/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.internal.protobuf;

import com.android.tradefed.internal.protobuf.AllocatedBuffer;
import com.android.tradefed.internal.protobuf.CheckReturnValue;
import java.nio.ByteBuffer;

@CheckReturnValue
abstract class BufferAllocator {
    private static final BufferAllocator UNPOOLED = new BufferAllocator(){

        @Override
        public AllocatedBuffer allocateHeapBuffer(int capacity) {
            return AllocatedBuffer.wrap(new byte[capacity]);
        }

        @Override
        public AllocatedBuffer allocateDirectBuffer(int capacity) {
            return AllocatedBuffer.wrap(ByteBuffer.allocateDirect(capacity));
        }
    };

    BufferAllocator() {
    }

    public static BufferAllocator unpooled() {
        return UNPOOLED;
    }

    public abstract AllocatedBuffer allocateHeapBuffer(int var1);

    public abstract AllocatedBuffer allocateDirectBuffer(int var1);
}

