/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceRuntimeException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@OptionClass(alias="atrace")
public class AtraceCollector
extends BaseDeviceMetricCollector {
    @Option(name="categories", description="the tracing categories atrace will capture")
    private List<String> mCategories = new ArrayList<String>();
    @Option(name="log-path", description="the temporary location the trace log will be saved to on device")
    private String mLogPath = "/data/local/tmp/";
    @Option(name="log-filename", description="the temporary location the trace log will be saved to on device")
    private String mLogFilename = "atrace";
    @Option(name="preserve-ondevice-log", description="delete the trace log on the target device after the host collects it")
    private boolean mPreserveOndeviceLog = false;
    @Option(name="compress-dump", description="produce a compressed trace dump")
    private boolean mCompressDump = true;
    @Option(name="atrace-on-boot", description="enable atrace collection for bootup")
    private boolean mTraceOnBoot = false;
    @Option(name="skip-atrace-start", description="Skip atrace start if the option is enabled. Needed when atrace isenabled through fastboot option.")
    private boolean mSkipAtraceStart = false;
    @Option(name="post-process-input-file-key", description="The string that will be replaced with the absolute path to the trace file in post-process-args")
    private String mLogProcessingTraceInput = "TRACE_FILE";
    @Option(name="post-process-binary", description="a self-contained binary that will be executed on the trace file")
    private File mLogProcessingBinary = null;
    @Option(name="post-process-args", description="args for the binary")
    private List<String> mLogProcessingArgs = new ArrayList<String>();
    @Option(name="post-process-timeout", isTimeVal=true, description="The amount of time (eg, 1m2s) that Tradefed will wait for the postprocessing subprocess to finish")
    private long mLogProcessingTimeoutMilliseconds = 0L;
    @Option(name="post-process-output-file-regex", description="A regex that will be applied to the stdout of the post processing program.the first matching group will be treated as a file and uploaded as a test log.")
    private List<String> mLogProcessingOutputRegex = new ArrayList<String>();
    private IRunUtil mRunUtil = RunUtil.getDefault();
    private Thread mThread;
    private static final long DEVICE_OFFLINE_TIMEOUT_MS = 60000L;
    private static final long DEVICE_ONLINE_TIMEOUT_MS = 60000L;

    protected String fullLogPath() {
        return Paths.get(this.mLogPath, this.mLogFilename + "." + this.getLogType().getFileExt()).toString();
    }

    protected LogDataType getLogType() {
        if (this.mCompressDump) {
            return LogDataType.ATRACE;
        }
        return LogDataType.TEXT;
    }

    protected void startTracing(ITestDevice device) throws DeviceNotAvailableException {
        String cmd = "atrace --async_start ";
        if (this.mCompressDump) {
            cmd = cmd + "-z ";
        }
        cmd = cmd + String.join((CharSequence)" ", this.mCategories);
        CollectingOutputReceiver c = new CollectingOutputReceiver();
        LogUtil.CLog.i((String)"issuing command : %s to device: %s", (Object[])new Object[]{cmd, device.getSerialNumber()});
        device.executeShellCommand(cmd, (IShellOutputReceiver)c, 1L, TimeUnit.SECONDS, 1);
        LogUtil.CLog.i((String)"command output: %s", (Object[])new Object[]{c.getOutput()});
    }

    public void onTestStart(DeviceMetricData testData) throws DeviceNotAvailableException {
        if (this.mSkipAtraceStart) {
            LogUtil.CLog.d((String)"Skip atrace start because tracing is enabled through fastboot option");
            return;
        }
        if (this.mCategories.isEmpty()) {
            LogUtil.CLog.d((String)"no categories specified to trace, not running AtraceMetricCollector");
            return;
        }
        if (this.mTraceOnBoot) {
            this.mThread = new Thread(() -> {
                try {
                    for (ITestDevice device : this.getDevices()) {
                        device.waitForDeviceNotAvailable(60000L);
                        device.waitForDeviceOnline(60000L);
                        device.waitForDeviceNotAvailable(60000L);
                        device.waitForDeviceOnline();
                        this.startTracing(device);
                    }
                }
                catch (DeviceNotAvailableException e) {
                    LogUtil.CLog.e((String)"Error starting atrace");
                    LogUtil.CLog.e((Throwable)e);
                }
            });
            this.mThread.setDaemon(true);
            this.mThread.setName("AtraceCollector-on-boot");
            this.mThread.start();
        } else {
            for (ITestDevice device : this.getDevices()) {
                this.startTracing(device);
            }
        }
    }

    protected void stopTracing(ITestDevice device) throws DeviceNotAvailableException {
        LogUtil.CLog.i((String)"collecting atrace log from device: %s", (Object[])new Object[]{device.getSerialNumber()});
        device.executeShellCommand("atrace --async_stop -z -c -o " + this.fullLogPath(), (IShellOutputReceiver)new NullOutputReceiver(), 300L, TimeUnit.SECONDS, 1);
        LogUtil.CLog.d((String)"Trace collected successfully.");
    }

    private void postProcess(File trace) {
        if (this.mLogProcessingBinary == null || !this.mLogProcessingBinary.exists() || !this.mLogProcessingBinary.canExecute()) {
            LogUtil.CLog.w((String)"No trace postprocessor specified. Skipping trace postprocessing.");
            return;
        }
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.mLogProcessingBinary.getAbsolutePath());
        for (String entry : this.mLogProcessingArgs) {
            commandLine.add(entry.replaceAll(this.mLogProcessingTraceInput, trace.getAbsolutePath()));
        }
        String[] commandLineArr = new String[commandLine.size()];
        commandLine.toArray(commandLineArr);
        CommandResult result = this.mRunUtil.runTimedCmd(this.mLogProcessingTimeoutMilliseconds, commandLineArr);
        LogUtil.CLog.v((String)"Trace postprocessing status: %s\nstdout: %s\nstderr: ", (Object[])new Object[]{result.getStatus(), result.getStdout(), result.getStderr()});
        if (result.getStdout() == null) {
            return;
        }
        for (String regex : this.mLogProcessingOutputRegex) {
            Pattern pattern = Pattern.compile(regex);
            for (String line : result.getStdout().split("\n")) {
                LogDataType type;
                File f;
                Matcher m = pattern.matcher(line);
                if (!m.find() || m.groupCount() != 1 || !(f = new File(m.group(1))).exists() || f.isDirectory()) continue;
                switch (FileUtil.getExtension((String)f.getName())) {
                    case ".png": {
                        type = LogDataType.PNG;
                        break;
                    }
                    case ".txt": {
                        type = LogDataType.TEXT;
                        break;
                    }
                    default: {
                        type = LogDataType.UNKNOWN;
                    }
                }
                try (FileInputStreamSource stream = new FileInputStreamSource(f);){
                    this.testLog(FileUtil.getBaseName((String)f.getName()), type, (InputStreamSource)stream);
                }
            }
        }
    }

    public void onTestEnd(DeviceMetricData testData, Map<String, MetricMeasurement.Metric> currentTestCaseMetrics, TestDescription test) throws DeviceNotAvailableException {
        if (!this.mSkipAtraceStart && this.mCategories.isEmpty()) {
            return;
        }
        for (ITestDevice device : this.getDevices()) {
            try {
                this.stopTracing(device);
                File trace = device.pullFile(this.fullLogPath());
                if (trace != null) {
                    LogUtil.CLog.i((String)"Log size: %s bytes", (Object[])new Object[]{String.valueOf(trace.length())});
                    try (FileInputStreamSource streamSource = new FileInputStreamSource(trace);){
                        this.testLog(this.mLogFilename + "_" + test + device.getSerialNumber() + "_", this.getLogType(), (InputStreamSource)streamSource);
                    }
                } else {
                    throw new DeviceRuntimeException(String.format("failed to pull log: %s", this.fullLogPath()), (ErrorIdentifier)DeviceErrorIdentifier.FAIL_PULL_FILE);
                }
                this.postProcess(trace);
                trace.delete();
                if (!this.mPreserveOndeviceLog) {
                    device.deleteFile(this.fullLogPath());
                    continue;
                }
                LogUtil.CLog.w((String)"preserving ondevice atrace log: %s", (Object[])new Object[]{this.fullLogPath()});
            }
            catch (DeviceRuntimeException e) {
                LogUtil.CLog.e((String)"Error retrieving atrace log! device not available:");
                LogUtil.CLog.e((Throwable)e);
            }
        }
    }

    @VisibleForTesting
    void setRunUtil(IRunUtil util) {
        this.mRunUtil = util;
    }
}

