/*
 * Decompiled with CFR 0.152.
 */
package android.host.test.composer;

import android.host.test.composer.Compose;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public abstract class ShuffleBase<T, U>
implements Compose<T, U> {
    protected static final String SEED_OPTION_NAME = "seed";
    protected static final String SHUFFLE_OPTION_NAME = "shuffle";
    private static final boolean SHUFFLE_DEFAULT_VALUE = false;
    protected final boolean mShuffleDefaultValue;

    public ShuffleBase() {
        this(false);
    }

    public ShuffleBase(boolean shuffleDefaultValue) {
        this.mShuffleDefaultValue = shuffleDefaultValue;
    }

    @Override
    public List<U> apply(T args, List<U> input) {
        boolean shuffle = this.getShuffleArgument(args);
        if (shuffle) {
            long seed = this.getSeedArgument(args);
            Collections.shuffle(input, new Random(seed));
        }
        return input;
    }

    protected abstract boolean getShuffleArgument(T var1);

    protected abstract long getSeedArgument(T var1);
}

