/*
 * Decompiled with CFR 0.152.
 */
package android.host.test.composer;

import android.host.test.composer.Compose;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class IterateBase<T, U>
implements Compose<T, U> {
    protected static final String ITERATIONS_OPTION_NAME = "iterations";
    protected static final int ITERATIONS_DEFAULT_VALUE = 1;
    protected static final String ORDER_OPTION_NAME = "order";
    protected static final OrderOptions ORDER_DEFAULT_VALUE = OrderOptions.CYCLIC;
    protected final int mDefaultValue;
    protected String mOptionName = "iterations";

    public IterateBase() {
        this(1);
    }

    public IterateBase(int defaultIterations) {
        this.mDefaultValue = defaultIterations;
    }

    @Override
    public List<U> apply(T args, List<U> input) {
        int iterations = this.getIterationsArgument(args);
        OrderOptions order = this.getOrdersArgument(args);
        switch (order) {
            case CYCLIC: {
                return Collections.nCopies(iterations, input).stream().flatMap(Collection::stream).collect(Collectors.toList());
            }
            case SEQUENTIAL: {
                return input.stream().map(u -> Collections.nCopies(iterations, u)).flatMap(Collection::stream).collect(Collectors.toList());
            }
        }
        throw new AssertionError((Object)String.format("Order option \"%s\" is not supported", new Object[]{order}));
    }

    protected abstract int getIterationsArgument(T var1);

    protected abstract OrderOptions getOrdersArgument(T var1);

    protected String getOptionName() {
        return this.mOptionName;
    }

    public void setOptionName(String name) {
        this.mOptionName = name;
    }

    protected static enum OrderOptions {
        CYCLIC,
        SEQUENTIAL;

    }
}

