# Draw samples from the distribution

loc, scale = 0., 1.
s = np.random.laplace(loc, scale, 1000)

# Display the histogram of the samples, along with
# the probability density function:

import matplotlib.pyplot as plt
count, bins, ignored = plt.hist(s, 30, normed=True)
x = np.arange(-8., 8., .01)
pdf = np.exp(-abs(x-loc)/scale)/(2.*scale)
plt.plot(x, pdf)

# Plot Gaussian for comparison:

g = (1/(scale * np.sqrt(2 * np.pi)) * 
     np.exp(-(x - loc)**2 / (2 * scale**2)))
plt.plot(x,g)
