(function (root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(function () {
      return (root.cv = factory());
    });
  } else if (typeof module === 'object' && module.exports) {
    // Node. Does not work with strict CommonJS, but
    // only CommonJS-like environments that support module.exports,
    // like Node.
    module.exports = factory();
  } else {
    // Browser globals
    root.cv = factory();
  }
}(this, function () {
  var cv = function(cv) {
  cv = cv || {};
  var Module = cv;

var Module;if(!Module)Module=(typeof cv!=="undefined"?cv:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;if(Module["ENVIRONMENT"]){if(Module["ENVIRONMENT"]==="WEB"){ENVIRONMENT_IS_WEB=true}else if(Module["ENVIRONMENT"]==="WORKER"){ENVIRONMENT_IS_WORKER=true}else if(Module["ENVIRONMENT"]==="NODE"){ENVIRONMENT_IS_NODE=true}else if(Module["ENVIRONMENT"]==="SHELL"){ENVIRONMENT_IS_SHELL=true}else{throw new Error("The provided Module['ENVIRONMENT'] value is not valid. It must be one of: WEB|WORKER|NODE|SHELL.")}}else{ENVIRONMENT_IS_WEB=typeof window==="object";ENVIRONMENT_IS_WORKER=typeof importScripts==="function";ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER}if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=console.log;if(!Module["printErr"])Module["printErr"]=console.warn;var nodeFS;var nodePath;Module["read"]=function shell_read(filename,binary){if(!nodeFS)nodeFS=require("fs");if(!nodePath)nodePath=require("path");filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);return binary?ret:ret.toString()};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function shell_read(){throw"no read() available"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof quit==="function"){Module["quit"]=(function(status,toThrow){quit(status)})}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function shell_read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(ENVIRONMENT_IS_WORKER){Module["readBinary"]=function readBinary(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(xhr.response)}}Module["readAsync"]=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function shell_print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function shell_printErr(x){console.warn(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}if(!Module["quit"]){Module["quit"]=(function(status,toThrow){throw toThrow})}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=undefined;var Runtime={setTempRet0:(function(value){tempRet0=value;return value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){return Module["dynCall_"+sig].apply(null,[ptr].concat(args))}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){if(sig.length===1){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func)}}else if(sig.length===2){sigCache[func]=function dynCall_wrapper(arg){return Runtime.dynCall(sig,func,[arg])}}else{sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,Array.prototype.slice.call(arguments))}}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=HEAP32[DYNAMICTOP_PTR>>2];var end=(ret+size+15|0)&-16;HEAP32[DYNAMICTOP_PTR>>2]=end;if(end>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){HEAP32[DYNAMICTOP_PTR>>2]=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var ABORT=0;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){var len=(str.length<<2)+1;ret=Runtime.stackAlloc(len);stringToUTF8(str,ret,len)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};var sourceRegex=/^function\s*[a-zA-Z$_0-9]*\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource=null;function ensureJSsource(){if(!JSsource){JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){ensureJSsource();funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"=("+convertCode.returnValue+");"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){ensureJSsource();funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[typeof _malloc==="function"?_malloc:Runtime.staticAlloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;var UTF8Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf8"):undefined;function UTF8ArrayToString(u8Array,idx){var endPtr=idx;while(u8Array[endPtr])++endPtr;if(endPtr-idx>16&&u8Array.subarray&&UTF8Decoder){return UTF8Decoder.decode(u8Array.subarray(idx,endPtr))}else{var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;var UTF16Decoder=typeof TextDecoder!=="undefined"?new TextDecoder("utf-16le"):undefined;function demangle(func){var __cxa_demangle_func=Module["___cxa_demangle"]||Module["__cxa_demangle"];if(__cxa_demangle_func){try{var s=func.substr(1);var len=lengthBytesUTF8(s)+1;var buf=_malloc(len);stringToUTF8(s,buf,len);var status=_malloc(4);var ret=__cxa_demangle_func(buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}return func}Runtime.warnOnce("warning: build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling");return func}function demangleAll(text){var regex=/__Z[\w\d_]+/g;return text.replace(regex,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){var js=jsStackTrace();if(Module["extraStackTrace"])js+="\n"+Module["extraStackTrace"]();return demangleAll(js)}Module["stackTrace"]=stackTrace;var WASM_PAGE_SIZE=65536;var ASMJS_PAGE_SIZE=16777216;var MIN_TOTAL_MEMORY=16777216;function alignUp(x,multiple){if(x%multiple>0){x+=multiple-x%multiple}return x}var HEAP,buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBuffer(buf){Module["buffer"]=buffer=buf}function updateGlobalBufferViews(){Module["HEAP8"]=HEAP8=new Int8Array(buffer);Module["HEAP16"]=HEAP16=new Int16Array(buffer);Module["HEAP32"]=HEAP32=new Int32Array(buffer);Module["HEAPU8"]=HEAPU8=new Uint8Array(buffer);Module["HEAPU16"]=HEAPU16=new Uint16Array(buffer);Module["HEAPU32"]=HEAPU32=new Uint32Array(buffer);Module["HEAPF32"]=HEAPF32=new Float32Array(buffer);Module["HEAPF64"]=HEAPF64=new Float64Array(buffer)}var STATIC_BASE,STATICTOP,staticSealed;var STACK_BASE,STACKTOP,STACK_MAX;var DYNAMIC_BASE,DYNAMICTOP_PTR;STATIC_BASE=STATICTOP=STACK_BASE=STACKTOP=STACK_MAX=DYNAMIC_BASE=DYNAMICTOP_PTR=0;staticSealed=false;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which allows increasing the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or (4) if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}if(!Module["reallocBuffer"])Module["reallocBuffer"]=(function(size){var ret;try{if(ArrayBuffer.transfer){ret=ArrayBuffer.transfer(buffer,size)}else{var oldHEAP8=HEAP8;ret=new ArrayBuffer(size);var temp=new Int8Array(ret);temp.set(oldHEAP8)}}catch(e){return false}var success=_emscripten_replace_memory(ret);if(!success)return false;return ret});function enlargeMemory(){var PAGE_MULTIPLE=Module["usingWasm"]?WASM_PAGE_SIZE:ASMJS_PAGE_SIZE;var LIMIT=2147483648-PAGE_MULTIPLE;if(HEAP32[DYNAMICTOP_PTR>>2]>LIMIT){return false}var OLD_TOTAL_MEMORY=TOTAL_MEMORY;TOTAL_MEMORY=Math.max(TOTAL_MEMORY,MIN_TOTAL_MEMORY);while(TOTAL_MEMORY<HEAP32[DYNAMICTOP_PTR>>2]){if(TOTAL_MEMORY<=536870912){TOTAL_MEMORY=alignUp(2*TOTAL_MEMORY,PAGE_MULTIPLE)}else{TOTAL_MEMORY=Math.min(alignUp((3*TOTAL_MEMORY+2147483648)/4,PAGE_MULTIPLE),LIMIT)}}var replacement=Module["reallocBuffer"](TOTAL_MEMORY);if(!replacement||replacement.byteLength!=TOTAL_MEMORY){TOTAL_MEMORY=OLD_TOTAL_MEMORY;return false}updateGlobalBuffer(replacement);updateGlobalBufferViews();return true}var byteLength;try{byteLength=Function.prototype.call.bind(Object.getOwnPropertyDescriptor(ArrayBuffer.prototype,"byteLength").get);byteLength(new ArrayBuffer(4))}catch(e){byteLength=(function(buffer){return buffer.byteLength})}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||134217728;if(TOTAL_MEMORY<TOTAL_STACK)Module.printErr("TOTAL_MEMORY should be larger than TOTAL_STACK, was "+TOTAL_MEMORY+"! (TOTAL_STACK="+TOTAL_STACK+")");if(Module["buffer"]){buffer=Module["buffer"]}else{{buffer=new ArrayBuffer(TOTAL_MEMORY)}}updateGlobalBufferViews();function getTotalMemory(){return TOTAL_MEMORY}HEAP32[0]=1668509029;HEAP16[1]=25459;if(HEAPU8[2]!==115||HEAPU8[3]!==99)throw"Runtime error: expected the system to be little-endian!";Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Module["dynCall_v"](func)}else{Module["dynCall_vi"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){Runtime.warnOnce("writeStringToMemory is deprecated and should not be called! Use stringToUTF8() instead!");var lastChar,end;if(dontAddNull){end=buffer+lengthBytesUTF8(string);lastChar=HEAP8[end]}stringToUTF8(string,buffer,Infinity);if(dontAddNull)HEAP8[end]=lastChar}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){HEAP8.set(array,buffer)}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];if(!Math["trunc"])Math["trunc"]=(function(x){return x<0?Math.ceil(x):Math.floor(x)});Math.trunc=Math["trunc"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_round=Math.round;var Math_min=Math.min;var Math_clz32=Math.clz32;var Math_trunc=Math.trunc;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var ASM_CONSTS=[];STATIC_BASE=Runtime.GLOBAL_BASE;STATICTOP=STATIC_BASE+1161664;__ATINIT__.push({func:(function(){__GLOBAL__I_000101()})},{func:(function(){__GLOBAL__sub_I_graph_pb_cc()})},{func:(function(){__GLOBAL__sub_I_iostream_cpp()})},{func:(function(){__GLOBAL__sub_I_bind_cpp()})},{func:(function(){__GLOBAL__sub_I_message_cc()})},{func:(function(){__GLOBAL__sub_I_descriptor_pb_cc()})},{func:(function(){__GLOBAL__sub_I_status_cc()})},{func:(function(){__GLOBAL__sub_I_versions_pb_cc()})},{func:(function(){__GLOBAL__sub_I_op_def_pb_cc()})},{func:(function(){__GLOBAL__sub_I_function_pb_cc()})},{func:(function(){__GLOBAL__sub_I_detection_output_layer_cpp()})},{func:(function(){__GLOBAL__sub_I_prior_box_layer_cpp()})},{func:(function(){__GLOBAL__sub_I_darknet_io_cpp()})},{func:(function(){__GLOBAL__sub_I_opencv_caffe_pb_cc()})},{func:(function(){__GLOBAL__sub_I_tensor_shape_pb_cc()})},{func:(function(){__GLOBAL__sub_I_bindings_cpp()})},{func:(function(){__GLOBAL__sub_I_tensor_pb_cc()})},{func:(function(){__GLOBAL__sub_I_types_pb_cc()})},{func:(function(){__GLOBAL__sub_I_attr_value_pb_cc()})},{func:(function(){__GLOBAL__sub_I_init_cpp()})},{func:(function(){__GLOBAL__sub_I_dnn_cpp()})},{func:(function(){__GLOBAL__sub_I_haar_cpp()})},{func:(function(){__GLOBAL__sub_I_hog_cpp()})},{func:(function(){__GLOBAL__sub_I_color_lab_cpp()})},{func:(function(){__GLOBAL__sub_I_histogram_cpp()})},{func:(function(){__GLOBAL__sub_I_imgwarp_cpp()})},{func:(function(){__GLOBAL__sub_I_persistence_types_cpp()})},{func:(function(){__GLOBAL__sub_I_umatrix_cpp()})},{func:(function(){__GLOBAL__sub_I_kmeans_cpp()})},{func:(function(){__GLOBAL__sub_I_system_cpp()})});allocate([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,244,70,62,15,206,131,63,71,85,215,212,68,5,132,63,150,24,1,83,20,61,132,63,240,209,204,101,127,117,132,63,186,20,239,190,135,174,132,63,248,121,213,20,47,232,132,63,157,202,179,34,119,34,133,63,157,78,145,168,97,93,133,63,12,65,86,107,240,152,133,63,195,105,217,52,37,213,133,63,241,220,237,211,1,18,134,63,251,224,112,28,136,79,134,63,26,251,87,231,185,141,134,63,41,35,191,18,153,204,134,63,3,31,247,129,39,12,135,63,238,5,148,29,103,76,135,63,113,236,123,211,89,141,135,63,28,185,245,150,1,207,135,63,164,34,184,96,96,17,136,63,192,215,248,46,120,84,136,63,87,209,123,5,75,152,136,63,90,207,162,237,218,220,136,63,197,0,125,246,41,34,137,63,87,215,214,52,58,104,137,63,85,7,74,195,13,175,137,63,241,179,77,194,166,246,137,63,199,200,70,88,7,63,138,63,236,128,152,177,49,136,138,63,15,28,181,0,40,210,138,63,43,194,46,126,236,28,139,63,87,150,200,104,129,104,139,63,34,249,135,5,233,180,139,63,22,251,197,159,37,2,140,63,215,255,64,137,57,80,140,63,117,146,46,26,39,159,140,63,103,107,77,177,240,238,140,63,204,168,247,179,152,63,141,63,114,57,53,142,33,145,141,63,62,123,206,178,141,227,141,63,105,13,95,155,223,54,142,63,71,215,104,200,25,139,142,63,18,68,103,193,62,224,142,63,77,180,226,20,81,54,143,63,95,37,132,88,83,141,143,63,249,15,41,41,72,229,143,63,242,190,123,21,25,31,144,63,223,43,185,4,10,76,144,63,173,245,198,59,120,121,144,63,177,85,226,23,101,167,144,63,92,20,22,250,209,213,144,63,48,35,69,71,192,4,145,63,65,84,53,104,49,52,145,63,151,47,154,201,38,100,145,63,190,230,31,220,161,148,145,63,229,102,118,20,164,197,145,63,208,137,92,235,46,247,145,63,8,102,171,221,67,41,146,63,142,190,97,108,228,91,146,63,109,146,175,28,18,143,146,63,136,204,1,120,206,194,146,63,5,20,14,12,27,247,146,63,151,189,222,106,249,43,147,63,33,222,222,42,107,97,147,63,249,126,230,230,113,151,147,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,192,11,177,162,10,240,111,63,32,224,31,224,31,224,239,63,136,103,16,107,42,224,127,63,240,7,252,1,127,192,239,63,118,10,129,95,71,220,135,63,18,250,1,170,28,161,239,63,227,3,252,176,168,192,143,63,32,248,129,31,248,129,239,63,116,165,70,67,164,206,147,63,181,219,160,172,16,99,239,63,26,177,213,7,27,185,151,63,113,66,74,158,101,68,239,63,151,145,175,39,192,159,155,63,181,10,35,68,246,37,239,63,0,51,120,14,155,130,159,63,8,31,124,240,193,7,239,63,127,217,35,137,217,176,161,63,2,142,69,248,199,233,238,63,95,189,254,185,135,158,163,63,192,236,1,179,7,204,238,63,212,228,200,175,91,138,165,63,235,1,186,122,128,174,238,63,252,220,50,246,88,116,167,63,103,183,240,171,49,145,238,63,235,227,200,14,131,92,169,63,228,80,151,165,26,116,238,63,190,113,25,113,221,66,171,63,116,229,1,201,58,87,238,63,82,11,219,138,107,39,173,63,115,26,220,121,145,58,238,63,166,98,17,192,48,10,175,63,30,30,30,30,30,30,238,63,113,228,152,53,152,117,176,63,30,224,1,30,224,1,238,63,224,122,163,238,54,101,177,63,138,134,248,227,214,229,237,63,22,20,10,47,246,83,178,63,202,29,160,220,1,202,237,63,208,209,27,150,215,65,179,63,219,129,185,118,96,174,237,63,240,70,166,190,220,46,180,63,138,127,30,35,242,146,237,63,63,24,6,63,7,27,181,63,52,44,184,84,182,119,237,63,195,80,55,169,88,6,182,63,178,114,117,128,172,92,237,63,75,107,229,138,210,240,182,63,29,212,65,29,212,65,237,63,204,18,123,109,118,218,183,63,26,91,252,163,44,39,237,63,32,155,49,214,69,195,184,63,116,192,110,143,181,12,237,63,172,51,32,70,66,171,185,63,198,191,68,92,110,242,236,63,99,213,74,58,109,146,186,63,11,155,3,137,86,216,236,63,161,237,176,43,200,120,187,63,231,203,1,150,109,190,236,63,67,199,91,143,84,94,188,63,145,225,94,5,179,164,236,63,93,179,108,214,19,67,189,63,66,138,251,90,38,139,236,63,229,242,42,110,7,39,190,63,28,199,113,28,199,113,236,63,166,98,17,192,48,10,191,63,134,73,13,209,148,88,236,63,186,234,219,49,145,236,191,63,240,248,195,1,143,63,236,63,110,89,202,18,21,103,192,63,28,160,46,57,181,38,236,63,89,142,208,124,126,215,192,63,224,192,129,3,7,14,236,63,172,66,103,132,133,71,193,63,139,141,134,238,131,245,235,63,160,103,47,213,42,183,193,63,247,6,148,137,43,221,235,63,203,90,10,25,111,38,194,63,123,62,136,101,253,196,235,63,35,245,31,248,82,149,194,63,208,186,193,20,249,172,235,63,210,127,228,24,215,3,195,63,35,255,24,43,30,149,235,63,116,143,30,32,252,113,195,63,139,51,218,61,108,125,235,63,41,198,236,176,194,223,195,63,5,238,190,227,226,101,235,63,30,125,203,108,43,77,196,63,79,27,232,180,129,78,235,63,229,85,154,243,54,186,196,63,206,6,216,74,72,55,235,63,55,180,161,227,229,38,197,63,217,128,108,64,54,32,235,63,133,32,152,217,56,147,197,63,164,34,217,49,75,9,235,63,211,147,167,112,48,255,197,63,40,175,161,188,134,242,234,63,80,173,114,66,205,106,198,63,94,144,148,127,232,219,234,63,28,210,25,231,15,214,198,63,27,112,197,26,112,197,234,63,164,55,64,245,248,64,199,63,253,235,135,47,29,175,234,63,9,217,16,2,137,171,199,63,190,99,106,96,239,152,234,63,234,87,67,161,192,21,200,63,89,225,48,81,230,130,234,63,16,201,32,101,160,127,200,63,109,26,208,166,1,109,234,63,64,109,136,222,40,233,200,63,74,138,104,7,65,87,234,63,180,86,244,156,90,82,201,63,26,164,65,26,164,65,234,63,131,251,125,46,54,187,201,63,160,28,197,135,42,44,234,63,99,181,226,31,188,35,202,63,2,75,122,249,211,22,234,63,24,47,136,252,236,139,202,63,26,160,1,26,160,1,234,63,242,191,128,78,201,243,202,63,217,51,16,149,142,236,233,63,164,181,143,158,81,91,203,63,45,104,107,23,159,215,233,63,214,140,45,116,134,194,203,63,2,161,228,78,209,194,233,63,192,24,140,85,104,41,204,63,218,16,85,234,36,174,233,63,33,154,154,199,247,143,204,63,154,153,153,153,153,153,233,63,220,197,9,78,53,246,204,63,255,192,142,13,47,133,233,63,145,187,79,107,33,92,205,63,114,184,12,248,228,112,233,63,125,236,171,160,188,193,205,63,174,119,227,11,187,92,233,63,229,242,42,110,7,39,206,63,224,233,214,252,176,72,233,63,95,90,170,82,2,140,206,63,230,44,155,127,198,52,233,63,54,89,220,203,173,240,206,63,41,226,208,73,251,32,233,63,55,123,75,86,10,85,207,63,213,144,1,18,79,13,233,63,42,62,94,109,24,185,207,63,250,24,156,143,193,249,232,63,28,80,173,69,108,14,208,63,63,55,241,122,82,230,232,63,64,208,180,148,37,64,208,63,211,24,48,141,1,211,232,63,13,89,205,95,184,113,208,63,58,255,98,128,206,191,232,63,227,144,115,226,36,163,208,63,170,243,107,15,185,172,232,63,75,183,154,87,107,212,208,63,156,137,1,246,192,153,232,63,213,74,174,249,139,5,209,63,74,176,171,240,229,134,232,63,176,168,147,2,135,54,209,63,185,146,192,188,39,116,232,63,14,166,171,171,92,103,209,63,24,134,97,24,134,97,232,63,111,35,212,45,13,152,209,63,20,6,120,194,0,79,232,63,250,153,105,193,152,200,209,63,221,190,178,122,151,60,232,63,242,162,72,158,255,248,209,63,160,164,130,1,74,42,232,63,101,121,207,251,65,41,210,63,24,24,24,24,24,24,232,63,57,118,223,16,96,89,210,63,6,24,96,128,1,6,232,63,163,134,222,19,90,137,210,63,64,127,1,253,5,244,231,63,36,157,184,58,48,185,210,63,29,79,90,81,37,226,231,63,48,29,225,186,226,232,210,63,244,5,125,65,95,208,231,63,132,65,84,201,113,24,211,63,124,1,46,146,179,190,231,63,84,125,152,154,221,71,211,63,195,236,224,8,34,173,231,63,90,216,191,98,38,119,211,63,139,57,182,107,170,155,231,63,233,69,105,85,76,166,211,63,200,164,120,129,76,138,231,63,15,247,193,165,79,213,211,63,13,198,154,17,8,121,231,63,227,167,134,134,48,4,212,63,177,169,52,228,220,103,231,63,19,232,4,42,239,50,212,63,109,117,1,194,202,86,231,63,194,94,28,194,139,97,212,63,70,23,93,116,209,69,231,63,208,9,64,128,6,144,212,63,141,254,65,197,240,52,231,63,160,120,119,149,95,190,212,63,188,222,70,127,40,36,231,63,105,2,96,50,151,236,212,63,9,124,156,109,120,19,231,63,45,248,45,135,173,26,213,63,112,129,11,92,224,2,231,63,98,210,173,195,162,72,213,63,23,96,242,22,96,242,230,63,108,90,69,23,119,118,213,63,199,55,67,107,247,225,230,63,225,207,244,176,42,164,213,63,97,200,129,38,166,209,230,63,202,9,88,191,189,209,213,63,23,108,193,22,108,193,230,63,211,147,167,112,48,255,213,63,61,26,163,10,73,177,230,63,149,199,185,242,130,44,214,63,144,114,83,209,60,161,230,63,242,225,3,115,181,89,214,63,192,208,136,58,71,145,230,63,174,20,155,30,200,134,214,63,23,104,129,22,104,129,230,63,61,148,53,34,187,179,214,63,26,103,1,54,159,113,230,63,227,161,43,170,142,224,214,63,249,34,81,106,236,97,230,63,53,146,120,226,66,13,215,63,163,74,59,133,79,82,230,63,6,208,187,246,215,57,215,63,100,33,11,89,200,66,230,63,206,219,57,18,78,102,215,63,222,192,138,184,86,51,230,63,162,71,221,95,165,146,215,63,64,98,1,119,250,35,230,63,191,175,55,10,222,190,215,63,148,174,49,104,179,20,230,63,195,175,130,59,248,234,215,63,6,22,88,96,129,5,230,63,149,212,160,29,244,22,216,63,252,45,41,52,100,246,229,63,23,139,30,218,209,66,216,63,231,21,208,184,91,231,229,63,160,11,51,154,145,110,216,63,165,226,236,195,103,216,229,63,90,66,193,134,51,154,216,63,87,16,147,43,136,201,229,63,138,180,88,200,183,197,216,63,145,250,71,198,188,186,229,63,199,98,54,135,30,241,216,63,192,90,1,107,5,172,229,63,61,168,69,235,103,28,217,63,170,204,35,241,97,157,229,63,250,22,33,28,148,71,217,63,237,88,129,48,210,142,229,63,88,81,19,65,163,114,217,63,96,5,88,1,86,128,229,63,138,224,23,129,149,157,217,63,58,107,80,60,237,113,229,63,98,8,220,2,107,200,217,63,226,82,124,186,151,99,229,63,75,152,191,236,35,243,217,63,85,85,85,85,85,85,229,63,149,185,213,100,192,29,218,63,254,130,187,230,37,71,229,63,10,187,229,144,64,72,218,63,235,15,244,72,9,57,229,63,234,217,107,150,164,114,218,63,75,5,168,86,255,42,229,63,73,8,154,154,236,156,218,63,21,248,226,234,7,29,229,63,228,176,88,194,24,199,218,63,197,196,17,225,34,15,229,63,107,120,71,50,41,241,218,63,21,80,1,21,80,1,229,63,91,252,189,14,30,27,219,63,155,76,221,98,143,243,228,63,98,143,204,123,247,68,219,63,57,5,47,167,224,229,228,63,93,243,60,157,181,110,219,63,76,44,220,190,67,216,228,63,251,16,147,150,88,152,219,63,110,175,37,135,184,202,228,63,10,173,13,139,224,193,219,63,225,143,166,221,62,189,228,63,123,27,167,157,77,235,219,63,91,191,82,160,214,175,228,63,38,240,21,241,159,20,220,63,74,1,118,173,127,162,228,63,77,173,205,167,215,61,220,63,103,208,178,227,57,149,228,63,247,111,255,227,244,102,220,63,128,72,1,34,5,136,228,63,33,154,154,199,247,143,220,63,123,20,174,71,225,122,228,63,201,122,77,116,224,184,220,63,102,96,89,52,206,109,228,63,235,243,133,11,175,225,220,63,154,207,245,199,203,96,228,63,100,30,114,174,99,10,221,63,202,118,199,226,217,83,228,63,213,235,0,126,254,50,221,63,251,217,98,101,248,70,228,63,131,198,226,154,127,91,221,63,77,238,171,48,39,58,228,63,62,47,138,37,231,131,221,63,135,31,213,37,102,45,228,63,84,89,44,62,53,172,221,63,81,89,94,38,181,32,228,63,160,196,193,4,106,212,221,63,20,20,20,20,20,20,228,63,181,213,6,153,133,252,221,63,102,101,14,209,130,7,228,63,38,108,124,26,136,36,222,63,251,19,176,63,1,251,227,63,4,119,104,168,113,76,222,63,7,175,165,66,143,238,227,63,135,135,214,97,66,116,222,63,2,169,228,188,44,226,227,63,245,97,152,101,250,155,222,63,198,117,170,145,217,213,227,63,192,140,70,210,153,195,222,63,231,171,123,164,149,201,227,63,244,221,64,198,32,235,222,63,85,41,35,217,96,189,227,63,236,6,175,95,143,18,223,63,20,59,177,19,59,177,227,63,91,30,129,188,229,57,223,63,34,200,122,56,36,165,227,63,172,40,112,250,35,97,223,63,99,127,24,44,28,153,227,63,194,158,254,54,74,136,223,63,142,8,102,211,34,141,227,63,30,243,120,143,88,175,223,63,20,56,129,19,56,129,227,63,113,21,246,32,79,214,223,63,238,69,201,209,91,117,227,63,152,244,87,8,46,253,223,63,72,7,222,243,141,105,227,63,138,255,37,177,250,17,224,63,248,42,159,95,206,93,227,63,254,208,165,165,82,37,224,63,193,120,43,251,28,82,227,63,59,99,206,239,158,56,224,63,70,19,224,172,121,70,227,63,210,38,169,157,223,75,224,63,178,188,87,91,228,58,227,63,156,69,38,189,20,95,224,63,250,29,106,237,92,47,227,63,64,223,28,92,62,114,224,63,191,16,43,74,227,35,227,63,14,69,75,136,92,133,224,63,182,235,233,88,119,24,227,63,32,53,87,79,111,152,224,63,144,209,48,1,25,13,227,63,209,20,206,190,118,171,224,63,96,2,196,42,200,1,227,63,130,42,37,228,114,190,224,63,104,47,161,189,132,246,226,63,183,214,185,204,99,209,224,63,75,209,254,161,78,235,226,63,139,204,209,133,73,228,224,63,151,128,75,192,37,224,226,63,125,73,155,28,36,247,224,63,160,80,45,1,10,213,226,63,150,76,45,158,243,9,225,63,160,44,129,77,251,201,226,63,248,204,135,23,184,28,225,63,17,55,90,142,249,190,226,63,188,239,147,149,113,47,225,63,64,43,1,173,4,180,226,63,68,61,36,37,32,66,225,63,5,193,243,146,28,169,226,63,233,213,244,210,195,84,225,63,158,18,228,41,65,158,226,63,14,166,171,171,92,103,225,63,165,4,184,91,114,147,226,63,160,153,216,187,234,121,225,63,19,176,136,18,176,136,226,63,6,207,245,15,110,140,225,63,77,206,161,56,250,125,226,63,110,201,103,180,230,158,225,63,53,39,129,184,80,115,226,63,158,162,125,181,84,177,225,63,39,1,214,124,179,104,226,63,36,60,113,31,184,195,225,63,241,146,128,112,34,94,226,63,3,112,103,254,16,214,225,63,178,119,145,126,157,83,226,63,208,64,112,94,95,232,225,63,146,36,73,146,36,73,226,63,76,9,135,75,163,250,225,63,91,96,23,151,183,62,226,63,109,171,146,209,220,12,226,63,223,188,154,120,86,52,226,63,235,190,101,252,11,31,226,63,42,18,160,34,1,42,226,63,66,191,190,215,48,49,226,63,120,251,33,129,183,31,226,63,51,57,72,111,75,67,226,63,230,85,72,128,121,21,226,63,203,247,152,206,91,85,226,63,217,192,103,12,71,11,226,63,223,48,52,1,98,103,226,63,18,32,1,18,32,1,226,63,26,177,137,18,94,121,226,63,112,31,193,125,4,247,225,63,130,7,246,13,80,139,226,63,76,184,127,60,244,236,225,63,138,176,194,254,55,157,226,63,116,184,63,59,239,226,225,63,173,64,38,240,21,175,226,63,189,74,46,103,245,216,225,63,139,142,68,237,233,192,226,63,29,129,162,173,6,207,225,63,157,220,46,1,180,210,226,63,89,224,28,252,34,197,225,63,104,2,228,54,116,228,226,63,41,237,70,64,74,187,225,63,70,149,80,153,42,246,226,63,227,186,242,103,124,177,225,63,190,16,79,51,215,7,227,63,150,123,26,97,185,167,225,63,106,254,167,15,122,25,227,63,158,17,224,25,1,158,225,63,113,29,18,57,19,43,227,63,156,162,140,128,83,148,225,63,148,137,50,186,162,60,227,63,219,43,144,131,176,138,225,63,211,225,156,157,40,78,227,63,18,24,129,17,24,129,225,63,160,110,211,237,164,95,227,63,132,214,27,25,138,119,225,63,181,71,71,181,23,113,227,63,121,115,66,137,6,110,225,63,126,121,88,254,128,130,227,63,1,50,252,80,141,100,225,63,25,42,86,211,224,147,227,63,13,39,117,95,30,91,225,63,249,189,126,62,55,165,227,63,201,213,253,163,185,81,225,63,34,252,255,73,132,182,227,63,59,205,10,14,95,72,225,63,5,50,247,255,199,199,227,63,36,71,52,141,14,63,225,63,250,86,113,106,2,217,227,63,17,200,53,17,200,53,225,63,91,47,107,147,51,234,227,63,172,192,237,137,139,44,225,63,66,111,209,132,91,251,227,63,51,48,93,231,88,35,225,63,233,220,128,72,122,12,228,63,38,72,167,25,48,26,225,63,174,114,70,232,143,29,228,63,17,17,17,17,17,17,225,63,191,128,223,109,156,46,228,63,128,16,1,190,251,7,225,63,103,206,249,226,159,63,228,63,17,240,254,16,240,254,224,63,10,187,51,81,154,80,228,63,162,37,179,250,237,245,224,63,194,94,28,194,139,97,228,63,144,156,230,107,245,236,224,63,173,170,51,63,116,114,228,63,17,96,130,85,6,228,224,63,223,136,234,209,83,131,228,63,150,70,143,168,32,219,224,63,7,252,162,131,42,148,228,63,58,158,53,86,68,210,224,63,187,62,176,93,248,164,228,63,59,218,188,79,113,201,224,63,115,226,86,105,189,181,228,63,113,65,139,134,167,192,224,63,57,238,204,175,121,198,228,63,200,157,37,236,230,183,224,63,0,253,57,58,45,215,228,63,181,236,46,114,47,175,224,63,176,91,183,17,216,231,228,63,167,16,104,10,129,166,224,63,232,38,80,63,122,248,228,63,96,131,175,166,219,157,224,63,107,104,1,204,19,9,229,63,84,9,1,57,63,149,224,63,70,52,186,192,164,25,229,63,226,101,117,179,171,140,224,63,170,197,91,38,45,42,229,63,132,16,66,8,33,132,224,63,124,155,185,5,173,58,229,63,226,234,184,41,159,123,224,63,151,148,153,103,36,75,229,63,198,247,71,10,38,115,224,63,205,11,180,84,147,91,229,63,251,18,121,156,181,106,224,63,153,243,179,213,249,107,229,63,252,169,241,210,77,98,224,63,144,241,54,243,87,124,229,63,134,117,114,160,238,89,224,63,137,121,205,181,173,140,229,63,4,52,215,247,151,81,224,63,125,232,250,37,251,156,229,63,197,100,22,204,73,73,224,63,44,159,53,76,64,173,229,63,16,4,65,16,4,65,224,63,115,28,231,48,125,189,229,63,252,71,130,183,198,56,224,63,100,23,108,220,177,205,229,63,26,94,31,181,145,48,224,63,35,153,20,87,222,221,229,63,233,41,119,252,100,40,224,63,117,22,36,169,2,238,229,63,8,4,2,129,64,32,224,63,24,137,209,218,30,254,229,63,55,122,81,54,36,24,224,63,216,136,71,244,50,14,230,63,16,16,16,16,16,16,224,63,239,57,250,254,66,46,230,63,0,0,0,0,0,0,224,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,192,11,177,162,10,240,111,63,32,224,31,224,31,224,239,63,136,103,16,107,42,224,127,63,240,7,252,1,127,192,239,63,118,10,129,95,71,220,135,63,18,250,1,170,28,161,239,63,227,3,252,176,168,192,143,63,32,248,129,31,248,129,239,63,116,165,70,67,164,206,147,63,181,219,160,172,16,99,239,63,26,177,213,7,27,185,151,63,113,66,74,158,101,68,239,63,151,145,175,39,192,159,155,63,181,10,35,68,246,37,239,63,0,51,120,14,155,130,159,63,8,31,124,240,193,7,239,63,127,217,35,137,217,176,161,63,2,142,69,248,199,233,238,63,95,189,254,185,135,158,163,63,192,236,1,179,7,204,238,63,212,228,200,175,91,138,165,63,235,1,186,122,128,174,238,63,252,220,50,246,88,116,167,63,103,183,240,171,49,145,238,63,235,227,200,14,131,92,169,63,228,80,151,165,26,116,238,63,190,113,25,113,221,66,171,63,116,229,1,201,58,87,238,63,82,11,219,138,107,39,173,63,115,26,220,121,145,58,238,63,166,98,17,192,48,10,175,63,30,30,30,30,30,30,238,63,113,228,152,53,152,117,176,63,30,224,1,30,224,1,238,63,224,122,163,238,54,101,177,63,138,134,248,227,214,229,237,63,22,20,10,47,246,83,178,63,202,29,160,220,1,202,237,63,208,209,27,150,215,65,179,63,219,129,185,118,96,174,237,63,240,70,166,190,220,46,180,63,138,127,30,35,242,146,237,63,63,24,6,63,7,27,181,63,52,44,184,84,182,119,237,63,195,80,55,169,88,6,182,63,178,114,117,128,172,92,237,63,75,107,229,138,210,240,182,63,29,212,65,29,212,65,237,63,204,18,123,109,118,218,183,63,26,91,252,163,44,39,237,63,32,155,49,214,69,195,184,63,116,192,110,143,181,12,237,63,172,51,32,70,66,171,185,63,198,191,68,92,110,242,236,63,99,213,74,58,109,146,186,63,11,155,3,137,86,216,236,63,161,237,176,43,200,120,187,63,231,203,1,150,109,190,236,63,67,199,91,143,84,94,188,63,145,225,94,5,179,164,236,63,93,179,108,214,19,67,189,63,66,138,251,90,38,139,236,63,229,242,42,110,7,39,190,63,28,199,113,28,199,113,236,63,166,98,17,192,48,10,191,63,134,73,13,209,148,88,236,63,186,234,219,49,145,236,191,63,240,248,195,1,143,63,236,63,110,89,202,18,21,103,192,63,28,160,46,57,181,38,236,63,89,142,208,124,126,215,192,63,224,192,129,3,7,14,236,63,172,66,103,132,133,71,193,63,139,141,134,238,131,245,235,63,160,103,47,213,42,183,193,63,247,6,148,137,43,221,235,63,203,90,10,25,111,38,194,63,123,62,136,101,253,196,235,63,35,245,31,248,82,149,194,63,208,186,193,20,249,172,235,63,210,127,228,24,215,3,195,63,35,255,24,43,30,149,235,63,116,143,30,32,252,113,195,63,139,51,218,61,108,125,235,63,41,198,236,176,194,223,195,63,5,238,190,227,226,101,235,63,30,125,203,108,43,77,196,63,79,27,232,180,129,78,235,63,229,85,154,243,54,186,196,63,206,6,216,74,72,55,235,63,55,180,161,227,229,38,197,63,217,128,108,64,54,32,235,63,133,32,152,217,56,147,197,63,164,34,217,49,75,9,235,63,211,147,167,112,48,255,197,63,40,175,161,188,134,242,234,63,80,173,114,66,205,106,198,63,94,144,148,127,232,219,234,63,28,210,25,231,15,214,198,63,27,112,197,26,112,197,234,63,164,55,64,245,248,64,199,63,253,235,135,47,29,175,234,63,9,217,16,2,137,171,199,63,190,99,106,96,239,152,234,63,234,87,67,161,192,21,200,63,89,225,48,81,230,130,234,63,16,201,32,101,160,127,200,63,109,26,208,166,1,109,234,63,64,109,136,222,40,233,200,63,74,138,104,7,65,87,234,63,180,86,244,156,90,82,201,63,26,164,65,26,164,65,234,63,131,251,125,46,54,187,201,63,160,28,197,135,42,44,234,63,99,181,226,31,188,35,202,63,2,75,122,249,211,22,234,63,24,47,136,252,236,139,202,63,26,160,1,26,160,1,234,63,242,191,128,78,201,243,202,63,217,51,16,149,142,236,233,63,164,181,143,158,81,91,203,63,45,104,107,23,159,215,233,63,214,140,45,116,134,194,203,63,2,161,228,78,209,194,233,63,192,24,140,85,104,41,204,63,218,16,85,234,36,174,233,63,33,154,154,199,247,143,204,63,154,153,153,153,153,153,233,63,220,197,9,78,53,246,204,63,255,192,142,13,47,133,233,63,145,187,79,107,33,92,205,63,114,184,12,248,228,112,233,63,125,236,171,160,188,193,205,63,174,119,227,11,187,92,233,63,229,242,42,110,7,39,206,63,224,233,214,252,176,72,233,63,95,90,170,82,2,140,206,63,230,44,155,127,198,52,233,63,54,89,220,203,173,240,206,63,41,226,208,73,251,32,233,63,55,123,75,86,10,85,207,63,213,144,1,18,79,13,233,63,42,62,94,109,24,185,207,63,250,24,156,143,193,249,232,63,28,80,173,69,108,14,208,63,63,55,241,122,82,230,232,63,64,208,180,148,37,64,208,63,211,24,48,141,1,211,232,63,13,89,205,95,184,113,208,63,58,255,98,128,206,191,232,63,227,144,115,226,36,163,208,63,170,243,107,15,185,172,232,63,75,183,154,87,107,212,208,63,156,137,1,246,192,153,232,63,213,74,174,249,139,5,209,63,74,176,171,240,229,134,232,63,176,168,147,2,135,54,209,63,185,146,192,188,39,116,232,63,14,166,171,171,92,103,209,63,24,134,97,24,134,97,232,63,111,35,212,45,13,152,209,63,20,6,120,194,0,79,232,63,250,153,105,193,152,200,209,63,221,190,178,122,151,60,232,63,242,162,72,158,255,248,209,63,160,164,130,1,74,42,232,63,101,121,207,251,65,41,210,63,24,24,24,24,24,24,232,63,57,118,223,16,96,89,210,63,6,24,96,128,1,6,232,63,163,134,222,19,90,137,210,63,64,127,1,253,5,244,231,63,36,157,184,58,48,185,210,63,29,79,90,81,37,226,231,63,48,29,225,186,226,232,210,63,244,5,125,65,95,208,231,63,132,65,84,201,113,24,211,63,124,1,46,146,179,190,231,63,84,125,152,154,221,71,211,63,195,236,224,8,34,173,231,63,90,216,191,98,38,119,211,63,139,57,182,107,170,155,231,63,233,69,105,85,76,166,211,63,200,164,120,129,76,138,231,63,15,247,193,165,79,213,211,63,13,198,154,17,8,121,231,63,227,167,134,134,48,4,212,63,177,169,52,228,220,103,231,63,19,232,4,42,239,50,212,63,109,117,1,194,202,86,231,63,194,94,28,194,139,97,212,63,70,23,93,116,209,69,231,63,208,9,64,128,6,144,212,63,141,254,65,197,240,52,231,63,160,120,119,149,95,190,212,63,188,222,70,127,40,36,231,63,105,2,96,50,151,236,212,63,9,124,156,109,120,19,231,63,45,248,45,135,173,26,213,63,112,129,11,92,224,2,231,63,98,210,173,195,162,72,213,63,23,96,242,22,96,242,230,63,108,90,69,23,119,118,213,63,199,55,67,107,247,225,230,63,225,207,244,176,42,164,213,63,97,200,129,38,166,209,230,63,202,9,88,191,189,209,213,63,23,108,193,22,108,193,230,63,211,147,167,112,48,255,213,63,61,26,163,10,73,177,230,63,149,199,185,242,130,44,214,63,144,114,83,209,60,161,230,63,242,225,3,115,181,89,214,63,192,208,136,58,71,145,230,63,174,20,155,30,200,134,214,63,23,104,129,22,104,129,230,63,61,148,53,34,187,179,214,63,26,103,1,54,159,113,230,63,227,161,43,170,142,224,214,63,249,34,81,106,236,97,230,63,53,146,120,226,66,13,215,63,163,74,59,133,79,82,230,63,6,208,187,246,215,57,215,63,100,33,11,89,200,66,230,63,206,219,57,18,78,102,215,63,222,192,138,184,86,51,230,63,162,71,221,95,165,146,215,63,64,98,1,119,250,35,230,63,191,175,55,10,222,190,215,63,148,174,49,104,179,20,230,63,195,175,130,59,248,234,215,63,6,22,88,96,129,5,230,63,149,212,160,29,244,22,216,63,252,45,41,52,100,246,229,63,23,139,30,218,209,66,216,63,231,21,208,184,91,231,229,63,160,11,51,154,145,110,216,63,165,226,236,195,103,216,229,63,90,66,193,134,51,154,216,63,87,16,147,43,136,201,229,63,138,180,88,200,183,197,216,63,145,250,71,198,188,186,229,63,199,98,54,135,30,241,216,63,192,90,1,107,5,172,229,63,61,168,69,235,103,28,217,63,170,204,35,241,97,157,229,63,250,22,33,28,148,71,217,63,237,88,129,48,210,142,229,63,88,81,19,65,163,114,217,63,96,5,88,1,86,128,229,63,138,224,23,129,149,157,217,63,58,107,80,60,237,113,229,63,98,8,220,2,107,200,217,63,226,82,124,186,151,99,229,63,75,152,191,236,35,243,217,63,85,85,85,85,85,85,229,63,149,185,213,100,192,29,218,63,254,130,187,230,37,71,229,63,10,187,229,144,64,72,218,63,235,15,244,72,9,57,229,63,234,217,107,150,164,114,218,63,75,5,168,86,255,42,229,63,73,8,154,154,236,156,218,63,21,248,226,234,7,29,229,63,228,176,88,194,24,199,218,63,197,196,17,225,34,15,229,63,107,120,71,50,41,241,218,63,21,80,1,21,80,1,229,63,91,252,189,14,30,27,219,63,155,76,221,98,143,243,228,63,98,143,204,123,247,68,219,63,57,5,47,167,224,229,228,63,93,243,60,157,181,110,219,63,76,44,220,190,67,216,228,63,251,16,147,150,88,152,219,63,110,175,37,135,184,202,228,63,10,173,13,139,224,193,219,63,225,143,166,221,62,189,228,63,123,27,167,157,77,235,219,63,91,191,82,160,214,175,228,63,38,240,21,241,159,20,220,63,74,1,118,173,127,162,228,63,77,173,205,167,215,61,220,63,103,208,178,227,57,149,228,63,247,111,255,227,244,102,220,63,128,72,1,34,5,136,228,63,33,154,154,199,247,143,220,63,123,20,174,71,225,122,228,63,201,122,77,116,224,184,220,63,102,96,89,52,206,109,228,63,235,243,133,11,175,225,220,63,154,207,245,199,203,96,228,63,100,30,114,174,99,10,221,63,202,118,199,226,217,83,228,63,213,235,0,126,254,50,221,63,251,217,98,101,248,70,228,63,131,198,226,154,127,91,221,63,77,238,171,48,39,58,228,63,62,47,138,37,231,131,221,63,135,31,213,37,102,45,228,63,84,89,44,62,53,172,221,63,81,89,94,38,181,32,228,63,160,196,193,4,106,212,221,63,20,20,20,20,20,20,228,63,181,213,6,153,133,252,221,63,102,101,14,209,130,7,228,63,38,108,124,26,136,36,222,63,251,19,176,63,1,251,227,63,4,119,104,168,113,76,222,63,7,175,165,66,143,238,227,63,135,135,214,97,66,116,222,63,2,169,228,188,44,226,227,63,245,97,152,101,250,155,222,63,198,117,170,145,217,213,227,63,192,140,70,210,153,195,222,63,231,171,123,164,149,201,227,63,244,221,64,198,32,235,222,63,85,41,35,217,96,189,227,63,236,6,175,95,143,18,223,63,20,59,177,19,59,177,227,63,91,30,129,188,229,57,223,63,34,200,122,56,36,165,227,63,172,40,112,250,35,97,223,63,99,127,24,44,28,153,227,63,194,158,254,54,74,136,223,63,142,8,102,211,34,141,227,63,30,243,120,143,88,175,223,63,20,56,129,19,56,129,227,63,113,21,246,32,79,214,223,63,238,69,201,209,91,117,227,63,152,244,87,8,46,253,223,63,72,7,222,243,141,105,227,63,138,255,37,177,250,17,224,63,248,42,159,95,206,93,227,63,254,208,165,165,82,37,224,63,193,120,43,251,28,82,227,63,59,99,206,239,158,56,224,63,70,19,224,172,121,70,227,63,210,38,169,157,223,75,224,63,178,188,87,91,228,58,227,63,156,69,38,189,20,95,224,63,250,29,106,237,92,47,227,63,64,223,28,92,62,114,224,63,191,16,43,74,227,35,227,63,14,69,75,136,92,133,224,63,182,235,233,88,119,24,227,63,32,53,87,79,111,152,224,63,144,209,48,1,25,13,227,63,209,20,206,190,118,171,224,63,96,2,196,42,200,1,227,63,130,42,37,228,114,190,224,63,104,47,161,189,132,246,226,63,183,214,185,204,99,209,224,63,75,209,254,161,78,235,226,63,139,204,209,133,73,228,224,63,151,128,75,192,37,224,226,63,125,73,155,28,36,247,224,63,160,80,45,1,10,213,226,63,150,76,45,158,243,9,225,63,160,44,129,77,251,201,226,63,248,204,135,23,184,28,225,63,17,55,90,142,249,190,226,63,188,239,147,149,113,47,225,63,64,43,1,173,4,180,226,63,68,61,36,37,32,66,225,63,5,193,243,146,28,169,226,63,233,213,244,210,195,84,225,63,158,18,228,41,65,158,226,63,14,166,171,171,92,103,225,63,165,4,184,91,114,147,226,63,160,153,216,187,234,121,225,63,19,176,136,18,176,136,226,63,6,207,245,15,110,140,225,63,77,206,161,56,250,125,226,63,110,201,103,180,230,158,225,63,53,39,129,184,80,115,226,63,158,162,125,181,84,177,225,63,39,1,214,124,179,104,226,63,36,60,113,31,184,195,225,63,241,146,128,112,34,94,226,63,3,112,103,254,16,214,225,63,178,119,145,126,157,83,226,63,208,64,112,94,95,232,225,63,146,36,73,146,36,73,226,63,76,9,135,75,163,250,225,63,91,96,23,151,183,62,226,63,109,171,146,209,220,12,226,63,223,188,154,120,86,52,226,63,235,190,101,252,11,31,226,63,42,18,160,34,1,42,226,63,66,191,190,215,48,49,226,63,120,251,33,129,183,31,226,63,51,57,72,111,75,67,226,63,230,85,72,128,121,21,226,63,203,247,152,206,91,85,226,63,217,192,103,12,71,11,226,63,223,48,52,1,98,103,226,63,18,32,1,18,32,1,226,63,26,177,137,18,94,121,226,63,112,31,193,125,4,247,225,63,130,7,246,13,80,139,226,63,76,184,127,60,244,236,225,63,138,176,194,254,55,157,226,63,116,184,63,59,239,226,225,63,173,64,38,240,21,175,226,63,189,74,46,103,245,216,225,63,139,142,68,237,233,192,226,63,29,129,162,173,6,207,225,63,157,220,46,1,180,210,226,63,89,224,28,252,34,197,225,63,104,2,228,54,116,228,226,63,41,237,70,64,74,187,225,63,70,149,80,153,42,246,226,63,227,186,242,103,124,177,225,63,190,16,79,51,215,7,227,63,150,123,26,97,185,167,225,63,106,254,167,15,122,25,227,63,158,17,224,25,1,158,225,63,113,29,18,57,19,43,227,63,156,162,140,128,83,148,225,63,148,137,50,186,162,60,227,63,219,43,144,131,176,138,225,63,211,225,156,157,40,78,227,63,18,24,129,17,24,129,225,63,160,110,211,237,164,95,227,63,132,214,27,25,138,119,225,63,181,71,71,181,23,113,227,63,121,115,66,137,6,110,225,63,126,121,88,254,128,130,227,63,1,50,252,80,141,100,225,63,25,42,86,211,224,147,227,63,13,39,117,95,30,91,225,63,249,189,126,62,55,165,227,63,201,213,253,163,185,81,225,63,34,252,255,73,132,182,227,63,59,205,10,14,95,72,225,63,5,50,247,255,199,199,227,63,36,71,52,141,14,63,225,63,250,86,113,106,2,217,227,63,17,200,53,17,200,53,225,63,91,47,107,147,51,234,227,63,172,192,237,137,139,44,225,63,66,111,209,132,91,251,227,63,51,48,93,231,88,35,225,63,233,220,128,72,122,12,228,63,38,72,167,25,48,26,225,63,174,114,70,232,143,29,228,63,17,17,17,17,17,17,225,63,191,128,223,109,156,46,228,63,128,16,1,190,251,7,225,63,103,206,249,226,159,63,228,63,17,240,254,16,240,254,224,63,10,187,51,81,154,80,228,63,162,37,179,250,237,245,224,63,194,94,28,194,139,97,228,63,144,156,230,107,245,236,224,63,173,170,51,63,116,114,228,63,17,96,130,85,6,228,224,63,223,136,234,209,83,131,228,63,150,70,143,168,32,219,224,63,7,252,162,131,42,148,228,63,58,158,53,86,68,210,224,63,187,62,176,93,248,164,228,63,59,218,188,79,113,201,224,63,115,226,86,105,189,181,228,63,113,65,139,134,167,192,224,63,57,238,204,175,121,198,228,63,200,157,37,236,230,183,224,63,0,253,57,58,45,215,228,63,181,236,46,114,47,175,224,63,176,91,183,17,216,231,228,63,167,16,104,10,129,166,224,63,232,38,80,63,122,248,228,63,96,131,175,166,219,157,224,63,107,104,1,204,19,9,229,63,84,9,1,57,63,149,224,63,70,52,186,192,164,25,229,63,226,101,117,179,171,140,224,63,170,197,91,38,45,42,229,63,132,16,66,8,33,132,224,63,124,155,185,5,173,58,229,63,226,234,184,41,159,123,224,63,151,148,153,103,36,75,229,63,198,247,71,10,38,115,224,63,205,11,180,84,147,91,229,63,251,18,121,156,181,106,224,63,153,243,179,213,249,107,229,63,252,169,241,210,77,98,224,63,144,241,54,243,87,124,229,63,134,117,114,160,238,89,224,63,137,121,205,181,173,140,229,63,4,52,215,247,151,81,224,63,125,232,250,37,251,156,229,63,197,100,22,204,73,73,224,63,44,159,53,76,64,173,229,63,16,4,65,16,4,65,224,63,115,28,231,48,125,189,229,63,252,71,130,183,198,56,224,63,100,23,108,220,177,205,229,63,26,94,31,181,145,48,224,63,35,153,20,87,222,221,229,63,233,41,119,252,100,40,224,63,117,22,36,169,2,238,229,63,8,4,2,129,64,32,224,63,24,137,209,218,30,254,229,63,55,122,81,54,36,24,224,63,216,136,71,244,50,14,230,63,16,16,16,16,16,16,224,63,239,57,250,254,66,46,230,63,0,0,0,0,0,0,224,63,4,0,0,0,0,0,0,0,88,98,0,0,36,0,0,0,37,0,0,0,252,255,255,255,252,255,255,255,88,98,0,0,38,0,0,0,39,0,0,0,0,0,0,0,0,0,0,0,172,126,2,0,64,195,2,0,172,126,2,0,80,195,2,0,172,126,2,0,99,195,2,0,172,126,2,0,208,195,2,0,132,127,2,0,164,195,2,0,0,0,0,0,1,0,0,0,136,34,0,0,0,0,0,0,132,127,2,0,128,195,2,0,0,0,0,0,1,0,0,0,144,34,0,0,0,0,0,0,104,127,2,0,245,195,2,0,0,0,0,0,168,34,0,0,104,127,2,0,26,196,2,0,1,0,0,0,168,34,0,0,172,126,2,0,87,196,2,0,132,127,2,0,153,196,2,0,0,0,0,0,1,0,0,0,136,34,0,0,0,0,0,0,132,127,2,0,117,196,2,0,0,0,0,0,1,0,0,0,232,34,0,0,0,0,0,0,104,127,2,0,197,196,2,0,0,0,0,0,0,35,0,0,104,127,2,0,234,196,2,0,1,0,0,0,0,35,0,0,132,127,2,0,69,197,2,0,0,0,0,0,1,0,0,0,136,34,0,0,0,0,0,0,132,127,2,0,33,197,2,0,0,0,0,0,1,0,0,0,56,35,0,0,0,0,0,0,104,127,2,0,113,197,2,0,0,0,0,0,80,35,0,0,104,127,2,0,150,197,2,0,1,0,0,0,80,35,0,0,132,127,2,0,1,198,2,0,0,0,0,0,1,0,0,0,136,34,0,0,0,0,0,0,132,127,2,0,205,197,2,0,0,0,0,0,1,0,0,0,136,35,0,0,0,0,0,0,104,127,2,0,61,198,2,0,0,0,0,0,160,35,0,0,104,127,2,0,114,198,2,0,1,0,0,0,160,35,0,0,172,126,2,0,168,198,2,0,132,127,2,0,230,198,2,0,0,0,0,0,1,0,0,0,136,34,0,0,0,0,0,0,132,127,2,0,184,198,2,0,0,0,0,0,1,0,0,0,224,35,0,0,0,0,0,0,104,127,2,0,28,199,2,0,0,0,0,0,248,35,0,0,104,127,2,0,75,199,2,0,1,0,0,0,248,35,0,0,172,126,2,0,123,199,2,0,132,127,2,0,184,199,2,0,0,0,0,0,1,0,0,0,136,34,0,0,0,0,0,0,132,127,2,0,133,199,2,0,0,0,0,0,1,0,0,0,56,36,0,0,0,0,0,0,104,127,2,0,243,199,2,0,0,0,0,0,80,36,0,0,104,127,2,0,39,200,2,0,1,0,0,0,80,36,0,0,104,127,2,0,92,200,2,0,0,0,0,0,48,36,0,0,104,127,2,0,103,200,2,0,1,0,0,0,48,36,0,0,172,126,2,0,115,200,2,0,172,126,2,0,164,200,2,0,212,126,2,0,147,200,2,0,176,36,0,0,0,0,0,0,212,126,2,0,130,200,2,0,184,36,0,0,0,0,0,0,172,126,2,0,201,200,2,0,172,126,2,0,232,200,2,0,172,126,2,0,7,201,2,0,172,126,2,0,38,201,2,0,172,126,2,0,69,201,2,0,172,126,2,0,100,201,2,0,172,126,2,0,131,201,2,0,172,126,2,0,184,201,2,0,172,126,2,0,232,201,2,0,172,126,2,0,0,202,2,0,172,126,2,0,19,202,2,0,172,126,2,0,34,202,2,0,172,126,2,0,62,202,2,0,172,126,2,0,87,202,2,0,172,126,2,0,164,202,2,0,132,127,2,0,101,202,2,0,0,0,0,0,1,0,0,0,72,37,0,0,0,0,0,0,172,126,2,0,209,202,2,0,172,126,2,0,125,205,2,0,104,127,2,0,163,205,2,0,0,0,0,0,160,70,0,0,104,127,2,0,185,205,2,0,1,0,0,0,160,70,0,0,212,126,2,0,3,206,2,0,112,41,0,0,0,0,0,0,104,127,2,0,31,206,2,0,0,0,0,0,152,37,0,0,104,127,2,0,60,206,2,0,1,0,0,0,152,37,0,0,212,126,2,0,90,206,2,0,152,37,0,0,0,0,0,0,104,127,2,0,122,206,2,0,0,0,0,0,200,37,0,0,104,127,2,0,155,206,2,0,1,0,0,0,200,37,0,0,172,126,2,0,189,206,2,0,212,126,2,0,231,206,2,0,112,41,0,0,0,0,0,0,104,127,2,0,243,206,2,0,0,0,0,0,0,38,0,0,104,127,2,0,0,207,2,0,1,0,0,0,0,38,0,0,172,126,2,0,14,207,2,0,104,127,2,0,45,207,2,0,0,0,0,0,112,41,0,0,104,127,2,0,62,207,2,0,1,0,0,0,112,41,0,0,104,127,2,0,80,207,2,0,0,0,0,0,112,37,0,0,104,127,2,0,119,207,2,0,1,0,0,0,112,37,0,0,172,126,2,0,159,207,2,0,104,127,2,0,184,207,2,0,0,0,0,0,120,38,0,0,104,127,2,0,210,207,2,0,1,0,0,0,120,38,0,0,0,0,0,0,0,0,0,0,44,180,41,188,166,23,185,63,10,166,105,60,184,248,200,63,5,159,213,46,6,148,210,63,99,169,174,166,226,125,216,63,59,246,6,56,93,43,222,63,200,104,174,57,59,199,225,63,214,29,9,37,243,76,228,63,204,59,127,102,158,160,230,63,65,23,21,107,128,188,232,63,163,161,14,41,102,155,234,63,176,189,128,241,178,56,236,63,70,141,50,207,107,144,237,63,219,45,198,86,65,159,238,63,176,92,247,207,151,98,239,63,37,37,209,163,141,216,239,63,0,0,0,0,0,0,240,63,38,37,209,163,141,216,239,63,176,92,247,207,151,98,239,63,219,45,198,86,65,159,238,63,70,141,50,207,107,144,237,63,177,189,128,241,178,56,236,63,165,161,14,41,102,155,234,63,66,23,21,107,128,188,232,63,205,59,127,102,158,160,230,63,214,29,9,37,243,76,228,63,200,104,174,57,59,199,225,63,63,246,6,56,93,43,222,63,101,169,174,166,226,125,216,63,6,159,213,46,6,148,210,63,23,166,105,60,184,248,200,63,60,180,41,188,166,23,185,63,159,113,189,255,249,165,161,60,43,180,41,188,166,23,185,191,14,166,105,60,184,248,200,191,1,159,213,46,6,148,210,191,97,169,174,166,226,125,216,191,59,246,6,56,93,43,222,191,198,104,174,57,59,199,225,191,212,29,9,37,243,76,228,191,204,59,127,102,158,160,230,191,62,23,21,107,128,188,232,191,163,161,14,41,102,155,234,191,176,189,128,241,178,56,236,191,68,141,50,207,107,144,237,191],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([218,45,198,86,65,159,238,191,175,92,247,207,151,98,239,191,38,37,209,163,141,216,239,191,0,0,0,0,0,0,240,191,38,37,209,163,141,216,239,191,176,92,247,207,151,98,239,191,219,45,198,86,65,159,238,191,69,141,50,207,107,144,237,191,177,189,128,241,178,56,236,191,165,161,14,41,102,155,234,191,64,23,21,107,128,188,232,191,206,59,127,102,158,160,230,191,218,29,9,37,243,76,228,191,200,104,174,57,59,199,225,191,64,246,6,56,93,43,222,191,110,169,174,166,226,125,216,191,8,159,213,46,6,148,210,191,27,166,105,60,184,248,200,191,37,180,41,188,166,23,185,191,212,126,2,0,186,220,2,0,120,103,0,0,0,0,0,0,172,126,2,0,237,225,2,0,64,0,0,0,0,0,0,0,40,98,0,0,11,0,0,0,12,0,0,0,192,255,255,255,192,255,255,255,40,98,0,0,13,0,0,0,14,0,0,0,64,0,0,0,0,0,0,0,136,98,0,0,17,0,0,0,18,0,0,0,56,0,0,0,248,255,255,255,136,98,0,0,19,0,0,0,20,0,0,0,192,255,255,255,192,255,255,255,136,98,0,0,21,0,0,0,22,0,0,0,0,0,0,0,212,126,2,0,102,225,2,0,24,98,0,0,0,0,0,0,212,126,2,0,168,225,2,0,136,98,0,0,0,0,0,0,132,127,2,0,235,246,2,0,0,0,0,0,1,0,0,0,176,40,0,0,0,0,0,0,132,127,2,0,24,247,2,0,0,0,0,0,1,0,0,0,176,40,0,0,0,0,0,0,172,126,2,0,62,255,2,0,212,126,2,0,202,11,3,0,208,46,0,0,0,0,0,0,212,126,2,0,87,12,3,0,208,46,0,0,0,0,0,0,212,126,2,0,202,12,3,0,208,46,0,0,0,0,0,0,132,127,2,0,98,14,3,0,0,0,0,0,1,0,0,0,176,40,0,0,0,0,0,0,172,126,2,0,246,15,3,0,56,0,0,0,0,0,0,0,88,98,0,0,36,0,0,0,37,0,0,0,200,255,255,255,200,255,255,255,88,98,0,0,38,0,0,0,39,0,0,0,212,126,2,0,18,16,3,0,88,98,0,0,0,0,0,0,172,126,2,0,143,41,3,0,212,126,2,0,154,40,3,0,24,42,0,0,0,0,0,0,172,126,2,0,223,40,3,0,172,126,2,0,232,64,3,0,212,126,2,0,71,56,3,0,32,42,0,0,0,0,0,0,212,126,2,0,244,55,3,0,32,42,0,0,0,0,0,0,212,126,2,0,49,56,3,0,32,42,0,0,0,0,0,0,212,126,2,0,201,57,3,0,32,42,0,0,0,0,0,0,212,126,2,0,180,60,3,0,32,42,0,0,0,0,0,0,212,126,2,0,235,58,3,0,32,42,0,0,0,0,0,0,212,126,2,0,106,61,3,0,32,42,0,0,0,0,0,0,212,126,2,0,244,64,3,0,32,42,0,0,0,0,0,0,212,126,2,0,131,65,3,0,32,42,0,0,0,0,0,0,172,126,2,0,130,69,3,0,212,126,2,0,105,67,3,0,192,41,0,0,0,0,0,0,212,126,2,0,240,67,3,0,184,42,0,0,0,0,0,0,212,126,2,0,53,73,3,0,24,42,0,0,0,0,0,0,0,0,0,0,0,0,240,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,191,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,63,205,59,127,102,158,160,230,63,204,59,127,102,158,160,230,63,70,141,50,207,107,144,237,63,99,169,174,166,226,125,216,63,176,92,247,207,151,98,239,63,10,166,105,60,184,248,200,63,38,37,209,163,141,216,239,63,44,180,41,188,166,23,185,63,126,109,121,227,33,246,239,63,21,216,13,241,101,31,169,63,13,205,132,96,136,253,239,63,127,102,163,247,85,33,153,63,219,146,155,22,98,255,239,63,135,199,222,252,209,33,137,63,146,138,142,133,216,255,239,63,118,0,103,254,240,33,121,63,2,29,98,33,246,255,239,63,195,164,204,190,248,33,105,63,230,110,88,136,253,255,239,63,66,71,230,174,250,33,89,63,52,26,22,98,255,255,239,63,55,179,236,42,251,33,73,63,117,134,133,216,255,255,239,63,248,78,238,73,251,33,57,63,156,97,33,246,255,255,239,63,2,181,174,81,251,33,41,63,103,88,136,253,255,255,239,63,245,207,158,83,251,33,25,63,26,22,98,255,255,255,239,63,106,215,26,84,251,33,9,63,134,133,216,255,255,255,239,63,72,217,57,84,251,33,249,62,98,33,246,255,255,255,239,63,78,152,65,84,251,33,233,62,88,136,253,255,255,255,239,63,136,124,67,84,251,33,217,62,22,98,255,255,255,255,239,63,196,216,67,84,251,33,201,62,134,216,255,255,255,255,239,63,0,53,68,84,251,33,185,62,33,246,255,255,255,255,239,63,136,124,67,84,251,33,169,62,136,253,255,255,255,255,239,63,136,124,67,84,251,33,153,62,98,255,255,255,255,255,239,63,103,94,70,84,251,33,137,62,217,255,255,255,255,255,239,63,169,154,64,84,251,33,121,62,246,255,255,255,255,255,239,63,36,34,76,84,251,33,105,62,254,255,255,255,255,255,239,63,36,34,76,84,251,33,89,62,255,255,255,255,255,255,239,63,58,4,30,84,251,33,73,62,0,0,0,0,0,0,240,63,15,64,122,84,251,33,57,62,0,0,0,0,0,0,240,63,15,64,122,84,251,33,41,62,212,126,2,0,228,74,3,0,0,45,0,0,0,0,0,0,172,126,2,0,251,74,3,0,212,126,2,0,11,75,3,0,0,45,0,0,0,0,0,0,212,126,2,0,226,75,3,0,24,42,0,0,0,0,0,0,212,126,2,0,40,76,3,0,56,45,0,0,0,0,0,0,172,126,2,0,58,76,3,0,212,126,2,0,74,76,3,0,56,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,192,0,0,0,0,0,0,224,193,0,0,0,224,255,255,239,199,255,255,255,255,255,255,239,255,0,0,0,0,0,0,0,0,0,0,0,0,0,224,111,64,0,0,0,0,0,192,95,64,0,0,0,0,224,255,239,64,0,0,0,0,192,255,223,64,0,0,192,255,255,255,223,65,0,0,0,224,255,255,239,71,255,255,255,255,255,255,239,127,0,0,0,0,0,0,0,0,172,126,2,0,153,89,3,0,172,126,2,0,169,89,3,0,212,126,2,0,185,89,3,0,24,42,0,0,0,0,0,0,212,126,2,0,230,90,3,0,32,46,0,0,0,0,0,0,212,126,2,0,6,90,3,0,24,42,0,0,0,0,0,0,212,126,2,0,209,90,3,0,208,45,0,0,0,0,0,0,212,126,2,0,248,90,3,0,216,45,0,0,0,0,0,0,212,126,2,0,13,91,3,0,24,42,0,0,0,0,0,0,212,126,2,0,155,91,3,0,32,46,0,0,0,0,0,0,212,126,2,0,177,91,3,0,24,42,0,0,0,0,0,0,212,126,2,0,252,91,3,0,32,46,0,0,0,0,0,0,212,126,2,0,19,92,3,0,24,42,0,0,0,0,0,0,212,126,2,0,91,92,3,0,32,46,0,0,0,0,0,0,212,126,2,0,111,92,3,0,24,42,0,0,0,0,0,0,212,126,2,0,191,92,3,0,32,46,0,0,0,0,0,0,212,126,2,0,214,92,3,0,24,42,0,0,0,0,0,0,212,126,2,0,34,93,3,0,32,46,0,0,0,0,0,0,172,126,2,0,205,93,3,0,60,0,0,0,0,0,0,0,40,98,0,0,11,0,0,0,12,0,0,0,196,255,255,255,196,255,255,255,40,98,0,0,13,0,0,0,14,0,0,0,212,126,2,0,131,137,3,0,40,98,0,0,0,0,0,0,212,126,2,0,11,149,3,0,208,46,0,0,0,0,0,0,212,126,2,0,152,149,3,0,208,46,0,0,0,0,0,0,212,126,2,0,217,150,3,0,208,46,0,0,0,0,0,0,172,126,2,0,237,161,3,0,172,126,2,0,2,162,3,0,172,126,2,0,26,162,3,0,172,126,2,0,18,164,3,0,212,126,2,0,95,165,3,0,24,42,0,0,0,0,0,0,212,126,2,0,12,166,3,0,64,47,0,0,0,0,0,0,212,126,2,0,45,166,3,0,24,42,0,0,0,0,0,0,212,126,2,0,130,166,3,0,64,47,0,0,0,0,0,0,212,126,2,0,163,166,3,0,24,42,0,0,0,0,0,0,212,126,2,0,248,166,3,0,64,47,0,0,0,0,0,0,212,126,2,0,25,167,3,0,24,42,0,0,0,0,0,0,212,126,2,0,110,167,3,0,64,47,0,0,0,0,0,0,212,126,2,0,143,167,3,0,24,42,0,0,0,0,0,0,212,126,2,0,228,167,3,0,64,47,0,0,0,0,0,0,212,126,2,0,5,168,3,0,24,42,0,0,0,0,0,0,212,126,2,0,90,168,3,0,64,47,0,0,0,0,0,0,212,126,2,0,123,168,3,0,24,42,0,0,0,0,0,0,212,126,2,0,208,168,3,0,64,47,0,0,0,0,0,0,212,126,2,0,241,168,3,0,24,42,0,0,0,0,0,0,212,126,2,0,70,169,3,0,64,47,0,0,0,0,0,0,212,126,2,0,103,169,3,0,24,42,0,0,0,0,0,0,212,126,2,0,188,169,3,0,64,47,0,0,0,0,0,0,212,126,2,0,221,169,3,0,24,42,0,0,0,0,0,0,212,126,2,0,50,170,3,0,64,47,0,0,0,0,0,0,212,126,2,0,83,170,3,0,24,42,0,0,0,0,0,0,212,126,2,0,36,171,3,0,64,47,0,0,0,0,0,0,212,126,2,0,79,171,3,0,176,48,0,0,0,0,0,0,212,126,2,0,132,171,3,0,24,42,0,0,0,0,0,0,212,126,2,0,237,171,3,0,64,47,0,0,0,0,0,0,212,126,2,0,24,172,3,0,224,48,0,0,0,0,0,0,212,126,2,0,10,173,3,0,24,42,0,0,0,0,0,0,212,126,2,0,200,173,3,0,72,47,0,0,0,0,0,0,212,126,2,0,252,173,3,0,16,49,0,0,0,0,0,0,212,126,2,0,52,174,3,0,24,42,0,0,0,0,0,0,212,126,2,0,160,174,3,0,72,47,0,0,0,0,0,0,212,126,2,0,212,174,3,0,64,49,0,0,0,0,0,0,212,126,2,0,12,175,3,0,24,42,0,0,0,0,0,0,212,126,2,0,120,175,3,0,72,47,0,0,0,0,0,0,212,126,2,0,172,175,3,0,112,49,0,0,0,0,0,0,212,126,2,0,228,175,3,0,24,42,0,0,0,0,0,0,212,126,2,0,80,176,3,0,72,47,0,0,0,0,0,0,212,126,2,0,132,176,3,0,160,49,0,0,0,0,0,0,212,126,2,0,188,176,3,0,24,42,0,0,0,0,0,0,212,126,2,0,40,177,3,0,72,47,0,0,0,0,0,0,212,126,2,0,92,177,3,0,208,49,0,0,0,0,0,0,212,126,2,0,239,177,3,0,24,42,0,0,0,0,0,0,212,126,2,0,91,178,3,0,72,47,0,0,0,0,0,0,212,126,2,0,143,178,3,0,0,50,0,0,0,0,0,0,212,126,2,0,199,178,3,0,24,42,0,0,0,0,0,0,212,126,2,0,51,179,3,0,72,47,0,0,0,0,0,0,212,126,2,0,103,179,3,0,48,50,0,0,0,0,0,0,212,126,2,0,159,179,3,0,24,42,0,0,0,0,0,0,212,126,2,0,11,180,3,0,72,47,0,0,0,0,0,0,212,126,2,0,63,180,3,0,96,50,0,0,0,0,0,0,212,126,2,0,119,180,3,0,24,42,0,0,0,0,0,0,212,126,2,0,227,180,3,0,72,47,0,0,0,0,0,0,212,126,2,0,23,181,3,0,144,50,0,0,0,0,0,0,212,126,2,0,79,181,3,0,24,42,0,0,0,0,0,0,212,126,2,0,197,181,3,0,72,47,0,0,0,0,0,0,212,126,2,0,3,182,3,0,192,50,0,0,0,0,0,0,212,126,2,0,69,182,3,0,24,42,0,0,0,0,0,0,212,126,2,0,230,182,3,0,72,47,0,0,0,0,0,0,212,126,2,0,35,183,3,0,16,51,0,0,0,0,0,0,212,126,2,0,105,183,3,0,240,50,0,0,0,0,0,0,212,126,2,0,170,183,3,0,24,42,0,0,0,0,0,0,212,126,2,0,36,184,3,0,72,47,0,0,0,0,0,0,212,126,2,0,97,184,3,0,80,51,0,0,0,0,0,0,212,126,2,0,167,184,3,0,48,51,0,0,0,0,0,0,212,126,2,0,232,184,3,0,24,42,0,0,0,0,0,0,212,126,2,0,99,185,3,0,208,50,0,0,0,0,0,0,212,126,2,0,170,185,3,0,24,42,0,0,0,0,0,0,212,126,2,0,18,186,3,0,24,42,0,0,0,0,0,0,212,126,2,0,122,186,3,0,24,42,0,0,0,0,0,0,212,126,2,0,226,186,3,0,24,42,0,0,0,0,0,0,212,126,2,0,74,187,3,0,24,42,0,0,0,0,0,0,212,126,2,0,178,187,3,0,24,42,0,0,0,0,0,0,212,126,2,0,26,188,3,0,24,42,0,0,0,0,0,0,212,126,2,0,130,188,3,0,24,42,0,0,0,0,0,0,212,126,2,0,234,188,3,0,24,42,0,0,0,0,0,0,212,126,2,0,146,189,3,0,24,42,0,0,0,0,0,0,212,126,2,0,191,190,3,0,24,42,0,0,0,0,0,0,212,126,2,0,81,191,3,0,80,47,0,0,0,0,0,0,212,126,2,0,129,191,3,0,24,42,0,0,0,0,0,0,212,126,2,0,229,191,3,0,80,47,0,0,0,0,0,0,212,126,2,0,21,192,3,0,24,42,0,0,0,0,0,0,212,126,2,0,121,192,3,0,80,47,0,0,0,0,0,0,212,126,2,0,169,192,3,0,24,42,0,0,0,0,0,0,212,126,2,0,13,193,3,0,80,47,0,0,0,0,0,0,212,126,2,0,61,193,3,0,24,42,0,0,0,0,0,0,212,126,2,0,161,193,3,0,80,47,0,0,0,0,0,0,212,126,2,0,209,193,3,0,24,42,0,0,0,0,0,0,212,126,2,0,53,194,3,0,80,47,0,0,0,0,0,0,212,126,2,0,101,194,3,0,24,42,0,0,0,0,0,0,212,126,2,0,201,194,3,0,80,47,0,0,0,0,0,0,212,126,2,0,249,194,3,0,24,42,0,0,0,0,0,0,212,126,2,0,93,195,3,0,80,47,0,0,0,0,0,0,212,126,2,0,141,195,3,0,24,42,0,0,0,0,0,0,212,126,2,0,241,195,3,0,80,47,0,0,0,0,0,0,212,126,2,0,33,196,3,0,24,42,0,0,0,0,0,0,212,126,2,0,133,196,3,0,80,47,0,0,0,0,0,0,212,126,2,0,181,196,3,0,24,42,0,0,0,0,0,0,212,126,2,0,25,197,3,0,80,47,0,0,0,0,0,0,212,126,2,0,73,197,3,0,24,42,0,0,0,0,0,0,212,126,2,0,173,197,3,0,80,47,0,0,0,0,0,0,212,126,2,0,221,197,3,0,24,42,0,0,0,0,0,0,212,126,2,0,65,198,3,0,80,47,0,0,0,0,0,0,212,126,2,0,81,203,3,0,208,46,0,0,0,0,0,0,212,126,2,0,230,203,3,0,208,46,0,0,0,0,0,0,212,126,2,0,82,204,3,0,208,46,0,0,0,0,0,0,212,126,2,0,190,204,3,0,208,46,0,0,0,0,0,0,212,126,2,0,42,205,3,0,208,46,0,0,0,0,0,0,212,126,2,0,163,205,3,0,208,46,0,0,0,0,0,0,212,126,2,0,39,206,3,0,208,46,0,0,0,0,0,0,212,126,2,0,171,206,3,0,208,46,0,0,0,0,0,0,212,126,2,0,47,207,3,0,208,46,0,0,0,0,0,0,212,126,2,0,179,207,3,0,208,46,0,0,0,0,0,0,212,126,2,0,71,208,3,0,208,46,0,0,0,0,0,0,212,126,2,0,185,208,3,0,208,46,0,0,0,0,0,0,212,126,2,0,43,209,3,0,208,46,0,0,0,0,0,0,212,126,2,0,157,209,3,0,208,46,0,0,0,0,0,0,212,126,2,0,15,210,3,0,208,46,0,0,0,0,0,0,212,126,2,0,142,210,3,0,208,46,0,0,0,0,0,0,212,126,2,0,172,210,3,0,208,46,0,0,0,0,0,0,212,126,2,0,202,210,3,0,208,46,0,0,0,0,0,0,212,126,2,0,232,210,3,0,208,46,0,0,0,0,0,0,212,126,2,0,6,211,3,0,208,46,0,0,0,0,0,0,212,126,2,0,36,211,3,0,208,46,0,0,0,0,0,0,212,126,2,0,99,211,3,0,208,46,0,0,0,0,0,0,212,126,2,0,170,211,3,0,208,46,0,0,0,0,0,0,212,126,2,0,3,212,3,0,208,46,0,0,0,0,0,0,212,126,2,0,92,212,3,0,208,46,0,0,0,0,0,0,212,126,2,0,181,212,3,0,208,46,0,0,0,0,0,0,212,126,2,0,204,212,3,0,208,46,0,0,0,0,0,0,212,126,2,0,14,213,3,0,208,46,0,0,0,0,0,0,212,126,2,0,80,213,3,0,208,46,0,0,0,0,0,0,212,126,2,0,147,213,3,0,208,46,0,0,0,0,0,0,212,126,2,0,213,213,3,0,208,46,0,0,0,0,0,0,212,126,2,0,94,215,3,0,208,46,0,0,0,0,0,0,212,126,2,0,235,222,3,0,208,46,0,0,0,0,0,0,212,126,2,0,121,223,3,0,208,46,0,0,0,0,0,0,212,126,2,0,141,232,3,0,208,46,0,0,0,0,0,0,212,126,2,0,167,232,3,0,208,46,0,0,0,0,0,0,212,126,2,0,145,235,3,0,208,46,0,0,0,0,0,0,212,126,2,0,243,238,3,0,208,46,0,0,0,0,0,0,212,126,2,0,62,239,3,0,208,46,0,0,0,0,0,0,212,126,2,0,137,239,3,0,208,46,0,0,0,0,0,0,212,126,2,0,200,239,3,0,208,46,0,0,0,0,0,0,212,126,2,0,7,240,3,0,208,46,0,0,0,0,0,0,212,126,2,0,71,240,3,0,208,46,0,0,0,0,0,0,212,126,2,0,143,244,3,0,24,42,0,0,0,0,0,0,212,126,2,0,38,248,3,0,0,38,0,0,0,0,0,0,212,126,2,0,36,245,3,0,24,42,0,0,0,0,0,0,212,126,2,0,139,245,3,0,208,46,0,0,0,0,0,0,212,126,2,0,189,245,3,0,24,42,0,0,0,0,0,0,212,126,2,0,36,246,3,0,208,46,0,0,0,0,0,0,212,126,2,0,86,246,3,0,24,42,0,0,0,0,0,0,212,126,2,0,191,246,3,0,208,46,0,0,0,0,0,0,212,126,2,0,243,246,3,0,24,42,0,0,0,0,0,0,212,126,2,0,90,247,3,0,208,46,0,0,0,0,0,0,212,126,2,0,196,248,3,0,24,42,0,0,0,0,0,0,212,126,2,0,9,249,3,0,64,47,0,0,0,0,0,0,212,126,2,0,26,249,3,0,24,42,0,0,0,0,0,0,212,126,2,0,95,249,3,0,64,47,0,0,0,0,0,0,212,126,2,0,112,249,3,0,24,42,0,0,0,0,0,0,212,126,2,0,181,249,3,0,64,47,0,0,0,0,0,0,212,126,2,0,198,249,3,0,24,42,0,0,0,0,0,0,212,126,2,0,11,250,3,0,64,47,0,0,0,0,0,0,212,126,2,0,28,250,3,0,24,42,0,0,0,0,0,0,212,126,2,0,97,250,3,0,64,47,0,0,0,0,0,0,212,126,2,0,114,250,3,0,24,42,0,0,0,0,0,0,212,126,2,0,183,250,3,0,64,47,0,0,0,0,0,0,212,126,2,0,200,250,3,0,24,42,0,0,0,0,0,0,212,126,2,0,13,251,3,0,64,47,0,0,0,0,0,0,212,126,2,0,30,251,3,0,24,42,0,0,0,0,0,0,212,126,2,0,99,251,3,0,64,47,0,0,0,0,0,0,212,126,2,0,116,251,3,0,24,42,0,0,0,0,0,0,212,126,2,0,185,251,3,0,64,47,0,0,0,0,0,0,212,126,2,0,202,251,3,0,24,42,0,0,0,0,0,0,212,126,2,0,15,252,3,0,64,47,0,0,0,0,0,0,212,126,2,0,234,252,3,0,24,42,0,0,0,0,0,0,212,126,2,0,70,253,3,0,72,47,0,0,0,0,0,0,212,126,2,0,90,253,3,0,24,42,0,0,0,0,0,0,212,126,2,0,162,253,3,0,72,47,0,0,0,0,0,0,212,126,2,0,182,253,3,0,24,42,0,0,0,0,0,0,212,126,2,0,254,253,3,0,72,47,0,0,0,0,0,0,212,126,2,0,18,254,3,0,24,42,0,0,0,0,0,0,212,126,2,0,90,254,3,0,72,47,0,0,0,0,0,0,212,126,2,0,110,254,3,0,24,42,0,0,0,0,0,0,212,126,2,0,182,254,3,0,72,47,0,0,0,0,0,0,212,126,2,0,202,254,3,0,24,42,0,0,0,0,0,0,212,126,2,0,18,255,3,0,72,47,0,0,0,0,0,0,212,126,2,0,38,255,3,0,24,42,0,0,0,0,0,0,212,126,2,0,110,255,3,0,72,47,0,0,0,0,0,0,212,126,2,0,130,255,3,0,24,42,0,0,0,0,0,0,212,126,2,0,202,255,3,0,72,47,0,0,0,0,0,0,212,126,2,0,222,255,3,0,24,42,0,0,0,0,0,0,212,126,2,0,38,0,4,0,72,47,0,0,0,0,0,0,212,126,2,0,58,0,4,0,24,42,0,0,0,0,0,0,212,126,2,0,130,0,4,0,72,47,0,0,0,0,0,0,212,126,2,0,150,0,4,0,24,42,0,0,0,0,0,0,212,126,2,0,222,0,4,0,72,47,0,0,0,0,0,0,212,126,2,0,242,0,4,0,24,42,0,0,0,0,0,0,212,126,2,0,58,1,4,0,72,47,0,0,0,0,0,0,212,126,2,0,227,1,4,0,24,42,0,0,0,0,0,0,212,126,2,0,43,2,4,0,64,47,0,0,0,0,0,0,212,126,2,0,63,2,4,0,24,42,0,0,0,0,0,0,212,126,2,0,135,2,4,0,64,47,0,0,0,0,0,0,212,126,2,0,155,2,4,0,24,42,0,0,0,0,0,0,212,126,2,0,227,2,4,0,64,47,0,0,0,0,0,0,212,126,2,0,247,2,4,0,24,42,0,0,0,0,0,0,212,126,2,0,63,3,4,0,64,47,0,0,0,0,0,0,212,126,2,0,83,3,4,0,24,42,0,0,0,0,0,0,212,126,2,0,155,3,4,0,64,47,0,0,0,0,0,0,212,126,2,0,155,4,4,0,208,46,0,0,0,0,0,0,212,126,2,0,18,7,4,0,208,46,0,0,0,0,0,0,212,126,2,0,53,7,4,0,208,46,0,0,0,0,0,0,212,126,2,0,218,60,5,0,208,46,0,0,0,0,0,0,212,126,2,0,38,61,5,0,208,46,0,0,0,0,0,0,212,126,2,0,112,61,5,0,208,46,0,0,0,0,0,0,212,126,2,0,185,61,5,0,208,46,0,0,0,0,0,0,212,126,2,0,14,62,5,0,208,46,0,0,0,0,0,0,212,126,2,0,182,62,5,0,208,46,0,0,0,0,0,0,212,126,2,0,7,63,5,0,208,46,0,0,0,0,0,0,212,126,2,0,86,63,5,0,208,46,0,0,0,0,0,0,212,126,2,0,164,63,5,0,208,46,0,0,0,0,0,0,212,126,2,0,254,63,5,0,208,46,0,0,0,0,0,0,212,126,2,0,238,65,5,0,208,46,0,0,0,0,0,0,212,126,2,0,168,66,5,0,208,46,0,0,0,0,0,0,212,126,2,0,96,67,5,0,208,46,0,0,0,0,0,0,212,126,2,0,167,68,5,0,208,46,0,0,0,0,0,0,212,126,2,0,166,69,5,0,208,46,0,0,0,0,0,0,212,126,2,0,176,70,5,0,208,46,0,0,0,0,0,0,212,126,2,0,93,71,5,0,208,46,0,0,0,0,0,0,212,126,2,0,8,72,5,0,208,46,0,0,0,0,0,0,212,126,2,0,16,73,5,0,208,46,0,0,0,0,0,0,212,126,2,0,205,73,5,0,208,46,0,0,0,0,0,0,212,126,2,0,136,74,5,0,208,46,0,0,0,0,0,0,212,126,2,0,129,75,5,0,208,46,0,0,0,0,0,0,212,126,2,0,121,76,5,0,208,46,0,0,0,0,0,0,212,126,2,0,142,77,5,0,208,46,0,0,0,0,0,0,212,126,2,0,168,78,5,0,208,46,0,0,0,0,0,0,212,126,2,0,108,88,5,0,24,42,0,0,0,0,0,0,212,126,2,0,216,88,5,0,64,47,0,0,0,0,0,0,212,126,2,0,16,89,5,0,24,42,0,0,0,0,0,0,212,126,2,0,124,89,5,0,64,47,0,0,0,0,0,0,212,126,2,0,180,89,5,0,24,42,0,0,0,0,0,0,212,126,2,0,32,90,5,0,64,47,0,0,0,0,0,0,212,126,2,0,88,90,5,0,24,42,0,0,0,0,0,0,212,126,2,0,196,90,5,0,64,47,0,0,0,0,0,0,212,126,2,0,252,90,5,0,24,42,0,0,0,0,0,0,212,126,2,0,104,91,5,0,64,47,0,0,0,0,0,0,212,126,2,0,160,91,5,0,24,42,0,0,0,0,0,0,212,126,2,0,12,92,5,0,64,47,0,0,0,0,0,0,212,126,2,0,68,92,5,0,24,42,0,0,0,0,0,0,212,126,2,0,176,92,5,0,64,47,0,0,0,0,0,0,212,126,2,0,232,92,5,0,24,42,0,0,0,0,0,0,212,126,2,0,84,93,5,0,64,47,0,0,0,0,0,0,212,126,2,0,140,93,5,0,24,42,0,0,0,0,0,0,212,126,2,0,248,93,5,0,64,47,0,0,0,0,0,0,212,126,2,0,48,94,5,0,24,42,0,0,0,0,0,0,212,126,2,0,156,94,5,0,64,47,0,0,0,0,0,0,212,126,2,0,238,94,5,0,24,42,0,0,0,0,0,0,212,126,2,0,96,95,5,0,72,47,0,0,0,0,0,0,212,126,2,0,158,95,5,0,24,42,0,0,0,0,0,0,212,126,2,0,16,96,5,0,72,47,0,0,0,0,0,0,212,126,2,0,78,96,5,0,24,42,0,0,0,0,0,0,212,126,2,0,192,96,5,0,72,47,0,0,0,0,0,0,212,126,2,0,254,96,5,0,24,42,0,0,0,0,0,0,212,126,2,0,112,97,5,0,72,47,0,0,0,0,0,0,212,126,2,0,174,97,5,0,24,42,0,0,0,0,0,0,212,126,2,0,32,98,5,0,72,47,0,0,0,0,0,0,212,126,2,0,94,98,5,0,24,42,0,0,0,0,0,0,212,126,2,0,208,98,5,0,72,47,0,0,0,0,0,0,212,126,2,0,14,99,5,0,24,42,0,0,0,0,0,0,212,126,2,0,128,99,5,0,72,47,0,0,0,0,0,0,212,126,2,0,190,99,5,0,24,42,0,0,0,0,0,0,212,126,2,0,48,100,5,0,72,47,0,0,0,0,0,0,212,126,2,0,110,100,5,0,24,42,0,0,0,0,0,0,212,126,2,0,224,100,5,0,72,47,0,0,0,0,0,0,212,126,2,0,30,101,5,0,24,42,0,0,0,0,0,0,212,126,2,0,144,101,5,0,72,47,0,0,0,0,0,0,212,126,2,0,113,102,5,0,24,42,0,0,0,0,0,0,212,126,2,0,251,102,5,0,80,47,0,0,0,0,0,0,212,126,2,0,45,103,5,0,24,42,0,0,0,0,0,0,212,126,2,0,147,103,5,0,80,47,0,0,0,0,0,0,212,126,2,0,197,103,5,0,24,42,0,0,0,0,0,0,212,126,2,0,43,104,5,0,80,47,0,0,0,0,0,0,212,126,2,0,93,104,5,0,24,42,0,0,0,0,0,0,212,126,2,0,195,104,5,0,80,47,0,0,0,0,0,0,212,126,2,0,245,104,5,0,24,42,0,0,0,0,0,0,212,126,2,0,91,105,5,0,80,47,0,0,0,0,0,0,212,126,2,0,141,105,5,0,24,42,0,0,0,0,0,0,212,126,2,0,243,105,5,0,80,47,0,0,0,0,0,0,212,126,2,0,37,106,5,0,24,42,0,0,0,0,0,0,212,126,2,0,139,106,5,0,80,47,0,0,0,0,0,0,212,126,2,0,189,106,5,0,24,42,0,0,0,0,0,0,212,126,2,0,35,107,5,0,80,47,0,0,0,0,0,0,212,126,2,0,85,107,5,0,24,42,0,0,0,0,0,0,212,126,2,0,187,107,5,0,80,47,0,0,0,0,0,0,212,126,2,0,237,107,5,0,24,42,0,0,0,0,0,0,212,126,2,0,83,108,5,0,80,47,0,0,0,0,0,0,212,126,2,0,120,112,5,0,208,46,0,0,0,0,0,0,212,126,2,0,56,113,5,0,208,46,0,0,0,0,0,0,212,126,2,0,246,113,5,0,208,46,0,0,0,0,0,0,212,126,2,0,71,115,5,0,208,46,0,0,0,0,0,0,212,126,2,0,7,116,5,0,208,46,0,0,0,0,0,0,212,126,2,0,197,116,5,0,208,46,0,0,0,0,0,0,212,126,2,0,192,117,5,0,208,46,0,0,0,0,0,0,212,126,2,0,92,118,5,0,208,46,0,0,0,0,0,0,212,126,2,0,196,119,5,0,208,46,0,0,0,0,0,0,212,126,2,0,200,120,5,0,208,46,0,0,0,0,0,0,212,126,2,0,87,122,5,0,208,46,0,0,0,0,0,0,212,126,2,0,243,122,5,0,208,46,0,0,0,0,0,0,212,126,2,0,156,123,5,0,208,46,0,0,0,0,0,0,212,126,2,0,56,124,5,0,208,46,0,0,0,0,0,0,212,126,2,0,22,133,5,0,208,46,0,0,0,0,0,0,212,126,2,0,80,133,5,0,208,46,0,0,0,0,0,0,212,126,2,0,139,133,5,0,208,46,0,0,0,0,0,0,212,126,2,0,177,133,5,0,208,46,0,0,0,0,0,0,212,126,2,0,38,137,5,0,24,42,0,0,0,0,0,0,212,126,2,0,47,140,5,0,208,46,0,0,0,0,0,0,212,126,2,0,67,140,5,0,208,46,0,0,0,0,0,0,212,126,2,0,77,142,5,0,208,46,0,0,0,0,0,0,212,126,2,0,20,143,5,0,208,46,0,0,0,0,0,0,212,126,2,0,217,143,5,0,208,46,0,0,0,0,0,0,212,126,2,0,55,145,5,0,208,46,0,0,0,0,0,0,212,126,2,0,254,145,5,0,208,46,0,0,0,0,0,0,212,126,2,0,195,146,5,0,208,46,0,0,0,0,0,0,212,126,2,0,149,147,5,0,208,46,0,0,0,0,0,0,212,126,2,0,191,147,5,0,208,46,0,0,0,0,0,0,212,126,2,0,233,147,5,0,208,46,0,0,0,0,0,0,212,126,2,0,19,148,5,0,208,46,0,0,0,0,0,0,212,126,2,0,61,148,5,0,208,46,0,0,0,0,0,0,212,126,2,0,101,148,5,0,208,46,0,0,0,0,0,0,212,126,2,0,141,148,5,0,208,46,0,0,0,0,0,0,212,126,2,0,181,148,5,0,208,46,0,0,0,0,0,0,212,126,2,0,202,149,5,0,208,46,0,0,0,0,0,0,212,126,2,0,239,149,5,0,208,46,0,0,0,0,0,0,212,126,2,0,20,150,5,0,208,46,0,0,0,0,0,0,212,126,2,0,55,150,5,0,208,46,0,0,0,0,0,0,212,126,2,0,192,150,5,0,208,46,0,0,0,0,0,0,212,126,2,0,88,151,5,0,208,46,0,0,0,0,0,0,212,126,2,0,133,151,5,0,208,46,0,0,0,0,0,0,212,126,2,0,178,151,5,0,208,46,0,0,0,0,0,0,212,126,2,0,223,151,5,0,208,46,0,0,0,0,0,0,212,126,2,0,12,152,5,0,208,46,0,0,0,0,0,0,212,126,2,0,57,152,5,0,208,46,0,0,0,0,0,0,212,126,2,0,102,152,5,0,208,46,0,0,0,0,0,0,212,126,2,0,145,152,5,0,208,46,0,0,0,0,0,0,212,126,2,0,188,152,5,0,208,46,0,0,0,0,0,0,212,126,2,0,231,152,5,0,208,46,0,0,0,0,0,0,212,126,2,0,18,153,5,0,208,46,0,0,0,0,0,0,212,126,2,0,61,153,5,0,208,46,0,0,0,0,0,0,212,126,2,0,114,159,5,0,208,46,0,0,0,0,0,0,212,126,2,0,14,160,5,0,208,46,0,0,0,0,0,0,212,126,2,0,170,160,5,0,208,46,0,0,0,0,0,0,212,126,2,0,70,161,5,0,208,46,0,0,0,0,0,0,212,126,2,0,74,162,5,0,208,46,0,0,0,0,0,0,212,126,2,0,230,162,5,0,208,46,0,0,0,0,0,0,212,126,2,0,130,163,5,0,208,46,0,0,0,0,0,0,212,126,2,0,30,164,5,0,208,46,0,0,0,0,0,0,172,126,2,0,206,165,5,0,212,126,2,0,178,164,5,0,24,42,0,0,0,0,0,0,212,126,2,0,118,168,5,0,176,69,0,0,0,0,0,0,212,126,2,0,55,167,5,0,24,42,0,0,0,0,0,0,212,126,2,0,134,167,5,0,24,42,0,0,0,0,0,0,212,126,2,0,0,168,5,0,24,42,0,0,0,0,0,0,212,126,2,0,208,169,5,0,176,69,0,0,0,0,0,0,212,126,2,0,149,168,5,0,24,42,0,0,0,0,0,0,212,126,2,0,221,168,5,0,24,42,0,0,0,0,0,0,212,126,2,0,86,169,5,0,24,42,0,0,0,0,0,0,212,126,2,0,5,179,5,0,120,70,0,0,0,0,0,0,212,126,2,0,123,174,5,0,208,46,0,0,0,0,0,0,212,126,2,0,222,177,5,0,24,42,0,0,0,0,0,0,212,126,2,0,34,179,5,0,112,41,0,0,0,0,0,0,212,126,2,0,179,179,5,0,24,42,0,0,0,0,0,0,172,126,2,0,183,181,5,0,172,126,2,0,16,190,5,0,212,126,2,0,78,182,5,0,208,46,0,0,0,0,0,0,212,126,2,0,174,186,5,0,208,46,0,0,0,0,0,0,212,126,2,0,131,202,5,0,208,46,0,0,0,0,0,0,212,126,2,0,12,203,5,0,208,46,0,0,0,0,0,0,212,126,2,0,56,203,5,0,24,42,0,0,0,0,0,0,212,126,2,0,153,215,5,0,200,37,0,0,0,0,0,0,212,126,2,0,202,213,5,0,208,46,0,0,0,0,0,0,212,126,2,0,189,215,5,0,24,42,0,0,0,0,0,0,212,126,2,0,210,216,5,0,208,46,0,0,0,0,0,0,212,126,2,0,201,217,5,0,24,42,0,0,0,0,0,0,212,126,2,0,182,221,5,0,88,71,0,0,0,0,0,0,212,126,2,0,230,221,5,0,104,71,0,0,0,0,0,0,212,126,2,0,4,222,5,0,112,41,0,0,0,0,0,0,212,126,2,0,181,223,5,0,24,42,0,0,0,0,0,0,212,126,2,0,105,225,5,0,152,71,0,0,0,0,0,0,212,126,2,0,151,225,5,0,168,71,0,0,0,0,0,0,212,126,2,0,179,225,5,0,112,41,0,0,0,0,0,0,212,126,2,0,145,228,5,0,104,92,0,0,0,0,0,0,108,0,0,0,0,0,0,0,40,98,0,0,11,0,0,0,12,0,0,0,148,255,255,255,148,255,255,255,40,98,0,0,13,0,0,0,14,0,0,0,212,126,2,0,4,244,5,0,24,98,0,0,0,0,0,0,212,126,2,0,51,244,5,0,40,98,0,0,0,0,0,0,132,127,2,0,212,254,5,0,0,0,0,0,1,0,0,0,40,72,0,0,0,0,0,0,172,126,2,0,78,255,5,0,212,126,2,0,23,4,6,0,24,42,0,0,0,0,0,0,172,126,2,0,236,3,6,0,212,126,2,0,232,4,6,0,64,72,0,0,0,0,0,0,212,126,2,0,34,5,6,0,24,42,0,0,0,0,0,0,212,126,2,0,244,6,6,0,64,72,0,0,0,0,0,0,212,126,2,0,47,7,6,0,24,42,0,0,0,0,0,0,212,126,2,0,172,7,6,0,64,72,0,0,0,0,0,0,212,126,2,0,230,7,6,0,24,42,0,0,0,0,0,0,212,126,2,0,160,8,6,0,64,72,0,0,0,0,0,0,212,126,2,0,226,8,6,0,24,42,0,0,0,0,0,0,212,126,2,0,140,9,6,0,64,72,0,0,0,0,0,0,212,126,2,0,207,9,6,0,24,42,0,0,0,0,0,0,212,126,2,0,88,10,6,0,64,72,0,0,0,0,0,0,212,126,2,0,143,10,6,0,24,42,0,0,0,0,0,0,212,126,2,0,251,10,6,0,64,72,0,0,0,0,0,0,212,126,2,0,51,11,6,0,24,42,0,0,0,0,0,0,212,126,2,0,171,11,6,0,64,72,0,0,0,0,0,0,212,126,2,0,225,11,6,0,24,42,0,0,0,0,0,0,212,126,2,0,97,12,6,0,64,72,0,0,0,0,0,0,212,126,2,0,153,12,6,0,24,42,0,0,0,0,0,0,212,126,2,0,5,13,6,0,64,72,0,0,0,0,0,0,212,126,2,0,61,13,6,0,24,42,0,0,0,0,0,0,212,126,2,0,164,13,6,0,64,72,0,0,0,0,0,0,212,126,2,0,215,13,6,0,24,42,0,0,0,0,0,0,212,126,2,0,40,15,6,0,64,72,0,0,0,0,0,0,212,126,2,0,100,15,6,0,24,42,0,0,0,0,0,0,212,126,2,0,108,16,6,0,64,72,0,0,0,0,0,0,212,126,2,0,116,25,6,0,24,42,0,0,0,0,0,0,212,126,2,0,78,27,6,0,24,42,0,0,0,0,0,0,212,126,2,0,101,35,6,0,24,98,0,0,0,0,0,0,212,126,2,0,44,37,6,0,112,41,0,0,0,0,0,0,172,126,2,0,84,37,6,0,212,126,2,0,57,41,6,0,24,42,0,0,0,0,0,0,212,126,2,0,177,41,6,0,24,42,0,0,0,0,0,0,212,126,2,0,218,43,6,0,8,74,0,0,0,0,0,0,212,126,2,0,199,49,6,0,24,74,0,0,0,0,0,0,212,126,2,0,157,58,6,0,8,74,0,0,0,0,0,0,212,126,2,0,109,58,6,0,8,74,0,0,0,0,0,0,212,126,2,0,1,58,6,0,192,74,0,0,0,0,0,0,212,126,2,0,244,56,6,0,8,74,0,0,0,0,0,0,212,126,2,0,197,56,6,0,8,74,0,0,0,0,0,0,212,126,2,0,114,57,6,0,24,42,0,0,0,0,0,0,212,126,2,0,53,58,6,0,8,74,0,0,0,0,0,0,212,126,2,0,225,76,6,0,112,95,0,0,0,0,0,0,212,126,2,0,39,74,6,0,96,75,0,0,0,0,0,0,212,126,2,0,17,71,6,0,112,95,0,0,0,0,0,0,172,126,2,0,46,71,6,0,212,126,2,0,170,73,6,0,88,75,0,0,0,0,0,0,212,126,2,0,171,71,6,0,112,95,0,0,0,0,0,0,212,126,2,0,196,71,6,0,56,75,0,0,0,0,0,0,212,126,2,0,244,71,6,0,72,75,0,0,0,0,0,0,212,126,2,0,198,72,6,0,112,95,0,0,0,0,0,0,172,126,2,0,222,73,6,0,212,126,2,0,249,74,6,0,40,95,0,0,0,0,0,0,212,126,2,0,236,75,6,0,40,75,0,0,0,0,0,0,212,126,2,0,54,82,6,0,112,95,0,0,0,0,0,0,212,126,2,0,176,88,6,0,112,95,0,0,0,0,0,0,212,126,2,0,90,86,6,0,96,75,0,0,0,0,0,0,212,126,2,0,47,86,6,0,208,75,0,0,0,0,0,0,212,126,2,0,131,84,6,0,112,95,0,0,0,0,0,0,212,126,2,0,98,85,6,0,192,75,0,0,0,0,0,0,212,126,2,0,153,88,6,0,112,95,0,0,0,0,0,0,212,126,2,0,169,87,6,0,176,75,0,0,0,0,0,0,212,126,2,0,78,90,6,0,112,95,0,0,0,0,0,0,212,126,2,0,8,90,6,0,112,95,0,0,0,0,0,0,212,126,2,0,233,173,6,0,112,95,0,0,0,0,0,0,212,126,2,0,103,164,6,0,112,95,0,0,0,0,0,0,212,126,2,0,143,164,6,0,112,95,0,0,0,0,0,0,212,126,2,0,179,164,6,0,112,95,0,0,0,0,0,0,212,126,2,0,217,164,6,0,112,95,0,0,0,0,0,0,212,126,2,0,28,165,6,0,112,95,0,0,0,0,0,0,212,126,2,0,250,164,6,0,112,95,0,0,0,0,0,0,212,126,2,0,126,165,6,0,112,95,0,0,0,0,0,0,212,126,2,0,61,165,6,0,112,95,0,0,0,0,0,0,212,126,2,0,99,165,6,0,112,95,0,0,0,0,0,0,212,126,2,0,198,169,6,0,112,95,0,0,0,0,0,0,212,126,2,0,161,165,6,0,112,95,0,0,0,0,0,0,212,126,2,0,193,165,6,0,112,95,0,0,0,0,0,0,212,126,2,0,224,165,6,0,112,95,0,0,0,0,0,0,212,126,2,0,11,166,6,0,112,95,0,0,0,0,0,0,212,126,2,0,46,166,6,0,112,95,0,0,0,0,0,0,212,126,2,0,81,166,6,0,112,95,0,0,0,0,0,0,212,126,2,0,113,166,6,0,112,95,0,0,0,0,0,0,212,126,2,0,155,166,6,0,112,95,0,0,0,0,0,0,212,126,2,0,186,166,6,0,112,95,0,0,0,0,0,0,212,126,2,0,219,166,6,0,112,95,0,0,0,0,0,0,212,126,2,0,251,166,6,0,112,95,0,0,0,0,0,0,212,126,2,0,32,167,6,0,112,95,0,0,0,0,0,0,212,126,2,0,68,167,6,0,112,95,0,0,0,0,0,0,212,126,2,0,105,167,6,0,112,95,0,0,0,0,0,0,212,126,2,0,142,167,6,0,112,95,0,0,0,0,0,0,212,126,2,0,177,167,6,0,112,95,0,0,0,0,0,0,212,126,2,0,211,167,6,0,112,95,0,0,0,0,0,0,212,126,2,0,249,167,6,0,112,95,0,0,0,0,0,0,212,126,2,0,26,168,6,0,112,95,0,0,0,0,0,0,212,126,2,0,64,168,6,0,112,95,0,0,0,0,0,0,212,126,2,0,99,168,6,0,112,95,0,0,0,0,0,0,212,126,2,0,130,168,6,0,112,95,0,0,0,0,0,0,212,126,2,0,170,168,6,0,112,95,0,0,0,0,0,0,212,126,2,0,210,168,6,0,112,95,0,0,0,0,0,0,212,126,2,0,247,168,6,0,112,95,0,0,0,0,0,0,212,126,2,0,27,169,6,0,112,95,0,0,0,0,0,0,212,126,2,0,62,169,6,0,112,95,0,0,0,0,0,0,212,126,2,0,94,169,6,0,112,95,0,0,0,0,0,0,212,126,2,0,133,169,6,0,112,95,0,0,0,0,0,0,212,126,2,0,167,169,6,0,112,95,0,0,0,0,0,0,212,126,2,0,233,169,6,0,112,95,0,0,0,0,0,0,212,126,2,0,8,170,6,0,112,95,0,0,0,0,0,0,212,126,2,0,40,170,6,0,112,95,0,0,0,0,0,0,212,126,2,0,73,170,6,0,112,95,0,0,0,0,0,0,212,126,2,0,108,170,6,0,112,95,0,0,0,0,0,0,212,126,2,0,145,170,6,0,112,95,0,0,0,0,0,0,212,126,2,0,182,170,6,0,112,95,0,0,0,0,0,0,212,126,2,0,216,170,6,0,112,95,0,0,0,0,0,0,212,126,2,0,253,170,6,0,112,95,0,0,0,0,0,0,212,126,2,0,28,171,6,0,112,95,0,0,0,0,0,0,212,126,2,0,61,171,6,0,112,95,0,0,0,0,0,0,212,126,2,0,96,171,6,0,112,95,0,0,0,0,0,0,212,126,2,0,129,171,6,0,112,95,0,0,0,0,0,0,212,126,2,0,160,171,6,0,112,95,0,0,0,0,0,0,212,126,2,0,198,171,6,0,112,95,0,0,0,0,0,0,212,126,2,0,247,171,6,0,112,95,0,0,0,0,0,0,212,126,2,0,23,172,6,0,112,95,0,0,0,0,0,0,212,126,2,0,55,172,6,0,112,95,0,0,0,0,0,0,212,126,2,0,18,173,6,0,112,95,0,0,0,0,0,0,212,126,2,0,92,172,6,0,112,95,0,0,0,0,0,0,212,126,2,0,128,172,6,0,112,95,0,0,0,0,0,0,212,126,2,0,169,172,6],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+10240);allocate([112,95,0,0,0,0,0,0,212,126,2,0,204,172,6,0,112,95,0,0,0,0,0,0,212,126,2,0,247,172,6,0,112,95,0,0,0,0,0,0,212,126,2,0,51,173,6,0,112,95,0,0,0,0,0,0,212,126,2,0,77,173,6,0,112,95,0,0,0,0,0,0,212,126,2,0,142,173,6,0,112,95,0,0,0,0,0,0,212,126,2,0,111,173,6,0,112,95,0,0,0,0,0,0,212,126,2,0,176,173,6,0,112,95,0,0,0,0,0,0,212,126,2,0,199,173,6,0,112,95,0,0,0,0,0,0,212,126,2,0,17,181,6,0,24,42,0,0,0,0,0,0,212,126,2,0,183,183,6,0,192,80,0,0,0,0,0,0,212,126,2,0,223,182,6,0,208,46,0,0,0,0,0,0,212,126,2,0,231,183,6,0,96,74,0,0,0,0,0,0,212,126,2,0,73,184,6,0,24,42,0,0,0,0,0,0,212,126,2,0,45,186,6,0,0,81,0,0,0,0,0,0,212,126,2,0,82,185,6,0,208,46,0,0,0,0,0,0,212,126,2,0,94,186,6,0,96,74,0,0,0,0,0,0,212,126,2,0,140,186,6,0,24,42,0,0,0,0,0,0,212,126,2,0,106,188,6,0,64,81,0,0,0,0,0,0,212,126,2,0,146,187,6,0,208,46,0,0,0,0,0,0,212,126,2,0,154,188,6,0,96,74,0,0,0,0,0,0,212,126,2,0,198,188,6,0,24,42,0,0,0,0,0,0,212,126,2,0,182,190,6,0,128,81,0,0,0,0,0,0,212,126,2,0,213,189,6,0,208,46,0,0,0,0,0,0,212,126,2,0,233,190,6,0,96,74,0,0,0,0,0,0,212,126,2,0,25,191,6,0,24,42,0,0,0,0,0,0,212,126,2,0,241,192,6,0,192,81,0,0,0,0,0,0,212,126,2,0,28,192,6,0,208,46,0,0,0,0,0,0,212,126,2,0,32,193,6,0,96,74,0,0,0,0,0,0,212,126,2,0,75,193,6,0,24,42,0,0,0,0,0,0,212,126,2,0,53,195,6,0,0,82,0,0,0,0,0,0,212,126,2,0,87,194,6,0,208,46,0,0,0,0,0,0,212,126,2,0,103,195,6,0,96,74,0,0,0,0,0,0,212,126,2,0,146,195,6,0,24,42,0,0,0,0,0,0,212,126,2,0,112,197,6,0,64,82,0,0,0,0,0,0,212,126,2,0,152,196,6,0,208,46,0,0,0,0,0,0,212,126,2,0,160,197,6,0,96,74,0,0,0,0,0,0,212,126,2,0,216,197,6,0,24,42,0,0,0,0,0,0,212,126,2,0,188,199,6,0,128,82,0,0,0,0,0,0,212,126,2,0,225,198,6,0,208,46,0,0,0,0,0,0,212,126,2,0,237,199,6,0,96,74,0,0,0,0,0,0,212,126,2,0,52,200,6,0,24,42,0,0,0,0,0,0,212,126,2,0,176,202,6,0,192,82,0,0,0,0,0,0,212,126,2,0,189,201,6,0,208,46,0,0,0,0,0,0,212,126,2,0,233,202,6,0,96,74,0,0,0,0,0,0,212,126,2,0,31,203,6,0,24,42,0,0,0,0,0,0,212,126,2,0,228,205,6,0,240,82,0,0,0,0,0,0,212,126,2,0,1,206,6,0,8,74,0,0,0,0,0,0,212,126,2,0,50,206,6,0,24,42,0,0,0,0,0,0,212,126,2,0,86,210,6,0,48,83,0,0,0,0,0,0,212,126,2,0,174,209,6,0,208,46,0,0,0,0,0,0,212,126,2,0,121,210,6,0,8,74,0,0,0,0,0,0,212,126,2,0,174,210,6,0,24,42,0,0,0,0,0,0,212,126,2,0,130,212,6,0,96,83,0,0,0,0,0,0,212,126,2,0,164,212,6,0,8,74,0,0,0,0,0,0,212,126,2,0,218,212,6,0,24,42,0,0,0,0,0,0,212,126,2,0,244,215,6,0,160,74,0,0,0,0,0,0,212,126,2,0,86,215,6,0,208,46,0,0,0,0,0,0,212,126,2,0,15,216,6,0,24,42,0,0,0,0,0,0,212,126,2,0,240,218,6,0,192,83,0,0,0,0,0,0,212,126,2,0,11,219,6,0,8,74,0,0,0,0,0,0,212,126,2,0,58,219,6,0,24,42,0,0,0,0,0,0,212,126,2,0,137,219,6,0,176,83,0,0,0,0,0,0,212,126,2,0,164,219,6,0,24,42,0,0,0,0,0,0,212,126,2,0,129,221,6,0,16,84,0,0,0,0,0,0,212,126,2,0,164,221,6,0,8,74,0,0,0,0,0,0,212,126,2,0,219,221,6,0,24,42,0,0,0,0,0,0,212,126,2,0,22,224,6,0,64,84,0,0,0,0,0,0,212,126,2,0,50,224,6,0,8,74,0,0,0,0,0,0,212,126,2,0,98,224,6,0,24,42,0,0,0,0,0,0,212,126,2,0,182,228,6,0,112,74,0,0,0,0,0,0,212,126,2,0,12,227,6,0,208,46,0,0,0,0,0,0,212,126,2,0,210,228,6,0,24,42,0,0,0,0,0,0,212,126,2,0,188,230,6,0,160,84,0,0,0,0,0,0,212,126,2,0,216,230,6,0,8,74,0,0,0,0,0,0,212,126,2,0,8,231,6,0,24,42,0,0,0,0,0,0,212,126,2,0,174,233,6,0,208,84,0,0,0,0,0,0,212,126,2,0,201,233,6,0,8,74,0,0,0,0,0,0,212,126,2,0,123,234,6,0,24,42,0,0,0,0,0,0,212,126,2,0,161,235,6,0,0,85,0,0,0,0,0,0,212,126,2,0,187,235,6,0,8,74,0,0,0,0,0,0,212,126,2,0,233,235,6,0,24,42,0,0,0,0,0,0,212,126,2,0,111,238,6,0,48,85,0,0,0,0,0,0,212,126,2,0,141,238,6,0,8,74,0,0,0,0,0,0,212,126,2,0,191,238,6,0,24,42,0,0,0,0,0,0,212,126,2,0,212,240,6,0,96,85,0,0,0,0,0,0,212,126,2,0,238,240,6,0,8,74,0,0,0,0,0,0,212,126,2,0,28,241,6,0,24,42,0,0,0,0,0,0,212,126,2,0,221,241,6,0,8,74,0,0,0,0,0,0,212,126,2,0,121,244,6,0,128,85,0,0,0,0,0,0,212,126,2,0,149,244,6,0,24,42,0,0,0,0,0,0,212,126,2,0,41,247,6,0,208,85,0,0,0,0,0,0,212,126,2,0,155,246,6,0,208,46,0,0,0,0,0,0,212,126,2,0,65,247,6,0,8,74,0,0,0,0,0,0,212,126,2,0,108,247,6,0,24,42,0,0,0,0,0,0,212,126,2,0,75,251,6,0,0,86,0,0,0,0,0,0,212,126,2,0,104,251,6,0,8,74,0,0,0,0,0,0,212,126,2,0,153,251,6,0,24,42,0,0,0,0,0,0,212,126,2,0,38,253,6,0,48,86,0,0,0,0,0,0,212,126,2,0,62,253,6,0,8,74,0,0,0,0,0,0,212,126,2,0,105,253,6,0,24,42,0,0,0,0,0,0,212,126,2,0,2,2,7,0,144,74,0,0,0,0,0,0,212,126,2,0,88,1,7,0,208,46,0,0,0,0,0,0,212,126,2,0,30,2,7,0,24,42,0,0,0,0,0,0,212,126,2,0,42,6,7,0,144,86,0,0,0,0,0,0,212,126,2,0,72,6,7,0,96,74,0,0,0,0,0,0,212,126,2,0,122,6,7,0,24,42,0,0,0,0,0,0,212,126,2,0,8,9,7,0,192,86,0,0,0,0,0,0,212,126,2,0,42,9,7,0,8,74,0,0,0,0,0,0,212,126,2,0,96,9,7,0,24,42,0,0,0,0,0,0,212,126,2,0,31,12,7,0,240,86,0,0,0,0,0,0,212,126,2,0,57,12,7,0,8,74,0,0,0,0,0,0,212,126,2,0,204,14,7,0,24,42,0,0,0,0,0,0,212,126,2,0,247,20,7,0,32,87,0,0,0,0,0,0,212,126,2,0,27,21,7,0,8,74,0,0,0,0,0,0,212,126,2,0,83,21,7,0,24,42,0,0,0,0,0,0,212,126,2,0,216,22,7,0,8,74,0,0,0,0,0,0,212,126,2,0,240,24,7,0,64,87,0,0,0,0,0,0,212,126,2,0,10,25,7,0,24,42,0,0,0,0,0,0,212,126,2,0,71,28,7,0,128,87,0,0,0,0,0,0,212,126,2,0,99,28,7,0,8,74,0,0,0,0,0,0,212,126,2,0,147,28,7,0,24,42,0,0,0,0,0,0,212,126,2,0,70,33,7,0,192,87,0,0,0,0,0,0,212,126,2,0,145,32,7,0,208,46,0,0,0,0,0,0,212,126,2,0,98,33,7,0,8,74,0,0,0,0,0,0,212,126,2,0,146,33,7,0,24,42,0,0,0,0,0,0,212,126,2,0,125,40,7,0,0,88,0,0,0,0,0,0,212,126,2,0,48,38,7,0,208,46,0,0,0,0,0,0,212,126,2,0,157,40,7,0,128,74,0,0,0,0,0,0,212,126,2,0,77,41,7,0,24,42,0,0,0,0,0,0,212,126,2,0,190,43,7,0,0,88,0,0,0,0,0,0,212,126,2,0,232,42,7,0,208,46,0,0,0,0,0,0,212,126,2,0,25,43,7,0,208,46,0,0,0,0,0,0,212,126,2,0,230,43,7,0,8,74,0,0,0,0,0,0,212,126,2,0,18,44,7,0,24,42,0,0,0,0,0,0,212,126,2,0,147,49,7,0,80,88,0,0,0,0,0,0,212,126,2,0,172,49,7,0,24,42,0,0,0,0,0,0,212,126,2,0,86,50,7,0,8,74,0,0,0,0,0,0,212,126,2,0,84,52,7,0,144,88,0,0,0,0,0,0,212,126,2,0,109,52,7,0,24,42,0,0,0,0,0,0,212,126,2,0,99,54,7,0,208,88,0,0,0,0,0,0,212,126,2,0,125,54,7,0,8,74,0,0,0,0,0,0,212,126,2,0,229,62,7,0,112,95,0,0,0,0,0,0,212,126,2,0,139,57,7,0,112,95,0,0,0,0,0,0,212,126,2,0,201,62,7,0,112,95,0,0,0,0,0,0,212,126,2,0,168,62,7,0,112,95,0,0,0,0,0,0,212,126,2,0,48,60,7,0,96,75,0,0,0,0,0,0,212,126,2,0,252,59,7,0,80,89,0,0,0,0,0,0,212,126,2,0,62,58,7,0,112,95,0,0,0,0,0,0,212,126,2,0,38,59,7,0,64,89,0,0,0,0,0,0,212,126,2,0,175,61,7,0,48,89,0,0,0,0,0,0,212,126,2,0,213,68,7,0,112,95,0,0,0,0,0,0,212,126,2,0,17,68,7,0,112,95,0,0,0,0,0,0,212,126,2,0,252,67,7,0,112,95,0,0,0,0,0,0,212,126,2,0,19,67,7,0,112,95,0,0,0,0,0,0,212,126,2,0,146,67,7,0,112,95,0,0,0,0,0,0,212,126,2,0,244,69,7,0,112,95,0,0,0,0,0,0,49,244,70,62,15,206,131,63,254,130,43,101,71,21,87,64,0,0,0,0,0,0,144,63,0,0,0,0,0,0,240,63,97,128,119,62,154,44,240,63,116,133,21,211,176,89,240,63,200,155,117,24,69,135,240,63,15,137,249,108,88,181,240,63,162,209,211,50,236,227,240,63,81,91,18,208,1,19,241,63,224,45,169,174,154,66,241,63,123,81,125,60,184,114,241,63,117,203,111,235,91,163,241,63,170,185,104,49,135,212,241,63,214,140,98,136,59,6,242,63,56,98,117,110,122,56,242,63,221,124,226,101,69,107,242,63,225,222,31,245,157,158,242,63,11,3,228,166,133,210,242,63,21,183,49,10,254,6,243,63,255,22,100,178,8,60,243,63,203,169,58,55,167,113,243,63,247,159,229,52,219,167,243,63,34,52,18,76,166,222,243,63,42,46,247,33,10,22,244,63,45,137,97,96,8,78,244,63,208,60,193,181,162,134,244,63,39,42,54,213,218,191,244,63,167,44,157,118,178,249,244,63,130,79,157,86,43,52,245,63,218,39,181,54,71,111,245,63,41,84,72,221,7,171,245,63,72,33,173,21,111,231,245,63,133,85,58,176,126,36,246,63,37,34,85,130,56,98,246,63,205,59,127,102,158,160,246,63,47,26,101,60,178,223,246,63,116,95,236,232,117,31,247,63,201,103,66,86,235,95,247,63,135,1,235,115,20,161,247,63,98,78,207,54,243,226,247,63,19,206,76,153,137,37,248,63,237,146,68,155,217,104,248,63,219,160,42,66,229,172,248,63,54,119,21,153,174,241,248,63,229,197,205,176,55,55,249,63,80,78,222,159,130,125,249,63,144,240,163,130,145,196,249,63,101,229,93,123,102,12,250,63,93,37,62,178,3,85,250,63,191,253,121,85,107,158,250,63,173,211,90,153,159,232,250,63,251,21,79,184,162,51,251,63,71,94,251,242,118,127,251,63,210,193,75,144,30,204,251,63,156,82,133,221,155,25,252,63,75,209,87,46,241,103,252,63,105,144,239,220,32,183,252,63,124,137,7,74,45,7,253,63,135,164,251,220,24,88,253,63,133,50,219,3,230,169,253,63,95,155,123,51,151,252,253,63,246,63,139,231,46,80,254,63,218,144,164,162,175,164,254,63,39,90,97,238,27,250,254,63,64,69,110,91,118,80,255,63,216,144,158,129,193,167,255,63,239,57,250,254,66,46,230,63,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,212,126,2,0,118,81,7,0,16,92,0,0,0,0,0,0,172,126,2,0,158,81,7,0,212,126,2,0,201,81,7,0,144,97,0,0,0,0,0,0,212,126,2,0,133,82,7,0,144,97,0,0,0,0,0,0,212,126,2,0,223,83,7,0,16,92,0,0,0,0,0,0,172,126,2,0,16,84,7,0,172,126,2,0,188,84,7,0,212,126,2,0,251,87,7,0,120,103,0,0,0,0,0,0,172,126,2,0,30,88,7,0,212,126,2,0,57,88,7,0,104,92,0,0,0,0,0,0,172,126,2,0,198,91,7,0,212,126,2,0,116,112,7,0,248,96,0,0,0,0,0,0,212,126,2,0,199,112,7,0,0,95,0,0,0,0,0,0,212,126,2,0,88,114,7,0,104,92,0,0,0,0,0,0,212,126,2,0,88,129,7,0,104,92,0,0,0,0,0,0,212,126,2,0,176,130,7,0,104,92,0,0,0,0,0,0,212,126,2,0,62,131,7,0,104,92,0,0,0,0,0,0,212,126,2,0,145,159,7,0,112,95,0,0,0,0,0,0,212,126,2,0,163,155,7,0,112,95,0,0,0,0,0,0,212,126,2,0,114,155,7,0,112,95,0,0,0,0,0,0,212,126,2,0,245,155,7,0,112,95,0,0,0,0,0,0,212,126,2,0,201,155,7,0,112,95,0,0,0,0,0,0,212,126,2,0,73,156,7,0,112,95,0,0,0,0,0,0,212,126,2,0,24,156,7,0,112,95,0,0,0,0,0,0,212,126,2,0,113,156,7,0,112,95,0,0,0,0,0,0,212,126,2,0,147,156,7,0,112,95,0,0,0,0,0,0,212,126,2,0,182,156,7,0,112,95,0,0,0,0,0,0,212,126,2,0,219,156,7,0,112,95,0,0,0,0,0,0,212,126,2,0,251,156,7,0,112,95,0,0,0,0,0,0,212,126,2,0,28,157,7,0,112,95,0,0,0,0,0,0,212,126,2,0,61,157,7,0,112,95,0,0,0,0,0,0,212,126,2,0,96,157,7,0,112,95,0,0,0,0,0,0,212,126,2,0,128,157,7,0,112,95,0,0,0,0,0,0,212,126,2,0,170,157,7,0,112,95,0,0,0,0,0,0,212,126,2,0,213,157,7,0,112,95,0,0,0,0,0,0,212,126,2,0,60,158,7,0,112,95,0,0,0,0,0,0,212,126,2,0,2,158,7,0,112,95,0,0,0,0,0,0,212,126,2,0,100,158,7,0,112,95,0,0,0,0,0,0,212,126,2,0,141,158,7,0,112,95,0,0,0,0,0,0,212,126,2,0,182,158,7,0,112,95,0,0,0,0,0,0,212,126,2,0,69,159,7,0,112,95,0,0,0,0,0,0,212,126,2,0,224,158,7,0,112,95,0,0,0,0,0,0,212,126,2,0,18,159,7,0,112,95,0,0,0,0,0,0,212,126,2,0,105,159,7,0,112,95,0,0,0,0,0,0,172,126,2,0,183,159,7,0,212,126,2,0,222,159,7,0,152,94,0,0,0,0,0,0,212,126,2,0,232,161,7,0,112,95,0,0,0,0,0,0,212,126,2,0,11,162,7,0,208,96,0,0,0,0,0,0,212,126,2,0,10,163,7,0,48,97,0,0,0,0,0,0,212,126,2,0,69,163,7,0,88,75,0,0,0,0,0,0,212,126,2,0,35,175,7,0,128,95,0,0,0,0,0,0,172,126,2,0,62,176,7,0,212,126,2,0,141,180,7,0,16,92,0,0,0,0,0,0,212,126,2,0,183,180,7,0,72,92,0,0,0,0,0,0,172,126,2,0,252,180,7,0,212,126,2,0,1,184,7,0,64,95,0,0,0,0,0,0,212,126,2,0,46,184,7,0,40,95,0,0,0,0,0,0,132,127,2,0,131,184,7,0,0,0,0,0,1,0,0,0,104,95,0,0,0,0,0,0,172,126,2,0,195,184,7,0,212,126,2,0,94,186,7,0,80,92,0,0,0,0,0,0,172,126,2,0,60,192,7,0,212,126,2,0,60,187,7,0,152,95,0,0,0,0,0,0,212,126,2,0,121,187,7,0,168,95,0,0,0,0,0,0,212,126,2,0,189,187,7,0,184,95,0,0,0,0,0,0,172,126,2,0,252,187,7,0,212,126,2,0,47,188,7,0,168,95,0,0,0,0,0,0,212,126,2,0,93,188,7,0,224,95,0,0,0,0,0,0,212,126,2,0,153,188,7,0,168,95,0,0,0,0,0,0,212,126,2,0,16,189,7,0,0,96,0,0,0,0,0,0,212,126,2,0,79,189,7,0,168,95,0,0,0,0,0,0,212,126,2,0,132,189,7,0,32,96,0,0,0,0,0,0,212,126,2,0,195,189,7,0,168,95,0,0,0,0,0,0,212,126,2,0,248,189,7,0,64,96,0,0,0,0,0,0,212,126,2,0,55,190,7,0,168,95,0,0,0,0,0,0,212,126,2,0,108,190,7,0,96,96,0,0,0,0,0,0,212,126,2,0,171,190,7,0,168,95,0,0,0,0,0,0,212,126,2,0,224,190,7,0,128,96,0,0,0,0,0,0,212,126,2,0,31,191,7,0,168,95,0,0,0,0,0,0,212,126,2,0,84,191,7,0,160,96,0,0,0,0,0,0,212,126,2,0,147,191,7,0,168,95,0,0,0,0,0,0,212,126,2,0,200,191,7,0,192,96,0,0,0,0,0,0,212,126,2,0,7,192,7,0,168,95,0,0,0,0,0,0,172,126,2,0,91,192,7,0,212,126,2,0,249,192,7,0,208,96,0,0,0,0,0,0,172,126,2,0,95,195,7,0,172,126,2,0,157,195,7,0,172,126,2,0,211,195,7,0,212,126,2,0,59,197,7,0,232,96,0,0,0,0,0,0,212,126,2,0,156,201,7,0,0,95,0,0,0,0,0,0,212,126,2,0,228,201,7,0,128,92,0,0,0,0,0,0,172,126,2,0,250,203,7,0,212,126,2,0,39,204,7,0,48,97,0,0,0,0,0,0,172,126,2,0,25,205,7,0,172,126,2,0,62,205,7,0,172,126,2,0,99,205,7,0,172,126,2,0,136,205,7,0,172,126,2,0,173,205,7,0,172,126,2,0,210,205,7,0,172,126,2,0,247,205,7,0,212,126,2,0,28,206,7,0,88,75,0,0,0,0,0,0,172,126,2,0,151,207,7,0,132,127,2,0,96,223,7,0,0,0,0,0,1,0,0,0,72,37,0,0,0,0,0,0,132,127,2,0,33,223,7,0,0,0,0,0,1,0,0,0,72,37,0,0,0,0,0,0,172,126,2,0,2,223,7,0,172,126,2,0,227,222,7,0,172,126,2,0,196,222,7,0,172,126,2,0,165,222,7,0,172,126,2,0,134,222,7,0,212,126,2,0,175,234,7,0,0,98,0,0,0,0,0,0,172,126,2,0,157,234,7,0,212,126,2,0,217,234,7,0,0,98,0,0,0,0,0,0,172,126,2,0,3,235,7,0,172,126,2,0,52,235,7,0,132,127,2,0,101,235,7,0,0,0,0,0,1,0,0,0,240,97,0,0,3,244,255,255,132,127,2,0,148,235,7,0,0,0,0,0,1,0,0,0,8,98,0,0,3,244,255,255,132,127,2,0,195,235,7,0,0,0,0,0,1,0,0,0,240,97,0,0,3,244,255,255,132,127,2,0,242,235,7,0,0,0,0,0,1,0,0,0,8,98,0,0,3,244,255,255,132,127,2,0,33,236,7,0,3,0,0,0,2,0,0,0,40,98,0,0,2,0,0,0,88,98,0,0,2,8,0,0,12,0,0,0,0,0,0,0,40,98,0,0,11,0,0,0,12,0,0,0,244,255,255,255,244,255,255,255,40,98,0,0,13,0,0,0,14,0,0,0,212,126,2,0,81,236,7,0,32,98,0,0,0,0,0,0,212,126,2,0,106,236,7,0,24,98,0,0,0,0,0,0,212,126,2,0,169,236,7,0,32,98,0,0,0,0,0,0,212,126,2,0,193,236,7,0,24,98,0,0,0,0,0,0,212,126,2,0,217,236,7,0,32,99,0,0,0,0,0,0,212,126,2,0,237,236,7,0,112,103,0,0,0,0,0,0,212,126,2,0,3,237,7,0,32,99,0,0,0,0,0,0,132,127,2,0,61,237,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,96,99,0,0,0,0,0,0,132,127,2,0,129,237,7,0,0,0,0,0,1,0,0,0,120,99,0,0,0,0,0,0,172,126,2,0,151,237,7,0,132,127,2,0,176,237,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,160,99,0,0,0,0,0,0,132,127,2,0,244,237,7,0,0,0,0,0,1,0,0,0,120,99,0,0,0,0,0,0,132,127,2,0,24,238,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,216,99,0,0,0,0,0,0,132,127,2,0,92,238,7,0,0,0,0,0,1,0,0,0,240,99,0,0,0,0,0,0,172,126,2,0,114,238,7,0,132,127,2,0,139,238,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,24,100,0,0,0,0,0,0,132,127,2,0,207,238,7,0,0,0,0,0,1,0,0,0,240,99,0,0,0,0,0,0,132,127,2,0,37,240,7,0,0,0,0,0,3,0,0,0,32,99,0,0,2,0,0,0,88,100,0,0,2,0,0,0,96,100,0,0,0,8,0,0,172,126,2,0,140,240,7,0,172,126,2,0,106,240,7,0,132,127,2,0,159,240,7,0,0,0,0,0,3,0,0,0,32,99,0,0,2,0,0,0,88,100,0,0,2,0,0,0,144,100,0,0,0,8,0,0,172,126,2,0,228,240,7,0,132,127,2,0,6,241,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,184,100,0,0,0,8,0,0,172,126,2,0,75,241,7,0,132,127,2,0,96,241,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,184,100,0,0,0,8,0,0,132,127,2,0,165,241,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,0,101,0,0,2,0,0,0,172,126,2,0,193,241,7,0,132,127,2,0,214,241,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,0,101,0,0,2,0,0,0,132,127,2,0,242,241,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,0,101,0,0,2,0,0,0,132,127,2,0,14,242,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,0,101,0,0,2,0,0,0,132,127,2,0,57,242,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,136,101,0,0,0,0,0,0,172,126,2,0,127,242,7,0,132,127,2,0,163,242,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,176,101,0,0,0,0,0,0,172,126,2,0,233,242,7,0,132,127,2,0,8,243,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,216,101,0,0,0,0,0,0,172,126,2,0,78,243,7,0,132,127,2,0,103,243,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,0,102,0,0,0,0,0,0,172,126,2,0,173,243,7,0,132,127,2,0,198,243,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,40,102,0,0,2,0,0,0,172,126,2,0,219,243,7,0,132,127,2,0,114,244,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,40,102,0,0,2,0,0,0,212,126,2,0,243,243,7,0,96,102,0,0,0,0,0,0,132,127,2,0,22,244,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,128,102,0,0,2,0,0,0,172,126,2,0,57,244,7,0,212,126,2,0,80,244,7,0,96,102,0,0,0,0,0,0,132,127,2,0,135,244,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,128,102,0,0,2,0,0,0,132,127,2,0,169,244,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,128,102,0,0,2,0,0,0,132,127,2,0,203,244,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,128,102,0,0,2,0,0,0,212,126,2,0,238,244,7,0,32,99,0,0,0,0,0,0,132,127,2,0,4,245,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,40,103,0,0,2,0,0,0,172,126,2,0,22,245,7,0,132,127,2,0,43,245,7,0,0,0,0,0,2,0,0,0,32,99,0,0,2,0,0,0,40,103,0,0,2,0,0,0,212,126,2,0,61,245,7,0,32,99,0,0,0,0,0,0,212,126,2,0,82,245,7,0,32,99,0,0,0,0,0,0,172,126,2,0,103,245,7,0,172,126,2,0,17,246,7,0,212,126,2,0,113,246,7,0,144,103,0,0,0,0,0,0,212,126,2,0,30,246,7,0,160,103,0,0,0,0,0,0,172,126,2,0,63,246,7,0,212,126,2,0,76,246,7,0,128,103,0,0,0,0,0,0,212,126,2,0,83,247,7,0,120,103,0,0,0,0,0,0,212,126,2,0,99,247,7,0,184,103,0,0,0,0,0,0,212,126,2,0,116,247,7,0,184,103,0,0,0,0,0,0,212,126,2,0,147,247,7,0,120,103,0,0,0,0,0,0,212,126,2,0,195,247,7,0,144,103,0,0,0,0,0,0,212,126,2,0,159,247,7,0,248,103,0,0,0,0,0,0,212,126,2,0,229,247,7,0,144,103,0,0,0,0,0,0,76,127,2,0,13,248,7,0,76,127,2,0,15,248,7,0,76,127,2,0,18,248,7,0,76,127,2,0,226,43,7,0,76,127,2,0,224,43,7,0,76,127,2,0,20,248,7,0,76,127,2,0,22,248,7,0,76,127,2,0,28,199,7,0,76,127,2,0,24,248,7,0,76,127,2,0,26,248,7,0,76,127,2,0,110,253,7,0,76,127,2,0,28,248,7,0,76,127,2,0,36,199,7,0,76,127,2,0,30,248,7,0,212,126,2,0,32,248,7,0,128,103,0,0,0,0,0,0,40,104,0,0,104,104,0,0,40,104,0,0,112,104,0,0,40,104,0,0,112,34,0,0,40,104,0,0,120,34,0,0,40,104,0,0,128,34,0,0,40,104,0,0,104,104,0,0,192,34,0,0,40,104,0,0,192,34,0,0,104,104,0,0,40,104,0,0,192,34,0,0,112,104,0,0,104,104,0,0,112,104,0,0,208,34,0,0,224,34,0,0,168,34,0,0,112,104,0,0,56,104,0,0,168,34,0,0,112,104,0,0,104,104,0,0,24,35,0,0,40,104,0,0,24,35,0,0,136,104,0,0,40,104,0,0,24,35,0,0,112,104,0,0,136,104,0,0,112,104,0,0,40,35,0,0,224,34,0,0,0,35,0,0,112,104,0,0,56,104,0,0,0,35,0,0,112,104,0,0,136,104,0,0,104,35,0,0,40,104,0,0,104,35,0,0,144,104,0,0,40,104,0,0,104,35,0,0,112,104,0,0,144,104,0,0,112,104,0,0,120,35,0,0,224,34,0,0,80,35,0,0,112,104,0,0,56,104,0,0,80,35,0,0,112,104,0,0,144,104,0,0,184,35,0,0,40,104,0,0,184,35,0,0,216,35,0,0,40,104,0,0,184,35,0,0,112,104,0,0,216,35,0,0,112,104,0,0,200,35,0,0,224,34,0,0,160,35,0,0,112,104,0,0,56,104,0,0,160,35,0,0,112,104,0,0,216,35,0,0,16,36,0,0,40,104,0,0,16,36,0,0,48,36,0,0,40,104,0,0,16,36,0,0,112,104,0,0,48,36,0,0,112,104,0,0,32,36,0,0,224,34,0,0,248,35,0,0,112,104,0,0,56,104,0,0,248,35,0,0,112,104,0,0,48,36,0,0,104,36,0,0,40,104,0,0,104,36,0,0,128,34,0,0,40,104,0,0,104,36,0,0,112,104,0,0,128,34,0,0,112,104,0,0,120,36,0,0,224,34,0,0,80,36,0,0,112,104,0,0,56,104,0,0,80,36,0,0,112,104,0,0,128,34,0,0,136,36,0,0,136,36,0,0,48,36,0,0,136,36,0,0,168,36,0,0,104,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,200,36,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,112,104,0,0,48,36,0,0,168,36,0,0,104,104,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,112,104,0,0,152,36,0,0,104,104,0,0,152,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,48,36,0,0,152,36,0,0,104,104,0,0,40,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,136,36,0,0,168,36,0,0,104,104,0,0,48,36,0,0,152,36,0,0,104,104,0,0,104,104,0,0,48,36,0,0,152,36,0,0,16,37,0,0,40,104,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,56,104,0,0,152,36,0,0,112,104,0,0,152,36,0,0,104,104,0,0,48,36,0,0,152,36,0,0,144,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,152,36,0,0,128,34,0,0,40,104,0,0,48,36,0,0,200,36,0,0,40,104,0,0,48,36,0,0,200,36,0,0,48,36,0,0,168,36,0,0,48,36,0,0,224,34,0,0,48,36,0,0,104,104,0,0,224,34,0,0,48,36,0,0,104,104,0,0,104,104,0,0,64,104,0,0,136,36,0,0,104,104,0,0,64,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,64,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,72,104,0,0,136,36,0,0,104,104,0,0,72,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,72,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,88,104,0,0,136,36,0,0,104,104,0,0,88,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,88,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,96,104,0,0,136,36,0,0,104,104,0,0,96,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,96,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,136,104,0,0,136,36,0,0,104,104,0,0,136,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,136,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,136,36,0,0,104,104,0,0,144,104,0,0,136,36,0,0,104,104,0,0,104,104,0,0,224,34,0,0,120,34,0,0,128,34,0,0,120,34,0,0,40,37,0,0,120,34,0,0,160,40,0,0,104,104,0,0,56,37,0,0,48,36,0,0,48,37,0,0,48,36,0,0,48,36,0,0,48,37,0,0,48,36,0,0,200,36,0,0,104,104,0,0,104,104,0,0,224,34,0,0,48,36,0,0,128,34,0,0,24,37,0,0,80,37,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,104,104,0,0,56,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,56,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,168,36,0,0,144,104,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,168,36,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,168,36,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,144,104,0,0,144,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,144,104,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,104,104,0,0,144,104,0,0,144,104,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,104,104,0,0,144,104,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,104,104,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,104,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,144,104,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,144,104,0,0,48,36,0,0,144,104,0,0,144,104,0,0,48,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,144,104,0,0,48,36,0,0,144,104,0,0,144,104,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,56,104,0,0,144,104,0,0,48,36,0,0,56,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,168,36,0,0,216,35,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,168,36,0,0,216,35,0,0,40,104,0,0,48,36,0,0,48,36,0,0,168,36,0,0,128,34,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,168,36,0,0,216,35,0,0,56,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,168,36,0,0,216,35,0,0,56,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,168,36,0,0,216,35,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,168,36,0,0,40,104,0,0,248,35,0,0,224,34,0,0,48,36,0,0,48,36,0,0,224,34,0,0,144,104,0,0,40,104,0,0,248,35,0,0,224,34,0,0,48,36,0,0,48,36,0,0,224,34,0,0,224,34,0,0,56,104,0,0,40,104,0,0,248,35,0,0,224,34,0,0,48,36,0,0,48,36,0,0,224,34,0,0,224,34,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,168,36,0,0,104,104,0,0,24,37,0,0,104,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,168,36,0,0,104,104,0,0,24,37,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,168,36,0,0,104,104,0,0,24,37,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,168,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,168,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,56,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,216,35,0,0,104,104,0,0,200,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,216,35,0,0,104,104,0,0,200,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,216,35,0,0,104,104,0,0,200,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,216,35,0,0,104,104,0,0,200,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,56,104,0,0,56,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,56,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,200,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,144,104,0,0,104,104,0,0,104,104,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,216,35,0,0,104,104,0,0,104,104,0,0,200,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,216,35,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,216,35,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,216,35,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,40,104,0,0,144,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,40,104,0,0,144,104,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,248,35,0,0,104,104,0,0,200,36,0,0,104,104,0,0,104,104,0,0,48,36,0,0,104,104,0,0,216,35,0,0,40,104,0,0,48,36,0,0,248,35,0,0,104,104,0,0,200,36,0,0,104,104,0,0,104,104,0,0,48,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,248,35,0,0,104,104,0,0,200,36,0,0,104,104,0,0,104,104,0,0,48,36,0,0,40,104,0,0,48,36,0,0,248,35,0,0,104,104,0,0,200,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,248,35,0,0,104,104,0,0,200,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,248,35,0,0,104,104,0,0,200,36,0,0,56,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,56,104,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,216,35,0,0,168,36,0,0,144,104,0,0,144,104,0,0,144,104,0,0,200,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,216,35,0,0,168,36,0,0,144,104,0,0,144,104,0,0,144,104,0,0,200,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,216,35,0,0,168,36,0,0,144,104,0,0,144,104,0,0,144,104,0,0,200,36,0,0,104,104,0,0,40,104],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+20480);allocate([48,36,0,0,216,35,0,0,168,36,0,0,144,104,0,0,144,104,0,0,144,104,0,0,200,36,0,0,40,104,0,0,48,36,0,0,120,34,0,0,200,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,120,34,0,0,200,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,120,34,0,0,200,36,0,0,40,104,0,0,216,35,0,0,168,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,104,104,0,0,160,35,0,0,48,36,0,0,48,36,0,0,48,36,0,0,56,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,56,104,0,0,104,104,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,216,35,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,216,35,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,216,35,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,40,104,0,0,48,36,0,0,248,35,0,0,48,36,0,0,104,104,0,0,104,104,0,0,216,35,0,0,40,104,0,0,48,36,0,0,248,35,0,0,48,36,0,0,104,104,0,0,104,104,0,0,144,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,24,37,0,0,48,36,0,0,144,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,24,37,0,0,144,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,120,34,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,48,36,0,0,144,104,0,0,48,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,48,36,0,0,144,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,112,34,0,0,144,104,0,0,144,104,0,0,48,36,0,0,104,104,0,0,168,36,0,0,216,35,0,0,48,36,0,0,104,104,0,0,168,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,48,36,0,0,104,104,0,0,56,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,48,36,0,0,104,104,0,0,56,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,48,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,48,36,0,0,104,104,0,0,104,104,0,0,56,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,48,36,0,0,104,104,0,0,104,104,0,0,56,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,144,104,0,0,48,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,128,34,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,128,34,0,0,48,36,0,0,48,36,0,0,104,104,0,0,40,104,0,0,80,36,0,0,168,34,0,0,104,104,0,0,144,104,0,0,40,104,0,0,80,36,0,0,168,34,0,0,104,104,0,0,40,104,0,0,248,35,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,168,36,0,0,104,104,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,48,36,0,0,48,36,0,0,56,104,0,0,48,36,0,0,144,104,0,0,48,36,0,0,104,104,0,0,48,36,0,0,24,37,0,0,104,104,0,0,104,104,0,0,48,36,0,0,144,104,0,0,48,36,0,0,104,104,0,0,48,36,0,0,24,37,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,216,35,0,0,216,35,0,0,200,36,0,0,104,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,216,35,0,0,216,35,0,0,200,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,216,35,0,0,216,35,0,0,200,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,216,35,0,0,216,35,0,0,200,36,0,0,144,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,200,36,0,0,48,36,0,0,48,36,0,0,200,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,40,104,0,0,248,35,0,0,248,35,0,0,224,34,0,0,64,37,0,0,48,36,0,0,56,104,0,0,64,37,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,216,35,0,0,104,104,0,0,104,104,0,0,200,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,216,35,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,216,35,0,0,104,104,0,0,144,104,0,0,48,36,0,0,104,104,0,0,48,36,0,0,144,104,0,0,48,36,0,0,104,104,0,0,144,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,104,104,0,0,104,104,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,104,104,0,0,104,104,0,0,144,104,0,0,48,36,0,0,112,34,0,0,56,104,0,0,40,104,0,0,48,36,0,0,144,104,0,0,48,36,0,0,40,104,0,0,48,36,0,0,80,37,0,0,216,35,0,0,104,104,0,0,144,104,0,0,200,36,0,0,104,104,0,0,104,104,0,0,56,104,0,0,40,104,0,0,48,36,0,0,80,37,0,0,216,35,0,0,104,104,0,0,144,104,0,0,200,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,80,37,0,0,216,35,0,0,104,104,0,0,144,104,0,0,200,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,80,37,0,0,216,35,0,0,104,104,0,0,144,104,0,0,200,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,168,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,168,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,200,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,104,104,0,0,104,104,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,48,36,0,0,216,35,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,48,36,0,0,216,35,0,0,144,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,48,36,0,0,216,35,0,0,40,104,0,0,48,36,0,0,48,36,0,0,104,104,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,40,104,0,0,104,104,0,0,56,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,104,104,0,0,56,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,248,35,0,0,144,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,144,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,48,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,168,36,0,0,104,104,0,0,104,104,0,0,200,36,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,168,36,0,0,104,104,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,168,36,0,0,104,104,0,0,40,104,0,0,48,36,0,0,48,36,0,0,48,36,0,0,168,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,168,36,0,0,200,36,0,0,56,104,0,0,56,104,0,0,104,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,168,36,0,0,200,36,0,0,56,104,0,0,56,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,168,36,0,0,200,36,0,0,56,104,0,0,48,36,0,0,48,36,0,0,144,104,0,0,168,36,0,0,200,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,168,36,0,0,48,36,0,0,48,36,0,0,144,104,0,0,112,37,0,0,80,37,0,0,80,37,0,0,112,37,0,0,80,37,0,0,112,37,0,0,224,34,0,0,224,34,0,0,112,37,0,0,224,34,0,0,112,37,0,0,80,37,0,0,56,104,0,0,56,104,0,0,160,70,0,0,80,37,0,0,80,37,0,0,56,104,0,0,160,70,0,0,80,37,0,0,120,37,0,0,120,37,0,0,168,36,0,0,168,36,0,0,168,36,0,0,168,36,0,0,104,104,0,0,104,104,0,0,144,104,0,0,104,104,0,0,144,104,0,0,56,104,0,0,104,104,0,0,56,104,0,0,120,37,0,0,104,37,0,0,0,35,0,0,40,104,0,0,160,70,0,0,48,36,0,0,40,104,0,0,160,70,0,0,48,36,0,0,80,36,0,0,80,35,0,0,144,104,0,0,168,36,0,0,168,36,0,0,144,104,0,0,144,104,0,0,56,104,0,0,40,104,0,0,160,70,0,0,48,36,0,0,80,36,0,0,80,35,0,0,144,104,0,0,168,36,0,0,168,36,0,0,144,104,0,0,144,104,0,0,40,104,0,0,160,70,0,0,48,36,0,0,80,36,0,0,80,35,0,0,144,104,0,0,168,36,0,0,168,36,0,0,144,104,0,0,40,104,0,0,160,70,0,0,48,36,0,0,80,36,0,0,80,35,0,0,144,104,0,0,168,36,0,0,168,36,0,0,40,104,0,0,160,70,0,0,48,36,0,0,80,36,0,0,80,35,0,0,144,104,0,0,168,36,0,0,40,104,0,0,160,70,0,0,48,36,0,0,80,36,0,0,80,35,0,0,144,104,0,0,40,104,0,0,160,70,0,0,48,36,0,0,80,36,0,0,80,35,0,0,40,104,0,0,152,37,0,0,48,36,0,0,48,36,0,0,144,104,0,0,40,104,0,0,152,37,0,0,48,36,0,0,48,36,0,0,40,104,0,0,152,37,0,0,48,36,0,0,248,37,0,0,104,104,0,0,144,104,0,0,56,104,0,0,248,37,0,0,104,104,0,0,144,104,0,0,248,37,0,0,104,104,0,0,248,37,0,0,40,104,0,0,200,37,0,0,48,36,0,0,48,36,0,0,144,104,0,0,40,104,0,0,200,37,0,0,48,36,0,0,48,36,0,0,40,104,0,0,0,38,0,0,168,36,0,0,48,38,0,0,144,104,0,0,168,36,0,0,48,38,0,0,144,104,0,0,48,38,0,0,40,104,0,0,16,38,0,0,40,104,0,0,0,38,0,0,144,104,0,0,168,36,0,0,32,38,0,0,144,104,0,0,32,38,0,0,40,104,0,0,0,38,0,0,48,36,0,0,48,36,0,0,40,104,0,0,112,37,0,0,48,36,0,0,80,37,0,0,144,104,0,0,200,36,0,0,40,104,0,0,112,37,0,0,48,36,0,0,80,37,0,0,144,104,0,0,40,104,0,0,112,37,0,0,48,36,0,0,80,37,0,0,40,104,0,0,112,37,0,0,48,36,0,0,48,36,0,0,112,37,0,0,80,37,0,0,48,36,0,0,112,37,0,0,40,104,0,0,112,37,0,0,248,35,0,0,80,37,0,0,40,104,0,0,112,37,0,0,248,35,0,0,40,104,0,0,112,37,0,0,248,35,0,0,224,34,0,0,56,104,0,0,120,38,0,0,80,37,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,144,104,0,0,104,104,0,0,104,104,0,0,168,36,0,0,168,36,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,144,104,0,0,104,104,0,0,104,104,0,0,168,36,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,144,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,144,104,0,0,104,104,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,144,104,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,128,38,0,0,128,38,0,0,104,37,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,80,35,0,0,144,104,0,0,104,104,0,0,104,104,0,0,168,36,0,0,168,36,0,0,56,104,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,80,35,0,0,144,104,0,0,104,104,0,0,104,104,0,0,168,36,0,0,168,36,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,80,35,0,0,144,104,0,0,104,104,0,0,104,104,0,0,168,36,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,80,35,0,0,144,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,80,35,0,0,144,104,0,0,104,104,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,80,35,0,0,144,104,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,168,34,0,0,80,35,0,0,56,104,0,0,144,38,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,144,104,0,0,104,104,0,0,104,104,0,0,168,36,0,0,168,36,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,144,104,0,0,104,104,0,0,104,104,0,0,168,36,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,144,104,0,0,104,104,0,0,104,104,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,144,104,0,0,104,104,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,144,104,0,0,40,104,0,0,120,38,0,0,48,36,0,0,80,36,0,0,200,45,8,0,129,208,2,0,66,208,2,0,109,0,0,0,1,0,0,0,204,45,8,0,61,209,2,0,66,208,2,0,255,2,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,208,45,8,0,176,210,2,0,202,210,2,0,105,0,0,0,1,0,0,0,212,45,8,0,104,211,2,0,202,210,2,0,148,0,0,0,1,0,0,0,216,45,8,0,249,211,2,0,202,210,2,0,14,1,0,0,1,0,0,0,220,45,8,0,198,212,2,0,202,210,2,0,51,2,0,0,1,0,0,0,224,45,8,0,23,213,2,0,202,210,2,0,154,2,0,0,1,0,0,0,228,45,8,0,65,213,2,0,202,210,2,0,187,2,0,0,1,0,0,0,232,45,8,0,103,213,2,0,202,210,2,0,181,4,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,236,45,8,0,149,213,2,0,202,210,2,0,76,5,0,0,1,0,0,0,240,45,8,0,4,214,2,0,202,210,2,0,163,5,0,0,1,0,0,0,244,45,8,0,98,214,2,0,202,210,2,0,46,6,0,0,1,0,0,0,248,45,8,0,64,215,2,0,202,210,2,0,203,6,0,0,1,0,0,0,252,45,8,0,212,215,2,0,202,210,2,0,94,7,0,0,1,0,0,0,0,46,8,0,156,216,2,0,7,216,2,0,243,2,0,0,1,0,0,0,12,46,8,0,217,218,2,0,7,216,2,0,65,3,0,0,1,0,0,0,8,46,8,0,132,218,2,0,7,216,2,0,8,6,0,0,1,0,0,0,4,46,8,0,58,217,2,0,7,216,2,0,112,5,0,0,1,0,0,0,16,46,8,0,221,219,2,0,7,216,2,0,69,4,0,0,1,0,0,0,221,219,2,0,7,216,2,0,81,4,0,0,0,0,0,0,22,220,2,0,59,220,2,0,66,220,2,0,0,0,0,0,160,40,0,0,1,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,176,40,0,0,3,0,0,0,4,0,0,0,1,0,0,0,1,0,0,0,64,0,0,0,0,0,0,0,48,41,0,0,5,0,0,0,6,0,0,0,56,0,0,0,248,255,255,255,48,41,0,0,7,0,0,0,8,0,0,0,192,255,255,255,192,255,255,255,48,41,0,0,9,0,0,0,10,0,0,0,0,0,0,0,32,41,0,0,15,0,0,0,16,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,8,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,4,0,0,0,5,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,136,136,0,0,236,40,0,0,196,40,0,0,216,40,0,0,212,41,0,0,232,41,0,0,20,41,0,0,0,41,0,0,176,136,0,0,156,136,0,0,129,165,17,0,0,0,0,0,64,41,0,0,23,0,0,0,24,0,0,0,6,0,0,0,2,0,0,0,0,0,0,0,88,41,0,0,25,0,0,0,26,0,0,0,7,0,0,0,3,0,0,0,60,54,8,0,19,248,2,0,211,247,2,0,26,1,0,0,1,0,0,0,9,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,11,0,0,0,11,0,0,0,12,0,0,0,0,0,0,0,64,54,8,0,72,248,2,0,211,247,2,0,174,1,0,0,1,0,0,0,68,54,8,0,147,252,2,0,84,252,2,0,116,2,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,0,0,0,0,72,54,8,0,168,253,2,0,84,252,2,0,66,4,0,0,1,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,0,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,0,0,0,0,76,54,8,0,55,254,2,0,238,253,2,0,103,1,0,0,1,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,112,41,0,0,27,0,0,0,28,0,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,80,54,8,0,98,254,2,0,155,254,2,0,82,0,0,0,1,0,0,0,84,54,8,0,223,254,2,0,155,254,2,0,73,0,0,0,1,0,0,0,88,54,8,0,26,255,2,0,155,254,2,0,55,0,0,0,1,0,0,0,92,54,8,0,78,255,2,0,155,254,2,0,50,0,0,0,1,0,0,0,96,54,8,0,112,255,2,0,155,254,2,0,88,0,0,0,1,0,0,0,100,54,8,0,169,255,2,0,232,255,2,0,75,0,0,0,1,0,0,0,104,54,8,0,48,0,3,0,232,255,2,0,86,0,0,0,1,0,0,0,108,54,8,0,113,0,3,0,232,255,2,0,175,0,0,0,1,0,0,0,112,54,8,0,183,0,3,0,232,255,2,0,184,0,0,0,1,0,0,0,116,54,8,0,255,0,3,0,232,255,2,0,40,1,0,0,1,0,0,0,120,54,8,0,76,1,3,0,232,255,2,0,50,1,0,0,1,0,0,0,124,54,8,0,80,2,3,0,15,2,3,0,237,2,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,128,54,8,0,184,2,3,0,15,2,3,0,53,3,0,0,1,0,0,0,132,54,8,0,9,3,3,0,99,3,3,0,152,0,0,0,1,0,0,0,136,54,8,0,177,3,3,0,99,3,3,0,158,0,0,0,1,0,0,0,140,54,8,0,14,4,3,0,99,3,3,0,185,0,0,0,1,0,0,0,144,54,8,0,99,4,3,0,99,3,3,0,218,0,0,0,1,0,0,0,148,54,8,0,187,4,3,0,99,3,3,0,252,0,0,0,1,0,0,0,152,54,8,0,255,4,3,0,99,3,3,0,25,1,0,0,1,0,0,0,156,54,8,0,69,5,3,0,99,3,3,0,52,1,0,0,1,0,0,0,160,54,8,0,134,5,3,0,99,3,3,0,81,1,0,0,1,0,0,0,164,54,8,0,201,5,3,0,99,3,3,0,171,1,0,0,1,0,0,0,168,54,8,0,9,6,3,0,99,3,3,0,28,2,0,0,1,0,0,0,172,54,8,0,75,6,3,0,99,3,3,0,162,2,0,0,1,0,0,0,176,54,8,0,139,6,3,0,99,3,3,0,233,2,0,0,1,0,0,0,180,54,8,0,205,6,3,0,25,7,3,0,16,0,0,0,1,0,0,0,184,54,8,0,107,7,3,0,25,7,3,0,26,0,0,0,1,0,0,0,188,54,8,0,186,7,3,0,25,7,3,0,44,0,0,0,1,0,0,0,192,54,8,0,1,8,3,0,25,7,3,0,56,0,0,0,1,0,0,0,196,54,8,0,75,8,3,0,25,7,3,0,69,0,0,0,1,0,0,0,200,54,8,0,129,8,3,0,25,7,3,0,81,0,0,0,1,0,0,0,204,54,8,0,185,8,3,0,25,7,3,0,93,0,0,0,1,0,0,0,208,54,8,0,236,8,3,0,25,7,3,0,104,0,0,0,1,0,0,0,212,54,8,0,33,9,3,0,25,7,3,0,114,0,0,0,1,0,0,0,216,54,8,0,83,9,3,0,25,7,3,0,125,0,0,0,1,0,0,0,220,54,8,0,135,9,3,0,25,7,3,0,136,0,0,0,1,0,0,0,224,54,8,0,185,9,3,0,25,7,3,0,147,0,0,0,1,0,0,0,248,54,8,0,54,13,3,0,66,10,3,0,230,0,0,0,1,0,0,0,244,54,8,0,234,12,3,0,66,10,3,0,97,0,0,0,1,0,0,0,0,0,0,0,152,41,0,0,30,0,0,0,31,0,0,0,8,0,0,0,0,0,0,0,136,41,0,0,30,0,0,0,32,0,0,0,9,0,0,0,0,0,0,0,120,41,0,0,30,0,0,0,33,0,0,0,10,0,0,0,232,54,8,0,95,11,3,0,66,10,3,0,176,0,0,0,1,0,0,0,236,54,8,0,238,11,3,0,66,10,3,0,176,0,0,0,1,0,0,0,240,54,8,0,123,12,3,0,66,10,3,0,70,0,0,0,1,0,0,0,0,0,0,0,168,41,0,0,34,0,0,0,35,0,0,0,9,0,0,0,11,0,0,0,128,55,8,0,66,15,3,0,172,13,3,0,107,3,0,0,1,0,0,0,124,55,8,0,1,15,3,0,172,13,3,0,202,3,0,0,1,0,0,0,132,55,8,0,107,15,3,0,172,13,3,0,11,4,0,0,1,0,0,0,136,55,8,0,157,15,3,0,184,15,3,0,74,3,0,0,1,0,0,0,56,0,0,0,0,0,0,0,240,41,0,0,40,0,0,0,41,0,0,0,200,255,255,255,200,255,255,255,240,41,0,0,42,0,0,0,43,0,0,0,248,142,0,0,212,41,0,0,232,41,0,0,12,143,0,0,0,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,140,55,8,0,227,16,3,0,164,16,3,0,239,0,0,0,1,0,0,0,148,55,8,0,147,17,3,0,164,16,3,0,100,1,0,0,1,0,0,0,144,55,8,0,103,17,3,0,164,16,3,0,156,1,0,0,1,0,0,0,152,55,8,0,92,18,3,0,164,16,3,0,2,2,0,0,1,0,0,0,156,55,8,0,145,18,3,0,164,16,3,0,226,2,0,0,1,0,0,0,160,55,8,0,244,18,3,0,164,16,3,0,90,3,0,0,1,0,0,0,164,55,8,0,224,19,3,0,164,16,3,0,153,4,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,168,61,8,0,105,23,3,0,249,20,3,0,11,3,0,0,1,0,0,0,172,61,8,0,162,23,3,0,249,20,3,0,18,3,0,0,1,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,0,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,0,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,0,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,0,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,0,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,0,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,61,8,0,217,39,3,0,145,39,3,0,221,6,0,0,1,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,0,0,0,0,180,61,8,0,67,40,3,0,145,39,3,0,93,7,0,0,1,0,0,0,0,0,0,0,0,42,0,0,44,0,0,0,45,0,0,0,6,0,0,0,10,0,0,0,46,0,0,0,12,0,0,0,184,61,8,0,245,40,3,0,69,41,3,0,59,0,0,0,1,0,0,0,0,0,0,0,8,42,0,0,47,0,0,0,48,0,0,0,49,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,0,0,0,0,188,61,8,0,193,42,3,0,131,42,3,0,73,2,0,0,1,0,0,0,240,42,3,0,246,42,3,0,252,42,3,0,3,43,3,0,10,43,3,0,17,43,3,0,24,43,3,0,31,43,3,0,78,43,3,0,228,248,7,0,6,249,7,0,237,248,7,0,159,248,7,0,231,248,7,0,161,248,7,0,113,43,3,0,128,43,3,0,137,43,3,0,150,43,3,0,172,43,3,0,182,43,3,0,207,43,3,0,200,61,8,0,137,44,3,0,61,44,3,0,50,0,0,0,1,0,0,0,204,61,8,0,192,44,3,0,61,44,3,0,86,0,0,0,1,0,0,0,208,61,8,0,67,45,3,0,61,44,3,0,95,0,0,0,5,0,0,0,212,61,8,0,122,45,3,0,61,44,3,0,131,0,0,0,1,0,0,0,216,61,8,0,191,45,3,0,61,44,3,0,182,0,0,0,1,0,0,0,220,61,8,0,252,45,3,0,61,44,3,0,229,0,0,0,1,0,0,0,224,61,8,0,130,46,3,0,61,44,3,0,239,1,0,0,1,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,0,0,0,0,17,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,228,61,8,0,219,46,3,0,61,44,3,0,31,2,0,0,1,0,0,0,232,61,8,0,180,47,3,0,61,44,3,0,199,3,0,0,1,0,0,0,236,61,8,0,22,48,3,0,61,44,3,0,127,5,0,0,1,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,0,0,0,0,81,0,0,0,74,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,0,0,0,0,87,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,91,0,0,0,92,0,0,0,93,0,0,0,0,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,89,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,0,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,103,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,0,0,0,0,107,0,0,0,108,0,0,0,109,0,0,0,110,0,0,0,111,0,0,0,104,0,0,0,112,0,0,0,0,0,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,61,8,0,11,49,3,0,201,48,3,0,25,5,0,0,1,0,0,0,244,61,8,0,111,49,3,0,201,48,3,0,183,5,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,248,61,8,0,221,49,3,0,157,49,3,0,34,1,0,0,1,0,0,0,13,0,0,0,13,0,0,0,14,0,0,0,14,0,0,0,15,0,0,0,15,0,0,0,16,0,0,0,0,0,0,0,252,61,8,0,67,50,3,0,157,49,3,0,134,1,0,0,1,0,0,0,16,62,8,0,206,50,3,0,141,50,3,0,131,3,0,0,1,0,0,0,20,62,8,0,8,53,3,0,141,50,3,0,36,8,0,0,1,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,0,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,24,62,8,0,138,53,3,0,141,50,3,0,216,8,0,0,1,0,0,0,28,62,8,0,2,54,3,0,141,50,3,0,107,9,0,0,1,0,0,0,32,62,8,0,209,54,3,0,141,50,3,0,65,11,0,0,1,0,0,0,36,62,8,0,74,55,3,0,141,50,3,0,217,12,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,40,62,8,0,112,55,3,0,167,55,3,0,64,2,0,0,1,0,0,0,96,151,0,0,0,0,0,0,40,42,0,0,50,0,0,0,51,0,0,0,8,0,0,0,17,0,0,0,23,0,0,0,18,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,25,0,0,0,26,0,0,0,23,0,0,0,24,0,0,0,27,0,0,0,9,0,0,0,80,152,0,0,220,151,0,0,0,0,0,0,56,42,0,0,50,0,0,0,52,0,0,0,10,0,0,0,25,0,0,0,23,0,0,0,18,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,25,0,0,0,26,0,0,0,26,0,0,0,24,0,0,0,27,0,0,0,9,0,0,0,0,0,0,0,72,42,0,0,50,0,0,0,53,0,0,0,11,0,0,0,27,0,0,0,23,0,0,0,18,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,25,0,0,0,26,0,0,0,26,0,0,0,24,0,0,0,27,0,0,0,9,0,0,0,32,155,0,0,148,153,0,0,208,152,0,0,0,0,0,0,88,42,0,0,50,0,0,0,54,0,0,0,12,0,0,0,28,0,0,0,23,0,0,0,18,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,29,0,0,0,20,0,0,0,30,0,0,0,22,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,1,0,0,0,25,0,0,0,28,0,0,0,26,0,0,0,24,0,0,0,27,0,0,0,9,0,0,0,44,62,8,0,91,56,3,0,167,55,3,0,250,5,0,0,1,0,0,0,48,62,8,0,172,56,3,0,167,55,3,0,241,5,0,0,1,0,0,0,52,62,8,0,4,57,3,0,167,55,3,0,222,5,0,0,1,0,0,0,56,62,8,0,105,57,3,0,167,55,3,0,203,5,0,0,1,0,0,0,0,0,0,0,104,42,0,0,50,0,0,0,55,0,0,0,13,0,0,0,31,0,0,0,23,0,0,0,18,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,19,0,0,0,32,0,0,0,21,0,0,0,33,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,29,0,0,0,30,0,0,0,26,0,0,0,24,0,0,0,27,0,0,0,9,0,0,0,60,62,8,0,219,57,3,0,167,55,3,0,27,5,0,0,1,0,0,0,72,62,8,0,251,58,3,0,167,55,3,0,37,5,0,0,1,0,0,0,52,154,0,0,0,0,0,0,120,42,0,0,50,0,0,0,56,0,0,0,14,0,0,0,34,0,0,0,23,0,0,0,18,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,1,0,0,0,4,0,0,0,2,0,0,0,3,0,0,0,25,0,0,0,26,0,0,0,26,0,0,0,24,0,0,0,27,0,0,0,9,0,0,0,64,62,8,0,45,58,3,0,167,55,3,0,112,5,0,0,1,0,0,0,68,62,8,0,130,58,3,0,167,55,3,0,99,5,0,0,1,0,0,0,76,62,8,0,71,59,3,0,167,55,3,0,16,5,0,0,1,0,0,0,80,62,8,0,158,59,3,0,167,55,3,0,6,5,0,0,1,0,0,0,84,62,8,0,247,59,3,0,167,55,3,0,252,4,0,0,1,0,0,0,88,62,8,0,88,60,3,0,167,55,3,0,243,4,0,0,1,0,0,0,0,0,0,0,136,42,0,0,50,0,0,0,57,0,0,0,15,0,0,0,35,0,0,0,23,0,0,0,18,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,1,0,0,0,5,0,0,0,2,0,0,0,1,0,0,0,25,0,0,0,31,0,0,0,26,0,0,0,24,0,0,0,27,0,0,0,9,0,0,0,92,62,8,0,199,60,3,0,167,55,3,0,177,5,0,0,1,0,0,0,96,62,8,0,21,61,3,0,167,55,3,0,169,5,0,0,1,0,0,0,100,62,8,0,120,61,3,0,167,55,3,0,254,1,0,0,1,0,0,0,104,62,8,0,196,61,3,0,167,55,3,0,244,1,0,0,1,0,0,0,108,62,8,0,10,62,3,0,167,55,3,0,234,1,0,0,1,0,0,0,112,62,8,0,91,62,3,0,167,55,3,0,192,1,0,0,1,0,0,0,116,62,8,0,193,62,3,0,167,55,3,0,182,1,0,0,1,0,0,0,120,62,8,0,20,63,3,0,167,55,3,0,129,1,0,0,1,0,0,0,124,62,8,0,124,63,3,0,167,55,3,0,119,1,0,0,1,0,0,0,128,62,8,0,215,63,3,0,167,55,3,0,86,1,0,0,1,0,0,0,132,62,8,0,55,64,3,0,167,55,3,0,76,1,0,0,1,0,0,0,136,62,8,0,141,64,3,0,167,55,3,0,43,1,0,0,1,0,0,0,0,0,0,0,152,42,0,0,50,0,0,0,58,0,0,0,16,0,0,0,36,0,0,0,23,0,0,0,18,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,25,0,0,0,26,0,0,0,26,0,0,0,24,0,0,0,27,0,0,0,9,0,0,0,0,0,0,0,168,42,0,0,50,0,0,0,59,0,0,0,17,0,0,0,37,0,0,0,23,0,0,0,18,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,1,0,0,0,6,0,0,0,2,0,0,0,1,0,0,0,25,0,0,0,26,0,0,0,26,0,0,0,24,0,0,0,27,0,0,0,9,0,0,0,140,62,8,0,4,65,3,0,167,55,3,0,75,6,0,0,1,0,0,0,132,156,0,0,144,62,8,0,156,65,3,0,167,55,3,0,126,4,0,0,1,0,0,0,152,62,8,0,193,65,3,0,167,55,3,0,159,4,0,0,1,0,0,0,156,62,8,0,223,65,3,0,167,55,3,0,95,6,0,0,1,0,0,0,160,62,8,0,254,65,3,0,167,55,3,0,104,6,0,0,1,0,0,0,164,62,8,0,34,66,3,0,167,55,3,0,114,6,0,0,1,0,0,0,168,62,8,0,85,66,3,0,167,55,3,0,129,6,0,0,1,0,0,0,172,62,8,0,134,66,3,0,167,55,3,0,138,6,0,0,1,0,0,0,176,62,8,0,179,66,3,0,167,55,3,0,156,6,0,0,1,0,0,0,180,62,8,0,227,66,3,0,167,55,3,0,165,6,0,0,1,0,0,0,184,62,8,0,15,67,3,0,167,55,3,0,183,6,0,0,1,0,0,0,188,62,8,0,62,67,3,0,167,55,3,0,192,6,0,0,1,0,0,0,0,0,0,0,192,42,0,0,11,0,0,0,12,0,0,0,13,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,204,62,8,0,205,68,3,0,140,68,3,0,88,0,0,0,1,0,0,0,0,0,0,0,208,42,0,0,63,0,0,0,64,0,0,0,1,0,0,0,7,0,0,0,14,0,0,0,32,0,0,0,15,0,0,0,120,0,0,0,121,0,0,0,1,0,0,0,18,0,0,0,0,0,0,0,8,45,0,0,33,0,0,0,65,0,0,0,66,0,0,0,0,0,0,0,240,44,0,0,34,0,0,0,67,0,0,0,68,0,0,0,0,0,0,0,224,42,0,0,47,0,0,0,69,0,0,0,70,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,0,0,0,0,64,45,0,0,24,0,0,0,71,0,0,0,72,0,0,0,0,0,0,0,40,45,0,0,25,0,0,0,73,0,0,0,74,0,0,0,0,0,0,0,24,45,0,0,47,0,0,0,75,0,0,0,76,0,0,0,208,62,8,0,233,76,3,0,166,73,3,0,245,12,0,0,1,0,0,0,212,62,8,0,88,77,3,0,166,73,3,0,204,13,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,12,0,0,0,15,0,0,0,16,0,0,0,18,0,0,0,20,0,0,0,24,0,0,0,25,0,0,0,27,0,0,0,30,0,0,0,32,0,0,0,36,0,0,0,40,0,0,0,45,0,0,0,48,0,0,0,50,0,0,0,54,0,0,0,60,0,0,0,64,0,0,0,72,0,0,0,75,0,0,0,80,0,0,0,81,0,0,0,90,0,0,0,96,0,0,0,100,0,0,0,108,0,0,0,120],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+30720);allocate([125,0,0,0,128,0,0,0,135,0,0,0,144,0,0,0,150,0,0,0,160,0,0,0,162,0,0,0,180,0,0,0,192,0,0,0,200,0,0,0,216,0,0,0,225,0,0,0,240,0,0,0,243,0,0,0,250,0,0,0,0,1,0,0,14,1,0,0,32,1,0,0,44,1,0,0,64,1,0,0,68,1,0,0,104,1,0,0,119,1,0,0,128,1,0,0,144,1,0,0,149,1,0,0,176,1,0,0,194,1,0,0,224,1,0,0,230,1,0,0,244,1,0,0,0,2,0,0,28,2,0,0,64,2,0,0,88,2,0,0,113,2,0,0,128,2,0,0,136,2,0,0,163,2,0,0,208,2,0,0,217,2,0,0,238,2,0,0,0,3,0,0,32,3,0,0,42,3,0,0,96,3,0,0,132,3,0,0,192,3,0,0,204,3,0,0,232,3,0,0,0,4,0,0,56,4,0,0,101,4,0,0,128,4,0,0,176,4,0,0,191,4,0,0,226,4,0,0,0,5,0,0,16,5,0,0,70,5,0,0,160,5,0,0,178,5,0,0,220,5,0,0,0,6,0,0,64,6,0,0,84,6,0,0,192,6,0,0,8,7,0,0,83,7,0,0,128,7,0,0,152,7,0,0,208,7,0,0,233,7,0,0,0,8,0,0,112,8,0,0,139,8,0,0,202,8,0,0,0,9,0,0,96,9,0,0,126,9,0,0,196,9,0,0,0,10,0,0,32,10,0,0,140,10,0,0,64,11,0,0,100,11,0,0,184,11,0,0,0,12,0,0,53,12,0,0,128,12,0,0,168,12,0,0,47,13,0,0,128,13,0,0,16,14,0,0,61,14,0,0,166,14,0,0,0,15,0,0,48,15,0,0,160,15,0,0,210,15,0,0,0,16,0,0,224,16,0,0,22,17,0,0,148,17,0,0,0,18,0,0,192,18,0,0,252,18,0,0,136,19,0,0,0,20,0,0,64,20,0,0,24,21,0,0,249,21,0,0,128,22,0,0,200,22,0,0,112,23,0,0,187,23,0,0,0,24,0,0,106,24,0,0,0,25,0,0,80,25,0,0,161,25,0,0,94,26,0,0,0,27,0,0,32,28,0,0,122,28,0,0,76,29,0,0,0,30,0,0,96,30,0,0,64,31,0,0,164,31,0,0,0,32,0,0,192,33,0,0,44,34,0,0,40,35,0,0,0,36,0,0,159,36,0,0,128,37,0,0,248,37,0,0,16,39,0,0,141,39,0,0,0,40,0,0,128,40,0,0,48,42,0,0,183,42,0,0,242,43,0,0,0,45,0,0,144,45,0,0,224,46,0,0,118,47,0,0,0,48,0,0,212,48,0,0,0,50,0,0,160,50,0,0,66,51,0,0,188,52,0,0,0,54,0,0,64,56,0,0,244,56,0,0,152,58,0,0,0,60,0,0,192,60,0,0,9,61,0,0,128,62,0,0,72,63,0,0,0,64,0,0,235,65,0,0,128,67,0,0,88,68,0,0,80,70,0,0,49,71,0,0,0,72,0,0,62,73,0,0,0,75,0,0,240,75,0,0,227,76,0,0,32,78,0,0,26,79,0,0,0,80,0,0,0,81,0,0,96,84,0,0,110,85,0,0,228,87,0,0,0,90,0,0,32,91,0,0,192,93,0,0,236,94,0,0,0,96,0,0,168,97,0,0,0,100,0,0,64,101,0,0,132,102,0,0,120,105,0,0,0,108,0,0,221,109,0,0,128,112,0,0,232,113,0,0,48,117,0,0,167,118,0,0,0,120,0,0,128,121,0,0,18,122,0,0,0,125,0,0,144,126,0,0,0,128,0,0,37,128,0,0,214,131,0,0,0,135,0,0,176,136,0,0,160,140,0,0,98,142,0,0,0,144,0,0,124,146,0,0,0,150,0,0,224,151,0,0,198,153,0,0,64,156,0,0,52,158,0,0,0,160,0,0,0,162,0,0,192,168,0,0,220,170,0,0,200,175,0,0,0,180,0,0,64,182,0,0,27,183,0,0,128,187,0,0,216,189,0,0,0,192,0,0,80,195,0,0,193,197,0,0,0,200,0,0,128,202,0,0,8,205,0,0,240,210,0,0,147,213,0,0,0,216,0,0,186,219,0,0,0,225,0,0,208,227,0,0,169,230,0,0,96,234,0,0,78,237,0,0,0,240,0,0,0,243,0,0,36,244,0,0,0,250,0,0,32,253,0,0,0,0,1,0,74,0,1,0,172,7,1,0,0,14,1,0,96,17,1,0,64,25,1,0,196,28,1,0,0,32,1,0,248,36,1,0,0,44,1,0,192,47,1,0,45,49,1,0,140,51,1,0,128,56,1,0,104,60,1,0,0,64,1,0,0,68,1,0,151,73,1,0,128,81,1,0,184,85,1,0,144,95,1,0,245,99,1,0,0,104,1,0,128,108,1,0,54,110,1,0,0,119,1,0,176,123,1,0,0,128,1,0,111,128,1,0,160,134,1,0,130,139,1,0,0,144,1,0,0,149,1,0,16,154,1,0,224,165,1,0,38,171,1,0,0,176,1,0,116,183,1,0,0,194,1,0,160,199,1,0,82,205,1,0,192,212,1,0,156,218,1,0,0,224,1,0,0,230,1,0,72,232,1,0,0,244,1,0,64,250,1,0,0,0,2,0,148,0,2,0,88,15,2,0,0,28,2,0,192,34,2,0,81,37,2,0,128,50,2,0,136,57,2,0,0,64,2,0,240,73,2,0,67,81,2,0,0,88,2,0,128,95,2,0,90,98,2,0,24,103,2,0,0,113,2,0,208,120,2,0,0,128,2,0,185,128,2,0,0,136,2,0,46,147,2,0,0,163,2,0,112,171,2,0,251,179,2,0,32,191,2,0,234,199,2,0,0,208,2,0,0,217,2,0,108,220,2,0,0,238,2,0,96,247,2,0,0,0,3,0,222,0,3,0,64,13,3,0,4,23,3,0,0,32,3,0,0,42,3,0,32,52,3,0,192,75,3,0,76,86,3,0,0,96,3,0,232,110,3,0,0,132,3,0,64,143,3,0,135,147,3,0,164,154,3,0,128,169,3,0,56,181,3,0,0,192,3,0,0,204,3,0,144,208,3,0,197,220,3,0,0,232,3,0,128,244,3,0,0,0,4,0,40,1,4,0,176,30,4,0,223,43,4,0,0,56,4,0,128,69,4,0,162,74,4,0,0,101,4,0,16,115,4,0,0,128,4,0,77,129,4,0,224,147,4,0,134,162,4,0,0,176,4,0,0,191,4,0,180,196,4,0,48,206,4,0,0,226,4,0,160,241,4,0,0,0,5,0,114,1,5,0,0,16,5,0,92,38,5,0,0,70,5,0,224,86,5,0,246,103,5,0,64,126,5,0,212,143,5,0,0,160,5,0,0,178,5,0,216,184,5,0,0,220,5,0,192,238,5,0,225,245,5,0,0,0,6,0,188,1,6,0,128,26,6,0,8,46,6,0,0,64,6,0,0,84,6,0,64,104,6,0,243,111,6,0,128,151,6,0,152,172,6,0,0,192,6,0,208,221,6,0,201,243,6,0,0,8,7,0,128,30,7,0,14,39,7,0,72,53,7,0,0,83,7,0,112,106,7,0,0,128,7,0,43,130,7,0,0,152,7,0,32,161,7,0,138,185,7,0,0,208,7,0,0,233,7,0,0,0,8,0,80,2,8,0,241,27,8,0,96,61,8,0,190,87,8,0,0,112,8,0,0,139,8,0,68,149,8,0,0,202,8,0,32,230,8,0,0,0,9,0,154,2,9,0,192,39,9,0,12,69,9,0,0,96,9,0,0,126,9,0,104,137,9,0,96,156,9,0,0,196,9,0,64,227,9,0,0,0,10,0,228,2,10,0,0,32,10,0,184,76,10,0,0,140,10,0,192,173,10,0,149,186,10,0,236,207,10,0,128,252,10,0,168,31,11,0,0,64,11,0,0,100,11,0,176,113,11,0,79,150,11,0,0,184,11,0,128,221,11,0,194,235,11,0,0,0,12,0,120,3,12,0,0,53,12,0,16,92,12,0,0,128,12,0,157,131,12,0,0,168,12,0,128,208,12,0,230,223,12,0,0,47,13,0,48,89,13,0,0,128,13,0,231,131,13,0,160,187,13,0,146,231,13,0,0,16,14,0,0,61,14,0,28,78,14,0,144,106,14,0,0,166,14,0,224,212,14,0,0,0,15,0,86,4,15,0,0,48,15,0,64,66,15,0,20,115,15,0,0,160,15,0,0,210,15,0,0,0,16,0,160,4,16,0,226,55,16,0,192,122,16,0,124,175,16,0,0,224,16,0,0,22,17,0,136,42,17,0,0,148,17,0,64,204,17,0,163,225,17,0,0,0,18,0,52,5,18,0,128,79,18,0,24,138,18,0,0,192,18,0,0,252,18,0,208,18,19,0,192,56,19,0,217,79,19,0,0,136,19,0,128,198,19,0,0,0,20,0,200,5,20,0,0,64,20,0,112,153,20,0,91,219,20,0,0,24,21,0,128,91,21,0,42,117,21,0,216,159,21,0,0,249,21,0,80,63,22,0,0,128,22,0,129,134,22,0,0,200,22,0,96,227,22,0,158,44,23,0,0,112,23,0,0,187,23,0,132,215,23,0,0,0,24,0,240,6,24,0,211,83,24,0,0,106,24,0,32,184,24,0,0,0,25,0,58,7,25,0,0,80,25,0,0,161,25,0,204,191,25,0,0,94,26,0,96,178,26,0,0,0,27,0,206,7,27,0,64,119,27,0,36,207,27,0,0,32,28,0,0,122,28,0,56,156,28,0,32,213,28,0,0,76,29,0,192,169,29,0,101,205,29,0,0,0,30,0,172,8,30,0,0,96,30,0,128,132,30,0,40,230,30,0,0,64,31,0,0,164,31,0,0,0,32,0,64,9,32,0,191,47,32,0,196,111,32,0,128,245,32,0,248,94,33,0,0,192,33,0,0,44,34,0,16,85,34,0,237,194,34,0,0,40,35,0,128,152,35,0,70,195,35,0,0,0,36,0,104,10,36,0,0,159,36,0,48,20,37,0,0,128,37,0,215,138,37,0,0,248,37,0,160,37,38,0,128,113,38,0,178,159,38,0,0,16,39,0,0,141,39,0,0,0,40,0,144,11,40,0,0,128,40,0,181,139,40,0,224,50,41,0,182,182,41,0,0,48,42,0,0,183,42,0,84,234,42,0,176,63,43,0,0,242,43,0,160,126,44,0,0,0,45,0,2,13,45,0,0,144,45,0,192,198,45,0,60,89,46,0,0,224,46,0,0,118,47,0,8,175,47,0,0,0,48,0,224,13,48,0,166,167,48,0,0,212,48,0,64,112,49,0,0,0,50,0,116,14,50,0,0,160,50,0,0,66,51,0,152,127,51,0,0,188,52,0,192,100,53,0,233,164,53,0,0,0,54,0,156,15,54,0,128,238,54,0,72,158,55,0,0,64,56,0,0,244,56,0,112,56,57,0,64,170,57,0,139,239,57,0,0,152,58,0,128,83,59,0,202,154,59,0,0,0,60,0,88,17,60,0,0,192,60,0,0,9,61,0,80,204,61,0,0,128,62,0,17,146,62,0,0,72,63,0,0,0,64,0,128,18,64,0,126,95,64,0,136,223,64,0,0,235,65,0,240,189,66,0,0,128,67,0,131,147,67,0,0,88,68,0,32,170,68,0,218,133,69,0,0,80,70,0,0,49,71,0,140,134,71,0,0,0,72,0,208,20,72,0,121,251,72,0,0,62,73,0,96,40,74,0,0,0,75,0,174,21,75,0,0,240,75,0,64,75,76,0,0,227,76,0,100,63,77,0,0,32,78,0,0,26,79,0,0,0,80,0,32,23,80,0,0,0,81,0,106,23,81,0,192,101,82,0,108,109,83,0,0,96,84,0,0,110,85,0,168,212,85,0,96,127,86,0,0,228,87,0,64,253,88,0,47,104,89,0,0,0,90,0,4,26,90,0,0,32,91,0,128,141,91,0,120,178,92,0,0,192,93,0,0,236,94,0,16,94,95,0,0,0,96,0,192,27,96,0,61,143,96,0,76,79,97,0,0,168,97,0,128,224,98,0,0,0,100,0,232,28,100,0,0,64,101,0,0,132,102,0,48,255,102,0,199,72,104,0,0,120,105,0,128,201,106,0,210,73,107,0,0,0,108,0,56,31,108,0,0,221,109,0,144,60,111,0,0,128,112,0,133,160,112,0,0,232,113,0,224,112,114,0,128,84,115,0,22,223,115,0,0,48,117,0,0,167,118,0,148,53,119,0,0,0,120,0,176,34,120,0,0,128,121,0,31,163,121,0,0,18,122,0,160,152,123,0,0,0,125,0,34,36,125,0,0,144,126,0,0,0,128,0,0,37,128,0,252,190,128,0,16,191,129,0,0,214,131,0,224,123,133,0,0,0,135,0,6,39,135,0,0,176,136,0,64,84,137,0,180,11,139,0,0,160,140,0,0,98,142,0,24,13,143,0,0,0,144,0,160,41,144,0,242,246,145,0,0,124,146,0,192,80,148,0,249,2,149,0,0,0,150,0,92,43,150,0,0,224,151,0,128,150,152,0,0,198,153,0,200,126,154,0,0,64,156,0,0,52,158,0,0,0,160,0,64,46,160,0,187,238,160,0,0,0,162,0,212,46,162,0,128,203,164,0,216,218,166,0,0,192,168,0,0,220,170,0,80,169,171,0,192,254,172,0,161,206,173,0,0,200,175,0,128,250,177,0,94,208,178,0,0,0,180,0,8,52,180,0,0,64,182,0,0,27,183,0,240,100,185,0,0,128,187,0,51,182,187,0,0,216,189,0,32,188,190,0,0,0,192,0,128,55,192,0,122,30,193,0,152,158,194,0,0,80,195,0,0,193,197,0,0,0,200,0,208,57,200,0,0,128,202,0,137,186,202,0,0,8,205,0,96,254,205,0,142,145,208,0,0,240,210,0,0,147,213,0,164,147,214,0,0,0,216,0,112,62,216,0,0,186,219,0,32,121,222,0,0,0,225,0,10,65,225,0,0,208,227,0,192,225,228,0,0,169,230,0,44,190,231,0,0,96,234,0,0,78,237,0,40,107,238,0,0,0,240,0,96,69,240,0,0,0,243,0,62,70,243,0,0,36,244,0,64,49,247,0,0,0,250,0,68,72,250,0,0,32,253,0,0,0,0,1,0,74,0,1,248,125,1,1,32,126,3,1,0,172,7,1,192,247,10,1,141,56,12,1,0,0,14,1,12,78,14,1,0,96,17,1,128,168,18,1,104,23,22,1,0,64,25,1,0,196,28,1,48,26,30,1,0,0,32,1,64,83,32,1,183,173,33,1,228,237,35,1,0,248,36,1,128,161,40,1,242,5,42,1,0,0,44,1,184,86,44,1,0,192,47,1,0,45,49,1,0,140,51,1,144,253,52,1,0,128,56,1,85,218,56,1,0,104,60,1,0,0,64,1,128,92,64,1,118,221,65,1,0,0,68,1,168,93,68,1,0,151,73,1,176,181,77,1,0,128,81,1,143,225,81,1,0,184,85,1,160,82,87,1,128,253,89,1,66,157,91,1,0,144,95,1,0,245,99,1,188,160,101,1,0,0,104,1,16,104,104,1,0,128,108,1,93,233,108,1,0,54,110,1,224,201,114,1,0,0,119,1,102,108,119,1,0,176,123,1,64,120,125,1,0,0,128,1,0,111,128,1,244,60,130,1,48,61,133,1,0,160,134,1,0,130,139,1,0,0,144,1,160,115,144,1,0,0,149,1,18,117,149,1,0,16,154,1,192,252,155,1,28,35,161,1,0,224,165,1,0,38,171,1,72,39,173,1,0,0,176,1,224,124,176,1,0,116,183,1,64,242,188,1,235,8,191,1,0,0,194,1,20,130,194,1,0,160,199,1,128,195,201,1,0,82,205,1,88,124,207,1,0,192,212,1,0,156,218,1,80,214,220,1,0,0,224,1,192,138,224,1,49,204,226,1,0,0,230,1,124,140,230,1,0,72,232,1,128,98,238,1,0,0,244,1,136,144,244,1,0,64,250,1,0,0,0,2,0,148,0,2,240,251,2,2,64,252,6,2,227,107,9,2,0,88,15,2,128,239,21,2,26,113,24,2,0,0,28,2,24,156,28,2,0,192,34,2,0,81,37,2,208,46,44,2,0,128,50,2,153,34,51,2,0,136,57,2,96,52,60,2,0,0,64,2,128,166,64,2,110,91,67,2,200,219,71,2,0,240,73,2,0,67,81,2,228,11,84,2,0,0,88,2,112,173,88,2,0,128,95,2,155,47,96,2,0,90,98,2,0,24,103,2,32,251,105,2,0,0,113,2,170,180,113,2,0,208,120,2,0,0,128,2,0,185,128,2,236,186,131,2,0,0,136,2,80,187,136,2,0,46,147,2,96,107,155,2,0,0,163,2,30,195,163,2,0,112,171,2,64,165,174,2,0,251,179,2,132,58,183,2,0,32,191,2,0,234,199,2,120,65,203,2,0,0,208,2,32,208,208,2,0,0,217,2,186,210,217,2,0,108,220,2,192,147,229,2,221,14,233,2,0,0,238,2,204,216,238,2,0,96,247,2,128,240,250,2,0,0,0,3,0,222,0,3,232,121,4,3,96,122,10,3,0,64,13,3,0,4,23,3,0,0,32,3,64,231,32,3,167,169,36,3,0,0,42,3,36,234,42,3,0,32,52,3,128,249,55,3,56,70,66,3,0,192,75,3,0,76,86,3,144,78,90,3,0,0,96,3,192,249,96,3,37,9,101,3,0,232,110,3,128,228,121,3,214,17,126,3,0,0,132,3,40,4,133,3,0,64,143,3,0,135,147,3,0,164,154,3,176,248,158,3,0,128,169,3,255,142,170,3,0,56,181,3,160,172,185,3,0,0,192,3,128,21,193,3,98,152,197,3,0,0,204,3,248,24,205,3,0,144,208,3,0,197,220,3,0,0,232,3,16,33,233,3,0,128,244,3,173,164,245,3,0,0,0,4,0,40,1,4,224,247,5,4,128,248,13,4,198,215,18,4,0,176,30,4,0,223,43,4,52,226,48,4,0,0,56,4,48,56,57,4,0,128,69,4,0,162,74,4,160,93,88,4,0,0,101,4,50,69,102,4,0,16,115,4,192,104,120,4,0,0,128,4,0,77,129,4,220,182,134,4,144,183,143,4,0,224,147,4,0,134,162,4,200,23,168,4,0,0,176,4,224,90,177,4,0,0,191,4,54,95,192,4,0,180,196,4,0,48,206,4,64,246,211,4,0,0,226,4,84,105,227,4,0,160,241,4,0,0,0,5,0,114,1,5,216,117,7,5,0,0,16,5,160,118,17,5,0,92,38,5,192,214,54,5,193,26,61,5,0,0,70,5,60,134,71,5,0,224,86,5,128,74,93,5,0,246,103,5,8,117,110,5,0,64,126,5,0,212,143,5,240,130,150,5,0,0,160,5,64,160,161,5,147,100,168,5,0,0,178,5,116,165,179,5,0,216,184,5,128,39,203,5,186,29,210,5,0,0,220,5,152,177,221,5,0,192,238,5,0,225,245,5,0,0,0,6,0,188,1,6,208,243,8,6,192,244,20,6,0,128,26,6,169,67,28,6,0,8,46,6,0,0,64,6,128,206,65,6,78,83,73,6,0,0,84,6,72,212,85,6,0,64,104,6,0,243,111,6,112,140,132,6,0,128,151,6,203,103,153,6,0,152,172,6,32,157,180,6,0,0,192,6,128,243,193,6,74,18,202,6,0,208,221,6,0,201,243,6,172,35,252,6,0,0,8,7,80,8,10,7,0,128,30,7,209,142,32,7,0,14,39,7,0,72,53,7,96,241,61,7,0,0,83,7,254,29,85,7,0,112,106,7,64,89,115,7,0,0,128,7,0,43,130,7,196,48,139,7,0,0,152,7,240,49,154,7,0,32,161,7,0,138,185,7,0,0,208,7,32,66,210,7,0,0,233,7,90,73,235,7,0,0,0,8,0,80,2,8,192,239,11,8,0,241,27,8,140,175,37,8,0,96,61,8,0,190,87,8,104,196,97,8,0,0,112,8,96,112,114,8,0,0,139,8,0,68,149,8,64,187,176,8,151,44,187,8,0,0,202,8,100,138,204,8,0,32,230,8,128,209,240,8,0,0,0,9,0,154,2,9,184,109,13,9,32,111,31,9,0,192,39,9,0,12,69,9,144,47,80,9,0,0,96,9,192,181,98,9,245,252,109,9,0,0,126,9,108,190,128,9,0,104,137,9,0,96,156,9,128,236,167,9,0,0,196,9,168,210,198,9,0,64,227,9,0,0,0,10,0,228,2,10,176,235,14,10,0,0,32,10,64,237,34,10,111,27,47,10,0,184,76,10,128,173,109,10,130,53,122,10,0,0,140,10,120,12,143,10,0,192,173,10,0,149,186,10,0,236,207,10,16,234,220,10,0,128,252,10,253,172,255,10,0,168,31,11,224,5,45,11,0,0,64,11,128,64,67,11,38,201,80,11,0,0,100,11,232,74,103,11,0,176,113,11,0,79,150,11,116,59,164,11,0,0,184,11,48,99,187,11,0,128,221,11,7,238,224,11,0,194,235,11,0,0,0,12,0,120,3,12,160,231,17,12,128,233,41,12,0,0,53,12,82,135,56,12,0,16,92,12,0,0,128,12,0,157,131,12,156,166,146,12,0,0,168,12,144,168,171,12,0,128,208,12,0,230,223,12,224,24,9,13,0,0,47,13,150,207,50,13,0,48,89,13,64,58,105,13,0,0,128,13,0,231,131,13,148,36,148,13,0,160,187,13,0,146,231,13,88,71,248,13,0,0,16,14,160,16,20,14,0,0,61,14,162,29,65,14,0,28,78,14,0,144,106,14,192,226,123,14,81,74,141,14,0,0,166,14,252,59,170,14,0,224,212,14,128,178,230,14,0,0,0,15,0,86,4,15,136,97,22,15,0,0,48,15,224,99,52,15,0,64,66,15,0,20,115,15,0,0,160,15,64,132,164,15,67,80,183,15,0,0,210,15,180,146,214,15,0,0,0,16,0,160,4,16,128,223,23,16,0,226,55,16,24,95,75,16,0,192,122,16,0,124,175,16,208,136,195,16,0,0,224,16,192,224,228,16,185,45,249,16,0,0,22,17,0,136,42,17,128,118,97,17,46,89,118,17,0,0,148,17,200,20,153,17,0,64,204,17,0,163,225,17,0,0,0,18,0,52,5,18,112,219,26,18,64,222,62,18,0,128,79,18,251,202,84,18,0,24,138,18,32,95,160,18,0,0,192,18,128,107,197,18,234,249,219,18,0,0,252,18,216,124,1,19,0,208,18,19,0,192,56,19,0,217,79,19,0,0,136,19,80,165,141,19,0,128,198,19,97,55,204,19,0,0,0,20,0,200,5,20,96,215,29,20,0,0,64,20,128,218,69,20,222,54,94,20,0,112,153,20,0,91,219,20,4,107,244,20,0,0,24,21,240,24,30,21,0,128,91,21,0,42,117,21,0,216,159,21,32,212,185,21,0,0,249,21,250,89,255,21,0,80,63,22,192,11,90,22,0,0,128,22,0,129,134,22,76,146,161,22,0,0,200,22,208,149,206,22,0,96,227,22,0,158,44,23,232,118,72,23,0,0,112,23,96,198,118,23,0,0,187,23,14,220,193,23,0,132,215,23,0,0,0,24,0,240,6,24,64,207,35,24,0,211,83,24,0,0,106,24,164,14,113,24,0,32,184,24,0,0,0,25,0,58,7,25,56,77,37,25,0,0,80,25,32,81,87,25,0,0,161,25,0,204,191,25,192,49,18,26,197,133,49,26,0,0,94,26,44,159,101,26,0,96,178,26,128,116,210,26,0,0,0,27,0,206,7,27,40,73,40,27,0,64,119,27,0,36,207,27,176,142,240,27,0,0,32,28,64,33,40,28,223,246,73,28,0,0,122,28,68,59,130,28,0,56,156,28,0,32,213,28,128,197,247,28,162,148,26,29,0,0,76,29,248,119,84,29,0,192,169,29,0,101,205,29,0,0,0,30,0,172,8,30,16,195,44,30,0,0,96,30,192,199,104,30,0,128,132,30,77,82,141,30,0,40,230,30,0,0,64,31,128,8,73,31,134,160,110,31,0,0,164,31,104,37,173,31,0,0,0,32,0,64,9,32,0,191,47,32,0,196,111,32,48,190,150,32,0,128,245,32,247,6,255,32,0,248,94,33,160,17,135,33,0,0,192,33,128,193,201,33,114,91,242,33,0,0,44,34,0,16,85,34,0,237,194,34,92,178,236,34,0,0,40,35,144,41,50,35,0,128,152,35,21,202,162,35,0,70,195,35,0,0,0,36,0,104,10,36,224,182,53,36,128,188,125,36,0,0,159,36,246,149,169,36,0,48,20,37,64,190,64,37,0,0,128,37,0,215,138,37,212,243,183,37,0,0,248,37,176,249,2,38,0,160,37,38,0,128,113,38,0,178,159,38,0,0,16,39,160,74,27,39,0,0,141,39,194,110,152,39,0,0,0,40,0,144,11,40,192,174,59,40,0,0,128,40,0,181,139,40,188,109,188,40,0,224,50,41,0,182,182,41,8,214,232,41,0,0,48,42,224,49,60,42,0,0,183,42,0,84,234,42,0,176,63,43,64,168,115,43,243,222,167,43,0,0,242,43,244,179,254,43,0,160,126,44,128,23,180,44,0,0,0,45,0,2,13,45,152,36,67,45,0,0,144,45,160,43,157,45,0,192,198,45,0,60,89,46,208,237,144,46,0,0,224,46,192,140,237,46,201,240,37,47,0,0,118,47,28,184,131,47,0,8,175,47,0,0,0,48,0,224,13,48,128,158,71,48,0,166,167,48,0,0,212,48,72,29,226,48,0,64,112,49,0,0,0,50,0,116,14,50,112,154,74,50,0,0,160,50,64,162,174,50,43,137,235,50,0,0,66,51,0,152,127,51,128,99,36,52,138,11,99,52,0,0,188,52,88,62,203,52,0,192,100,53,0,233,164,53,0,0,0,54,0,156,15,54,80,146,80,54,0,128,238,54,241,96,254,54,0,72,158,55,96,29,225,55,0,0,64,56,128,66,80,56,190,237,147,56,0,0,244,56,136,118,4,57,0,112,56,57,0,64,170,57,0,139,239,57,68,41,53,58,0,0,152,58,240,239,168,58,0,128,83,59,35,166,100,59,0,202,154,59,0,0,0,60,0,88,17,60,32,134,89,60,0,0,192,60,128,143,209,60,0,0,9,61,154,164,26,61,0,80,204,61,0,0,128,62,0,17,146,62,12,65,221,62,0,0,72,63,208,74,90,63,0,0,0,64,0,128,18,64,0,126,95,64,0,136,223,64,96,124,45,65,0,0,235,65,238,13,254,65,0,240,189,66,64,35,14,67,0,0,128,67,0,131,147,67,228,182,228,67,0,0,88,68,0,32,170,68,0,218,133,69,184,100,217,69,0,0,80,70,32,83,100,70,0,0,49,71,42,148,69,71,0,140,134,71,0,0,0,72,0,208,20,72,192,109,107,72,149,115,194,72,0,121,251,72,0,0,62,73,236,43,83,73,0,96,40,74,128,124,129,74,0,0,0,75,0,174,21,75,168,231,111,75,0,0,240,75,96,243,5,76,0,64,75,76,0,0,227,76,0,100,63,77,0,0,32,78,64,149,54,78,79,145,148,78,0,0,26,79,132,221,48,79,0,0,0,80,0,32,23,80,128,93,119,80,0,0,0,81,0,106,23,81,120,219,120,81,0,192,101,82,0,108,109,83,16,172,209,83,0,0,96,84,192,99,120,84,157,228,221,84,0,0,110,85,0,168,212,85,0,96,127,86,128,80,231,86,230,189,79,87,0,0,228,87,232,103,253,87,0,64,253,88,0,47,104,89,0,0,0,90,0,4,26,90,48,73,134,90,0,0,32,91,64,87,58,91,0,128,141,91,231,246,167,91,0,120,178,92,160,219,33,93,0,0,192,93,128,25,219,93,146,225,75,94,0,0,236,94,56,112,7,95,0,16,94,95,0,0,0,96,0,192,27,96,0,61,143,96,0,76,79,97,0,0,168,97,144,58,196,97,0,128,224,98,229,20,253,98,0,0,0,100,0,232,28,100,224,52,149,100,0,0,64,101,128,68,93,101,86,18,215,101,0,0,132,102,0,48,255,102,0,199,72,104,20,23,198,104,0,0,120,105,176,124,150,105,0,128,201,106,0,210,73,107,0,0,0,108,0,56,31,108,160,36,161,108,0,0,221,109,226,193,252,109,0,144,60,111,192,58,194,111,0,0,128,112,0,133,160,112,124,219,39,113,0,0,232,113,16,237,8,114,0,224,112,114,0,128,84,115,0,22,223,115,136,82,106,116,0,0,48,117,224,223,81,117,0,0,167,118,70,76,201,118,0,148,53,119,0,0,0,120,0,176,34,120,64,12,179,120,0,0,128,121,0,31,163,121,0,0,18,122,52,73,53,122,0,160,152,123,0,0,0,125,0,34,36,125,24,130,186,125,0,0,144,126,160,149,180,126,216,62,8,0,127,78,3,0,60,78,3,0,97,0,0,0,1,0,0,0,18,0,0,0,18,0,0,0,19,0,0,0,19,0,0,0,20,0,0,0,20,0,0,0,21,0,0,0,0,0,0,0,220,62,8,0,2,79,3,0,60,78,3,0,52,1,0,0,1,0,0,0,224,62,8,0,131,79,3,0,60,78,3,0,166,1,0,0,1,0,0,0,228,62,8,0,185,79,3,0,230,79,3,0,14,0,0,0,1,0,0,0,232,62,8,0,46,80,3,0,230,79,3,0,22,0,0,0,1,0,0,0,236,62,8,0,182,81,3,0,129,80,3,0,116,1,0,0,1,0,0,0,240,62,8,0,252,81,3,0,129,80,3,0,124,1,0,0,1,0,0,0,244,62,8,0,65,82,3,0,129,80,3,0,132,1,0,0,1,0,0,0,248,62,8,0,135,82,3,0,129,80,3,0,140,1,0,0,1,0,0,0,252,62,8,0,193,82,3,0,129,80,3,0,148,1,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,0,63,8,0,243,82,3,0,129,80,3,0,155,1,0,0,1,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,0,0,0,0,4,63,8,0,37,83,3,0,129,80,3,0,162,1,0,0,1,0,0,0,8,63,8,0,95,83,3,0,129,80,3,0,170,1,0,0,1,0,0,0,12,63,8,0,63,85,3,0,129,80,3,0,156,3,0,0,1,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,0,0,0,0,16,63,8,0,130,85,3,0,129,80,3,0,164,3,0,0,1,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,0,0,0,0,20,63,8,0,202,85,3,0,129,80,3,0,224,3,0,0,1,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,0,0,0,0,24,63,8,0,0,86,3,0,129,80,3,0,21,4,0,0,1,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,0,0,0,0,28,63,8,0,68,86,3,0,129,80,3,0,30,4,0,0,1,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,0,0,0,0,32,63,8,0,134,86,3,0,129,80,3,0,38,4,0,0,1,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,0,0,0,0,36,63,8,0,188,86,3,0,129,80,3,0,67,4,0,0,1,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,0,0,0,0,40,63,8,0,35,88,3,0,129,80,3,0,207,4,0,0,1,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,0,0,0,0,44,63,8,0,87,89,3,0,129,80,3,0,224,6,0,0,1,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,192,46,0,0,77,0,0,0,78,0,0,0,41,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,176,46,0,0,47,0,0,0,79,0,0,0,80,0,0,0,0,0,0,0,160,46,0,0,77,0,0,0,81,0,0,0,42,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,144,46,0,0,47,0,0,0,82,0,0,0,83,0,0,0,0,0,0,0,128,46,0,0,77,0,0,0,84,0,0,0,43,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,112,46,0,0,47,0,0,0,85,0,0,0,86,0,0,0,0,0,0,0,96,46,0,0,77,0,0,0,87,0,0,0,44,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,80,46,0,0,47,0,0,0,88,0,0,0,89,0,0,0,0,0,0,0,64,46,0,0,77,0,0,0,90,0,0,0,45,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,48,46,0,0,47,0,0,0,91,0,0,0,92,0,0,0,0,0,0,0,240,45,0,0,77,0,0,0,93,0,0,0,46,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,0,0,0,0,224,45,0,0,47,0,0,0,94,0,0,0,95,0,0,0,0,0,0,0,0,46,0,0,47,0,0,0,96,0,0,0,97,0,0,0,0,0,0,0,16,46,0,0,13,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,115,91,3,0,121,91,3,0,126,91,3,0,133,91,3,0,40,93,7,0,139,91,3,0,147,91,3,0,33,93,7,0,153,102,3,0,153,102,3,0,190,185,17,0,190,185,17,0,158,102,3,0,162,102,3,0,158,102,3,0,166,102,3,0,68,63,8,0,211,103,3,0,229,93,3,0,174,12,0,0,1,0,0,0,0,0,0,195,0,0,254,194,0,0,252,194,0,0,250,194,0,0,248,194,0,0,246,194,0,0,244,194,0,0,242,194,0,0,240,194,0,0,238,194,0,0,236,194,0,0,234,194,0,0,232,194,0,0,230,194,0,0,228,194,0,0,226,194,0,0,224,194,0,0,222,194,0,0,220,194,0,0,218,194,0,0,216,194,0,0,214,194,0,0,212,194,0,0,210,194,0,0,208,194,0,0,206,194,0,0,204,194,0,0,202,194,0,0,200,194,0,0,198,194,0,0,196,194,0,0,194,194,0,0,192,194,0,0,190,194,0,0,188,194,0,0,186,194,0,0,184,194,0,0,182,194,0,0,180,194,0,0,178,194,0,0,176,194,0,0,174,194,0,0,172,194,0,0,170,194,0,0,168,194,0,0,166,194,0,0,164,194,0,0,162,194,0,0,160,194,0,0,158,194,0,0,156,194,0,0,154,194,0,0,152,194,0,0,150,194,0,0,148,194,0,0,146,194,0,0,144,194,0,0,142,194,0,0,140,194,0,0,138,194,0,0,136,194,0,0,134,194,0,0,132,194,0,0,130,194,0,0,128,194,0,0,124,194,0,0,120,194,0,0,116,194,0,0,112,194,0,0,108,194,0,0,104,194,0,0,100,194,0,0,96,194,0,0,92,194,0,0,88,194,0,0,84,194,0,0,80,194,0,0,76,194,0,0,72,194,0,0,68,194,0,0,64,194,0,0,60,194,0,0,56,194,0,0,52,194,0,0,48,194,0,0,44,194,0,0,40,194,0,0,36,194,0,0,32,194,0,0,28,194,0,0,24,194,0,0,20,194,0,0,16,194,0,0,12,194,0,0,8,194,0,0,4,194,0,0,0,194,0,0,248,193,0,0,240,193,0,0,232,193,0,0,224,193,0,0,216,193,0,0,208,193,0,0,200,193,0,0,192,193,0,0,184,193,0,0,176,193,0,0,168,193,0,0,160,193,0,0,152,193,0,0,144,193,0,0,136,193,0,0,128,193,0,0,112,193,0,0,96,193,0,0,80,193,0,0,64,193,0,0,48,193,0,0,32,193,0,0,16,193,0,0,0,193,0,0,224,192,0,0,192,192,0,0,160,192,0,0,128,192,0,0,64,192,0,0,0,192,0,0,128,191,0,0,0,0,0,0,128,63,0,0,0,64,0,0,64,64,0,0,128,64,0,0,160,64,0,0,192,64,0,0,224,64,0,0,0,65,0,0,16,65,0,0,32,65,0,0,48,65,0,0,64,65,0,0,80,65,0,0,96,65,0,0,112,65,0,0,128,65,0,0,136,65,0,0,144,65,0,0,152,65,0,0,160,65,0,0,168,65,0,0,176,65,0,0,184,65,0,0,192,65,0,0,200,65,0,0,208,65,0,0,216,65,0,0,224,65,0,0,232,65,0,0,240,65,0,0,248,65,0,0,0,66,0,0,4,66,0,0,8,66,0,0,12,66,0,0,16,66,0,0,20,66,0,0,24,66,0,0,28,66,0,0,32,66,0,0,36,66,0,0,40,66,0,0,44,66,0,0,48,66,0,0,52,66,0,0,56,66,0,0,60,66,0,0,64,66,0,0,68,66,0,0,72,66,0,0,76,66,0,0,80,66,0,0,84,66,0,0,88,66,0,0,92,66,0,0,96,66,0,0,100,66,0,0,104,66,0,0,108,66,0,0,112,66,0,0,116,66,0,0,120,66,0,0,124,66,0,0,128,66,0,0,130,66,0,0,132,66,0,0,134,66,0,0,136,66,0,0,138,66,0,0,140,66,0,0,142,66,0,0,144,66,0,0,146,66,0,0,148,66,0,0,150,66,0,0,152,66,0,0,154,66,0,0,156,66,0,0,158,66,0,0,160,66,0,0,162,66,0,0,164,66,0,0,166,66,0,0,168,66,0,0,170,66,0,0,172,66,0,0,174,66,0,0,176,66,0,0,178,66,0,0,180,66,0,0,182,66,0,0,184,66,0,0,186,66,0,0,188,66,0,0,190,66,0,0,192,66,0,0,194,66,0,0,196,66,0,0,198,66,0,0,200,66,0,0,202,66,0,0,204,66,0,0,206,66,0,0,208,66,0,0,210,66,0,0,212,66,0,0,214,66,0,0,216,66,0,0,218,66,0,0,220,66,0,0,222,66,0,0,224,66,0,0,226,66,0,0,228,66,0,0,230,66,0,0,232,66,0,0,234,66,0,0,236,66,0,0,238,66,0,0,240,66,0,0,242,66,0,0,244,66,0,0,246,66,0,0,248,66,0,0,250,66,0,0,252,66,0,0,254,66,0,0,0,67,0,0,1,67,0,0,2,67,0,0,3,67,0,0,4,67,0,0,5,67,0,0,6,67,0,0,7,67,0,0,8,67,0,0,9,67,0,0,10,67,0,0,11,67,0,0,12,67,0,0,13,67,0,0,14,67,0,0,15,67,0,0,16,67,0,0,17,67,0,0,18,67,0,0,19,67,0,0,20,67,0,0,21,67,0,0,22,67,0,0,23,67,0,0,24,67,0,0,25,67,0,0,26,67,0,0,27,67,0,0,28,67,0,0,29,67,0,0,30,67,0,0,31,67,0,0,32,67,0,0,33,67,0,0,34,67,0,0,35,67,0,0,36,67,0,0,37,67,0,0,38,67,0,0,39,67,0,0,40,67,0,0,41,67,0,0,42,67,0,0,43,67,0,0,44,67,0,0,45,67,0,0,46,67,0,0,47,67,0,0,48,67,0,0,49,67,0,0,50,67,0,0,51,67,0,0,52,67,0,0,53,67,0,0,54,67,0,0,55,67,0,0,56,67,0,0,57,67,0,0,58,67,0,0,59,67,0,0,60,67,0,0,61,67,0,0,62,67,0,0,63,67,0,0,64,67,0,0,65,67,0,0,66,67,0,0,67,67,0,0,68,67,0,0,69,67,0,0,70,67,0,0,71,67,0,0,72,67,0,0,73,67,0,0,74,67,0,0,75,67,0,0,76,67,0,0,77,67,0,0,78,67,0,0,79,67,0,0,80,67,0,0,81,67,0,0,82,67,0,0,83,67,0,0,84,67,0,0,85,67,0,0,86,67,0,0,87,67,0,0,88,67,0,0,89,67,0,0,90,67,0,0,91,67,0,0,92,67,0,0,93,67,0,0,94,67,0,0,95,67,0,0,96,67,0,0,97,67,0,0,98,67,0,0,99,67,0,0,100,67,0,0,101,67,0,0,102,67,0,0,103,67,0,0,104,67,0,0,105,67,0,0,106,67,0,0,107,67,0,0,108,67,0,0,109,67,0,0,110,67,0,0,111,67,0,0,112,67,0,0,113,67,0,0,114,67,0,0,115,67,0,0,116,67,0,0,117,67,0,0,118,67,0,0,119,67,0,0,120,67,0,0,121,67,0,0,122,67,0,0,123,67,0,0,124,67,0,0,125,67,0,0,126,67,0,0,127,67,60,0,0,0,0,0,0,0,0,47,0,0,101,0,0,0,102,0,0,0,196,255,255,255,196,255,255,255,0,47,0,0,103,0,0,0,104,0,0,0,64,196,0,0,228,46,0,0,248,46,0,0,84,196,0,0,108,127,13,0,62,149,3,0,101,147,3,0,137,6,0,0,1,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,9,0,0,0,10,0,0,0,0,0,0,0,11,0,0,0,12,0,0,0,0,0,0,0,13,0,0,0,0,0,0,0,14,0,0,0,15,0,0,0,0,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,18,0,0,0,0,0,0,0,19,0,0,0,20,0,0,0,0,0,0,0,21,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,16,47,0,0,30,0,0,0,105,0,0,0,19,0,0,0,0,0,0,0,32,47,0,0,106,0,0,0,107,0,0,0,20,0,0,0,112,127,13,0,128,150,3,0,101,147,3,0,33,10,0,0,1,0,0,0,0,0,0,0,48,47,0,0,108,0,0,0,109,0,0,0,21,0,0,0,116,127,13,0,101,151,3,0,101,147,3,0,85,11,0,0,1,0,0,0,120,127,13,0,195,151,3,0,101,147,3,0,183,11,0,0,1,0,0,0,128,127,13,0,48,152,3,0,101,147,3,0,228,11,0,0,1,0,0,0,132,127,13,0,246,153,3,0,78,153,3,0,87,2,0,0,1,0,0,0,136,127,13,0,82,157,3,0,138,154,3,0,22,2,0,0,1,0,0,0,140,127,13,0,63,158,3,0,181,157,3,0,97,0,0,0,1,0,0,0,144,127,13,0,9,161,3,0,179,158,3,0,68,4,0,0,1,0,0,0,148,127,13,0,193,161,3,0,120,161,3,0,93,1,0,0,1,0,0,0,0,0,0,0,64,47,0,0,110,0,0,0,111,0,0,0,1,0,0,0,0,0,0,0,72,47,0,0,112,0,0,0,113,0,0,0,1,0,0,0,114,0,0,0,0,0,0,0,80,47,0,0,115,0,0,0,116,0,0,0,1,0,0,0,117,0,0,0,0,0,0,0,88,47,0,0,118,0,0,0,119,0,0,0,8,0,0,0,9,0,0,0,29,0,0,0,33,0,0,0,152,127,13,0,159,162,3,0,91,162,3,0,130,1,0,0,1,0,0,0,0,0,0,0,208,48,0,0,47,0,0,0,120,0,0,0,121,0,0,0,0,0,0,0,160,48,0,0,47,0,0,0,122,0,0,0,123,0,0,0,0,0,0,0,128,48,0,0,47,0,0,0,124,0,0,0,125,0,0,0,0,0,0,0,96,48,0,0,47,0,0,0,126,0,0,0,127,0,0,0,0,0,0,0,64,48,0,0,47,0,0,0,128,0,0,0,129,0,0,0,0,0,0,0,32,48,0,0,47,0,0,0,130,0,0,0,131,0,0,0,0,0,0,0,0,48,0,0,47,0,0,0,132,0,0,0,133,0,0,0,0,0,0,0,224,47,0,0,47,0,0,0,134,0,0,0,135,0,0,0,0,0,0,0,192,47,0,0,47,0,0,0,136,0,0,0,137,0,0,0,0,0,0,0,160,47,0,0,47,0,0,0,138,0,0,0,139,0,0,0,0,0,0,0,128,47,0,0,47,0,0,0,140,0,0,0,141,0,0,0,0,0,0,0,96,47,0,0,47,0,0,0,142,0,0,0,143,0,0,0,0,0,0,0,112,47,0,0,144,0,0,0,145,0,0,0,34,0,0,0,0,0,0,0,144,47,0,0,146,0,0,0,147,0,0,0,35,0,0,0,0,0,0,0,176,47,0,0,148,0,0,0,149,0,0,0,36,0,0,0,0,0,0,0,208,47,0,0,150,0,0,0,151,0,0,0,37,0,0,0,0,0,0,0,240,47,0,0,152,0,0,0,153,0,0,0,38,0,0,0,0,0,0,0,16,48,0,0,154,0,0,0,155,0,0,0,39,0,0,0,0,0,0,0,48,48,0,0,156,0,0,0,157,0,0,0,40,0,0,0,0,0,0,0,80,48,0,0,158,0,0,0,159,0,0,0,41,0,0,0,0,0,0,0,112,48,0,0,160,0,0,0,161],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+40960);allocate([42,0,0,0,0,0,0,0,144,48,0,0,162,0,0,0,163,0,0,0,43,0,0,0,0,0,0,0,192,48,0,0,164,0,0,0,165,0,0,0,44,0,0,0,0,0,0,0,176,48,0,0,164,0,0,0,166,0,0,0,45,0,0,0,0,0,0,0,240,48,0,0,167,0,0,0,168,0,0,0,46,0,0,0,0,0,0,0,224,48,0,0,167,0,0,0,169,0,0,0,47,0,0,0,0,0,0,0,0,52,0,0,47,0,0,0,170,0,0,0,171,0,0,0,0,0,0,0,240,51,0,0,47,0,0,0,172,0,0,0,173,0,0,0,0,0,0,0,224,51,0,0,47,0,0,0,174,0,0,0,175,0,0,0,0,0,0,0,208,51,0,0,47,0,0,0,176,0,0,0,177,0,0,0,0,0,0,0,192,51,0,0,47,0,0,0,178,0,0,0,179,0,0,0,0,0,0,0,176,51,0,0,47,0,0,0,180,0,0,0,181,0,0,0,0,0,0,0,160,51,0,0,47,0,0,0,182,0,0,0,183,0,0,0,0,0,0,0,144,51,0,0,47,0,0,0,184,0,0,0,185,0,0,0,0,0,0,0,128,51,0,0,47,0,0,0,186,0,0,0,187,0,0,0,0,0,0,0,96,51,0,0,47,0,0,0,188,0,0,0,189,0,0,0,0,0,0,0,32,51,0,0,47,0,0,0,190,0,0,0,191,0,0,0,0,0,0,0,224,50,0,0,47,0,0,0,192,0,0,0,193,0,0,0,0,0,0,0,176,50,0,0,47,0,0,0,194,0,0,0,195,0,0,0,0,0,0,0,128,50,0,0,47,0,0,0,196,0,0,0,197,0,0,0,0,0,0,0,80,50,0,0,47,0,0,0,198,0,0,0,199,0,0,0,0,0,0,0,32,50,0,0,47,0,0,0,200,0,0,0,201,0,0,0,0,0,0,0,240,49,0,0,47,0,0,0,202,0,0,0,203,0,0,0,0,0,0,0,192,49,0,0,47,0,0,0,204,0,0,0,205,0,0,0,0,0,0,0,144,49,0,0,47,0,0,0,206,0,0,0,207,0,0,0,0,0,0,0,96,49,0,0,47,0,0,0,208,0,0,0,209,0,0,0,0,0,0,0,48,49,0,0,47,0,0,0,210,0,0,0,211,0,0,0,0,0,0,0,0,49,0,0,47,0,0,0,212,0,0,0,213,0,0,0,0,0,0,0,32,49,0,0,214,0,0,0,215,0,0,0,22,0,0,0,114,0,0,0,0,0,0,0,16,49,0,0,214,0,0,0,216,0,0,0,23,0,0,0,114,0,0,0,0,0,0,0,80,49,0,0,217,0,0,0,218,0,0,0,24,0,0,0,114,0,0,0,0,0,0,0,64,49,0,0,217,0,0,0,219,0,0,0,25,0,0,0,114,0,0,0,0,0,0,0,128,49,0,0,220,0,0,0,221,0,0,0,26,0,0,0,114,0,0,0,0,0,0,0,112,49,0,0,220,0,0,0,222,0,0,0,27,0,0,0,114,0,0,0,0,0,0,0,176,49,0,0,223,0,0,0,224,0,0,0,28,0,0,0,114,0,0,0,0,0,0,0,160,49,0,0,223,0,0,0,225,0,0,0,29,0,0,0,114,0,0,0,0,0,0,0,224,49,0,0,226,0,0,0,227,0,0,0,30,0,0,0,114,0,0,0,0,0,0,0,208,49,0,0,226,0,0,0,228,0,0,0,31,0,0,0,114,0,0,0,0,0,0,0,16,50,0,0,229,0,0,0,230,0,0,0,32,0,0,0,114,0,0,0,0,0,0,0,0,50,0,0,229,0,0,0,231,0,0,0,33,0,0,0,114,0,0,0,0,0,0,0,64,50,0,0,232,0,0,0,233,0,0,0,34,0,0,0,114,0,0,0,0,0,0,0,48,50,0,0,232,0,0,0,234,0,0,0,35,0,0,0,114,0,0,0,0,0,0,0,112,50,0,0,235,0,0,0,236,0,0,0,36,0,0,0,114,0,0,0,0,0,0,0,96,50,0,0,235,0,0,0,237,0,0,0,37,0,0,0,114,0,0,0,0,0,0,0,160,50,0,0,238,0,0,0,239,0,0,0,38,0,0,0,114,0,0,0,0,0,0,0,144,50,0,0,238,0,0,0,240,0,0,0,39,0,0,0,114,0,0,0,0,0,0,0,208,50,0,0,241,0,0,0,242,0,0,0,40,0,0,0,114,0,0,0,0,0,0,0,192,50,0,0,241,0,0,0,243,0,0,0,41,0,0,0,114,0,0,0,0,0,0,0,0,51,0,0,244,0,0,0,245,0,0,0,42,0,0,0,114,0,0,0,0,0,0,0,240,50,0,0,244,0,0,0,246,0,0,0,43,0,0,0,114,0,0,0,0,0,0,0,16,51,0,0,244,0,0,0,247,0,0,0,44,0,0,0,114,0,0,0,0,0,0,0,64,51,0,0,248,0,0,0,249,0,0,0,45,0,0,0,114,0,0,0,0,0,0,0,48,51,0,0,248,0,0,0,250,0,0,0,46,0,0,0,114,0,0,0,0,0,0,0,80,51,0,0,248,0,0,0,251,0,0,0,47,0,0,0,114,0,0,0,0,0,0,0,112,51,0,0,241,0,0,0,252,0,0,0,48,0,0,0,114,0,0,0,0,0,0,0,16,52,0,0,47,0,0,0,253,0,0,0,254,0,0,0,0,0,0,0,160,53,0,0,47,0,0,0,255,0,0,0,0,1,0,0,0,0,0,0,128,53,0,0,47,0,0,0,1,1,0,0,2,1,0,0,0,0,0,0,96,53,0,0,47,0,0,0,3,1,0,0,4,1,0,0,0,0,0,0,64,53,0,0,47,0,0,0,5,1,0,0,6,1,0,0,0,0,0,0,32,53,0,0,47,0,0,0,7,1,0,0,8,1,0,0,0,0,0,0,0,53,0,0,47,0,0,0,9,1,0,0,10,1,0,0,0,0,0,0,224,52,0,0,47,0,0,0,11,1,0,0,12,1,0,0,0,0,0,0,192,52,0,0,47,0,0,0,13,1,0,0,14,1,0,0,0,0,0,0,160,52,0,0,47,0,0,0,15,1,0,0,16,1,0,0,0,0,0,0,128,52,0,0,47,0,0,0,17,1,0,0,18,1,0,0,0,0,0,0,96,52,0,0,47,0,0,0,19,1,0,0,20,1,0,0,0,0,0,0,64,52,0,0,47,0,0,0,21,1,0,0,22,1,0,0,0,0,0,0,32,52,0,0,47,0,0,0,23,1,0,0,24,1,0,0,0,0,0,0,48,52,0,0,25,1,0,0,26,1,0,0,23,0,0,0,117,0,0,0,0,0,0,0,80,52,0,0,27,1,0,0,28,1,0,0,24,0,0,0,117,0,0,0,0,0,0,0,112,52,0,0,29,1,0,0,30,1,0,0,25,0,0,0,117,0,0,0,0,0,0,0,144,52,0,0,31,1,0,0,32,1,0,0,26,0,0,0,117,0,0,0,0,0,0,0,176,52,0,0,33,1,0,0,34,1,0,0,27,0,0,0,117,0,0,0,0,0,0,0,208,52,0,0,35,1,0,0,36,1,0,0,28,0,0,0,117,0,0,0,0,0,0,0,240,52,0,0,37,1,0,0,38,1,0,0,29,0,0,0,117,0,0,0,0,0,0,0,16,53,0,0,39,1,0,0,40,1,0,0,30,0,0,0,117,0,0,0,0,0,0,0,48,53,0,0,41,1,0,0,42,1,0,0,31,0,0,0,117,0,0,0,0,0,0,0,80,53,0,0,43,1,0,0,44,1,0,0,32,0,0,0,117,0,0,0,0,0,0,0,112,53,0,0,45,1,0,0,46,1,0,0,33,0,0,0,117,0,0,0,0,0,0,0,144,53,0,0,47,1,0,0,48,1,0,0,34,0,0,0,117,0,0,0,0,0,0,0,176,53,0,0,49,1,0,0,50,1,0,0,35,0,0,0,117,0,0,0,156,127,13,0,132,198,3,0,91,162,3,0,34,19,0,0,1,0,0,0,160,127,13,0,89,199,3,0,91,162,3,0,65,19,0,0,1,0,0,0,164,127,13,0,8,200,3,0,193,199,3,0,241,1,0,0,1,0,0,0,168,127,13,0,87,200,3,0,193,199,3,0,23,2,0,0,1,0,0,0,172,127,13,0,135,200,3,0,193,199,3,0,30,2,0,0,1,0,0,0,176,127,13,0,2,202,3,0,114,201,3,0,110,1,0,0,1,0,0,0,196,127,13,0,24,214,3,0,194,202,3,0,89,14,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,0,0,0,0,0,0,0,50,0,0,0,51,0,0,0,0,0,0,0,52,0,0,0,53,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,37,0,0,0,38,0,0,0,0,0,0,0,39,0,0,0,40,0,0,0,0,0,0,0,78,0,0,0,0,0,0,0,79,0,0,0,80,0,0,0,0,0,0,0,81,0,0,0,82,0,0,0,0,0,0,0,83,0,0,0,0,0,0,0,84,0,0,0,85,0,0,0,0,0,0,0,86,0,0,0,87,0,0,0,0,0,0,0,88,0,0,0,0,0,0,0,89,0,0,0,90,0,0,0,0,0,0,0,91,0,0,0,92,0,0,0,0,0,0,0,0,0,0,0,192,53,0,0,51,1,0,0,52,1,0,0,22,0,0,0,0,0,0,0,208,53,0,0,53,1,0,0,54,1,0,0,23,0,0,0,0,0,0,0,224,53,0,0,55,1,0,0,56,1,0,0,24,0,0,0,0,0,0,0,240,53,0,0,57,1,0,0,58,1,0,0,25,0,0,0,0,0,0,0,0,54,0,0,59,1,0,0,60,1,0,0,26,0,0,0,0,0,0,0,16,54,0,0,61,1,0,0,62,1,0,0,27,0,0,0,0,0,0,0,32,54,0,0,63,1,0,0,64,1,0,0,28,0,0,0,0,0,0,0,48,54,0,0,65,1,0,0,66,1,0,0,29,0,0,0,0,0,0,0,64,54,0,0,67,1,0,0,68,1,0,0,30,0,0,0,0,0,0,0,80,54,0,0,69,1,0,0,70,1,0,0,31,0,0,0,0,0,0,0,96,54,0,0,71,1,0,0,72,1,0,0,32,0,0,0,0,0,0,0,112,54,0,0,73,1,0,0,74,1,0,0,33,0,0,0,0,0,0,0,128,54,0,0,75,1,0,0,76,1,0,0,34,0,0,0,0,0,0,0,144,54,0,0,77,1,0,0,78,1,0,0,35,0,0,0,0,0,0,0,160,54,0,0,79,1,0,0,80,1,0,0,36,0,0,0,0,0,0,0,176,54,0,0,30,0,0,0,81,1,0,0,37,0,0,0,0,0,0,0,192,54,0,0,30,0,0,0,82,1,0,0,38,0,0,0,0,0,0,0,208,54,0,0,30,0,0,0,83,1,0,0,39,0,0,0,0,0,0,0,224,54,0,0,30,0,0,0,84,1,0,0,40,0,0,0,0,0,0,0,240,54,0,0,30,0,0,0,85,1,0,0,41,0,0,0,0,0,0,0,0,55,0,0,86,1,0,0,87,1,0,0,42,0,0,0,0,0,0,0,16,55,0,0,88,1,0,0,89,1,0,0,43,0,0,0,0,0,0,0,32,55,0,0,90,1,0,0,91,1,0,0,44,0,0,0,0,0,0,0,48,55,0,0,92,1,0,0,93,1,0,0,45,0,0,0,0,0,0,0,64,55,0,0,94,1,0,0,95,1,0,0,46,0,0,0,0,0,0,0,80,55,0,0,96,1,0,0,97,1,0,0,47,0,0,0,0,0,0,0,96,55,0,0,30,0,0,0,98,1,0,0,48,0,0,0,0,0,0,0,112,55,0,0,30,0,0,0,99,1,0,0,49,0,0,0,0,0,0,0,128,55,0,0,30,0,0,0,100,1,0,0,50,0,0,0,0,0,0,0,144,55,0,0,30,0,0,0,101,1,0,0,51,0,0,0,0,0,0,0,160,55,0,0,30,0,0,0,102,1,0,0,52,0,0,0,200,127,13,0,201,214,3,0,194,202,3,0,200,15,0,0,1,0,0,0,204,127,13,0,185,215,3,0,117,215,3,0,114,5,0,0,1,0,0,0,0,0,0,0,176,55,0,0,103,1,0,0,104,1,0,0,53,0,0,0,208,127,13,0,131,216,3,0,117,215,3,0,241,5,0,0,1,0,0,0,212,127,13,0,225,217,3,0,153,217,3,0,153,0,0,0,1,0,0,0,216,127,13,0,39,218,3,0,153,217,3,0,232,0,0,0,1,0,0,0,220,127,13,0,143,218,3,0,153,217,3,0,11,1,0,0,1,0,0,0,224,127,13,0,39,219,3,0,153,217,3,0,44,1,0,0,1,0,0,0,228,127,13,0,164,219,3,0,153,217,3,0,186,3,0,0,1,0,0,0,232,127,13,0,18,221,3,0,60,220,3,0,161,1,0,0,1,0,0,0,236,127,13,0,99,221,3,0,60,220,3,0,213,1,0,0,1,0,0,0,240,127,13,0,176,221,3,0,60,220,3,0,18,3,0,0,1,0,0,0,0,0,0,0,0,0,128,63,0,0,0,0,0,0,128,63,0,0,128,192,0,0,128,63,0,0,0,0,0,0,128,63,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,193,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,64,12,128,13,0,142,223,3,0,23,222,3,0,177,3,0,0,1,0,0,0,0,0,0,0,208,55,0,0,105,1,0,0,106,1,0,0,54,0,0,0,248,127,13,0,5,223,3,0,23,222,3,0,8,4,0,0,0,0,0,0,244,127,13,0,251,222,3,0,23,222,3,0,27,4,0,0,0,0,0,128,0,0,0,0,192,55,0,0,30,0,0,0,107,1,0,0,55,0,0,0,8,128,13,0,53,223,3,0,23,222,3,0,105,1,0,0,1,0,0,0,4,128,13,0,44,223,3,0,23,222,3,0,116,1,0,0,0,0,0,0,0,128,13,0,34,223,3,0,23,222,3,0,132,1,0,0,0,0,0,128,252,127,13,0,23,223,3,0,23,222,3,0,248,2,0,0,0,0,0,128,24,128,13,0,61,224,3,0,23,222,3,0,35,4,0,0,1,0,0,0,20,128,13,0,5,223,3,0,23,222,3,0,80,4,0,0,0,0,0,0,16,128,13,0,251,222,3,0,23,222,3,0,99,4,0,0,0,0,0,128,32,128,13,0,127,228,3,0,16,226,3,0,97,3,0,0,1,0,0,0,36,128,13,0,99,229,3,0,16,226,3,0,165,4,0,0,1,0,0,0,40,128,13,0,48,230,3,0,16,226,3,0,242,5,0,0,1,0,0,0,44,128,13,0,59,231,3,0,16,226,3,0,79,7,0,0,1,0,0,0,48,128,13,0,53,232,3,0,16,226,3,0,134,7,0,0,1,0,0,0,52,128,13,0,198,232,3,0,16,226,3,0,4,13,0,0,1,0,0,0,0,0,0,0,240,55,0,0,30,0,0,0,108,1,0,0,56,0,0,0,0,0,0,0,224,55,0,0,30,0,0,0,109,1,0,0,57,0,0,0,0,0,0,0,0,56,0,0,30,0,0,0,110,1,0,0,58,0,0,0,56,128,13,0,7,236,3,0,76,233,3,0,20,1,0,0,1,0,0,0,60,128,13,0,220,240,3,0,147,240,3,0,126,6,0,0,1,0,0,0,0,0,0,0,0,0,0,63,0,0,128,62,171,170,42,62,0,0,0,62,205,204,204,61,171,170,170,61,40,73,146,61,0,0,128,61,0,0,0,0,16,56,0,0,111,1,0,0,112,1,0,0,59,0,0,0,0,0,0,0,32,56,0,0,113,1,0,0,114,1,0,0,60,0,0,0,0,0,0,0,48,56,0,0,115,1,0,0,116,1,0,0,61,0,0,0,0,0,0,0,64,56,0,0,117,1,0,0,118,1,0,0,62,0,0,0,0,0,0,0,80,56,0,0,119,1,0,0,120,1,0,0,63,0,0,0,0,0,0,0,96,56,0,0,121,1,0,0,122,1,0,0,64,0,0,0,64,128,13,0,11,242,3,0,197,241,3,0,60,5,0,0,1,0,0,0,68,128,13,0,234,242,3,0,197,241,3,0,172,5,0,0,1,0,0,0,72,128,13,0,113,243,3,0,37,243,3,0,179,0,0,0,1,0,0,0,76,128,13,0,83,244,3,0,8,244,3,0,46,0,0,0,1,0,0,0,0,0,0,0,128,56,0,0,123,1,0,0,124,1,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,47,0,0,0,1,0,0,0,1,0,0,0,65,0,0,0,66,0,0,0,125,1,0,0,0,0,0,0,112,56,0,0,47,0,0,0,126,1,0,0,127,1,0,0,80,128,13,0,207,247,3,0,140,247,3,0,93,1,0,0,1,0,0,0,0,0,0,0,0,57,0,0,128,1,0,0,129,1,0,0,67,0,0,0,0,0,0,0,240,56,0,0,47,0,0,0,130,1,0,0,131,1,0,0,0,0,0,0,224,56,0,0,132,1,0,0,133,1,0,0,68,0,0,0,0,0,0,0,208,56,0,0,47,0,0,0,134,1,0,0,135,1,0,0,0,0,0,0,192,56,0,0,136,1,0,0,137,1,0,0,69,0,0,0,0,0,0,0,176,56,0,0,47,0,0,0,138,1,0,0,139,1,0,0,0,0,0,0,160,56,0,0,140,1,0,0,141,1,0,0,70,0,0,0,0,0,0,0,144,56,0,0,47,0,0,0,142,1,0,0,143,1,0,0,0,0,0,0,64,58,0,0,110,0,0,0,144,1,0,0,48,0,0,0,0,0,0,0,48,58,0,0,47,0,0,0,145,1,0,0,146,1,0,0,0,0,0,0,32,58,0,0,110,0,0,0,147,1,0,0,49,0,0,0,0,0,0,0,16,58,0,0,47,0,0,0,148,1,0,0,149,1,0,0,0,0,0,0,0,58,0,0,110,0,0,0,150,1,0,0,50,0,0,0,0,0,0,0,240,57,0,0,47,0,0,0,151,1,0,0,152,1,0,0,0,0,0,0,224,57,0,0,110,0,0,0,153,1,0,0,51,0,0,0,0,0,0,0,208,57,0,0,47,0,0,0,154,1,0,0,155,1,0,0,0,0,0,0,192,57,0,0,110,0,0,0,156,1,0,0,52,0,0,0,0,0,0,0,176,57,0,0,47,0,0,0,157,1,0,0,158,1,0,0,0,0,0,0,160,57,0,0,110,0,0,0,159,1,0,0,53,0,0,0,0,0,0,0,144,57,0,0,47,0,0,0,160,1,0,0,161,1,0,0,0,0,0,0,128,57,0,0,110,0,0,0,162,1,0,0,54,0,0,0,0,0,0,0,112,57,0,0,47,0,0,0,163,1,0,0,164,1,0,0,0,0,0,0,96,57,0,0,110,0,0,0,165,1,0,0,55,0,0,0,0,0,0,0,80,57,0,0,47,0,0,0,166,1,0,0,167,1,0,0,0,0,0,0,64,57,0,0,110,0,0,0,168,1,0,0,56,0,0,0,0,0,0,0,48,57,0,0,47,0,0,0,169,1,0,0,170,1,0,0,0,0,0,0,32,57,0,0,110,0,0,0,171,1,0,0,57,0,0,0,0,0,0,0,16,57,0,0,47,0,0,0,172,1,0,0,173,1,0,0,0,0,0,0,192,59,0,0,174,1,0,0,175,1,0,0,54,0,0,0,176,1,0,0,0,0,0,0,176,59,0,0,47,0,0,0,177,1,0,0,178,1,0,0,0,0,0,0,160,59,0,0,179,1,0,0,180,1,0,0,55,0,0,0,181,1,0,0,0,0,0,0,144,59,0,0,47,0,0,0,182,1,0,0,183,1,0,0,0,0,0,0,128,59,0,0,184,1,0,0,185,1,0,0,56,0,0,0,186,1,0,0,0,0,0,0,112,59,0,0,47,0,0,0,187,1,0,0,188,1,0,0,0,0,0,0,96,59,0,0,189,1,0,0,190,1,0,0,57,0,0,0,191,1,0,0,0,0,0,0,80,59,0,0,47,0,0,0,192,1,0,0,193,1,0,0,0,0,0,0,64,59,0,0,194,1,0,0,195,1,0,0,58,0,0,0,196,1,0,0,0,0,0,0,48,59,0,0,47,0,0,0,197,1,0,0,198,1,0,0,0,0,0,0,32,59,0,0,199,1,0,0,200,1,0,0,59,0,0,0,201,1,0,0,0,0,0,0,16,59,0,0,47,0,0,0,202,1,0,0,203,1,0,0,0,0,0,0,0,59,0,0,204,1,0,0,205,1,0,0,60,0,0,0,206,1,0,0,0,0,0,0,240,58,0,0,47,0,0,0,207,1,0,0,208,1,0,0,0,0,0,0,224,58,0,0,209,1,0,0,210,1,0,0,61,0,0,0,211,1,0,0,0,0,0,0,208,58,0,0,47,0,0,0,212,1,0,0,213,1,0,0,0,0,0,0,192,58,0,0,214,1,0,0,215,1,0,0,62,0,0,0,216,1,0,0,0,0,0,0,176,58,0,0,47,0,0,0,217,1,0,0,218,1,0,0,0,0,0,0,160,58,0,0,219,1,0,0,220,1,0,0,63,0,0,0,221,1,0,0,0,0,0,0,144,58,0,0,47,0,0,0,222,1,0,0,223,1,0,0,0,0,0,0,128,58,0,0,224,1,0,0,225,1,0,0,64,0,0,0,226,1,0,0,0,0,0,0,112,58,0,0,47,0,0,0,227,1,0,0,228,1,0,0,0,0,0,0,96,58,0,0,229,1,0,0,230,1,0,0,65,0,0,0,231,1,0,0,0,0,0,0,80,58,0,0,47,0,0,0,232,1,0,0,233,1,0,0,84,128,13,0,78,1,4,0,32,252,3,0,252,5,0,0,1,0,0,0,88,128,13,0,151,1,4,0,32,252,3,0,45,6,0,0,1,0,0,0,92,128,13,0,175,3,4,0,32,252,3,0,127,6,0,0,1,0,0,0,0,0,0,0,96,60,0,0,110,0,0,0,234,1,0,0,58,0,0,0,0,0,0,0,80,60,0,0,47,0,0,0,235,1,0,0,236,1,0,0,0,0,0,0,64,60,0,0,110,0,0,0,237,1,0,0,59,0,0,0,0,0,0,0,48,60,0,0,47,0,0,0,238,1,0,0,239,1,0,0,0,0,0,0,32,60,0,0,110,0,0,0,240,1,0,0,60,0,0,0,0,0,0,0,16,60,0,0,47,0,0,0,241,1,0,0,242,1,0,0,0,0,0,0,0,60,0,0,110,0,0,0,243,1,0,0,61,0,0,0,0,0,0,0,240,59,0,0,47,0,0,0,244,1,0,0,245,1,0,0,0,0,0,0,224,59,0,0,110,0,0,0,246,1,0,0,62,0,0,0,0,0,0,0,208,59,0,0,47,0,0,0,247,1,0,0,248,1,0,0,0,0,128,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,62,0,0,0,63,0,0,128,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,61,0,0,128,62,0,0,192,62,0,0,128,62,0,0,128,61,0,0,0,0,0,0,0,0,0,0,0,61,0,0,224,61,0,0,96,62,0,0,144,62,0,0,96,62,0,0,224,61,0,0,0,61,96,128,13,0,215,4,4,0,32,252,3,0,24,16,0,0,1,0,0,0,0,0,0,0,112,60,0,0,30,0,0,0,249,1,0,0,71,0,0,0,100,128,13,0,207,5,4,0,32,252,3,0,59,20,0,0,1,0,0,0,104,128,13,0,87,7,4,0,32,252,3,0,100,23,0,0,1,0,0,0,0,0,0,0,144,60,0,0,30,0,0,0,250,1,0,0,72,0,0,0,0,0,0,0,128,60,0,0,30,0,0,0,251,1,0,0,73,0,0,0,108,128,13,0,163,7,4,0,211,7,4,0,94,0,0,0,1,0,0,0,112,128,13,0,37,8,4,0,211,7,4,0,194,3,0,0,1,0,0,0,0,0,0,0,86,248,142,60,199,242,14,61,70,94,86,61,127,220,142,61,176,126,178,61,10,19,214,61,157,150,249,61,101,131,14,62,94,48,32,62,213,208,49,62,111,99,67,62,206,230,84,62,149,89,102,62,96,186,119,62,237,131,132,62,88,32,141,62,190,177,149,62,122,55,158,62,224,176,166,62,66,29,175,62,255,123,183,62,112,204,191,62,232,13,200,62,200,63,208,62,109,97,216,62,45,114,224,62,113,113,232,62,149,94,240,62,247,56,248,62,0,0,0,63,137,217,3,63,203,168,7,63,118,109,11,63,68,39,15,63,231,213,18,63,25,121,22,63,140,16,26,63,254,155,29,63,36,27,33,63,186,141,36,63,124,243,39,63,37,76,43,63,114,151,46,63,34,213,49,63,244,4,53,63,167,38,56,63,255,57,59,63,189,62,62,63,166,52,65,63,124,27,68,63,10,243,70,63,19,187,73,63,96,115,76,63,189,27,79,63,242,179,81,63,207,59,84,63,30,179,86,63,174,25,89,63,81,111,91,63,215,179,93,63,20,231,95,63,219,8,98,63,1,25,100,63,93,23,102,63,202,3,104,63,30,222,105,63,54,166,107,63,237,91,109,63,32,255,110,63,178,143,112,63,130,13,114,63,112,120,115,63,100,208,116,63,63,21,118,63,234,70,119,63,77,101,120,63,82,112,121,63,226,103,122,63,236,75,123,63,93,28,124,63,36,217,124,63,54,130,125,63,130,23,126,63,253,152,126,63,158,6,127,63,92,96,127,63,47,166,127,63,19,216,127,63,5,246,127,63,0,0,128,63,5,246,127,63,19,216,127,63,47,166,127,63,92,96,127,63,158,6,127,63,253,152,126,63,130,23,126,63,54,130,125,63,36,217,124,63,93,28,124,63,236,75,123,63,226,103,122,63,82,112,121,63,77,101,120,63,234,70,119,63,63,21,118,63,100,208,116,63,112,120,115,63,130,13,114,63,178,143,112,63,32,255,110,63,237,91,109,63,54,166,107,63,30,222,105,63,202,3,104,63,93,23,102,63,1,25,100,63,219,8,98,63,20,231,95,63,215,179,93,63,81,111,91,63,174,25,89,63,30,179,86,63,207,59,84,63,242,179,81,63,189,27,79,63,96,115,76,63,19,187,73,63,10,243,70,63,124,27,68,63,166,52,65,63,189,62,62,63,255,57,59,63,167,38,56,63,244,4,53,63,34,213,49,63,114,151,46,63,37,76,43,63,124,243,39,63,186,141,36,63,36,27,33,63,254,155,29,63,140,16,26,63,25,121,22,63,231,213,18,63,68,39,15,63,118,109,11,63,203,168,7,63,137,217,3,63,0,0,0,63,247,56,248,62,149,94,240,62,113,113,232,62,45,114,224,62,109,97,216,62,200,63,208,62,232,13,200,62,112,204,191,62,255,123,183,62,66,29,175,62,224,176,166,62,122,55,158,62,190,177,149,62,88,32,141,62,237,131,132,62,96,186,119,62,149,89,102,62,206,230,84,62,111,99,67,62,213,208,49,62,94,48,32,62,101,131,14,62,157,150,249,61,10,19,214,61,176,126,178,61,127,220,142,61,70,94,86,61,199,242,14,61,86,248,142,60,0,0,0,0,86,248,142,188,199,242,14,189,70,94,86,189,127,220,142,189,176,126,178,189,10,19,214,189,157,150,249,189,101,131,14,190,94,48,32,190,213,208,49,190,111,99,67,190,206,230,84,190,149,89,102,190,96,186,119,190,237,131,132,190,88,32,141,190,190,177,149,190,122,55,158,190,224,176,166,190,66,29,175,190,255,123,183,190,112,204,191,190,232,13,200,190,200,63,208,190,109,97,216,190,45,114,224,190,113,113,232,190,149,94,240,190,247,56,248,190,0,0,0,191,137,217,3,191,203,168,7,191,118,109,11,191,68,39,15,191,231,213,18,191,25,121,22,191,140,16,26,191,254,155,29,191,36,27,33,191,186,141,36,191,124,243,39,191,37,76,43,191,114,151,46,191,34,213,49,191,244,4,53,191,167,38,56,191,255,57,59,191,189,62,62,191,166,52,65,191,124,27,68,191,10,243,70,191,19,187,73,191,96,115,76,191,189,27,79,191,242,179,81,191,207,59,84,191,30,179,86,191,174,25,89,191,81,111,91,191,215,179,93,191,20,231,95,191,219,8,98,191,1,25,100,191,93,23,102,191,202,3,104,191,30,222,105,191,54,166,107,191,237,91,109,191,32,255,110,191,178,143,112,191,130,13,114,191,112,120,115,191,100,208,116,191,63,21,118,191,234,70,119,191,77,101,120,191,82,112,121,191,226,103,122,191,236,75,123,191,93,28,124,191,36,217,124,191,54,130,125,191,130,23,126,191,253,152,126,191,158,6,127,191,92,96,127,191,47,166,127,191,19,216,127,191,5,246,127,191,0,0,128,191,5,246,127,191,19,216,127,191,47,166,127,191,92,96,127,191,158,6,127,191,253,152,126,191,130,23,126,191,54,130,125,191,36,217,124,191,93,28,124,191,236,75,123,191,226,103,122,191,82,112,121,191,77,101,120,191,234,70,119,191,63,21,118,191,100,208,116,191,112,120,115,191,130,13,114,191,178,143,112,191,32,255,110,191,237,91,109,191,54,166,107,191,30,222,105,191,202,3,104,191,93,23,102,191,1,25,100,191,219,8,98,191,20,231,95,191,215,179,93,191,81,111,91,191,174,25,89,191,30,179,86,191,207,59,84,191,242,179,81,191,189,27,79,191,96,115,76,191,19,187,73,191,10,243,70,191,124,27,68,191,166,52,65,191,189,62,62,191,255,57,59,191,167,38,56,191,244,4,53,191,34,213,49,191,114,151,46,191,37,76,43,191,124,243,39,191,186,141,36,191,36,27,33,191,254,155,29,191,140,16,26,191,25,121,22,191,231,213,18,191,68,39,15,191,118,109,11,191,203,168,7,191,137,217,3,191,0,0,0,191,247,56,248,190,149,94,240,190,113,113,232,190,45,114,224,190,109,97,216,190,200,63,208,190,232,13,200,190,112,204,191,190,255,123,183,190,66,29,175,190,224,176,166,190,122,55,158,190,190,177,149,190,88,32,141,190,237,131,132,190,96,186,119,190,149,89,102,190,206,230,84,190,111,99,67,190,213,208,49,190,94,48,32,190,101,131,14,190,157,150,249,189,10,19,214,189,176,126,178,189,127,220,142,189,70,94,86,189,199,242,14,189,86,248,142,188,0,0,0,128,86,248,142,60,199,242,14,61,70,94,86,61,127,220,142,61,176,126,178,61,10,19,214,61,157,150,249,61,101,131,14,62,94,48,32,62,213,208,49,62,111,99,67,62,206,230,84,62,149,89,102,62,96,186,119,62,237,131,132,62,88,32,141,62,190,177,149,62,122,55,158,62,224,176,166,62,66,29,175,62,255,123,183,62,112,204,191,62,232,13,200,62,200,63,208,62,109,97,216,62,45,114,224,62,113,113,232,62,149,94,240,62,247,56,248,62,0,0,0,63,137,217,3,63,203,168,7,63,118,109,11,63,68,39,15,63,231,213,18,63,25,121,22,63,140,16,26,63,254,155,29,63,36,27,33,63,186,141,36,63,124,243,39,63,37,76,43,63,114,151,46,63,34,213,49,63,244,4,53,63,167,38,56,63,255,57,59,63,189,62,62,63,166,52,65,63,124,27,68,63,10,243,70,63,19,187,73,63,96,115,76,63,189,27,79,63,242,179,81,63,207,59,84,63,30,179,86,63,174,25,89,63,81,111,91,63,215,179,93,63,20,231,95,63,219,8,98,63,1,25,100,63,93,23,102,63,202,3,104,63,30,222,105,63,54,166,107,63,237,91,109,63,32,255,110,63,178,143,112,63,130,13,114,63,112,120,115,63,100,208,116,63,63,21,118,63,234,70,119,63,77,101,120,63,82,112,121,63,226,103,122,63,236,75,123,63,93,28,124,63,36,217,124,63,54,130,125,63,130,23,126,63,253,152,126,63,158,6,127,63,92,96,127,63,47,166,127,63,19,216,127,63,5,246,127,63,0,0,128,63,116,128,13,0,36,9,4,0,211,7,4,0,12,7,0,0,1,0,0,0,168,0,0,0,177,0,0,0,185,0,0,0,194,0,0,0,202,0,0,0,210,0,0,0,218,0,0,0,224,0,0,0,231,0,0,0,236,0,0,0,241,0,0,0,246,0,0,0,249,0,0,0,252,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,252,0,0,0,249,0,0,0,246,0,0,0,241,0,0,0,236,0,0,0,231,0,0,0,224,0,0,0,218,0,0,0,210,0,0,0,202,0,0,0,194,0,0,0,185,0,0,0,177,0,0,0,168,0,0,0,158,0,0,0,149,0,0,0,140,0,0,0,131,0,0,0,122,0,0,0,114,0,0,0,105,0,0,0,97,0,0,0,89,0,0,0,82,0,0,0,75,0,0,0,68,0,0,0,62,0,0,0,56,0,0,0,50,0,0,0,45,0,0,0,40,0,0,0,36,0,0,0,32,0,0,0,28,0,0,0,25,0,0,0,22,0,0,0,19,0,0,0,16,0,0,0,14,0,0,0,12,0,0,0,11,0,0,0,9,0,0,0,8,0,0,0,7,0,0,0,5,0,0,0,5,0,0,0,120,128,13,0,150,9,4,0,211,7,4,0,51,7,0,0,1,0,0,0,124,128,13,0,60,10,4,0,211,7,4,0,96,7,0,0,1,0,0,0,128,128,13,0,246,10,4,0,211,7,4,0,128,7,0,0,1,0,0,0,132,128,13,0,167,11,4,0,211,7,4,0,158,7,0,0,1,0,0,0,136,128,13,0,27,12,4,0,211,7,4,0,220,8,0,0,1,0,0,0,69,17,0,0,199,0,0,0,214,0,0,0,217,0,0,0,233,0,0,0,219,0,0,0,197,0,0,0,234,0,0,0,216,0,0,0,221,0,0,0,222,0,0,0,228,0,0,0,225,0,0,0,211,0,0,0,224,0,0,0,210,0,0,0,220,0,0,0,200,0,0,0,201,0,0,0,202,0,0,0,203,0,0,0,204,0,0,0,205,0,0,0,206,0,0,0,207,0,0,0,208,0,0,0,209,0,0,0,212,0,0,0,213,0,0,0,191,0,0,0,226,0,0,0,192,0,0,0,215,0,0,0,190,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,193,0,0,0,84,0,0,0,194,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,151,0,0,0,152,0,0,0,153,0,0,0,154,0,0,0,155,0,0,0,156,0,0,0,157,0,0,0,158,0,0,0,159,0,0,0,160,0,0,0,161,0,0,0,162,0,0,0,163,0,0,0,164,0,0,0,165,0,0,0,166,0,0,0,167,0,0,0,168,0,0,0,169,0,0,0,170,0,0,0,171,0,0,0,172,0,0,0,173,0,0,0,174,0,0,0,175,0,0,0,176,0,0,0,195,0,0,0,223,0,0,0,196,0,0,0,88,0,0,0,69,16,0,0,199,0,0,0,214,0,0,0,217,0,0,0,233,0,0,0,219,0,0,0,197,0,0,0,234,0,0,0,216,0,0,0,221,0,0,0,222,0,0,0,228,0,0,0,225,0,0,0,211,0,0,0,224,0,0,0,210,0,0,0,220,0,0,0,200,0,0,0,201,0,0,0,202,0,0,0,203,0,0,0,204,0,0,0,205,0,0,0,206,0,0,0,207,0,0,0,208,0,0,0,209,0,0,0,212,0,0,0,213,0,0,0,191,0,0,0,226,0,0,0,192,0,0,0,215,0,0,0,190,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,193,0,0,0,84,0,0,0,194,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,101,0,0,0,102,0,0,0,103,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,107,0,0,0,108,0,0,0,109,0,0,0,110,0,0,0,111,0,0,0,112,0,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,120,0,0,0,121,0,0,0,122,0,0,0,123,0,0,0,124,0,0,0,125,0,0,0,126,0,0,0,195,0,0,0,223,0,0,0,196,0,0,0,88,0,0,0,201,55,0,0,151,8,0,0,204,10,0,0,218,10,0,0,222,10,0,0,209,10,0,0,223,10,0,0,208,10,0,0,217,10,0,0,211,10,0,0,212,10,0,0,171,8,0,0,184,8,0,0,163,8,0,0,183,8,0,0,162,8,0,0,172,8,0,0,190,10,0,0,191,10,0,0,192,10,0,0,193,10,0,0,194,10,0,0,195,10,0,0,196,10,0,0,197,10,0,0,198,10,0,0,199,10,0,0,164,8,0,0,165,8,0,0,193,8,0,0,190,8,0,0,194,8,0,0,205,10,0,0,225,8,0,0,3,8,0,0,4,8,0,0,5,8,0,0,6,8,0,0,7,8,0,0,8,8,0,0,9,8,0,0,10,8,0,0,11,8,0,0,12,8,0,0,13,8,0,0,14,8,0,0,15,8,0,0,16,8,0,0,17,8,0,0,18,8,0,0,19,8,0,0,20,8,0,0,21,8,0,0,22,8,0,0,23,8,0,0,24,8,0,0,25,8,0,0,26,8,0,0,27,8,0,0,28,8,0,0,175,8,0,0,36,8,0,0,176,8,0,0,199,8,0,0,75,2,0,0,201,8,0,0,103,8,0,0,104,8,0,0,105,8,0,0,106,8,0,0,107,8,0,0,108,8,0,0,109,8,0,0,110,8,0,0,111,8,0,0,112,8,0,0,113,8,0,0,114,8,0,0,115,8,0,0,116,8,0,0,117,8,0,0,118,8,0,0,119,8,0,0,120,8,0,0,121,8,0,0,122,8,0,0,123,8,0,0,124,8,0,0,125,8,0,0,126,8,0,0,127,8,0,0,128,8,0,0,177,8,0,0,181,8,0,0,178,8,0,0,198,8,0,0,201,48,0,0,151,8,0,0,166,8,0,0,169,8,0,0,227,8,0,0,226,8,0,0,223,8,0,0,224,8,0,0,168,8,0,0,173,8,0,0,174,8,0,0,171,8,0,0,184,8,0,0,163,8,0,0,183,8,0,0,162,8,0,0,172,8,0,0,152,8,0,0,153,8,0,0,154,8,0,0,155,8,0,0,156,8,0,0,157,8,0,0,158,8,0,0,159,8,0,0,160,8,0,0,161,8,0,0,164,8,0,0,165,8,0,0,193,8,0,0,190,8,0,0,194,8,0,0,167,8,0,0,225,8,0,0,209,7,0,0,210,7,0,0,211,7,0,0,212,7,0,0,213,7,0,0,214,7,0,0,215,7,0,0,216,7,0,0,217,7,0,0,218,7,0,0,219,7,0,0,220,7,0,0,221,7,0,0,222,7,0,0,223,7,0,0,224,7,0,0,225,7,0,0,226,7,0,0,227,7,0,0,228,7,0,0,229,7,0,0,230,7,0,0,231,7,0,0,232,7,0,0,233,7,0,0,234,7,0,0,175,8,0,0,36,8,0,0,176,8,0,0,199,8,0,0,75,2,0,0,201,8,0,0,53,8,0,0,54,8,0,0,55,8,0,0,56,8,0,0,57,8,0,0,58,8,0,0,59,8,0,0,60,8,0,0,61,8,0,0,62,8,0,0,63,8,0,0,64,8,0,0,65,8,0,0,66,8,0,0,67,8,0,0,68,8,0,0,69,8,0,0,70,8,0,0,71,8,0,0,72,8,0,0,73,8,0,0,74,8,0,0,75,8,0,0,76,8,0,0,77,8,0,0,78,8,0,0,177,8,0,0,181,8,0,0,178,8,0,0,198,8,0,0,241,10,0,0,242,10,0,0,243,10,0,0,244,10,0,0,245,10,0,0,246,10,0,0,247,10,0,0,248,10,0,0,249,10,0,0,250,10,0,0,251,10,0,0,252,10,0,0,253,10,0,0,254,10,0,0,255,10,0,0,0,11,0,0,1,11,0,0,2,11,0,0,3,11,0,0,4,11,0,0,5,11,0,0,6,11,0,0,7,11,0,0,8,11,0,0,9,11,0,0,10,11,0,0,11,11,0,0,12,11,0,0,13,11,0,0,14,11,0,0,15,11,0,0,16,11,0,0,85,11,0,0,86,11,0,0,87,11,0,0,88,11,0,0,89,11,0,0,90,11,0,0,91,11,0,0,92,11,0,0,93,11,0,0,94,11,0,0,95,11,0,0,96,11,0,0,97,11,0,0,98,11,0,0,99,11,0,0,100,11,0,0,101,11,0,0,102,11,0,0,103,11,0,0,104,11,0,0,105,11,0,0,106,11,0,0,107,11,0,0,108,11,0,0,109,11,0,0,110,11,0,0,111,11,0,0,112,11,0,0,113,11,0,0,114,11,0,0,115,11,0,0,116,11,0,0,201,23,0,0,151,8,0,0,192,12,0,0,206,12,0,0,210,12,0,0,197,12,0,0,161,12,0,0,196,12,0,0,205,12,0,0,199,12,0,0,200,12,0,0,151,12,0,0,153,12,0,0,189,12,0,0,152,12,0,0,188,12,0,0,198,12,0,0,178,12,0,0,179,12,0,0,180,12,0,0,181,12,0,0,182,12,0,0,183,12,0,0,184,12,0,0,185,12,0,0,186,12,0,0,187,12,0,0,190,12,0,0,191,12,0,0,158,12,0,0,154,12,0,0,159,12,0,0,193,12,0,0,162,12,0,0,235,11,0,0,236,11,0,0,237,11,0,0,238,11,0,0,239,11,0,0,240,11,0,0,241,11,0,0,242,11,0,0,243,11,0,0,244,11,0,0,245,11,0,0,246,11,0,0,247,11,0,0,16,8,0,0,249,11,0,0,250,11,0,0,251,11,0,0,252,11,0,0,253,11,0,0,254,11,0,0,255,11,0,0,0,12,0,0,1,12,0,0,2,12,0,0,3,12,0,0,4,12,0,0,175,8,0,0,36,8,0,0,176,8,0,0,199,8,0,0,75,2,0,0,201,8,0,0,79,12,0,0,80,12,0,0,81,12,0,0,82,12,0,0,83,12,0,0,84,12,0,0,85,12,0,0,86,12,0,0,87,12,0,0,88,12,0,0,89,12,0,0,90,12,0,0,91,12,0,0,92,12,0,0,93,12,0,0,94,12,0,0,95,12,0,0,96,12,0,0,97,12,0,0,98,12,0,0,99,12,0,0,100,12,0,0,101,12,0,0,102,12,0,0,103,12,0,0,104,12,0,0,177,8,0,0,181,8,0,0,178,8,0,0,198,8,0,0,201,16,0,0,151,8,0,0,142,12,0,0,156,12,0,0,160,12,0,0,147,12,0,0,161,12,0,0,146,12,0,0,155,12,0,0,149,12,0,0,150,12,0,0,151,12,0,0,153,12,0,0,139,12,0,0,152,12,0,0,138,12,0,0,148,12,0,0,128,12,0,0,129,12,0,0,130,12,0,0,131,12,0,0,132,12,0,0,133,12,0,0,134,12,0,0,135,12,0,0,136,12,0,0,137,12,0,0,140,12,0,0,141,12,0,0,158,12,0,0,154,12,0,0,159,12,0,0,143,12,0,0,162,12,0,0,185,11,0,0,186,11,0,0,187,11,0,0,188,11,0,0,189,11,0,0,190,11,0,0,191,11,0,0,192,11,0,0,193,11,0,0,194,11,0,0,195,11,0,0,196,11,0,0,197,11,0,0,222,7,0,0,199,11,0,0,200,11,0,0,201,11,0,0,202,11,0,0,203,11,0,0,204,11,0,0,205,11,0,0,206,11,0,0,207,11,0,0,208,11,0,0,209,11,0,0,210,11,0,0,175,8,0,0,36,8,0,0,176,8,0,0,199,8,0,0,75,2,0,0,201,8,0,0,29,12,0,0,30,12,0,0,31,12,0,0,32,12,0,0,33,12,0,0,34,12,0,0,35,12,0,0,36,12,0,0,37,12,0,0,38,12,0,0,39,12,0,0,40,12,0,0,41,12,0,0,42,12,0,0,43,12,0,0,44,12,0,0,45,12,0,0,46,12,0,0,47,12,0,0,48,12,0,0,49,12,0,0,50,12,0,0,51,12,0,0,52,12,0,0,53,12,0,0,54,12,0,0,177,8,0,0,181,8,0,0,178,8,0,0,198,8,0,0,118,17,0,0,175,4,0,0,190,4,0,0,193,4,0,0,251,4,0,0,250,4,0,0,247,4,0,0,248,4],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+51200);allocate([192,4,0,0,197,4,0,0,198,4,0,0,195,4,0,0,208,4,0,0,187,4,0,0,207,4,0,0,186,4,0,0,196,4,0,0,176,4,0,0,177,4,0,0,178,4,0,0,179,4,0,0,180,4,0,0,181,4,0,0,182,4,0,0,183,4,0,0,184,4,0,0,185,4,0,0,188,4,0,0,189,4,0,0,217,4,0,0,214,4,0,0,218,4,0,0,191,4,0,0,249,4,0,0,27,4,0,0,28,4,0,0,29,4,0,0,30,4,0,0,31,4,0,0,32,4,0,0,33,4,0,0,34,4,0,0,35,4,0,0,36,4,0,0,37,4,0,0,38,4,0,0,39,4,0,0,40,4,0,0,41,4,0,0,42,4,0,0,43,4,0,0,44,4,0,0,45,4,0,0,46,4,0,0,47,4,0,0,48,4,0,0,49,4,0,0,50,4,0,0,51,4,0,0,52,4,0,0,199,4,0,0,60,4,0,0,200,4,0,0,223,4,0,0,74,2,0,0,225,4,0,0,127,4,0,0,128,4,0,0,129,4,0,0,130,4,0,0,131,4,0,0,132,4,0,0,133,4,0,0,134,4,0,0,135,4,0,0,136,4,0,0,137,4,0,0,138,4,0,0,139,4,0,0,140,4,0,0,141,4,0,0,142,4,0,0,143,4,0,0,144,4,0,0,145,4,0,0,146,4,0,0,147,4,0,0,148,4,0,0,149,4,0,0,150,4,0,0,151,4,0,0,152,4,0,0,201,4,0,0,205,4,0,0,202,4,0,0,222,4,0,0,118,16,0,0,175,4,0,0,190,4,0,0,193,4,0,0,251,4,0,0,250,4,0,0,247,4,0,0,248,4,0,0,192,4,0,0,197,4,0,0,198,4,0,0,195,4,0,0,208,4,0,0,187,4,0,0,207,4,0,0,186,4,0,0,196,4,0,0,176,4,0,0,177,4,0,0,178,4,0,0,179,4,0,0,180,4,0,0,181,4,0,0,182,4,0,0,183,4,0,0,184,4,0,0,185,4,0,0,188,4,0,0,165,8,0,0,217,4,0,0,214,4,0,0,218,4,0,0,191,4,0,0,249,4,0,0,233,3,0,0,234,3,0,0,235,3,0,0,236,3,0,0,237,3,0,0,238,3,0,0,239,3,0,0,240,3,0,0,241,3,0,0,242,3,0,0,243,3,0,0,244,3,0,0,245,3,0,0,246,3,0,0,247,3,0,0,248,3,0,0,249,3,0,0,250,3,0,0,251,3,0,0,252,3,0,0,253,3,0,0,254,3,0,0,255,3,0,0,0,4,0,0,1,4,0,0,2,4,0,0,199,4,0,0,60,4,0,0,200,4,0,0,223,4,0,0,74,2,0,0,225,4,0,0,77,4,0,0,78,4,0,0,79,4,0,0,80,4,0,0,81,4,0,0,82,4,0,0,83,4,0,0,84,4,0,0,85,4,0,0,86,4,0,0,87,4,0,0,88,4,0,0,89,4,0,0,90,4,0,0,91,4,0,0,92,4,0,0,93,4,0,0,94,4,0,0,95,4,0,0,96,4,0,0,97,4,0,0,98,4,0,0,99,4,0,0,100,4,0,0,101,4,0,0,102,4,0,0,201,4,0,0,205,4,0,0,202,4,0,0,222,4,0,0,201,23,0,0,151,8,0,0,204,10,0,0,218,10,0,0,222,10,0,0,209,10,0,0,223,10,0,0,208,10,0,0,217,10,0,0,211,10,0,0,212,10,0,0,171,8,0,0,184,8,0,0,163,8,0,0,183,8,0,0,162,8,0,0,172,8,0,0,190,10,0,0,191,10,0,0,192,10,0,0,193,10,0,0,194,10,0,0,195,10,0,0,196,10,0,0,197,10,0,0,198,10,0,0,199,10,0,0,164,8,0,0,165,8,0,0,193,8,0,0,190,8,0,0,194,8,0,0,167,8,0,0,225,8,0,0,247,9,0,0,248,9,0,0,249,9,0,0,250,9,0,0,251,9,0,0,252,9,0,0,253,9,0,0,254,9,0,0,255,9,0,0,0,10,0,0,1,10,0,0,2,10,0,0,3,10,0,0,4,10,0,0,5,10,0,0,6,10,0,0,7,10,0,0,8,10,0,0,9,10,0,0,10,10,0,0,11,10,0,0,12,10,0,0,13,10,0,0,14,10,0,0,15,10,0,0,16,10,0,0,175,8,0,0,36,8,0,0,176,8,0,0,199,8,0,0,74,2,0,0,201,8,0,0,91,10,0,0,92,10,0,0,93,10,0,0,94,10,0,0,95,10,0,0,96,10,0,0,97,10,0,0,98,10,0,0,99,10,0,0,100,10,0,0,101,10,0,0,102,10,0,0,103,10,0,0,104,10,0,0,105,10,0,0,106,10,0,0,107,10,0,0,108,10,0,0,109,10,0,0,110,10,0,0,111,10,0,0,112,10,0,0,113,10,0,0,114,10,0,0,115,10,0,0,116,10,0,0,177,8,0,0,181,8,0,0,178,8,0,0,198,8,0,0,201,17,0,0,151,8,0,0,202,2,0,0,205,2,0,0,221,2,0,0,207,2,0,0,185,2,0,0,222,2,0,0,204,2,0,0,209,2,0,0,210,2,0,0,216,2,0,0,213,2,0,0,199,2,0,0,212,2,0,0,198,2,0,0,208,2,0,0,188,2,0,0,189,2,0,0,190,2,0,0,191,2,0,0,192,2,0,0,193,2,0,0,194,2,0,0,195,2,0,0,196,2,0,0,197,2,0,0,200,2,0,0,201,2,0,0,179,2,0,0,214,2,0,0,180,2,0,0,203,2,0,0,178,2,0,0,39,2,0,0,40,2,0,0,41,2,0,0,42,2,0,0,43,2,0,0,44,2,0,0,45,2,0,0,46,2,0,0,47,2,0,0,48,2,0,0,49,2,0,0,50,2,0,0,51,2,0,0,52,2,0,0,53,2,0,0,54,2,0,0,55,2,0,0,56,2,0,0,57,2,0,0,58,2,0,0,59,2,0,0,60,2,0,0,61,2,0,0,62,2,0,0,63,2,0,0,64,2,0,0,181,2,0,0,72,2,0,0,182,2,0,0,199,8,0,0,74,2,0,0,201,8,0,0,139,2,0,0,140,2,0,0,141,2,0,0,142,2,0,0,143,2,0,0,144,2,0,0,145,2,0,0,146,2,0,0,147,2,0,0,148,2,0,0,149,2,0,0,150,2,0,0,151,2,0,0,152,2,0,0,153,2,0,0,154,2,0,0,155,2,0,0,156,2,0,0,157,2,0,0,158,2,0,0,159,2,0,0,160,2,0,0,161,2,0,0,162,2,0,0,163,2,0,0,164,2,0,0,183,2,0,0,211,2,0,0,184,2,0,0,198,8,0,0,201,16,0,0,151,8,0,0,154,10,0,0,168,10,0,0,172,10,0,0,159,10,0,0,173,10,0,0,158,10,0,0,167,10,0,0,161,10,0,0,162,10,0,0,163,10,0,0,165,10,0,0,151,10,0,0,164,10,0,0,150,10,0,0,160,10,0,0,140,10,0,0,141,10,0,0,142,10,0,0,143,10,0,0,144,10,0,0,145,10,0,0,146,10,0,0,147,10,0,0,148,10,0,0,149,10,0,0,152,10,0,0,153,10,0,0,170,10,0,0,166,10,0,0,171,10,0,0,155,10,0,0,174,10,0,0,197,9,0,0,198,9,0,0,199,9,0,0,200,9,0,0,201,9,0,0,202,9,0,0,203,9,0,0,204,9,0,0,205,9,0,0,206,9,0,0,207,9,0,0,208,9,0,0,209,9,0,0,210,9,0,0,211,9,0,0,212,9,0,0,213,9,0,0,214,9,0,0,215,9,0,0,216,9,0,0,217,9,0,0,218,9,0,0,219,9,0,0,220,9,0,0,221,9,0,0,222,9,0,0,175,8,0,0,36,8,0,0,176,8,0,0,199,8,0,0,75,2,0,0,201,8,0,0,41,10,0,0,42,10,0,0,43,10,0,0,44,10,0,0,45,10,0,0,46,10,0,0,47,10,0,0,48,10,0,0,49,10,0,0,50,10,0,0,51,10,0,0,52,10,0,0,53,10,0,0,54,10,0,0,55,10,0,0,56,10,0,0,57,10,0,0,58,10,0,0,59,10,0,0,60,10,0,0,61,10,0,0,62,10,0,0,63,10,0,0,64,10,0,0,65,10,0,0,66,10,0,0,177,8,0,0,181,8,0,0,178,8,0,0,198,8,0,0,201,16,0,0,151,8,0,0,202,2,0,0,205,2,0,0,221,2,0,0,207,2,0,0,185,2,0,0,222,2,0,0,204,2,0,0,209,2,0,0,210,2,0,0,216,2,0,0,213,2,0,0,199,2,0,0,212,2,0,0,198,2,0,0,208,2,0,0,188,2,0,0,189,2,0,0,190,2,0,0,191,2,0,0,192,2,0,0,193,2,0,0,194,2,0,0,195,2,0,0,196,2,0,0,197,2,0,0,200,2,0,0,201,2,0,0,179,2,0,0,214,2,0,0,180,2,0,0,203,2,0,0,178,2,0,0,245,1,0,0,246,1,0,0,247,1,0,0,248,1,0,0,249,1,0,0,250,1,0,0,251,1,0,0,252,1,0,0,253,1,0,0,254,1,0,0,255,1,0,0,0,2,0,0,1,2,0,0,2,2,0,0,3,2,0,0,4,2,0,0,5,2,0,0,6,2,0,0,7,2,0,0,8,2,0,0,9,2,0,0,10,2,0,0,11,2,0,0,12,2,0,0,13,2,0,0,14,2,0,0,181,2,0,0,72,2,0,0,182,2,0,0,199,8,0,0,74,2,0,0,201,8,0,0,89,2,0,0,90,2,0,0,91,2,0,0,92,2,0,0,93,2,0,0,94,2,0,0,95,2,0,0,96,2,0,0,97,2,0,0,98,2,0,0,99,2,0,0,100,2,0,0,101,2,0,0,102,2,0,0,103,2,0,0,104,2,0,0,105,2,0,0,106,2,0,0,107,2,0,0,108,2,0,0,109,2,0,0,110,2,0,0,111,2,0,0,112,2,0,0,113,2,0,0,114,2,0,0,183,2,0,0,211,2,0,0,184,2,0,0,198,8,0,0,140,128,13,0,56,13,4,0,211,7,4,0,175,9,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,255,255,255,255,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,144,128,13,0,144,14,4,0,228,13,4,0,166,2,0,0,1,0,0,0,190,185,17,0,206,17,4,0,223,17,4,0,254,17,4,0,21,18,4,0,45,18,4,0,67,18,4,0,84,18,4,0,114,18,4,0,131,18,4,0,138,18,4,0,153,18,4,0,170,18,4,0,182,18,4,0,204,18,4,0,221,18,4,0,250,18,4,0,14,19,4,0,48,19,4,0,73,19,4,0,100,19,4,0,112,19,4,0,131,19,4,0,143,19,4,0,165,19,4,0,177,19,4,0,191,19,4,0,206,17,4,0,223,17,4,0,208,19,4,0,220,19,4,0,45,18,4,0,191,19,4,0,114,18,4,0,237,19,4,0,131,18,4,0,153,18,4,0,20,20,4,0,182,18,4,0,204,18,4,0,32,20,4,0,221,18,4,0,54,20,4,0,250,18,4,0,71,20,4,0,100,19,4,0,90,20,4,0,120,20,4,0,165,19,4,0,146,20,4,0,170,20,4,0,197,20,4,0,214,20,4,0,247,20,4,0,20,21,4,0,44,21,4,0,66,21,4,0,83,21,4,0,114,21,4,0,131,21,4,0,138,21,4,0,155,21,4,0,172,21,4,0,184,21,4,0,206,21,4,0,223,21,4,0,0,22,4,0,22,22,4,0,74,22,4,0,107,22,4,0,134,22,4,0,146,22,4,0,165,22,4,0,177,22,4,0,199,22,4,0,211,22,4,0,225,22,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,236,22,4,0,253,22,4,0,4,23,4,0,16,23,4,0,23,23,4,0,30,23,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,45,23,4,0,71,23,4,0,97,23,4,0,118,23,4,0,144,23,4,0,165,23,4,0,183,23,4,0,215,23,4,0,235,23,4,0,253,23,4,0,21,24,4,0,131,18,4,0,38,24,4,0,75,24,4,0,95,24,4,0,116,24,4,0,142,24,4,0,168,24,4,0,184,24,4,0,211,24,4,0,229,24,4,0,249,24,4,0,5,25,4,0,27,25,4,0,39,25,4,0,57,25,4,0,68,25,4,0,93,25,4,0,130,25,4,0,156,25,4,0,187,25,4,0,217,25,4,0,249,25,4,0,25,26,4,0,64,26,4,0,79,26,4,0,104,26,4,0,122,26,4,0,155,26,4,0,173,26,4,0,95,24,4,0,216,26,4,0,239,26,4,0,6,27,4,0,29,27,4,0,43,27,4,0,66,27,4,0,97,27,4,0,121,27,4,0,149,27,4,0,179,27,4,0,211,27,4,0,234,27,4,0,253,27,4,0,29,28,4,0,54,28,4,0,78,28,4,0,112,28,4,0,140,28,4,0,170,28,4,0,202,28,4,0,227,28,4,0,240,28,4,0,33,29,4,0,95,24,4,0,67,29,4,0,99,29,4,0,125,29,4,0,149,29,4,0,176,29,4,0,194,29,4,0,228,29,4,0,253,29,4,0,37,30,4,0,73,30,4,0,109,30,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,134,30,4,0,163,30,4,0,189,30,4,0,223,30,4,0,253,30,4,0,190,185,17,0,190,185,17,0,22,31,4,0,80,31,4,0,89,31,4,0,98,31,4,0,109,31,4,0,120,31,4,0,145,31,4,0,170,31,4,0,218,31,4,0,221,31,4,0,224,31,4,0,249,31,4,0,2,32,4,0,21,32,4,0,51,32,4,0,65,32,4,0,93,32,4,0,122,32,4,0,134,32,4,0,172,32,4,0,201,32,4,0,214,32,4,0,229,32,4,0,253,32,4,0,23,33,4,0,46,33,4,0,80,33,4,0,87,33,4,0,99,33,4,0,120,33,4,0,152,33,4,0,159,33,4,0,174,33,4,0,189,33,4,0,196,33,4,0,203,33,4,0,215,33,4,0,227,33,4,0,239,33,4,0,0,34,4,0,13,34,4,0,28,34,4,0,43,34,4,0,57,34,4,0,79,34,4,0,122,34,4,0,160,34,4,0,190,185,17,0,197,34,4,0,221,34,4,0,27,35,4,0,190,185,17,0,34,35,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,47,35,4,0,190,185,17,0,133,35,4,0,190,185,17,0,187,35,4,0,190,185,17,0,203,35,4,0,190,185,17,0,216,35,4,0,190,185,17,0,14,36,4,0,21,36,4,0,190,185,17,0,33,36,4,0,123,36,4,0,221,36,4,0,58,37,4,0,178,37,4,0,69,38,4,0,246,38,4,0,154,39,4,0,40,40,4,0,177,40,4,0,223,40,4,0,70,41,4,0,148,41,4,0,4,42,4,0,95,42,4,0,117,42,4,0,190,185,17,0,152,42,4,0,195,42,4,0,238,42,4,0,14,43,4,0,46,43,4,0,190,185,17,0,78,43,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,95,43,4,0,112,43,4,0,159,43,4,0,198,43,4,0,230,43,4,0,252,43,4,0,13,44,4,0,59,44,4,0,76,44,4,0,83,44,4,0,106,44,4,0,123,44,4,0,135,44,4,0,157,44,4,0,174,44,4,0,219,44,4,0,247,44,4,0,41,45,4,0,74,45,4,0,117,45,4,0,129,45,4,0,152,45,4,0,164,45,4,0,186,45,4,0,198,45,4,0,212,45,4,0,95,43,4,0,112,43,4,0,229,45,4,0,241,45,4,0,230,43,4,0,212,45,4,0,59,44,4,0,2,46,4,0,76,44,4,0,106,44,4,0,52,46,4,0,135,44,4,0,157,44,4,0,64,46,4,0,174,44,4,0,81,46,4,0,219,44,4,0,98,46,4,0,117,45,4,0,117,46,4,0,155,46,4,0,197,46,4,0,209,46,4,0,245,46,4,0,24,47,4,0,65,47,4,0,147,47,4,0,196,47,4,0,11,48,4,0,68,48,4,0,123,48,4,0,182,48,4,0,2,49,4,0,53,49,4,0,104,49,4,0,181,49,4,0,240,49,4,0,73,50,4,0,137,50,4,0,196,50,4,0,3,51,4,0,68,51,4,0,145,51,4,0,202,51,4,0,252,51,4,0,62,52,4,0,127,52,4,0,175,52,4,0,247,52,4,0,67,53,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,148,53,4,0,165,53,4,0,172,53,4,0,184,53,4,0,191,53,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,204,53,4,0,240,53,4,0,20,54,4,0,51,54,4,0,87,54,4,0,124,54,4,0,142,54,4,0,188,54,4,0,210,54,4,0,228,54,4,0,252,54,4,0,76,44,4,0,13,55,4,0,50,55,4,0,72,55,4,0,109,55,4,0,145,55,4,0,181,55,4,0,199,55,4,0,236,55,4,0,254,55,4,0,20,56,4,0,32,56,4,0,54,56,4,0,66,56,4,0,86,56,4,0,103,56,4,0,151,56,4,0,212,56,4,0,246,56,4,0,39,57,4,0,77,57,4,0,123,57,4,0,161,57,4,0,216,57,4,0,235,57,4,0,16,58,4,0,34,58,4,0,75,58,4,0,103,58,4,0,160,58,4,0,197,58,4,0,222,58,4,0,5,59,4,0,42,59,4,0,58,59,4,0,91,59,4,0,134,59,4,0,162,59,4,0,202,59,4,0,248,59,4,0,37,60,4,0,84,60,4,0,113,60,4,0,161,60,4,0,196,60,4,0,245,60,4,0,45,61,4,0,103,61,4,0,135,61,4,0,175,61,4,0,240,61,4,0,21,62,4,0,86,62,4,0,132,62,4,0,179,62,4,0,226,62,4,0,24,63,4,0,55,63,4,0,87,63,4,0,118,63,4,0,156,63,4,0,190,63,4,0,239,63,4,0,23,64,4,0,69,64,4,0,116,64,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,161,64,4,0,214,64,4,0,246,64,4,0,36,65,4,0,78,65,4,0,190,185,17,0,190,185,17,0,111,65,4,0,199,65,4,0,208,65,4,0,217,65,4,0,234,65,4,0,251,65,4,0,28,66,4,0,61,66,4,0,221,31,4,0,124,66,4,0,127,66,4,0,164,66,4,0,175,66,4,0,206,66,4,0,239,66,4,0,253,66,4,0,34,67,4,0,83,67,4,0,95,67,4,0,156,67,4,0,205,67,4,0,218,67,4,0,237,67,4,0,5,68,4,0,35,68,4,0,53,68,4,0,95,68,4,0,102,68,4,0,114,68,4,0,143,68,4,0,196,68,4,0,203,68,4,0,226,68,4,0,249,68,4,0,0,69,4,0,7,69,4,0,19,69,4,0,31,69,4,0,43,69,4,0,60,69,4,0,73,69,4,0,90,69,4,0,107,69,4,0,125,69,4,0,147,69,4,0,218,69,4,0,16,70,4,0,69,70,4,0,81,70,4,0,93,70,4,0,102,70,4,0,137,70,4,0,200,70,4,0,252,70,4,0,34,71,4,0,126,71,4,0,230,71,4,0,190,185,17,0,190,185,17,0,190,185,17,0,79,72,4,0,115,72,4,0,147,72,4,0,164,72,4,0,214,72,4,0,6,73,4,0,32,73,4,0,52,73,4,0,75,73,4,0,102,73,4,0,125,73,4,0,140,73,4,0,153,73,4,0,168,73,4,0,183,73,4,0,226,73,4,0,13,74,4,0,76,74,4,0,116,74,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,176,74,4,0,183,74,4,0,190,74,4,0,197,74,4,0,204,74,4,0,211,74,4,0,218,74,4,0,190,185,17,0,225,74,4,0,232,74,4,0,239,74,4,0,246,74,4,0,190,185,17,0,253,74,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,4,75,4,0,23,75,4,0,42,75,4,0,61,75,4,0,80,75,4,0,91,75,4,0,102,75,4,0,113,75,4,0,124,75,4,0,171,75,4,0,218,75,4,0,9,76,4,0,56,76,4,0,99,76,4,0,138,76,4,0,190,185,17,0,189,76,4,0,206,76,4,0,217,76,4,0,229,76,4,0,246,76,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,7,77,4,0,44,77,4,0,57,77,4,0,68,77,4,0,81,77,4,0,106,77,4,0,118,77,4,0,130,77,4,0,190,185,17,0,190,185,17,0,147,77,4,0,211,77,4,0,3,78,4,0,34,78,4,0,65,78,4,0,96,78,4,0,127,78,4,0,190,185,17,0,190,185,17,0,190,185,17,0,167,78,4,0,192,78,4,0,213,78,4,0,239,78,4,0,15,79,4,0,52,79,4,0,73,79,4,0,102,79,4,0,166,79,4,0,186,79,4,0,252,79,4,0,110,80,4,0,26,81,4,0,104,81,4,0,166,81,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,193,81,4,0,206,81,4,0,227,81,4,0,0,82,4,0,7,77,4,0,37,82,4,0,82,82,4,0,151,82,4,0,220,82,4,0,65,83,4,0,133,83,4,0,198,83,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,3,84,4,0,35,84,4,0,101,84,4,0,149,84,4,0,199,84,4,0,239,84,4,0,19,85,4,0,87,85,4,0,134,85,4,0,156,85,4,0,193,85,4,0,240,85,4,0,10,86,4,0,62,86,4,0,99,86,4,0,162,86,4,0,209,86,4,0,44,87,4,0,113,87,4,0,177,87,4,0,207,87,4,0,245,87,4,0,16,88,4,0,58,88,4,0,95,88,4,0,131,88,4,0,3,84,4,0,35,84,4,0,161,88,4,0,187,88,4,0,199,84,4,0,131,88,4,0,87,85,4,0,214,88,4,0,134,85,4,0,193,85,4,0,41,89,4,0,10,86,4,0,62,86,4,0,68,89,4,0,99,86,4,0,130,89,4,0,162,86,4,0,167,89,4,0,177,87,4,0,204,89,4,0,11,90,4,0,58,88,4,0,86,90,4,0,147,90,4,0,214,90,4,0,246,90,4,0,54,91,4,0,104,91,4,0,154,91,4,0,194,91,4,0,230,91,4,0,38,92,4,0,85,92,4,0,107,92,4,0,144,92,4,0,191,92,4,0,217,92,4,0,13,93,4,0,50,93,4,0,113,93,4,0,158,93,4,0,247,93,4,0,56,94,4,0,112,94,4,0,142,94,4,0,180,94,4,0,207,94,4,0,249,94,4,0,30,95,4,0,66,95,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,96,95,4,0,103,95,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,115,95,4,0,177,95,4,0,232,95,4,0,24,96,4,0,84,96,4,0,135,96,4,0,173,96,4,0,253,96,4,0,48,97,4,0,81,97,4,0,125,97,4,0,172,97,4,0,194,97,4,0,18,98,4,0,69,98,4,0,124,98,4,0,184,98,4,0,239,98,4,0,24,99,4,0,76,99,4,0,103,99,4,0,154,99,4,0,181,99,4,0,223,99,4,0,4,100,4,0,47,100,4,0,77,100,4,0,139,100,4,0,215,100,4,0,252,100,4,0,72,101,4,0,124,101,4,0,180,101,4,0,230,101,4,0,43,102,4,0,69,102,4,0,118,102,4,0,146,102,4,0,195,102,4,0,231,102,4,0,44,103,4,0,99,103,4,0,135,103,4,0,191,103,4,0,246,103,4,0,16,104,4,0,64,104,4,0,132,104,4,0,165,104,4,0,219,104,4,0,33,105,4,0,95,105,4,0,156,105,4,0,200,105,4,0,11,106,4,0,57,106,4,0,102,106,4,0,168,106,4,0,223,106,4,0,18,107,4,0,69,107,4,0,129,107,4,0,160,107,4,0,248,107,4,0,44,103,4,0,56,108,4,0,123,108,4,0,176,108,4,0,219,108,4,0,11,109,4,0,42,109,4,0,16,104,4,0,106,109,4,0,178,109,4,0,252,109,4,0,64,110,4,0,115,110,4,0,188,110,4,0,241,110,4,0,34,111,4,0,122,111,4,0,206,111,4,0,190,185,17,0,228,111,4,0,13,112,4,0,81,112,4,0,146,112,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,112,4,0,21,113,4,0,94,113,4,0,166,113,4,0,29,114,4,0,147,114,4,0,190,185,17,0,187,114,4,0,190,114,4,0,193,114,4,0,248,114,4,0,11,115,4,0,79,115,4,0,155,115,4,0,179,115,4,0,242,115,4,0,57,116,4,0,98,116,4,0,196,116,4,0,11,117,4,0,24,117,4,0,41,117,4,0,65,117,4,0,93,117,4,0,122,117,4,0,179,117,4,0,191,117,4,0,213,117,4,0,234,117,4,0,251,117,4,0,2,118,4,0,34,118,4,0,66,118,4,0,88,118,4,0,110,118,4,0,159,118,4,0,208,118,4,0,217,118,4,0,226,118,4,0,233,118,4,0,245,118,4,0,252,118,4,0,8,119,4,0,25,119,4,0,42,119,4,0,54,119,4,0,67,119,4,0,96,119,4,0,108,119,4,0,125,119,4,0,142,119,4,0,151,119,4,0,160,119,4,0,179,119,4,0,198,119,4,0,241,119,4,0,17,120,4,0,33,120,4,0,47,120,4,0,61,120,4,0,89,120,4,0,106,120,4,0,123,120,4,0,140,120,4,0,190,185,17,0,157,120,4,0,180,120,4,0,203,120,4,0,226,120,4,0,249,120,4,0,21,121,4,0,46,121,4,0,71,121,4,0,96,121,4,0,121,121,4,0,194,121,4,0,221,121,4,0,240,121,4,0,36,122,4,0,115,122,4,0,168,122,4,0,219,122,4,0,44,123,4,0,102,123,4,0,168,123,4,0,190,123,4,0,12,124,4,0,67,124,4,0,149,124,4,0,190,185,17,0,171,124,4,0,219,124,4,0,25,125,4,0,69,125,4,0,116,125,4,0,164,125,4,0,211,125,4,0,6,126,4,0,58,126,4,0,108,126,4,0,159,126,4,0,199,126,4,0,243,126,4,0,9,127,4,0,77,127,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,145,127,4,0,182,127,4,0,219,127,4,0,3,128,4,0,43,128,4,0,65,128,4,0,87,128,4,0,138,128,4,0,189,128,4,0,237,128,4,0,29,129,4,0,53,129,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+61440);allocate([190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,117,129,4,0,149,129,4,0,235,129,4,0,43,130,4,0,101,130,4,0,141,130,4,0,177,130,4,0,254,130,4,0,45,131,4,0,67,131,4,0,106,131,4,0,153,131,4,0,179,131,4,0,231,131,4,0,12,132,4,0,99,132,4,0,154,132,4,0,23,133,4,0,108,133,4,0,176,133,4,0,206,133,4,0,250,133,4,0,21,134,4,0,63,134,4,0,100,134,4,0,136,134,4,0,117,129,4,0,149,129,4,0,166,134,4,0,192,134,4,0,101,130,4,0,136,134,4,0,254,130,4,0,219,134,4,0,45,131,4,0,106,131,4,0,70,135,4,0,179,131,4,0,231,131,4,0,97,135,4,0,12,132,4,0,159,135,4,0,99,132,4,0,196,135,4,0,176,133,4,0,233,135,4,0,40,136,4,0,63,134,4,0,131,136,4,0,208,136,4,0,35,137,4,0,67,137,4,0,145,137,4,0,213,137,4,0,15,138,4,0,55,138,4,0,91,138,4,0,173,138,4,0,220,138,4,0,242,138,4,0,27,139,4,0,74,139,4,0,100,139,4,0,152,139,4,0,189,139,4,0,16,140,4,0,67,140,4,0,186,140,4,0,9,141,4,0,79,141,4,0,109,141,4,0,157,141,4,0,184,141,4,0,226,141,4,0,7,142,4,0,43,142,4,0,73,142,4,0,158,142,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,217,142,4,0,224,142,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,236,142,4,0,56,143,4,0,119,143,4,0,175,143,4,0,243,143,4,0,48,144,4,0,90,144,4,0,206,144,4,0,1,145,4,0,34,145,4,0,82,145,4,0,129,145,4,0,151,145,4,0,231,145,4,0,26,146,4,0,97,146,4,0,165,146,4,0,228,146,4,0,15,147,4,0,79,147,4,0,110,147,4,0,161,147,4,0,188,147,4,0,230,147,4,0,11,148,4,0,52,148,4,0,82,148,4,0,160,148,4,0,14,149,4,0,68,149,4,0,155,149,4,0,217,149,4,0,23,150,4,0,85,150,4,0,172,150,4,0,202,150,4,0,1,151,4,0,45,151,4,0,98,151,4,0,143,151,4,0,230,151,4,0,37,152,4,0,77,152,4,0,138,152,4,0,206,152,4,0,236,152,4,0,41,153,4,0,114,153,4,0,159,153,4,0,225,153,4,0,55,154,4,0,131,154,4,0,200,154,4,0,250,154,4,0,75,155,4,0,127,155,4,0,196,155,4,0,24,156,4,0,83,156,4,0,134,156,4,0,197,156,4,0,5,157,4,0,40,157,4,0,140,157,4,0,230,151,4,0,212,157,4,0,37,158,4,0,100,158,4,0,151,158,4,0,207,158,4,0,242,158,4,0,58,159,4,0,110,159,4,0,190,159,4,0,16,160,4,0,96,160,4,0,155,160,4,0,236,160,4,0,41,161,4,0,105,161,4,0,205,161,4,0,52,162,4,0,190,185,17,0,74,162,4,0,123,162,4,0,207,162,4,0,32,163,4,0,190,185,17,0,190,185,17,0,86,163,4,0,175,163,4,0,54,164,4,0,155,164,4,0,3,165,4,0,170,165,4,0,84,166,4,0,190,185,17,0,221,31,4,0,124,66,4,0,124,166,4,0,203,166,4,0,224,166,4,0,56,167,4,0,148,167,4,0,172,167,4,0,247,167,4,0,86,168,4,0,145,168,4,0,11,169,4,0,205,67,4,0,106,169,4,0,237,67,4,0,123,169,4,0,151,169,4,0,180,169,4,0,243,169,4,0,255,169,4,0,114,68,4,0,21,170,4,0,196,68,4,0,219,127,4,0,3,128,4,0,43,128,4,0,65,128,4,0,87,128,4,0,138,128,4,0,38,170,4,0,47,170,4,0,249,68,4,0,56,170,4,0,0,69,4,0,7,69,4,0,68,170,4,0,85,170,4,0,31,69,4,0,102,170,4,0,125,170,4,0,19,69,4,0,154,170,4,0,171,170,4,0,199,65,4,0,208,65,4,0,188,170,4,0,207,170,4,0,226,170,4,0,13,171,4,0,61,171,4,0,77,171,4,0,91,171,4,0,105,171,4,0,90,69,4,0,73,69,4,0,141,171,4,0,158,171,4,0,175,171,4,0,194,171,4,0,221,171,4,0,248,171,4,0,19,172,4,0,46,172,4,0,78,172,4,0,99,172,4,0,120,172,4,0,141,172,4,0,162,172,4,0,249,172,4,0,20,173,4,0,53,129,4,0,39,173,4,0,138,173,4,0,191,173,4,0,254,173,4,0,95,174,4,0,205,174,4,0,125,69,4,0,31,175,4,0,121,175,4,0,177,175,4,0,24,176,4,0,190,185,17,0,46,176,4,0,121,176,4,0,205,176,4,0,1,177,4,0,56,177,4,0,116,177,4,0,169,177,4,0,226,177,4,0,55,178,4,0,124,178,4,0,183,178,4,0,231,178,4,0,27,179,4,0,49,179,4,0,145,179,4,0,241,179,4,0,10,180,4,0,35,180,4,0,60,180,4,0,190,185,17,0,85,180,4,0,163,180,4,0,6,181,4,0,62,181,4,0,154,181,4,0,249,181,4,0,83,182,4,0,162,182,4,0,218,182,4,0,21,183,4,0,86,183,4,0,152,183,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,242,183,4,0,9,184,4,0,44,184,4,0,79,184,4,0,79,184,4,0,146,184,4,0,209,184,4,0,241,184,4,0,17,185,4,0,65,185,4,0,97,185,4,0,129,185,4,0,218,185,4,0,10,186,4,0,180,186,4,0,117,187,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,242,183,4,0,9,184,4,0,44,184,4,0,169,187,4,0,79,184,4,0,146,184,4,0,209,184,4,0,241,184,4,0,17,185,4,0,65,185,4,0,97,185,4,0,232,187,4,0,44,188,4,0,10,186,4,0,92,188,4,0,1,189,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,162,189,4,0,199,189,4,0,241,189,4,0,41,190,4,0,97,190,4,0,123,190,4,0,149,190,4,0,224,190,4,0,43,191,4,0,107,191,4,0,171,191,4,0,197,191,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,52,192,4,0,88,192,4,0,172,192,4,0,248,192,4,0,54,193,4,0,102,193,4,0,140,193,4,0,228,193,4,0,12,194,4,0,28,194,4,0,68,194,4,0,108,194,4,0,134,194,4,0,180,194,4,0,216,194,4,0,40,195,4,0,92,195,4,0,186,195,4,0,250,195,4,0,80,196,4,0,108,196,4,0,156,196,4,0,182,196,4,0,228,196,4,0,2,197,4,0,34,197,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,70,197,4,0,144,197,4,0,24,198,4,0,106,198,4,0,192,198,4,0,32,199,4,0,122,199,4,0,226,199,4,0,78,200,4,0,144,200,4,0,212,200,4,0,70,201,4,0,150,201,4,0,244,201,4,0,62,202,4,0,130,202,4,0,234,202,4,0,64,203,4,0,190,203,4,0,6,204,4,0,81,204,4,0,157,204,4,0,229,204,4,0,51,205,4,0,154,205,4,0,236,205,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,67,206,4,0,137,206,4,0,207,206,4,0,15,207,4,0,85,207,4,0,157,207,4,0,202,207,4,0,40,208,4,0,88,208,4,0,134,208,4,0,180,208,4,0,12,194,4,0,220,208,4,0,44,209,4,0,92,209,4,0,164,209,4,0,234,209,4,0,48,210,4,0,88,210,4,0,182,210,4,0,212,210,4,0,4,211,4,0,30,211,4,0,76,211,4,0,106,211,4,0,138,211,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,174,211,4,0,238,211,4,0,27,212,4,0,71,212,4,0,135,212,4,0,181,212,4,0,235,212,4,0,53,213,4,0,110,213,4,0,147,213,4,0,194,213,4,0,252,213,4,0,29,214,4,0,115,214,4,0,177,214,4,0,235,214,4,0,36,215,4,0,104,215,4,0,150,215,4,0,193,215,4,0,231,215,4,0,27,216,4,0,72,216,4,0,141,216,4,0,221,216,4,0,27,217,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,221,31,4,0,124,66,4,0,101,217,4,0,182,217,4,0,206,217,4,0,16,218,4,0,106,218,4,0,139,218,4,0,238,218,4,0,101,219,4,0,124,219,4,0,1,220,4,0,120,220,4,0,152,220,4,0,198,220,4,0,4,221,4,0,80,221,4,0,126,221,4,0,236,221,4,0,26,222,4,0,72,222,4,0,211,222,4,0,54,223,4,0,70,223,4,0,118,223,4,0,166,223,4,0,237,223,4,0,253,223,4,0,27,224,4,0,57,224,4,0,78,224,4,0,118,224,4,0,177,224,4,0,197,224,4,0,217,224,4,0,19,225,4,0,143,225,4,0,50,226,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,221,31,4,0,124,66,4,0,152,226,4,0,235,226,4,0,7,227,4,0,89,227,4,0,187,227,4,0,206,227,4,0,25,228,4,0,116,228,4,0,173,228,4,0,39,229,4,0,130,229,4,0,143,229,4,0,160,229,4,0,182,229,4,0,210,229,4,0,242,229,4,0,53,230,4,0,70,230,4,0,87,230,4,0,196,230,4,0,20,231,4,0,27,231,4,0,67,231,4,0,107,231,4,0,0,69,4,0,7,69,4,0,19,69,4,0,124,231,4,0,136,231,4,0,158,231,4,0,199,65,4,0,208,65,4,0,187,231,4,0,209,231,4,0,95,174,4,0,138,173,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,117,129,4,0,16,232,4,0,149,129,4,0,166,134,4,0,75,232,4,0,101,130,4,0,130,232,4,0,9,233,4,0,97,233,4,0,144,233,4,0,210,233,4,0,35,234,4,0,179,131,4,0,254,130,4,0,12,132,4,0,159,135,4,0,99,132,4,0,235,129,4,0,176,133,4,0,82,234,4,0,127,234,4,0,63,134,4,0,218,234,4,0,9,235,4,0,60,235,4,0,112,235,4,0,174,235,4,0,233,235,4,0,52,236,4,0,107,236,4,0,184,236,4,0,40,237,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,236,142,4,0,125,237,4,0,219,237,4,0,33,238,4,0,59,238,4,0,243,143,4,0,100,238,4,0,211,238,4,0,37,239,4,0,84,239,4,0,150,239,4,0,221,239,4,0,6,240,4,0,58,240,4,0,26,146,4,0,105,240,4,0,97,146,4,0,119,143,4,0,142,240,4,0,172,240,4,0,213,240,4,0,230,147,4,0,55,241,4,0,96,241,4,0,147,241,4,0,199,241,4,0,255,241,4,0,50,242,4,0,117,242,4,0,164,242,4,0,231,242,4,0,71,243,4,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,146,243,4,0,208,243,4,0,93,244,4,0,166,244,4,0,22,245,4,0,164,245,4,0,28,246,4,0,140,246,4,0,21,247,4,0,88,247,4,0,171,247,4,0,32,248,4,0,121,248,4,0,228,248,4,0,39,249,4,0,144,249,4,0,249,249,4,0,141,250,4,0,29,251,4,0,116,251,4,0,213,251,4,0,38,252,4,0,97,252,4,0,192,252,4,0,28,253,4,0,111,253,4,0,146,243,4,0,208,243,4,0,182,253,4,0,15,254,4,0,22,245,4,0,111,253,4,0,140,246,4,0,52,254,4,0,21,247,4,0,171,247,4,0,217,254,4,0,121,248,4,0,228,248,4,0,18,255,4,0,39,249,4,0,190,255,4,0,144,249,4,0,61,0,5,0,116,251,4,0,124,0,5,0,238,0,5,0,192,252,4,0,128,1,5,0,24,2,5,0,133,2,5,0,199,2,5,0,84,3,5,0,165,3,5,0,23,4,5,0,160,4,5,0,24,5,5,0,146,5,5,0,27,6,5,0,94,6,5,0,181,6,5,0,47,7,5,0,131,7,5,0,247,7,5,0,65,8,5,0,174,8,5,0,25,9,5,0,175,9,5,0,59,10,5,0,146,10,5,0,238,10,5,0,69,11,5,0,130,11,5,0,229,11,5,0,65,12,5,0,153,12,5,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,214,12,5,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,248,12,5,0,96,13,5,0,184,13,5,0,251,13,5,0,91,14,5,0,170,14,5,0,243,14,5,0,157,15,5,0,15,16,5,0,90,16,5,0,166,16,5,0,14,17,5,0,68,17,5,0,242,17,5,0,100,18,5,0,189,18,5,0,42,19,5,0,143,19,5,0,220,19,5,0,47,20,5,0,89,20,5,0,167,20,5,0,221,20,5,0,43,21,5,0,125,21,5,0,197,21,5,0,12,22,5,0,115,22,5,0,245,22,5,0,83,23,5,0,200,23,5,0,40,24,5,0,141,24,5,0,221,24,5,0,88,25,5,0,139,25,5,0,244,25,5,0,42,26,5,0,122,26,5,0,195,26,5,0,100,18,5,0,70,27,5,0,140,27,5,0,229,27,5,0,76,28,5,0,126,28,5,0,204,28,5,0,63,29,5,0,133,29,5,0,236,29,5,0,86,30,5,0,182,30,5,0,25,31,5,0,92,31,5,0,202,31,5,0,11,32,5,0,99,32,5,0,209,32,5,0,29,33,5,0,95,33,5,0,181,33,5,0,16,34,5,0,65,34,5,0,180,34,5,0,4,35,5,0,93,35,5,0,216,35,5,0,65,36,5,0,123,36,5,0,214,36,5,0,2,37,5,0,82,37,5,0,139,37,5,0,231,37,5,0,74,38,5,0,168,38,5,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,241,38,5,0,100,39,5,0,185,39,5,0,36,40,5,0,149,40,5,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,221,31,4,0,124,66,4,0,229,40,5,0,70,41,5,0,119,41,5,0,238,41,5,0,128,42,5,0,177,42,5,0,26,43,5,0,160,43,5,0,241,43,5,0,135,44,5,0,120,220,4,0,152,220,4,0,198,220,4,0,4,221,4,0,13,45,5,0,77,45,5,0,236,221,4,0,26,222,4,0,177,45,5,0,63,46,5,0,54,223,4,0,172,46,5,0,225,46,5,0,166,223,4,0,237,223,4,0,253,223,4,0,27,224,4,0,57,224,4,0,78,224,4,0,118,224,4,0,177,224,4,0,197,224,4,0,217,224,4,0,22,47,5,0,158,47,5,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,221,31,4,0,124,66,4,0,34,48,5,0,147,48,5,0,184,48,5,0,28,49,5,0,152,49,5,0,180,49,5,0,17,50,5,0,136,50,5,0,209,50,5,0,146,51,5,0,9,52,5,0,41,52,5,0,84,52,5,0,146,52,5,0,219,52,5,0,27,53,5,0,141,53,5,0,184,53,5,0,227,53,5,0,111,54,5,0,212,54,5,0,228,54,5,0,34,55,5,0,96,55,5,0,237,223,4,0,253,223,4,0,27,224,4,0,167,55,5,0,188,55,5,0,228,55,5,0,177,224,4,0,197,224,4,0,31,56,5,0,89,56,5,0,225,56,5,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,190,185,17,0,0,0,0,0,148,128,13,0,46,58,5,0,159,57,5,0,131,0,0,0,1,0,0,0,152,128,13,0,205,58,5,0,159,57,5,0,14,1,0,0,1,0,0,0,0,0,0,0,176,60,0,0,30,0,0,0,252,1,0,0,74,0,0,0,0,0,0,0,160,60,0,0,30,0,0,0,253,1,0,0,75,0,0,0,0,0,0,0,224,60,0,0,30,0,0,0,254,1,0,0,76,0,0,0,0,0,0,0,208,60,0,0,30,0,0,0,255,1,0,0,77,0,0,0,0,0,0,0,192,60,0,0,30,0,0,0,0,2,0,0,78,0,0,0,0,0,0,0,0,61,0,0,30,0,0,0,1,2,0,0,79,0,0,0,0,0,0,0,240,60,0,0,30,0,0,0,2,2,0,0,80,0,0,0,0,0,0,0,48,61,0,0,30,0,0,0,3,2,0,0,81,0,0,0,0,0,0,0,32,61,0,0,30,0,0,0,4,2,0,0,82,0,0,0,0,0,0,0,16,61,0,0,30,0,0,0,5,2,0,0,83,0,0,0,156,128,13,0,23,65,5,0,158,64,5,0,148,2,0,0,1,0,0,0,160,128,13,0,65,65,5,0,158,64,5,0,2,3,0,0,1,0,0,0,176,128,13,0,141,67,5,0,238,67,5,0,94,5,0,0,1,0,0,0,0,0,0,0,96,61,0,0,30,0,0,0,6,2,0,0,84,0,0,0,0,0,0,0,80,61,0,0,30,0,0,0,7,2,0,0,85,0,0,0,0,0,0,0,64,61,0,0,30,0,0,0,8,2,0,0,86,0,0,0,164,128,13,0,115,65,5,0,47,159,5,0,143,1,0,0,1,0,0,0,168,128,13,0,27,66,5,0,47,159,5,0,143,1,0,0,1,0,0,0,172,128,13,0,213,66,5,0,47,159,5,0,143,1,0,0,1,0,0,0,184,128,13,0,213,68,5,0,238,67,5,0,157,5,0,0,1,0,0,0,0,0,0,0,112,61,0,0,30,0,0,0,9,2,0,0,87,0,0,0,180,128,13,0,53,68,5,0,47,159,5,0,143,1,0,0,1,0,0,0,192,128,13,0,212,69,5,0,238,67,5,0,170,5,0,0,1,0,0,0,0,0,0,0,128,61,0,0,30,0,0,0,10,2,0,0,88,0,0,0,188,128,13,0,52,69,5,0,47,159,5,0,143,1,0,0,1,0,0,0,208,128,13,0,54,72,5,0,238,67,5,0,183,5,0,0,1,0,0,0,35,19,0,0,145,37,0,0,76,7,0,0,0,0,0,0,176,61,0,0,30,0,0,0,11,2,0,0,89,0,0,0,0,0,0,0,160,61,0,0,30,0,0,0,12,2,0,0,90,0,0,0,135,22,153,62,162,69,22,63,213,120,233,61,0,0,0,0,144,61,0,0,30,0,0,0,13,2,0,0,91,0,0,0,196,128,13,0,51,70,5,0,47,159,5,0,143,1,0,0,1,0,0,0,200,128,13,0,222,70,5,0,47,159,5,0,143,1,0,0,1,0,0,0,204,128,13,0,139,71,5,0,47,159,5,0,143,1,0,0,1,0,0,0,224,128,13,0,182,74,5,0,238,67,5,0,232,5,0,0,1,0,0,0,0,0,0,0,224,61,0,0,30,0,0,0,14,2,0,0,92,0,0,0,0,0,0,0,208,61,0,0,30,0,0,0,15,2,0,0,93,0,0,0,0,0,0,0,192,61,0,0,30,0,0,0,16,2,0,0,94,0,0,0,212,128,13,0,147,72,5,0,47,159,5,0,143,1,0,0,1,0,0,0,216,128,13,0,62,73,5,0,47,159,5,0,143,1,0,0,1,0,0,0,220,128,13,0,251,73,5,0,47,159,5,0,143,1,0,0,1,0,0,0,232,128,13,0,176,75,5,0,238,67,5,0,25,6,0,0,1,0,0,0,0,0,0,0,240,61,0,0,30,0,0,0,17,2,0,0,95,0,0,0,228,128,13,0,13,75,5,0,47,159,5,0,143,1,0,0,1,0,0,0,240,128,13,0,168,76,5,0,238,67,5,0,37,6,0,0,1,0,0,0,0,0,0,0,0,62,0,0,30,0,0,0,18,2,0,0,96,0,0,0,236,128,13,0,5,76,5,0,47,159,5,0,143,1,0,0,1,0,0,0,248,128,13,0,191,77,5,0,238,67,5,0,47,6,0,0,1,0,0,0,0,0,0,0,16,62,0,0,30,0,0,0,19,2,0,0,97,0,0,0,244,128,13,0,253,76,5,0,47,159,5,0,143,1,0,0,1,0,0,0,0,129,13,0,217,78,5,0,238,67,5,0,67,6,0,0,1,0,0,0,0,0,0,0,32,62,0,0,30,0,0,0,20,2,0,0,98,0,0,0,252,128,13,0,23,78,5,0,47,159,5,0,143,1,0,0,1,0,0,0,49,79,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,49,79,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,49,79,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,41,80,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,41,80,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,41,80,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,39,81,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,39,81,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,39,81,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,37,82,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,37,82,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,37,82,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,31,83,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,31,83,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,31,83,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,25,84,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,25,84,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,25,84,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,25,85,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,25,85,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,25,85,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,25,86,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,25,86,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,25,86,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,4,129,13,0,157,87,5,0,83,87,5,0,90,0,0,0,1,0,0,0,0,0,0,0,96,63,0,0,110,0,0,0,21,2,0,0,63,0,0,0,0,0,0,0,80,63,0,0,47,0,0,0,22,2,0,0,23,2,0,0,0,0,0,0,64,63,0,0,110,0,0,0,24,2,0,0,64,0,0,0,0,0,0,0,48,63,0,0,47,0,0,0,25,2,0,0,26,2,0,0,0,0,0,0,32,63,0,0,110,0,0,0,27,2,0,0,65,0,0,0,0,0,0,0,16,63,0,0,47,0,0,0,28,2,0,0,29,2,0,0,0,0,0,0,0,63,0,0,110,0,0,0,30,2,0,0,66,0,0,0,0,0,0,0,240,62,0,0,47,0,0,0,31,2,0,0,32,2,0,0,0,0,0,0,224,62,0,0,110,0,0,0,33,2,0,0,67,0,0,0,0,0,0,0,208,62,0,0,47,0,0,0,34,2,0,0,35,2,0,0,0,0,0,0,192,62,0,0,110,0,0,0,36,2,0,0,68,0,0,0,0,0,0,0,176,62,0,0,47,0,0,0,37,2,0,0,38,2,0,0,0,0,0,0,160,62,0,0,110,0,0,0,39,2,0,0,69,0,0,0,0,0,0,0,144,62,0,0,47,0,0,0,40,2,0,0,41,2,0,0,0,0,0,0,128,62,0,0,110,0,0,0,42,2,0,0,70,0,0,0,0,0,0,0,112,62,0,0,47,0,0,0,43,2,0,0,44,2,0,0,0,0,0,0,96,62,0,0,110,0,0,0,45,2,0,0,71,0,0,0,0,0,0,0,80,62,0,0,47,0,0,0,46,2,0,0,47,2,0,0,0,0,0,0,64,62,0,0,110,0,0,0,48,2,0,0,72,0,0,0,0,0,0,0,48,62,0,0,47,0,0,0,49,2,0,0,50,2,0,0,0,0,0,0,160,64,0,0,112,0,0,0,51,2,0,0,66,0,0,0,114,0,0,0,0,0,0,0,144,64,0,0,47,0,0,0,52,2,0,0,53,2,0,0,0,0,0,0,128,64,0,0,112,0,0,0,54,2,0,0,67,0,0,0,114,0,0,0,0,0,0,0,112,64,0,0,47,0,0,0,55,2,0,0,56,2,0,0,0,0,0,0,96,64,0,0,112,0,0,0,57,2,0,0,68,0,0,0,114,0,0,0,0,0,0,0,80,64,0,0,47,0,0,0,58,2,0,0,59,2,0,0,0,0,0,0,64,64,0,0,112,0,0,0,60,2,0,0,69,0,0,0,114,0,0,0,0,0,0,0,48,64,0,0,47,0,0,0,61,2,0,0,62,2,0,0,0,0,0,0,32,64,0,0,112,0,0,0,63,2,0,0,70,0,0,0,114,0,0,0,0,0,0,0,16,64,0,0,47,0,0,0,64,2,0,0,65,2,0,0,0,0,0,0,0,64,0,0,112,0,0,0,66,2,0,0,71,0,0,0,114,0,0,0,0,0,0,0,240,63,0,0,47,0,0,0,67,2,0,0,68,2,0,0,0,0,0,0,224,63,0,0,112,0,0,0,69,2,0,0,72,0,0,0,114,0,0,0,0,0,0,0,208,63,0,0,47,0,0,0,70,2,0,0,71,2,0,0,0,0,0,0,192,63,0,0,112,0,0,0,72,2,0,0,73,0,0,0,114,0,0,0,0,0,0,0,176,63,0,0,47,0,0,0,73,2,0,0,74,2,0,0,0,0,0,0,160,63,0,0,112,0,0,0,75,2,0,0,74,0,0,0,114,0,0,0,0,0,0,0,144,63,0,0,47,0,0,0,76,2,0,0,77,2,0,0,0,0,0,0,128,63,0,0,112,0,0,0,78,2,0,0,75,0,0,0,114,0,0,0,0,0,0,0,112,63,0,0,47,0,0,0,79,2,0,0,80,2,0,0,0,0,0,0,208,65,0,0,47,0,0,0,81,2,0,0,82,2,0,0,0,0,0,0,176,65,0,0,47,0,0,0,83,2,0,0,84,2,0,0,0,0,0,0,144,65,0,0,47,0,0,0,85,2,0,0,86,2,0,0,0,0,0,0,112,65,0,0,47,0,0,0,87,2,0,0,88,2,0,0,0,0,0,0,80,65,0,0,47,0,0,0,89,2,0,0,90,2,0,0,0,0,0,0,48,65,0,0,47,0,0,0,91,2,0,0,92,2,0,0,0,0,0,0,16,65,0,0,47,0,0,0,93,2,0,0,94,2,0,0,0,0,0,0,240,64,0,0,47,0,0,0,95,2,0,0,96,2,0,0,0,0,0,0,208,64,0,0,47,0,0,0,97,2,0,0,98,2,0,0,0,0,0,0,176,64,0,0,47,0,0,0,99,2,0,0,100,2,0,0,0,0,0,0,192,64,0,0,101,2,0,0,102,2,0,0,41,0,0,0,117,0,0,0,0,0,0,0,224,64,0,0,103,2,0,0,104,2,0,0,42,0,0,0,117,0,0,0,0,0,0,0,0,65,0,0,105,2,0,0,106,2,0,0,43,0,0,0,117,0,0,0,0,0,0,0,32,65,0,0,107,2,0,0,108,2,0,0,44,0,0,0,117,0,0,0,0,0,0,0,64,65,0,0,109,2,0,0,110,2,0,0,45,0,0,0,117,0,0,0,0,0,0,0,96,65,0,0,111,2,0,0,112,2,0,0,46,0,0,0,117,0,0,0,0,0,0,0,128,65,0,0,113,2,0,0,114,2,0,0,47,0,0,0,117,0,0,0,0,0,0,0,160,65,0,0,115,2,0,0,116,2,0,0,48,0,0,0,117,0,0,0,0,0,0,0,192,65,0,0,117,2,0,0,118,2,0,0,49,0,0,0,117,0,0,0,0,0,0,0,224,65,0,0,119,2,0,0,120,2,0,0,50,0,0,0,117,0,0,0,12,129,13,0,175,109,5,0,13,88,5,0,99,7,0,0,1,0,0,0,8,129,13,0,83,109,5,0,13,88,5,0,31,7,0,0,1,0,0,0,16,129,13,0,4,110,5,0,13,88,5,0,109,7,0,0,1,0,0,0,20,129,13,0,135,110,5,0,13,88,5,0,253,7,0,0,1,0,0,0,24,129,13,0,112,111,5,0,44,111,5,0,56,2,0,0,1,0,0,0,28,129,13,0,179,111,5,0,44,111,5,0,140,2,0,0,1,0,0,0,88,129,13,0,37,114,5,0,129,114,5,0,1,16,0,0,1,0,0,0,153,6,0,0,185,5,0,0,227,2,0,0,103,3,0,0,113,11,0,0,40,1,0,0,79,0,0,0,232,1,0,0,52,15,0,0,0,0,0,0,16,66,0,0,30,0,0,0,121,2,0,0,99,0,0,0,0,0,0,0,0,66,0,0,30,0,0,0,122,2,0,0,100,0,0,0,0,0,0,0,240,65,0,0,30,0,0,0,123,2,0,0,101,0,0,0,76,129,13,0,249,111,5,0,47,159,5,0,143,1,0,0,1,0,0,0,80,129,13,0,167,112,5,0,47,159,5,0,143,1,0,0,1,0,0,0,84,129,13,0,103,113,5,0,47,159,5,0,143,1,0,0,1,0,0,0,104,129,13,0,244,116,5,0,129,114,5,0,52,16,0,0,1,0,0,0,217,51,0,0,104,231,255,255,6,248,255,255,126,240,255,255,4,30,0,0,170,0,0,0,228,0,0,0,188,252,255,255,235,16,0,0,0,0,0,0,64,66,0,0,30,0,0,0,124,2,0,0,102,0,0,0,0,0,0,0,48,66,0,0,30,0,0,0,125,2,0,0,103,0,0,0,0,0,0,0,32,66,0,0,30,0,0,0,126,2,0,0,104,0,0,0,92,129,13,0,200,114,5,0,47,159,5,0,143,1,0,0,1,0,0,0,96,129,13,0,118,115,5,0,47,159,5,0,143,1,0,0,1,0,0,0,100,129,13,0,54,116,5,0,47,159,5,0,143,1,0,0,1,0,0,0,248,129,13,0,127,121,5,0,129,114,5,0,104,16,0,0,1,0,0,0,0,0,0,0,128,66,0,0,30,0,0,0,127,2,0,0,105,0,0,0,0,0,0,0,112,66,0,0,30,0,0,0,128,2,0,0,106,0,0,0,0,0,0,0,96,66,0,0,30,0,0,0,129,2,0,0,107,0,0,0,0,0,0,0,80,66,0,0,30,0,0,0,130,2,0,0,108,0,0,0,116,129,13,0,80,117,5,0,47,159,5,0,143,1,0,0,1,0,0,0,144,129,13,0,236,117,5,0,47,159,5,0,143,1,0,0,1,0,0,0,240,129,13,0,84,119,5,0,47,159,5,0,143,1,0,0,1,0,0,0,244,129,13,0,88,120,5,0,47,159,5,0,143,1,0,0,1,0,0,0,3,0,0,0,24,130,13,0,100,124,5,0,129,114,5,0,201,16,0,0,1,0,0,0,0,0,0,0,192,66,0,0,30,0,0,0,131,2,0,0,109,0,0,0,0,0,0,0,176,66,0,0,30,0,0,0,132,2,0,0,110,0,0,0,0,0,0,0,160,66,0,0,30,0,0,0,133,2,0,0,111,0,0,0,0,0,0,0,144,66,0,0,30,0,0,0,134,2,0,0,112,0,0,0,252,129,13,0,231,121,5,0,47,159,5,0,143,1,0,0,1,0,0,0,12,130,13,0,131,122,5,0,47,159,5,0,143,1,0,0,1,0,0,0,16,130,13,0,44,123,5,0,47,159,5,0,143,1,0,0,1,0,0,0,20,130,13,0,200,123,5,0,47,159,5,0,143,1,0,0,1,0,0,0,204,124,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,204,124,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,204,124,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,200,125,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,200,125,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,200,125,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,196,126,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,196,126,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,196,126,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,190,127,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,190,127,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,190,127,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,28,130,13,0,123,130,5,0,221,128,5,0,130,3,0,0,1,0,0,0,123,130,5,0,221,128,5,0,136,3,0,0,0,0,0,0,221,130,5,0,118,46,6,0,164,129,5,0,45,129,5,0,221,128,5,0,239,0,0,0,0,0,0,0,149,129,5,0,118,46,6,0,164,129,5,0,220,129,5,0,221,128,5,0,113,0,0,0,0,0,0,0,149,129,5,0,118,46,6,0,164,129,5,0,220,129,5,0,221,128,5,0,131,0,0,0,5,0,0,0,62,130,5,0,103,130,5,0,113,130,5,0,32,130,13,0,40,131,5,0,221,128,5,0,153,3,0,0,1,0,0,0,36,130,13,0,209,133,5,0,221,128,5,0,191,6,0,0,1,0,0,0,209,133,5,0,221,128,5,0,197,6,0,0,0,0,0,0,60,134,5,0,118,46,6,0,89,134,5,0,0,0,0,0,0,67,0,0,30,0,0,0,135,2,0,0,113,0,0,0,0,0,0,0,240,66,0,0,30,0,0,0,136,2,0,0,114,0,0,0,0,0,0,0,208,66,0,0,30,0,0,0,137,2,0,0,115,0,0,0,0,0,0,0,224,66,0,0,30,0,0,0,138,2,0,0,116,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,255,255,255,255,1,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,16,67,0,0,47,0,0,0,139,2,0,0,140,2,0,0,40,130,13,0,117,138,5,0,149,134,5,0,101,7,0,0,1,0,0,0,44,130,13,0,164,140,5,0,90,140,5,0,203,2,0,0,1,0,0,0,0,0,0,0,48,67,0,0,30,0,0,0,141,2,0,0,117,0,0,0,0,0,0,0,32,67,0,0,30,0,0,0,142,2,0,0,118,0,0,0,52,130,13,0,135,141,5,0,90,140,5,0,89,3,0,0,1,0,0,0,48,130,13,0,77,141,5,0,90,140,5,0,172,2,0,0,1,0,0,0,68,130,13,0,11,144,5,0,109,144,5,0,223,8,0,0,1,0,0,0,35,19,0,0,145,37,0,0,76,7,0,0,162,45,0,0,25,36,0,0,35,19,0,0,145,37,0,0,76,7,0,0,33,56,0,0,125,31,0,0,0,0,0,0,96,67,0,0,30,0,0,0,143,2,0,0,119,0,0,0,35,19,0,0,145,37,0,0,76,7,0,0,162,45,0,0,25,36,0,0,35,19,0,0,145,37,0,0,76,7,0,0,33,56,0,0,125,31,0,0,0,0,0,0,80,67],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+71680);allocate([30,0,0,0,144,2,0,0,120,0,0,0,135,22,153,62,162,69,22,63,213,120,233,61,43,135,54,63,78,98,16,63,135,22,153,62,162,69,22,63,213,120,233,61,18,131,96,63,109,231,251,62,0,0,0,0,64,67,0,0,30,0,0,0,145,2,0,0,121,0,0,0,56,130,13,0,202,141,5,0,47,159,5,0,143,1,0,0,1,0,0,0,60,130,13,0,127,142,5,0,47,159,5,0,143,1,0,0,1,0,0,0,64,130,13,0,70,143,5,0,47,159,5,0,143,1,0,0,1,0,0,0,84,130,13,0,245,146,5,0,109,144,5,0,20,9,0,0,1,0,0,0,203,89,0,0,78,210,255,255,252,233,255,255,121,113,0,0,246,72,0,0,209,218,255,255,184,230,255,255,12,130,0,0,0,0,0,0,144,67,0,0,30,0,0,0,146,2,0,0,122,0,0,0,203,89,0,0,78,210,255,255,252,233,255,255,121,113,0,0,246,72,0,0,209,218,255,255,184,230,255,255,12,130,0,0,0,0,0,0,128,67,0,0,30,0,0,0,147,2,0,0,123,0,0,0,129,149,179,63,180,200,54,191,197,32,176,190,170,241,226,63,133,235,145,63,106,188,20,191,113,61,202,190,74,12,2,64,0,0,0,0,112,67,0,0,30,0,0,0,148,2,0,0,124,0,0,0,72,130,13,0,180,144,5,0,47,159,5,0,143,1,0,0,1,0,0,0,76,130,13,0,105,145,5,0,47,159,5,0,143,1,0,0,1,0,0,0,80,130,13,0,48,146,5,0,47,159,5,0,143,1,0,0,1,0,0,0,92,130,13,0,80,149,5,0,109,144,5,0,74,9,0,0,1,0,0,0,88,130,13,0,221,148,5,0,109,144,5,0,86,9,0,0,1,0,0,0,0,0,0,0,16,68,0,0,30,0,0,0,149,2,0,0,125,0,0,0,0,0,0,0,0,68,0,0,30,0,0,0,150,2,0,0,126,0,0,0,0,0,0,0,240,67,0,0,30,0,0,0,151,2,0,0,127,0,0,0,0,0,0,0,224,67,0,0,30,0,0,0,152,2,0,0,128,0,0,0,0,0,0,0,208,67,0,0,30,0,0,0,153,2,0,0,129,0,0,0,0,0,0,0,192,67,0,0,30,0,0,0,154,2,0,0,130,0,0,0,0,0,0,0,176,67,0,0,30,0,0,0,155,2,0,0,131,0,0,0,0,0,0,0,160,67,0,0,30,0,0,0,156,2,0,0,132,0,0,0,96,130,13,0,90,150,5,0,109,144,5,0,109,9,0,0,1,0,0,0,0,0,0,0,80,68,0,0,30,0,0,0,157,2,0,0,133,0,0,0,0,0,0,0,64,68,0,0,30,0,0,0,158,2,0,0,134,0,0,0,0,0,0,0,48,68,0,0,30,0,0,0,159,2,0,0,135,0,0,0,0,0,0,0,32,68,0,0,30,0,0,0,160,2,0,0,136,0,0,0,100,130,13,0,222,150,5,0,109,144,5,0,136,9,0,0,1,0,0,0,0,0,0,0,96,68,0,0,30,0,0,0,161,2,0,0,137,0,0,0,104,130,13,0,104,153,5,0,109,144,5,0,159,9,0,0,1,0,0,0,0,0,0,0,32,69,0,0,30,0,0,0,162,2,0,0,138,0,0,0,0,0,0,0,16,69,0,0,30,0,0,0,163,2,0,0,139,0,0,0,0,0,0,0,0,69,0,0,30,0,0,0,164,2,0,0,140,0,0,0,0,0,0,0,240,68,0,0,30,0,0,0,165,2,0,0,141,0,0,0,0,0,0,0,224,68,0,0,30,0,0,0,166,2,0,0,142,0,0,0,0,0,0,0,208,68,0,0,30,0,0,0,167,2,0,0,143,0,0,0,0,0,0,0,192,68,0,0,30,0,0,0,168,2,0,0,144,0,0,0,0,0,0,0,176,68,0,0,30,0,0,0,169,2,0,0,145,0,0,0,0,0,0,0,160,68,0,0,30,0,0,0,170,2,0,0,146,0,0,0,0,0,0,0,144,68,0,0,30,0,0,0,171,2,0,0,147,0,0,0,0,0,0,0,128,68,0,0,30,0,0,0,172,2,0,0,148,0,0,0,0,0,0,0,112,68,0,0,30,0,0,0,173,2,0,0,149,0,0,0,83,154,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,83,154,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,83,154,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,65,156,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,65,156,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,65,156,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,73,157,5,0,47,159,5,0,255,0,0,0,0,0,0,0,215,155,5,0,1,156,5,0,5,156,5,0,73,157,5,0,47,159,5,0,0,1,0,0,0,0,0,0,148,155,5,0,191,155,5,0,195,155,5,0,73,157,5,0,47,159,5,0,1,1,0,0,0,0,0,0,85,155,5,0,118,155,5,0,124,155,5,0,124,142,13,0,114,161,5,0,120,158,5,0,218,4,0,0,1,0,0,0,0,0,0,0,96,69,0,0,30,0,0,0,174,2,0,0,150,0,0,0,0,0,0,0,80,69,0,0,30,0,0,0,175,2,0,0,151,0,0,0,0,0,0,0,64,69,0,0,30,0,0,0,176,2,0,0,152,0,0,0,0,0,0,0,48,69,0,0,30,0,0,0,177,2,0,0,153,0,0,0,108,130,13,0,191,158,5,0,47,159,5,0,143,1,0,0,1,0,0,0,112,130,13,0,158,159,5,0,47,159,5,0,143,1,0,0,1,0,0,0,116,130,13,0,58,160,5,0,47,159,5,0,143,1,0,0,1,0,0,0,120,142,13,0,214,160,5,0,47,159,5,0,143,1,0,0,1,0,0,0,144,142,13,0,74,164,5,0,120,158,5,0,49,5,0,0,1,0,0,0,0,0,0,0,160,69,0,0,30,0,0,0,178,2,0,0,154,0,0,0,0,0,0,0,144,69,0,0,30,0,0,0,179,2,0,0,155,0,0,0,0,0,0,0,128,69,0,0,30,0,0,0,180,2,0,0,156,0,0,0,0,0,0,0,112,69,0,0,30,0,0,0,181,2,0,0,157,0,0,0,128,142,13,0,218,161,5,0,47,159,5,0,143,1,0,0,1,0,0,0,1,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,132,142,13,0,118,162,5,0,47,159,5,0,143,1,0,0,1,0,0,0,136,142,13,0,18,163,5,0,47,159,5,0,143,1,0,0,1,0,0,0,1,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,140,142,13,0,174,163,5,0,47,159,5,0,143,1,0,0,1,0,0,0,0,0,0,0,176,69,0,0,182,2,0,0,183,2,0,0,4,0,0,0,158,0,0,0,14,0,0,0,5,0,0,0,6,0,0,0,159,0,0,0,184,2,0,0,1,0,0,0,19,0,0,0,48,0,0,0,185,2,0,0,148,142,13,0,45,165,5,0,129,165,5,0,230,1,0,0,1,0,0,0,0,0,0,0,184,69,0,0,47,0,0,0,186,2,0,0,187,2,0,0,0,0,0,0,200,69,0,0,188,2,0,0,189,2,0,0,7,0,0,0,160,0,0,0,15,0,0,0,5,0,0,0,8,0,0,0,159,0,0,0,184,2,0,0,2,0,0,0,19,0,0,0,49,0,0,0,190,2,0,0,152,142,13,0,230,165,5,0,129,165,5,0,167,2,0,0,1,0,0,0,156,142,13,0,105,166,5,0,129,165,5,0,123,2,0,0,1,0,0,0,0,0,0,0,216,69,0,0,47,0,0,0,191,2,0,0,192,2,0,0,0,0,0,0,248,69,0,0,47,0,0,0,193,2,0,0,194,2,0,0,0,0,0,0,232,69,0,0,47,0,0,0,195,2,0,0,196,2,0,0,0,0,0,0,8,70,0,0,197,2,0,0,198,2,0,0,9,0,0,0,161,0,0,0,16,0,0,0,5,0,0,0,10,0,0,0,159,0,0,0,184,2,0,0,1,0,0,0,20,0,0,0,50,0,0,0,199,2,0,0,0,0,0,0,24,70,0,0,47,0,0,0,200,2,0,0,201,2,0,0,0,0,0,0,56,70,0,0,47,0,0,0,202,2,0,0,203,2,0,0,0,0,0,0,40,70,0,0,47,0,0,0,204,2,0,0,205,2,0,0,0,0,0,0,72,70,0,0,206,2,0,0,207,2,0,0,29,0,0,0,4,0,0,0,162,0,0,0,17,0,0,0,6,0,0,0,7,0,0,0,21,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,18,0,0,0,163,0,0,0,19,0,0,0,20,0,0,0,164,0,0,0,165,0,0,0,200,142,13,0,184,175,5,0,129,165,5,0,94,5,0,0,1,0,0,0,168,142,13,0,57,171,5,0,129,165,5,0,123,1,0,0,1,0,0,0,160,142,13,0,32,170,5,0,129,165,5,0,108,1,0,0,1,0,0,0,164,142,13,0,211,170,5,0,129,165,5,0,63,0,0,0,1,0,0,0,196,142,13,0,155,174,5,0,129,165,5,0,223,4,0,0,1,0,0,0,0,0,0,0,88,70,0,0,208,2,0,0,209,2,0,0,166,0,0,0,192,142,13,0,44,174,5,0,129,165,5,0,234,3,0,0,1,0,0,0,188,142,13,0,212,173,5,0,129,165,5,0,164,3,0,0,1,0,0,0,172,142,13,0,159,171,5,0,234,166,5,0,17,2,0,0,1,0,0,0,176,142,13,0,25,172,5,0,234,166,5,0,231,1,0,0,1,0,0,0,180,142,13,0,197,172,5,0,234,166,5,0,100,2,0,0,1,0,0,0,184,142,13,0,88,173,5,0,234,166,5,0,61,2,0,0,1,0,0,0,208,142,13,0,218,176,5,0,129,165,5,0,141,5,0,0,1,0,0,0,204,142,13,0,139,176,5,0,129,165,5,0,115,1,0,0,1,0,0,0,212,142,13,0,102,177,5,0,129,165,5,0,128,5,0,0,1,0,0,0,0,0,0,0,104,70,0,0,47,0,0,0,210,2,0,0,211,2,0,0,216,142,13,0,63,179,5,0,129,165,5,0,131,1,0,0,1,0,0,0,0,0,0,0,136,70,0,0,47,0,0,0,212,2,0,0,213,2,0,0,220,142,13,0,46,180,5,0,129,165,5,0,160,6,0,0,1,0,0,0,224,142,13,0,154,180,5,0,129,165,5,0,174,6,0,0,1,0,0,0,228,142,13,0,26,181,5,0,129,165,5,0,191,6,0,0,1,0,0,0,0,0,0,0,152,70,0,0,214,2,0,0,215,2,0,0,51,0,0,0,167,0,0,0,0,0,0,0,160,70,0,0,216,2,0,0,217,2,0,0,168,0,0,0,22,0,0,0,51,0,0,0,11,0,0,0,52,0,0,0,169,0,0,0,76,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,77,0,0,0,1,0,0,0,1,0,0,0,240,142,13,0,100,182,5,0,11,182,5,0,78,14,0,0,1,0,0,0,0,0,0,0,168,70,0,0,218,2,0,0,219,2,0,0,170,0,0,0,236,142,13,0,198,181,5,0,11,182,5,0,178,13,0,0,1,0,0,0,244,142,13,0,26,184,5,0,11,182,5,0,222,13,0,0,1,0,0,0,248,142,13,0,38,185,5,0,11,182,5,0,239,0,0,0,1,0,0,0,252,142,13,0,143,185,5,0,11,182,5,0,60,8,0,0,1,0,0,0,4,143,13,0,192,186,5,0,11,182,5,0,5,8,0,0,1,0,0,0,0,0,0,0,184,70,0,0,220,2,0,0,221,2,0,0,171,0,0,0,0,143,13,0,67,186,5,0,11,182,5,0,198,14,0,0,1,0,0,0,8,143,13,0,89,187,5,0,11,182,5,0,233,6,0,0,1,0,0,0,12,143,13,0,38,188,5,0,11,182,5,0,120,6,0,0,1,0,0,0,16,143,13,0,193,188,5,0,11,182,5,0,53,6,0,0,1,0,0,0,152,11,8,0,60,133,91,61,105,191,22,190,2,153,98,189,108,247,79,61,246,123,236,61,167,217,46,189,62,226,61,61,57,250,95,189,212,151,168,61,35,124,213,61,136,247,187,188,168,158,53,60,147,226,97,60,59,62,229,61,79,209,79,60,24,169,174,61,149,54,129,189,240,173,5,62,38,231,165,61,19,100,85,189,154,195,48,189,193,79,191,61,81,255,225,61,15,146,155,189,76,255,97,189,6,230,54,189,19,114,241,60,66,152,58,61,65,71,105,187,217,33,160,61,168,84,158,61,18,154,161,61,195,227,126,61,40,89,184,61,26,104,18,189,208,217,11,61,93,138,104,61,160,134,67,189,86,118,25,61,50,58,16,189,138,114,142,61,23,168,29,189,94,104,44,60,232,56,142,60,25,146,222,61,48,45,179,61,33,25,88,59,61,96,223,61,226,18,162,61,158,217,212,61,161,93,171,60,17,114,237,61,236,252,6,62,68,84,202,61,23,168,91,61,71,37,138,189,4,202,229,187,53,239,171,59,152,142,4,61,71,172,102,60,194,224,180,60,128,219,207,60,177,72,58,61,179,120,147,61,81,51,0,61,72,128,128,189,73,155,172,60,190,51,119,61,192,222,176,61,41,126,148,59,40,174,179,60,10,56,189,60,116,18,100,61,159,175,216,188,243,55,54,61,22,115,232,60,125,210,183,61,99,190,54,61,182,208,183,61,13,229,153,61,235,252,188,60,210,50,213,61,174,108,130,61,189,113,115,61,27,55,150,59,51,211,85,61,176,184,136,61,249,46,171,61,189,118,137,61,18,84,134,61,23,254,32,189,43,17,22,188,31,148,113,189,77,185,230,60,254,31,78,61,63,222,138,61,58,89,10,61,73,193,31,186,241,14,147,188,138,157,252,188,195,101,85,188,236,125,243,188,194,56,1,60,97,108,16,189,197,25,36,187,177,214,86,61,86,124,241,61,186,143,177,188,134,15,89,61,120,255,135,61,224,151,84,61,44,140,7,188,73,121,248,60,160,75,111,61,138,106,131,187,176,213,204,187,146,37,112,61,119,248,201,188,55,50,99,61,112,131,168,189,36,39,148,189,151,19,62,61,38,88,86,188,162,78,205,188,91,3,254,60,230,26,63,189,56,17,60,189,116,168,241,60,104,54,119,61,163,225,183,60,11,39,139,188,123,102,42,60,181,84,57,60,104,252,93,61,38,131,174,188,138,4,49,189,99,32,22,189,106,144,56,60,4,134,213,188,109,139,182,188,10,201,184,188,45,97,12,189,146,1,254,187,175,193,125,189,2,158,6,60,249,75,195,61,243,245,23,189,179,46,142,189,24,75,21,62,111,40,95,189,111,107,168,188,104,105,107,61,83,226,227,60,227,242,144,189,143,26,84,189,14,150,213,189,104,26,230,189,217,49,154,61,131,208,154,189,209,243,179,189,185,111,244,60,80,135,218,60,161,117,98,60,57,64,147,188,220,169,0,189,94,224,171,188,8,235,184,61,33,245,74,61,218,122,12,62,186,15,233,61,101,244,235,58,184,127,59,189,210,161,145,186,226,244,193,189,219,124,237,189,42,226,55,61,158,41,146,60,0,25,73,59,8,208,220,61,17,135,92,59,89,14,222,189,116,78,152,189,28,194,215,189,189,237,152,188,204,110,36,62,200,60,166,187,61,243,47,189,202,125,193,187,233,129,16,60,28,142,116,188,208,255,77,189,89,217,3,190,106,97,102,58,215,135,84,188,1,128,155,189,113,161,218,188,73,223,53,186,30,40,197,60,193,68,145,188,107,238,29,189,202,193,112,189,97,132,5,61,31,88,3,62,75,223,128,61,220,150,134,187,126,53,225,61,178,101,90,60,243,27,171,60,76,96,37,61,199,110,85,189,253,236,158,61,2,15,131,61,92,153,107,189,249,226,205,189,239,179,153,61,123,74,175,188,138,36,147,60,241,157,25,59,108,95,44,189,172,161,150,61,165,159,80,61,8,127,245,188,80,201,181,188,47,111,9,61,222,253,52,61,239,149,100,189,200,86,78,189,29,75,58,189,3,5,98,60,215,46,176,60,241,191,179,188,98,28,12,190,99,216,95,61,236,187,131,60,30,118,89,61,202,141,64,61,14,59,175,58,76,38,155,61,83,32,197,61,91,64,18,60,75,241,230,188,124,141,222,61,240,223,12,189,115,64,145,189,175,244,117,189,3,49,222,188,170,210,231,187,204,26,134,188,9,5,91,60,0,57,211,189,62,249,72,61,11,205,106,189,225,186,223,188,129,194,42,60,31,209,170,189,196,255,22,61,150,50,122,61,19,184,88,60,108,240,159,189,218,156,26,61,128,206,11,189,179,182,121,189,82,135,44,189,151,121,163,189,154,29,165,186,201,124,249,188,70,150,74,188,33,71,129,189,72,46,68,61,41,128,60,189,237,165,175,61,225,134,206,60,245,200,244,60,31,62,211,61,235,150,144,61,87,41,57,61,213,80,53,189,215,158,6,62,92,193,171,61,190,82,177,60,183,30,11,187,54,254,22,189,187,250,169,188,8,224,28,189,217,197,122,188,68,87,220,60,92,11,243,61,96,138,119,189,42,38,228,188,72,150,67,189,89,213,71,61,77,17,130,61,130,37,15,61,56,107,112,60,98,133,154,58,149,99,51,61,37,124,5,59,6,37,34,189,204,191,47,188,243,237,210,59,41,121,245,60,165,5,12,189,158,150,160,188,6,191,71,188,65,50,143,187,232,217,208,188,80,201,216,60,71,188,133,188,198,217,211,59,117,21,158,188,68,221,156,59,59,66,75,61,108,5,28,61,82,205,148,61,81,218,107,61,10,65,25,189,209,13,135,60,217,125,10,188,194,181,35,61,121,163,167,189,56,45,216,60,30,238,36,189,252,215,224,188,243,196,38,189,122,192,137,58,108,51,66,189,54,229,137,189,176,156,14,60,246,156,179,188,44,104,177,58,100,109,250,188,51,193,243,188,35,145,236,188,252,92,70,188,196,198,69,189,68,173,185,189,146,45,204,189,8,32,22,189,47,208,104,186,104,207,139,189,1,224,152,188,144,150,20,189,225,187,102,188,164,137,153,60,106,13,170,188,14,75,187,61,11,76,17,189,87,13,93,61,130,253,43,61,177,78,85,60,134,159,10,189,127,229,249,189,178,229,139,61,117,49,24,189,46,155,28,60,251,179,165,59,0,206,103,61,179,11,128,59,78,18,230,60,113,5,98,189,43,7,24,189,28,74,232,188,237,15,53,189,255,18,41,188,37,75,154,60,174,47,11,188,255,231,192,189,243,249,79,188,8,196,174,188,56,181,208,189,104,167,160,189,188,172,31,59,151,56,134,187,165,6,69,60,150,36,132,189,30,246,216,189,120,233,201,188,8,51,180,188,110,151,151,189,7,55,149,61,11,168,104,58,251,116,35,60,132,188,10,60,96,203,24,61,232,252,237,188,39,93,18,61,43,247,51,189,111,14,246,189,149,28,2,61,197,227,52,187,231,175,221,61,50,132,80,61,228,98,88,187,43,223,81,189,107,104,165,59,165,0,104,189,167,106,196,187,228,205,90,189,239,28,72,188,205,145,83,60,117,125,34,60,184,12,248,187,157,171,125,189,24,41,19,187,50,210,162,60,37,98,165,188,235,219,142,189,254,50,135,189,252,45,9,189,174,122,182,189,15,24,10,189,115,177,151,189,246,40,184,188,197,79,124,189,250,6,54,59,138,109,106,189,171,76,68,189,216,250,153,61,188,183,53,59,95,133,44,61,61,254,253,60,138,52,88,61,209,251,33,61,34,82,246,188,111,196,29,189,239,192,228,188,27,140,235,188,138,226,122,60,187,39,179,60,189,1,163,188,9,73,36,59,72,25,210,189,39,6,68,189,79,133,236,188,238,90,124,59,143,58,54,60,246,219,7,60,159,140,69,189,163,119,56,189,173,22,24,189,74,29,143,189,182,83,225,189,208,109,48,187,112,252,242,58,179,134,114,189,31,16,122,189,139,56,173,189,89,115,57,189,253,100,105,58,21,164,112,189,22,8,48,187,199,89,130,188,205,194,20,61,5,0,97,61,193,130,149,61,246,80,181,59,145,20,131,61,235,93,151,60,233,213,188,187,124,132,3,189,14,81,139,59,101,31,63,60,93,224,189,186,112,160,184,60,101,234,9,189,14,4,143,61,17,99,138,187,47,184,17,188,66,174,162,189,26,251,84,61,62,110,120,61,206,78,41,61,103,201,188,58,61,78,196,189,56,101,34,189,239,88,45,61,233,101,143,60,16,211,55,189,19,243,248,187,80,193,164,60,123,110,63,61,128,140,184,61,53,41,161,189,98,203,63,189,30,21,80,189,188,222,130,187,88,252,90,189,134,226,49,60,190,109,19,189,123,93,145,189,177,120,17,61,202,147,219,60,159,49,14,61,67,171,146,60,117,26,96,61,59,159,29,60,249,66,2,189,4,53,112,61,133,236,190,60,131,201,133,60,43,15,102,189,142,211,209,189,97,7,170,189,135,83,149,61,54,152,161,188,176,153,214,188,22,153,203,188,210,139,61,189,234,26,195,58,108,220,97,61,187,55,80,188,101,167,159,188,242,135,130,61,213,228,76,61,10,144,246,188,45,143,15,60,136,176,202,188,247,122,97,189,76,28,228,58,8,140,8,189,151,218,121,60,180,223,238,61,156,119,173,186,83,87,135,189,66,242,104,61,66,193,52,186,2,82,52,189,81,138,193,61,13,246,44,189,251,149,91,189,120,199,145,60,51,212,209,60,12,211,226,189,57,209,15,188,138,36,52,188,125,150,212,189,54,60,254,60,151,128,172,188,7,249,150,189,42,207,82,61,46,181,216,61,249,126,176,189,225,235,236,188,37,242,50,60,255,1,21,62,205,2,19,187,127,78,110,189,198,92,151,189,14,134,105,61,159,121,4,62,211,64,76,189,46,137,208,61,56,249,77,61,246,40,0,62,164,231,187,61,143,44,131,61,199,151,121,60,151,192,193,61,171,32,122,61,20,24,18,190,105,193,239,188,237,70,226,60,137,73,177,60,15,67,123,186,12,81,45,189,236,16,202,189,3,10,49,61,189,132,112,61,253,50,70,189,22,107,129,61,41,50,200,60,214,188,19,189,126,205,25,60,209,183,47,61,190,84,40,188,146,13,167,61,92,57,179,61,88,20,7,190,209,179,5,60,12,236,109,188,32,226,241,60,238,27,20,61,2,14,9,187,145,12,184,60,189,21,197,61,162,194,192,61,159,152,239,188,21,14,160,189,234,121,180,188,26,193,4,187,110,92,51,60,202,79,108,188,240,136,232,60,216,89,243,61,9,208,238,59,167,226,211,189,142,218,154,61,130,232,167,188,78,140,145,59,116,214,131,60,123,108,72,189,107,94,179,189,234,119,251,187,98,128,181,61,111,199,121,61,40,120,134,61,250,46,240,59,154,192,17,61,134,177,30,189,61,252,203,188,239,171,138,189,39,142,203,61,131,170,46,188,4,151,98,60,198,71,149,189,93,214,244,59,227,134,217,61,219,209,235,188,36,66,195,60,39,33,6,189,78,16,175,60,231,44,29,61,7,201,200,60,103,255,47,189,141,43,237,188,134,53,90,61,117,153,117,60,129,191,76,61,234,125,4,62,115,88,192,61,249,208,47,61,180,151,9,189,89,117,139,189,79,115,56,60,228,13,49,62,216,133,12,189,112,27,128,189,194,135,148,188,129,42,240,61,136,252,122,189,60,185,177,189,209,124,12,189,35,229,63,61,88,37,167,61,188,242,16,61,86,59,150,60,33,223,231,61,236,154,5,61,106,175,69,189,163,142,143,60,136,41,147,188,96,80,214,189,215,75,88,187,13,124,112,57,66,195,110,60,224,187,174,188,64,59,213,188,132,196,33,188,204,14,47,61,188,77,172,188,236,183,163,189,165,55,214,60,217,252,172,188,52,164,142,189,132,195,9,190,1,136,140,189,64,171,199,187,87,253,168,61,59,223,31,62,27,145,33,59,59,143,17,60,90,27,42,189,100,85,168,60,89,47,88,61,156,243,252,188,234,208,230,60,116,188,14,62,22,125,156,61,109,150,20,189,48,255,246,188,158,138,37,189,122,239,94,188,250,16,127,189,179,80,224,188,228,8,11,62,166,3,28,62,227,228,92,189,48,226,228,189,70,182,176,60,230,214,59,60,222,166,87,189,181,17,135,189,97,54,225,188,59,234,241,61,239,55,50,62,122,95,123,189,234,89,225,189,24,115,93,188,131,6,143,188,126,170,175,189,101,22,55,189,66,27,122,189,139,67,216,61,208,15,85,62,39,231,187,189,236,5,58,58,117,156,18,61,251,195,147,61,79,1,182,60,135,186,149,60,238,143,1,188,108,12,116,60,52,175,20,62,220,153,131,189,54,249,244,60,210,42,236,186,88,160,101,188,131,217,42,189,163,212,114,187,77,44,186,189,245,251,194,61,251,39,181,61,75,59,217,188,106,33,247,188,110,234,209,60,82,249,17,61,98,97,28,189,134,216,106,60,93,228,184,60,185,72,235,60,40,40,36,60,72,175,129,189,124,179,49,61,162,101,143,61,18,191,64,189,39,228,149,189,174,124,215,60,141,121,254,60,118,40,136,61,126,128,223,61,171,152,133,188,149,105,238,60,214,42,237,60,22,170,164,61,66,187,142,61,180,55,139,61,108,112,199,59,1,130,136,59,193,209,182,61,166,227,255,188,42,50,221,60,66,124,63,60,2,169,133,188,207,16,151,59,155,124,11,60,226,43,17,189,18,79,18,61,100,211,140,59,130,99,161,188,52,37,16,188,135,197,196,61,93,1,125,60,13,183,32,189,10,174,149,61,240,68,120,61,106,20,10,57,220,199,2,188,38,140,196,60,113,55,121,189,224,189,224,188,5,71,96,189,240,55,41,189,191,206,17,61,42,75,250,60,47,61,244,60,243,43,24,62,53,188,144,60,132,70,241,60,192,161,72,61,59,64,40,60,190,84,230,60,94,79,169,61,108,209,223,60,155,200,74,188,22,217,240,61,133,187,27,61,73,145,7,189,163,4,172,59,162,144,201,188,210,123,220,60,250,46,93,61,194,136,207,189,20,198,130,61,84,238,148,188,54,25,185,60,9,91,18,61,55,220,42,60,148,31,42,189,59,154,37,189,68,164,134,60,197,135,170,61,200,229,241,57,105,107,89,189,101,210,174,189,139,10,211,186,127,64,177,188,154,23,146,188,58,23,30,61,162,14,174,61,103,84,141,188,135,164,176,61,236,45,225,61,73,245,187,61,208,11,174,61,161,153,156,61,206,147,100,61,32,167,220,60,157,188,204,61,163,194,185,61,84,139,136,61,244,142,112,61,170,36,184,188,89,45,159,61,241,31,254,61,212,82,1,62,134,185,92,186,182,30,114,60,48,184,187,61,128,143,67,187,206,110,132,189,150,136,144,189,199,177,91,57,113,15,181,60,130,217,176,188,232,45,176,189,124,44,187,188,213,175,131,59,62,189,28,60,121,230,169,188,242,218,61,189,11,217,248,187,13,172,97,188,88,192,58,189,38,9,8,190,36,151,177,189,28,175,21,189,102,63,59,60,9,172,6,61,196,239,51,189,152,157,123,61,9,92,53,62,168,176,212,61,12,196,89,60,100,47,206,61,52,254,254,61,178,93,55,189,147,83,185,61,109,250,59,61,255,183,228,61,110,223,175,61,187,71,67,61,8,35,219,58,163,80,193,60,181,2,28,189,86,13,0,61,244,52,157,188,125,109,105,189,254,191,193,188,129,130,133,189,134,89,101,189,86,90,145,189,2,62,7,189,95,75,65,189,38,59,210,188,176,239,88,60,78,11,189,189,219,6,98,189,246,9,65,189,86,123,10,189,108,157,137,189,179,248,65,60,248,2,191,189,96,149,134,60,163,59,27,61,85,200,216,187,132,171,159,61,235,104,148,61,160,197,64,61,79,184,206,188,27,1,139,188,25,64,165,189,114,6,119,61,29,152,215,61,165,104,135,189,121,231,243,60,195,199,214,60,115,200,156,60,76,168,173,189,174,123,129,189,142,246,10,190,37,143,156,189,187,174,24,60,229,201,165,189,98,218,208,189,40,40,85,189,217,135,103,60,158,192,159,189,224,109,154,188,201,202,153,189,138,151,207,189,129,127,85,189,138,167,203,189,240,30,175,186,148,229,129,189,70,39,43,189,242,105,253,189,200,14,232,188,128,29,120,189,183,204,110,61,87,188,155,61,145,90,132,189,22,121,3,60,53,41,237,61,79,144,252,61,91,19,162,60,121,129,50,187,149,165,111,61,124,119,63,189,88,221,82,61,97,15,44,187,253,119,230,61,145,159,202,61,18,102,200,61,218,215,62,189,57,159,52,188,67,104,143,189,51,11,253,60,118,43,210,188,125,28,157,189,62,10,80,59,171,216,220,189,194,149,189,188,53,29,227,189,227,229,39,188,178,67,255,60,247,91,75,189,87,237,186,60,210,57,180,59,61,154,172,189,37,97,22,190,192,25,158,189,1,161,8,190,108,93,57,189,3,11,203,189,79,20,212,60,7,26,14,61,203,9,63,61,199,95,239,61,129,147,197,61,57,94,222,61,249,91,109,188,59,30,48,61,100,130,138,189,212,169,174,58,94,193,18,62,91,31,155,61,80,185,187,61,233,113,104,61,132,242,231,61,185,73,53,188,167,238,168,60,163,53,235,189,96,112,153,189,148,164,234,188,35,0,81,188,54,65,142,189,192,225,206,189,39,125,40,189,94,111,181,188,0,185,80,188,206,50,153,189,14,48,216,189,210,25,156,189,242,143,204,189,190,147,234,189,6,70,247,189,40,198,192,189,180,92,146,189,231,18,38,189,31,247,122,189,172,229,44,61,219,115,157,61,209,231,39,61,56,173,1,62,181,92,22,62,47,215,94,62,101,66,0,62,214,189,60,62,95,27,218,186,103,212,27,59,158,211,108,60,229,190,15,61,8,121,217,60,160,162,140,60,151,30,92,61,206,47,241,60,254,233,231,61,138,96,115,188,10,0,132,188,166,53,243,186,223,246,139,188,0,166,94,189,143,44,89,189,16,119,87,61,231,193,18,189,243,194,179,185,194,91,178,58,153,179,53,189,83,50,45,189,212,102,6,61,187,126,96,189,178,217,208,189,168,149,147,189,21,250,219,189,117,230,193,188,208,128,210,61,2,21,52,187,214,207,4,189,76,38,189,60,124,80,232,60,131,241,211,61,188,128,72,62,38,246,209,61,98,168,164,61,162,83,98,61,89,176,7,190,141,104,19,190,38,131,77,59,3,188,10,189,40,149,18,60,170,111,93,61,155,246,162,187,14,211,66,188,205,84,148,57,202,206,31,189,165,166,72,189,70,81,177,60,72,147,98,188,9,150,151,188,12,35,153,60,123,181,200,188,249,187,187,60,18,221,167,61,252,138,7,61,174,179,217,189,242,169,202,60,8,232,90,61,203,0,197,188,16,220,4,189,75,241,181,187,115,11,164,189,63,82,230,60,249,126,45,61,36,74,152,60,124,202,72,61,169,164,107,188,219,40,122,188,224,117,167,60,155,39,77,189,192,214,45,61,214,227,155,61,113,197,74,61,8,154,118,189,167,153,139,187,183,124,6,62,12,185,107,188,41,119,160,188,2,166,37,189,5,119,254,189,146,90,58,59,87,141,78,189,217,206,186,189,99,161,240,59,153,72,192,61,161,171,241,61,252,194,154,59,39,157,145,59,246,135,163,189,199,4,20,189,168,242,55,61,42,8,184,188,150,188,63,61,132,170,86,61,228,183,176,60,121,142,60,189,201,68,68,188,19,46,225,188,195,122,11,62,18,121,180,61,52,201,159,189,26,103,159,59,5,250,130,188,140,216,39,60,156,221,13,189,101,195,188,188,153,6,178,189,10,76,136,61,139,252,108,61,254,112,1,190,50,7,189,60,30,69,150,61,243,30,154,61,29,127,74,61,228,149,183,188,180,90,204,189,104,91,20,62,116,144,134,189,89,225,160,189,15,218,231,60,23,213,10,186,102,71,63,189,112,33,242,189,174,206,250,189,40,88,29,190,27,59,243,188,10,113,165,61,119,94,10,62,237,162,235,61,143,45,66,61,140,114,97,60,236,188,111,189,98,244,123,188,216,246,98,189,107,17,204,60,191,44,235,188,232,45,226,60,27,21,116,62,114,214,100,62,145,19,211,61,219,179,141,189,17,129,207,189,190,212,78,190,26,118,78,189,48,19,139,62,156,95,189,62,225,216,176,62,108,248,148,62,118,105,103,61,125,253,40,61,114,184,153,61,149,72,224,188,19,48,10,188,144,230,150,61,75,124,135,60,145,146,192,189,55,21,196,189,45,142,113,60,49,254,145,189,117,192,13,189,255,68,234,61,158,211,12,62,41,198,130,189,88,60,129,189,89,70,6,60,55,7,238,61,163,133,165,59,84,180,155,189,139,32,137,61,222,180,131,62,160,24,185,61,42,151,147,62,65,208,6,62,204,154,89,189,74,20,175,188,107,254,12,189,198,29,128,189,249,186,31,61,250,82,60,62,139,52,133,62,204,55,10,61,199,104,152,60,191,90,67,62,198,246,57,62,73,52,97,59,239,197,248,188,231,141,73,62,231,34,181,62,97,173,127,62,237,255,3,189,174,86,148,62,17,161,220,62,207,149,157,62,20,78,191,60,5,74,202,189,137,138,224,187,210,50,183,61,18,237,166,189,211,194,228,60,166,5,126,62,205,139,49,62,43,65,127,61,187,167,213,189,175,135,42,190,128,37,7,190,7,186,174,189,39,87,69,190,197,156,10,190,89,189,99,62,230,205,200,62,41,46,136,62,26,203,73,188,163,125,38,60,138,2,9,62,175,34,246,61,231,198,70,189,208,26,162,189,247,24,144,61,37,25,126,59,53,244,122,189,94,193,25,190,253,154,233,189,222,60,175,189,26,39,152,189,203,5,37,190,223,79,7,62,49,138,131,62,61,97,105,61,46,136,140,61,59,143,197,187,94,46,2,188,38,151,68,61,242,29,137,61,206,216,157,188,219,53,126,61,242,188,9,62,106,177,130,189,53,138,67,187,153,169,14,189,104,17,247,59,113,144,31,61,191,201,234,61,213,205,136,60,59,161,7,60,29,124,245,187,143,223,239,189,238,31,218,189,38,12,212,189,255,142,76,189,207,179,72,186,253,180,247,60,144,240,66,189,27,143,149,189,174,151,110,189,148,184,6,190,235,230,217,189,97,151,70,190,211,66,204,189,226,45,162,189,166,214,242,57,153,96,45,186,247,87,34,62,87,85,175,61,243,224,156,189,19,39,164,189,253,122,124,189,128,56,154,60,83,87,63,186,250,25,140,61,201,112,29,61,129,157,79,62,55,147,97,62,146,100,172,187,138,247,109,60,241,171,129,189,191,180,234,60,122,101,104,61,13,70,249,61,235,43,29,61,198,161,17,61,91,37,218,188,116,137,210,189,135,168,133,189,141,163,226,189,58,21,184,189,95,236,206,189,243,203,4,60,62,12,195,59,151,113,214,60,1,188,139,188,173,48,223,189,53,241,163,189,181,217,230,189,54,93,125,189,15,2,122,189,97,212,130,60,131,161,114,189,79,187,192,61,93,18,106,62,5,171,5,61,249,181,138,61,91,100,184,189,144,196,38,60,111,62,158,60,113,181,176,61,237,74,106,188,118,91,224,61,140,28,42,62,23,112,199,188,148,148,7,189,65,136,45,189,104,163,70,60,213,137,201,187,1,108,142,61,17,3,247,60,45,120,146,60,201,223,227,60,234,200,99,189,53,215,18,188,215,161,75,189,133,207,153,61,93,110,145,60,12,64,113,61,170,117,163,189,79,104,21,61,211,254,116,187,48,41,182,189,194,172,131,189,1,61,165,189,23,34,18,61,226,15,146,189,52,142,236,187,228,236,195,189,80,39,55,62,49,178,24,62,184,147,169,60,81,128,77,189,112,127,76,189,73,160,128,60,180,228,202,189,12,57,132,61,98,249,28,62,131,185,64,62,138,104,239,61,107,22,65,188,13,73,182,188,106,21,156,188,203,90,210,61,158,59,238,187,45,226,238,61,49,133,23,62,26,43,159,61,236,155,196,60,132,158,91,189,118,158,161,188,12,121,97,60,57,9,138,61,221,163,133,189,84,139,106,61,27,4,197,188,213,140,15,190,162,251,169,188,222,80,61,189,209,11,64,189,199,230,150,188,85,41,158,61,43,198,70,189,19,131,122,60,194,27,73,190,158,136,221,61,122,122,27,61,167,59,193,189,35,133,163,189,241,149,10,189,25,242,226,61,247,72,183,60,211,20,2,62,134,83,93,62,118,27,239,60,136,218,152,59,190,106,210,189,65,211,70,189,117,244,98,187,206,50,177,61,88,114,184,60,170,88,197,61,81,238,47,62,5,230,189,189,85,189,240,57,137,22,240,189,38,16,250,189,240,52,31,190,21,212,147,61,241,255,88,189,139,211,26,61,215,250,82,61,28,190,27,189,168,138,30,61,203,42,28,190,179,26,178,189,48,155,165,188,18,182,40,61,38,108,27,190,168,61,129,60,219,231,209,61,19,198,245,59,228,12,141,60,138,219,139,189,60,105,196,188,165,37,135,189,62,217,48,189,185,43,165,189,49,113,218,59,29,138,8,61,0,71,145,61,123,146,168,61,40,183,134,189,60,49,137,189,96,8,143,189,201,72,133,189,129,216,16,190,220,13,196,188,170,209,132,61,193,182,16,60,77,118,189,61,123,199,154,189,173,146,79,189,169,173,200,189,97,72,137,189,187,239,15,190,183,244,4,61,239,141,0,62,223,79,144,60,38,235,4,62,89,50,39,189,127,218,243,189,110,175,23,190,227,142,171,189,181,222,249,189,104,80,76,61,90,45,94,61,124,27,128,187,214,90,5,61,12,59,2,190,182,207,152,189,102,162,105,189,134,58,142,188,160,97,164,189,130,146,94,189,146,217,140,188,147,113,236,60,58,55,145,60,58,171,187,189,34,123,106,59,86,118,207,189,119,101,217,188,8,136,166,189,15,157,29,189,135,203,71,186,184,216,132,61,150,122,73,62,23,125,73,189,43,146,144,189,145,249,70,189,182,200,42,188,33,146,170,189,12,237,21,61,61,108,23,189,117,138,75,61,108,199,168,61,243,38,0,190,233,200,122,189,184,155,25,189,189,248,213,59,232,220,209,189,31,102,210,60,44,10,148,59,59,244,24,189,167,88,57,188,182,173,93,189,247,34,105,58,235,185,253,189,33,23,116,189,70,85,254,189,167,248,123,189,209,182,149,189,138,3,200,60,132,215,143,61,198,150,154,189,87,123,70,186,143,147,185,189,92,39,166,189,85,186,141,189,50,94,28,60,102,222,71,188,138,244,158,58,238,166,17,188,171,44,170,189,28,122,58,189,234,243,219,189,209,26,105,189,127,159,14,190,104,227,184,61,75,220,26,62,134,22,2,61,39,230,53,62,53,248,172,57,118,5,83,61,76,155,201,189,203,13,194,189,5,138,175,189,82,80,38,62,54,0,70,62,64,124,12,60,165,0,235,61,34,196,116,188,62,80,9,61,236,160,183,189,95,62,190,188,18,51,218,60,73,46,95,61,232,222,16,189,152,171,147,189,189,105,139,189,35,185,255,188,206,253,114,189,251,249,48,190,108,139,34,190,100,3,75,189,65,89,131,60,7,170,253,189,226,29,14,62,65,213,91,62,218,87,10,62,106,246,86,62,224,41,181,61,94,248,165,61,99,197,25,61,45,78,249,61,75,100,227,61,157,248,217,61,191,194,14,62,35,101,238,61,213,106,23,62,155,152,71,60,130,45,62,60,217,82,17,61,132,27,180,61,200,226,138,188,154,137,157,189,48,173,168,189,238,142,222,59,115,100,201,188,188,90,5,62,63,82,224,61,31,227,201,61,211,251,65,61,188,81,50,189,30,96,27,190,108,87,55,190,1,6,214,189,235,102,9,190,137,216,135,189,219,219,1,189,14,16,140,189,89,115,232,189,209,7,143,189,93,106,67,62,42,68,52,62,199,82,158,61,142,67,205,61,13,131,186,62,202,218,144,62,120,238,1,62,23,63,35,62,170,5,16,62,249,105,229,189,46,11,15,190,178,31,186,189,199,116,16,190,142,155,81,61,122,150,44,187,216,18,221,189,247,248,198,189,0,121,88,189,112,66,128,60,245,19,78,61,218,202,143,61,51,187,242,188,214,191,144,60,76,172,170,61,200,137,3,189,76,152,160,59,56,114,84,61,99,172,78,189,128,29,197,189,255,237,206,188,68,167,141,61,84,227,70,60,252,121,90,61,104,9,13,189,236,239,205,189,144,215,128,189,180,225,177,59,115,142,206,187,189,250,185,60,58,251,144,188,27,23,6,61,194,163,158,61,209,163,254,59,88,126,78,61,58,3,135,60,25,46,190,188,198,94,203,189,150,233,187,188,213,180,166,60,205,122,170,189,63,73,174,61,159,229,24,189,88,105,132,189,65,82,121,189,159,22,12,62,160,228,234,189,199,152,31,189,229,72,146,189,175,92,47,59,79,20,21,189,113,181,201,189,213,146,225,189,192,22,51,62,241,85,52,62,20,199,36,190,21,117,148,189,84,97,128,60,215,32,115,62,137,171,154,61,176,106,128,189,189,146,149,189,149,67,130,62,129,22,45,62,187,75,167,189,178,59,114,189,180,245,33,189,151,103,223,59,227,0,102,189,242,144,149,189,79,95,249,189,163,165,253,61,25,37,98,62,186,12,99,189,99,152,7,189,28,196,106,61,155,126,71,62,82,131,36,61,214,185,132,189,181,255,252,189,152,212,63,62,77,63,197,189,182,54,229,189,195,11,254,61,140,122,32,62,201,46,69,62,106,36,223,61,55,234,10,61,158,114,5,190,101,122,102,189,45,216,184,189,9,125,112,62,46,102,142,62,163,213,136,62,60,154,148,61,131,160,41,62,8,66,101,62,158,100,152,61,116,18,87,190,9,98,165,189,81,237,25,190,30,217,143,61,206,168,222,61,57,236,57,62,117,46,77,62,25,250,10,62,126,8,244,189,167,251,227,189,147,79,65,190,2,209,120,61,83,186,82,62,113,56,254,61,53,251,32,61,150,97,149,62,212,13,151,62,183,159,142,62,65,192,147,188,128,117,42,62,190,78,69,62,49,180,155,60,51,214,118,61,40,148,26,59,154,75,127,60,186,198,221,60,199,31,233,61,199,227,247,61,137,11,32,61,44,242,61,61,255,191,184,61,177,29,244,61,129,230,109,187,6,224,181,60,196,178,211,61,235,174,49,62,76,20,251,61,185,99,66,62,63,37,33,62,86,44,62,60,8,129,138,188,147,43,126,186,40,189,147,61,149,81,62,60,168,239,54,62,247,188,122,62,199,117,58,62,24,158,78,62,127,162,116,61,86,118,18,188,17,206,189,188,181,212,19,62,79,136,16,62,91,35,98,61,28,31,130,61,213,214,67,190,205,96,208,61,185,154,150,62,23,106,135,62,129,98,191,61,47,130,28,62,250,185,74,62,117,218,232,61,239,71,2,190,75,25,91,190,190,131,164,188,101,124,134,189,208,41,136,188,120,66,33,189,143,184,67,61,238,129,77,61,211,86,188,188,92,239,78,190,237,252,130,189,208,130,12,62,52,219,102,62,239,116,24,62,151,233,177,61,232,176,138,62,218,229,164,62,231,86,200,61,146,173,61,190,33,117,48,190,250,164,42,188,201,49,36,61,17,5,44,61,72,129,165,189,113,210,25,189,203,0,69,189,125,229,85,189,94,77,94,190,72,163,135,189,5,71,241,60,15,111,60,189,246,73,87,189,231,180,172,189,252,80,233,60,55,249,14,61,233,194,7,60,91,84,226,189,209,151,229,189,40,179,163,188,75,238,91,189,164,164,181,189,199,129,64,190,221,174,94,189,203,70,77,189,215,253,93,189,229,250,123,189,226,192,221,189,210,10,50,61,175,127,36,61,208,43,121,60,60,79,249,189,127,229,71,189,81,116,52,188,154,39,5,61,182,38,118,189,197,141,252,188,115,4,188,188,143,109,140,189,148,183,179,189,241,164,115,190,4,229,187,189,132,217,98,189,75,253,48,189,240,49,243,189,62,237,44,189,120,165,120,189,128,180,67,60,147,177,213,60,12,108,31,189,96,155,134,188,156,40,213,188,119,227,85,188,58,145,32,61,125,105,133,189,94,162,56,60,50,176,205,187,133,211,222,188,79,4,228,189,120,46,7,61,155,123,196,60,99,26,39,61,34,92,216,189,182,95,116,61,52,211,67,60,219,58,2,189,47,168,138,188,92,11,125,189,166,220,150,60],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+81920);allocate([202,147,180,187,178,181,139,189,95,189,2,189,201,125,195,189,61,67,248,60,224,139,72,189,24,196,238,188,125,5,8,190,201,237,67,189,14,45,199,59,8,126,109,188,192,201,8,190,214,103,198,189,132,129,230,188,204,209,70,60,54,49,136,61,86,10,167,188,121,196,8,62,28,52,117,61,245,139,21,188,16,79,64,190,231,156,245,189,150,227,129,189,101,114,73,60,26,75,146,61,5,103,219,61,86,9,227,61,122,137,134,61,46,48,242,188,222,202,38,190,64,75,15,190,2,196,83,188,14,0,29,61,130,253,186,61,69,85,80,189,247,21,102,61,132,155,31,189,103,169,128,189,190,80,235,189,130,16,18,190,186,145,57,189,116,236,130,60,169,193,187,61,156,108,177,61,216,25,72,61,11,41,107,189,107,242,154,189,54,122,47,190,67,149,214,188,153,246,202,188,3,131,219,60,128,4,238,61,123,252,179,61,109,238,30,62,51,231,64,61,237,128,56,61,42,47,209,189,173,196,251,189,23,115,69,189,167,168,96,189,121,52,96,61,136,116,150,61,253,113,100,61,220,35,168,189,237,215,13,61,61,167,86,190,192,247,190,189,118,178,120,59,162,45,20,61,56,113,43,62,207,140,144,61,97,255,208,61,47,43,139,189,20,142,83,59,30,234,0,190,59,43,51,190,103,65,170,60,107,148,157,189,155,138,249,61,13,67,184,61,118,87,68,61,177,33,233,189,24,202,164,189,146,171,131,190,132,127,165,189,57,14,223,59,109,12,240,188,40,216,71,187,237,116,227,189,29,153,61,189,248,47,160,189,250,90,252,59,126,223,209,189,50,167,158,58,35,173,82,62,103,192,4,189,210,28,10,60,79,116,159,60,161,70,68,188,136,76,21,190,169,104,45,61,243,176,135,187,230,159,140,189,216,55,199,188,211,137,10,190,58,2,165,58,124,252,233,189,13,71,48,189,217,214,138,188,192,76,106,61,113,64,36,190,216,39,227,60,83,54,97,61,77,181,25,190,187,181,109,60,109,137,192,60,76,43,48,189,104,211,74,189,26,59,94,62,36,102,1,189,115,213,160,188,202,179,58,62,54,176,5,189,100,14,61,187,151,13,130,60,146,173,254,186,98,135,159,189,20,116,63,61,38,253,204,187,191,205,182,61,145,169,90,62,248,144,77,60,9,92,143,189,123,242,114,189,52,93,154,188,137,98,48,189,61,139,241,61,236,101,29,61,46,8,32,189,240,218,102,61,3,2,200,189,20,92,172,188,43,252,14,60,121,52,224,188,20,102,81,189,33,12,46,62,78,35,242,60,168,138,171,60,48,83,172,61,0,162,8,189,201,43,20,189,229,231,109,189,92,179,181,189,109,214,239,60,119,163,138,62,32,214,120,61,160,39,153,61,6,127,28,62,28,23,32,189,16,248,80,189,177,249,27,188,197,9,6,189,213,231,178,189,54,85,156,61,187,39,147,189,26,188,13,62,196,0,160,61,97,28,4,190,7,208,96,189,177,51,103,189,134,201,6,189,87,16,229,189,16,170,25,61,122,221,116,189,3,128,187,189,63,185,103,61,82,72,49,189,202,175,249,188,46,135,103,188,249,129,208,189,182,193,98,188,59,40,78,62,32,205,123,188,187,125,156,189,14,241,113,61,61,108,160,189,217,168,121,188,71,167,153,189,135,199,193,189,74,188,25,190,219,91,36,62,5,194,184,61,41,136,173,61,149,179,10,61,103,86,187,189,115,208,187,189,155,12,174,189,145,174,81,189,177,160,213,189,160,168,42,60,226,19,251,188,156,73,191,61,212,16,132,61,205,247,30,189,22,52,76,189,161,125,23,190,32,255,84,189,82,173,175,188,166,223,35,61,201,96,254,61,240,175,151,188,16,159,40,189,88,197,244,189,94,216,71,189,25,163,178,189,39,39,173,189,2,12,216,189,195,112,230,61,168,126,220,61,217,160,68,62,80,10,123,61,8,5,224,188,113,240,180,189,6,20,46,190,32,87,17,189,175,170,175,187,45,241,169,61,8,255,147,61,211,206,43,61,150,58,63,61,31,46,15,60,8,244,142,61,140,134,103,61,115,210,112,61,13,236,202,60,17,210,200,60,65,164,254,61,163,98,101,61,105,8,141,61,74,59,30,61,239,194,152,61,112,122,185,60,132,4,117,60,252,237,129,61,228,60,142,61,97,46,240,60,65,3,240,61,131,113,57,61,195,11,5,61,40,126,8,59,234,126,167,60,234,138,233,61,148,73,48,61,150,252,131,61,35,31,75,61,203,103,167,61,130,61,189,61,3,124,72,61,131,143,184,60,17,96,135,188,204,97,155,61,66,100,120,61,156,228,14,62,128,38,227,60,244,67,145,61,248,26,174,61,222,94,139,60,16,118,185,61,37,30,171,62,37,122,78,62,123,34,201,61,19,216,162,61,121,19,178,61,160,163,2,190,212,252,13,190,203,95,135,189,177,251,224,189,14,139,11,61,135,230,54,188,112,33,149,189,218,128,10,190,168,135,3,190,139,108,183,61,167,213,187,61,207,176,206,61,88,119,111,62,25,150,176,62,173,201,202,61,82,20,164,60,30,164,252,61,87,198,155,61,179,145,24,190,57,25,32,190,129,2,133,189,89,57,144,188,110,112,11,61,50,66,7,190,250,212,247,189,33,86,59,190,232,148,41,190,110,231,178,60,123,126,225,188,191,146,148,60,234,230,163,60,160,65,88,60,152,117,164,61,243,248,71,60,66,115,67,59,125,38,86,188,26,139,116,61,93,241,90,189,167,134,10,189,150,204,33,188,95,175,140,189,82,17,34,61,45,159,254,188,220,208,106,189,61,246,177,60,76,98,42,61,212,55,44,59,93,38,69,61,6,172,191,61,185,21,6,188,240,70,141,60,103,176,208,188,202,117,75,189,209,209,195,188,94,255,135,61,146,40,129,189,247,94,58,60,224,240,100,61,187,181,168,189,26,29,201,60,187,160,250,188,162,96,183,189,148,81,140,61,182,65,147,61,130,222,155,189,39,251,0,60,34,192,0,188,117,11,118,61,102,154,56,188,187,67,59,187,110,127,67,189,36,106,154,60,244,168,25,62,173,98,128,189,221,241,162,188,234,131,58,60,254,105,179,61,86,226,30,61,218,107,30,188,254,26,164,189,190,94,131,61,68,78,95,188,115,24,187,189,90,200,143,60,249,168,54,61,154,166,197,61,31,207,85,61,16,208,15,187,18,35,144,189,152,254,130,188,143,45,6,62,172,49,204,188,222,43,41,188,195,214,237,188,65,224,55,61,152,221,82,61,182,56,152,60,166,36,239,188,55,248,169,61,103,5,60,189,59,60,33,190,121,183,185,189,220,128,243,188,114,247,4,62,208,143,100,62,39,113,120,62,244,51,21,61,5,139,97,189,119,64,47,59,189,10,29,189,142,21,132,61,124,19,29,61,13,88,28,61,121,51,128,62,96,42,175,62,189,15,166,62,125,195,64,62,237,31,176,189,203,55,52,190,163,216,28,190,123,5,203,189,44,248,233,188,205,71,89,189,157,130,139,186,59,6,136,189,89,202,153,189,207,193,111,60,205,169,154,189,176,190,56,189,239,97,10,188,57,45,145,60,137,162,38,61,238,210,79,62,150,247,32,62,190,247,105,61,0,164,134,62,108,24,22,62,46,131,125,60,50,246,78,189,210,250,30,189,47,149,107,188,167,240,73,189,74,4,240,61,142,196,118,62,236,132,135,62,246,75,162,62,1,236,206,61,77,161,51,188,174,248,95,188,184,37,47,62,4,120,77,62,154,99,47,59,165,249,66,188,145,104,59,62,112,188,193,61,60,52,130,189,93,149,132,189,145,193,97,60,163,120,205,189,102,215,130,189,93,75,121,59,114,51,126,61,50,243,211,61,251,60,137,62,255,1,6,60,117,151,189,188,130,24,25,60,2,98,188,61,128,201,22,61,75,190,15,188,230,226,197,189,134,120,222,188,169,70,10,62,130,142,183,61,39,79,215,187,1,31,3,189,181,249,145,62,127,84,164,62,235,145,61,62,87,185,17,190,111,219,15,190,176,18,147,189,214,159,175,189,38,100,177,189,53,87,50,190,1,190,69,58,215,113,101,61,74,29,11,62,244,45,75,189,45,222,157,189,188,166,218,61,120,136,52,189,85,164,147,189,74,16,22,61,115,56,148,62,36,146,210,62,149,114,140,62,151,81,141,189,77,229,91,190,115,134,31,190,135,63,72,190,28,191,27,190,244,202,230,189,55,225,151,61,162,120,66,62,139,131,137,62,215,237,159,60,190,198,38,60,49,239,176,60,124,65,162,187,144,235,50,189,25,69,2,190,193,174,136,189,200,234,230,189,243,197,52,61,215,124,100,61,155,156,31,61,152,20,18,61,116,130,112,189,223,78,151,189,165,247,55,190,227,132,175,189,220,101,28,190,149,172,118,189,92,91,143,189,64,81,223,187,15,232,128,61,177,173,43,186,46,235,56,188,150,145,187,188,126,160,70,61,122,155,41,61,200,128,114,62,196,242,20,62,151,4,163,60,206,109,246,61,133,237,125,59,142,117,197,187,87,121,114,189,89,68,251,188,97,126,159,189,44,229,221,61,254,110,176,60,221,143,226,60,151,214,34,61,132,129,249,189,105,181,72,189,192,146,203,189,130,43,132,189,183,223,12,190,133,109,24,189,95,158,231,60,39,58,50,189,124,57,156,60,104,158,210,189,108,74,104,189,200,96,220,189,134,25,197,189,70,231,195,189,54,151,85,188,150,91,252,60,199,20,104,60,62,117,111,61,193,235,177,187,231,212,126,61,34,0,8,189,148,24,139,189,159,54,109,189,24,153,3,62,75,128,25,62,44,221,20,61,76,13,18,62,113,95,49,61,80,34,78,61,230,174,102,189,34,147,131,60,94,179,51,61,16,208,100,62,242,255,32,62,66,64,64,189,136,76,246,60,171,186,37,187,154,49,106,61,112,53,154,189,56,91,233,188,18,172,140,189,205,5,148,187,175,108,132,61,243,28,115,189,0,182,64,189,90,208,150,189,35,97,70,61,84,111,9,190,86,124,200,189,38,7,210,189,119,195,15,61,138,159,66,61,246,143,28,189,26,124,199,61,203,22,67,61,109,99,33,61,34,164,169,189,13,165,195,61,2,99,78,61,52,176,89,62,5,146,197,61,95,194,4,61,70,171,83,61,70,3,61,61,73,92,49,61,140,224,218,188,244,51,128,189,77,146,188,188,138,207,64,62,180,129,215,61,19,171,48,61,82,226,136,60,36,123,172,189,179,33,114,61,80,187,216,189,113,225,70,189,88,127,171,189,48,64,159,61,19,132,24,61,199,186,246,189,159,93,159,59,212,119,215,189,16,151,134,61,30,45,154,189,30,241,4,189,84,30,202,189,237,255,238,188,182,82,59,190,1,170,23,62,201,100,23,60,149,96,50,189,6,180,185,60,75,39,243,189,253,132,36,189,52,218,231,60,195,204,102,62,154,151,82,62,194,6,43,62,97,186,184,61,77,25,85,60,168,229,199,61,226,143,22,189,73,141,158,188,203,52,141,189,50,108,165,61,250,11,67,62,165,172,231,61,251,46,40,61,14,29,229,189,12,167,48,61,253,239,61,190,76,41,231,189,199,28,180,189,182,64,170,60,51,160,28,190,119,203,241,61,81,192,52,188,83,139,35,190,247,106,176,60,10,79,86,189,68,232,221,189,49,113,14,190,150,131,114,61,150,79,207,189,150,149,78,62,153,124,186,61,186,30,154,188,190,196,195,61,69,155,24,189,39,100,193,189,38,243,199,189,102,204,111,61,179,184,169,61,156,76,4,62,40,3,176,61,151,182,35,187,239,122,196,60,28,27,186,59,244,242,128,189,20,13,5,190,138,239,29,61,6,113,84,61,86,0,222,61,185,118,10,189,226,149,1,190,44,40,93,189,28,183,152,189,254,254,65,189,216,41,208,189,91,133,153,61,134,103,166,61,107,204,156,61,163,200,76,189,237,78,3,190,78,138,157,189,108,200,231,189,4,192,186,189,107,75,105,189,192,146,214,61,224,244,152,61,150,136,133,60,196,58,3,188,79,205,134,189,68,159,36,189,215,207,63,189,89,74,156,188,186,59,225,189,211,43,73,61,39,28,240,60,113,240,43,61,146,128,108,189,3,14,198,189,203,63,19,189,211,89,11,189,235,106,146,189,82,101,216,189,69,29,217,61,121,219,129,61,11,208,120,188,218,109,195,187,192,56,156,189,133,50,103,187,127,220,219,188,193,60,210,189,196,156,219,188,22,78,39,62,109,61,254,60,20,43,188,60,12,17,133,60,226,212,221,189,252,148,189,188,119,50,68,189,152,137,98,189,229,83,132,189,112,237,214,61,224,43,62,61,244,128,155,189,191,221,125,189,238,46,185,189,140,213,108,188,227,9,48,189,101,165,230,189,206,24,234,189,122,7,2,61,63,161,22,189,128,207,242,188,83,96,135,189,79,28,8,190,215,145,144,189,118,239,172,189,14,80,216,188,129,38,146,189,184,198,58,61,0,52,111,60,190,53,56,62,201,171,53,61,21,71,255,189,165,51,235,188,139,52,220,189,247,1,11,189,203,75,27,189,178,192,208,60,87,61,160,60,82,19,69,62,213,251,14,62,58,219,113,189,108,14,152,189,66,60,213,189,237,20,202,58,209,62,147,60,120,98,5,62,124,69,58,61,89,229,105,189,238,19,219,189,192,33,10,190,82,113,133,189,137,54,131,189,149,225,133,187,41,248,90,188,135,241,50,61,92,153,230,189,250,137,105,189,72,129,132,189,60,240,170,189,192,171,42,189,172,98,109,189,182,232,168,189,210,55,107,189,39,26,173,61,165,57,9,189,252,41,15,62,11,180,7,62,116,111,155,61,65,107,154,61,99,243,248,61,47,116,67,62,164,30,26,62,62,154,89,62,70,122,17,62,147,190,84,60,190,148,152,61,143,84,134,61,68,79,139,60,238,217,56,61,62,147,45,62,56,40,210,61,91,213,39,62,186,124,97,61,35,112,13,189,137,150,176,61,65,135,162,61,28,222,34,61,236,203,166,60,125,173,129,59,169,209,5,61,12,4,28,62,216,148,84,60,136,19,166,189,67,157,102,60,11,104,144,59,67,54,27,190,233,70,233,189,147,88,153,189,10,3,0,188,35,62,225,188,230,131,208,189,201,219,12,62,16,111,15,62,186,15,10,62,100,227,140,62,157,93,175,62,206,117,156,61,111,220,148,61,30,255,74,62,2,59,37,62,63,122,43,189,197,232,2,190,231,166,201,189,206,205,1,61,204,191,224,61,182,33,26,190,83,157,182,189,179,51,146,189,5,31,42,189,231,239,204,59,82,135,79,60,143,184,215,61,30,141,2,62,182,29,27,62,49,132,117,60,85,37,129,61,33,84,76,188,26,200,179,189,123,36,175,189,101,215,244,189,199,242,173,189,98,179,237,188,213,47,196,188,229,126,9,190,154,94,226,189,127,151,19,190,128,174,27,190,104,185,34,61,21,26,195,185,212,17,44,189,168,16,122,61,57,14,156,60,3,61,53,188,147,94,238,187,185,23,121,188,141,122,144,58,253,183,74,189,183,27,164,189,204,116,187,59,55,89,172,61,26,152,133,189,173,20,22,61,193,249,218,188,102,29,247,189,15,163,23,189,142,7,118,61,240,107,133,60,134,110,202,187,115,199,167,61,249,227,95,187,0,39,235,60,73,220,109,61,57,41,75,61,223,41,61,61,78,197,72,189,112,171,216,189,130,82,186,60,154,54,247,61,111,137,18,59,196,90,201,61,205,98,247,188,186,1,229,189,164,52,75,189,82,182,204,60,129,42,24,189,150,174,132,188,235,141,216,60,22,2,250,187,1,30,236,188,88,178,127,189,46,217,172,189,71,226,147,61,7,196,148,61,41,217,127,60,69,75,253,60,74,250,139,60,4,136,27,189,176,197,80,187,48,10,133,60,122,183,231,188,252,26,231,61,11,98,173,186,22,111,159,189,114,164,147,189,133,32,10,61,189,236,248,61,78,159,186,60,160,21,88,189,135,41,157,188,167,2,5,62,248,46,94,61,92,32,191,60,92,7,37,61,149,206,253,61,182,119,194,61,218,55,188,61,234,134,162,61,93,168,15,60,159,153,47,62,57,122,11,188,4,18,164,189,25,48,139,189,80,21,72,61,18,60,54,60,146,119,160,189,84,124,150,186,252,238,12,189,18,21,233,60,206,154,157,61,183,200,144,189,83,181,60,188,129,230,11,188,38,55,136,188,71,141,42,189,102,52,93,61,254,56,234,60,173,91,239,60,172,237,76,61,51,178,224,187,86,190,133,188,190,86,159,61,239,151,37,61,49,77,71,188,108,135,108,59,197,123,129,189,13,231,194,61,93,220,3,62,159,201,30,188,200,242,40,60,159,53,84,61,115,34,25,188,91,184,134,188,23,161,70,189,33,230,49,189,191,87,215,61,139,203,164,61,239,9,61,189,254,213,34,189,111,99,115,188,142,28,6,62,112,179,120,188,172,151,134,189,182,130,36,189,211,136,151,60,151,219,199,60,170,55,165,61,113,37,229,58,243,117,144,61,173,159,180,61,180,147,166,187,99,41,134,189,138,74,169,189,199,88,159,189,29,34,110,60,83,87,179,189,150,166,51,60,198,193,14,188,243,15,207,61,53,79,198,60,63,99,137,189,217,122,164,60,155,91,194,59,208,35,93,61,142,97,154,61,104,223,167,60,128,182,183,60,30,75,36,61,66,228,189,186,238,85,137,187,217,104,130,61,55,94,205,60,236,111,199,60,8,210,112,61,37,213,6,188,193,143,75,188,143,13,45,61,103,195,143,188,217,11,116,61,236,107,28,61,127,241,149,188,69,126,48,189,25,34,53,189,219,73,199,188,175,137,185,60,209,135,5,59,30,31,68,60,107,212,53,61,231,57,249,61,47,145,19,61,63,238,212,188,227,232,1,187,199,162,167,60,15,49,216,188,90,170,250,186,141,44,191,189,233,65,19,189,68,231,33,188,147,65,140,189,188,33,63,189,187,228,203,189,158,75,44,189,69,188,213,60,114,238,20,60,145,50,146,189,236,105,221,185,59,185,144,60,251,205,225,60,19,89,86,60,164,1,38,61,210,149,195,60,160,157,90,61,8,218,204,60,44,155,75,189,81,85,255,189,227,68,52,62,228,2,251,61,217,217,153,189,93,157,14,60,31,95,105,189,86,138,20,189,63,160,15,188,180,100,70,188,50,145,193,189,2,105,153,61,213,126,164,188,122,166,219,188,219,94,132,189,219,160,120,188,16,112,240,59,66,243,198,59,185,207,190,189,203,103,59,189,123,204,7,62,95,243,29,62,30,167,135,188,59,29,227,188,152,199,86,189,119,10,193,188,214,167,192,188,70,34,209,189,228,209,3,190,101,253,20,62,13,52,0,62,21,198,143,59,52,12,229,60,193,198,83,61,53,230,188,61,73,65,113,61,8,179,194,60,43,133,227,188,148,179,194,61,84,201,190,60,107,12,190,188,121,214,3,189,76,82,122,188,61,147,38,188,236,28,219,188,58,107,82,61,148,65,162,60,192,7,134,61,220,11,143,188,127,41,40,60,228,226,127,60,18,238,80,58,97,175,155,61,238,61,156,60,238,143,252,188,91,62,117,189,205,74,189,61,32,11,21,62,188,181,41,60,89,84,253,60,35,216,195,189,146,190,27,189,240,89,207,60,186,68,252,60,50,108,145,189,36,109,8,61,81,94,48,187,138,189,1,61,174,80,107,61,122,134,5,61,137,178,250,58,148,217,2,61,181,87,151,61,169,16,180,60,141,84,156,61,181,226,6,61,86,113,186,189,78,65,65,61,39,247,121,61,131,87,36,188,189,217,191,59,98,117,121,188,223,87,190,60,115,196,216,61,56,212,142,59,177,45,122,61,195,96,112,61,108,57,255,188,84,3,71,60,7,116,175,61,246,20,129,59,112,143,206,188,0,249,246,186,18,245,166,60,132,83,36,186,92,153,72,61,48,85,47,189,26,106,69,189,145,34,69,189,39,195,109,188,200,244,80,61,241,163,19,188,12,142,8,189,188,122,32,61,242,226,43,61,76,206,47,61,24,40,230,60,149,188,245,60,9,44,39,61,206,25,21,60,226,184,198,61,189,147,212,61,85,104,192,60,179,233,154,187,34,81,40,60,227,11,213,61,31,59,247,61,236,14,201,61,77,250,213,188,137,7,21,61,74,132,113,61,124,69,71,61,202,91,68,61,22,5,31,189,25,168,242,188,163,65,72,188,202,197,38,61,142,131,157,60,7,108,187,188,155,84,8,61,252,75,152,60,246,212,184,61,154,212,27,61,72,100,105,188,224,12,160,60,124,150,205,60,79,228,10,189,186,254,103,189,204,130,134,188,236,142,111,61,119,10,62,61,218,98,171,60,124,55,4,62,53,246,75,62,34,131,158,61,6,213,237,187,198,231,38,61,150,106,2,61,253,132,182,58,224,16,106,188,243,209,152,60,92,175,174,61,252,185,10,62,13,42,229,61,132,203,35,61,126,29,196,61,53,138,215,188,105,166,13,189,52,143,66,189,18,168,120,189,128,160,154,59,128,2,132,61,5,181,200,188,143,157,96,189,171,194,62,189,57,91,166,188,122,146,14,189,45,119,192,189,244,16,131,189,228,212,147,188,50,69,184,59,110,216,217,187,104,124,133,189,89,34,228,59,34,98,152,188,193,232,45,189,139,161,111,189,41,156,84,187,214,181,157,61,80,61,231,61,65,57,203,61,250,89,243,188,174,16,101,61,58,46,69,61,235,238,200,189,218,166,191,189,140,48,6,189,61,190,85,61,119,161,41,61,94,197,128,59,170,190,78,189,103,110,35,62,183,240,60,61,94,27,255,188,63,119,62,189,146,28,5,189,97,181,198,188,213,151,48,189,20,113,48,61,242,140,192,189,181,67,66,189,128,137,77,188,104,36,135,189,79,184,95,59,163,54,102,189,197,151,238,187,96,177,117,189,25,31,6,189,9,20,151,189,230,17,81,59,142,95,158,189,193,55,110,61,29,110,202,188,165,184,29,61,139,181,13,62,208,177,29,62,111,212,141,60,115,22,114,188,10,219,212,61,197,88,83,61,63,97,159,188,249,99,12,189,197,93,71,189,0,47,189,61,92,206,219,61,196,175,120,61,204,3,94,188,243,22,151,60,221,146,14,189,251,130,27,189,94,26,98,57,124,212,94,189,34,209,154,60,33,125,108,188,171,163,213,188,89,174,240,188,252,224,222,60,122,29,127,189,11,97,243,188,106,86,12,189,102,141,210,189,93,5,138,189,251,33,86,189,55,163,9,61,131,251,230,189,217,170,142,189,37,184,14,190,69,63,21,60,167,33,132,57,206,123,133,187,52,31,252,61,139,88,191,61,48,142,149,61,24,250,3,61,251,69,154,61,15,86,27,61,103,49,76,189,63,213,147,60,93,181,220,60,240,12,10,62,87,119,60,61,212,56,40,61,115,78,174,61,74,52,252,61,160,103,88,60,113,155,78,61,76,48,181,187,64,43,184,189,67,67,184,188,19,144,167,189,242,134,124,61,245,99,5,189,193,33,47,188,123,214,88,188,125,38,245,189,232,21,61,189,129,147,247,189,136,127,138,189,153,179,177,189,180,199,131,189,161,52,145,60,141,29,14,61,242,198,223,189,127,229,246,60,216,171,15,62,28,44,37,62,36,44,56,62,203,13,231,61,224,170,215,61,209,100,182,61,50,99,158,61,84,30,137,61,215,122,175,60,66,222,131,61,36,151,200,61,114,81,107,61,71,112,228,60,114,174,215,60,161,140,163,61,114,59,139,59,25,235,10,60,122,128,219,188,6,72,173,187,151,40,177,188,235,104,153,189,197,252,168,189,134,121,168,188,178,33,40,188,2,97,151,186,250,235,22,186,67,172,147,189,6,239,149,189,61,5,72,189,116,44,223,189,94,34,153,189,82,153,181,189,33,224,188,189,182,188,223,189,175,156,213,189,62,227,162,61,79,192,226,60,4,86,233,61,114,77,64,62,189,183,7,61,166,156,175,60,214,178,111,61,10,251,10,187,108,15,119,187,128,66,227,60,210,247,255,188,120,12,112,60,15,98,132,60,16,13,100,188,91,100,52,189,220,254,94,189,36,95,22,190,21,197,25,190,51,181,56,61,33,210,169,58,13,27,101,60,90,205,101,61,34,109,71,189,127,167,67,189,43,214,5,188,205,208,22,187,117,75,187,188,133,107,245,61,68,165,64,189,14,133,180,189,141,88,155,189,11,45,221,189,227,98,4,189,4,93,119,60,103,99,70,189,226,133,34,189,40,100,196,61,122,154,93,60,242,229,110,188,246,42,44,60,81,243,248,188,87,194,131,60,195,196,146,58,81,232,76,188,79,146,59,59,11,130,49,61,49,138,21,190,247,117,159,188,189,171,190,188,155,180,161,188,137,179,162,61,18,60,182,188,198,64,137,189,21,102,14,61,115,162,235,61,143,59,222,188,243,103,136,188,139,88,129,61,87,14,168,189,20,53,152,61,171,89,73,61,67,10,55,189,254,47,116,188,207,143,151,61,71,156,238,189,219,254,80,61,209,189,58,61,42,82,114,189,11,15,181,61,184,20,130,188,192,121,24,190,107,237,160,61,152,238,64,61,47,114,92,189,130,40,150,189,108,165,19,189,216,221,31,62,188,171,156,61,75,24,116,189,171,117,227,188,23,77,227,61,169,246,25,61,221,36,54,189,55,16,74,61,212,115,92,60,131,190,141,61,175,212,150,61,115,14,98,61,180,136,237,60,103,4,192,61,227,106,215,61,150,13,53,189,96,230,156,60,201,143,105,187,160,94,21,62,203,168,210,61,122,156,50,189,52,73,2,190,103,226,185,61,255,187,227,61,179,49,119,189,232,35,198,61,35,14,183,61,203,181,144,61,164,64,213,60,227,161,191,59,90,145,114,189,158,35,253,61,248,186,107,59,122,129,68,59,171,119,23,61,83,94,167,60,64,192,42,61,131,24,40,60,178,209,94,188,186,37,131,188,171,112,211,60,234,207,190,60,255,92,67,59,150,130,133,60,62,60,136,61,179,216,111,61,246,190,74,60,201,133,84,188,40,79,144,60,151,133,80,61,106,33,134,61,102,73,53,189,184,98,31,59,12,105,73,59,65,199,136,61,254,72,48,189,218,86,49,60,31,161,132,189,175,6,39,61,206,207,254,61,174,181,168,61,2,12,152,61,242,137,38,61,239,108,141,61,200,182,195,61,127,77,2,62,0,169,174,188,176,94,174,61,125,5,43,189,20,122,218,188,129,120,155,60,69,225,7,61,181,231,26,60,86,254,74,188,214,197,45,189,68,145,104,188,65,54,17,189,215,244,199,188,203,217,177,61,254,143,44,61,224,193,201,60,184,3,53,188,57,102,164,187,17,56,243,60,5,201,212,60,9,135,128,188,19,238,56,61,185,214,142,61,58,145,177,61,243,214,139,61,45,177,209,61,145,109,93,61,216,28,134,61,243,43,26,189,248,209,95,60,19,201,144,61,249,178,91,61,239,135,68,61,94,191,239,61,242,231,95,61,52,33,153,188,213,238,129,61,238,124,254,60,158,178,172,61,81,216,168,188,3,131,28,61,46,209,226,187,69,222,209,59,71,94,80,188,50,127,144,56,48,4,58,61,56,156,155,188,5,161,77,189,127,213,245,60,157,167,50,60,125,66,148,59,250,212,210,60,131,169,195,188,252,12,44,189,168,120,226,58,193,223,116,189,82,222,222,188,51,161,134,61,144,31,61,60,190,91,79,60,116,15,151,61,102,180,22,188,72,72,73,189,240,16,174,60,123,52,132,61,73,29,51,61,81,148,7,189,109,177,19,61,114,47,222,187,44,99,25,60,191,41,143,60,137,51,131,189,103,135,139,189,192,126,165,61,186,148,227,188,143,18,224,60,81,240,130,61,215,60,136,61,150,135,104,61,148,242,176,61,80,197,248,187,118,228,164,188,168,50,66,189,65,191,135,188,30,18,133,188,171,60,99,61,226,230,24,187,151,129,55,60,176,138,123,61,134,183,128,189,158,214,178,189,7,189,190,189,118,207,46,189,202,169,182,59,15,3,69,61,243,75,145,60,28,21,176,59,132,252,23,62,185,251,128,189,126,114,240,188,200,92,234,61,127,51,78,189,25,77,185,59,232,27,170,60,164,131,59,189,216,249,65,189,41,146,242,60,38,156,190,189,66,245,52,189,58,100,76,189,48,98,33,189,72,250,85,60,217,93,128,61,55,245,25,61,97,67,173,61,252,233,13,62,213,41,71,61,0,110,129,189,98,166,103,189,110,124,154,60,22,148,6,189,113,25,10,61,190,50,144,189,60,229,56,189,173,23,100,60,241,157,167,61,174,19,148,189,80,136,195,60,50,246,178,60,213,118,213,60,45,103,41,188,236,89,24,60,21,114,251,59,176,137,27,62,144,127,169,60,184,112,199,189,186,38,182,189,157,26,159,189,52,15,191,60,59,188,145,188,235,123,5,189,17,139,167,189,182,239,173,189,13,156,187,60,243,209,232,189,68,151,17,189,205,180,57,189,175,107,234,188,111,231,138,61,195,95,54,60,165,0,201,60,209,69,2,62,182,147,165,61,121,198,19,189,243,183,53,60,218,192,68,61,143,242,14,189,184,62,11,61,60,188,104,189,119,211,12,60,61,55,140,187,78,86,4,61,66,6,85,188,159,22,42,188,161,104,162,189,164,126,8,60,117,43,188,60,149,14,86,188,143,36,154,188,135,197,52,61,38,178,106,61,190,18,26,189,135,29,159,60,188,170,215,58,148,28,28,189,38,166,43,61,46,96,25,190,212,233,56,189,255,43,70,60,113,16,179,187,47,240,134,188,117,10,250,59,56,125,153,189,88,88,172,61,102,54,205,61,149,73,73,188,236,56,134,61,52,136,58,61,130,152,161,61,73,33,249,60,64,134,143,60,200,149,188,61,181,77,196,185,231,13,216,61,216,249,63,61,135,57,155,60,36,52,217,188,205,111,142,187,30,145,178,59,13,170,108,60,224,238,112,61,51,170,8,189,76,147,60,61,150,168,213,189,178,155,157,60,67,247,150,60,196,66,140,188,200,22,182,188,18,61,64,61,181,18,126,189,172,1,105,188,251,213,178,61,50,210,157,189,62,254,217,60,67,35,48,189,202,84,253,188,89,127,17,189,34,130,154,188,101,250,75,189,149,1,32,61,35,197,60,61,115,105,75,61,125,31,47,61,195,78,61,189,227,89,217,188,168,105,12,60,1,70,29,61,42,86,110,61,24,245,30,61,155,193,144,185,29,7,252,60,60,208,5,189,81,36,92,189,134,63,76,61,44,230,26,188,58,189,18,61,150,98,45,187,26,218,140,186,53,172,242,60,193,8,115,188,19,191,250,60,35,145,200,60,230,49,151,60,101,120,6,61,69,197,16,189,187,156,49,188,247,91,55,188,146,244,242,186,122,226,27,186,175,88,54,189,23,131,67,59,226,117,128,61,78,76,176,188,121,133,72,187,124,179,79,189,193,246,122,60,41,45,82,60,127,165,83,61,80,9,27,60,147,65,91,187,139,86,234,61,187,4,32,189,184,49,47,187,116,109,251,60,84,210,57,188,180,158,241,60,150,235,235,60,138,236,29,61,16,88,13,189,251,62,187,61,80,172,176,188,164,213,120,61,252,205,126,189,229,78,159,60,35,3,219,59,200,84,136,189,84,171,14,60,236,142,13,61,100,107,199,60,81,138,7,190,99,23,43,189,57,139,169,188,221,255,46,60,101,166,118,60,199,244,153,189,164,96,123,187,82,254,128,189,103,8,236,188,155,39,6,190,200,229,147,189,86,9,190,187,198,117,12,188,16,238,26,61,199,70,226,60,104,113,74,61,176,140,240,188,7,141,196,61,233,102,157,60,160,231,121,61,166,24,68,189,178,7,98,188,135,142,242,187,160,223,181,188,236,62,87,188,76,202,254,59,135,215,251,61,58,216,240,60,121,54,19,61,210,130,159,189,129,167,57,188,97,91,209,57,235,117,121,189,220,214,55,188,241,147,153,187,109,83,156,61,202,55,138,189,208,6,103,189,171,174,87,189,61,162,58,188,7,17,133,188,216,39,65,189,66,19,52,188,214,203,43,60,39,73,87,59,4,252,109,189,182,177,157,189,190,108,8,189,109,108,43,61,24,123,14,61,171,97,186,60,114,206,188,60,142,63,218,59,175,160,224,61,154,81,194,187,88,255,70,189,226,41,44,189,202,206,190,189,115,228,200,187,167,116,208,188,160,214,95,60,6,127,22,60,140,69,151,188,38,75,102,189,166,103,35,189,114,244,159,189,105,132,226,59,239,5,116,61,116,204,31,189,69,199,128,60,236,155,67,188,35,231,225,187,97,104,253,188,34,106,41,189,189,7,128,188,133,154,60,189,80,184,234,60,14,188,177,189,13,103,4,189,214,187,91,189,93,192,108,188,102,112,143,189,112,142,177,189,195,43,57,189,107,17,47,61,7,99,255,60,59,112,167,61,255,32,49,60,55,168,130,61,99,235,125,61,32,200,234,60,11,92,193,60,133,188,137,61,237,17,5,189,28,162,25,188,28,73,169,61,168,250,183,188,133,243,81,61,65,145,152,188,79,170,161,60,146,99,163,188,94,150,220,189,166,68,2,61,77,75,84,59,172,122,175,188,99,85,46,189,168,1,67,61,19,109,47,61,64,217,102,61,140,66,153,188,162,241,98,61,85,65,249,188,190,110,110,60,60,201,135,189,194,92,111,189,102,45,25,189,57,117,199,189,151,230,3,189,225,51,102,189,113,156,212,189,107,142,151,61,240,216,137,59,55,120,5,61,20,115,12,59,181,203,81,61,145,201,80,188,16,92,195,60,173,192,129,61,17,232,161,189,102,136,171,61,0,197,161,189,110,75,133,189,43,172,204,188,120,218,133,61,20,162,34,61,180,132,72,61,39,159,63,188,160,11,35,189,41,191,104,61,252,180,114,61,136,1,63,188,41,139,162,189,21,102,44,189,120,143,90,60,86,94,185,61,31,210,206,61,24,201,34,189,210,245,74,60,186,162,153,189,17,186,21,189,202,48,48,189,228,194,188,61,136,12,243,57,55,144,233,60,105,136,175,60,65,121,6,57,106,231,235,60,66,52,175,189,37,51,70,189,195,156,166,61,160,201,107,189,68,167,103,60,150,99,13,61,46,145,135,189,199,28,250,188,217,158,242,60,193,60,151,189,96,18,58,60,208,109,88,61,77,75,159,189,26,165,172,188,136,194,97,189,162,248,9,190,0,59,248,60,191,170,137,61,6,185,126,189,182,170,110,189,102,24,128,61,190,56,237,60,156,80,136,188,99,73,20,189,236,19,132,188,37,126,191,186,81,127,15,62,151,212,18,188,77,33,5,189,184,236,93,59,160,134,45,59,88,157,9,61,30,151,197,188,236,63,45,189,120,113,218,61,42,78,213,192,11,181,150,62,143,85,202,189,106,161,4,190,65,73,161,61,240,105,198,62,33,231,133,62,9,113,21,62,101,252,123,61,60,75,168,62,124,153,104,62,218,31,136,189,212,155,177,189,58,205,66,61,223,140,218,61,226,57,27,61,170,69,228,61,23,239,199,188,175,10,156,62,229,100,130,62,20,203,141,189,93,24,169,61,83,203,22,62,123,104,167,62,25,118,24,62,204,98,98,61,123,49,180,189,42,0,134,62,118,226,18,62,215,164,219,60,217,237,115,62,46,173,70,62,210,197,102,61,197,203,211,188,39,21,13,189,224,99,32,190,34,25,82,62,212,73,182,61,157,42,15,190,223,25,205,189,161,243,26,189,193,115,239,188,209,231,99,189,14,47,8,61,44,68,135,188,72,248,30,62,37,64,125,62,145,95,255,189,194,77,70,189,90,217,126,189,214,84,70,62,126,225,149,59,1,165,97,61,2,159,191,61,178,188,43,62,91,154,43,62,176,201,154,60,152,108,92,62,109,26,251,61,141,98,185,61,29,170,137,189,162,210,72,189,243,2,204,189,120,155,119,62,67,87,194,189,91,122,52,190,129,92,226,58,74,179,9,190,176,229,213,61,143,168,80,61,214,57,166,61,134,198,147,61,138,33,249,61,73,16,46,59,12,144,152,190,8,203,8,190,112,65,118,189,129,120,189,189,246,152,72,189,129,147,173,189,5,111,56,190,140,16,30,189,36,181,176,61,5,222,9,190,93,165,219,189,81,20,8,62,14,244,16,62,68,105,127,62,73,102,5,62,146,3,246,188,44,240,149,61,141,156,5,188,86,70,163,60,40,209,146,61,82,73,157,57,229,242,159,188,161,248,177,188,71,232,39,189,178,217,177,189,44,157,143,61,54,203,117,62,245,219,135,62,223,250,48,61,144,193,42,62,182,75,187,61,14,131,121,61,244,111,23,189,193,116,186,189,117,148,163,61,69,14,97,62,126,229,33,62,42,254,15,190,140,49,48,189,49,152,255,61,2,213,191,61,183,94,211,61,64,76,194,61,174,242,164,61,29,4,13,62,106,107,36,62,228,74,45,190,244,24,101,60,213,119,158,62,195,46,138,187,140,74,106,189,207,18,132,189,20,117,102,60,44,214,184,62,16,174,128,62,106,218,165,189,60,249,52,189,81,164,123,61,210,28,25,189,142,90,161,189,8,229,253,60,162,207,135,61,125,89,26,61,22,251,27,62,76,196,187,189,151,198,143,61,165,21,95,62,222,60,21,61,28,152,156,189,91,238,204,59,10,101,193,189,126,139,30,62,48,186,188,188,37,176,73,190,91,121,201,188,135,191,54,62,141,94,77,189,49,35,60,189,14,248,124,186,29,118,223,61,131,23,61,61,173,50,35,190,249,192,14,188,135,49,41,61,146,235,198,61,21,86,106,189,123,76,132,189,175,8,158,61,31,101,52,62,72,164,13,62,130,169,134,61,7,240,214,189,58,232,146,60,110,134,11,62,138,5,62,188,105,138,64,61,102,247,164,61,30,136,140,61,191,98,173,61,28,97,17,189,214,2,187,189,149,158,41,189,186,188,121,61,61,183,208,189,226,146,163,189,182,20,176,189,254,215,185,188,228,103,163,61,199,213,200,189,101,167,95,189,165,104,37,61,172,1,154,62,129,176,3,62,146,61,194,61,216,45,66,61,160,137,208,61,141,67,125,61,69,13,38,190,87,118,81,190,45,9,16,189,5,197,207,61,181,82,136,188,181,84,222,188,14,158,9,190,205,62,15,188,234,146,209,61,13,56,235,61,222,1,30,60,88,169,128,61,255,8,115,62,9,223,43,62,188,91,89,61,173,78,78,188,113,198,48,61,124,15,23,59,63,31,133,61,4,116,31,189,160,193,166,188,206,255,27,62,141,12,50,61,91,125,245,188,62,234,47,189,204,10,5,61,112,67,140,61,21,0,227,189,124,127,227,189,197,85,229,61,100,202,7,187,112,65,182,187,27,213,169,61,106,106,217,59,82,127,221,189,41,151,198,60,10,20,177,189,244,112,66,190,98,75,143,188,11,13,68,62,173,193,251,187,5,220,3,190,183,183,27,189,159,142,7,190,179,67,188,61,168,55,163,61,54,148,218,189,47,223,250,187,206,227,48,62,67,169,61,60,78,236,33,60,44,131,170,61,21,56,217,188,221,6,21,62,65,158,29,62,190,106,5,190,142,30,223,189,157,244,254,61,54,204,80,187,20,203,205,189,57,39,118,60,110,219,119,189,239,89,215,60,150,150,177,189,123,17,45,190,242,180,156,61,232,244,92,62,210,255,50,61,41,205,6,190,81,49,78,188,182,15,57,189,238,9,242,189,79,87,119,190,219,78,43,190,111,183,164,188,250,40,163,188,173,138,208,189,38,85,219,189,198,20,44,188,233,16,56,61,121,59,66,62,113,84,94,62,172,196,60,189,5,78,54,61,90,130,76,62,238,120,19,189,82,128,24,190,238,206,90,60,190,80,160,189,96,116,249,60,225,155,102,61,208,152,201,188,88,113,170,61,245,215,203,61,115,131,33,189,143,54,14,190,89,162,179,59,78,151,197,188,216,214,15,190,195,242,135,189,31,187,139,188,65,183,23,60,154,149,109,189,121,91,233,188,196,90,124,189,244,51,245,59,193,27,34,190,177,77,26,190,63,169,54,189,174,73,215,189,252,113,59,189,207,219,216,187,91,10,200,188,131,19,241,189,41,118,244,189,225,41,52,190,157,132,146,189,110,196,243,61,195,17,228,61,167,116,48,61,197,231,14,61,91,120,190,61,187,123,0,60,181,250,106,61,92,228,222,189,67,198,163,189,132,128,108,62,245,132,165,60,171,236,59,60,6,128,202,61,158,123,207,61,115,133,247,188,124,154,147,188,204,236,115,189,215,104,217,189,83,32,179,60,158,98,21,189,199,241,163,61,162,156,40,61,146,36,168,189,84,26,241,61,236,161,253,60,43,79,96,189,171,61,172,189,151,60,62,190,244,26,123,189,54,3,28,189,93,197,226,189,82,44,135,190,200,7,157,61,95,236,157,189,140,242,12,190,1,104,20,61,92,85,142,62,40,153,156,60,190,165,220,61,134,117,19,62,108,118,164,61,102,50,92,62,250,99,106,62,142,234,148,61,115,71,159,61,164,26,246,61,120,67,154,61,150,120,128,61,191,213,250,61,157,188,72,189,177,222,40,62,75,89,38,62,145,241,40,61,220,13,34,60,134,89,200,189,228,131,30,189,30,163,188,188,12,205,245,189,167,62,80,62,248,111,126,62,203,103,25,62,37,150,20,189,99,154,169,189,192,5,185,189,255,90,222,188,214,2,155,189,172,255,163,190,111,18,3,186,38,198,18,190,23,71,133,189,39,108,63,190,24,122,4,62,96,115,238,61,77,15,58,62,198,134,46,62,8,116,214,62,5,139,235,62,55,221,170,62,32,12,108,62,0,225,67,61,175,33,56,189,172,112,139,189,21,139,15,62,58,150,55,189,215,52,175,61,186,103,189,61,1,190,219,189,91,206,5,190,141,150,83,190,238,179,234,61,186,191,162,190,126,1,157,189,235,110,30,61,236,219,89,62,42,142,131,188,8,144,1,190,72,135,39,190,156,50,87,62,142,145,204,61,23,102,1,190,125,151,242,61,232,45,158,60,141,9,177,188,69,161,197,189,30,252,228,189,253,76,77,190,82,72,18,62,8,85,106,62,196,233,180,190,92,115,55,190,170,70,239,61,34,57,129,62,56,245,1,189,118,166,64,190,95,208,34,190,88,230,197,62,73,128,250,61,143,251,86,62,98,189,201,62,200,210,183,62,179,124,133,62,76,108,46,62,169,46,96,60,176,4,18,190,92,31,214,188,241,155,66,188,167,33,26,190,204,41,65,61,82,67,219,189,34,226,22,190,140,49,64,190,221,125,62,190,137,10,85,190,36,124,111,61,168,142,149,189,188,59,114,190,228,103,163,189,166,185,21,190,194,223,111,189,91,150,207,189,151,2,146,189,53,153,145,189,59,115,239,61,99,237,111,62,102,18,157,62,159,203,164,62,143,194,117,62,221,9,150,61,67,113,71,188,125,234,216,60,52,130,77,61,50,29,42,62,46,115,106,62,25,144,125,61,13,55,32,62,11,239,82,62,226,34,247,61,80,252,24,61,201,233,43,62,219,135,148,62,52,128,215,62,109,116,78,188,40,101,66,62,148,221,156,62,201,114,242,61,226,200,195,189,123,49,148,189,8,173,7,190,39,164,101,190,166,11,1,190,182,18,186,60,143,109,145,62,77,104,82,61,235,1,115,186,29,148,112,189,128,181,170,189,227,164,16,190,114,20,64,190,118,136,79,190,119,77,72,61,237,131,124,62,222,59,226,62,166,94,175,62,73,44,137,61,239,115,92,62,36,181,64,62,145,242,147,189,45,35,85,190,154,93,247,188,152,106,54,62,204,69,12,62,239,168,49,189,193,113,57,190,129,9,188,61,53,238,237,61,6,187,1,190,182,243,197,190,31,128,188,62,230,205,137,62,93,79,180,189,54,30,236,188,86,98,190,61,68,107,197,60,240,223,60,61,134,255,52,62,0,28,11,62,104,232,255,61,128,40,72,62,231,113,24,189,239,58,43,62,247,120,65,62,45,64,91,61,34,81,136,189,40,238,8,62,98,132,144,189,238,91,237,61,236,23,28,62,7,154,239,189,15,126,226,189,22,77,55,190,217,118,218,60,234,236,164,61,164,197,153,61,102,46,144,189,56,192,76,60,173,252,178,60,75,30,15,190,73,99,180,188,117,57,197,189,154,6,133,189,52,129,2,190,144,50,98,188,65,212,221,189,45,9,32,62,188,118,25,62,145,123,58,188,90,41,132,61,187,241,238,60,73,103,224,60,67,199,142,61,181,108,29,62,47,135,29,61,74,64,108,62,81,247,129,62,87,205,115,61,127,137,56,189,98,188,102,60,115,158,145,61,58,203,140,61,103,96,196,61,93,26,191,59,66,93,20,62,163,234,215,60,132,243,137,189,174,215,52,189,204,123,252,189,101,28,163,188,158,66,174,59,114,168,223,61,222,199,81,187,128,11,178,188,0,111,17,62,138,6,137,189,67,231,245,189,149,42,65,190,92,87,76,60,216,125,71,189,195,154,74,188,141,67,61,190,30,163,44,62,251,201,136,62,131,107,110,61,64,163,52,189,76,55,9,61,233,215,54,62,79,30,214,61,74,182,250,61,215,51,164,61,102,103,49,62,215,217,152,62,34,109,131,61,208,182,90,61,114,134,50,62,18,135,108,62,206,170,239,61,88,59,42,62,108,63,105,62,49,9,247,61,232,50,53,62,181,169,58,188,0,30,177,189,229,126,7,188,97,195,83,61,195,12,29,190,17,255,112,189,223,22,108,189],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+92160);allocate([37,59,118,189,220,217,215,60,86,154,36,190,189,54,27,189,148,246,70,189,36,38,40,61,58,36,181,188,74,65,119,61,99,155,84,61,142,143,38,62,237,215,13,62,201,142,77,189,142,147,194,187,66,6,146,61,30,192,2,62,83,90,127,61,152,221,19,62,79,175,148,61,207,50,75,62,213,32,124,62,117,31,160,189,242,37,20,189,73,131,155,61,1,219,65,61,187,214,94,188,137,152,178,61,83,5,163,60,56,48,185,60,123,189,123,188,201,115,189,189,199,41,154,61,4,86,238,189,23,217,78,61,167,205,56,61,138,144,42,62,2,155,147,61,149,71,119,61,176,232,6,62,145,240,45,190,144,47,33,189,174,128,66,189,46,2,35,189,42,55,81,190,43,217,177,60,181,140,4,62,0,115,173,188,247,147,49,62,114,252,144,189,24,11,131,189,27,185,142,61,86,70,131,189,206,80,252,189,185,79,142,188,187,213,83,190,46,227,134,61,8,227,231,61,86,102,202,60,59,27,146,189,108,36,137,189,250,69,201,189,223,223,128,189,0,82,155,61,97,27,113,60,157,190,158,60,63,226,7,62,115,241,151,189,169,105,183,189,76,168,160,189,75,58,74,190,61,213,49,190,70,97,87,61,225,179,53,61,97,140,232,61,44,182,201,61,226,120,158,61,182,157,54,188,25,55,69,190,166,97,40,190,131,165,58,61,194,162,82,62,79,120,73,61,241,130,168,189,105,28,10,62,115,243,61,62,155,58,15,61,102,220,244,189,75,35,230,189,213,180,235,189,37,91,93,189,67,58,60,190,229,242,159,189,141,69,67,62,178,161,187,61,78,126,139,59,44,125,40,189,36,182,123,189,126,253,16,190,3,124,71,190,14,17,247,189,93,55,165,60,183,155,224,61,246,7,138,61,206,168,121,188,109,226,116,190,245,130,135,190,199,158,61,190,186,187,78,61,21,86,170,60,24,35,18,61,219,24,187,60,160,55,85,189,11,10,3,190,60,134,231,189,226,229,105,190,104,61,132,190,193,224,90,189,48,132,156,61,255,178,123,61,111,45,115,62,248,27,109,59,179,210,100,189,184,92,221,189,74,13,237,188,86,183,58,61,57,99,88,61,146,206,192,186,151,253,186,60,110,250,115,61,101,223,213,189,163,61,158,189,152,247,88,190,250,42,89,190,114,251,229,60,38,85,155,61,45,62,133,60,156,195,37,62,87,180,9,62,27,100,18,60,164,198,68,189,31,248,152,61,15,123,161,59,245,19,206,188,195,128,69,62,69,100,152,61,31,18,158,62,167,232,136,62,32,240,192,61,149,16,172,187,47,51,44,61,159,173,3,189,208,100,127,60,12,120,129,62,94,130,51,62,1,136,187,60,44,68,167,61,50,115,129,61,110,135,38,62,156,23,71,62,220,128,111,62,35,75,134,62,148,106,63,62,156,49,172,61,115,161,146,190,150,37,90,190,195,40,72,189,47,167,84,190,150,33,46,190,28,64,63,60,196,96,190,189,177,105,69,190,233,12,140,190,25,114,108,62,25,145,136,62,17,27,164,62,179,36,152,62,206,84,12,63,189,30,156,62,26,223,7,62,221,68,125,62,116,150,89,62,97,254,138,190,249,131,17,190,191,41,44,187,254,38,244,189,213,118,3,62,56,246,204,61,162,122,107,189,193,167,249,189,170,98,106,190,162,37,79,62,238,177,204,190,113,30,190,190,170,69,196,189,89,78,130,189,125,63,37,190,252,82,159,190,162,239,150,190,212,238,119,62,117,34,65,60,199,187,195,61,188,33,165,62,242,7,3,63,135,80,165,62,124,99,160,62,175,125,49,62,175,151,38,59,83,35,244,188,187,71,166,62,193,255,166,190,45,92,174,190,95,155,13,190,228,46,66,187,74,152,233,189,10,47,193,190,137,152,226,190,114,139,89,62,54,63,254,187,67,169,61,188,184,200,45,62,124,12,158,62,112,123,162,62,119,21,10,63,169,106,170,62,233,211,106,61,245,161,139,189,59,226,208,61,146,179,136,62,133,153,86,62,62,34,182,62,34,171,187,61,223,82,46,62,92,56,0,62,234,93,140,62,20,209,143,61,213,4,209,60,45,148,76,61,224,45,16,186,128,14,51,61,75,63,17,190,9,193,170,60,231,252,4,62,129,95,131,62,27,18,215,61,46,230,23,62,67,199,46,62,51,221,235,60,182,160,151,61,13,226,35,62,30,110,207,62,114,24,124,62,81,78,180,62,126,1,45,62,233,152,99,62,140,100,135,62,44,14,135,61,192,235,179,60,164,197,153,189,214,173,190,61,0,202,223,60,53,121,202,61,83,202,107,61,228,106,164,189,7,121,61,62,135,251,160,62,68,222,170,62,49,209,0,62,160,255,150,62,14,162,197,62,132,215,94,62,225,235,59,190,139,167,142,190,61,124,25,187,222,232,227,188,7,125,9,190,83,231,169,190,242,235,7,188,105,27,255,61,29,1,92,61,170,239,188,190,60,162,194,189,249,103,86,62,18,247,216,62,84,87,190,62,172,230,217,61,12,35,189,62,157,161,248,62,244,191,108,62,113,3,14,190,100,203,178,190,173,135,143,189,137,126,237,60,161,45,167,189,119,191,202,190,97,80,22,190,127,21,224,188,195,213,129,61,6,131,139,190,239,202,110,61,120,41,173,62,207,217,226,61,35,159,87,189,218,117,111,190,161,218,224,188,109,114,248,60,68,78,31,62,217,39,192,189,12,92,158,60,14,17,247,61,31,45,206,59,11,66,217,189,1,246,113,190,190,80,16,190,121,92,180,189,53,238,205,188,128,101,85,190,146,233,208,188,17,167,19,62,204,13,70,189,7,98,217,189,210,56,156,190,231,197,233,189,207,74,186,61,213,203,167,62,153,215,17,61,52,15,192,189,102,188,45,59,220,47,47,190,106,165,64,190,202,196,93,190,147,30,86,190,162,212,94,189,37,235,32,62,0,254,105,189,49,93,136,61,104,66,19,60,229,183,40,61,188,33,13,61,40,68,160,189,195,101,85,61,144,46,182,188,86,45,137,61,83,174,240,189,181,194,148,189,75,6,128,61,0,227,25,61,66,179,107,189,133,237,159,190,237,185,12,61,134,57,1,189,86,42,40,59,29,90,84,190,11,179,144,189,25,229,153,188,239,143,55,189,208,241,81,188,169,77,156,189,105,30,160,61,179,153,195,60,151,198,239,61,182,157,182,60,171,90,82,190,115,133,119,189,87,176,141,188,208,43,158,187,213,94,164,190,195,187,188,189,140,19,31,61,164,228,149,61,65,68,138,189,145,66,217,60,90,18,48,62,200,211,178,61,161,74,13,61,232,160,11,189,168,29,30,62,18,159,123,189,77,161,243,59,64,133,227,189,17,143,196,189,60,132,113,60,241,127,7,190,163,205,241,188,151,197,68,190,237,17,202,61,18,21,170,60,152,76,53,62,210,29,132,189,85,249,94,189,88,88,112,189,34,136,243,186,220,159,43,62,176,230,128,60,134,145,94,61,198,250,134,60,169,218,62,62,164,196,46,188,184,4,96,61,168,200,1,62,40,73,87,60,254,10,185,61,137,208,8,190,99,152,147,188,40,72,28,190,101,25,226,60,95,7,14,190,28,236,77,189,197,229,56,61,61,41,243,189,238,36,194,61,165,160,43,190,162,153,199,61,49,154,21,188,212,183,76,62,93,253,88,189,156,253,33,62,136,218,54,62,100,93,220,189,29,115,30,60,241,45,172,189,147,229,36,189,241,155,82,190,132,184,210,61,17,224,100,62,38,229,46,61,75,201,242,61,208,70,174,188,101,82,227,61,10,216,30,190,185,226,226,60,54,145,25,190,49,40,83,61,252,81,4,190,71,176,49,62,162,126,151,61,3,149,65,190,253,103,13,189,240,109,218,189,36,9,66,188,63,30,74,190,205,173,96,62,255,151,59,62,203,243,96,189,21,111,20,62,218,146,21,61,125,236,174,189,83,145,106,190,183,40,19,190,213,177,74,189,170,100,32,62,51,25,14,188,84,170,132,189,249,163,168,61,78,43,21,62,65,215,62,59,246,41,87,190,27,185,238,189,73,157,160,61,181,53,98,62,185,110,138,189,72,27,71,61,88,230,173,61,234,148,135,189,68,110,230,189,80,254,94,190,41,63,169,189,206,167,142,188,151,202,107,62,131,221,144,189,72,81,135,61,18,108,92,62,195,186,145,61,102,160,178,189,177,22,79,190,183,67,67,188,41,231,203,61,192,232,50,62,43,193,130,189,175,235,247,189,145,99,107,60,222,228,7,62,91,206,165,187,255,121,122,190,113,1,56,190,45,236,9,190,183,95,190,60,51,192,69,190,18,165,157,189,32,96,173,188,125,4,254,186,237,186,39,190,21,57,228,189,35,105,87,190,120,94,42,190,54,90,14,61,9,110,36,60,72,139,179,188,237,74,139,61,245,244,177,189,218,228,128,190,163,202,136,190,235,30,25,61,56,245,129,59,191,129,9,61,100,36,27,190,65,97,208,60,219,247,168,188,175,237,157,190,112,176,175,190,98,244,188,189,79,33,215,188,198,51,232,188,124,154,19,61,95,13,16,61,201,147,4,62,157,70,250,61,127,75,128,60,6,157,144,189,169,49,193,189,216,71,135,189,166,70,40,189,43,247,34,62,126,225,149,61,192,94,225,61,135,168,50,62,164,226,159,61,112,207,115,188,249,248,4,60,144,106,88,60,234,90,155,61,173,76,72,62,51,112,128,61,254,43,139,61,174,154,103,61,15,154,29,190,166,38,17,190,24,149,148,189,106,79,9,61,65,14,202,188,246,182,9,62,153,242,161,61,122,196,8,62,196,148,104,62,251,229,147,60,15,123,161,59,206,56,45,62,105,110,133,61,159,200,147,61,71,202,6,62,130,58,197,61,24,93,94,61,191,156,217,61,47,196,234,61,50,202,243,61,38,228,3,63,7,94,125,62,201,233,75,62,65,11,89,62,144,158,2,62,210,224,150,190,63,145,71,190,56,192,76,189,193,225,229,189,35,18,5,188,11,96,202,187,3,178,23,61,148,21,227,189,30,253,127,190,169,23,28,62,125,64,112,62,41,5,29,62,57,213,178,62,77,220,46,63,57,242,32,62,54,174,255,61,209,7,203,61,209,231,131,61,146,92,126,190,254,12,31,190,85,18,217,188,55,26,192,188,180,233,72,61,224,218,233,189,9,196,235,59,157,17,53,190,114,252,192,190,49,121,187,62,171,65,56,190,123,18,24,190,92,4,198,59,16,33,46,62,248,109,200,61,92,62,210,189,21,87,133,190,65,215,126,62,60,161,23,61,46,228,241,189,189,26,160,61,195,212,70,62,94,102,88,62,182,186,188,62,233,240,184,62,33,34,5,62,220,215,193,61,127,218,104,62,214,84,54,190,211,18,235,189,129,152,4,188,60,160,108,62,36,9,66,188,181,136,200,189,175,205,166,190,187,72,17,62,50,57,245,61,14,245,107,190,95,121,240,189,12,201,233,189,45,64,27,61,54,90,238,61,8,6,96,62,143,168,208,189,159,146,115,61,247,59,244,61,221,40,50,60,171,208,0,189,77,102,60,61,98,158,245,61,69,42,140,62,36,151,159,62,221,9,134,62,3,124,71,62,17,254,173,62,30,50,117,62,213,91,131,61,45,235,158,61,106,190,202,61,148,250,18,62,79,8,61,62,241,160,25,61,230,231,102,62,25,230,196,61,41,232,22,190,45,210,84,190,145,239,50,190,196,237,176,189,166,129,31,189,39,104,35,62,75,59,181,189,85,161,129,186,216,127,221,61,68,23,212,188,142,234,148,189,169,247,212,60,179,235,222,187,158,237,177,189,177,249,56,188,149,212,137,190,152,221,211,189,208,208,255,189,170,67,238,189,161,218,16,62,171,207,85,62,54,33,45,61,137,178,135,62,164,55,4,63,45,208,94,62,163,92,154,188,135,108,160,190,90,103,44,190,87,10,65,61,148,77,185,61,22,250,224,189,171,176,153,188,157,185,87,62,126,2,144,62,122,140,50,189,186,221,11,189,129,122,115,190,73,20,10,190,235,112,148,189,89,165,212,189,34,26,29,61,79,3,158,62,87,147,23,62,9,223,59,189,127,217,253,189,175,235,87,190,144,16,133,189,179,183,20,189,1,105,63,189,246,8,181,188,53,38,196,61,228,159,209,62,104,92,120,61,123,133,133,189,153,73,84,61,105,56,229,60,17,111,29,188,64,252,12,190,33,149,194,189,67,4,156,188,93,136,53,62,54,228,31,60,227,168,188,189,129,235,138,188,153,18,9,190,182,134,242,189,84,59,3,189,207,158,203,187,213,35,173,189,58,3,131,61,158,209,150,189,248,166,41,62,241,47,226,61,181,194,52,61,22,190,62,61,182,72,90,61,81,48,99,189,11,38,126,60,214,111,190,62,38,172,109,62,26,162,138,188,241,242,212,61,158,235,187,189,130,143,193,59,79,30,86,62,30,54,33,62,226,0,250,60,249,47,128,62,90,69,127,61,182,103,22,61,126,229,193,61,80,197,141,60,198,54,41,188,11,209,161,189,79,120,137,60,82,68,230,189,193,28,125,61,146,65,46,61,153,215,1,190,47,110,35,188,44,125,104,189,24,39,62,61,149,98,71,190,157,190,14,190,210,139,26,189,222,199,33,62,202,53,133,188,78,156,252,61,181,24,108,62,49,153,170,61,132,72,134,188,135,252,115,61,213,91,131,188,144,164,132,189,253,130,109,62,90,99,32,62,212,186,13,61,130,31,21,62,235,57,41,61,146,116,13,61,213,145,163,60,51,168,182,189,84,25,70,188,111,159,157,62,141,122,88,62,164,139,205,188,150,206,23,190,61,125,4,190,42,31,130,61,187,127,140,189,167,36,139,189,54,201,15,189,88,228,87,62,209,174,130,61,105,138,128,61,185,23,184,189,98,76,250,188,243,85,114,60,29,146,90,189,12,231,26,189,255,91,73,190,210,109,9,60,128,70,169,189,70,125,18,62,77,134,131,61,174,240,142,61,253,159,67,62,60,80,199,61,57,240,234,188,226,57,155,61,185,85,160,62,153,158,176,61,94,160,84,62,46,228,145,60,178,161,251,61,223,249,101,62,177,107,43,62,97,168,195,188,39,74,66,61,178,44,176,62,58,64,64,62,252,113,11,62,196,35,17,62,13,169,130,61,61,70,57,61,124,101,158,189,176,3,103,187,130,0,41,190,165,216,209,188,158,7,151,189,178,98,40,62,52,128,55,60,195,101,21,190,201,255,228,188,21,230,125,189,235,82,35,189,156,51,18,190,193,170,26,62,115,159,28,189,233,181,89,61,231,0,161,61,192,64,176,61,180,3,206,61,126,30,3,62,152,107,145,189,246,181,238,189,155,114,85,62,142,63,81,61,221,95,157,61,13,251,189,60,169,161,173,189,216,42,65,188,184,90,23,62,143,224,70,189,46,85,233,189,149,15,145,62,52,132,67,62,41,8,190,61,226,61,7,61,165,216,17,190,71,230,17,190,146,204,202,189,150,4,40,189,28,37,47,189,145,44,80,62,154,8,91,189,202,196,45,61,232,47,100,62,29,4,157,188,74,95,8,190,47,108,141,190,86,16,3,189,189,53,240,61,72,24,54,62,64,166,117,189,129,152,132,189,171,178,239,189,172,54,31,190,233,214,203,189,86,15,40,62,54,148,218,188,117,31,192,189,149,186,116,62,73,48,213,187,102,73,0,60,29,204,134,61,202,135,80,190,196,177,206,189,51,194,91,189,146,232,5,190,221,66,215,60,136,245,6,62,122,28,6,61,12,61,2,62,68,253,238,61,42,253,36,190,104,62,143,190,165,73,129,190,76,226,44,187,163,91,47,61,127,50,198,61,58,122,252,189,69,212,132,61,115,75,43,188,196,8,97,190,48,19,117,190,69,188,213,189,122,168,109,189,229,122,91,189,41,206,209,60,44,17,168,59,244,167,205,189,130,60,59,189,131,21,71,190,23,102,1,190,13,26,250,188,137,149,81,61,91,36,93,62,38,138,48,62,27,13,96,189,121,117,62,190,52,133,142,190,117,87,70,190,13,27,37,189,231,198,116,59,124,155,254,187,238,10,253,61,73,190,66,62,84,87,158,189,252,112,240,61,120,13,90,62,189,58,71,60,106,250,236,56,67,229,223,60,218,170,36,61,62,94,8,61,91,180,96,62,28,152,60,62,100,201,132,62,101,86,159,62,103,14,169,61,147,24,68,189,24,153,160,189,254,15,48,60,173,52,169,61,108,181,159,62,103,126,157,62,99,42,125,59,138,89,175,60,166,43,216,188,117,85,160,188,149,155,168,60,34,28,115,189,34,110,206,60,155,203,133,62,113,198,176,61,140,15,19,62,195,187,220,61,36,151,127,59,37,235,64,190,60,244,29,189,31,46,217,189,95,40,0,190,241,45,44,188,32,69,93,61,237,240,119,62,3,237,142,62,23,184,92,62,84,169,177,62,225,183,225,62,158,38,115,62,17,198,111,62,88,113,154,62,185,251,44,62,205,91,85,190,113,228,1,190,143,25,40,60,73,216,247,61,9,249,128,189,37,119,88,189,93,50,78,61,36,71,122,189,84,112,136,190,85,132,219,61,24,150,15,62,174,100,143,62,48,102,147,62,207,19,191,62,251,59,27,62,45,181,94,60,21,200,236,61,242,119,111,60,75,60,144,190,161,76,115,190,155,61,240,189,57,155,14,184,79,5,12,190,80,252,72,190,83,5,195,189,68,81,0,190,95,67,128,190,191,124,114,62,128,14,147,189,195,70,25,189,210,140,69,61,59,168,164,62,126,81,130,61,112,237,196,60,84,168,238,188,207,134,108,62,126,114,36,62,61,15,30,190,170,102,86,188,209,177,163,189,225,237,193,61,138,61,36,62,147,144,56,62,1,193,92,61,188,90,206,61,113,199,147,62,43,110,28,61,120,13,58,62,194,49,107,62,112,93,225,62,98,216,129,61,189,141,205,59,20,237,170,60,110,105,173,62,106,50,131,62,204,236,51,189,155,200,236,61,180,1,88,59,226,35,50,62,22,163,174,60,130,172,39,189,159,146,243,189,211,193,58,62,137,149,113,62,217,10,90,189,220,160,118,188,249,246,206,189,36,66,195,61,197,89,81,61,7,183,37,62,66,150,5,61,235,82,35,62,88,57,148,61,114,135,205,60,42,139,194,60,20,206,238,60,162,39,37,62,156,21,241,189,4,61,20,189,212,16,53,190,231,228,37,190,160,250,103,62,244,106,160,189,155,115,48,61,115,16,244,189,238,178,95,61,116,152,207,189,18,46,132,189,129,36,236,189,1,106,10,62,192,5,153,62,174,211,200,61,7,38,183,61,101,169,245,187,173,20,226,61,79,32,236,188,41,174,170,60,203,191,22,189,190,107,0,62,44,183,68,62,223,107,72,189,125,62,74,59,92,255,46,188,68,251,152,61,252,57,133,188,174,188,196,61,136,218,118,61,231,115,238,187,116,122,14,62,246,35,165,189,62,7,22,61,45,63,176,61,129,37,7,62,39,135,175,61,11,68,207,60,47,133,103,62,231,110,71,62,145,210,44,61,98,162,33,190,89,22,140,189,69,216,16,190,195,185,230,189,204,69,156,189,112,124,141,189,229,38,234,189,255,231,208,189,154,93,7,62,81,77,137,189,165,103,218,61,56,189,75,62,27,188,47,62,45,64,43,62,120,40,10,189,77,45,219,188,125,65,171,61,200,11,25,62,109,111,55,187,61,185,166,185,168,143,64,60,208,240,134,61,61,10,183,189,219,51,75,189,10,248,101,62,194,190,93,62,177,251,14,189,67,60,146,188,215,132,180,189,56,190,246,59,209,8,118,62,149,14,150,61,14,77,89,60,223,135,51,62,149,243,69,60,103,127,192,61,91,97,122,60,251,201,216,61,220,41,221,61,143,84,159,61,174,242,196,189,255,8,163,189,114,22,54,62,53,207,17,62,97,140,8,61,229,242,159,189,74,38,167,189,187,123,64,189,87,206,14,62,119,17,166,60,214,59,252,189,183,121,51,62,3,124,215,61,196,208,106,61,158,179,165,61,144,162,78,188,103,210,198,189,19,15,168,61,10,19,198,189,3,233,130,189,174,186,78,62,243,61,3,62,163,145,15,189,117,0,4,189,118,140,139,189,216,100,237,189,78,185,194,61,112,36,176,189,252,83,138,189,243,29,252,60,5,253,5,61,154,36,182,61,109,143,94,61,114,23,33,189,94,132,233,189,201,202,47,62,141,8,230,189,152,222,94,190,61,128,133,61,100,172,118,61,67,201,68,62,219,167,99,61,234,64,6,190,87,205,19,190,183,93,104,61,237,40,14,189,74,38,167,189,143,139,10,190,216,244,32,186,37,144,178,61,143,111,111,60,4,171,138,61,13,140,220,61,223,50,103,62,118,197,172,61,34,252,11,188,231,141,83,61,147,30,70,189,54,148,26,189,13,171,120,189,187,238,45,59,69,187,138,60,167,59,175,61,165,192,130,188,162,209,157,188,27,241,228,61,250,125,127,61,18,222,78,62,181,110,67,61,223,25,45,61,67,199,142,61,47,190,120,62,62,117,172,60,117,30,149,189,126,169,31,190,79,144,216,188,83,231,17,61,10,104,162,189,183,210,235,188,161,244,69,189,161,128,173,61,1,19,120,189,31,133,171,189,71,3,40,190,21,225,38,189,150,147,176,189,55,51,122,60,81,134,170,187,32,98,131,188,143,169,59,61,213,146,78,189,3,8,159,189,216,214,239,61,117,119,29,60,123,49,20,188,159,117,13,188,205,206,98,189,254,15,176,189,117,177,233,60,219,50,96,189,134,31,44,190,36,15,52,62,237,211,145,61,20,91,193,188,95,68,27,61,113,116,149,187,240,106,185,188,27,155,253,61,247,120,193,61,21,87,149,189,115,217,8,190,121,230,101,188,27,46,18,190,2,45,221,188,223,49,76,190,7,98,89,60,206,111,104,62,57,69,71,61,122,23,47,190,166,96,77,189,30,27,1,60,226,117,125,61,119,73,156,60,216,126,50,189,164,55,28,189,174,12,10,62,209,148,93,61,154,66,167,189,5,21,53,62,195,71,68,61,112,94,28,189,134,118,78,61,182,129,219,189,74,153,20,189,239,172,221,60,193,26,167,61,192,207,56,187,188,91,185,61,109,141,8,189,185,0,116,189,115,156,91,60,102,131,204,189,137,67,150,61,35,132,175,62,34,84,201,61,39,136,26,190,230,146,170,188,228,78,105,189,57,125,61,61,212,209,49,189,160,253,24,190,26,52,4,190,184,145,50,188,192,32,105,188,141,68,56,190,157,131,231,189,245,158,74,189,174,43,134,189,244,222,184,61,233,71,67,188,155,232,179,61,177,48,196,61,81,162,21,62,35,19,208,61,17,225,159,61,165,190,172,189,217,205,204,189,15,240,164,188,2,126,77,189,163,115,126,61,156,220,111,60,200,209,156,60,29,174,21,61,36,68,57,62,152,251,100,188,169,189,136,189,85,222,142,186,214,55,144,189,121,144,158,187,222,33,197,186,12,62,13,61,175,33,56,189,31,45,78,189,215,135,181,189,13,250,50,190,102,188,237,189,109,112,82,190,158,96,127,60,242,119,47,189,127,104,198,189,42,142,19,190,210,229,77,189,228,132,73,190,105,138,224,61,98,246,138,62,205,230,49,62,206,83,221,61,5,49,32,62,104,121,254,61,208,38,199,61,240,107,116,62,66,233,171,61,113,114,223,61,135,80,101,62,222,204,136,62,130,86,224,60,94,130,211,60,90,18,0,62,181,249,191,61,48,73,37,61,56,74,30,61,125,145,80,188,64,133,19,62,45,206,88,61,141,183,21,188,97,109,172,61,88,30,36,62,101,111,41,189,33,206,67,60,174,184,248,189,88,140,218,189,145,212,66,189,223,138,68,61,184,172,130,190,181,226,155,189,92,27,202,61,29,119,26,190,27,161,47,190,33,89,32,190,125,236,110,61,42,254,63,62,24,119,211,62,80,228,13,63,129,150,190,62,84,167,115,62,21,31,255,61,81,250,226,61,155,29,41,60,25,170,50,190,6,128,138,189,28,178,1,187,201,87,18,62,10,73,38,61,1,20,163,60,91,176,212,60,47,134,50,189,87,66,247,189,197,171,204,61,36,125,186,61,12,62,125,62,159,32,81,62,197,29,47,189,172,115,140,189,82,183,243,189,25,232,218,60,5,194,14,61,238,149,121,189,12,62,205,188,106,132,190,189,59,226,16,189,87,206,110,190,112,67,76,189,205,92,32,189,115,130,182,188,243,229,133,189,67,5,17,193,24,143,13,0,85,201,5,0,154,190,5,0,162,3,0,0,1,0,0,0,36,143,13,0,116,203,5,0,154,190,5,0,200,4,0,0,1,0,0,0,0,0,0,0,232,70,0,0,47,0,0,0,222,2,0,0,223,2,0,0,0,0,0,0,200,70,0,0,30,0,0,0,224,2,0,0,172,0,0,0,28,143,13,0,38,202,5,0,154,190,5,0,123,4,0,0,1,0,0,0,0,0,0,0,216,70,0,0,225,2,0,0,226,2,0,0,173,0,0,0,32,143,13,0,177,202,5,0,154,190,5,0,199,3,0,0,1,0,0,0,40,143,13,0,209,210,5,0,141,210,5,0,46,0,0,0,1,0,0,0,44,143,13,0,9,211,5,0,141,210,5,0,113,0,0,0,1,0,0,0,0,0,0,0,248,70,0,0,227,2,0,0,228,2,0,0,29,0,0,0,174,0,0,0,175,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,1,0,0,0,176,0,0,0,21,0,0,0,177,0,0,0,22,0,0,0,178,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,7,0,0,0,7,0,0,0,8,0,0,0,8,0,0,0,23,0,0,0,179,0,0,0,24,0,0,0,180,0,0,0,9,0,0,0,9,0,0,0,48,143,13,0,8,212,5,0,190,211,5,0,119,3,0,0,1,0,0,0,52,143,13,0,112,212,5,0,190,211,5,0,119,3,0,0,1,0,0,0,56,143,13,0,216,212,5,0,190,211,5,0,119,3,0,0,1,0,0,0,60,143,13,0,72,213,5,0,190,211,5,0,119,3,0,0,1,0,0,0,64,143,13,0,16,214,5,0,190,211,5,0,79,3,0,0,1,0,0,0,0,0,0,0,8,71,0,0,30,0,0,0,229,2,0,0,181,0,0,0,0,0,0,0,24,71,0,0,47,0,0,0,230,2,0,0,231,2,0,0,0,0,0,0,40,71,0,0,30,0,0,0,232,2,0,0,182,0,0,0,68,143,13,0,131,216,5,0,62,216,5,0,183,0,0,0,1,0,0,0,72,143,13,0,103,217,5,0,62,216,5,0,191,2,0,0,1,0,0,0,0,0,0,0,72,71,0,0,27,0,0,0,233,2,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,52,0,0,0,183,0,0,0,184,0,0,0,25,0,0,0,185,0,0,0,186,0,0,0,187,0,0,0,26,0,0,0,188,0,0,0,10,0,0,0,10,0,0,0,0,0,0,0,56,71,0,0,47,0,0,0,234,2,0,0,235,2,0,0,76,143,13,0,29,221,5,0,62,216,5,0,203,4,0,0,1,0,0,0,80,143,13,0,92,223,5,0,62,216,5,0,218,5,0,0,1,0,0,0,88,143,13,0,203,225,5,0,179,224,5,0,165,4,0,0,1,0,0,0,0,0,0,0,136,71,0,0,27,0,0,0,236,2,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,38,0,0,0,237,2,0,0,27,0,0,0,189,0,0,0,11,0,0,0,11,0,0,0,28,0,0,0,190,0,0,0,29,0,0,0,191,0,0,0,30,0,0,0,192,0,0,0,31,0,0,0,193,0,0,0,12,0,0,0,12,0,0,0,32,0,0,0,194,0,0,0,0,0,0,0,120,71,0,0,47,0,0,0,238,2,0,0,239,2,0,0,84,143,13,0,248,224,5,0,179,224,5,0,75,4,0,0,1,0,0,0,41,92,15,62,41,92,15,62,102,247,228,62,102,247,228,62,102,247,228,62,108,143,13,0,87,229,5,0,121,226,5,0,87,0,0,0,1,0,0,0,104,143,13,0,217,228,5,0,121,226,5,0,61,1,0,0,1,0,0,0,0,0,0,0,184,71,0,0,240,2,0,0,241,2,0,0,242,2,0,0,112,143,13,0,200,229,5,0,121,226,5,0,98,0,0,0,1,0,0,0,108,0,0,0,0,0,0,0,0,72,0,0,243,2,0,0,244,2,0,0,148,255,255,255,148,255,255,255,0,72,0,0,245,2,0,0,246,2,0,0,72,169,1,0,212,71,0,0,232,71,0,0,92,169,1,0,0,0,0,0,240,71,0,0,247,2,0,0,248,2,0,0,195,0,0,0,12,0,0,0,78,0,0,0,39,0,0,0,33,0,0,0,3,0,0,0,2,0,0,0,34,0,0,0,5,0,0,0,23,0,0,0,3,0,0,0,24,0,0,0,176,251,5,0,98,245,5,0,66,5,0,0,1,0,0,0,190,185,17,0,143,253,5,0,121,6,6,0,176,251,5,0,98,245,5,0,67,5,0,0,1,0,0,0,190,185,17,0,130,253,5,0,121,6,6,0,176,251,5,0,98,245,5,0,155,6,0,0,1,0,0,0,190,185,17,0,238,252,5,0,121,6,6,0,176,251,5,0,98,245,5,0,155,6,0,0,1,0,0,0,190,185,17,0,222,252,5,0,149,6,6,0,176,251,5,0,98,245,5,0,163,6,0,0,1,0,0,0,190,185,17,0,202,252,5,0,121,6,6,0,176,251,5,0,98,245,5,0,163,6,0,0,1,0,0,0,190,185,17,0,181,252,5,0,65,251,6,0,176,251,5,0,98,245,5,0,164,6,0,0,1,0,0,0,190,185,17,0,162,252,5,0,121,6,6,0,176,251,5,0,98,245,5,0,164,6,0,0,1,0,0,0,190,185,17,0,142,252,5,0,65,251,6,0,176,251,5,0,98,245,5,0,6,7,0,0,1,0,0,0,190,185,17,0,126,252,5,0,121,6,6,0,176,251,5,0,98,245,5,0,6,7,0,0,1,0,0,0,190,185,17,0,109,252,5,0,149,6,6,0,176,251,5,0,98,245,5,0,60,7,0,0,1,0,0,0,190,185,17,0,92,252,5,0,65,251,6,0,176,251,5,0,98,245,5,0,60,7,0,0,1,0,0,0,190,185,17,0,76,252,5,0,116,11,7,0,176,251,5,0,98,245,5,0,61,7,0,0,1,0,0,0,190,185,17,0,59,252,5,0,65,251,6,0,176,251,5,0,98,245,5,0,61,7,0,0,1,0,0,0,190,185,17,0,43,252,5,0,116,11,7,0,0,0,0,0,184,73,0,0,47,0,0,0,249,2,0,0,250,2,0,0,0,0,0,0,152,73,0,0,47,0,0,0,251,2,0,0,252,2,0,0,0,0,0,0,120,73,0,0,47,0,0,0,253,2,0,0,254,2,0,0,0,0,0,0,88,73,0,0,47,0,0,0,255,2,0,0,0,3,0,0,0,0,0,0,56,73,0,0,47,0,0,0,1,3,0,0,2,3,0,0,0,0,0,0,24,73,0,0,47,0,0,0,3,3,0,0,4,3,0,0,0,0,0,0,248,72,0,0,47,0,0,0,5,3,0,0,6,3,0,0,0,0,0,0,216,72,0,0,47,0,0,0,7,3,0,0,8,3,0,0,0,0,0,0,184,72,0,0,47,0,0,0,9,3,0,0,10,3,0,0,0,0,0,0,152,72,0,0,47,0,0,0,11,3,0,0,12,3,0,0,0,0,0,0,120,72,0,0,47,0,0,0,13,3,0,0,14,3,0,0,0,0,0,0,88,72,0,0,47,0,0,0,15,3,0,0,16,3,0,0,0,0,0,0,48,72,0,0,47,0,0,0,17,3,0,0,18,3,0,0,0,0,0,0,64,72,0,0,10,0,0,0,40,0,0,0,0,0,0,0,72,72,0,0,10,0,0,0,40,0,0,0,0,0,0,0,104,72,0,0,10,0,0,0,41,0,0,0,194,5,6,0,64,3,6,0,84,2,0,0,1,0,0,0,190,185,17,0,130,6,6,0,149,6,6,0,194,5,6,0,64,3,6,0,84,2,0,0,1,0,0,0,190,185,17,0,103,6,6,0,121,6,6,0,0,0,0,0,136,72,0,0,10,0,0,0,40,0,0,0,0,0,0,0,168,72,0,0,10,0,0,0,42,0,0,0,0,0,0,0,200,72,0,0,10,0,0,0,43,0,0,0,0,0,0,0,232,72,0,0,10,0,0,0,40,0,0,0,0,0,0,0,8,73,0,0,10,0,0,0,44,0,0,0,0,0,0,0,40,73,0,0,11,0,0,0,40,0,0,0,0,0,0,0,72,73,0,0,10,0,0,0,40,0,0,0,0,0,0,0,104,73,0,0,10,0,0,0,40,0,0,0,0,0,0,0,136,73,0,0,10,0,0,0,40,0,0,0,0,0,0,0,168,73,0,0,10,0,0,0,45,0,0,0,101,14,6,0,64,3,6,0,3,1,0,0,1,0,0,0,190,185,17,0,25,15,6,0,65,251,6,0,101,14,6,0,64,3,6,0,3,1,0,0,1,0,0,0,190,185,17,0,11,15,6,0,116,11,7,0,0,0,0,0,200,73,0,0,10,0,0,0,46,0,0,0,205,15,6,0,64,3,6,0,224,0,0,0,1,0,0,0,190,185,17,0,25,15,6,0,65,251,6,0,205,15,6,0,64,3,6,0,224,0,0,0,1,0,0,0,190,185,17,0,11,15,6,0,116,11,7,0,0,0,0,0,216,73,0,0,47,0,0,0,19,3,0,0,20,3,0,0,224,25,6,0,228,25,6,0,234,25,6,0,241,25,6,0,0,0,0,0,116,143,13,0,129,27,6,0,161,16,6,0,123,0,0,0,1,0,0,0,0,0,0,0,232,73,0,0,47,0,0,0,21,3,0,0,22,3,0,0,124,143,13,0,50,29,6,0,161,16,6,0,211,4,0,0,1,0,0,0,120,143,13,0,203,28,6,0,161,16,6,0,181,4,0,0,1,0,0,0,35,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,196,0,0,0,23,3,0,0,36,0,0,0,24,3,0,0,25,3,0,0,132,143,13,0,131,34,6,0,49,34,6,0,80,0,0,0,1,0,0,0,128,143,13,0,177,33,6,0,49,34,6,0,99,0,0,0,1,0,0,0,136,143,13,0,236,34,6,0,49,34,6,0,72,0,0,0,1,0,0,0,0,0,0,0,248,73,0,0,26,3,0,0,27,3,0,0,1,0,0,0,1,0,0,0,79,0,0,0,47,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,37,0,0,0,5,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,0,0,0,0,8,74,0,0,28,3,0,0,29,3,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,1,0,0,0,48,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,29,0,0,0,21,0,0,0,152,143,13,0,177,36,6,0,149,35,6,0,127,12,0,0,1,0,0,0,148,143,13,0,85,53,7,0,0,0,0,0,144,143,13,0,53,36,6,0,149,35,6,0,135,12,0,0,1,0,0,0,140,143,13,0,85,53,7,0,0,0,0,0,168,143,13,0,191,40,6,0,149,35,6,0,106,0,0,0,1,0,0,0,164,143,13,0,59,40,6,0,149,35,6,0,115,0,0,0,1,0,0,0,160,143,13,0,40,39,6,0,149,35,6,0,132,0,0,0,1,0,0,0,40,39,6,0,149,35,6,0,133,0,0,0,0,0,0,0,235,39,6,0,16,40,6,0,23,40,6,0,40,39,6,0,149,35,6,0,136,0,0,0,1,0,0,0,173,39,6,0,219,39,6,0,231,39,6,0,0,0,0,0,32,74,0,0,47,0,0,0,31,3,0,0,32,3,0,0,0,0,0,0,64,74,0,0,33,3,0,0,34,3,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,58,0,0,0,49,0,0,0,50,0,0,0,27,0,0,0,32,0,0,0,33,0,0,0,54,0,0,0,59,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,30,0,0,0,21,0,0,0,0,0,0,0,48,74,0,0,47,0,0,0,35,3,0,0,36,3,0,0,176,143,13,0,50,42,6,0,149,35,6,0,179,1,0,0,1,0,0,0,172,143,13,0,85,53,7,0,0,0,0,0,224,42,6,0,149,35,6,0,199,1,0,0,1,0,0,0,190,185,17,0,95,43,6,0,116,11,7,0,184,143,13,0,189,44,6,0,149,35,6,0,111,9,0,0,1,0,0,0,180,143,13,0,42,44,6,0,149,35,6,0,114,1,0,0,1,0,0,0,188,143,13,0,213,45,6,0,149,35,6,0,138,9,0,0,1,0,0,0,224,143,13,0,53,47,6,0,149,35,6,0,147,1,0,0,1,0,0,0,220,143,13,0,118,46,6,0,0,0,0,0,216,143,13,0,123,46,6,0,149,35,6,0,35,13,0,0,1,0,0,0,212,143,13,0,118,46,6,0,0,0,0,0,24,144,13,0,45,63,6,0,149,35,6,0,157,9,0,0,1,0,0,0,228,143,13,0,71,48,6,0,149,35,6,0,20,9,0,0,1,0,0,0,236,143,13,0,124,50,6,0,149,35,6,0,182,8,0,0,1,0,0,0,232,143,13,0,16,50,6,0,149,35,6,0,1,8,0,0,1,0,0,0,20,144,13,0,212,62,6,0,149,35,6,0,22,4,0,0,1,0,0,0,248,143,13,0,53,55,6,0,149,35,6,0,203,4,0,0,1,0,0,0,240,143,13,0,50,54,6,0,149,35,6,0,53,5,0,0,1,0,0,0,244,143,13,0,240,54,6,0,149,35,6,0,216,4,0,0,1,0,0,0,12,144,13,0,60,62,6,0,149,35,6,0,207,7,0,0,1,0,0,0,8,144,13,0,1,62,6,0,149,35,6,0,62,3,0,0,1,0,0,0,252,143,13,0,208,58,6,0,149,35,6,0,121,6,0,0,1,0,0,0,0,0,0,0,176,74,0,0,47,0,0,0,37,3,0,0,38,3,0,0,0,0,0,0,80,74,0,0,39,3,0,0,40,3,0,0,41,3,0,0,42,3,0,0,4,144,13,0,164,61,6,0,149,35,6,0,9,6,0,0,1,0,0,0,0,144,13,0,193,60,6,0,149,35,6,0,240,2,0,0,1,0,0,0,16,144,13,0,155,62,6,0,149,35,6,0,247,3,0,0,1,0,0,0,28,144,13,0,154,63,6,0,149,35,6,0,173,9,0,0,1,0,0,0,32,144,13,0,246,63,6,0,149,35,6,0,245,9,0,0,1,0,0,0,36,144,13,0,91,64,6,0,149,35,6,0,86,10,0,0,1,0,0,0,44,144,13,0,204,64,6,0,149,35,6,0,93,10,0,0,1,0,0,0,40,144,13,0,85,53,7,0,0,0,0,0,52,144,13,0,95,65,6,0,149,35,6,0,255,12,0,0,1,0,0,0,48,144,13,0,118,46,6,0,0,0,0,0,64,144,13,0,195,66,6,0,2,67,6,0,77,0,0,0,1,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,24,0,0,0,40,0,0,0,56,0,0,0,72,0,0,0,88,0,0,0,104,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,20,0,0,0,255,255,255,255,24,0,0,0,32,0,0,0,40,0,0,0,44,0,0,0,48,0,0,0,52,0,0,0,56,0,0,0,60,0,0,0,64,0,0,0,68,0,0,0,8,0,0,0,16,0,0,0,20,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,4,0,0,0,8,0,0,0,0,0,0,0,1,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,44,0,0,0,8,0,0,0,0,0,0,0,208,74,0,0,43,3,0,0,44,3,0,0,197,0,0,0,38,0,0,0,34,0,0,0,39,0,0,0,40,0,0,0,45,3,0,0,41,0,0,0,198,0,0,0,199,0,0,0,35,0,0,0,42,0,0,0,200,0,0,0,36,0,0,0,43,0,0,0,22,0,0,0,44,0,0,0,201,0,0,0,202,0,0,0,46,3,0,0,45,0,0,0,203,0,0,0,46,0,0,0,204,0,0,0,0,0,0,0,255,255,255,255,124,0,0,0,12,0,0,0,255,255,255,255,24,0,0,0,28,0,0,0,35,0,0,0,24,0,0,0,37,0,0,0,255,255,255,255,52,0,0,0,72,12,8,0,200,12,8,0,16,13,8,0,40,13,8,0,0,0,0,0,24,75,0,0,47,3,0,0,48,3,0,0,197,0,0,0,47,0,0,0,37,0,0,0,48,0,0,0,49,0,0,0,49,3,0,0,50,0,0,0,198,0,0,0,199,0,0,0,38,0,0,0,51,0,0,0,205,0,0,0,36,0,0,0,52,0,0,0,23,0,0,0,44,0,0,0,206,0,0,0,207,0,0,0,46,3,0,0,45,0,0,0,208,0,0,0,46,0,0,0,209,0,0,0,0,0,0,0,40,75,0,0,50,3,0,0,51,3,0,0,210,0,0,0,53,0,0,0,39,0,0,0,54,0,0,0,55,0,0,0,52,3,0,0,56,0,0,0,198,0,0,0,211,0,0,0,40,0,0,0,57,0,0,0,212,0,0,0,36,0,0,0,58,0,0,0,24,0,0,0,44,0,0,0,213,0,0,0,214,0,0,0,46,3,0,0,59,0,0,0,215,0,0,0,46,0,0,0,216,0,0,0,60,0,0,0,61,0,0,0,0,0,0,0,240,74,0,0,53,3,0,0,54,3,0,0,197,0,0,0,62,0,0,0,41,0,0,0,63,0,0,0,64,0,0,0,55,3,0,0,65,0,0,0,198,0,0,0,199,0,0,0,42,0,0,0,66,0,0,0,217,0,0,0,36,0,0,0,67,0,0,0,25,0,0,0,44,0,0,0,218,0,0,0,219,0,0,0,46,3,0,0,45,0,0,0,220,0,0,0,46,0,0,0,221,0,0,0,0,0,0,0,224,74,0,0,56,3,0,0,57,3,0,0,43,0,0,0,26,0,0,0,44,0,0,0,27,0,0,0,222,0,0,0,223,0,0,0,68,0,0,0,69,0,0,0,58,3,0,0,59,3,0,0,224,0,0,0,225,0,0,0,60,0,0,0,226,0,0,0,70,0,0,0,71,0,0,0,227,0,0,0,0,0,0,0,112,75,0,0,50,3,0,0,60,3,0,0,210,0,0,0,53,0,0,0,39,0,0,0,54,0,0,0,55,0,0,0,52,3,0,0,56,0,0,0,198,0,0,0,211,0,0,0,40,0,0,0,57,0,0,0,212,0,0,0,36,0,0,0,58,0,0,0,24,0,0,0,44,0,0,0,213,0,0,0,214,0,0,0,46,3,0,0,59,0,0,0,215,0,0,0,46,0,0,0,216,0,0,0,72,0,0,0,73,0,0,0,0,0,0,0,56,75,0,0,50,3,0,0,61,3,0,0,210,0,0,0,53,0,0,0,39,0,0,0,54,0,0,0,55,0,0,0,52,3,0,0,56,0,0,0,198,0,0,0,211,0,0,0,40,0,0,0,57,0,0,0,212,0,0,0,36,0,0,0,58,0,0,0,24,0,0,0,44,0,0,0,213,0,0,0,228,0,0,0,46,3,0,0,59,0,0,0,215,0,0,0,46,0,0,0,1,0,0,0,60,0,0,0,61,0,0,0,0,0,0,0,72,75,0,0,62,3,0,0,63,3,0,0,210,0,0,0,53,0,0,0,39,0,0,0,54,0,0,0,55,0,0,0,52,3,0,0,56,0,0,0,198,0,0,0,211,0,0,0,40,0,0,0,57,0,0,0,212,0,0,0,36,0,0,0,58,0,0,0,24,0,0,0,44,0,0,0,213,0,0,0,228,0,0,0,46,3,0,0,59,0,0,0,215,0,0,0,46,0,0,0,1,0,0,0,60,0,0,0,61,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,160,0,0,0,156,0,0,0,164,0,0,0,152,0,0,0,136,0,0,0,8,0,0,0,24,0,0,0,40,0,0,0,56,0,0,0,72,0,0,0,88,0,0,0,104,0,0,0,120,0,0,0,0,0,0,0,128,75,0,0,64,3,0,0,65,3,0,0,197,0,0,0,74,0,0,0,45,0,0,0,75,0,0,0,76,0,0,0,66,3,0,0,77,0,0,0,198,0,0,0,199,0,0,0,46,0,0,0,78],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+102400);allocate([229,0,0,0,36,0,0,0,79,0,0,0,28,0,0,0,44,0,0,0,230,0,0,0,231,0,0,0,46,3,0,0,45,0,0,0,232,0,0,0,46,0,0,0,233,0,0,0,0,0,0,0,255,255,255,255,172,0,0,0,128,13,8,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,28,0,0,0,32,0,0,0,24,0,0,0,16,0,0,0,20,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,4,0,0,0,8,0,0,0,0,0,0,0,1,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,60,0,0,0,64,0,0,0,8,0,0,0,68,0,0,0,24,0,0,0,0,0,0,0,144,75,0,0,67,3,0,0,68,3,0,0,197,0,0,0,80,0,0,0,47,0,0,0,81,0,0,0,82,0,0,0,69,3,0,0,83,0,0,0,198,0,0,0,199,0,0,0,48,0,0,0,84,0,0,0,234,0,0,0,36,0,0,0,85,0,0,0,29,0,0,0,44,0,0,0,235,0,0,0,236,0,0,0,46,3,0,0,45,0,0,0,237,0,0,0,46,0,0,0,238,0,0,0,0,0,0,0,255,255,255,255,40,0,0,0,9,0,0,0,16,0,0,0,24,0,0,0,18,0,0,0,255,255,255,255,76,0,0,0,56,14,8,0,96,14,8,0,120,14,8,0,0,0,0,0,224,75,0,0,70,3,0,0,71,3,0,0,197,0,0,0,86,0,0,0,49,0,0,0,87,0,0,0,88,0,0,0,72,3,0,0,89,0,0,0,198,0,0,0,199,0,0,0,50,0,0,0,90,0,0,0,239,0,0,0,36,0,0,0,91,0,0,0,30,0,0,0,44,0,0,0,240,0,0,0,241,0,0,0,46,3,0,0,45,0,0,0,242,0,0,0,46,0,0,0,243,0,0,0,0,0,0,0,160,75,0,0,73,3,0,0,74,3,0,0,51,0,0,0,31,0,0,0,52,0,0,0,27,0,0,0,222,0,0,0,223,0,0,0,92,0,0,0,93,0,0,0,75,3,0,0,76,3,0,0,224,0,0,0,225,0,0,0,60,0,0,0,226,0,0,0,94,0,0,0,95,0,0,0,244,0,0,0,0,0,0,0,176,75,0,0,77,3,0,0,78,3,0,0,245,0,0,0,96,0,0,0,53,0,0,0,97,0,0,0,55,0,0,0,79,3,0,0,98,0,0,0,198,0,0,0,246,0,0,0,54,0,0,0,99,0,0,0,247,0,0,0,36,0,0,0,100,0,0,0,32,0,0,0,44,0,0,0,213,0,0,0,248,0,0,0,46,3,0,0,101,0,0,0,215,0,0,0,46,0,0,0,249,0,0,0,102,0,0,0,103,0,0,0,0,0,0,0,208,75,0,0,77,3,0,0,80,3,0,0,245,0,0,0,96,0,0,0,53,0,0,0,97,0,0,0,55,0,0,0,79,3,0,0,98,0,0,0,198,0,0,0,246,0,0,0,54,0,0,0,99,0,0,0,247,0,0,0,36,0,0,0,100,0,0,0,32,0,0,0,44,0,0,0,213,0,0,0,228,0,0,0,46,3,0,0,101,0,0,0,215,0,0,0,46,0,0,0,1,0,0,0,102,0,0,0,103,0,0,0,0,0,0,0,192,75,0,0,81,3,0,0,82,3,0,0,245,0,0,0,96,0,0,0,53,0,0,0,97,0,0,0,55,0,0,0,79,3,0,0,98,0,0,0,198,0,0,0,246,0,0,0,54,0,0,0,99,0,0,0,247,0,0,0,36,0,0,0,100,0,0,0,32,0,0,0,44,0,0,0,213,0,0,0,228,0,0,0,46,3,0,0,101,0,0,0,215,0,0,0,46,0,0,0,1,0,0,0,102,0,0,0,103,0,0,0,0,0,0,0,240,75,0,0,77,3,0,0,83,3,0,0,245,0,0,0,96,0,0,0,53,0,0,0,97,0,0,0,55,0,0,0,79,3,0,0,98,0,0,0,198,0,0,0,246,0,0,0,54,0,0,0,99,0,0,0,247,0,0,0,36,0,0,0,100,0,0,0,32,0,0,0,44,0,0,0,213,0,0,0,248,0,0,0,46,3,0,0,101,0,0,0,215,0,0,0,46,0,0,0,249,0,0,0,104,0,0,0,105,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,8,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,24,0,0,0,0,0,0,0,0,76,0,0,84,3,0,0,85,3,0,0,197,0,0,0,106,0,0,0,55,0,0,0,107,0,0,0,108,0,0,0,86,3,0,0,109,0,0,0,198,0,0,0,199,0,0,0,56,0,0,0,110,0,0,0,250,0,0,0,36,0,0,0,111,0,0,0,33,0,0,0,44,0,0,0,251,0,0,0,252,0,0,0,46,3,0,0,45,0,0,0,253,0,0,0,46,0,0,0,254,0,0,0,0,0,0,0,255,255,255,255,32,0,0,0,7,0,0,0,255,255,255,255,32,0,0,0,224,14,8,0,0,15,8,0,0,0,0,0,16,76,0,0,87,3,0,0,88,3,0,0,197,0,0,0,112,0,0,0,57,0,0,0,113,0,0,0,114,0,0,0,89,3,0,0,115,0,0,0,198,0,0,0,199,0,0,0,58,0,0,0,116,0,0,0,255,0,0,0,36,0,0,0,117,0,0,0,34,0,0,0,44,0,0,0,0,1,0,0,1,1,0,0,46,3,0,0,45,0,0,0,2,1,0,0,46,0,0,0,3,1,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,84,0,0,0,16,0,0,0,32,0,0,0,48,0,0,0,64,0,0,0,104,0,0,0,80,0,0,0,88,0,0,0,92,0,0,0,96,0,0,0,100,0,0,0,1,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,6,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,16,0,0,0,21,0,0,0,24,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,88,0,0,0,92,0,0,0,16,0,0,0,120,0,0,0,121,0,0,0,28,0,0,0,96,0,0,0,100,0,0,0,104,0,0,0,108,0,0,0,112,0,0,0,116,0,0,0,124,0,0,0,40,0,0,0,52,0,0,0,64,0,0,0,76,0,0,0,0,0,0,0,1,0,0,0,255,255,255,255,8,0,0,0,9,0,0,0,255,255,255,255,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,10,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,48,0,0,0,28,0,0,0,16,0,0,0,20,0,0,0,44,0,0,0,32,0,0,0,40,0,0,0,36,0,0,0,49,0,0,0,2,0,0,0,8,0,0,0,3,0,0,0,0,0,0,0,1,0,0,0,7,0,0,0,4,0,0,0,6,0,0,0,5,0,0,0,9,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,32,0,0,0,36,0,0,0,40,0,0,0,28,0,0,0,44,0,0,0,16,0,0,0,48,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,0,0,0,0,4,0,0,0,255,255,255,255,5,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,40,0,0,0,28,0,0,0,44,0,0,0,36,0,0,0,32,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,6,0,0,0,3,0,0,0,7,0,0,0,5,0,0,0,4,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,92,0,0,0,32,0,0,0,60,0,0,0,48,0,0,0,100,0,0,0,96,0,0,0,101,0,0,0,76,0,0,0,16,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,2,0,0,0,1,0,0,0,3,0,0,0,255,255,255,255,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,100,0,0,0,116,0,0,0,88,0,0,0,16,0,0,0,112,0,0,0,44,0,0,0,120,0,0,0,60,0,0,0,32,0,0,0,124,0,0,0,168,0,0,0,196,0,0,0,128,0,0,0,132,0,0,0,204,0,0,0,136,0,0,0,212,0,0,0,92,0,0,0,140,0,0,0,144,0,0,0,148,0,0,0,152,0,0,0,104,0,0,0,156,0,0,0,76,0,0,0,208,0,0,0,160,0,0,0,96,0,0,0,169,0,0,0,216,0,0,0,192,0,0,0,164,0,0,0,184,0,0,0,108,0,0,0,200,0,0,0,176,0,0,0,220,0,0,0,170,0,0,0,197,0,0,0,172,0,0,0,3,0,0,0,7,0,0,0,0,0,0,0,255,255,255,255,6,0,0,0,255,255,255,255,8,0,0,0,255,255,255,255,255,255,255,255,9,0,0,0,20,0,0,0,27,0,0,0,10,0,0,0,11,0,0,0,30,0,0,0,12,0,0,0,32,0,0,0,1,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,4,0,0,0,17,0,0,0,255,255,255,255,31,0,0,0,18,0,0,0,2,0,0,0,21,0,0,0,33,0,0,0,26,0,0,0,19,0,0,0,25,0,0,0,5,0,0,0,29,0,0,0,24,0,0,0,34,0,0,0,22,0,0,0,28,0,0,0,23,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,36,0,0,0,32,0,0,0,16,0,0,0,40,0,0,0,1,0,0,0,0,0,0,0,255,255,255,255,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,36,0,0,0,32,0,0,0,16,0,0,0,1,0,0,0,0,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,48,0,0,0,52,0,0,0,56,0,0,0,16,0,0,0,32,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,255,255,255,255,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,28,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,136,0,0,0,140,0,0,0,16,0,0,0,32,0,0,0,104,1,0,0,48,0,0,0,60,0,0,0,76,0,0,0,124,0,0,0,92,0,0,0,108,0,0,0,144,0,0,0,148,0,0,0,152,0,0,0,156,0,0,0,44,1,0,0,52,1,0,0,160,0,0,0,164,0,0,0,168,0,0,0,64,1,0,0,172,0,0,0,76,1,0,0,176,0,0,0,180,0,0,0,184,0,0,0,48,1,0,0,36,1,0,0,188,0,0,0,28,1,0,0,192,0,0,0,196,0,0,0,200,0,0,0,204,0,0,0,208,0,0,0,212,0,0,0,60,1,0,0,24,1,0,0,216,0,0,0,220,0,0,0,224,0,0,0,84,1,0,0,80,1,0,0,68,1,0,0,228,0,0,0,232,0,0,0,12,1,0,0,88,1,0,0,92,1,0,0,96,1,0,0,8,1,0,0,72,1,0,0,32,1,0,0,236,0,0,0,20,1,0,0,100,1,0,0,56,1,0,0,240,0,0,0,244,0,0,0,16,1,0,0,248,0,0,0,252,0,0,0,0,1,0,0,40,1,0,0,4,1,0,0,0,0,0,0,1,0,0,0,255,255,255,255,255,255,255,255,56,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,41,0,0,0,43,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,46,0,0,0,9,0,0,0,49,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,42,0,0,0,39,0,0,0,13,0,0,0,37,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,45,0,0,0,36,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,51,0,0,0,50,0,0,0,47,0,0,0,23,0,0,0,24,0,0,0,33,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,32,0,0,0,48,0,0,0,38,0,0,0,25,0,0,0,35,0,0,0,55,0,0,0,44,0,0,0,26,0,0,0,27,0,0,0,34,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,40,0,0,0,31,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,40,0,0,0,36,0,0,0,32,0,0,0,28,0,0,0,16,0,0,0,37,0,0,0,38,0,0,0,5,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,255,255,255,255,3,0,0,0,4,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,24,0,0,0,20,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,24,0,0,0,16,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,24,0,0,0,20,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,16,0,0,0,1,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,17,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,24,0,0,0,16,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,16,0,0,0,1,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,72,0,0,0,112,0,0,0,16,0,0,0,28,0,0,0,40,0,0,0,52,0,0,0,76,0,0,0,80,0,0,0,84,0,0,0,88,0,0,0,92,0,0,0,96,0,0,0,116,0,0,0,64,0,0,0,68,0,0,0,100,0,0,0,108,0,0,0,104,0,0,0,2,0,0,0,12,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,13,0,0,0,0,0,0,0,1,0,0,0,9,0,0,0,11,0,0,0,10,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,16,0,0,0,0,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,24,0,0,0,32,0,0,0,40,0,0,0,44,0,0,0,20,0,0,0,28,0,0,0,36,0,0,0,37,0,0,0,48,0,0,0,0,0,0,0,2,0,0,0,4,0,0,0,7,0,0,0,8,0,0,0,1,0,0,0,3,0,0,0,5,0,0,0,6,0,0,0,9,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,16,0,0,0,24,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,28,0,0,0,32,0,0,0,36,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,80,0,0,0,32,0,0,0,44,0,0,0,56,0,0,0,68,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,16,0,0,0,32,0,0,0,0,0,0,0,255,255,255,255,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,28,0,0,0,32,0,0,0,16,0,0,0,20,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,24,0,0,0,16,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,56,0,0,0,32,0,0,0,36,0,0,0,40,0,0,0,44,0,0,0,48,0,0,0,52,0,0,0,20,0,0,0,28,0,0,0,37,0,0,0,24,0,0,0,0,0,0,0,11,0,0,0,4,0,0,0,5,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,1,0,0,0,3,0,0,0,6,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,29,0,0,0,16,0,0,0,20,0,0,0,32,0,0,0,28,0,0,0,2,0,0,0,4,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,3,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,24,0,0,0,16,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,28,0,0,0,32,0,0,0,16,0,0,0,36,0,0,0,20,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,5,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,28,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,17,0,0,0,16,0,0,0,20,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,24,0,0,0,44,0,0,0,48,0,0,0,20,0,0,0,28,0,0,0,32,0,0,0,60,0,0,0,36,0,0,0,40,0,0,0,52,0,0,0,56,0,0,0,64,0,0,0,0,0,0,0,2,0,0,0,7,0,0,0,8,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,11,0,0,0,5,0,0,0,6,0,0,0,9,0,0,0,10,0,0,0,12,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,24,0,0,0,16,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,28,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,16,0,0,0,20,0,0,0,28,0,0,0,29,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,3,0,0,0,4,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,16,0,0,0,24,0,0,0,1,0,0,0,0,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,28,0,0,0,32,0,0,0,16,0,0,0,24,0,0,0,20,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,32,0,0,0,16,0,0,0,28,0,0,0,1,0,0,0,255,255,255,255,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,16,0,0,0,1,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,48,0,0,0,20,0,0,0,32,0,0,0,36,0,0,0,40,0,0,0,52,0,0,0,56,0,0,0,60,0,0,0,44,0,0,0,24,0,0,0,41,0,0,0,28,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,8,0,0,0,2,0,0,0,7,0,0,0,3,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,32,0,0,0,160,0,0,0,88,0,0,0,104,0,0,0,32,1,0,0,48,0,0,0,132,0,0,0,148,0,0,0,64,0,0,0,76,0,0,0,120,0,0,0,240,0,0,0,224,0,0,0,168,0,0,0,20,1,0,0,172,0,0,0,176,0,0,0,180,0,0,0,236,0,0,0,228,0,0,0,24,1,0,0,184,0,0,0,188,0,0,0,244,0,0,0,192,0,0,0,196,0,0,0,200,0,0,0,204,0,0,0,220,0,0,0,0,1,0,0,208,0,0,0,216,0,0,0,248,0,0,0,12,1,0,0,16,1,0,0,252,0,0,0,8,1,0,0,232,0,0,0,212,0,0,0,4,1,0,0,28,1,0,0,164,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,255,255,255,255,255,255,255,255,32,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,16,0,0,0,2,0,0,0,29,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,19,0,0,0,17,0,0,0,30,0,0,0,6,0,0,0,7,0,0,0,21,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,15,0,0,0,24,0,0,0,12,0,0,0,14,0,0,0,22,0,0,0,27,0,0,0,28,0,0,0,23,0,0,0,26,0,0,0,18,0,0,0,13,0,0,0,25,0,0,0,31,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,56,0,0,0,60,0,0,0,88,0,0,0,144,0,0,0,76,0,0,0,80,0,0,0,92,0,0,0,96,0,0,0,148,0,0,0,152,0,0,0,100,0,0,0,156,0,0,0,160,0,0,0,164,0,0,0,168,0,0,0,176,0,0,0,64,0,0,0,172,0,0,0,68,0,0,0,104,0,0,0,108,0,0,0,116,0,0,0,16,0,0,0,32,0,0,0,44,0,0,0,120,0,0,0,180,0,0,0,184,0,0,0,188,0,0,0,124,0,0,0,72,0,0,0,128,0,0,0,132,0,0,0,136,0,0,0,112,0,0,0,117,0,0,0,140,0,0,0,84,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,23,0,0,0,5,0,0,0,6,0,0,0,9,0,0,0,10,0,0,0,24,0,0,0,25,0,0,0,11,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,31,0,0,0,2,0,0,0,30,0,0,0,3,0,0,0,12,0,0,0,13,0,0,0,15,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,17,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,18,0,0,0,4,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,14,0,0,0,16,0,0,0,22,0,0,0,7,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,28,0,0,0,32,0,0,0,36,0,0,0,40,0,0,0,44,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,40,0,0,0,44,0,0,0,48,0,0,0,16,0,0,0,28,0,0,0,52,0,0,0,56,0,0,0,60,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,255,255,255,255,255,255,255,255,3,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,32,76,0,0,90,3,0,0,91,3,0,0,197,0,0,0,118,0,0,0,59,0,0,0,119,0,0,0,55,0,0,0,92,3,0,0,120,0,0,0,198,0,0,0,199,0,0,0,60,0,0,0,121,0,0,0,4,1,0,0,36,0,0,0,122,0,0,0,35,0,0,0,44,0,0,0,5,1,0,0,6,1,0,0,46,3,0,0,45,0,0,0,7,1,0,0,46,0,0,0,8,1,0,0,0,0,0,0,6,0,0,0,32,0,0,0,7,0,0,0,23,0,0,0,108,0,0,0,34,0,0,0,40,0,0,0,32,0,0,0,41,0,0,0,47,0,0,0,28,0,0,0,48,0,0,0,57,0,0,0,28,0,0,0,61,0,0,0,83,0,0,0,128,0,0,0,100,0,0,0,115,0,0,0,52,0,0,0,125,0,0,0,137,0,0,0,52,0,0,0,144,0,0,0,157,0,0,0,48,0,0,0,165,0,0,0,179,0,0,0,104,0,0,0,188,0,0,0,233,0,0,0,232,0,0,0,17,1,0,0,26,1,0,0,44,0,0,0,30,1,0,0,38,1,0,0,40,0,0,0,41,1,0,0,51,1,0,0,60,0,0,0,56,1,0,0,65,1,0,0,32,0,0,0,69,1,0,0,139,1,0,0,112,1,0,0,204,1,0,0,216,1,0,0,44,0,0,0,223,1,0,0,231,1,0,0,28,0,0,0,234,1,0,0,242,1,0,0,28,0,0,0,245,1,0,0,253,1,0,0,28,0,0,0,0,2,0,0,7,2,0,0,24,0,0,0,9,2,0,0,18,2,0,0,28,0,0,0,22,2,0,0,30,2,0,0,28,0,0,0,33,2,0,0,40,2,0,0,24,0,0,0,42,2,0,0,65,2,0,0,120,0,0,0,83,2,0,0,90,2,0,0,32,0,0,0,92,2,0,0,107,2,0,0,52,0,0,0,117,2,0,0,125,2,0,0,28,0,0,0,128,2,0,0,139,2,0,0,40,0,0,0,145,2,0,0,152,2,0,0,24,0,0,0,154,2,0,0,165,2,0,0,96,0,0,0,171,2,0,0,179,2,0,0,36,0,0,0,182,2,0,0,188,2,0,0,20,0,0,0,189,2,0,0,199,2,0,0,36,0,0,0,204,2,0,0,212,2,0,0,28,0,0,0,215,2,0,0,222,2,0,0,24,0,0,0,224,2,0,0,232,2,0,0,28,0,0,0,235,2,0,0,241,2,0,0,20,0,0,0,242,2,0,0,248,2,0,0,20,0,0,0,249,2,0,0,10,3,0,0,60,0,0,0,22,3,0,0,28,3,0,0,20,0,0,0,29,3,0,0,40,3,0,0,36,0,0,0,46,3,0,0,52,3,0,0,32,0,0,0,53,3,0,0,61,3,0,0,28,0,0,0,64,3,0,0,75,3,0,0,40,0,0,0,81,3,0,0,90,3,0,0,32,0,0,0,94,3,0,0,102,3,0,0,24,0,0,0,105,3,0,0,111,3,0,0,20,0,0,0,112,3,0,0,130,3,0,0,68,0,0,0,143,3,0,0,151,3,0,0,28,0,0,0,154,3,0,0,163,3,0,0,32,0,0,0,167,3,0,0,177,3,0,0,32,0,0,0,182,3,0,0,190,3,0,0,28,0,0,0,193,3,0,0,200,3,0,0,24,0,0,0,202,3,0,0,210,3,0,0,28,0,0,0,213,3,0,0,223,3,0,0,36,0,0,0,228,3,0,0,234,3,0,0,20,0,0,0,235,3,0,0,243,3,0,0,36,0,0,0,246,3,0,0,253,3,0,0,24,0,0,0,255,3,0,0,5,4,0,0,20,0,0,0,6,4,0,0,13,4,0,0,24,0,0,0,15,4,0,0,21,4,0,0,20,0,0,0,22,4,0,0,40,4,0,0,64,0,0,0,53,4,0,0,61,4,0,0,28,0,0,0,64,4,0,0,112,4,0,0,40,1,0,0,155,4,0,0,198,4,0,0,196,0,0,0,236,4,0,0,243,4,0,0,24,0,0,0,245,4,0,0,2,5,0,0,48,0,0,0,10,5,0,0,18,5,0,0,28,0,0,0,21,5,0,0,34,5,0,0,64,0,0,0,42,5,0,0,50,5,0,0,28,0,0,0,48,15,8,0,80,15,8,0,192,15,8,0,224,15,8,0,0,16,8,0,32,16,8,0,160,16,8,0,216,16,8,0,16,17,8,0,64,17,8,0,168,17,8,0,144,18,8,0,192,18,8,0,232,18,8,0,40,19,8,0,72,19,8,0,184,20,8,0,232,20,8,0,8,21,8,0,40,21,8,0,72,21,8,0,96,21,8,0,128,21,8,0,160,21,8,0,184,21,8,0,48,22,8,0,80,22,8,0,136,22,8,0,168,22,8,0,208,22,8,0,232,22,8,0,72,23,8,0,112,23,8,0,136,23,8,0,176,23,8,0,208,23,8,0,232,23,8,0,8,24,8,0,32,24,8,0,56,24,8,0,120,24,8,0,144,24,8,0,184,24,8,0,216,24,8,0,248,24,8,0,32,25,8,0,64,25,8,0,88,25,8,0,112,25,8,0,184,25,8,0,216,25,8,0,248,25,8,0,24,26,8,0,56,26,8,0,80,26,8,0,112,26,8,0,152,26,8,0,176,26,8,0,216,26,8,0,240,26,8,0,8,27,8,0,32,27,8,0,56,27,8,0,120,27,8,0,152,27,8,0,192,28,8,0,136,29,8,0,160,29,8,0,208,29,8,0,240,29,8,0,48,30,8,0,0,0,0,0,48,76,0,0,93,3,0,0,94,3,0,0,197,0,0,0,123,0,0,0,61,0,0,0,119,0,0,0,55,0,0,0,95,3,0,0,124,0,0,0,198,0,0,0,199,0,0,0,62,0,0,0,125,0,0,0,9,1,0,0,36,0,0,0,126,0,0,0,36,0,0,0,44,0,0,0,10,1,0,0,11,1,0,0,46,3,0,0,45,0,0,0,12,1,0,0,46,0,0,0,13,1,0,0,0,0,0,0,64,76,0,0,96,3,0,0,97,3,0,0,197,0,0,0,127,0,0,0,63,0,0,0,119,0,0,0,55,0,0,0,98,3,0,0,128,0,0,0,198,0,0,0,199,0,0,0,64,0,0,0,129,0,0,0,14,1,0,0,36,0,0,0,130,0,0,0,37,0,0,0,44,0,0,0,15,1,0,0,16,1,0,0,46,3,0,0,45,0,0,0,17,1,0,0,46,0,0,0,18,1,0,0,0,0,0,0,80,76,0,0,99,3,0,0,100,3,0,0,197,0,0,0,131,0,0,0,65,0,0,0,119,0,0,0,55,0,0,0,101,3,0,0,132,0,0,0,198,0,0,0,199,0,0,0,66,0,0,0,133,0,0,0,19,1,0,0,36,0,0,0,134,0,0,0,38,0,0,0,44,0,0,0,20,1,0,0,21,1,0,0,46,3,0,0,45,0,0,0,22,1,0,0,46,0,0,0,23,1,0,0,0,0,0,0,96,76,0,0,102,3,0,0,103,3,0,0,197,0,0,0,135,0,0,0,67,0,0,0,119,0,0,0,55,0,0,0,104,3,0,0,136,0,0,0,198,0,0,0,199,0,0,0,68,0,0,0,137,0,0,0,24,1,0,0,36,0,0,0,138,0,0,0,39,0,0,0,44,0,0,0,25,1,0,0,26,1,0,0,46,3,0,0,45,0,0,0,27,1,0,0,46,0,0,0,28,1,0,0,0,0,0,0,112,76,0,0,105,3,0,0,106,3,0,0,197,0,0,0,139,0,0,0,69,0,0,0,119,0,0,0,55,0,0,0,107,3,0,0,140,0,0,0,198,0,0,0,199,0,0,0,70,0,0,0,141,0,0,0,29,1,0,0,36,0,0,0,142,0,0,0,40,0,0,0,44,0,0,0,30,1,0,0,31,1,0,0,46,3,0,0,45,0,0,0,32,1,0,0,46,0,0,0,33,1,0,0,0,0,0,0,128,76,0,0,108,3,0,0,109,3,0,0,197,0,0,0,143,0,0,0,71,0,0,0,119,0,0,0,55,0,0,0,110,3,0,0,144,0,0,0,198,0,0,0,199,0,0,0,72,0,0,0,145,0,0,0,34,1,0,0,36,0,0,0,146,0,0,0,41,0,0,0,44,0,0,0,35,1,0,0,36,1,0,0,46,3,0,0,45,0,0,0,37,1,0,0,46,0,0,0,38,1,0,0,0,0,0,0,144,76,0,0,111,3,0,0,112,3,0,0,197,0,0,0,147,0,0,0,73,0,0,0,119,0,0,0,55,0,0,0,113,3,0,0,148,0,0,0,198,0,0,0,199,0,0,0,74,0,0,0,149,0,0,0,39,1,0,0,36,0,0,0,150,0,0,0,42,0,0,0,44,0,0,0,40,1,0,0,41,1,0,0,46,3,0,0,45,0,0,0,42,1,0,0,46,0,0,0,43,1,0,0,0,0,0,0,160,76,0,0,114,3,0,0,115,3,0,0,197,0,0,0,151,0,0,0,75,0,0,0,119,0,0,0,55,0,0,0,116,3,0,0,152,0,0,0,198,0,0,0,199,0,0,0,76,0,0,0,153,0,0,0,44,1,0,0,36,0,0,0,154,0,0,0,43,0,0,0,44,0,0,0,45,1,0,0,46,1,0,0,46,3,0,0,45,0,0,0,47,1,0,0,46,0,0,0,48,1,0,0,0,0,0,0,176,76,0,0,117,3,0,0,118,3,0,0,197,0,0,0,155,0,0,0,77,0,0,0,119,0,0,0,55,0,0,0,119,3,0,0,156,0,0,0,198,0,0,0,199,0,0,0,78,0,0,0,157,0,0,0,49,1,0,0,36,0,0,0,158,0,0,0,44,0,0,0,44,0,0,0,50,1,0,0,51,1,0,0,46,3,0,0,45,0,0,0,52,1,0,0,46,0,0,0,53,1,0,0,0,0,0,0,192,76,0,0,120,3,0,0,121,3,0,0,197,0,0,0,159,0,0,0,79,0,0,0,119,0,0,0,55,0,0,0,122,3,0,0,160,0,0,0,198,0,0,0,199,0,0,0,80,0,0,0,161,0,0,0,54,1,0,0,36,0,0,0,162,0,0,0,45,0,0,0,44,0,0,0,55,1,0,0,56,1,0,0,46,3,0,0,45,0,0,0,57,1,0,0,46,0,0,0,58,1,0,0,0,0,0,0,208,76,0,0,123,3,0,0,124,3,0,0,197,0,0,0,163,0,0,0,81,0,0,0,119,0,0,0,55,0,0,0,125,3,0,0,164,0,0,0,198,0,0,0,199,0,0,0,82,0,0,0,165,0,0,0,59,1,0,0,36,0,0,0,166,0,0,0,46,0,0,0,44,0,0,0,60,1,0,0,61,1,0,0,46,3,0,0,45,0,0,0,62,1,0,0,46,0,0,0,63,1,0,0,0,0,0,0,224,76,0,0,126,3,0,0,127,3,0,0,197,0,0,0,167,0,0,0,83,0,0,0,119,0,0,0,55,0,0,0,128,3,0,0,168,0,0,0,198,0,0,0,199,0,0,0,84,0,0,0,169,0,0,0,64,1,0,0,36,0,0,0,170,0,0,0,47,0,0,0,44,0,0,0,65,1,0,0,66,1,0,0,46,3,0,0,45,0,0,0,67,1,0,0,46,0,0,0,68,1,0,0,0,0,0,0,240,76,0,0,129,3,0,0,130,3,0,0,197,0,0,0,171,0,0,0,85,0,0,0,119,0,0,0,55,0,0,0,131,3,0,0,172,0,0,0,198,0,0,0,199,0,0,0,86,0,0,0,173,0,0,0,69,1,0,0,36,0,0,0,174,0,0,0,48,0,0,0,44,0,0,0,70,1,0,0,71,1,0,0,46,3,0,0,45,0,0,0,72,1,0,0,46,0,0,0,73,1,0,0,0,0,0,0,0,77,0,0,132,3,0,0,133,3,0,0,197,0,0,0,175,0,0,0,87,0,0,0,119,0,0,0,55,0,0,0,134,3,0,0,176,0,0,0,198,0,0,0,199,0,0,0,88,0,0,0,177,0,0,0,74,1,0,0,36,0,0,0,178,0,0,0,49,0,0,0,44,0,0,0,75,1,0,0,76,1,0,0,46,3,0,0,45,0,0,0,77,1,0,0,46,0,0,0,78,1,0,0,0,0,0,0,16,77,0,0,135,3,0,0,136,3,0,0,197,0,0,0,179,0,0,0,89,0,0,0,119,0,0,0,55,0,0,0,137,3,0,0,180,0,0,0,198,0,0,0,199,0,0,0,90,0,0,0,181,0,0,0,79,1,0,0,36,0,0,0,182,0,0,0,50,0,0,0,44,0,0,0,80,1,0,0,81,1,0,0,46,3,0,0,45,0,0,0,82,1,0,0,46,0,0,0,83,1,0,0,0,0,0,0,32,77,0,0,138,3,0,0,139,3,0,0,197,0,0,0,183,0,0,0,91,0,0,0,119,0,0,0,55,0,0,0,140,3,0,0,184,0,0,0,198,0,0,0,199,0,0,0,92,0,0,0,185,0,0,0,84,1,0,0,36,0,0,0,186,0,0,0,51,0,0,0,44,0,0,0,85,1,0,0,86,1,0,0,46,3,0,0,45,0,0,0,87,1,0,0,46,0,0,0,88,1,0,0,0,0,0,0,48,77,0,0,141,3,0,0,142,3,0,0,197,0,0,0,187,0,0,0,93,0,0,0,119,0,0,0,55,0,0,0,143,3,0,0,188,0,0,0,198,0,0,0,199,0,0,0,94,0,0,0,189,0,0,0,89,1,0,0,36,0,0,0,190,0,0,0,52,0,0,0,44,0,0,0,90,1,0,0,91,1,0,0,46,3,0,0,45,0,0,0,92,1,0,0,46,0,0,0,93,1,0,0,0,0,0,0,64,77,0,0,144,3,0,0,145,3,0,0,197,0,0,0,191,0,0,0,95,0,0,0,119,0,0,0,55,0,0,0,146,3,0,0,192,0,0,0,198,0,0,0,199,0,0,0,96,0,0,0,193,0,0,0,94,1,0,0,36,0,0,0,194,0,0,0,53,0,0,0,44,0,0,0,95,1,0,0,96,1,0,0,46,3,0,0,45,0,0,0,97,1,0,0,46,0,0,0,98,1,0,0,0,0,0,0,80,77,0,0,147,3,0,0,148,3,0,0,197,0,0,0,195,0,0,0,97,0,0,0,119,0,0,0,55,0,0,0,149,3,0,0,196,0,0,0,198,0,0,0,199,0,0,0,98,0,0,0,197,0,0,0,99,1,0,0,36,0,0,0,198,0,0,0,54,0,0,0,44,0,0,0,100,1,0,0,101,1,0,0,46,3,0,0,45,0,0,0,102,1,0,0,46,0,0,0,103,1,0,0,0,0,0,0,96,77,0,0,150,3,0,0,151,3,0,0,197,0,0,0,199,0,0,0,99,0,0,0,119,0,0,0,55,0,0,0,152,3,0,0,200,0,0,0,198,0,0,0,199,0,0,0,100,0,0,0,201,0,0,0,104,1,0,0,36,0,0,0,202,0,0,0,55,0,0,0,44,0,0,0,105,1,0,0,106,1,0,0,46,3,0,0,45,0,0,0,107,1,0,0,46,0,0,0,108,1,0,0,0,0,0,0,112,77,0,0,153,3,0,0,154,3,0,0,197,0,0,0,203,0,0,0,101,0,0,0,119,0,0,0,55,0,0,0,155,3,0,0,204,0,0,0,198,0,0,0,199,0,0,0,102,0,0,0,205,0,0,0,109,1,0,0,36,0,0,0,206,0,0,0,56,0,0,0,44,0,0,0,110,1,0,0,111,1,0,0,46,3,0,0,45,0,0,0,112,1,0,0,46,0,0,0,113,1,0,0,0,0,0,0,128,77,0,0,156,3,0,0,157,3,0,0,197,0,0,0,207,0,0,0,103,0,0,0,119,0,0,0,55,0,0,0,158,3,0,0,208,0,0,0,198,0,0,0,199,0,0,0,104,0,0,0,209,0,0,0,114,1,0,0,36,0,0,0,210,0,0,0,57,0,0,0,44,0,0,0,115,1,0,0,116,1,0,0,46,3,0,0,45,0,0,0,117,1,0,0,46],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+112640);allocate([118,1,0,0,0,0,0,0,144,77,0,0,159,3,0,0,160,3,0,0,197,0,0,0,211,0,0,0,105,0,0,0,119,0,0,0,55,0,0,0,161,3,0,0,212,0,0,0,198,0,0,0,199,0,0,0,106,0,0,0,213,0,0,0,119,1,0,0,36,0,0,0,214,0,0,0,58,0,0,0,44,0,0,0,120,1,0,0,121,1,0,0,46,3,0,0,45,0,0,0,122,1,0,0,46,0,0,0,123,1,0,0,0,0,0,0,160,77,0,0,162,3,0,0,163,3,0,0,197,0,0,0,215,0,0,0,107,0,0,0,119,0,0,0,55,0,0,0,164,3,0,0,216,0,0,0,198,0,0,0,199,0,0,0,108,0,0,0,217,0,0,0,124,1,0,0,36,0,0,0,218,0,0,0,59,0,0,0,44,0,0,0,125,1,0,0,126,1,0,0,46,3,0,0,45,0,0,0,127,1,0,0,46,0,0,0,128,1,0,0,0,0,0,0,176,77,0,0,165,3,0,0,166,3,0,0,197,0,0,0,219,0,0,0,109,0,0,0,119,0,0,0,55,0,0,0,167,3,0,0,220,0,0,0,198,0,0,0,199,0,0,0,110,0,0,0,221,0,0,0,129,1,0,0,36,0,0,0,222,0,0,0,60,0,0,0,44,0,0,0,130,1,0,0,131,1,0,0,46,3,0,0,45,0,0,0,132,1,0,0,46,0,0,0,133,1,0,0,0,0,0,0,192,77,0,0,168,3,0,0,169,3,0,0,197,0,0,0,223,0,0,0,111,0,0,0,119,0,0,0,55,0,0,0,170,3,0,0,224,0,0,0,198,0,0,0,199,0,0,0,112,0,0,0,225,0,0,0,134,1,0,0,36,0,0,0,226,0,0,0,61,0,0,0,44,0,0,0,135,1,0,0,136,1,0,0,46,3,0,0,45,0,0,0,137,1,0,0,46,0,0,0,138,1,0,0,0,0,0,0,208,77,0,0,171,3,0,0,172,3,0,0,197,0,0,0,227,0,0,0,113,0,0,0,119,0,0,0,55,0,0,0,173,3,0,0,228,0,0,0,198,0,0,0,199,0,0,0,114,0,0,0,229,0,0,0,139,1,0,0,36,0,0,0,230,0,0,0,62,0,0,0,44,0,0,0,140,1,0,0,141,1,0,0,46,3,0,0,45,0,0,0,142,1,0,0,46,0,0,0,143,1,0,0,0,0,0,0,224,77,0,0,174,3,0,0,175,3,0,0,197,0,0,0,231,0,0,0,115,0,0,0,119,0,0,0,55,0,0,0,176,3,0,0,232,0,0,0,198,0,0,0,199,0,0,0,116,0,0,0,233,0,0,0,144,1,0,0,36,0,0,0,234,0,0,0,63,0,0,0,44,0,0,0,145,1,0,0,146,1,0,0,46,3,0,0,45,0,0,0,147,1,0,0,46,0,0,0,148,1,0,0,0,0,0,0,240,77,0,0,177,3,0,0,178,3,0,0,197,0,0,0,235,0,0,0,117,0,0,0,119,0,0,0,55,0,0,0,179,3,0,0,236,0,0,0,198,0,0,0,199,0,0,0,118,0,0,0,237,0,0,0,149,1,0,0,36,0,0,0,238,0,0,0,64,0,0,0,44,0,0,0,150,1,0,0,151,1,0,0,46,3,0,0,45,0,0,0,152,1,0,0,46,0,0,0,153,1,0,0,0,0,0,0,0,78,0,0,180,3,0,0,181,3,0,0,197,0,0,0,239,0,0,0,119,0,0,0,119,0,0,0,55,0,0,0,182,3,0,0,240,0,0,0,198,0,0,0,199,0,0,0,120,0,0,0,241,0,0,0,154,1,0,0,36,0,0,0,242,0,0,0,65,0,0,0,44,0,0,0,155,1,0,0,156,1,0,0,46,3,0,0,45,0,0,0,157,1,0,0,46,0,0,0,158,1,0,0,0,0,0,0,16,78,0,0,183,3,0,0,184,3,0,0,197,0,0,0,243,0,0,0,121,0,0,0,119,0,0,0,55,0,0,0,185,3,0,0,244,0,0,0,198,0,0,0,199,0,0,0,122,0,0,0,245,0,0,0,159,1,0,0,36,0,0,0,246,0,0,0,66,0,0,0,44,0,0,0,160,1,0,0,161,1,0,0,46,3,0,0,45,0,0,0,162,1,0,0,46,0,0,0,163,1,0,0,0,0,0,0,32,78,0,0,186,3,0,0,187,3,0,0,197,0,0,0,247,0,0,0,123,0,0,0,119,0,0,0,55,0,0,0,188,3,0,0,248,0,0,0,198,0,0,0,199,0,0,0,124,0,0,0,249,0,0,0,164,1,0,0,36,0,0,0,250,0,0,0,67,0,0,0,44,0,0,0,165,1,0,0,166,1,0,0,46,3,0,0,45,0,0,0,167,1,0,0,46,0,0,0,168,1,0,0,0,0,0,0,48,78,0,0,189,3,0,0,190,3,0,0,197,0,0,0,251,0,0,0,125,0,0,0,119,0,0,0,55,0,0,0,191,3,0,0,252,0,0,0,198,0,0,0,199,0,0,0,126,0,0,0,253,0,0,0,169,1,0,0,36,0,0,0,254,0,0,0,68,0,0,0,44,0,0,0,170,1,0,0,171,1,0,0,46,3,0,0,45,0,0,0,172,1,0,0,46,0,0,0,173,1,0,0,0,0,0,0,64,78,0,0,192,3,0,0,193,3,0,0,197,0,0,0,255,0,0,0,127,0,0,0,119,0,0,0,55,0,0,0,194,3,0,0,0,1,0,0,198,0,0,0,199,0,0,0,128,0,0,0,1,1,0,0,174,1,0,0,36,0,0,0,2,1,0,0,69,0,0,0,44,0,0,0,175,1,0,0,176,1,0,0,46,3,0,0,45,0,0,0,177,1,0,0,46,0,0,0,178,1,0,0,0,0,0,0,80,78,0,0,195,3,0,0,196,3,0,0,197,0,0,0,3,1,0,0,129,0,0,0,119,0,0,0,55,0,0,0,197,3,0,0,4,1,0,0,198,0,0,0,199,0,0,0,130,0,0,0,5,1,0,0,179,1,0,0,36,0,0,0,6,1,0,0,70,0,0,0,44,0,0,0,180,1,0,0,181,1,0,0,46,3,0,0,45,0,0,0,182,1,0,0,46,0,0,0,183,1,0,0,0,0,0,0,96,78,0,0,198,3,0,0,199,3,0,0,197,0,0,0,7,1,0,0,131,0,0,0,119,0,0,0,55,0,0,0,200,3,0,0,8,1,0,0,198,0,0,0,199,0,0,0,132,0,0,0,9,1,0,0,184,1,0,0,36,0,0,0,10,1,0,0,71,0,0,0,44,0,0,0,185,1,0,0,186,1,0,0,46,3,0,0,45,0,0,0,187,1,0,0,46,0,0,0,188,1,0,0,0,0,0,0,112,78,0,0,201,3,0,0,202,3,0,0,197,0,0,0,11,1,0,0,133,0,0,0,119,0,0,0,55,0,0,0,203,3,0,0,12,1,0,0,198,0,0,0,199,0,0,0,134,0,0,0,13,1,0,0,189,1,0,0,36,0,0,0,14,1,0,0,72,0,0,0,44,0,0,0,190,1,0,0,191,1,0,0,46,3,0,0,45,0,0,0,192,1,0,0,46,0,0,0,193,1,0,0,0,0,0,0,128,78,0,0,204,3,0,0,205,3,0,0,197,0,0,0,15,1,0,0,135,0,0,0,119,0,0,0,55,0,0,0,206,3,0,0,16,1,0,0,198,0,0,0,199,0,0,0,136,0,0,0,17,1,0,0,194,1,0,0,36,0,0,0,18,1,0,0,73,0,0,0,44,0,0,0,195,1,0,0,196,1,0,0,46,3,0,0,45,0,0,0,197,1,0,0,46,0,0,0,198,1,0,0,0,0,0,0,144,78,0,0,207,3,0,0,208,3,0,0,197,0,0,0,19,1,0,0,137,0,0,0,119,0,0,0,55,0,0,0,209,3,0,0,20,1,0,0,198,0,0,0,199,0,0,0,138,0,0,0,21,1,0,0,199,1,0,0,36,0,0,0,22,1,0,0,74,0,0,0,44,0,0,0,200,1,0,0,201,1,0,0,46,3,0,0,45,0,0,0,202,1,0,0,46,0,0,0,203,1,0,0,0,0,0,0,160,78,0,0,210,3,0,0,211,3,0,0,197,0,0,0,23,1,0,0,139,0,0,0,119,0,0,0,55,0,0,0,212,3,0,0,24,1,0,0,198,0,0,0,199,0,0,0,140,0,0,0,25,1,0,0,204,1,0,0,36,0,0,0,26,1,0,0,75,0,0,0,44,0,0,0,205,1,0,0,206,1,0,0,46,3,0,0,45,0,0,0,207,1,0,0,46,0,0,0,208,1,0,0,0,0,0,0,176,78,0,0,213,3,0,0,214,3,0,0,197,0,0,0,27,1,0,0,141,0,0,0,119,0,0,0,55,0,0,0,215,3,0,0,28,1,0,0,198,0,0,0,199,0,0,0,142,0,0,0,29,1,0,0,209,1,0,0,36,0,0,0,30,1,0,0,76,0,0,0,44,0,0,0,210,1,0,0,211,1,0,0,46,3,0,0,45,0,0,0,212,1,0,0,46,0,0,0,213,1,0,0,0,0,0,0,192,78,0,0,216,3,0,0,217,3,0,0,197,0,0,0,31,1,0,0,143,0,0,0,119,0,0,0,55,0,0,0,218,3,0,0,32,1,0,0,198,0,0,0,199,0,0,0,144,0,0,0,33,1,0,0,214,1,0,0,36,0,0,0,34,1,0,0,77,0,0,0,44,0,0,0,215,1,0,0,216,1,0,0,46,3,0,0,45,0,0,0,217,1,0,0,46,0,0,0,218,1,0,0,0,0,0,0,208,78,0,0,219,3,0,0,220,3,0,0,197,0,0,0,35,1,0,0,145,0,0,0,119,0,0,0,55,0,0,0,221,3,0,0,36,1,0,0,198,0,0,0,199,0,0,0,146,0,0,0,37,1,0,0,219,1,0,0,36,0,0,0,38,1,0,0,78,0,0,0,44,0,0,0,220,1,0,0,221,1,0,0,46,3,0,0,45,0,0,0,222,1,0,0,46,0,0,0,223,1,0,0,0,0,0,0,224,78,0,0,222,3,0,0,223,3,0,0,197,0,0,0,39,1,0,0,147,0,0,0,119,0,0,0,55,0,0,0,224,3,0,0,40,1,0,0,198,0,0,0,199,0,0,0,148,0,0,0,41,1,0,0,224,1,0,0,36,0,0,0,42,1,0,0,79,0,0,0,44,0,0,0,225,1,0,0,226,1,0,0,46,3,0,0,45,0,0,0,227,1,0,0,46,0,0,0,228,1,0,0,0,0,0,0,240,78,0,0,225,3,0,0,226,3,0,0,197,0,0,0,43,1,0,0,149,0,0,0,119,0,0,0,55,0,0,0,227,3,0,0,44,1,0,0,198,0,0,0,199,0,0,0,150,0,0,0,45,1,0,0,229,1,0,0,36,0,0,0,46,1,0,0,80,0,0,0,44,0,0,0,230,1,0,0,231,1,0,0,46,3,0,0,45,0,0,0,232,1,0,0,46,0,0,0,233,1,0,0,0,0,0,0,0,79,0,0,228,3,0,0,229,3,0,0,197,0,0,0,47,1,0,0,151,0,0,0,119,0,0,0,55,0,0,0,230,3,0,0,48,1,0,0,198,0,0,0,199,0,0,0,152,0,0,0,49,1,0,0,234,1,0,0,36,0,0,0,50,1,0,0,81,0,0,0,44,0,0,0,235,1,0,0,236,1,0,0,46,3,0,0,45,0,0,0,237,1,0,0,46,0,0,0,238,1,0,0,0,0,0,0,16,79,0,0,231,3,0,0,232,3,0,0,197,0,0,0,51,1,0,0,153,0,0,0,119,0,0,0,55,0,0,0,233,3,0,0,52,1,0,0,198,0,0,0,199,0,0,0,154,0,0,0,53,1,0,0,239,1,0,0,36,0,0,0,54,1,0,0,82,0,0,0,44,0,0,0,240,1,0,0,241,1,0,0,46,3,0,0,45,0,0,0,242,1,0,0,46,0,0,0,243,1,0,0,0,0,0,0,32,79,0,0,234,3,0,0,235,3,0,0,197,0,0,0,55,1,0,0,155,0,0,0,119,0,0,0,55,0,0,0,236,3,0,0,56,1,0,0,198,0,0,0,199,0,0,0,156,0,0,0,57,1,0,0,244,1,0,0,36,0,0,0,58,1,0,0,83,0,0,0,44,0,0,0,245,1,0,0,246,1,0,0,46,3,0,0,45,0,0,0,247,1,0,0,46,0,0,0,248,1,0,0,0,0,0,0,48,79,0,0,237,3,0,0,238,3,0,0,197,0,0,0,59,1,0,0,157,0,0,0,119,0,0,0,55,0,0,0,239,3,0,0,60,1,0,0,198,0,0,0,199,0,0,0,158,0,0,0,61,1,0,0,249,1,0,0,36,0,0,0,62,1,0,0,84,0,0,0,44,0,0,0,250,1,0,0,251,1,0,0,46,3,0,0,45,0,0,0,252,1,0,0,46,0,0,0,253,1,0,0,0,0,0,0,64,79,0,0,240,3,0,0,241,3,0,0,197,0,0,0,63,1,0,0,159,0,0,0,119,0,0,0,55,0,0,0,242,3,0,0,64,1,0,0,198,0,0,0,199,0,0,0,160,0,0,0,65,1,0,0,254,1,0,0,36,0,0,0,66,1,0,0,85,0,0,0,44,0,0,0,255,1,0,0,0,2,0,0,46,3,0,0,45,0,0,0,1,2,0,0,46,0,0,0,2,2,0,0,0,0,0,0,80,79,0,0,243,3,0,0,244,3,0,0,197,0,0,0,67,1,0,0,161,0,0,0,119,0,0,0,55,0,0,0,245,3,0,0,68,1,0,0,198,0,0,0,199,0,0,0,162,0,0,0,69,1,0,0,3,2,0,0,36,0,0,0,70,1,0,0,86,0,0,0,44,0,0,0,4,2,0,0,5,2,0,0,46,3,0,0,45,0,0,0,6,2,0,0,46,0,0,0,7,2,0,0,0,0,0,0,96,79,0,0,246,3,0,0,247,3,0,0,197,0,0,0,71,1,0,0,163,0,0,0,119,0,0,0,55,0,0,0,248,3,0,0,72,1,0,0,198,0,0,0,199,0,0,0,164,0,0,0,73,1,0,0,8,2,0,0,36,0,0,0,74,1,0,0,87,0,0,0,44,0,0,0,9,2,0,0,10,2,0,0,46,3,0,0,45,0,0,0,11,2,0,0,46,0,0,0,12,2,0,0,0,0,0,0,112,79,0,0,249,3,0,0,250,3,0,0,197,0,0,0,75,1,0,0,165,0,0,0,119,0,0,0,55,0,0,0,251,3,0,0,76,1,0,0,198,0,0,0,199,0,0,0,166,0,0,0,77,1,0,0,13,2,0,0,36,0,0,0,78,1,0,0,88,0,0,0,44,0,0,0,14,2,0,0,15,2,0,0,46,3,0,0,45,0,0,0,16,2,0,0,46,0,0,0,17,2,0,0,0,0,0,0,128,79,0,0,252,3,0,0,253,3,0,0,197,0,0,0,79,1,0,0,167,0,0,0,119,0,0,0,55,0,0,0,254,3,0,0,80,1,0,0,198,0,0,0,199,0,0,0,168,0,0,0,81,1,0,0,18,2,0,0,36,0,0,0,82,1,0,0,89,0,0,0,44,0,0,0,19,2,0,0,20,2,0,0,46,3,0,0,45,0,0,0,21,2,0,0,46,0,0,0,22,2,0,0,0,0,0,0,144,79,0,0,255,3,0,0,0,4,0,0,197,0,0,0,83,1,0,0,169,0,0,0,119,0,0,0,55,0,0,0,1,4,0,0,84,1,0,0,198,0,0,0,199,0,0,0,170,0,0,0,85,1,0,0,23,2,0,0,36,0,0,0,86,1,0,0,90,0,0,0,44,0,0,0,24,2,0,0,25,2,0,0,46,3,0,0,45,0,0,0,26,2,0,0,46,0,0,0,27,2,0,0,0,0,0,0,160,79,0,0,2,4,0,0,3,4,0,0,197,0,0,0,87,1,0,0,171,0,0,0,119,0,0,0,55,0,0,0,4,4,0,0,88,1,0,0,198,0,0,0,199,0,0,0,172,0,0,0,89,1,0,0,28,2,0,0,36,0,0,0,90,1,0,0,91,0,0,0,44,0,0,0,29,2,0,0,30,2,0,0,46,3,0,0,45,0,0,0,31,2,0,0,46,0,0,0,32,2,0,0,0,0,0,0,176,79,0,0,5,4,0,0,6,4,0,0,197,0,0,0,91,1,0,0,173,0,0,0,119,0,0,0,55,0,0,0,7,4,0,0,92,1,0,0,198,0,0,0,199,0,0,0,174,0,0,0,93,1,0,0,33,2,0,0,36,0,0,0,94,1,0,0,92,0,0,0,44,0,0,0,34,2,0,0,35,2,0,0,46,3,0,0,45,0,0,0,36,2,0,0,46,0,0,0,37,2,0,0,0,0,0,0,192,79,0,0,8,4,0,0,9,4,0,0,197,0,0,0,95,1,0,0,175,0,0,0,119,0,0,0,55,0,0,0,10,4,0,0,96,1,0,0,198,0,0,0,199,0,0,0,176,0,0,0,97,1,0,0,38,2,0,0,36,0,0,0,98,1,0,0,93,0,0,0,44,0,0,0,39,2,0,0,40,2,0,0,46,3,0,0,45,0,0,0,41,2,0,0,46,0,0,0,42,2,0,0,0,0,0,0,208,79,0,0,11,4,0,0,12,4,0,0,197,0,0,0,99,1,0,0,177,0,0,0,119,0,0,0,55,0,0,0,13,4,0,0,100,1,0,0,198,0,0,0,199,0,0,0,178,0,0,0,101,1,0,0,43,2,0,0,36,0,0,0,102,1,0,0,94,0,0,0,44,0,0,0,44,2,0,0,45,2,0,0,46,3,0,0,45,0,0,0,46,2,0,0,46,0,0,0,47,2,0,0,0,0,0,0,224,79,0,0,14,4,0,0,15,4,0,0,197,0,0,0,103,1,0,0,179,0,0,0,119,0,0,0,55,0,0,0,16,4,0,0,104,1,0,0,198,0,0,0,199,0,0,0,180,0,0,0,105,1,0,0,48,2,0,0,36,0,0,0,106,1,0,0,95,0,0,0,44,0,0,0,49,2,0,0,50,2,0,0,46,3,0,0,45,0,0,0,51,2,0,0,46,0,0,0,52,2,0,0,0,0,0,0,240,79,0,0,17,4,0,0,18,4,0,0,197,0,0,0,107,1,0,0,181,0,0,0,119,0,0,0,55,0,0,0,19,4,0,0,108,1,0,0,198,0,0,0,199,0,0,0,182,0,0,0,109,1,0,0,53,2,0,0,36,0,0,0,110,1,0,0,96,0,0,0,44,0,0,0,54,2,0,0,55,2,0,0,46,3,0,0,45,0,0,0,56,2,0,0,46,0,0,0,57,2,0,0,0,0,0,0,0,80,0,0,20,4,0,0,21,4,0,0,197,0,0,0,111,1,0,0,183,0,0,0,119,0,0,0,55,0,0,0,22,4,0,0,112,1,0,0,198,0,0,0,199,0,0,0,184,0,0,0,113,1,0,0,58,2,0,0,36,0,0,0,114,1,0,0,97,0,0,0,44,0,0,0,59,2,0,0,60,2,0,0,46,3,0,0,45,0,0,0,61,2,0,0,46,0,0,0,62,2,0,0,0,0,0,0,16,80,0,0,23,4,0,0,24,4,0,0,197,0,0,0,115,1,0,0,185,0,0,0,119,0,0,0,55,0,0,0,25,4,0,0,116,1,0,0,198,0,0,0,199,0,0,0,186,0,0,0,117,1,0,0,63,2,0,0,36,0,0,0,118,1,0,0,98,0,0,0,44,0,0,0,64,2,0,0,65,2,0,0,46,3,0,0,45,0,0,0,66,2,0,0,46,0,0,0,67,2,0,0,0,0,0,0,32,80,0,0,26,4,0,0,27,4,0,0,197,0,0,0,119,1,0,0,187,0,0,0,119,0,0,0,55,0,0,0,28,4,0,0,120,1,0,0,198,0,0,0,199,0,0,0,188,0,0,0,121,1,0,0,68,2,0,0,36,0,0,0,122,1,0,0,99,0,0,0,44,0,0,0,69,2,0,0,70,2,0,0,46,3,0,0,45,0,0,0,71,2,0,0,46,0,0,0,72,2,0,0,0,0,0,0,48,80,0,0,29,4,0,0,30,4,0,0,197,0,0,0,123,1,0,0,189,0,0,0,119,0,0,0,55,0,0,0,31,4,0,0,124,1,0,0,198,0,0,0,199,0,0,0,190,0,0,0,125,1,0,0,73,2,0,0,36,0,0,0,126,1,0,0,100,0,0,0,44,0,0,0,74,2,0,0,75,2,0,0,46,3,0,0,45,0,0,0,76,2,0,0,46,0,0,0,77,2,0,0,0,0,0,0,64,80,0,0,32,4,0,0,33,4,0,0,197,0,0,0,127,1,0,0,191,0,0,0,119,0,0,0,55,0,0,0,34,4,0,0,128,1,0,0,198,0,0,0,199,0,0,0,192,0,0,0,129,1,0,0,78,2,0,0,36,0,0,0,130,1,0,0,101,0,0,0,44,0,0,0,79,2,0,0,80,2,0,0,46,3,0,0,45,0,0,0,81,2,0,0,46,0,0,0,82,2,0,0,0,0,0,0,80,80,0,0,35,4,0,0,36,4,0,0,197,0,0,0,131,1,0,0,193,0,0,0,119,0,0,0,55,0,0,0,37,4,0,0,132,1,0,0,198,0,0,0,199,0,0,0,194,0,0,0,133,1,0,0,83,2,0,0,36,0,0,0,134,1,0,0,102,0,0,0,44,0,0,0,84,2,0,0,85,2,0,0,46,3,0,0,45,0,0,0,86,2,0,0,46,0,0,0,87,2,0,0,0,0,0,0,96,80,0,0,38,4,0,0,39,4,0,0,197,0,0,0,135,1,0,0,195,0,0,0,119,0,0,0,55,0,0,0,40,4,0,0,136,1,0,0,198,0,0,0,199,0,0,0,196,0,0,0,137,1,0,0,88,2,0,0,36,0,0,0,138,1,0,0,103,0,0,0,44,0,0,0,89,2,0,0,90,2,0,0,46,3,0,0,45,0,0,0,91,2,0,0,46,0,0,0,92,2,0,0,0,0,0,0,112,80,0,0,41,4,0,0,42,4,0,0,197,0,0,0,139,1,0,0,197,0,0,0,119,0,0,0,55,0,0,0,43,4,0,0,140,1,0,0,198,0,0,0,199,0,0,0,198,0,0,0,141,1,0,0,93,2,0,0,36,0,0,0,142,1,0,0,104,0,0,0,44,0,0,0,94,2,0,0,95,2,0,0,46,3,0,0,45,0,0,0,96,2,0,0,46,0,0,0,97,2,0,0,0,0,0,0,128,80,0,0,44,4,0,0,45,4,0,0,197,0,0,0,143,1,0,0,199,0,0,0,119,0,0,0,55,0,0,0,46,4,0,0,144,1,0,0,198,0,0,0,199,0,0,0,200,0,0,0,145,1,0,0,98,2,0,0,36,0,0,0,146,1,0,0,105,0,0,0,44,0,0,0,99,2,0,0,100,2,0,0,46,3,0,0,45,0,0,0,101,2,0,0,46,0,0,0,102,2,0,0,0,0,0,0,160,80,0,0,28,3,0,0,47,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,51,0,0,0,52,0,0,0,27,0,0,0,28,0,0,0,201,0,0,0,61,0,0,0,62,0,0,0,73,0,0,0,63,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,31,0,0,0,106,0,0,0,53,0,0,0,0,0,0,0,144,80,0,0,47,0,0,0,48,4,0,0,49,4,0,0,48,146,13,0,117,181,6,0,23,182,6,0,175,0,0,0,1,0,0,0,52,146,13,0,21,183,6,0,23,182,6,0,185,0,0,0,1,0,0,0,0,0,0,0,176,80,0,0,30,0,0,0,50,4,0,0,103,2,0,0,0,0,0,0,224,80,0,0,28,3,0,0,51,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,53,0,0,0,54,0,0,0,27,0,0,0,28,0,0,0,202,0,0,0,64,0,0,0,65,0,0,0,73,0,0,0,66,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,32,0,0,0,107,0,0,0,54,0,0,0,0,0,0,0,208,80,0,0,47,0,0,0,52,4,0,0,53,4,0,0,56,146,13,0,174,184,6,0,23,182,6,0,175,0,0,0,1,0,0,0,60,146,13,0,137,185,6,0,23,182,6,0,185,0,0,0,1,0,0,0,0,0,0,0,240,80,0,0,30,0,0,0,54,4,0,0,104,2,0,0,0,0,0,0,32,81,0,0,28,3,0,0,55,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,55,0,0,0,56,0,0,0,27,0,0,0,28,0,0,0,203,0,0,0,67,0,0,0,68,0,0,0,73,0,0,0,69,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,33,0,0,0,108,0,0,0,55,0,0,0,0,0,0,0,16,81,0,0,47,0,0,0,56,4,0,0,57,4,0,0,64,146,13,0,240,186,6,0,23,182,6,0,175,0,0,0,1,0,0,0,68,146,13,0,200,187,6,0,23,182,6,0,185,0,0,0,1,0,0,0,0,0,0,0,48,81,0,0,30,0,0,0,58,4,0,0,105,2,0,0,0,0,0,0,96,81,0,0,28,3,0,0,59,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,57,0,0,0,58,0,0,0,27,0,0,0,28,0,0,0,204,0,0,0,70,0,0,0,71,0,0,0,73,0,0,0,72,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,34,0,0,0,109,0,0,0,56,0,0,0,0,0,0,0,80,81,0,0,47,0,0,0,60,4,0,0,61,4,0,0,72,146,13,0,45,189,6,0,23,182,6,0,175,0,0,0,1,0,0,0,76,146,13,0,14,190,6,0,23,182,6,0,185,0,0,0,1,0,0,0,0,0,0,0,112,81,0,0,30,0,0,0,62,4,0,0,106,2,0,0,0,0,0,0,160,81,0,0,28,3,0,0,63,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,59,0,0,0,60,0,0,0,27,0,0,0,28,0,0,0,205,0,0,0,73,0,0,0,74,0,0,0,73,0,0,0,75,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,35,0,0,0,110,0,0,0,57,0,0,0,0,0,0,0,144,81,0,0,47,0,0,0,64,4,0,0,65,4,0,0,80,146,13,0,124,191,6,0,23,182,6,0,175,0,0,0,1,0,0,0,84,146,13,0,81,192,6,0,23,182,6,0,185,0,0,0,1,0,0,0,0,0,0,0,176,81,0,0,30,0,0,0,66,4,0,0,107,2,0,0,0,0,0,0,224,81,0,0,28,3,0,0,67,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,61,0,0,0,62,0,0,0,27,0,0,0,28,0,0,0,206,0,0,0,76,0,0,0,77,0,0,0,73,0,0,0,78,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,36,0,0,0,111,0,0,0,58,0,0,0,0,0,0,0,208,81,0,0,47,0,0,0,68,4,0,0,69,4,0,0,88,146,13,0,177,193,6,0,23,182,6,0,175,0,0,0,1,0,0,0,92,146,13,0,143,194,6,0,23,182,6,0,185,0,0,0,1,0,0,0,0,0,0,0,240,81,0,0,30,0,0,0,70,4,0,0,108,2,0,0,0,0,0,0,32,82,0,0,28,3,0,0,71,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,63,0,0,0,64,0,0,0,27,0,0,0,28,0,0,0,207,0,0,0,79,0,0,0,80,0,0,0,73,0,0,0,81,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,37,0,0,0,112,0,0,0,59,0,0,0,0,0,0,0,16,82,0,0,47,0,0,0,72,4,0,0,73,4,0,0,96,146,13,0,246,195,6,0,23,182,6,0,175,0,0,0,1,0,0,0,100,146,13,0,206,196,6,0,23,182,6,0,185,0,0,0,1,0,0,0,0,0,0,0,48,82,0,0,30,0,0,0,74,4,0,0,109,2,0,0,0,0,0,0,96,82,0,0,28,3,0,0,75,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,65,0,0,0,66,0,0,0,27,0,0,0,28,0,0,0,208,0,0,0,82,0,0,0,83,0,0,0,73,0,0,0,84,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,38,0,0,0,113,0,0,0,60,0,0,0,0,0,0,0,80,82,0,0,47,0,0,0,76,4,0,0,77,4,0,0,104,146,13,0,61,198,6,0,23,182,6,0,175,0,0,0,1,0,0,0,108,146,13,0,24,199,6,0,23,182,6,0,185,0,0,0,1,0,0,0,0,0,0,0,112,82,0,0,30,0,0,0,78,4,0,0,110,2,0,0,0,0,0,0,144,82,0,0,47,0,0,0,79,4,0,0,80,4,0,0,0,0,0,0,160,82,0,0,81,4,0,0,82,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,67,0,0,0,68,0,0,0,27,0,0,0,28,0,0,0,209,0,0,0,85,0,0,0,86,0,0,0,73,0,0,0,87,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,39,0,0,0,114,0,0,0,61,0,0,0,112,146,13,0,9,201,6,0,23,182,6,0,175,0,0,0,1,0,0,0,116,146,13,0,252,201,6,0,23,182,6,0,185,0,0,0,1,0,0,0,0,0,0,0,176,82,0,0,30,0,0,0,83,4,0,0,111,2,0,0,0,0,0,0,208,82,0,0,47,0,0,0,84,4,0,0,85,4,0,0,0,0,0,0,224,82,0,0,86,4,0,0,87,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,88,0,0,0,69,0,0,0,70,0,0,0,27,0,0,0,28,0,0,0,210,0,0,0,54,0,0,0,89,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,40,0,0,0,21,0,0,0,124,146,13,0,108,204,6,0,197,203,6,0,247,0,0,0,1,0,0,0,120,146,13,0,85,53,7,0,0,0,0,0,132,146,13,0,95,205,6,0,197,203,6,0,3,1,0,0,1,0,0,0,128,146,13,0,85,53,7,0,0,0,0,0,0,0,0,0,0,83,0,0,47,0,0,0,88,4,0,0,89,4,0,0,0,0,0,0,16,83,0,0,90,4,0,0,91,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,71,0,0,0,72,0,0,0,27,0,0,0,28,0,0,0,211,0,0,0,90,0,0,0,91,0,0,0,73,0,0,0,56,0,0,0,212,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,41,0,0,0,115,0,0,0,140,146,13,0,240,207,6,0,200,206,6,0,117,1,0,0,1,0,0,0,136,146,13,0,85,53,7,0,0,0,0,0,148,146,13,0,225,209,6,0,200,206,6,0,129,1,0,0,1,0,0,0,144,146,13,0,85,53,7,0,0,0,0,0,0,0,0,0,32,83,0,0,30,0,0,0,92,4,0,0,112,2,0,0,0,0,0,0,64,83,0,0,47,0,0,0,93,4,0,0,94,4,0,0,0,0,0,0,80,83,0,0,28,3,0,0,95,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,73,0,0,0,74,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,42,0,0,0,21,0,0,0,156,146,13,0,154,211,6,0,47,211,6,0,40,0,0,0,1,0,0,0,152,146,13,0,85,53,7,0,0,0,0,0,164,146,13,0,14,212,6,0,47,211,6,0,48,0,0,0,1,0,0,0,160,146,13,0,85,53,7,0,0,0,0,0,0,0,0,0,112,83,0,0,47,0,0,0,96,4,0,0,97,4,0,0,0,0,0,0,128,83,0,0,28,3,0,0,98,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,75,0,0,0,76,0,0,0,27,0,0,0,28,0,0,0,213,0,0,0,92,0,0,0,93,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,43,0,0,0,21,0,0,0,172,146,13,0,198,213,6,0,49,213,6,0,237,0,0,0,1,0,0,0,168,146,13,0,85,53,7,0,0,0,0,0,180,146,13,0,135,215,6,0,49,213,6,0,249,0,0,0,1,0,0,0,176,146,13,0,85,53,7,0,0,0,0,0,0,0,0,0,144,83,0,0,99,4,0,0,100,4,0,0,113,2,0,0,0,0,0,0,160,83,0,0,47,0,0,0,101,4,0,0,102,4,0,0,0,0,0,0,176,83,0,0,103,4,0,0,104,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,94,0,0,0,77,0,0,0,78,0,0,0,27,0,0,0,28,0,0,0,214,0,0,0,54,0,0,0,95,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,44,0,0,0,21,0,0,0,188,146,13,0,216,217,6,0,211,216,6,0,80,0,0,0,1,0,0,0,184,146,13,0,85,53,7,0,0,0,0,0,196,146,13,0,131,218,6,0,211,216,6,0,88,0,0,0,1,0,0,0,192,146,13,0,85,53,7,0,0,0,0,0,0,0,0,0,224,83,0,0,103,4,0,0,105,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,96,0,0,0,77,0,0,0,78,0,0,0,27,0,0,0,28,0,0,0,215,0,0,0,54,0,0,0,97,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,45,0,0,0,21,0,0,0,0,0,0,0,208,83,0,0,47,0,0,0,106,4,0,0,107,4,0,0,0,0,0,0,240,83,0,0,47,0,0,0,108,4,0,0,109,4,0,0,0,0,0,0,0,84,0,0,110,4,0,0,111,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,98,0,0,0,79,0,0,0,80,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,46,0,0,0,21,0,0,0,204,146,13,0,151,220,6,0,39,220,6,0,66,0,0,0,1,0,0,0,200,146,13,0,85,53,7,0,0,0,0,0,212,146,13,0,12,221,6,0,39,220,6,0,74,0,0,0,1,0,0,0,208,146,13,0,85,53,7,0,0,0,0,0,0,0,0,0,32,84,0,0,47,0,0,0,112,4,0,0,113,4,0,0,0,0,0,0,48,84,0,0,28,3,0,0,114,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,81,0,0,0,82,0,0,0,27,0,0,0,28,0,0,0,216,0,0,0,99,0,0,0,100,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,47,0,0,0,116,0,0,0,220,146,13,0,55,222,6,0,165,222,6,0,187,0,0,0,1,0,0,0,216,146,13,0,85,53,7,0,0,0,0,0,228,146,13,0,168,223,6,0,165,222,6,0,199,0,0,0,1,0,0,0,224,146,13,0,85,53,7,0,0,0,0,0,0,0,0,0,80,84,0,0,47,0,0,0,115,4,0,0,116,4,0,0,0,0,0,0,96,84,0,0,117,4,0,0,118,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,83,0,0,0,84,0,0,0,27,0,0,0,28,0,0,0,217,0,0,0,101,0,0,0,102,0,0,0,73,0,0,0,56,0,0,0,218,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,48,0,0,0,117,0,0,0,236,146,13,0,194,225,6,0,239,224,6,0,98,1,0,0,1,0,0,0,232,146,13,0,85,53,7,0,0,0,0,0,244,146,13,0,72,228,6,0,239,224,6,0,110,1,0,0,1,0,0,0,240,146,13,0,85,53,7,0,0,0,0,0,56,227,6,0,239,224,6,0,142,0,0,0,0,0,0,0,190,185,17,0,33,228,6,0,42,228,6,0,56,227,6,0,239,224,6,0,142,0,0,0,1,0,0,0,190,185,17,0,22,228,6,0,116,11,7,0,0,0,0,0,112,84,0,0,30,0,0,0,119,4,0,0,114,2,0,0,0,0,0,0,128,84,0,0,47,0,0,0,120,4,0,0,121,4,0,0,0,0,0,0,144,84,0,0,28,3,0,0,122,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,85,0,0,0,86,0,0,0,27,0,0,0,28,0,0,0,219,0,0,0,54,0,0,0,103,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,49,0,0,0,21,0,0,0,252,146,13,0,224,229,6,0,34,229,6,0,140,0,0,0,1,0,0,0,248,146,13,0,85,53,7,0,0,0,0,0,4,147,13,0,78,230,6,0,34,229,6,0,153,0,0,0,1,0,0,0,0,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,176,84,0,0,47,0,0,0,123,4,0,0,124,4,0,0,0,0,0,0,192,84,0,0,28,3,0,0,125,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,87,0,0,0,88,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,50,0,0,0,118,0,0,0,12,147,13,0,151,232,6,0,121,231,6,0,186,0,0,0,1,0,0,0,8,147,13,0,85,53,7,0,0,0,0,0,20,147,13,0,65,233,6,0,121,231,6,0,198,0,0,0,1,0,0,0,16,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,240,84,0,0,28,3,0,0,126,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,89,0,0,0,90,0,0,0,27,0,0,0,28,0,0,0,220,0,0,0,54,0,0,0,104,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,51,0,0,0,21,0,0,0,0,0,0,0,224,84,0,0,47,0,0,0,127,4,0,0,128,4,0,0,28,147,13,0,201,234,6,0,35,234,6,0,95,0,0,0,1,0,0,0,24,147,13,0,85,53,7,0,0,0,0,0,36,147,13,0,53,235,6,0,35,234,6,0,107,0,0,0,1,0,0,0,32,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,16,85,0,0,47,0,0,0,129,4,0,0,130,4,0,0,0,0,0,0,32,85,0,0,28,3,0,0,131,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,91,0,0,0,92,0,0,0,27,0,0,0,28,0,0,0,221,0,0,0,105,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,52,0,0,0,21,0,0,0,44,147,13,0,193,236,6,0,109,236,6,0,62,0,0,0,1,0,0,0,40,147,13,0,85,53,7,0,0,0,0,0,52,147,13,0,255,237,6,0,109,236,6,0,70,0,0,0,1,0,0,0,48,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,64,85,0,0,47,0,0,0,132,4,0,0,133,4,0,0,0,0,0,0,80,85,0,0,28,3,0,0,134,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,93,0,0,0,94,0,0,0,27,0,0,0,28,0,0,0,222,0,0,0,54,0,0,0,106,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,53,0,0,0,119,0,0,0,60,147,13,0,252,239,6,0,57,239,6,0,135,0,0,0,1,0,0,0,56,147,13,0,85,53,7,0,0,0,0,0,68,147,13,0,104,240,6,0,57,239,6,0,147,0,0,0,1,0,0,0,64,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,112,85,0,0,47,0,0,0,135,4,0,0,136,4,0,0,0,0,0,0,144,85,0,0,137,4,0,0,138,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,95,0,0,0,96,0,0,0,27,0,0,0,28,0,0,0,223,0,0,0,54,0,0,0,107,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,54,0,0,0,21,0,0,0,0,0,0,0,128,85,0,0,137,4,0,0,139,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,1,0,0,0,48,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,29,0,0,0,21,0,0,0,76,147,13,0,157,243,6,0,139,241,6,0,233,0,0,0,1,0,0,0,72,147,13,0,85,53,7,0,0,0,0,0,84,147,13,0,11,244,6,0,139,241,6,0,245,0,0,0,1,0,0,0,80,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,160,85,0,0,47,0,0,0,140,4,0,0,141,4,0,0,0,0,0,0,176,85,0,0,28,3,0,0,142,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,97,0,0,0,98,0,0,0,27,0,0,0,28,0,0,0,224,0,0,0,108,0,0,0,109,0,0,0,74,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,29,0,0,0,120,0,0,0,92,147,13,0,252,245,6,0,47,245,6,0,146,0,0,0,1,0,0,0,88,147,13,0,85,53,7,0,0,0,0,0,100,147,13,0,191,246,6,0,47,245,6,0,160,0,0,0,1,0,0,0,96,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,192,85,0,0,30,0,0,0,143,4,0,0,115,2,0,0,0,0,0,0,224,85,0,0,47,0,0,0,144,4,0,0,145,4,0,0,0,0,0,0,240,85,0,0,146,4,0,0,147,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,110,0,0,0,99,0,0,0,100,0,0,0,27,0,0,0,28,0,0,0,225,0,0,0,54,0,0,0,111,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,55,0,0,0,121,0,0,0,108,147,13,0,209,249,6,0,227,247,6,0,143,1,0,0,1,0,0,0,104,147,13,0,85,53,7,0,0,0,0,0,116,147,13,0,64,250,6,0,227,247,6,0,155,1,0,0,1],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+122880);allocate([112,147,13,0,85,53,7,0,0,0,0,0,175,250,6,0,227,247,6,0,46,1,0,0,6,0,0,0,190,185,17,0,51,251,6,0,65,251,6,0,175,250,6,0,227,247,6,0,47,1,0,0,1,0,0,0,190,185,17,0,35,251,6,0,33,251,6,0,175,250,6,0,227,247,6,0,47,1,0,0,1,0,0,0,190,185,17,0,17,251,6,0,33,251,6,0,0,0,0,0,16,86,0,0,47,0,0,0,148,4,0,0,149,4,0,0,0,0,0,0,32,86,0,0,150,4,0,0,151,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,112,0,0,0,101,0,0,0,102,0,0,0,27,0,0,0,28,0,0,0,226,0,0,0,54,0,0,0,113,0,0,0,73,0,0,0,56,0,0,0,227,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,29,0,0,0,122,0,0,0,124,147,13,0,8,252,6,0,114,252,6,0,12,1,0,0,1,0,0,0,120,147,13,0,85,53,7,0,0,0,0,0,132,147,13,0,188,252,6,0,114,252,6,0,23,1,0,0,1,0,0,0,128,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,64,86,0,0,47,0,0,0,152,4,0,0,153,4,0,0,0,0,0,0,80,86,0,0,154,4,0,0,155,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,114,0,0,0,103,0,0,0,104,0,0,0,27,0,0,0,28,0,0,0,228,0,0,0,115,0,0,0,116,0,0,0,75,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,56,0,0,0,123,0,0,0,117,0,0,0,118,0,0,0,0,0,0,0,144,74,0,0,154,4,0,0,156,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,1,0,0,0,48,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,29,0,0,0,21,0,0,0,140,147,13,0,91,255,6,0,244,253,6,0,199,0,0,0,1,0,0,0,136,147,13,0,85,53,7,0,0,0,0,0,148,147,13,0,132,1,7,0,244,253,6,0,213,0,0,0,1,0,0,0,144,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,96,86,0,0,157,4,0,0,158,4,0,0,116,2,0,0,0,0,0,0,112,86,0,0,47,0,0,0,159,4,0,0,160,4,0,0,0,0,0,0,128,86,0,0,161,4,0,0,162,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,105,0,0,0,106,0,0,0,27,0,0,0,28,0,0,0,229,0,0,0,119,0,0,0,120,0,0,0,73,0,0,0,121,0,0,0,30,0,0,0,230,0,0,0,122,0,0,0,30,3,0,0,57,0,0,0,124,0,0,0,62,0,0,0,116,4,7,0,149,2,7,0,51,0,0,0,1,0,0,0,190,185,17,0,218,4,7,0,116,11,7,0,156,147,13,0,35,5,7,0,149,2,7,0,230,0,0,0,1,0,0,0,152,147,13,0,85,53,7,0,0,0,0,0,164,147,13,0,186,5,7,0,149,2,7,0,242,0,0,0,1,0,0,0,160,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,160,86,0,0,47,0,0,0,163,4,0,0,164,4,0,0,0,0,0,0,176,86,0,0,28,3,0,0,165,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,123,0,0,0,107,0,0,0,108,0,0,0,27,0,0,0,28,0,0,0,231,0,0,0,54,0,0,0,124,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,58,0,0,0,21,0,0,0,172,147,13,0,157,7,7,0,62,7,7,0,182,0,0,0,1,0,0,0,168,147,13,0,85,53,7,0,0,0,0,0,180,147,13,0,148,8,7,0,62,7,7,0,194,0,0,0,1,0,0,0,176,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,208,86,0,0,47,0,0,0,166,4,0,0,167,4,0,0,0,0,0,0,224,86,0,0,28,3,0,0,168,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,125,0,0,0,109,0,0,0,110,0,0,0,27,0,0,0,28,0,0,0,232,0,0,0,126,0,0,0,127,0,0,0,73,0,0,0,128,0,0,0,30,0,0,0,31,0,0,0,129,0,0,0,30,3,0,0,59,0,0,0,125,0,0,0,188,147,13,0,184,9,7,0,36,10,7,0,57,0,0,0,1,0,0,0,184,147,13,0,85,53,7,0,0,0,0,0,196,147,13,0,249,10,7,0,36,10,7,0,65,0,0,0,1,0,0,0,192,147,13,0,85,53,7,0,0,0,0,0,249,10,7,0,36,10,7,0,81,0,0,0,1,0,0,0,140,11,7,0,172,11,7,0,188,11,7,0,249,10,7,0,36,10,7,0,91,0,0,0,1,0,0,0,190,185,17,0,125,11,7,0,116,11,7,0,249,10,7,0,36,10,7,0,91,0,0,0,1,0,0,0,190,185,17,0,101,11,7,0,116,11,7,0,0,0,0,0,0,87,0,0,47,0,0,0,169,4,0,0,170,4,0,0,0,0,0,0,16,87,0,0,171,4,0,0,172,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,111,0,0,0,112,0,0,0,27,0,0,0,28,0,0,0,233,0,0,0,54,0,0,0,130,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,60,0,0,0,21,0,0,0,216,147,13,0,144,17,7,0,3,16,7,0,157,1,0,0,1,0,0,0,212,147,13,0,85,53,7,0,0,0,0,0,224,147,13,0,129,20,7,0,3,16,7,0,172,1,0,0,1,0,0,0,220,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,48,87,0,0,47,0,0,0,173,4,0,0,174,4,0,0,0,0,0,0,80,87,0,0,175,4,0,0,176,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,131,0,0,0,113,0,0,0,114,0,0,0,27,0,0,0,28,0,0,0,234,0,0,0,54,0,0,0,132,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,61,0,0,0,21,0,0,0,0,0,0,0,64,87,0,0,175,4,0,0,177,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,1,0,0,0,48,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,29,0,0,0,21,0,0,0,232,147,13,0,202,23,7,0,8,22,7,0,235,0,0,0,1,0,0,0,228,147,13,0,85,53,7,0,0,0,0,0,240,147,13,0,91,24,7,0,8,22,7,0,247,0,0,0,1,0,0,0,236,147,13,0,85,53,7,0,0,0,0,0,0,0,0,0,96,87,0,0,47,0,0,0,178,4,0,0,179,4,0,0,0,0,0,0,112,87,0,0,180,4,0,0,181,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,133,0,0,0,115,0,0,0,116,0,0,0,27,0,0,0,28,0,0,0,235,0,0,0,134,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,62,0,0,0,21,0,0,0,248,147,13,0,162,26,7,0,141,25,7,0,96,0,0,0,1,0,0,0,244,147,13,0,85,53,7,0,0,0,0,0,0,148,13,0,164,27,7,0,141,25,7,0,104,0,0,0,1,0,0,0,252,147,13,0,85,53,7,0,0,0,0,0,164,27,7,0,141,25,7,0,130,0,0,0,4,0,0,0,190,185,17,0,64,28,7,0,54,28,7,0,164,27,7,0,141,25,7,0,130,0,0,0,4,0,0,0,190,185,17,0,44,28,7,0,54,28,7,0,164,27,7,0,141,25,7,0,131,0,0,0,4,0,0,0,190,185,17,0,36,28,7,0,27,28,7,0,164,27,7,0,141,25,7,0,131,0,0,0,4,0,0,0,190,185,17,0,18,28,7,0,27,28,7,0,0,0,0,0,144,87,0,0,47,0,0,0,182,4,0,0,183,4,0,0,0,0,0,0,160,87,0,0,184,4,0,0,185,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,135,0,0,0,117,0,0,0,118,0,0,0,27,0,0,0,28,0,0,0,236,0,0,0,54,0,0,0,136,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,63,0,0,0,21,0,0,0,8,148,13,0,173,30,7,0,47,29,7,0,59,1,0,0,1,0,0,0,4,148,13,0,85,53,7,0,0,0,0,0,16,148,13,0,189,32,7,0,47,29,7,0,71,1,0,0,1,0,0,0,12,148,13,0,85,53,7,0,0,0,0,0,0,0,0,0,176,87,0,0,30,0,0,0,186,4,0,0,117,2,0,0,0,0,0,0,224,87,0,0,187,4,0,0,188,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,137,0,0,0,119,0,0,0,120,0,0,0,27,0,0,0,28,0,0,0,237,0,0,0,138,0,0,0,139,0,0,0,76,0,0,0,56,0,0,0,238,0,0,0,239,0,0,0,57,0,0,0,30,3,0,0,64,0,0,0,126,0,0,0,121,0,0,0,0,0,0,0,208,87,0,0,47,0,0,0,189,4,0,0,190,4,0,0,24,148,13,0,129,35,7,0,15,34,7,0,234,3,0,0,1,0,0,0,20,148,13,0,85,53,7,0,0,0,0,0,32,148,13,0,94,38,7,0,15,34,7,0,245,3,0,0,1,0,0,0,28,148,13,0,85,53,7,0,0,0,0,0,0,0,0,0,240,87,0,0,191,4,0,0,192,4,0,0,118,2,0,0,0,0,0,0,192,74,0,0,193,4,0,0,194,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,1,0,0,0,48,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,29,0,0,0,21,0,0,0,0,0,0,0,0,88,0,0,193,4,0,0,195,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,140,0,0,0,1,0,0,0,48,0,0,0,27,0,0,0,28,0,0,0,237,0,0,0,54,0,0,0,55,0,0,0,76,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,29,0,0,0,21,0,0,0,1,0,0,0,0,0,0,0,32,88,0,0,196,4,0,0,197,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,141,0,0,0,122,0,0,0,123,0,0,0,27,0,0,0,28,0,0,0,237,0,0,0,142,0,0,0,143,0,0,0,76,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,65,0,0,0,127,0,0,0,124,0,0,0,0,0,0,0,16,88,0,0,47,0,0,0,198,4,0,0,199,4,0,0,40,148,13,0,116,42,7,0,15,34,7,0,210,5,0,0,1,0,0,0,36,148,13,0,85,53,7,0,0,0,0,0,48,148,13,0,74,43,7,0,15,34,7,0,222,5,0,0,1,0,0,0,44,148,13,0,85,53,7,0,0,0,0,0,0,0,0,0,64,88,0,0,30,0,0,0,200,4,0,0,119,2,0,0,0,0,0,0,48,88,0,0,30,0,0,0,201,4,0,0,120,2,0,0,0,0,0,0,96,88,0,0,47,0,0,0,202,4,0,0,203,4,0,0,0,0,0,0,112,88,0,0,204,4,0,0,205,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,144,0,0,0,125,0,0,0,126,0,0,0,240,0,0,0,241,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,66,0,0,0,21,0,0,0,127,0,0,0,121,2,0,0,122,2,0,0,123,2,0,0,56,148,13,0,254,47,7,0,127,44,7,0,0,1,0,0,1,0,0,0,52,148,13,0,85,53,7,0,0,0,0,0,64,148,13,0,154,48,7,0,127,44,7,0,8,1,0,0,1,0,0,0,60,148,13,0,85,53,7,0,0,0,0,0,0,0,0,0,128,88,0,0,47,0,0,0,206,4,0,0,207,4,0,0,0,0,0,0,160,88,0,0,208,4,0,0,209,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,145,0,0,0,128,0,0,0,129,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,67,0,0,0,21,0,0,0,0,0,0,0,144,88,0,0,210,4,0,0,211,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,1,0,0,0,48,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,29,0,0,0,21,0,0,0,72,148,13,0,224,50,7,0,149,50,7,0,124,0,0,0,1,0,0,0,68,148,13,0,85,53,7,0,0,0,0,0,80,148,13,0,75,51,7,0,149,50,7,0,132,0,0,0,1,0,0,0,76,148,13,0,85,53,7,0,0,0,0,0,0,0,0,0,176,88,0,0,47,0,0,0,212,4,0,0,213,4,0,0,0,0,0,0,192,88,0,0,28,3,0,0,214,4,0,0,29,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,6,0,0,0,7,0,0,0,53,0,0,0,130,0,0,0,131,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,54,0,0,0,55,0,0,0,73,0,0,0,56,0,0,0,30,0,0,0,31,0,0,0,57,0,0,0,30,3,0,0,68,0,0,0,21,0,0,0,88,148,13,0,90,53,7,0,230,52,7,0,83,0,0,0,1,0,0,0,84,148,13,0,85,53,7,0,0,0,0,0,96,148,13,0,247,53,7,0,230,52,7,0,91,0,0,0,1,0,0,0,92,148,13,0,85,53,7,0,0,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,24,0,0,0,16,0,0,0,20,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,4,0,0,0,8,0,0,0,0,0,0,0,1,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,92,0,0,0,24,0,0,0,40,0,0,0,56,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,8,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,12,0,0,0,0,0,0,0,224,88,0,0,215,4,0,0,216,4,0,0,197,0,0,0,147,1,0,0,242,0,0,0,148,1,0,0,149,1,0,0,217,4,0,0,150,1,0,0,198,0,0,0,199,0,0,0,243,0,0,0,151,1,0,0,124,2,0,0,36,0,0,0,152,1,0,0,128,0,0,0,44,0,0,0,125,2,0,0,126,2,0,0,46,3,0,0,45,0,0,0,127,2,0,0,46,0,0,0,128,2,0,0,0,0,0,0,255,255,255,255,44,0,0,0,7,0,0,0,14,0,0,0,24,0,0,0,16,0,0,0,255,255,255,255,100,0,0,0,26,0,0,0,255,255,255,255,32,0,0,0,33,0,0,0,255,255,255,255,20,0,0,0,232,32,8,0,24,33,8,0,48,33,8,0,152,33,8,0,184,33,8,0,0,0,0,0,240,88,0,0,218,4,0,0,219,4,0,0,197,0,0,0,153,1,0,0,244,0,0,0,154,1,0,0,155,1,0,0,220,4,0,0,156,1,0,0,198,0,0,0,199,0,0,0,245,0,0,0,157,1,0,0,129,2,0,0,36,0,0,0,158,1,0,0,129,0,0,0,44,0,0,0,130,2,0,0,131,2,0,0,46,3,0,0,45,0,0,0,132,2,0,0,46,0,0,0,133,2,0,0,0,0,0,0,0,89,0,0,221,4,0,0,222,4,0,0,197,0,0,0,159,1,0,0,246,0,0,0,160,1,0,0,161,1,0,0,223,4,0,0,162,1,0,0,198,0,0,0,199,0,0,0,247,0,0,0,163,1,0,0,134,2,0,0,36,0,0,0,164,1,0,0,130,0,0,0,44,0,0,0,135,2,0,0,136,2,0,0,46,3,0,0,45,0,0,0,137,2,0,0,46,0,0,0,138,2,0,0,0,0,0,0,16,89,0,0,224,4,0,0,225,4,0,0,197,0,0,0,165,1,0,0,248,0,0,0,166,1,0,0,167,1,0,0,226,4,0,0,168,1,0,0,198,0,0,0,199,0,0,0,249,0,0,0,169,1,0,0,139,2,0,0,36,0,0,0,170,1,0,0,131,0,0,0,44,0,0,0,140,2,0,0,141,2,0,0,46,3,0,0,45,0,0,0,142,2,0,0,46,0,0,0,143,2,0,0,0,0,0,0,32,89,0,0,227,4,0,0,228,4,0,0,250,0,0,0,132,0,0,0,251,0,0,0,27,0,0,0,222,0,0,0,223,0,0,0,171,1,0,0,172,1,0,0,229,4,0,0,230,4,0,0,224,0,0,0,225,0,0,0,60,0,0,0,226,0,0,0,173,1,0,0,174,1,0,0,144,2,0,0,0,0,0,0,48,89,0,0,231,4,0,0,232,4,0,0,145,2,0,0,175,1,0,0,252,0,0,0,176,1,0,0,55,0,0,0,233,4,0,0,177,1,0,0,198,0,0,0,146,2,0,0,253,0,0,0,178,1,0,0,147,2,0,0,36,0,0,0,179,1,0,0,133,0,0,0,44,0,0,0,213,0,0,0,148,2,0,0,46,3,0,0,180,1,0,0,215,0,0,0,46,0,0,0,149,2,0,0,181,1,0,0,182,1,0,0,0,0,0,0,80,89,0,0,231,4,0,0,234,4,0,0,145,2,0,0,175,1,0,0,252,0,0,0,176,1,0,0,55,0,0,0,233,4,0,0,177,1,0,0,198,0,0,0,146,2,0,0,253,0,0,0,178,1,0,0,147,2,0,0,36,0,0,0,179,1,0,0,133,0,0,0,44,0,0,0,213,0,0,0,228,0,0,0,46,3,0,0,180,1,0,0,215,0,0,0,46,0,0,0,1,0,0,0,181,1,0,0,182,1,0,0,0,0,0,0,64,89,0,0,235,4,0,0,236,4,0,0,145,2,0,0,175,1,0,0,252,0,0,0,176,1,0,0,55,0,0,0,233,4,0,0,177,1,0,0,198,0,0,0,146,2,0,0,253,0,0,0,178,1,0,0,147,2,0,0,36,0,0,0,179,1,0,0,133,0,0,0,44,0,0,0,213,0,0,0,228,0,0,0,46,3,0,0,180,1,0,0,215,0,0,0,46,0,0,0,1,0,0,0,181,1,0,0,182,1,0,0,0,0,0,0,96,89,0,0,231,4,0,0,237,4,0,0,145,2,0,0,175,1,0,0,252,0,0,0,176,1,0,0,55,0,0,0,233,4,0,0,177,1,0,0,198,0,0,0,146,2,0,0,253,0,0,0,178,1,0,0,147,2,0,0,36,0,0,0,179,1,0,0,133,0,0,0,44,0,0,0,213,0,0,0,148,2,0,0,46,3,0,0,180,1,0,0,215,0,0,0,46,0,0,0,149,2,0,0,183,1,0,0,184,1,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,12,0,0,0,28,0,0,0,16,0,0,0,20,0,0,0,24,0,0,0,32,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,12,0,0,0,20,0,0,0,16,0,0,0,40,0,0,0,32,0,0,0,24,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,56,0,0,0,8,0,0,0,24,0,0,0,40,0,0,0,68,0,0,0,60,0,0,0,64,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,12,0,0,0,8,0,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,8,0,0,0,0,0,0,0,112,89,0,0,238,4,0,0,239,4,0,0,197,0,0,0,185,1,0,0,254,0,0,0,186,1,0,0,187,1,0,0,240,4,0,0,188,1,0,0,198,0,0,0,199,0,0,0,255,0,0,0,189,1,0,0,150,2,0,0,36,0,0,0,190,1,0,0,134,0,0,0,44,0,0,0,151,2,0,0,152,2,0,0,46,3,0,0,45,0,0,0,153,2,0,0,46,0,0,0,154,2,0,0,0,0,0,0,255,255,255,255,40,0,0,0,12,0,0,0,255,255,255,255,48,0,0,0,24,0,0,0,255,255,255,255,80,0,0,0,40,0,0,0,255,255,255,255,20,0,0,0,47,0,0,0,255,255,255,255,28,0,0,0,248,33,8,0,32,34,8,0,80,34,8,0,160,34,8,0,184,34,8,0,0,0,0,0,128,89,0,0,241,4,0,0,242,4,0,0,197,0,0,0,191,1,0,0,0,1,0,0,192,1,0,0,193,1,0,0,243,4,0,0,194,1,0,0,198,0,0,0,199,0,0,0,1,1,0,0,195,1,0,0,155,2,0,0,36,0,0,0,196,1,0,0,135,0,0,0,44,0,0,0,156,2,0,0,157,2,0,0,46,3,0,0,45,0,0,0,158,2,0,0,46,0,0,0,159,2,0,0,0,0,0,0,144,89,0,0,244,4,0,0,245,4,0,0,197,0,0,0,197,1,0,0,2,1,0,0,198,1,0,0,199,1,0,0,246,4,0,0,200,1,0,0,198,0,0,0,199,0,0,0,3,1,0,0,201,1,0,0,160,2,0,0,36,0,0,0,202,1,0,0,136,0,0,0,44,0,0,0,161,2,0,0,162,2,0,0,46,3,0,0,45,0,0,0,163,2,0,0,46,0,0,0,164,2,0,0,0,0,0,0,160,89,0,0,247,4,0,0,248,4,0,0,197,0,0,0,203,1,0,0,4,1,0,0,204,1,0,0,205,1,0,0,249,4,0,0,206,1,0,0,198,0,0,0,199,0,0,0,5,1,0,0,207,1,0,0,165,2,0,0,36,0,0,0,208,1,0,0,137,0,0,0,44,0,0,0,166,2,0,0,167,2,0,0,46,3,0,0,45,0,0,0,168,2,0,0,46,0,0,0,169,2,0,0,0,0,0,0,176,89,0,0,250,4,0,0,251,4,0,0,197,0,0,0,209,1,0,0,6,1,0,0,210,1,0,0,211,1,0,0,252,4,0,0,212,1,0,0,198,0,0,0,199,0,0,0,7,1,0,0,213,1,0,0,170,2,0,0,36,0,0,0,214,1,0,0,138,0,0,0,44,0,0,0,171,2,0,0,172,2,0,0,46,3,0,0,45,0,0,0,173,2,0,0,46,0,0,0,174,2,0,0,255,255,255,255,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,24,0,0,0,28,0,0,0,8,0,0,0,0,0,0,0,192,89,0,0,253,4,0,0,254,4,0,0,197,0,0,0,215,1,0,0,8,1,0,0,216,1,0,0,217,1,0,0,255,4,0,0,218,1,0,0,198,0,0,0,199,0,0,0,9,1,0,0,219,1,0,0,175,2,0,0,36,0,0,0,220,1,0,0,139,0,0,0,44,0,0,0,176,2,0,0,177,2,0,0,46,3,0,0,45,0,0,0,178,2,0,0,46,0,0,0,179,2,0,0,0,0,0,0,255,255,255,255,36,0,0,0,0,35,8,0,68,74,7,0,84,74,7,0,190,185,17,0,95,74,7,0,106,74,7,0,119,74,7,0,130,74,7,0,150,74,7,0,163,74,7,0,190,185,17,0,0,0,0,0,150,48,7,119,44,97,14,238,186,81,9,153,25,196,109,7,143,244,106,112,53,165,99,233,163,149,100,158,50,136,219,14,164,184,220,121,30,233,213,224,136,217,210,151,43,76,182,9,189,124,177,126,7,45,184,231,145,29,191,144,100,16,183,29,242,32,176,106,72,113,185,243,222,65,190,132,125,212,218,26,235,228,221,109,81,181,212,244,199,133,211,131,86,152,108,19,192,168,107,100,122,249,98,253,236,201,101,138,79,92,1,20,217,108,6,99,99,61,15,250,245,13,8,141,200,32,110,59,94,16,105,76,228,65,96,213,114,113,103,162,209,228,3,60,71,212,4,75,253,133,13,210,107,181,10,165,250,168,181,53,108,152,178,66,214,201,187,219,64,249,188,172,227,108,216,50,117,92,223,69,207,13,214,220,89,61,209,171,172,48,217,38,58,0,222,81,128,81,215,200,22,97,208,191,181,244,180,33,35,196,179,86,153,149,186,207,15,165,189,184,158,184,2,40,8,136,5,95,178,217,12,198,36,233,11,177,135,124,111,47,17,76,104,88,171,29,97,193,61,45,102,182,144,65,220,118,6,113,219,1,188,32,210,152,42,16,213,239,137,133,177,113,31,181,182,6,165,228,191,159,51,212,184,232,162,201,7,120,52,249,0,15,142,168,9,150,24,152,14,225,187,13,106,127,45,61,109,8,151,108,100,145,1,92,99,230,244,81,107,107,98,97,108,28,216,48,101,133,78,0,98,242,237,149,6,108,123,165,1,27,193,244,8,130,87,196,15,245,198,217,176,101,80,233,183,18,234,184,190,139,124,136,185,252,223,29,221,98,73,45,218,21,243,124,211,140,101,76,212,251,88,97,178,77,206,81,181,58,116,0,188,163,226,48,187,212,65,165,223,74,215,149,216,61,109,196,209,164,251,244,214,211,106,233,105,67,252,217,110,52,70,136,103,173,208,184,96,218,115,45,4,68,229,29,3,51,95,76,10,170,201,124,13,221,60,113,5,80,170,65,2,39,16,16,11,190,134,32,12,201,37,181,104,87,179,133,111,32,9,212,102,185,159,228,97,206,14,249,222,94,152,201,217,41,34,152,208,176,180,168,215,199,23,61,179,89,129,13,180,46,59,92,189,183,173,108,186,192,32,131,184,237,182,179,191,154,12,226,182,3,154,210,177,116,57,71,213,234,175,119,210,157,21,38,219,4,131,22,220,115,18,11,99,227,132,59,100,148,62,106,109,13,168,90,106,122,11,207,14,228,157,255,9,147,39,174,0,10,177,158,7,125,68,147,15,240,210,163,8,135,104,242,1,30,254,194,6,105,93,87,98,247,203,103,101,128,113,54,108,25,231,6,107,110,118,27,212,254,224,43,211,137,90,122,218,16,204,74,221,103,111,223,185,249,249,239,190,142,67,190,183,23,213,142,176,96,232,163,214,214,126,147,209,161,196,194,216,56,82,242,223,79,241,103,187,209,103,87,188,166,221,6,181,63,75,54,178,72,218,43,13,216,76,27,10,175,246,74,3,54,96,122,4,65,195,239,96,223,85,223,103,168,239,142,110,49,121,190,105,70,140,179,97,203,26,131,102,188,160,210,111,37,54,226,104,82,149,119,12,204,3,71,11,187,185,22,2,34,47,38,5,85,190,59,186,197,40,11,189,178,146,90,180,43,4,106,179,92,167,255,215,194,49,207,208,181,139,158,217,44,29,174,222,91,176,194,100,155,38,242,99,236,156,163,106,117,10,147,109,2,169,6,9,156,63,54,14,235,133,103,7,114,19,87,0,5,130,74,191,149,20,122,184,226,174,43,177,123,56,27,182,12,155,142,210,146,13,190,213,229,183,239,220,124,33,223,219,11,212,210,211,134,66,226,212,241,248,179,221,104,110,131,218,31,205,22,190,129,91,38,185,246,225,119,176,111,119,71,183,24,230,90,8,136,112,106,15,255,202,59,6,102,92,11,1,17,255,158,101,143,105,174,98,248,211,255,107,97,69,207,108,22,120,226,10,160,238,210,13,215,84,131,4,78,194,179,3,57,97,38,103,167,247,22,96,208,77,71,105,73,219,119,110,62,74,106,209,174,220,90,214,217,102,11,223,64,240,59,216,55,83,174,188,169,197,158,187,222,127,207,178,71,233,255,181,48,28,242,189,189,138,194,186,202,48,147,179,83,166,163,180,36,5,54,208,186,147,6,215,205,41,87,222,84,191,103,217,35,46,122,102,179,184,74,97,196,2,27,104,93,148,43,111,42,55,190,11,180,161,142,12,195,27,223,5,90,141,239,2,45,0,0,0,0,65,49,27,25,130,98,54,50,195,83,45,43,4,197,108,100,69,244,119,125,134,167,90,86,199,150,65,79,8,138,217,200,73,187,194,209,138,232,239,250,203,217,244,227,12,79,181,172,77,126,174,181,142,45,131,158,207,28,152,135,81,18,194,74,16,35,217,83,211,112,244,120,146,65,239,97,85,215,174,46,20,230,181,55,215,181,152,28,150,132,131,5,89,152,27,130,24,169,0,155,219,250,45,176,154,203,54,169,93,93,119,230,28,108,108,255,223,63,65,212,158,14,90,205,162,36,132,149,227,21,159,140,32,70,178,167,97,119,169,190,166,225,232,241,231,208,243,232,36,131,222,195,101,178,197,218,170,174,93,93,235,159,70,68,40,204,107,111,105,253,112,118,174,107,49,57,239,90,42,32,44,9,7,11,109,56,28,18,243,54,70,223,178,7,93,198,113,84,112,237,48,101,107,244,247,243,42,187,182,194,49,162,117,145,28,137,52,160,7,144,251,188,159,23,186,141,132,14,121,222,169,37,56,239,178,60,255,121,243,115,190,72,232,106,125,27,197,65,60,42,222,88,5,79,121,240,68,126,98,233,135,45,79,194,198,28,84,219,1,138,21,148,64,187,14,141,131,232,35,166,194,217,56,191,13,197,160,56,76,244,187,33,143,167,150,10,206,150,141,19,9,0,204,92,72,49,215,69,139,98,250,110,202,83,225,119,84,93,187,186,21,108,160,163,214,63,141,136,151,14,150,145,80,152,215,222,17,169,204,199,210,250,225,236,147,203,250,245,92,215,98,114,29,230,121,107,222,181,84,64,159,132,79,89,88,18,14,22,25,35,21,15,218,112,56,36,155,65,35,61,167,107,253,101,230,90,230,124,37,9,203,87,100,56,208,78,163,174,145,1,226,159,138,24,33,204,167,51,96,253,188,42,175,225,36,173,238,208,63,180,45,131,18,159,108,178,9,134,171,36,72,201,234,21,83,208,41,70,126,251,104,119,101,226,246,121,63,47,183,72,36,54,116,27,9,29,53,42,18,4,242,188,83,75,179,141,72,82,112,222,101,121,49,239,126,96,254,243,230,231,191,194,253,254,124,145,208,213,61,160,203,204,250,54,138,131,187,7,145,154,120,84,188,177,57,101,167,168,75,152,131,59,10,169,152,34,201,250,181,9,136,203,174,16,79,93,239,95,14,108,244,70,205,63,217,109,140,14,194,116,67,18,90,243,2,35,65,234,193,112,108,193,128,65,119,216,71,215,54,151,6,230,45,142,197,181,0,165,132,132,27,188,26,138,65,113,91,187,90,104,152,232,119,67,217,217,108,90,30,79,45,21,95,126,54,12,156,45,27,39,221,28,0,62,18,0,152,185,83,49,131,160,144,98,174,139,209,83,181,146,22,197,244,221,87,244,239,196,148,167,194,239,213,150,217,246,233,188,7,174,168,141,28,183,107,222,49,156,42,239,42,133,237,121,107,202,172,72,112,211,111,27,93,248,46,42,70,225,225,54,222,102,160,7,197,127,99,84,232,84,34,101,243,77,229,243,178,2,164,194,169,27,103,145,132,48,38,160,159,41,184,174,197,228,249,159,222,253,58,204,243,214,123,253,232,207,188,107,169,128,253,90,178,153,62,9,159,178,127,56,132,171,176,36,28,44,241,21,7,53,50,70,42,30,115,119,49,7,180,225,112,72,245,208,107,81,54,131,70,122,119,178,93,99,78,215,250,203,15,230,225,210,204,181,204,249,141,132,215,224,74,18,150,175,11,35,141,182,200,112,160,157,137,65,187,132,70,93,35,3,7,108,56,26,196,63,21,49,133,14,14,40,66,152,79,103,3,169,84,126,192,250,121,85,129,203,98,76,31,197,56,129,94,244,35,152,157,167,14,179,220,150,21,170,27,0,84,229,90,49,79,252,153,98,98,215,216,83,121,206,23,79,225,73,86,126,250,80,149,45,215,123,212,28,204,98,19,138,141,45,82,187,150,52,145,232,187,31,208,217,160,6,236,243,126,94,173,194,101,71,110,145,72,108,47,160,83,117,232,54,18,58,169,7,9,35,106,84,36,8,43,101,63,17,228,121,167,150,165,72,188,143,102,27,145,164,39,42,138,189,224,188,203,242,161,141,208,235,98,222,253,192,35,239,230,217,189,225,188,20,252,208,167,13,63,131,138,38,126,178,145,63,185,36,208,112,248,21,203,105,59,70,230,66,122,119,253,91,181,107,101,220,244,90,126,197,55,9,83,238,118,56,72,247,177,174,9,184,240,159,18,161,51,204,63,138,114,253,36,147,0,0,0,0,55,106,194,1,110,212,132,3,89,190,70,2,220,168,9,7,235,194,203,6,178,124,141,4,133,22,79,5,184,81,19,14,143,59,209,15,214,133,151,13,225,239,85,12,100,249,26,9,83,147,216,8,10,45,158,10,61,71,92,11,112,163,38,28,71,201,228,29,30,119,162,31,41,29,96,30,172,11,47,27,155,97,237,26,194,223,171,24,245,181,105,25,200,242,53,18,255,152,247,19,166,38,177,17,145,76,115,16,20,90,60,21,35,48,254,20,122,142,184,22,77,228,122,23,224,70,77,56,215,44,143,57,142,146,201,59,185,248,11,58,60,238,68,63,11,132,134,62,82,58,192,60,101,80,2,61,88,23,94,54,111,125,156,55,54,195,218,53,1,169,24,52,132,191,87,49,179,213,149,48,234,107,211,50,221,1,17,51,144,229,107,36,167,143,169,37,254,49,239,39,201,91,45,38,76,77,98,35,123,39,160,34,34,153,230,32,21,243,36,33,40,180,120,42,31,222,186,43,70,96,252,41,113,10,62,40,244,28,113,45,195,118,179,44,154,200,245,46,173,162,55,47,192,141,154,112,247,231,88,113,174,89,30,115,153,51,220,114,28,37,147,119,43,79,81,118,114,241,23,116,69,155,213,117,120,220,137,126,79,182,75,127,22,8,13,125,33,98,207,124,164,116,128,121,147,30,66,120,202,160,4,122,253,202,198,123,176,46,188,108,135,68,126,109,222,250,56,111,233,144,250,110,108,134,181,107,91,236,119,106,2,82,49,104,53,56,243,105,8,127,175,98,63,21,109,99,102,171,43,97,81,193,233,96,212,215,166,101,227,189,100,100,186,3,34,102,141,105,224,103,32,203,215,72,23,161,21,73,78,31,83,75,121,117,145,74,252,99,222,79,203,9,28,78,146,183,90,76,165,221,152,77,152,154,196,70,175,240,6,71,246,78,64,69,193,36,130,68,68,50,205,65,115,88,15,64,42,230,73,66,29,140,139,67,80,104,241,84,103,2,51,85,62,188,117,87,9,214,183,86,140,192,248,83,187,170,58,82,226,20,124,80,213,126,190,81,232,57,226,90,223,83,32,91,134,237,102,89,177,135,164,88,52,145,235,93,3,251,41,92,90,69,111,94,109,47,173,95,128,27,53,225,183,113,247,224,238,207,177,226,217,165,115,227,92,179,60,230,107,217,254,231,50,103,184,229,5,13,122,228,56,74,38,239,15,32,228,238,86,158,162,236,97,244,96,237,228,226,47,232,211,136,237,233,138,54,171,235,189,92,105,234,240,184,19,253,199,210,209,252,158,108,151,254,169,6,85,255,44,16,26,250,27,122,216,251,66,196,158,249,117,174,92,248,72,233,0,243,127,131,194,242,38,61,132,240,17,87,70,241,148,65,9,244,163,43,203,245,250,149,141,247,205,255,79,246,96,93,120,217,87,55,186,216,14,137,252,218,57,227,62,219,188,245,113,222,139,159,179,223,210,33,245,221,229,75,55,220,216,12,107,215,239,102,169,214,182,216,239,212,129,178,45,213,4,164,98,208,51,206,160,209,106,112,230,211,93,26,36,210,16,254,94,197,39,148,156,196,126,42,218,198,73,64,24,199,204,86,87,194,251,60,149,195,162,130,211,193,149,232,17,192,168,175,77,203,159,197,143,202,198,123,201,200,241,17,11,201,116,7,68,204,67,109,134,205,26,211,192,207,45,185,2,206,64,150,175,145,119,252,109,144,46,66,43,146,25,40,233,147,156,62,166,150,171,84,100,151,242,234,34,149,197,128,224,148,248,199,188,159,207,173,126,158,150,19,56,156,161,121,250,157,36,111,181,152,19,5,119,153,74,187,49,155,125,209,243,154,48,53,137,141,7,95,75,140,94,225,13,142,105,139,207,143,236,157,128,138,219,247,66,139,130,73,4,137,181,35,198,136,136,100,154,131,191,14,88,130,230,176,30,128,209,218,220,129,84,204,147,132,99,166,81,133,58,24,23,135,13,114,213,134,160,208,226,169,151,186,32,168,206,4,102,170,249,110,164,171,124,120,235,174,75,18,41,175,18,172,111,173,37,198,173,172,24,129,241,167,47,235,51,166,118,85,117,164,65,63,183,165,196,41,248,160,243,67,58,161,170,253,124,163,157,151,190,162,208,115,196,181,231,25,6,180,190,167,64,182,137,205,130,183,12,219,205,178,59,177,15,179,98,15,73,177,85,101,139,176,104,34,215,187,95,72,21,186,6,246,83,184,49,156,145,185,180,138,222,188,131,224,28,189,218,94,90,191,237,52,152,190,0,0,0,0,101,103,188,184,139,200,9,170,238,175,181,18,87,151,98,143,50,240,222,55,220,95,107,37,185,56,215,157,239,40,180,197,138,79,8,125,100,224,189,111,1,135,1,215,184,191,214,74,221,216,106,242,51,119,223,224,86,16,99,88,159,87,25,80,250,48,165,232,20,159,16,250,113,248,172,66,200,192,123,223,173,167,199,103,67,8,114,117,38,111,206,205,112,127,173,149,21,24,17,45,251,183,164,63,158,208,24,135,39,232,207,26,66,143,115,162,172,32,198,176,201,71,122,8,62,175,50,160,91,200,142,24,181,103,59,10,208,0,135,178,105,56,80,47,12,95,236,151,226,240,89,133,135,151,229,61,209,135,134,101,180,224,58,221,90,79,143,207,63,40,51,119,134,16,228,234,227,119,88,82,13,216,237,64,104,191,81,248,161,248,43,240,196,159,151,72,42,48,34,90,79,87,158,226,246,111,73,127,147,8,245,199,125,167,64,213,24,192,252,109,78,208,159,53,43,183,35,141,197,24,150,159,160,127,42,39,25,71,253,186,124,32,65,2,146,143,244,16,247,232,72,168,61,88,20,155,88,63,168,35,182,144,29,49,211,247,161,137,106,207,118,20,15,168,202,172,225,7,127,190,132,96,195,6,210,112,160,94,183,23,28,230,89,184,169,244,60,223,21,76,133,231,194,209,224,128,126,105,14,47,203,123,107,72,119,195,162,15,13,203,199,104,177,115,41,199,4,97,76,160,184,217,245,152,111,68,144,255,211,252,126,80,102,238,27,55,218,86,77,39,185,14,40,64,5,182,198,239,176,164,163,136,12,28,26,176,219,129,127,215,103,57,145,120,210,43,244,31,110,147,3,247,38,59,102,144,154,131,136,63,47,145,237,88,147,41,84,96,68,180,49,7,248,12,223,168,77,30,186,207,241,166,236,223,146,254,137,184,46,70,103,23,155,84,2,112,39,236,187,72,240,113,222,47,76,201,48,128,249,219,85,231,69,99,156,160,63,107,249,199,131,211,23,104,54,193,114,15,138,121,203,55,93,228,174,80,225,92,64,255,84,78,37,152,232,246,115,136,139,174,22,239,55,22,248,64,130,4,157,39,62,188,36,31,233,33,65,120,85,153,175,215,224,139,202,176,92,51,59,182,89,237,94,209,229,85,176,126,80,71,213,25,236,255,108,33,59,98,9,70,135,218,231,233,50,200,130,142,142,112,212,158,237,40,177,249,81,144,95,86,228,130,58,49,88,58,131,9,143,167,230,110,51,31,8,193,134,13,109,166,58,181,164,225,64,189,193,134,252,5,47,41,73,23,74,78,245,175,243,118,34,50,150,17,158,138,120,190,43,152,29,217,151,32,75,201,244,120,46,174,72,192,192,1,253,210,165,102,65,106,28,94,150,247,121,57,42,79,151,150,159,93,242,241,35,229,5,25,107,77,96,126,215,245,142,209,98,231,235,182,222,95,82,142,9,194,55,233,181,122,217,70,0,104,188,33,188,208,234,49,223,136,143,86,99,48,97,249,214,34,4,158,106,154,189,166,189,7,216,193,1,191,54,110,180,173,83,9,8,21,154,78,114,29,255,41,206,165,17,134,123,183,116,225,199,15,205,217,16,146,168,190,172,42,70,17,25,56,35,118,165,128,117,102,198,216,16,1,122,96,254,174,207,114,155,201,115,202,34,241,164,87,71,150,24,239,169,57,173,253,204,94,17,69,6,238,77,118,99,137,241,206,141,38,68,220,232,65,248,100,81,121,47,249,52,30,147,65,218,177,38,83,191,214,154,235,233,198,249,179,140,161,69,11,98,14,240,25,7,105,76,161,190,81,155,60,219,54,39,132,53,153,146,150,80,254,46,46,153,185,84,38,252,222,232,158,18,113,93,140,119,22,225,52,206,46,54,169,171,73,138,17,69,230,63,3,32,129,131,187,118,145,224,227,19,246,92,91,253,89,233,73,152,62,85,241,33,6,130,108,68,97,62,212,170,206,139,198,207,169,55,126,56,65,127,214,93,38,195,110,179,137,118,124,214,238,202,196,111,214,29,89,10,177,161,225,228,30,20,243,129,121,168,75,215,105,203,19,178,14,119,171,92,161,194,185,57,198,126,1,128,254,169,156,229,153,21,36,11,54,160,54,110,81,28,142,167,22,102,134,194,113,218,62,44,222,111,44,73,185,211,148,240,129,4,9,149,230,184,177,123,73,13,163,30,46,177,27,72,62,210,67,45,89,110,251,195,246,219,233,166,145,103,81,31,169,176,204,122,206,12,116,148,97,185,102,241,6,5,222,0,0,0,0,119,7,48,150,238,14,97,44,153,9,81,186,7,109,196,25,112,106,244,143,233,99,165,53,158,100,149,163,14,219,136,50,121,220,184,164,224,213,233,30,151,210,217,136,9,182,76,43,126,177,124,189,231,184,45,7,144,191,29,145,29,183,16,100,106,176,32,242,243,185,113,72,132,190,65,222,26,218,212,125,109,221,228,235,244,212,181,81,131,211,133,199,19,108,152,86,100,107,168,192,253,98,249,122,138,101,201,236,20,1,92,79,99,6,108,217,250,15,61,99,141,8,13,245,59,110,32,200,76,105,16,94,213,96,65,228,162,103,113,114,60,3,228,209,75,4,212,71,210,13,133,253,165,10,181,107,53,181,168,250,66,178,152,108,219,187,201,214,172,188,249,64,50,216,108,227,69,223,92,117,220,214,13,207,171,209,61,89,38,217,48,172,81,222,0,58,200,215,81,128,191,208,97,22,33,180,244,181,86,179,196,35,207,186,149,153,184,189,165,15,40,2,184,158,95,5,136,8,198,12,217,178,177,11,233,36,47,111,124,135,88,104,76,17,193,97,29,171,182,102,45,61,118,220,65,144,1,219,113,6,152,210,32,188,239,213,16,42,113,177,133,137,6,182,181,31,159,191,228,165],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+133120);allocate([232,184,212,51,120,7,201,162,15,0,249,52,150,9,168,142,225,14,152,24,127,106,13,187,8,109,61,45,145,100,108,151,230,99,92,1,107,107,81,244,28,108,97,98,133,101,48,216,242,98,0,78,108,6,149,237,27,1,165,123,130,8,244,193,245,15,196,87,101,176,217,198,18,183,233,80,139,190,184,234,252,185,136,124,98,221,29,223,21,218,45,73,140,211,124,243,251,212,76,101,77,178,97,88,58,181,81,206,163,188,0,116,212,187,48,226,74,223,165,65,61,216,149,215,164,209,196,109,211,214,244,251,67,105,233,106,52,110,217,252,173,103,136,70,218,96,184,208,68,4,45,115,51,3,29,229,170,10,76,95,221,13,124,201,80,5,113,60,39,2,65,170,190,11,16,16,201,12,32,134,87,104,181,37,32,111,133,179,185,102,212,9,206,97,228,159,94,222,249,14,41,217,201,152,176,208,152,34,199,215,168,180,89,179,61,23,46,180,13,129,183,189,92,59,192,186,108,173,237,184,131,32,154,191,179,182,3,182,226,12,116,177,210,154,234,213,71,57,157,210,119,175,4,219,38,21,115,220,22,131,227,99,11,18,148,100,59,132,13,109,106,62,122,106,90,168,228,14,207,11,147,9,255,157,10,0,174,39,125,7,158,177,240,15,147,68,135,8,163,210,30,1,242,104,105,6,194,254,247,98,87,93,128,101,103,203,25,108,54,113,110,107,6,231,254,212,27,118,137,211,43,224,16,218,122,90,103,221,74,204,249,185,223,111,142,190,239,249,23,183,190,67,96,176,142,213,214,214,163,232,161,209,147,126,56,216,194,196,79,223,242,82,209,187,103,241,166,188,87,103,63,181,6,221,72,178,54,75,216,13,43,218,175,10,27,76,54,3,74,246,65,4,122,96,223,96,239,195,168,103,223,85,49,110,142,239,70,105,190,121,203,97,179,140,188,102,131,26,37,111,210,160,82,104,226,54,204,12,119,149,187,11,71,3,34,2,22,185,85,5,38,47,197,186,59,190,178,189,11,40,43,180,90,146,92,179,106,4,194,215,255,167,181,208,207,49,44,217,158,139,91,222,174,29,155,100,194,176,236,99,242,38,117,106,163,156,2,109,147,10,156,9,6,169,235,14,54,63,114,7,103,133,5,0,87,19,149,191,74,130,226,184,122,20,123,177,43,174,12,182,27,56,146,210,142,155,229,213,190,13,124,220,239,183,11,219,223,33,134,211,210,212,241,212,226,66,104,221,179,248,31,218,131,110,129,190,22,205,246,185,38,91,111,176,119,225,24,183,71,119,136,8,90,230,255,15,106,112,102,6,59,202,17,1,11,92,143,101,158,255,248,98,174,105,97,107,255,211,22,108,207,69,160,10,226,120,215,13,210,238,78,4,131,84,57,3,179,194,167,103,38,97,208,96,22,247,73,105,71,77,62,110,119,219,174,209,106,74,217,214,90,220,64,223,11,102,55,216,59,240,169,188,174,83,222,187,158,197,71,178,207,127,48,181,255,233,189,189,242,28,202,186,194,138,83,179,147,48,36,180,163,166,186,208,54,5,205,215,6,147,84,222,87,41,35,217,103,191,179,102,122,46,196,97,74,184,93,104,27,2,42,111,43,148,180,11,190,55,195,12,142,161,90,5,223,27,45,2,239,141,0,0,0,0,25,27,49,65,50,54,98,130,43,45,83,195,100,108,197,4,125,119,244,69,86,90,167,134,79,65,150,199,200,217,138,8,209,194,187,73,250,239,232,138,227,244,217,203,172,181,79,12,181,174,126,77,158,131,45,142,135,152,28,207,74,194,18,81,83,217,35,16,120,244,112,211,97,239,65,146,46,174,215,85,55,181,230,20,28,152,181,215,5,131,132,150,130,27,152,89,155,0,169,24,176,45,250,219,169,54,203,154,230,119,93,93,255,108,108,28,212,65,63,223,205,90,14,158,149,132,36,162,140,159,21,227,167,178,70,32,190,169,119,97,241,232,225,166,232,243,208,231,195,222,131,36,218,197,178,101,93,93,174,170,68,70,159,235,111,107,204,40,118,112,253,105,57,49,107,174,32,42,90,239,11,7,9,44,18,28,56,109,223,70,54,243,198,93,7,178,237,112,84,113,244,107,101,48,187,42,243,247,162,49,194,182,137,28,145,117,144,7,160,52,23,159,188,251,14,132,141,186,37,169,222,121,60,178,239,56,115,243,121,255,106,232,72,190,65,197,27,125,88,222,42,60,240,121,79,5,233,98,126,68,194,79,45,135,219,84,28,198,148,21,138,1,141,14,187,64,166,35,232,131,191,56,217,194,56,160,197,13,33,187,244,76,10,150,167,143,19,141,150,206,92,204,0,9,69,215,49,72,110,250,98,139,119,225,83,202,186,187,93,84,163,160,108,21,136,141,63,214,145,150,14,151,222,215,152,80,199,204,169,17,236,225,250,210,245,250,203,147,114,98,215,92,107,121,230,29,64,84,181,222,89,79,132,159,22,14,18,88,15,21,35,25,36,56,112,218,61,35,65,155,101,253,107,167,124,230,90,230,87,203,9,37,78,208,56,100,1,145,174,163,24,138,159,226,51,167,204,33,42,188,253,96,173,36,225,175,180,63,208,238,159,18,131,45,134,9,178,108,201,72,36,171,208,83,21,234,251,126,70,41,226,101,119,104,47,63,121,246,54,36,72,183,29,9,27,116,4,18,42,53,75,83,188,242,82,72,141,179,121,101,222,112,96,126,239,49,231,230,243,254,254,253,194,191,213,208,145,124,204,203,160,61,131,138,54,250,154,145,7,187,177,188,84,120,168,167,101,57,59,131,152,75,34,152,169,10,9,181,250,201,16,174,203,136,95,239,93,79,70,244,108,14,109,217,63,205,116,194,14,140,243,90,18,67,234,65,35,2,193,108,112,193,216,119,65,128,151,54,215,71,142,45,230,6,165,0,181,197,188,27,132,132,113,65,138,26,104,90,187,91,67,119,232,152,90,108,217,217,21,45,79,30,12,54,126,95,39,27,45,156,62,0,28,221,185,152,0,18,160,131,49,83,139,174,98,144,146,181,83,209,221,244,197,22,196,239,244,87,239,194,167,148,246,217,150,213,174,7,188,233,183,28,141,168,156,49,222,107,133,42,239,42,202,107,121,237,211,112,72,172,248,93,27,111,225,70,42,46,102,222,54,225,127,197,7,160,84,232,84,99,77,243,101,34,2,178,243,229,27,169,194,164,48,132,145,103,41,159,160,38,228,197,174,184,253,222,159,249,214,243,204,58,207,232,253,123,128,169,107,188,153,178,90,253,178,159,9,62,171,132,56,127,44,28,36,176,53,7,21,241,30,42,70,50,7,49,119,115,72,112,225,180,81,107,208,245,122,70,131,54,99,93,178,119,203,250,215,78,210,225,230,15,249,204,181,204,224,215,132,141,175,150,18,74,182,141,35,11,157,160,112,200,132,187,65,137,3,35,93,70,26,56,108,7,49,21,63,196,40,14,14,133,103,79,152,66,126,84,169,3,85,121,250,192,76,98,203,129,129,56,197,31,152,35,244,94,179,14,167,157,170,21,150,220,229,84,0,27,252,79,49,90,215,98,98,153,206,121,83,216,73,225,79,23,80,250,126,86,123,215,45,149,98,204,28,212,45,141,138,19,52,150,187,82,31,187,232,145,6,160,217,208,94,126,243,236,71,101,194,173,108,72,145,110,117,83,160,47,58,18,54,232,35,9,7,169,8,36,84,106,17,63,101,43,150,167,121,228,143,188,72,165,164,145,27,102,189,138,42,39,242,203,188,224,235,208,141,161,192,253,222,98,217,230,239,35,20,188,225,189,13,167,208,252,38,138,131,63,63,145,178,126,112,208,36,185,105,203,21,248,66,230,70,59,91,253,119,122,220,101,107,181,197,126,90,244,238,83,9,55,247,72,56,118,184,9,174,177,161,18,159,240,138,63,204,51,147,36,253,114,0,0,0,0,1,194,106,55,3,132,212,110,2,70,190,89,7,9,168,220,6,203,194,235,4,141,124,178,5,79,22,133,14,19,81,184,15,209,59,143,13,151,133,214,12,85,239,225,9,26,249,100,8,216,147,83,10,158,45,10,11,92,71,61,28,38,163,112,29,228,201,71,31,162,119,30,30,96,29,41,27,47,11,172,26,237,97,155,24,171,223,194,25,105,181,245,18,53,242,200,19,247,152,255,17,177,38,166,16,115,76,145,21,60,90,20,20,254,48,35,22,184,142,122,23,122,228,77,56,77,70,224,57,143,44,215,59,201,146,142,58,11,248,185,63,68,238,60,62,134,132,11,60,192,58,82,61,2,80,101,54,94,23,88,55,156,125,111,53,218,195,54,52,24,169,1,49,87,191,132,48,149,213,179,50,211,107,234,51,17,1,221,36,107,229,144,37,169,143,167,39,239,49,254,38,45,91,201,35,98,77,76,34,160,39,123,32,230,153,34,33,36,243,21,42,120,180,40,43,186,222,31,41,252,96,70,40,62,10,113,45,113,28,244,44,179,118,195,46,245,200,154,47,55,162,173,112,154,141,192,113,88,231,247,115,30,89,174,114,220,51,153,119,147,37,28,118,81,79,43,116,23,241,114,117,213,155,69,126,137,220,120,127,75,182,79,125,13,8,22,124,207,98,33,121,128,116,164,120,66,30,147,122,4,160,202,123,198,202,253,108,188,46,176,109,126,68,135,111,56,250,222,110,250,144,233,107,181,134,108,106,119,236,91,104,49,82,2,105,243,56,53,98,175,127,8,99,109,21,63,97,43,171,102,96,233,193,81,101,166,215,212,100,100,189,227,102,34,3,186,103,224,105,141,72,215,203,32,73,21,161,23,75,83,31,78,74,145,117,121,79,222,99,252,78,28,9,203,76,90,183,146,77,152,221,165,70,196,154,152,71,6,240,175,69,64,78,246,68,130,36,193,65,205,50,68,64,15,88,115,66,73,230,42,67,139,140,29,84,241,104,80,85,51,2,103,87,117,188,62,86,183,214,9,83,248,192,140,82,58,170,187,80,124,20,226,81,190,126,213,90,226,57,232,91,32,83,223,89,102,237,134,88,164,135,177,93,235,145,52,92,41,251,3,94,111,69,90,95,173,47,109,225,53,27,128,224,247,113,183,226,177,207,238,227,115,165,217,230,60,179,92,231,254,217,107,229,184,103,50,228,122,13,5,239,38,74,56,238,228,32,15,236,162,158,86,237,96,244,97,232,47,226,228,233,237,136,211,235,171,54,138,234,105,92,189,253,19,184,240,252,209,210,199,254,151,108,158,255,85,6,169,250,26,16,44,251,216,122,27,249,158,196,66,248,92,174,117,243,0,233,72,242,194,131,127,240,132,61,38,241,70,87,17,244,9,65,148,245,203,43,163,247,141,149,250,246,79,255,205,217,120,93,96,216,186,55,87,218,252,137,14,219,62,227,57,222,113,245,188,223,179,159,139,221,245,33,210,220,55,75,229,215,107,12,216,214,169,102,239,212,239,216,182,213,45,178,129,208,98,164,4,209,160,206,51,211,230,112,106,210,36,26,93,197,94,254,16,196,156,148,39,198,218,42,126,199,24,64,73,194,87,86,204,195,149,60,251,193,211,130,162,192,17,232,149,203,77,175,168,202,143,197,159,200,201,123,198,201,11,17,241,204,68,7,116,205,134,109,67,207,192,211,26,206,2,185,45,145,175,150,64,144,109,252,119,146,43,66,46,147,233,40,25,150,166,62,156,151,100,84,171,149,34,234,242,148,224,128,197,159,188,199,248,158,126,173,207,156,56,19,150,157,250,121,161,152,181,111,36,153,119,5,19,155,49,187,74,154,243,209,125,141,137,53,48,140,75,95,7,142,13,225,94,143,207,139,105,138,128,157,236,139,66,247,219,137,4,73,130,136,198,35,181,131,154,100,136,130,88,14,191,128,30,176,230,129,220,218,209,132,147,204,84,133,81,166,99,135,23,24,58,134,213,114,13,169,226,208,160,168,32,186,151,170,102,4,206,171,164,110,249,174,235,120,124,175,41,18,75,173,111,172,18,172,173,198,37,167,241,129,24,166,51,235,47,164,117,85,118,165,183,63,65,160,248,41,196,161,58,67,243,163,124,253,170,162,190,151,157,181,196,115,208,180,6,25,231,182,64,167,190,183,130,205,137,178,205,219,12,179,15,177,59,177,73,15,98,176,139,101,85,187,215,34,104,186,21,72,95,184,83,246,6,185,145,156,49,188,222,138,180,189,28,224,131,191,90,94,218,190,152,52,237,0,0,0,0,184,188,103,101,170,9,200,139,18,181,175,238,143,98,151,87,55,222,240,50,37,107,95,220,157,215,56,185,197,180,40,239,125,8,79,138,111,189,224,100,215,1,135,1,74,214,191,184,242,106,216,221,224,223,119,51,88,99,16,86,80,25,87,159,232,165,48,250,250,16,159,20,66,172,248,113,223,123,192,200,103,199,167,173,117,114,8,67,205,206,111,38,149,173,127,112,45,17,24,21,63,164,183,251,135,24,208,158,26,207,232,39,162,115,143,66,176,198,32,172,8,122,71,201,160,50,175,62,24,142,200,91,10,59,103,181,178,135,0,208,47,80,56,105,151,236,95,12,133,89,240,226,61,229,151,135,101,134,135,209,221,58,224,180,207,143,79,90,119,51,40,63,234,228,16,134,82,88,119,227,64,237,216,13,248,81,191,104,240,43,248,161,72,151,159,196,90,34,48,42,226,158,87,79,127,73,111,246,199,245,8,147,213,64,167,125,109,252,192,24,53,159,208,78,141,35,183,43,159,150,24,197,39,42,127,160,186,253,71,25,2,65,32,124,16,244,143,146,168,72,232,247,155,20,88,61,35,168,63,88,49,29,144,182,137,161,247,211,20,118,207,106,172,202,168,15,190,127,7,225,6,195,96,132,94,160,112,210,230,28,23,183,244,169,184,89,76,21,223,60,209,194,231,133,105,126,128,224,123,203,47,14,195,119,72,107,203,13,15,162,115,177,104,199,97,4,199,41,217,184,160,76,68,111,152,245,252,211,255,144,238,102,80,126,86,218,55,27,14,185,39,77,182,5,64,40,164,176,239,198,28,12,136,163,129,219,176,26,57,103,215,127,43,210,120,145,147,110,31,244,59,38,247,3,131,154,144,102,145,47,63,136,41,147,88,237,180,68,96,84,12,248,7,49,30,77,168,223,166,241,207,186,254,146,223,236,70,46,184,137,84,155,23,103,236,39,112,2,113,240,72,187,201,76,47,222,219,249,128,48,99,69,231,85,107,63,160,156,211,131,199,249,193,54,104,23,121,138,15,114,228,93,55,203,92,225,80,174,78,84,255,64,246,232,152,37,174,139,136,115,22,55,239,22,4,130,64,248,188,62,39,157,33,233,31,36,153,85,120,65,139,224,215,175,51,92,176,202,237,89,182,59,85,229,209,94,71,80,126,176,255,236,25,213,98,59,33,108,218,135,70,9,200,50,233,231,112,142,142,130,40,237,158,212,144,81,249,177,130,228,86,95,58,88,49,58,167,143,9,131,31,51,110,230,13,134,193,8,181,58,166,109,189,64,225,164,5,252,134,193,23,73,41,47,175,245,78,74,50,34,118,243,138,158,17,150,152,43,190,120,32,151,217,29,120,244,201,75,192,72,174,46,210,253,1,192,106,65,102,165,247,150,94,28,79,42,57,121,93,159,150,151,229,35,241,242,77,107,25,5,245,215,126,96,231,98,209,142,95,222,182,235,194,9,142,82,122,181,233,55,104,0,70,217,208,188,33,188,136,223,49,234,48,99,86,143,34,214,249,97,154,106,158,4,7,189,166,189,191,1,193,216,173,180,110,54,21,8,9,83,29,114,78,154,165,206,41,255,183,123,134,17,15,199,225,116,146,16,217,205,42,172,190,168,56,25,17,70,128,165,118,35,216,198,102,117,96,122,1,16,114,207,174,254,202,115,201,155,87,164,241,34,239,24,150,71,253,173,57,169,69,17,94,204,118,77,238,6,206,241,137,99,220,68,38,141,100,248,65,232,249,47,121,81,65,147,30,52,83,38,177,218,235,154,214,191,179,249,198,233,11,69,161,140,25,240,14,98,161,76,105,7,60,155,81,190,132,39,54,219,150,146,153,53,46,46,254,80,38,84,185,153,158,232,222,252,140,93,113,18,52,225,22,119,169,54,46,206,17,138,73,171,3,63,230,69,187,131,129,32,227,224,145,118,91,92,246,19,73,233,89,253,241,85,62,152,108,130,6,33,212,62,97,68,198,139,206,170,126,55,169,207,214,127,65,56,110,195,38,93,124,118,137,179,196,202,238,214,89,29,214,111,225,161,177,10,243,20,30,228,75,168,121,129,19,203,105,215,171,119,14,178,185,194,161,92,1,126,198,57,156,169,254,128,36,21,153,229,54,160,54,11,142,28,81,110,134,102,22,167,62,218,113,194,44,111,222,44,148,211,185,73,9,4,129,240,177,184,230,149,163,13,73,123,27,177,46,30,67,210,62,72,251,110,89,45,233,219,246,195,81,103,145,166,204,176,169,31,116,12,206,122,102,185,97,148,222,5,6,241,0,0,0,0,0,0,0,0,10,1,0,0,4,0,4,0,8,0,4,0,11,1,0,0,4,0,5,0,16,0,8,0,11,1,0,0,4,0,6,0,32,0,32,0,11,1,0,0,4,0,4,0,16,0,16,0,12,1,0,0,8,0,16,0,32,0,32,0,12,1,0,0,8,0,16,0,128,0,128,0,12,1,0,0,8,0,32,0,128,0,0,1,12,1,0,0,32,0,128,0,2,1,0,4,12,1,0,0,32,0,2,1,2,1,0,16,12,1,0,0,190,137,2,0,100,64,2,0,1,1,0,0,30,1,0,0,15,0,0,0,70,137,2,0,236,63,2,0,0,0,0,0,30,0,0,0,15,0,0,0,0,0,0,0,160,63,2,0,0,0,0,0,19,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,7,0,0,0,7,0,0,0,8,0,0,0,8,0,0,0,9,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,11,0,0,0,11,0,0,0,12,0,0,0,12,0,0,0,13,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,10,0,0,0,12,0,0,0,14,0,0,0,16,0,0,0,20,0,0,0,24,0,0,0,28,0,0,0,32,0,0,0,40,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,80,0,0,0,96,0,0,0,112,0,0,0,128,0,0,0,160,0,0,0,192,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,6,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,48,0,0,0,64,0,0,0,96,0,0,0,128,0,0,0,192,0,0,0,0,1,0,0,128,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,6,0,0,0,8,0,0,0,12,0,0,0,16,0,0,0,24,0,0,0,32,0,0,0,48,0,0,0,64,0,0,0,96,0,0,100,0,0,0,0,0,0,0,0,92,0,0,0,5,0,0,1,5,0,0,140,0,0,0,180,2,0,0,13,1,0,0,221,1,0,0,0,0,0,0,24,92,0,0,2,5,0,0,3,5,0,0,141,0,0,0,181,2,0,0,222,1,0,0,142,0,0,0,223,1,0,0,0,0,0,0,40,92,0,0,2,5,0,0,4,5,0,0,143,0,0,0,182,2,0,0,224,1,0,0,142,0,0,0,223,1,0,0,0,0,0,0,56,92,0,0,5,5,0,0,6,5,0,0,144,0,0,0,183,2,0,0,14,1,0,0,225,1,0,0,0,0,0,0,88,92,0,0,7,5,0,0,8,5,0,0,226,1,0,0,0,0,0,0,112,92,0,0,240,2,0,0,9,5,0,0,10,5,0,0,132,0,0,0,132,91,7,0,137,91,7,0,21,93,7,0,145,91,7,0,4,0,0,0,0,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,3,0,0,0,7,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,9,0,0,0,3,0,0,0,8,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,255,255,255,255,1,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,6,0,0,0,2,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,3,0,0,0,7,0,0,0,9,0,0,0,10,0,0,0,10,0,0,0,9,0,0,0,3,0,0,0,8,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,21,93,7,0,194,254,7,0,82,254,7,0,27,93,7,0,33,93,7,0,40,93,7,0,46,93,7,0,54,93,7,0,31,254,7,0,62,93,7,0,69,93,7,0,75,93,7,0,83,93,7,0,89,93,7,0,96,93,7,0,101,93,7,0,110,93,7,0,119,93,7,0,126,93,7,0,21,93,7,0,40,93,7,0,27,93,7,0,89,93,7,0,33,93,7,0,194,254,7,0,82,254,7,0,31,254,7,0,96,93,7,0,62,93,7,0,75,93,7,0,21,93,7,0,133,93,7,0,142,93,7,0,151,93,7,0,0,0,0,0,184,92,0,0,240,2,0,0,11,5,0,0,12,5,0,0,31,102,7,0,43,102,7,0,58,102,7,0,71,102,7,0,83,102,7,0,100,102,7,0,115,102,7,0,129,102,7,0,0,0,0,0,152,92,0,0,13,5,0,0,14,5,0,0,133,0,0,0,134,0,0,0,0,0,0,0,136,92,0,0,15,5,0,0,16,5,0,0,145,0,0,0,0,0,0,0,168,92,0,0,240,2,0,0,17,5,0,0,18,5,0,0,0,0,0,0,200,92,0,0,240,2,0,0,19,5,0,0,20,5,0,0,0,0,0,0,216,92,0,0,240,2,0,0,21,5,0,0,22,5,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,120,0,0,0,124,0,0,0,16,0,0,0,96,0,0,0,108,0,0,0,32,0,0,0,48,0,0,0,64,0,0,0,80,0,0,0,132,0,0,0,136,0,0,0,128,0,0,0,0,0,0,0,1,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,3,0,0,0,4,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,20,0,0,0,24,0,0,0,16,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,144,0,0,0,16,0,0,0,80,0,0,0,32,0,0,0,48,0,0,0,64,0,0,0,96,0,0,0,148,0,0,0,112,0,0,0,128,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,1,0,0,0,255,255,255,255,255,255,255,255,24,0,0,0,20,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,32,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,40,0,0,0,48,0,0,0,52,0,0,0,24,0,0,0,20,0,0,0,28,0,0,0,44,0,0,0,32,0,0,0,36,0,0,0,0,0,0,0,6,0,0,0,8,0,0,0,9,0,0,0,2,0,0,0,1,0,0,0,3,0,0,0,7,0,0,0,4,0,0,0,5,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,64,0,0,0,16,0,0,0,68,0,0,0,32,0,0,0,48,0,0,0,0,0,0,0,255,255,255,255,1,0,0,0,255,255,255,255,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,24,0,0,0,20,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,32,0,0,0,16,0,0,0,36,0,0,0,0,0,0,0,255,255,255,255,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,24,0,0,0,28,0,0,0,32,0,0,0,33,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,24,0,0,0,20,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,48,0,0,0,52,0,0,0,81,0,0,0,82,0,0,0,83,0,0,0,92,0,0,0,56,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,80,0,0,0,60,0,0,0,64,0,0,0,68,0,0,0,72,0,0,0,76,0,0,0,32,0,0,0,0,0,0,0,1,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,17,0,0,0,2,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,8,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,255,255,255,255,24,0,0,0,20,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,32,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,255,255,255,255,24,0,0,0,20,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,48,0,0,0,52,0,0,0,56,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,32,0,0,0,0,0,0,0,1,0,0,0,5,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,255,255,255,255,24,0,0,0,20,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,32,0,0,0,255,255,255,255,24,0,0,0,20,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,48,0,0,0,49,0,0,0,32,0,0,0,0,0,0,0,1,0,0,0,255,255,255,255,24,0,0,0,20,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,48,0,0,0,32,0,0,0,0,0,0,0,255,255,255,255,24,0,0,0,20,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,48,0,0,0,32,0,0,0,0,0,0,0,255,255,255,255,24,0,0,0,20,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,48,0,0,0,52,0,0,0,32,0,0,0,0,0,0,0,1,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,20,0,0,0,0,0,0,0,1,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,32,0,0,0,48,0,0,0,56,0,0,0,64,0,0,0,36,0,0,0,40,0,0,0,255,255,255,255,0,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,32,0,0,0,64,0,0,0,68,0,0,0,48,0,0,0,255,255,255,255,255,255,255,255,0,0,0,0,1,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,255,255,255,255,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,32,0,0,0,36,0,0,0,40,0,0,0,255,255,255,255,0,0,0,0,1,0,0,0,2,0,0,0,8,0,0,0,4,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,16,0,0,0,255,255,255,255,0,0,0,0,232,92,0,0,23,5,0,0,24,5,0,0,197,0,0,0,227,1,0,0,15,1,0,0,228,1,0,0,229,1,0,0,25,5,0,0,230,1,0,0,198,0,0,0,199,0,0,0,16,1,0,0,231,1,0,0,184,2,0,0,36,0,0,0,232,1,0,0,146,0,0,0,44,0,0,0,185,2,0,0,186,2,0,0,46,3,0,0,45,0,0,0,187,2,0,0,46,0,0,0,188,2,0,0,0,0,0,0,6,0,0,0,32,0,0,0,7,0,0,0,24,0,0,0,140,0,0,0,36,0,0,0,44,0,0,0,28,0,0,0,47,0,0,0,54,0,0,0,24,0,0,0,56,0,0,0,71,0,0,0,152,0,0,0,81,0,0,0,87,0,0,0,48,0,0,0,88,0,0,0,103,0,0,0,56,0,0,0,113,0,0,0,120,0,0,0,24,0,0,0,122,0,0,0,129,0,0,0,24,0,0,0,131,0,0,0,141,0,0,0,72,0,0,0,146,0,0,0,154,0,0,0,28,0,0,0,157,0,0,0,165,0,0,0,40,0,0,0,168,0,0,0,179,0,0,0,36,0,0,0,185,0,0,0,209,0,0,0,96,0,0,0,228,0,0,0,238,0,0,0,52,0,0,0,243,0,0,0,255,0,0,0,60,0,0,0,6,1,0,0,12,1,0,0,48,0,0,0,13,1,0,0,21,1,0,0,52,0,0,0,24,1,0,0,31,1,0,0,52,0,0,0,33,1,0,0,40,1,0,0,52,0,0,0,42,1,0,0,50,1,0,0,56,0,0,0,53,1,0,0,60,1,0,0,24,0,0,0,62,1,0,0,74,1,0,0,72,0,0,0,81,1,0,0,91,1,0,0,72,0,0,0,96,1,0,0,102,1,0,0,32,0,0,0,103,1,0,0,112,1,0,0,44,0,0,0,116,1,0,0,122,1,0,0,32,0,0,0,112,36,8,0,144,36,8,0,32,37,8,0,64,37,8,0,88,37,8,0,240,37,8,0,32,38,8,0,88,38,8,0,112,38,8,0,136,38,8,0,208,38,8,0,240,38,8,0,24,39,8,0,64,39,8,0,160,39,8,0,216,39,8,0,24,40,8,0,72,40,8,0,128,40,8,0,184,40,8,0,240,40,8,0,40,41,8,0,64,41,8,0,136,41,8,0,208,41,8,0,240,41,8,0,32,42,8,0,0,0,0,0,248,92,0,0,26,5,0,0,27,5,0,0,197,0,0,0,233,1,0,0,17,1,0,0,234,1,0,0,235,1,0,0,28,5,0,0,236,1,0,0,198,0,0,0,199,0,0,0,18,1,0,0,237,1,0,0,189,2,0,0,36,0,0,0,238,1,0,0,147,0,0,0,44,0,0,0,190,2,0,0,191,2,0,0,46,3,0,0,45,0,0,0,192,2,0,0,46,0,0,0,193,2,0,0,0,0,0,0,8,93,0,0,29,5,0,0,30,5,0,0,197,0,0,0,239,1,0,0,19,1,0,0,240,1,0,0,241,1,0,0,31,5,0,0,242,1,0,0,198,0,0,0,199,0,0,0,20,1,0,0,243,1,0,0,194,2,0,0,36,0,0,0,244,1,0,0,148,0,0,0,44,0,0,0,195,2,0,0,196,2,0,0,46,3,0,0,45,0,0,0,197,2,0,0,46,0,0,0,198,2,0,0,0,0,0,0,24,93,0,0,32,5,0,0,33,5,0,0,197,0,0,0,245,1,0,0,21,1,0,0,246,1,0,0,247,1,0,0,34,5,0,0,248,1,0,0,198,0,0,0,199,0,0,0,22,1,0,0,249,1,0,0,199,2,0,0,36,0,0,0,250,1,0,0,149,0,0,0,44,0,0,0,200,2,0,0,201,2,0,0,46,3,0,0,45,0,0,0,202,2,0,0,46,0,0,0,203,2,0,0,0,0,0,0,40,93,0,0,35,5,0,0,36,5,0,0,197,0,0,0,251,1,0,0,23,1,0,0,252,1,0,0,253,1,0,0,37,5,0,0,254,1,0,0,198,0,0,0,199,0,0,0,24,1,0,0,255,1,0,0,204,2,0,0,36,0,0,0,0,2,0,0,150,0,0,0,44,0,0,0,205,2,0,0,206,2,0,0,46,3,0,0,45,0,0,0,207,2,0,0,46,0,0,0,208,2,0,0,0,0,0,0,56,93,0,0,38,5,0,0,39,5,0,0,197,0,0,0,1,2,0,0,25,1,0,0,2,2,0,0,3,2,0,0,40,5,0,0,4,2,0,0,198,0,0,0,199,0,0,0,26,1,0,0,5,2,0,0,209,2,0,0,36,0,0,0,6,2,0,0,151,0,0,0,44,0,0,0,210,2,0,0,211,2,0,0,46,3,0,0,45,0,0,0,212,2,0,0,46,0,0,0,213,2,0,0,0,0,0,0,72,93,0,0,41,5,0,0,42,5,0,0,197,0,0,0,7,2,0,0,27,1,0,0,8,2,0,0,9,2,0,0,43,5,0,0,10,2,0,0,198,0,0,0,199,0,0,0,28,1,0,0,11,2,0,0,214,2,0,0,36,0,0,0,12,2,0,0,152,0,0,0,44,0,0,0,215,2,0,0,216,2,0,0,46,3,0,0,45,0,0,0,217,2,0,0,46,0,0,0,218,2,0,0,0,0,0,0,88,93,0,0,44,5,0,0,45,5,0,0,197,0,0,0,13,2,0,0,29,1,0,0,14,2,0,0,15,2,0,0,46,5,0,0,16,2,0,0,198,0,0,0,199,0,0,0,30,1,0,0,17,2,0,0,219,2,0,0,36,0,0,0,18,2,0,0,153,0,0,0,44,0,0,0,220,2,0,0,221,2,0,0,46,3,0,0,45,0,0,0,222,2,0,0,46,0,0,0,223,2,0,0,0,0,0,0,104,93,0,0,47,5,0,0,48,5,0,0,197,0,0,0,19,2,0,0,31,1,0,0,20,2,0,0,21,2,0,0,49,5,0,0,22,2,0,0,198,0,0,0,199,0,0,0,32,1,0,0,23,2,0,0,224,2,0,0,36,0,0,0,24,2,0,0,154,0,0,0,44,0,0,0,225,2,0,0,226,2,0,0,46,3,0,0,45,0,0,0,227,2,0,0,46,0,0,0,228,2,0,0,0,0,0,0,120,93,0,0,50,5,0,0,51,5,0,0,197,0,0,0,25,2,0,0,33,1,0,0,26,2,0,0,27,2,0,0,52,5,0,0,28,2,0,0,198,0,0,0,199,0,0,0,34,1,0,0,29,2,0,0,229,2,0,0,36,0,0,0,30,2,0,0,155,0,0,0,44,0,0,0,230,2,0,0,231,2,0,0,46,3,0,0,45,0,0,0,232,2,0,0,46,0,0,0,233,2,0,0,0,0,0,0,136,93,0,0,53,5,0,0,54,5,0,0,197,0,0,0,31,2,0,0,35,1,0,0,32,2,0,0,33,2,0,0,55,5,0,0,34,2,0,0,198,0,0,0,199,0,0,0,36,1,0,0,35,2,0,0,234,2,0,0,36,0,0,0,36,2,0,0,156,0,0,0,44,0,0,0,235,2,0,0,236,2,0,0,46,3,0,0,45,0,0,0,237,2,0,0,46,0,0,0,238,2,0,0,0,0,0,0,152,93,0,0,56,5,0,0,57,5,0,0,197,0,0,0,37,2,0,0,37,1,0,0,38,2,0,0,39,2,0,0,58,5,0,0,40,2,0,0,198,0,0,0,199,0,0,0,38,1,0,0,41,2,0,0,239,2,0,0,36,0,0,0,42,2,0,0,157,0,0,0,44,0,0,0,240,2,0,0,241,2,0,0,46,3,0,0,45,0,0,0,242,2,0,0,46,0,0,0,243,2,0,0,0,0,0,0,168,93,0,0,59,5,0,0,60,5,0,0,197,0,0,0,43,2,0,0,39,1,0,0,44,2,0,0,45,2,0,0,61,5,0,0,46,2,0,0,198,0,0,0,199,0,0,0,40,1,0,0,47,2,0,0,244,2,0,0,36,0,0,0,48,2,0,0,158,0,0,0,44,0,0,0,245,2,0,0,246,2,0,0,46,3,0,0,45,0,0,0,247,2,0,0,46,0,0,0,248,2,0,0,0,0,0,0,184,93,0,0,62,5,0,0,63,5,0,0,197,0,0,0,49,2,0,0,41,1,0,0,50,2,0,0,51,2,0,0,64,5,0,0,52,2,0,0,198,0,0,0,199,0,0,0,42,1,0,0,53,2,0,0,249,2,0,0,36,0,0,0,54,2,0,0,159,0,0,0,44,0,0,0,250,2,0,0,251,2,0,0,46,3,0,0,45,0,0,0,252,2,0,0,46,0,0,0,253,2,0,0,0,0,0,0,200,93,0,0,65,5,0,0,66,5,0,0,197,0,0,0,55,2,0,0,43,1,0,0,56,2,0,0,57,2,0,0,67,5,0,0,58,2,0,0,198,0,0,0,199,0,0,0,44,1,0,0,59,2,0,0,254,2,0,0,36,0,0,0,60,2,0,0,160,0,0,0,44,0,0,0,255,2,0,0,0,3,0,0,46,3,0,0,45,0,0,0,1,3,0,0,46,0,0,0,2,3,0,0,0,0,0,0,216,93,0,0,68,5,0,0,69,5,0,0,197,0,0,0,61,2,0,0,45,1,0,0,62,2,0,0,63,2,0,0,70,5,0,0,64,2,0,0,198,0,0,0,199,0,0,0,46,1,0,0,65,2,0,0,3,3,0,0,36,0,0,0,66,2,0,0,161,0,0,0,44,0,0,0,4,3,0,0,5,3,0,0,46,3,0,0,45,0,0,0,6,3,0,0,46,0,0,0,7,3,0,0,0,0,0,0,232,93,0,0,71,5,0,0,72,5,0,0,197,0,0,0,67,2,0,0,47,1,0,0,68,2,0,0,69,2,0,0,73,5,0,0,70,2,0,0,198,0,0,0,199,0,0,0,48,1,0,0,71,2,0,0,8,3,0,0,36,0,0,0,72,2,0,0,162,0,0,0,44,0,0,0,9,3,0,0,10,3,0,0,46,3,0,0,45,0,0,0,11,3,0,0,46,0,0,0,12,3,0,0,0,0,0,0,248,93,0,0,74,5,0,0,75,5,0,0,197,0,0,0,73,2,0,0,49,1,0,0,74,2,0,0,75,2,0,0,76,5,0,0,76,2,0,0,198,0,0,0,199,0,0,0,50,1,0,0,77,2,0,0,13,3,0,0,36,0,0,0,78,2,0,0,163,0,0,0,44,0,0,0,14,3,0,0,15,3,0,0,46,3,0,0,45,0,0,0,16,3,0,0,46,0,0,0,17,3,0,0,0,0,0,0,8,94,0,0,77,5,0,0,78,5,0,0,197,0,0,0,79,2,0,0,51,1,0,0,80,2,0,0,81,2,0,0,79,5,0,0,82,2,0,0,198,0,0,0,199,0,0,0,52,1,0,0,83,2,0,0,18,3,0,0,36,0,0,0,84,2,0,0,164,0,0,0,44,0,0,0,19,3,0,0,20,3,0,0,46,3,0,0,45,0,0,0,21,3,0,0,46,0,0,0,22,3,0,0,0,0,0,0,24,94,0,0,80,5,0,0,81,5,0,0,197,0,0,0,85,2,0,0,53,1,0,0,86,2,0,0,87,2,0,0,82,5,0,0,88,2,0,0,198,0,0,0,199,0,0,0,54,1,0,0,89,2,0,0,23,3,0,0,36,0,0,0,90,2,0,0,165,0,0,0,44,0,0,0,24,3,0,0,25,3,0,0,46,3,0,0,45,0,0,0,26,3,0,0,46,0,0,0,27,3,0,0,0,0,0,0,40,94,0,0,83,5,0,0,84,5,0,0,197,0,0,0,91,2,0,0,55,1,0,0,92,2,0,0,93,2,0,0,85,5,0,0,94,2,0,0,198,0,0,0,199,0,0,0,56,1,0,0,95,2,0,0,28,3,0,0,36,0,0,0,96,2,0,0,166,0,0,0,44,0,0,0,29,3,0,0,30,3,0,0,46,3,0,0,45,0,0,0,31,3,0,0,46,0,0,0,32,3,0,0,0,0,0,0,56,94,0,0,86,5,0,0,87,5,0,0,197,0,0,0,97,2,0,0,57,1,0,0,98,2,0,0,99,2,0,0,88,5,0,0,100,2,0,0,198,0,0,0,199,0,0,0,58,1,0,0,101,2,0,0,33,3,0,0,36,0,0,0,102,2,0,0,167,0,0,0,44,0,0,0,34,3,0,0,35,3,0,0,46,3,0,0,45,0,0,0,36,3,0,0,46,0,0,0,37,3,0,0,0,0,0,0,72,94,0,0,89,5,0,0,90,5,0,0,197,0,0,0,103,2,0,0,59,1,0,0,104,2,0,0,105,2,0,0,91,5,0,0,106,2,0,0,198,0,0,0,199,0,0,0,60,1,0,0,107,2,0,0,38,3,0,0,36,0,0,0,108,2,0,0,168,0,0,0,44,0,0,0,39,3,0,0,40,3,0,0,46,3,0,0,45,0,0,0,41,3,0,0,46,0,0,0,42,3,0,0,0,0,0,0,88,94,0,0,92,5,0,0,93,5,0,0,197,0,0,0,109,2,0,0,61,1,0,0,110,2,0,0,111,2,0,0,94,5,0,0,112,2,0,0,198,0,0,0,199,0,0,0,62,1,0,0,113,2,0,0,43,3,0,0,36,0,0,0,114,2,0,0,169,0,0,0,44,0,0,0,44,3,0,0,45,3,0,0,46,3,0,0,45,0,0,0,46,3,0,0,46,0,0,0,47,3,0,0,0,0,0,0,104,94,0,0,95,5,0,0,96,5,0,0,197,0,0,0,115,2,0,0,63,1,0,0,116,2,0,0,117,2,0,0,97,5,0,0,118,2,0,0,198,0,0,0,199,0,0,0,64,1,0,0,119,2,0,0,48,3,0,0,36,0,0,0,120,2,0,0,170,0,0,0,44,0,0,0,49,3,0,0,50,3,0,0,46,3,0,0,45,0,0,0,51,3,0,0,46,0,0,0,52,3,0,0,0,0,0,0,120,94,0,0,98,5,0,0,99,5,0,0,197,0,0,0,121,2,0,0,65,1,0,0,122,2,0,0,123,2,0,0,100,5,0,0,124,2,0,0,198,0,0,0,199,0,0,0,66,1,0,0,125,2,0,0,53,3,0,0,36,0,0,0,126,2,0,0,171,0,0,0,44,0,0,0,54,3,0,0,55,3,0,0,46,3,0,0,45,0,0,0,56,3,0,0,46,0,0,0,57,3,0,0,0,0,0,0,136,94,0,0,101,5,0,0,102,5,0,0,197,0,0,0,127,2,0,0,67,1,0,0,128,2,0,0,129,2,0,0,103,5,0,0,130,2,0,0,198,0,0,0,199,0,0,0,68,1,0,0,131,2,0,0,58,3,0,0,36,0,0,0,132,2,0,0,172,0,0,0,44,0,0,0,59,3,0,0,60,3,0,0,46,3,0,0,45,0,0,0,61,3,0,0,46,0,0,0,62,3,0,0,4,0,0,0,5,0,0,0,7,0,0,0,2,0,0,0,6,0,0,0,3,0,0,0,4,0,0,0,8,0,0,0,2,0,0,0,0,0,0,0,160,94,0,0,104,5,0,0,105,5,0,0,173,0,0,0,174,0,0,0,12,0,0,0,175,0,0,0,69,1,0,0,0,0,0,0,176,94,0,0,106,5,0,0,107,5,0,0,197,0,0,0,133,2,0,0,70,1,0,0,134,2,0,0,55,0,0,0,108,5],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+143360);allocate([135,2,0,0,198,0,0,0,199,0,0,0,71,1,0,0,136,2,0,0,63,3,0,0,36,0,0,0,137,2,0,0,176,0,0,0,44,0,0,0,213,0,0,0,228,0,0,0,46,3,0,0,45,0,0,0,64,3,0,0,46,0,0,0,65,3,0,0,0,0,0,0,192,94,0,0,109,5,0,0,110,5,0,0,72,1,0,0,0,0,0,0,208,94,0,0,111,5,0,0,112,5,0,0,177,0,0,0,0,0,0,0,240,94,0,0,113,5,0,0,114,5,0,0,73,1,0,0,74,1,0,0,75,1,0,0,178,0,0,0,179,0,0,0,146,0,0,0,180,0,0,0,147,0,0,0,181,0,0,0,148,0,0,0,182,0,0,0,149,0,0,0,135,0,0,0,77,0,0,0,150,0,0,0,183,0,0,0,184,0,0,0,185,0,0,0,186,0,0,0,8,0,0,0,9,0,0,0,187,0,0,0,136,0,0,0,188,0,0,0,189,0,0,0,13,0,0,0,14,0,0,0,137,0,0,0,78,0,0,0,138,0,0,0,79,0,0,0,2,0,0,0,3,0,0,0,139,0,0,0,140,0,0,0,141,0,0,0,142,0,0,0,15,0,0,0,143,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,1,0,0,0,2,0,0,0,21,0,0,0,80,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,69,0,0,0,81,0,0,0,80,0,0,0,82,0,0,0,81,0,0,0,3,0,0,0,4,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,25,0,0,0,144,0,0,0,87,0,0,0,145,0,0,0,88,0,0,0,4,0,0,0,5,0,0,0,146,0,0,0,147,0,0,0,148,0,0,0,149,0,0,0,26,0,0,0,150,0,0,0,76,1,0,0,77,1,0,0,138,2,0,0,139,2,0,0,30,0,0,0,31,0,0,0,70,0,0,0,78,1,0,0,27,0,0,0,71,0,0,0,28,0,0,0,151,0,0,0,152,0,0,0,190,0,0,0,191,0,0,0,202,167,7,0,218,167,7,0,232,167,7,0,246,167,7,0,5,168,7,0,20,168,7,0,35,168,7,0,49,168,7,0,62,168,7,0,75,168,7,0,90,168,7,0,0,0,0,0,8,95,0,0,115,5,0,0,116,5,0,0,192,0,0,0,66,3,0,0,79,1,0,0,140,2,0,0,0,0,0,0,24,95,0,0,117,5,0,0,118,5,0,0,193,0,0,0,80,1,0,0,0,0,0,0,40,95,0,0,119,5,0,0,120,5,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,141,2,0,0,121,5,0,0,122,5,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,48,95,0,0,123,5,0,0,124,5,0,0,81,1,0,0,194,0,0,0,82,1,0,0,195,0,0,0,67,3,0,0,68,3,0,0,142,2,0,0,143,2,0,0,125,5,0,0,126,5,0,0,69,3,0,0,70,3,0,0,151,0,0,0,71,3,0,0,144,2,0,0,145,2,0,0,72,3,0,0,0,0,0,0,136,95,0,0,127,5,0,0,128,5,0,0,83,1,0,0,84,1,0,0,29,0,0,0,73,3,0,0,153,0,0,0,152,0,0,0,74,3,0,0,154,0,0,0,155,0,0,0,85,1,0,0,86,1,0,0,196,0,0,0,197,0,0,0,30,0,0,0,153,0,0,0,31,0,0,0,87,1,0,0,154,0,0,0,198,0,0,0,0,0,0,0,192,95,0,0,127,5,0,0,129,5,0,0,88,1,0,0,89,1,0,0,32,0,0,0,75,3,0,0,156,0,0,0,155,0,0,0,76,3,0,0,157,0,0,0,158,0,0,0,85,1,0,0,86,1,0,0,196,0,0,0,197,0,0,0,30,0,0,0,153,0,0,0,31,0,0,0,90,1,0,0,156,0,0,0,199,0,0,0,0,0,0,0,208,95,0,0,127,5,0,0,130,5,0,0,91,1,0,0,92,1,0,0,33,0,0,0,77,3,0,0,159,0,0,0,157,0,0,0,78,3,0,0,160,0,0,0,161,0,0,0,85,1,0,0,86,1,0,0,196,0,0,0,197,0,0,0,30,0,0,0,153,0,0,0,31,0,0,0,93,1,0,0,158,0,0,0,200,0,0,0,0,0,0,0,240,95,0,0,127,5,0,0,131,5,0,0,94,1,0,0,95,1,0,0,34,0,0,0,79,3,0,0,162,0,0,0,159,0,0,0,80,3,0,0,163,0,0,0,164,0,0,0,85,1,0,0,86,1,0,0,196,0,0,0,197,0,0,0,30,0,0,0,153,0,0,0,31,0,0,0,96,1,0,0,201,0,0,0,0,0,0,0,16,96,0,0,127,5,0,0,132,5,0,0,97,1,0,0,98,1,0,0,35,0,0,0,81,3,0,0,165,0,0,0,160,0,0,0,82,3,0,0,166,0,0,0,167,0,0,0,85,1,0,0,86,1,0,0,196,0,0,0,197,0,0,0,30,0,0,0,153,0,0,0,31,0,0,0,3,0,0,0,202,0,0,0,0,0,0,0,48,96,0,0,127,5,0,0,133,5,0,0,99,1,0,0,100,1,0,0,36,0,0,0,83,3,0,0,168,0,0,0,161,0,0,0,84,3,0,0,169,0,0,0,170,0,0,0,85,1,0,0,86,1,0,0,196,0,0,0,197,0,0,0,30,0,0,0,153,0,0,0,31,0,0,0,4,0,0,0,203,0,0,0,0,0,0,0,80,96,0,0,127,5,0,0,134,5,0,0,101,1,0,0,102,1,0,0,37,0,0,0,85,3,0,0,171,0,0,0,162,0,0,0,86,3,0,0,172,0,0,0,173,0,0,0,85,1,0,0,86,1,0,0,196,0,0,0,197,0,0,0,30,0,0,0,153,0,0,0,31,0,0,0,103,1,0,0,204,0,0,0,0,0,0,0,112,96,0,0,127,5,0,0,135,5,0,0,104,1,0,0,105,1,0,0,38,0,0,0,87,3,0,0,174,0,0,0,163,0,0,0,88,3,0,0,175,0,0,0,176,0,0,0,85,1,0,0,86,1,0,0,196,0,0,0,197,0,0,0,30,0,0,0,153,0,0,0,31,0,0,0,106,1,0,0,205,0,0,0,0,0,0,0,144,96,0,0,127,5,0,0,136,5,0,0,107,1,0,0,108,1,0,0,39,0,0,0,89,3,0,0,177,0,0,0,164,0,0,0,90,3,0,0,178,0,0,0,179,0,0,0,85,1,0,0,86,1,0,0,196,0,0,0,197,0,0,0,30,0,0,0,153,0,0,0,31,0,0,0,109,1,0,0,206,0,0,0,0,0,0,0,176,96,0,0,127,5,0,0,137,5,0,0,110,1,0,0,111,1,0,0,40,0,0,0,91,3,0,0,180,0,0,0,165,0,0,0,92,3,0,0,181,0,0,0,182,0,0,0,85,1,0,0,86,1,0,0,196,0,0,0,197,0,0,0,30,0,0,0,153,0,0,0,31,0,0,0,112,1,0,0,207,0,0,0,0,0,0,0,216,96,0,0,138,5,0,0,139,5,0,0,113,1,0,0,0,0,0,0,240,96,0,0,140,5,0,0,141,5,0,0,166,0,0,0,167,0,0,0,168,0,0,0,183,0,0,0,184,0,0,0,1,0,0,0,2,0,0,0,169,0,0,0,170,0,0,0,185,0,0,0,89,0,0,0,82,0,0,0,83,0,0,0,0,0,0,0,0,97,0,0,142,5,0,0,143,5,0,0,171,0,0,0,0,0,0,0,16,97,0,0,144,5,0,0,145,5,0,0,186,0,0,0,187,0,0,0,0,0,0,0,32,97,0,0,146,5,0,0,147,5,0,0,208,0,0,0,114,1,0,0,172,0,0,0,0,0,0,0,56,97,0,0,111,5,0,0,148,5,0,0,209,0,0,0,0,0,0,0,0,1,0,0,0,9,0,0,0,0,0,0,8,0,0,0,1,0,0,0,32,32,32,32,0,0,0,0,195,207,7,0,120,164,17,0,190,185,17,0,195,216,7,0,104,95,2,0,20,0,0,0,67,46,85,84,70,45,56,0,0,0,0,0,0,0,0,0,0,0,0,0,222,18,4,149,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,76,95,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,100,96,2,0,5,0,0,0,0,0,0,0,0,0,0,0,146,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,210,0,0,0,211,0,0,0,172,177,17,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,152,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100,96,2,0,220,97,2,0,9,0,0,0,0,0,0,0,0,0,0,0,146,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,212,0,0,0,0,0,0,0,211,0,0,0,180,181,17,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,92,98,2,0,5,0,0,0,0,0,0,0,0,0,0,0,146,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,213,0,0,0,211,0,0,0,188,185,17,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,95,112,137,0,255,9,47,15,62,143,2,0,132,101,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,81,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,91,0,0,0,92,0,0,0,93,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,81,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,123,0,0,0,124,0,0,0,125,0,0,0,126,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,107,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,103,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,107,0,0,0,108,0,0,0,109,0,0,0,110,0,0,0,111,0,0,0,112,0,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,120,0,0,0,121,0,0,0,122,0,0,0,91,0,0,0,92,0,0,0,93,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,103,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,107,0,0,0,108,0,0,0,109,0,0,0,110,0,0,0,111,0,0,0,112,0,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,120,0,0,0,121,0,0,0,122,0,0,0,123,0,0,0,124,0,0,0,125,0,0,0,126,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,3,0,0,0,5,0,0,0,7,0,0,0,11,0,0,0,13,0,0,0,17,0,0,0,19,0,0,0,23,0,0,0,29,0,0,0,31,0,0,0,37,0,0,0,41,0,0,0,43,0,0,0,47,0,0,0,53,0,0,0,59,0,0,0,61,0,0,0,67,0,0,0,71,0,0,0,73,0,0,0,79,0,0,0,83,0,0,0,89,0,0,0,97,0,0,0,101,0,0,0,103,0,0,0,107,0,0,0,109,0,0,0,113,0,0,0,127,0,0,0,131,0,0,0,137,0,0,0,139,0,0,0,149,0,0,0,151,0,0,0,157,0,0,0,163,0,0,0,167,0,0,0,173,0,0,0,179,0,0,0,181,0,0,0,191,0,0,0,193,0,0,0,197,0,0,0,199,0,0,0,211,0,0,0,1,0,0,0,11,0,0,0,13,0,0,0,17,0,0,0,19,0,0,0,23,0,0,0,29,0,0,0,31,0,0,0,37,0,0,0,41,0,0,0,43,0,0,0,47,0,0,0,53,0,0,0,59,0,0,0,61,0,0,0,67,0,0,0,71,0,0,0,73,0,0,0,79,0,0,0,83,0,0,0,89,0,0,0,97,0,0,0,101,0,0,0,103,0,0,0,107,0,0,0,109,0,0,0,113,0,0,0,121,0,0,0,127,0,0,0,131,0,0,0,137,0,0,0,139,0,0,0,143,0,0,0,149,0,0,0,151,0,0,0,157,0,0,0,163,0,0,0,167,0,0,0,169,0,0,0,173,0,0,0,179,0,0,0,181,0,0,0,187,0,0,0,191,0,0,0,193,0,0,0,197,0,0,0,199,0,0,0,209,0,0,0,0,0,0,0,0,98,0,0,149,5,0,0,150,5,0,0,0,0,0,0,24,98,0,0,151,5,0,0,152,5,0,0,1,0,0,0,1,0,0,0,79,0,0,0,47,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,37,0,0,0,5,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,0,0,0,0,32,98,0,0,153,5,0,0,154,5,0,0,93,3,0,0,215,0,0,0,84,0,0,0,188,0,0,0,147,2,0,0,148,2,0,0,216,0,0,0,149,2,0,0,150,2,0,0,115,1,0,0,217,0,0,0,116,1,0,0,8,0,0,0,0,0,0,0,40,98,0,0,11,0,0,0,12,0,0,0,248,255,255,255,248,255,255,255,40,98,0,0,13,0,0,0,14,0,0,0,164,113,2,0,184,113,2,0,8,0,0,0,0,0,0,0,64,98,0,0,155,5,0,0,156,5,0,0,248,255,255,255,248,255,255,255,64,98,0,0,157,5,0,0,158,5,0,0,212,113,2,0,232,113,2,0,76,34,0,0,96,34,0,0,4,0,0,0,0,0,0,0,112,98,0,0,159,5,0,0,160,5,0,0,252,255,255,255,252,255,255,255,112,98,0,0,161,5,0,0,162,5,0,0,12,114,2,0,32,114,2,0,12,0,0,0,0,0,0,0,136,98,0,0,17,0,0,0,18,0,0,0,4,0,0,0,248,255,255,255,136,98,0,0,19,0,0,0,20,0,0,0,244,255,255,255,244,255,255,255,136,98,0,0,21,0,0,0,22,0,0,0,60,114,2,0,180,98,0,0,200,98,0,0,76,34,0,0,96,34,0,0,100,114,2,0,80,114,2,0,0,0,0,0,208,98,0,0,163,5,0,0,164,5,0,0,94,3,0,0,215,0,0,0,84,0,0,0,188,0,0,0,151,2,0,0,148,2,0,0,216,0,0,0,149,2,0,0,150,2,0,0,115,1,0,0,218,0,0,0,117,1,0,0,0,0,0,0,224,98,0,0,165,5,0,0,166,5,0,0,95,3,0,0,1,0,0,0,79,0,0,0,47,0,0,0,152,2,0,0,3,0,0,0,2,0,0,0,37,0,0,0,5,0,0,0,25,0,0,0,219,0,0,0,118,1,0,0,0,0,0,0,240,98,0,0,167,5,0,0,168,5,0,0,96,3,0,0,215,0,0,0,84,0,0,0,188,0,0,0,147,2,0,0,148,2,0,0,216,0,0,0,153,2,0,0,154,2,0,0,119,1,0,0,217,0,0,0,116,1,0,0,0,0,0,0,0,99,0,0,169,5,0,0,170,5,0,0,97,3,0,0,1,0,0,0,79,0,0,0,47,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,155,2,0,0,156,2,0,0,120,1,0,0,3,0,0,0,26,0,0,0,0,0,0,0,16,99,0,0,171,5,0,0,172,5,0,0,173,5,0,0,72,0,0,0,189,0,0,0,220,0,0,0,0,0,0,0,48,99,0,0,174,5,0,0,175,5,0,0,173,5,0,0,73,0,0,0,190,0,0,0,221,0,0,0,0,0,0,0,64,99,0,0,176,5,0,0,177,5,0,0,173,5,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,0,0,0,0,128,99,0,0,178,5,0,0,179,5,0,0,173,5,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,0,0,0,0,184,99,0,0,180,5,0,0,181,5,0,0,173,5,0,0,74,0,0,0,75,0,0,0,54,0,0,0,76,0,0,0,55,0,0,0,1,0,0,0,2,0,0,0,77,0,0,0,0,0,0,0,248,99,0,0,182,5,0,0,183,5,0,0,173,5,0,0,78,0,0,0,79,0,0,0,56,0,0,0,80,0,0,0,57,0,0,0,3,0,0,0,4,0,0,0,81,0,0,0,0,0,0,0,48,100,0,0,184,5,0,0,185,5,0,0,173,5,0,0,157,2,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,2,0,0,0,248,255,255,255,48,100,0,0,158,2,0,0,159,2,0,0,160,2,0,0,161,2,0,0,162,2,0,0,163,2,0,0,164,2,0,0,0,0,0,0,104,100,0,0,186,5,0,0,187,5,0,0,173,5,0,0,165,2,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,3,0,0,0,248,255,255,255,104,100,0,0,166,2,0,0,167,2,0,0,168,2,0,0,169,2,0,0,170,2,0,0,171,2,0,0,172,2,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,0,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,37,0,0,0,97,0,0,0,32,0,0,0,37,0,0,0,98,0,0,0,32,0,0,0,37,0,0,0,100,0,0,0,32,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,89,0,0,0,0,0,0,0,65,0,0,0,77,0,0,0,0,0,0,0,80,0,0,0,77,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,114,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,99,0,0,0,104,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,105,0,0,0,108,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,101,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,121,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,117,0,0,0,115,0,0,0,116,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,116,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,111,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,110,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,114,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,117,0,0,0,114,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,0,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,37,0,0,0,89,0,0,0,45,0,0,0,37,0,0,0,109,0,0,0,45,0,0,0,37,0,0,0,100,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,152,100,0,0,188,5,0,0,189,5,0,0,173,5,0,0,1,0,0,0,0,0,0,0,192,100,0,0,190,5,0,0,191,5,0,0,173,5,0,0,2,0,0,0,0,0,0,0,224,100,0,0,192,5,0,0,193,5,0,0,173,5,0,0,173,2,0,0,174,2,0,0,98,3,0,0,99,3,0,0,100,3,0,0,101,3,0,0,175,2,0,0,102,3,0,0,103,3,0,0,0,0,0,0,8,101,0,0,194,5,0,0,195,5,0,0,173,5,0,0,176,2,0,0,177,2,0,0,104,3,0,0,105,3,0,0,106,3,0,0,107,3,0,0,178,2,0,0,108,3,0,0,109,3,0,0,0,0,0,0,40,101,0,0,196,5,0,0,197,5,0,0,173,5,0,0,179,2,0,0,180,2,0,0,110,3,0,0,111,3,0,0,112,3,0,0,113,3,0,0,181,2,0,0,114,3,0,0,115,3,0,0,0,0,0,0,72,101,0,0,198,5,0,0,199,5,0,0,173,5,0,0,182,2,0,0,183,2,0,0,116,3,0,0,117,3,0,0,118,3,0,0,119,3,0,0,184,2,0,0,120,3,0,0,121,3,0,0,0,0,0,0,104,101,0,0,200,5,0,0,201,5,0,0,173,5,0,0,3,0,0,0,4,0,0,0,0,0,0,0,144,101,0,0,202,5,0,0,203,5,0,0,173,5,0,0,5,0,0,0,6,0,0,0,0,0,0,0,184,101,0,0,204,5,0,0,205,5,0,0,173,5,0,0,1,0,0,0,68,0,0,0,0,0,0,0,224,101,0,0,206,5,0,0,207,5,0,0,173,5,0,0,2,0,0,0,69,0,0,0,0,0,0,0,8,102,0,0,208,5,0,0,209,5,0,0,173,5,0,0,222,0,0,0,85,0,0,0,122,3,0,0,0,0,0,0,48,102,0,0,210,5,0,0,211,5,0,0,173,5,0,0,223,0,0,0,86,0,0,0,123,3,0,0,0,0,0,0,136,102,0,0,212,5,0,0,213,5,0,0,173,5,0,0,4,0,0,0,5,0,0,0,82,0,0,0,185,2,0,0,186,2,0,0,83,0,0,0,187,2,0,0,0,0,0,0,80,102,0,0,212,5,0,0,214,5,0,0,173,5,0,0,4,0,0,0,5,0,0,0,82,0,0,0,185,2,0,0,186,2,0,0,83,0,0,0,187,2,0,0,0,0,0,0,184,102,0,0,215,5,0,0,216,5,0,0,173,5,0,0,6,0,0,0,7,0,0,0,84,0,0,0,188,2,0,0,189,2,0,0,85,0,0,0,190,2,0,0,0,0,0,0,248,102,0,0,217,5,0,0,218,5,0,0,173,5,0,0,0,0,0,0,8,103,0,0,219,5,0,0,220,5,0,0,173,5,0,0,121,1,0,0,224,0,0,0,122,1,0,0,225,0,0,0,123,1,0,0,41,0,0,0,226,0,0,0,86,0,0,0,0,0,0,0,80,103,0,0,221,5,0,0,222,5,0,0,173,5,0,0,191,2,0,0,192,2,0,0,124,3,0,0,125,3,0,0,126,3,0,0,0,0,0,0,96,103,0,0,223,5,0,0,224,5,0,0,173,5,0,0,193,2,0,0,194,2,0,0,127,3,0,0,128,3,0,0,129,3,0,0,102,0,0,0,97,0,0,0,108,0,0,0,115,0,0,0,101,0,0,0,0,0,0,0,116,0,0,0,114,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,32,99,0,0,212,5,0,0,225,5,0,0,173,5,0,0,0,0,0,0,48,103,0,0,212,5,0,0,226,5,0,0,173,5,0,0,227,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,124,1,0,0,228,0,0,0,125,1,0,0,229,0,0,0,126,1,0,0,45,0,0,0,230,0,0,0,87,0,0,0,0,0,0,0,152,102,0,0,212,5,0,0,227,5,0,0,173,5,0,0,8,0,0,0,9,0,0,0,88,0,0,0,195,2,0,0,196,2,0,0,89,0,0,0,197,2,0,0,0,0,0,0,216,102,0,0,212,5,0,0,228,5,0,0,173,5,0,0,10,0,0,0,11,0,0,0,90,0,0,0,198,2,0,0,199,2,0,0,91,0,0,0,200,2,0,0,0,0,0,0,96,102,0,0,212,5,0,0,229,5,0,0,173,5,0,0,4,0,0,0,5,0,0,0,82,0,0,0,185,2,0,0,186,2,0,0,83,0,0,0,187,2,0,0,0,0,0,0,96,100,0,0,158,2,0,0,159,2,0,0,160,2,0,0,161,2,0,0,162,2,0,0,163,2,0,0,164,2,0,0,0,0,0,0,144,100,0,0,166,2,0,0,167,2,0,0,168,2,0,0,169,2,0,0,170,2,0,0,171,2,0,0,172,2,0,0,2,0,0,0,8,246,7,0,0,0,0,0,128,103,0,0,230,5,0,0,231,5,0,0,232,5,0,0,233,5,0,0,231,0,0,0,87,0,0,0,90,0,0,0,191,0,0,0,0,0,0,0,168,103,0,0,230,5,0,0,234,5,0,0,232,5,0,0,233,5,0,0,231,0,0,0,88,0,0,0,91,0,0,0,192,0,0,0,0,0,0,0,184,103,0,0,235,5,0,0,236,5,0,0,201,2,0,0,0,0,0,0,200,103,0,0,235,5,0,0,237,5,0,0,201,2,0,0,0,0,0,0,216,103,0,0,235,5,0,0,238,5,0,0,201,2,0,0,0,0,0,0,232,103,0,0,239,5,0,0,240,5,0,0,202,2,0,0,0,0,0,0,24,104,0,0,230,5,0,0,241,5,0,0,232,5,0,0,233,5,0,0,232,0,0,0,0,0,0,0,8,104,0,0,230,5,0,0,242,5,0,0,232,5,0,0,233,5,0,0,233,0,0,0,0,0,0,0,152,104,0,0,230,5,0,0,243,5,0,0,232,5,0,0,233,5,0,0,231,0,0,0,89,0,0,0,92,0,0,0,193,0,0,0,96,7,0,0,0,8,80,0,0,8,16,0,20,8,115,0,18,7,31,0,0,8,112,0,0,8,48,0,0,9,192,0,16,7,10,0,0,8,96,0,0,8,32,0,0,9,160,0,0,8,0,0,0,8,128,0,0,8,64,0,0,9,224,0,16,7,6,0,0,8,88,0,0,8,24,0,0,9,144,0,19,7,59,0,0,8,120,0,0,8,56,0,0,9,208,0,17,7,17],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+153600);allocate([8,104,0,0,8,40,0,0,9,176,0,0,8,8,0,0,8,136,0,0,8,72,0,0,9,240,0,16,7,4,0,0,8,84,0,0,8,20,0,21,8,227,0,19,7,43,0,0,8,116,0,0,8,52,0,0,9,200,0,17,7,13,0,0,8,100,0,0,8,36,0,0,9,168,0,0,8,4,0,0,8,132,0,0,8,68,0,0,9,232,0,16,7,8,0,0,8,92,0,0,8,28,0,0,9,152,0,20,7,83,0,0,8,124,0,0,8,60,0,0,9,216,0,18,7,23,0,0,8,108,0,0,8,44,0,0,9,184,0,0,8,12,0,0,8,140,0,0,8,76,0,0,9,248,0,16,7,3,0,0,8,82,0,0,8,18,0,21,8,163,0,19,7,35,0,0,8,114,0,0,8,50,0,0,9,196,0,17,7,11,0,0,8,98,0,0,8,34,0,0,9,164,0,0,8,2,0,0,8,130,0,0,8,66,0,0,9,228,0,16,7,7,0,0,8,90,0,0,8,26,0,0,9,148,0,20,7,67,0,0,8,122,0,0,8,58,0,0,9,212,0,18,7,19,0,0,8,106,0,0,8,42,0,0,9,180,0,0,8,10,0,0,8,138,0,0,8,74,0,0,9,244,0,16,7,5,0,0,8,86,0,0,8,22,0,64,8,0,0,19,7,51,0,0,8,118,0,0,8,54,0,0,9,204,0,17,7,15,0,0,8,102,0,0,8,38,0,0,9,172,0,0,8,6,0,0,8,134,0,0,8,70,0,0,9,236,0,16,7,9,0,0,8,94,0,0,8,30,0,0,9,156,0,20,7,99,0,0,8,126,0,0,8,62,0,0,9,220,0,18,7,27,0,0,8,110,0,0,8,46,0,0,9,188,0,0,8,14,0,0,8,142,0,0,8,78,0,0,9,252,0,96,7,0,0,0,8,81,0,0,8,17,0,21,8,131,0,18,7,31,0,0,8,113,0,0,8,49,0,0,9,194,0,16,7,10,0,0,8,97,0,0,8,33,0,0,9,162,0,0,8,1,0,0,8,129,0,0,8,65,0,0,9,226,0,16,7,6,0,0,8,89,0,0,8,25,0,0,9,146,0,19,7,59,0,0,8,121,0,0,8,57,0,0,9,210,0,17,7,17,0,0,8,105,0,0,8,41,0,0,9,178,0,0,8,9,0,0,8,137,0,0,8,73,0,0,9,242,0,16,7,4,0,0,8,85,0,0,8,21,0,16,8,2,1,19,7,43,0,0,8,117,0,0,8,53,0,0,9,202,0,17,7,13,0,0,8,101,0,0,8,37,0,0,9,170,0,0,8,5,0,0,8,133,0,0,8,69,0,0,9,234,0,16,7,8,0,0,8,93,0,0,8,29,0,0,9,154,0,20,7,83,0,0,8,125,0,0,8,61,0,0,9,218,0,18,7,23,0,0,8,109,0,0,8,45,0,0,9,186,0,0,8,13,0,0,8,141,0,0,8,77,0,0,9,250,0,16,7,3,0,0,8,83,0,0,8,19,0,21,8,195,0,19,7,35,0,0,8,115,0,0,8,51,0,0,9,198,0,17,7,11,0,0,8,99,0,0,8,35,0,0,9,166,0,0,8,3,0,0,8,131,0,0,8,67,0,0,9,230,0,16,7,7,0,0,8,91,0,0,8,27,0,0,9,150,0,20,7,67,0,0,8,123,0,0,8,59,0,0,9,214,0,18,7,19,0,0,8,107,0,0,8,43,0,0,9,182,0,0,8,11,0,0,8,139,0,0,8,75,0,0,9,246,0,16,7,5,0,0,8,87,0,0,8,23,0,64,8,0,0,19,7,51,0,0,8,119,0,0,8,55,0,0,9,206,0,17,7,15,0,0,8,103,0,0,8,39,0,0,9,174,0,0,8,7,0,0,8,135,0,0,8,71,0,0,9,238,0,16,7,9,0,0,8,95,0,0,8,31,0,0,9,158,0,20,7,99,0,0,8,127,0,0,8,63,0,0,9,222,0,18,7,27,0,0,8,111,0,0,8,47,0,0,9,190,0,0,8,15,0,0,8,143,0,0,8,79,0,0,9,254,0,96,7,0,0,0,8,80,0,0,8,16,0,20,8,115,0,18,7,31,0,0,8,112,0,0,8,48,0,0,9,193,0,16,7,10,0,0,8,96,0,0,8,32,0,0,9,161,0,0,8,0,0,0,8,128,0,0,8,64,0,0,9,225,0,16,7,6,0,0,8,88,0,0,8,24,0,0,9,145,0,19,7,59,0,0,8,120,0,0,8,56,0,0,9,209,0,17,7,17,0,0,8,104,0,0,8,40,0,0,9,177,0,0,8,8,0,0,8,136,0,0,8,72,0,0,9,241,0,16,7,4,0,0,8,84,0,0,8,20,0,21,8,227,0,19,7,43,0,0,8,116,0,0,8,52,0,0,9,201,0,17,7,13,0,0,8,100,0,0,8,36,0,0,9,169,0,0,8,4,0,0,8,132,0,0,8,68,0,0,9,233,0,16,7,8,0,0,8,92,0,0,8,28,0,0,9,153,0,20,7,83,0,0,8,124,0,0,8,60,0,0,9,217,0,18,7,23,0,0,8,108,0,0,8,44,0,0,9,185,0,0,8,12,0,0,8,140,0,0,8,76,0,0,9,249,0,16,7,3,0,0,8,82,0,0,8,18,0,21,8,163,0,19,7,35,0,0,8,114,0,0,8,50,0,0,9,197,0,17,7,11,0,0,8,98,0,0,8,34,0,0,9,165,0,0,8,2,0,0,8,130,0,0,8,66,0,0,9,229,0,16,7,7,0,0,8,90,0,0,8,26,0,0,9,149,0,20,7,67,0,0,8,122,0,0,8,58,0,0,9,213,0,18,7,19,0,0,8,106,0,0,8,42,0,0,9,181,0,0,8,10,0,0,8,138,0,0,8,74,0,0,9,245,0,16,7,5,0,0,8,86,0,0,8,22,0,64,8,0,0,19,7,51,0,0,8,118,0,0,8,54,0,0,9,205,0,17,7,15,0,0,8,102,0,0,8,38,0,0,9,173,0,0,8,6,0,0,8,134,0,0,8,70,0,0,9,237,0,16,7,9,0,0,8,94,0,0,8,30,0,0,9,157,0,20,7,99,0,0,8,126,0,0,8,62,0,0,9,221,0,18,7,27,0,0,8,110,0,0,8,46,0,0,9,189,0,0,8,14,0,0,8,142,0,0,8,78,0,0,9,253,0,96,7,0,0,0,8,81,0,0,8,17,0,21,8,131,0,18,7,31,0,0,8,113,0,0,8,49,0,0,9,195,0,16,7,10,0,0,8,97,0,0,8,33,0,0,9,163,0,0,8,1,0,0,8,129,0,0,8,65,0,0,9,227,0,16,7,6,0,0,8,89,0,0,8,25,0,0,9,147,0,19,7,59,0,0,8,121,0,0,8,57,0,0,9,211,0,17,7,17,0,0,8,105,0,0,8,41,0,0,9,179,0,0,8,9,0,0,8,137,0,0,8,73,0,0,9,243,0,16,7,4,0,0,8,85,0,0,8,21,0,16,8,2,1,19,7,43,0,0,8,117,0,0,8,53,0,0,9,203,0,17,7,13,0,0,8,101,0,0,8,37,0,0,9,171,0,0,8,5,0,0,8,133,0,0,8,69,0,0,9,235,0,16,7,8,0,0,8,93,0,0,8,29,0,0,9,155,0,20,7,83,0,0,8,125,0,0,8,61,0,0,9,219,0,18,7,23,0,0,8,109,0,0,8,45,0,0,9,187,0,0,8,13,0,0,8,141,0,0,8,77,0,0,9,251,0,16,7,3,0,0,8,83,0,0,8,19,0,21,8,195,0,19,7,35,0,0,8,115,0,0,8,51,0,0,9,199,0,17,7,11,0,0,8,99,0,0,8,35,0,0,9,167,0,0,8,3,0,0,8,131,0,0,8,67,0,0,9,231,0,16,7,7,0,0,8,91,0,0,8,27,0,0,9,151,0,20,7,67,0,0,8,123,0,0,8,59,0,0,9,215,0,18,7,19,0,0,8,107,0,0,8,43,0,0,9,183,0,0,8,11,0,0,8,139,0,0,8,75,0,0,9,247,0,16,7,5,0,0,8,87,0,0,8,23,0,64,8,0,0,19,7,51,0,0,8,119,0,0,8,55,0,0,9,207,0,17,7,15,0,0,8,103,0,0,8,39,0,0,9,175,0,0,8,7,0,0,8,135,0,0,8,71,0,0,9,239,0,16,7,9,0,0,8,95,0,0,8,31,0,0,9,159,0,20,7,99,0,0,8,127,0,0,8,63,0,0,9,223,0,18,7,27,0,0,8,111,0,0,8,47,0,0,9,191,0,0,8,15,0,0,8,143,0,0,8,79,0,0,9,255,0,16,5,1,0,23,5,1,1,19,5,17,0,27,5,1,16,17,5,5,0,25,5,1,4,21,5,65,0,29,5,1,64,16,5,3,0,24,5,1,2,20,5,33,0,28,5,1,32,18,5,9,0,26,5,1,8,22,5,129,0,64,5,0,0,16,5,2,0,23,5,129,1,19,5,25,0,27,5,1,24,17,5,7,0,25,5,1,6,21,5,97,0,29,5,1,96,16,5,4,0,24,5,1,3,20,5,49,0,28,5,1,48,18,5,13,0,26,5,1,12,22,5,193,0,64,5,0,0,16,0,17,0,18,0,0,0,8,0,7,0,9,0,6,0,10,0,5,0,11,0,4,0,12,0,3,0,13,0,2,0,14,0,1,0,15,0,1,0,2,0,3,0,4,0,5,0,7,0,9,0,13,0,17,0,25,0,33,0,49,0,65,0,97,0,129,0,193,0,1,1,129,1,1,2,1,3,1,4,1,6,1,8,1,12,1,16,1,24,1,32,1,48,1,64,1,96,0,0,0,0,3,0,4,0,5,0,6,0,7,0,8,0,9,0,10,0,11,0,13,0,15,0,17,0,19,0,23,0,27,0,31,0,35,0,43,0,51,0,59,0,67,0,83,0,99,0,115,0,131,0,163,0,195,0,227,0,2,1,0,0,0,0,16,0,16,0,16,0,16,0,17,0,17,0,18,0,18,0,19,0,19,0,20,0,20,0,21,0,21,0,22,0,22,0,23,0,23,0,24,0,24,0,25,0,25,0,26,0,26,0,27,0,27,0,28,0,28,0,29,0,29,0,64,0,64,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,16,0,17,0,17,0,17,0,17,0,18,0,18,0,18,0,18,0,19,0,19,0,19,0,19,0,20,0,20,0,20,0,20,0,21,0,21,0,21,0,21,0,16,0,77,0,202,0,0,0,5,0,16,0,5,0,8,0,5,0,24,0,5,0,4,0,5,0,20,0,5,0,12,0,5,0,28,0,5,0,2,0,5,0,18,0,5,0,10,0,5,0,26,0,5,0,6,0,5,0,22,0,5,0,14,0,5,0,30,0,5,0,1,0,5,0,17,0,5,0,9,0,5,0,25,0,5,0,5,0,5,0,21,0,5,0,13,0,5,0,29,0,5,0,3,0,5,0,19,0,5,0,11,0,5,0,27,0,5,0,7,0,5,0,23,0,5,0,12,0,8,0,140,0,8,0,76,0,8,0,204,0,8,0,44,0,8,0,172,0,8,0,108,0,8,0,236,0,8,0,28,0,8,0,156,0,8,0,92,0,8,0,220,0,8,0,60,0,8,0,188,0,8,0,124,0,8,0,252,0,8,0,2,0,8,0,130,0,8,0,66,0,8,0,194,0,8,0,34,0,8,0,162,0,8,0,98,0,8,0,226,0,8,0,18,0,8,0,146,0,8,0,82,0,8,0,210,0,8,0,50,0,8,0,178,0,8,0,114,0,8,0,242,0,8,0,10,0,8,0,138,0,8,0,74,0,8,0,202,0,8,0,42,0,8,0,170,0,8,0,106,0,8,0,234,0,8,0,26,0,8,0,154,0,8,0,90,0,8,0,218,0,8,0,58,0,8,0,186,0,8,0,122,0,8,0,250,0,8,0,6,0,8,0,134,0,8,0,70,0,8,0,198,0,8,0,38,0,8,0,166,0,8,0,102,0,8,0,230,0,8,0,22,0,8,0,150,0,8,0,86,0,8,0,214,0,8,0,54,0,8,0,182,0,8,0,118,0,8,0,246,0,8,0,14,0,8,0,142,0,8,0,78,0,8,0,206,0,8,0,46,0,8,0,174,0,8,0,110,0,8,0,238,0,8,0,30,0,8,0,158,0,8,0,94,0,8,0,222,0,8,0,62,0,8,0,190,0,8,0,126,0,8,0,254,0,8,0,1,0,8,0,129,0,8,0,65,0,8,0,193,0,8,0,33,0,8,0,161,0,8,0,97,0,8,0,225,0,8,0,17,0,8,0,145,0,8,0,81,0,8,0,209,0,8,0,49,0,8,0,177,0,8,0,113,0,8,0,241,0,8,0,9,0,8,0,137,0,8,0,73,0,8,0,201,0,8,0,41,0,8,0,169,0,8,0,105,0,8,0,233,0,8,0,25,0,8,0,153,0,8,0,89,0,8,0,217,0,8,0,57,0,8,0,185,0,8,0,121,0,8,0,249,0,8,0,5,0,8,0,133,0,8,0,69,0,8,0,197,0,8,0,37,0,8,0,165,0,8,0,101,0,8,0,229,0,8,0,21,0,8,0,149,0,8,0,85,0,8,0,213,0,8,0,53,0,8,0,181,0,8,0,117,0,8,0,245,0,8,0,13,0,8,0,141,0,8,0,77,0,8,0,205,0,8,0,45,0,8,0,173,0,8,0,109,0,8,0,237,0,8,0,29,0,8,0,157,0,8,0,93,0,8,0,221,0,8,0,61,0,8,0,189,0,8,0,125,0,8,0,253,0,8,0,19,0,9,0,19,1,9,0,147,0,9,0,147,1,9,0,83,0,9,0,83,1,9,0,211,0,9,0,211,1,9,0,51,0,9,0,51,1,9,0,179,0,9,0,179,1,9,0,115,0,9,0,115,1,9,0,243,0,9,0,243,1,9,0,11,0,9,0,11,1,9,0,139,0,9,0,139,1,9,0,75,0,9,0,75,1,9,0,203,0,9,0,203,1,9,0,43,0,9,0,43,1,9,0,171,0,9,0,171,1,9,0,107,0,9,0,107,1,9,0,235,0,9,0,235,1,9,0,27,0,9,0,27,1,9,0,155,0,9,0,155,1,9,0,91,0,9,0,91,1,9,0,219,0,9,0,219,1,9,0,59,0,9,0,59,1,9,0,187,0,9,0,187,1,9,0,123,0,9,0,123,1,9,0,251,0,9,0,251,1,9,0,7,0,9,0,7,1,9,0,135,0,9,0,135,1,9,0,71,0,9,0,71,1,9,0,199,0,9,0,199,1,9,0,39,0,9,0,39,1,9,0,167,0,9,0,167,1,9,0,103,0,9,0,103,1,9,0,231,0,9,0,231,1,9,0,23,0,9,0,23,1,9,0,151,0,9,0,151,1,9,0,87,0,9,0,87,1,9,0,215,0,9,0,215,1,9,0,55,0,9,0,55,1,9,0,183,0,9,0,183,1,9,0,119,0,9,0,119,1,9,0,247,0,9,0,247,1,9,0,15,0,9,0,15,1,9,0,143,0,9,0,143,1,9,0,79,0,9,0,79,1,9,0,207,0,9,0,207,1,9,0,47,0,9,0,47,1,9,0,175,0,9,0,175,1,9,0,111,0,9,0,111,1,9,0,239,0,9,0,239,1,9,0,31,0,9,0,31,1,9,0,159,0,9,0,159,1,9,0,95,0,9,0,95,1,9,0,223,0,9,0,223,1,9,0,63,0,9,0,63,1,9,0,191,0,9,0,191,1,9,0,127,0,9,0,127,1,9,0,255,0,9,0,255,1,9,0,0,0,7,0,64,0,7,0,32,0,7,0,96,0,7,0,16,0,7,0,80,0,7,0,48,0,7,0,112,0,7,0,8,0,7,0,72,0,7,0,40,0,7,0,104,0,7,0,24,0,7,0,88,0,7,0,56,0,7,0,120,0,7,0,4,0,7,0,68,0,7,0,36,0,7,0,100,0,7,0,20,0,7,0,84,0,7,0,52,0,7,0,116,0,7,0,3,0,8,0,131,0,8,0,67,0,8,0,195,0,8,0,35,0,8,0,163,0,8,0,99,0,8,0,227,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,3,32,2,32,2,32,2,32,2,32,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,96,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,4,192,4,192,4,192,4,192,4,192,4,192,4,192,8,213,8,213,8,213,8,213,8,213,8,213,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,4,192,4,192,4,192,4,192,4,192,4,192,8,214,8,214,8,214,8,214,8,214,8,214,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,4,192,4,192,4,192,4,192,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,117,115,104,0,73,110,116,86,101,99,116,111,114,0,70,108,111,97,116,86,101,99,116,111,114,0,68,111,117,98,108,101,86,101,99,116,111,114,0,80,111,105,110,116,86,101,99,116,111,114,0,77,97,116,86,101,99,116,111,114,0,82,101,99,116,86,101,99,116,111,114,0,101,121,101,0,111,110,101,115,0,122,101,114,111,115,0,109,97,116,83,105,122,101,0,115,116,101,112,0,100,97,116,97,56,83,0,100,97,116,97,49,54,85,0,100,97,116,97,49,54,83,0,100,97,116,97,51,50,83,0,100,97,116,97,51,50,70,0,100,97,116,97,54,52,70,0,101,108,101,109,83,105,122,101,0,101,108,101,109,83,105,122,101,49,0,99,104,97,110,110,101,108,115,0,114,111,119,0,114,111,119,82,97,110,103,101,0,99,111,108,82,97,110,103,101,0,115,116,101,112,49,0,99,108,111,110,101,0,99,111,108,0,109,117,108,0,105,110,118,0,117,99,104,97,114,80,116,114,0,99,104,97,114,80,116,114,0,115,104,111,114,116,80,116,114,0,117,115,104,111,114,116,80,116,114,0,105,110,116,80,116,114,0,102,108,111,97,116,80,116,114,0,100,111,117,98,108,101,80,116,114,0,99,104,97,114,65,116,0,117,99,104,97,114,65,116,0,115,104,111,114,116,65,116,0,117,115,104,111,114,116,65,116,0,105,110,116,65,116,0,102,108,111,97,116,65,116,0,100,111,117,98,108,101,65,116,0,82,97,110,103,101,0,84,101,114,109,67,114,105,116,101,114,105,97,0,109,97,120,67,111,117,110,116,0,35,116,121,112,101,0,82,101,99,116,0,82,101,99,116,50,102,0,82,111,116,97,116,101,100,82,101,99,116,0,99,101,110,116,101,114,0,97,110,103,108,101,0,114,111,116,97,116,101,100,82,101,99,116,80,111,105,110,116,115,0,114,111,116,97,116,101,100,82,101,99,116,66,111,117,110,100,105,110,103,82,101,99,116,0,114,111,116,97,116,101,100,82,101,99,116,66,111,117,110,100,105,110,103,82,101,99,116,50,102,0,83,99,97,108,97,114,0,77,105,110,77,97,120,76,111,99,0,109,105,110,86,97,108,0,109,97,120,86,97,108,0,109,105,110,76,111,99,0,109,97,120,76,111,99,0,67,105,114,99,108,101,0,114,97,100,105,117,115,0,77,111,109,101,110,116,115,0,109,48,48,0,109,49,48,0,109,48,49,0,109,50,48,0,109,49,49,0,109,48,50,0,109,51,48,0,109,50,49,0,109,49,50,0,109,48,51,0,109,117,50,48,0,109,117,49,49,0,109,117,48,50,0,109,117,51,48,0,109,117,50,49,0,109,117,49,50,0,109,117,48,51,0,110,117,50,48,0,110,117,49,49,0,110,117,48,50,0,110,117,51,48,0,110,117,50,49,0,110,117,49,50,0,110,117,48,51,0,69,120,99,101,112,116,105,111,110,0,99,111,100,101,0,109,115,103,0,101,120,99,101,112,116,105,111,110,70,114,111,109,80,116,114,0,109,111,114,112,104,111,108,111,103,121,68,101,102,97,117,108,116,66,111,114,100,101,114,86,97,108,117,101,0,67,86,95,77,65,84,95,68,69,80,84,72,0,67,97,109,83,104,105,102,116,0,103,101,116,66,117,105,108,100,73,110,102,111,114,109,97,116,105,111,110,0,67,86,95,56,85,67,49,0,67,86,95,56,85,67,50,0,67,86,95,56,85,67,51,0,67,86,95,56,85,67,52,0,67,86,95,56,83,67,49,0,67,86,95,56,83,67,50,0,67,86,95,56,83,67,51,0,67,86,95,56,83,67,52,0,67,86,95,49,54,85,67,49,0,67,86,95,49,54,85,67,50,0,67,86,95,49,54,85,67,51,0,67,86,95,49,54,85,67,52,0,67,86,95,49,54,83,67,49,0,67,86,95,49,54,83,67,50,0,67,86,95,49,54,83,67,51,0,67,86,95,49,54,83,67,52,0,67,86,95,51,50,83,67,50,0,67,86,95,51,50,83,67,51,0,67,86,95,51,50,83,67,52,0,67,86,95,51,50,70,67,50,0,67,86,95,51,50,70,67,51,0,67,86,95,51,50,70,67,52,0,67,86,95,54,52,70,67,49,0,67,86,95,54,52,70,67,50,0,67,86,95,54,52,70,67,51,0,67,86,95,54,52,70,67,52,0,73,78,84,95,77,73,78,0,73,78,84,95,77,65,88,0,67,97,110,110,121,49,0,71,97,117,115,115,105,97,110,66,108,117,114,0,72,111,117,103,104,76,105,110,101,115,0,72,111,117,103,104,76,105,110,101,115,80,0,76,97,112,108,97,99,105,97,110,0,83,99,104,97,114,114,0,83,111,98,101,108,0,97,98,115,100,105,102,102,0,97,100,100,0,97,100,100,87,101,105,103,104,116,101,100,0,98,105,116,119,105,115,101,95,97,110,100,0,98,105,116,119,105,115,101,95,110,111,116,0,98,105,116,119,105,115,101,95,111,114,0,98,105,116,119,105,115,101,95,120,111,114,0,98,108,117,114,0,98,111,117,110,100,105,110,103,82,101,99,116,0,98,111,120,70,105,108,116,101,114,0,99,97,108,99,79,112,116,105,99,97,108,70,108,111,119,70,97,114,110,101,98,97,99,107,0,99,97,108,99,79,112,116,105,99,97,108,70,108,111,119,80,121,114,76,75,0,99,111,114,110,101,114,72,97,114,114,105,115,0,99,111,114,110,101,114,77,105,110,69,105,103,101,110,86,97,108,0,100,105,108,97,116,101,0,100,105,115,116,97,110,99,101,84,114,97,110,115,102,111,114,109,87,105,116,104,76,97,98,101,108,115,0,100,105,118,105,100,101,0,100,105,118,105,100,101,49,0,101,108,108,105,112,115,101,49,0,101,108,108,105,112,115,101,50,80,111,108,121,0,101,114,111,100,101,0,101,115,116,105,109,97,116,101,82,105,103,105,100,84,114,97,110,115,102,111,114,109,49,0,102,105,108,116,101,114,50,68,0,103,101,116,79,112,116,105,109,97,108,68,70,84,83,105,122,101,0,103,101,116,82,111,116,97,116,105,111,110,77,97,116,114,105,120,50,68,0,103,111,111,100,70,101,97,116,117,114,101,115,84,111,84,114,97,99,107,49,0,105,110,116,101,103,114,97,108,50,0,109,105,110,0,109,105,110,65,114,101,97,82,101,99,116,0,109,117,108,116,105,112,108,121,0,110,111,114,109,49,0,112,117,116,84,101,120,116,0,114,97,110,100,110,0,114,97,110,100,117,0,115,101,116,82,78,71,83,101,101,100,0,115,113,114,116,0,115,117,98,116,114,97,99,116,0,98,108,111,98,70,114,111,109,73,109,97,103,101,0,114,101,97,100,78,101,116,70,114,111,109,67,97,102,102,101,0,114,101,97,100,78,101,116,70,114,111,109,67,97,102,102,101,49,0,114,101,97,100,78,101,116,70,114,111,109,68,97,114,107,110,101,116,49,0,114,101,97,100,78,101,116,70,114,111,109,84,101,110,115,111,114,102,108,111,119,0,114,101,97,100,78,101,116,70,114,111,109,84,101,110,115,111,114,102,108,111,119,49,0,114,101,97,100,78,101,116,70,114,111,109,84,111,114,99,104,0,72,79,71,68,101,115,99,114,105,112,116,111,114,0,108,111,97,100,0,103,101,116,68,101,102,97,117,108,116,80,101,111,112,108,101,68,101,116,101,99,116,111,114,0,103,101,116,68,97,105,109,108,101,114,80,101,111,112,108,101,68,101,116,101,99,116,111,114,0,115,118,109,68,101,116,101,99,116,111,114,0,66,97,99,107,103,114,111,117,110,100,83,117,98,116,114,97,99,116,111,114,0,66,97,99,107,103,114,111,117,110,100,83,117,98,116,114,97,99,116,111,114,77,79,71,50,0,80,116,114,60,66,97,99,107,103,114,111,117,110,100,83,117,98,116,114,97,99,116,111,114,77,79,71,50,62,0,67,76,65,72,69,0,115,101,116,84,105,108,101,115,71,114,105,100,83,105,122,101,0,99,111,108,108,101,99,116,71,97,114,98,97,103,101,0,115,101,116,67,108,105,112,76,105,109,105,116,0,103,101,116,84,105,108,101,115,71,114,105,100,83,105,122,101,0,103,101,116,67,108,105,112,76,105,109,105,116,0,80,116,114,60,67,76,65,72,69,62,0,65,108,103,111,114,105,116,104,109,0,100,110,110,95,78,101,116,0,102,111,114,119,97,114,100,49,0,102,111,114,119,97,114,100,50,0,67,97,115,99,97,100,101,67,108,97,115,115,105,102,105,101,114,0,100,101,116,101,99,116,77,117,108,116,105,83,99,97,108,101,50,0,100,101,116,101,99,116,77,117,108,116,105,83,99,97,108,101,51,0,65,67,67,69,83,83,95,70,65,83,84,0,65,67,67,69,83,83,95,77,65,83,75,0,65,67,67,69,83,83,95,82,69,65,68,0,65,67,67,69,83,83,95,82,87,0,65,67,67,69,83,83,95,87,82,73,84,69,0,65,68,65,80,84,73,86,69,95,84,72,82,69,83,72,95,71,65,85,83,83,73,65,78,95,67,0,65,68,65,80,84,73,86,69,95,84,72,82,69,83,72,95,77,69,65,78,95,67,0,66,79,82,68,69,82,95,67,79,78,83,84,65,78,84,0,66,79,82,68,69,82,95,68,69,70,65,85,76,84,0,66,79,82,68,69,82,95,73,83,79,76,65,84,69,68,0,66,79,82,68,69,82,95,82,69,70,76,69,67,84,0,66,79,82,68,69,82,95,82,69,70,76,69,67,84,49,48,49,0,66,79,82,68,69,82,95,82,69,70,76,69,67,84,95,49,48,49,0,66,79,82,68,69,82,95,82,69,80,76,73,67,65,84,69,0,66,79,82,68,69,82,95,84,82,65,78,83,80,65,82,69,78,84,0,66,79,82,68,69,82,95,87,82,65,80,0,67,65,83,67,65,68,69,95,68,79,95,67,65,78,78,89,95,80,82,85,78,73,78,71,0,67,65,83,67,65,68,69,95,68,79,95,82,79,85,71,72,95,83,69,65,82,67,72,0,67,65,83,67,65,68,69,95,70,73,78,68,95,66,73,71,71,69,83,84,95,79,66,74,69,67,84,0,67,65,83,67,65,68,69,95,83,67,65,76,69,95,73,77,65,71,69,0,67,67,76,95,68,69,70,65,85,76,84,0,67,67,76,95,71,82,65,78,65,0,67,67,76,95,87,85,0,67,67,95,83,84,65,84,95,65,82,69,65,0,67,67,95,83,84,65,84,95,72,69,73,71,72,84,0,67,67,95,83,84,65,84,95,76,69,70,84,0,67,67,95,83,84,65,84,95,77,65,88,0,67,67,95,83,84,65,84,95,84,79,80,0,67,67,95,83,84,65,84,95,87,73,68,84,72,0,67,72,65,73,78,95,65,80,80,82,79,88,95,78,79,78,69,0,67,72,65,73,78,95,65,80,80,82,79,88,95,83,73,77,80,76,69,0,67,72,65,73,78,95,65,80,80,82,79,88,95,84,67,56,57,95,75,67,79,83,0,67,72,65,73,78,95,65,80,80,82,79,88,95,84,67,56,57,95,76,49,0,67,77,80,95,69,81,0,67,77,80,95,71,69,0,67,77,80,95,71,84,0,67,77,80,95,76,69,0,67,77,80,95,76,84,0,67,77,80,95,78,69,0,67,79,76,79,82,77,65,80,95,65,85,84,85,77,78,0,67,79,76,79,82,77,65,80,95,66,79,78,69,0,67,79,76,79,82,77,65,80,95,67,79,79,76,0,67,79,76,79,82,77,65,80,95,72,79,84,0,67,79,76,79,82,77,65,80,95,72,83,86,0,67,79,76,79,82,77,65,80,95,74,69,84,0,67,79,76,79,82,77,65,80,95,79,67,69,65,78,0,67,79,76,79,82,77,65,80,95,80,65,82,85,76,65,0,67,79,76,79,82,77,65,80,95,80,73,78,75,0,67,79,76,79,82,77,65,80,95,82,65,73,78,66,79,87,0,67,79,76,79,82,77,65,80,95,83,80,82,73,78,71,0,67,79,76,79,82,77,65,80,95,83,85,77,77,69,82,0,67,79,76,79,82,77,65,80,95,87,73,78,84,69,82,0,67,79,76,79,82,95,66,71,82,50,66,71,82,53,53,53,0,67,79,76,79,82,95,66,71,82,50,66,71,82,53,54,53,0,67,79,76,79,82,95,66,71,82,50,66,71,82,65,0,67,79,76,79,82,95,66,71,82,50,71,82,65,89,0,67,79,76,79,82,95,66,71,82,50,72,76,83,0,67,79,76,79,82,95,66,71,82,50,72,76,83,95,70,85,76,76,0,67,79,76,79,82,95,66,71,82,50,72,83,86,0,67,79,76,79,82,95,66,71,82,50,72,83,86,95,70,85,76,76,0,67,79,76,79,82,95,66,71,82,50,76,97,98,0,67,79,76,79,82,95,66,71,82,50,76,117,118,0,67,79,76,79,82,95,66,71,82,50,82,71,66,0,67,79,76,79,82,95,66,71,82,50,82,71,66,65,0,67,79,76,79,82,95,66,71,82,50,88,89,90,0,67,79,76,79,82,95,66,71,82,50,89,67,114,67,98,0,67,79,76,79,82,95,66,71,82,50,89,85,86,0,67,79,76,79,82,95,66,71,82,50,89,85,86,95,73,52,50,48,0,67,79,76,79,82,95,66,71,82,50,89,85,86,95,73,89,85,86,0,67,79,76,79,82,95,66,71,82,50,89,85,86,95,89,86,49,50,0,67,79,76,79,82,95,66,71,82,53,53,53,50,66,71,82,0,67,79,76,79,82,95,66,71,82,53,53,53,50,66,71,82,65,0,67,79,76,79,82,95,66,71,82,53,53,53,50,71,82,65,89,0,67,79,76,79,82,95,66,71,82,53,53,53,50,82,71,66,0,67,79,76,79,82,95,66,71,82,53,53,53,50,82,71,66,65,0,67,79,76,79,82,95,66,71,82,53,54,53,50,66,71,82,0,67,79,76,79,82,95,66,71,82,53,54,53,50,66,71,82,65,0,67,79,76,79,82,95,66,71,82,53,54,53,50,71,82,65,89,0,67,79,76,79,82,95,66,71,82,53,54,53,50,82,71,66,0,67,79,76,79,82,95,66,71,82,53,54,53,50,82,71,66,65,0,67,79,76,79,82,95,66,71,82,65,50,66,71,82,0,67,79,76,79,82,95,66,71,82,65,50,66,71,82,53,53,53,0,67,79,76,79,82,95,66,71,82,65,50,66,71,82,53,54,53,0,67,79,76,79,82,95,66,71,82,65,50,71,82,65,89,0,67,79,76,79,82,95,66,71,82,65,50,82,71,66,0,67,79,76,79,82,95,66,71,82,65,50,82,71,66,65,0,67,79,76,79,82,95,66,71,82,65,50,89,85,86,95,73,52,50,48,0,67,79,76,79,82,95,66,71,82,65,50,89,85,86,95,73,89,85,86,0,67,79,76,79,82,95,66,71,82,65,50,89,85,86,95,89,86,49,50,0,67,79,76,79,82,95,66,97,121,101,114,66,71,50,66,71,82,0,67,79,76,79,82,95,66,97,121,101,114,66,71,50,66,71,82,65,0,67,79,76,79,82,95,66,97,121,101,114,66,71,50,66,71,82,95,69,65,0,67,79,76,79,82,95,66,97,121,101,114,66,71,50,66,71,82,95,86,78,71,0,67,79,76,79,82,95,66,97,121,101,114,66,71,50,71,82,65,89,0,67,79,76,79,82,95,66,97,121,101,114,66,71,50,82,71,66,0,67,79,76,79,82,95,66,97,121,101,114,66,71,50,82,71,66,65,0,67,79,76,79,82,95,66,97,121,101,114,66,71,50,82,71,66,95,69,65,0,67,79,76,79,82,95,66,97,121,101,114,66,71,50,82,71,66,95,86,78,71,0,67,79,76,79,82,95,66,97,121,101,114,71,66,50,66,71,82,0,67,79,76,79,82,95,66,97,121,101,114,71,66,50,66,71,82,65,0,67,79,76,79,82,95,66,97,121,101,114,71,66,50,66,71,82,95,69,65,0,67,79,76,79,82,95,66,97,121,101,114,71,66,50,66,71,82,95,86,78,71,0,67,79,76,79,82,95,66,97,121,101,114,71,66,50,71,82,65,89,0,67,79,76,79,82,95,66,97,121,101,114,71,66,50,82,71,66,0,67,79,76,79,82,95,66,97,121,101,114,71,66,50,82,71,66,65,0,67,79,76,79,82,95,66,97,121,101,114,71,66,50,82,71,66,95,69,65,0,67,79,76,79,82,95,66,97,121,101,114,71,66,50,82,71,66,95,86,78,71,0,67,79,76,79,82,95,66,97,121,101,114,71,82,50,66,71,82,0,67,79,76,79,82,95,66,97,121,101,114,71,82,50,66,71,82,65,0,67,79,76,79,82,95,66,97,121,101,114,71,82,50,66,71,82,95,69,65,0,67,79,76,79,82,95,66,97,121,101,114,71,82,50,66,71,82,95,86,78,71,0,67,79,76,79,82,95,66,97,121,101,114,71,82,50,71,82,65,89,0,67,79,76,79,82,95,66,97,121,101,114,71,82,50,82,71,66,0,67,79,76,79,82,95,66,97,121,101,114,71,82,50,82,71,66,65,0,67,79,76,79,82,95,66,97,121,101,114,71,82,50,82,71,66,95,69,65,0,67,79,76,79,82,95,66,97,121,101,114,71,82,50,82,71,66,95,86,78,71,0,67,79,76,79,82,95,66,97,121,101,114,82,71,50,66,71,82,0,67,79,76,79,82,95,66,97,121,101,114,82,71,50,66,71,82,65,0,67,79,76,79,82,95,66,97,121,101,114,82,71,50,66,71,82,95,69,65,0,67,79,76,79,82,95,66,97,121,101,114,82,71,50,66,71,82,95,86,78,71,0,67,79,76,79,82,95,66,97,121,101,114,82,71,50,71,82,65,89,0,67,79,76,79,82,95,66,97,121,101,114,82,71,50,82,71,66,0,67,79,76,79,82,95,66,97,121,101,114,82,71,50,82,71,66,65,0,67,79,76,79,82,95,66,97,121,101,114,82,71,50,82,71,66,95,69,65,0,67,79,76,79,82,95,66,97,121,101,114,82,71,50,82,71,66,95,86,78,71,0,67,79,76,79,82,95,67,79,76,79,82,67,86,84,95,77,65,88,0,67,79,76,79,82,95,71,82,65,89,50,66,71,82,0,67,79,76,79,82,95,71,82,65,89,50,66,71,82,53,53,53,0,67,79,76,79,82,95,71,82,65,89,50,66,71,82,53,54,53,0,67,79,76,79,82,95,71,82,65,89,50,66,71,82,65,0,67,79,76,79,82,95,71,82,65,89,50,82,71,66,0,67,79,76,79,82,95,71,82,65,89,50,82,71,66,65,0,67,79,76,79,82,95,72,76,83,50,66,71,82,0,67,79,76,79,82,95,72,76,83,50,66,71,82,95,70,85,76,76,0,67,79,76,79,82,95,72,76,83,50,82,71,66,0,67,79,76,79,82,95,72,76,83,50,82,71,66,95,70,85,76,76,0,67,79,76,79,82,95,72,83,86,50,66,71,82,0,67,79,76,79,82,95,72,83,86,50,66,71,82,95,70,85,76,76,0,67,79,76,79,82,95,72,83,86,50,82,71,66,0,67,79,76,79,82,95,72,83,86,50,82,71,66,95,70,85,76,76,0,67,79,76,79,82,95,76,66,71,82,50,76,97,98,0,67,79,76,79,82,95,76,66,71,82,50,76,117,118,0,67,79,76,79,82,95,76,82,71,66,50,76,97,98,0,67,79,76,79,82,95,76,82,71,66,50,76,117,118,0,67,79,76,79,82,95,76,97,98,50,66,71,82,0,67,79,76,79,82,95,76,97,98,50,76,66,71,82,0,67,79,76,79,82,95,76,97,98,50,76,82,71,66,0,67,79,76,79,82,95,76,97,98,50,82,71,66,0,67,79,76,79,82,95,76,117,118,50,66,71,82,0,67,79,76,79,82,95,76,117,118,50,76,66,71,82,0,67,79,76,79,82,95,76,117,118,50,76,82,71,66,0,67,79,76,79,82,95,76,117,118,50,82,71,66,0,67,79,76,79,82,95,82,71,66,50,66,71,82,0,67,79,76,79,82,95,82,71,66,50,66,71,82,53,53,53,0,67,79,76,79,82,95,82,71,66,50,66,71,82,53,54,53,0,67,79,76,79,82,95,82,71,66,50,66,71,82,65,0,67,79,76,79,82,95,82,71,66,50,71,82,65,89,0,67,79,76,79,82,95,82,71,66,50,72,76,83,0,67,79,76,79,82,95,82,71,66,50,72,76,83,95,70,85,76,76,0,67,79,76,79,82,95,82,71,66,50,72,83,86,0,67,79,76,79,82,95,82,71,66,50,72,83,86,95,70,85,76,76,0,67,79,76,79,82,95,82,71,66,50,76,97,98,0,67,79,76,79,82,95,82,71,66,50,76,117,118,0,67,79,76,79,82,95,82,71,66,50,82,71,66,65,0,67,79,76,79,82,95,82,71,66,50,88,89,90,0,67,79,76,79,82,95,82,71,66,50,89,67,114,67,98,0,67,79,76,79,82,95,82,71,66,50,89,85,86,0,67,79,76,79,82,95,82,71,66,50,89,85,86,95,73,52,50,48,0,67,79,76,79,82,95,82,71,66,50,89,85,86,95,73,89,85,86,0,67,79,76,79,82,95,82,71,66,50,89,85,86,95,89,86,49,50,0,67,79,76,79,82,95,82,71,66,65,50,66,71,82,0,67,79,76,79,82,95,82,71,66,65,50,66,71,82,53,53,53,0,67,79,76,79,82,95,82,71,66,65,50,66,71,82,53,54,53,0,67,79,76,79,82,95,82,71,66,65,50,66,71,82,65,0,67,79,76,79,82,95,82,71,66,65,50,71,82,65,89,0,67,79,76,79,82,95,82,71,66,65,50,82,71,66,0,67,79,76,79,82,95,82,71,66,65,50,89,85,86,95,73,52,50,48,0,67,79,76,79,82,95,82,71,66,65,50,89,85,86,95,73,89,85,86,0,67,79,76,79,82,95,82,71,66,65,50,89,85,86,95,89,86,49,50,0,67,79,76,79,82,95,82,71,66,65,50,109,82,71,66,65,0,67,79,76,79,82,95,88,89,90,50,66,71,82,0,67,79,76,79,82,95,88,89,90,50,82,71,66,0,67,79,76,79,82,95,89,67,114,67,98,50,66,71,82,0,67,79,76,79,82,95,89,67,114,67,98,50,82,71,66,0,67,79,76,79,82,95,89,85,86,50,66,71,82,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,73,52,50,48,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,73,89,85,86,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,78,86,49,50,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,78,86,50,49,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,85,89,78,86,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,85,89,86,89,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,89,52,50,50,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,89,85,78,86,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,89,85,89,50,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,89,85,89,86,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,89,86,49,50,0,67,79,76,79,82,95,89,85,86,50,66,71,82,65,95,89,86,89,85,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,73,52,50,48,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,73,89,85,86,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,78,86,49,50,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,78,86,50,49,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,85,89,78,86,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,85,89,86,89,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,89,52,50,50,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,89,85,78,86,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,89,85,89,50,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,89,85,89,86,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,89,86,49,50,0,67,79,76,79,82,95,89,85,86,50,66,71,82,95,89,86,89,85,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,52,50,48,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,73,52,50,48,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,73,89,85,86,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,78,86,49,50,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,78,86,50,49,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,85,89,78,86,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,85,89,86,89,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,89,52,50,50,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,89,85,78,86,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,89,85,89,50,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,89,85,89,86,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,89,86,49,50,0,67,79,76,79,82,95,89,85,86,50,71,82,65,89,95,89,86,89,85,0,67,79,76,79,82,95,89,85,86,50,82,71,66,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,73,52,50,48,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,73,89,85,86,0,67,79,76,79],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+163841);allocate([82,95,89,85,86,50,82,71,66,65,95,78,86,49,50,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,78,86,50,49,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,85,89,78,86,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,85,89,86,89,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,89,52,50,50,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,89,85,78,86,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,89,85,89,50,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,89,85,89,86,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,89,86,49,50,0,67,79,76,79,82,95,89,85,86,50,82,71,66,65,95,89,86,89,85,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,73,52,50,48,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,73,89,85,86,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,78,86,49,50,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,78,86,50,49,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,85,89,78,86,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,85,89,86,89,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,89,52,50,50,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,89,85,78,86,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,89,85,89,50,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,89,85,89,86,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,89,86,49,50,0,67,79,76,79,82,95,89,85,86,50,82,71,66,95,89,86,89,85,0,67,79,76,79,82,95,89,85,86,52,50,48,112,50,66,71,82,0,67,79,76,79,82,95,89,85,86,52,50,48,112,50,66,71,82,65,0,67,79,76,79,82,95,89,85,86,52,50,48,112,50,71,82,65,89,0,67,79,76,79,82,95,89,85,86,52,50,48,112,50,82,71,66,0,67,79,76,79,82,95,89,85,86,52,50,48,112,50,82,71,66,65,0,67,79,76,79,82,95,89,85,86,52,50,48,115,112,50,66,71,82,0,67,79,76,79,82,95,89,85,86,52,50,48,115,112,50,66,71,82,65,0,67,79,76,79,82,95,89,85,86,52,50,48,115,112,50,71,82,65,89,0,67,79,76,79,82,95,89,85,86,52,50,48,115,112,50,82,71,66,0,67,79,76,79,82,95,89,85,86,52,50,48,115,112,50,82,71,66,65,0,67,79,76,79,82,95,109,82,71,66,65,50,82,71,66,65,0,67,79,78,84,79,85,82,83,95,77,65,84,67,72,95,73,49,0,67,79,78,84,79,85,82,83,95,77,65,84,67,72,95,73,50,0,67,79,78,84,79,85,82,83,95,77,65,84,67,72,95,73,51,0,67,79,86,65,82,95,67,79,76,83,0,67,79,86,65,82,95,78,79,82,77,65,76,0,67,79,86,65,82,95,82,79,87,83,0,67,79,86,65,82,95,83,67,65,76,69,0,67,79,86,65,82,95,83,67,82,65,77,66,76,69,68,0,67,79,86,65,82,95,85,83,69,95,65,86,71,0,68,67,84,95,73,78,86,69,82,83,69,0,68,67,84,95,82,79,87,83,0,68,69,67,79,77,80,95,67,72,79,76,69,83,75,89,0,68,69,67,79,77,80,95,69,73,71,0,68,69,67,79,77,80,95,76,85,0,68,69,67,79,77,80,95,78,79,82,77,65,76,0,68,69,67,79,77,80,95,81,82,0,68,69,67,79,77,80,95,83,86,68,0,68,70,84,95,67,79,77,80,76,69,88,95,73,78,80,85,84,0,68,70,84,95,67,79,77,80,76,69,88,95,79,85,84,80,85,84,0,68,70,84,95,73,78,86,69,82,83,69,0,68,70,84,95,82,69,65,76,95,79,85,84,80,85,84,0,68,70,84,95,82,79,87,83,0,68,70,84,95,83,67,65,76,69,0,68,73,83,84,95,67,0,68,73,83,84,95,70,65,73,82,0,68,73,83,84,95,72,85,66,69,82,0,68,73,83,84,95,76,49,0,68,73,83,84,95,76,49,50,0,68,73,83,84,95,76,50,0,68,73,83,84,95,76,65,66,69,76,95,67,67,79,77,80,0,68,73,83,84,95,76,65,66,69,76,95,80,73,88,69,76,0,68,73,83,84,95,77,65,83,75,95,51,0,68,73,83,84,95,77,65,83,75,95,53,0,68,73,83,84,95,77,65,83,75,95,80,82,69,67,73,83,69,0,68,73,83,84,95,85,83,69,82,0,68,73,83,84,95,87,69,76,83,67,72,0,70,73,76,76,69,68,0,70,76,79,79,68,70,73,76,76,95,70,73,88,69,68,95,82,65,78,71,69,0,70,76,79,79,68,70,73,76,76,95,77,65,83,75,95,79,78,76,89,0,70,79,78,84,95,72,69,82,83,72,69,89,95,67,79,77,80,76,69,88,0,70,79,78,84,95,72,69,82,83,72,69,89,95,67,79,77,80,76,69,88,95,83,77,65,76,76,0,70,79,78,84,95,72,69,82,83,72,69,89,95,68,85,80,76,69,88,0,70,79,78,84,95,72,69,82,83,72,69,89,95,80,76,65,73,78,0,70,79,78,84,95,72,69,82,83,72,69,89,95,83,67,82,73,80,84,95,67,79,77,80,76,69,88,0,70,79,78,84,95,72,69,82,83,72,69,89,95,83,67,82,73,80,84,95,83,73,77,80,76,69,88,0,70,79,78,84,95,72,69,82,83,72,69,89,95,83,73,77,80,76,69,88,0,70,79,78,84,95,72,69,82,83,72,69,89,95,84,82,73,80,76,69,88,0,70,79,78,84,95,73,84,65,76,73,67,0,70,105,108,101,78,111,100,101,95,69,77,80,84,89,0,70,105,108,101,78,111,100,101,95,70,76,79,65,84,0,70,105,108,101,78,111,100,101,95,70,76,79,87,0,70,105,108,101,78,111,100,101,95,73,78,84,0,70,105,108,101,78,111,100,101,95,77,65,80,0,70,105,108,101,78,111,100,101,95,78,65,77,69,68,0,70,105,108,101,78,111,100,101,95,78,79,78,69,0,70,105,108,101,78,111,100,101,95,82,69,65,76,0,70,105,108,101,78,111,100,101,95,82,69,70,0,70,105,108,101,78,111,100,101,95,83,69,81,0,70,105,108,101,78,111,100,101,95,83,84,82,0,70,105,108,101,78,111,100,101,95,83,84,82,73,78,71,0,70,105,108,101,78,111,100,101,95,84,89,80,69,95,77,65,83,75,0,70,105,108,101,78,111,100,101,95,85,83,69,82,0,70,105,108,101,83,116,111,114,97,103,101,95,65,80,80,69,78,68,0,70,105,108,101,83,116,111,114,97,103,101,95,66,65,83,69,54,52,0,70,105,108,101,83,116,111,114,97,103,101,95,70,79,82,77,65,84,95,65,85,84,79,0,70,105,108,101,83,116,111,114,97,103,101,95,70,79,82,77,65,84,95,74,83,79,78,0,70,105,108,101,83,116,111,114,97,103,101,95,70,79,82,77,65,84,95,77,65,83,75,0,70,105,108,101,83,116,111,114,97,103,101,95,70,79,82,77,65,84,95,88,77,76,0,70,105,108,101,83,116,111,114,97,103,101,95,70,79,82,77,65,84,95,89,65,77,76,0,70,105,108,101,83,116,111,114,97,103,101,95,73,78,83,73,68,69,95,77,65,80,0,70,105,108,101,83,116,111,114,97,103,101,95,77,69,77,79,82,89,0,70,105,108,101,83,116,111,114,97,103,101,95,78,65,77,69,95,69,88,80,69,67,84,69,68,0,70,105,108,101,83,116,111,114,97,103,101,95,82,69,65,68,0,70,105,108,101,83,116,111,114,97,103,101,95,85,78,68,69,70,73,78,69,68,0,70,105,108,101,83,116,111,114,97,103,101,95,86,65,76,85,69,95,69,88,80,69,67,84,69,68,0,70,105,108,101,83,116,111,114,97,103,101,95,87,82,73,84,69,0,70,105,108,101,83,116,111,114,97,103,101,95,87,82,73,84,69,95,66,65,83,69,54,52,0,70,111,114,109,97,116,116,101,114,95,70,77,84,95,67,0,70,111,114,109,97,116,116,101,114,95,70,77,84,95,67,83,86,0,70,111,114,109,97,116,116,101,114,95,70,77,84,95,68,69,70,65,85,76,84,0,70,111,114,109,97,116,116,101,114,95,70,77,84,95,77,65,84,76,65,66,0,70,111,114,109,97,116,116,101,114,95,70,77,84,95,78,85,77,80,89,0,70,111,114,109,97,116,116,101,114,95,70,77,84,95,80,89,84,72,79,78,0,71,67,95,66,71,68,0,71,67,95,69,86,65,76,0,71,67,95,69,86,65,76,95,70,82,69,69,90,69,95,77,79,68,69,76,0,71,67,95,70,71,68,0,71,67,95,73,78,73,84,95,87,73,84,72,95,77,65,83,75,0,71,67,95,73,78,73,84,95,87,73,84,72,95,82,69,67,84,0,71,67,95,80,82,95,66,71,68,0,71,67,95,80,82,95,70,71,68,0,71,69,77,77,95,49,95,84,0,71,69,77,77,95,50,95,84,0,71,69,77,77,95,51,95,84,0,72,73,83,84,67,77,80,95,66,72,65,84,84,65,67,72,65,82,89,89,65,0,72,73,83,84,67,77,80,95,67,72,73,83,81,82,0,72,73,83,84,67,77,80,95,67,72,73,83,81,82,95,65,76,84,0,72,73,83,84,67,77,80,95,67,79,82,82,69,76,0,72,73,83,84,67,77,80,95,72,69,76,76,73,78,71,69,82,0,72,73,83,84,67,77,80,95,73,78,84,69,82,83,69,67,84,0,72,73,83,84,67,77,80,95,75,76,95,68,73,86,0,72,79,71,68,101,115,99,114,105,112,116,111,114,95,68,69,70,65,85,76,84,95,78,76,69,86,69,76,83,0,72,79,71,68,101,115,99,114,105,112,116,111,114,95,76,50,72,121,115,0,72,79,85,71,72,95,71,82,65,68,73,69,78,84,0,72,79,85,71,72,95,77,85,76,84,73,95,83,67,65,76,69,0,72,79,85,71,72,95,80,82,79,66,65,66,73,76,73,83,84,73,67,0,72,79,85,71,72,95,83,84,65,78,68,65,82,68,0,72,97,109,109,105,110,103,95,110,111,114,109,84,121,112,101,0,73,78,84,69,82,83,69,67,84,95,70,85,76,76,0,73,78,84,69,82,83,69,67,84,95,78,79,78,69,0,73,78,84,69,82,83,69,67,84,95,80,65,82,84,73,65,76,0,73,78,84,69,82,95,65,82,69,65,0,73,78,84,69,82,95,66,73,84,83,0,73,78,84,69,82,95,66,73,84,83,50,0,73,78,84,69,82,95,67,85,66,73,67,0,73,78,84,69,82,95,76,65,78,67,90,79,83,52,0,73,78,84,69,82,95,76,73,78,69,65,82,0,73,78,84,69,82,95,76,73,78,69,65,82,95,69,88,65,67,84,0,73,78,84,69,82,95,77,65,88,0,73,78,84,69,82,95,78,69,65,82,69,83,84,0,73,78,84,69,82,95,84,65,66,95,83,73,90,69,0,73,78,84,69,82,95,84,65,66,95,83,73,90,69,50,0,75,77,69,65,78,83,95,80,80,95,67,69,78,84,69,82,83,0,75,77,69,65,78,83,95,82,65,78,68,79,77,95,67,69,78,84,69,82,83,0,75,77,69,65,78,83,95,85,83,69,95,73,78,73,84,73,65,76,95,76,65,66,69,76,83,0,76,73,78,69,95,52,0,76,73,78,69,95,56,0,76,73,78,69,95,65,65,0,76,83,68,95,82,69,70,73,78,69,95,65,68,86,0,76,83,68,95,82,69,70,73,78,69,95,78,79,78,69,0,76,83,68,95,82,69,70,73,78,69,95,83,84,68,0,77,65,82,75,69,82,95,67,82,79,83,83,0,77,65,82,75,69,82,95,68,73,65,77,79,78,68,0,77,65,82,75,69,82,95,83,81,85,65,82,69,0,77,65,82,75,69,82,95,83,84,65,82,0,77,65,82,75,69,82,95,84,73,76,84,69,68,95,67,82,79,83,83,0,77,65,82,75,69,82,95,84,82,73,65,78,71,76,69,95,68,79,87,78,0,77,65,82,75,69,82,95,84,82,73,65,78,71,76,69,95,85,80,0,77,79,82,80,72,95,66,76,65,67,75,72,65,84,0,77,79,82,80,72,95,67,76,79,83,69,0,77,79,82,80,72,95,67,82,79,83,83,0,77,79,82,80,72,95,68,73,76,65,84,69,0,77,79,82,80,72,95,69,76,76,73,80,83,69,0,77,79,82,80,72,95,69,82,79,68,69,0,77,79,82,80,72,95,71,82,65,68,73,69,78,84,0,77,79,82,80,72,95,72,73,84,77,73,83,83,0,77,79,82,80,72,95,79,80,69,78,0,77,79,82,80,72,95,82,69,67,84,0,77,79,82,80,72,95,84,79,80,72,65,84,0,77,79,84,73,79,78,95,65,70,70,73,78,69,0,77,79,84,73,79,78,95,69,85,67,76,73,68,69,65,78,0,77,79,84,73,79,78,95,72,79,77,79,71,82,65,80,72,89,0,77,79,84,73,79,78,95,84,82,65,78,83,76,65,84,73,79,78,0,77,97,116,95,65,85,84,79,95,83,84,69,80,0,77,97,116,95,67,79,78,84,73,78,85,79,85,83,95,70,76,65,71,0,77,97,116,95,68,69,80,84,72,95,77,65,83,75,0,77,97,116,95,77,65,71,73,67,95,77,65,83,75,0,77,97,116,95,77,65,71,73,67,95,86,65,76,0,77,97,116,95,83,85,66,77,65,84,82,73,88,95,70,76,65,71,0,77,97,116,95,84,89,80,69,95,77,65,83,75,0,78,79,82,77,95,72,65,77,77,73,78,71,0,78,79,82,77,95,72,65,77,77,73,78,71,50,0,78,79,82,77,95,73,78,70,0,78,79,82,77,95,76,49,0,78,79,82,77,95,76,50,0,78,79,82,77,95,76,50,83,81,82,0,78,79,82,77,95,77,73,78,77,65,88,0,78,79,82,77,95,82,69,76,65,84,73,86,69,0,78,79,82,77,95,84,89,80,69,95,77,65,83,75,0,79,80,84,70,76,79,87,95,70,65,82,78,69,66,65,67,75,95,71,65,85,83,83,73,65,78,0,79,80,84,70,76,79,87,95,76,75,95,71,69,84,95,77,73,78,95,69,73,71,69,78,86,65,76,83,0,79,80,84,70,76,79,87,95,85,83,69,95,73,78,73,84,73,65,76,95,70,76,79,87,0,80,67,65,95,68,65,84,65,95,65,83,95,67,79,76,0,80,67,65,95,68,65,84,65,95,65,83,95,82,79,87,0,80,67,65,95,85,83,69,95,65,86,71,0,80,82,79,74,95,83,80,72,69,82,73,67,65,76,95,69,81,82,69,67,84,0,80,82,79,74,95,83,80,72,69,82,73,67,65,76,95,79,82,84,72,79,0,80,97,114,97,109,95,65,76,71,79,82,73,84,72,77,0,80,97,114,97,109,95,66,79,79,76,69,65,78,0,80,97,114,97,109,95,70,76,79,65,84,0,80,97,114,97,109,95,73,78,84,0,80,97,114,97,109,95,77,65,84,0,80,97,114,97,109,95,77,65,84,95,86,69,67,84,79,82,0,80,97,114,97,109,95,82,69,65,76,0,80,97,114,97,109,95,83,67,65,76,65,82,0,80,97,114,97,109,95,83,84,82,73,78,71,0,80,97,114,97,109,95,85,67,72,65,82,0,80,97,114,97,109,95,85,73,78,84,54,52,0,80,97,114,97,109,95,85,78,83,73,71,78,69,68,95,73,78,84,0,82,69,68,85,67,69,95,65,86,71,0,82,69,68,85,67,69,95,77,65,88,0,82,69,68,85,67,69,95,77,73,78,0,82,69,68,85,67,69,95,83,85,77,0,82,69,84,82,95,67,67,79,77,80,0,82,69,84,82,95,69,88,84,69,82,78,65,76,0,82,69,84,82,95,70,76,79,79,68,70,73,76,76,0,82,69,84,82,95,76,73,83,84,0,82,69,84,82,95,84,82,69,69,0,82,78,71,95,78,79,82,77,65,76,0,82,78,71,95,85,78,73,70,79,82,77,0,82,79,84,65,84,69,95,49,56,48,0,82,79,84,65,84,69,95,57,48,95,67,76,79,67,75,87,73,83,69,0,82,79,84,65,84,69,95,57,48,95,67,79,85,78,84,69,82,67,76,79,67,75,87,73,83,69,0,83,79,76,86,69,76,80,95,77,85,76,84,73,0,83,79,76,86,69,76,80,95,83,73,78,71,76,69,0,83,79,76,86,69,76,80,95,85,78,66,79,85,78,68,69,68,0,83,79,76,86,69,76,80,95,85,78,70,69,65,83,73,66,76,69,0,83,79,82,84,95,65,83,67,69,78,68,73,78,71,0,83,79,82,84,95,68,69,83,67,69,78,68,73,78,71,0,83,79,82,84,95,69,86,69,82,89,95,67,79,76,85,77,78,0,83,79,82,84,95,69,86,69,82,89,95,82,79,87,0,83,86,68,95,70,85,76,76,95,85,86,0,83,86,68,95,77,79,68,73,70,89,95,65,0,83,86,68,95,78,79,95,85,86,0,83,112,97,114,115,101,77,97,116,95,72,65,83,72,95,66,73,84,0,83,112,97,114,115,101,77,97,116,95,72,65,83,72,95,83,67,65,76,69,0,83,112,97,114,115,101,77,97,116,95,77,65,71,73,67,95,86,65,76,0,83,112,97,114,115,101,77,97,116,95,77,65,88,95,68,73,77,0,83,117,98,100,105,118,50,68,95,78,69,88,84,95,65,82,79,85,78,68,95,68,83,84,0,83,117,98,100,105,118,50,68,95,78,69,88,84,95,65,82,79,85,78,68,95,76,69,70,84,0,83,117,98,100,105,118,50,68,95,78,69,88,84,95,65,82,79,85,78,68,95,79,82,71,0,83,117,98,100,105,118,50,68,95,78,69,88,84,95,65,82,79,85,78,68,95,82,73,71,72,84,0,83,117,98,100,105,118,50,68,95,80,82,69,86,95,65,82,79,85,78,68,95,68,83,84,0,83,117,98,100,105,118,50,68,95,80,82,69,86,95,65,82,79,85,78,68,95,76,69,70,84,0,83,117,98,100,105,118,50,68,95,80,82,69,86,95,65,82,79,85,78,68,95,79,82,71,0,83,117,98,100,105,118,50,68,95,80,82,69,86,95,65,82,79,85,78,68,95,82,73,71,72,84,0,83,117,98,100,105,118,50,68,95,80,84,76,79,67,95,69,82,82,79,82,0,83,117,98,100,105,118,50,68,95,80,84,76,79,67,95,73,78,83,73,68,69,0,83,117,98,100,105,118,50,68,95,80,84,76,79,67,95,79,78,95,69,68,71,69,0,83,117,98,100,105,118,50,68,95,80,84,76,79,67,95,79,85,84,83,73,68,69,95,82,69,67,84,0,83,117,98,100,105,118,50,68,95,80,84,76,79,67,95,86,69,82,84,69,88,0,84,72,82,69,83,72,95,66,73,78,65,82,89,0,84,72,82,69,83,72,95,66,73,78,65,82,89,95,73,78,86,0,84,72,82,69,83,72,95,77,65,83,75,0,84,72,82,69,83,72,95,79,84,83,85,0,84,72,82,69,83,72,95,84,79,90,69,82,79,0,84,72,82,69,83,72,95,84,79,90,69,82,79,95,73,78,86,0,84,72,82,69,83,72,95,84,82,73,65,78,71,76,69,0,84,72,82,69,83,72,95,84,82,85,78,67,0,84,77,95,67,67,79,69,70,70,0,84,77,95,67,67,79,69,70,70,95,78,79,82,77,69,68,0,84,77,95,67,67,79,82,82,0,84,77,95,67,67,79,82,82,95,78,79,82,77,69,68,0,84,77,95,83,81,68,73,70,70,0,84,77,95,83,81,68,73,70,70,95,78,79,82,77,69,68,0,84,101,114,109,67,114,105,116,101,114,105,97,95,67,79,85,78,84,0,84,101,114,109,67,114,105,116,101,114,105,97,95,69,80,83,0,84,101,114,109,67,114,105,116,101,114,105,97,95,77,65,88,95,73,84,69,82,0,85,77,97,116,68,97,116,97,95,65,83,89,78,67,95,67,76,69,65,78,85,80,0,85,77,97,116,68,97,116,97,95,67,79,80,89,95,79,78,95,77,65,80,0,85,77,97,116,68,97,116,97,95,68,69,86,73,67,69,95,67,79,80,89,95,79,66,83,79,76,69,84,69,0,85,77,97,116,68,97,116,97,95,68,69,86,73,67,69,95,77,69,77,95,77,65,80,80,69,68,0,85,77,97,116,68,97,116,97,95,72,79,83,84,95,67,79,80,89,95,79,66,83,79,76,69,84,69,0,85,77,97,116,68,97,116,97,95,84,69,77,80,95,67,79,80,73,69,68,95,85,77,65,84,0,85,77,97,116,68,97,116,97,95,84,69,77,80,95,85,77,65,84,0,85,77,97,116,68,97,116,97,95,85,83,69,82,95,65,76,76,79,67,65,84,69,68,0,85,77,97,116,95,65,85,84,79,95,83,84,69,80,0,85,77,97,116,95,67,79,78,84,73,78,85,79,85,83,95,70,76,65,71,0,85,77,97,116,95,68,69,80,84,72,95,77,65,83,75,0,85,77,97,116,95,77,65,71,73,67,95,77,65,83,75,0,85,77,97,116,95,77,65,71,73,67,95,86,65,76,0,85,77,97,116,95,83,85,66,77,65,84,82,73,88,95,70,76,65,71,0,85,77,97,116,95,84,89,80,69,95,77,65,83,75,0,85,83,65,71,69,95,65,76,76,79,67,65,84,69,95,68,69,86,73,67,69,95,77,69,77,79,82,89,0,85,83,65,71,69,95,65,76,76,79,67,65,84,69,95,72,79,83,84,95,77,69,77,79,82,89,0,85,83,65,71,69,95,65,76,76,79,67,65,84,69,95,83,72,65,82,69,68,95,77,69,77,79,82,89,0,85,83,65,71,69,95,68,69,70,65,85,76,84,0,87,65,82,80,95,70,73,76,76,95,79,85,84,76,73,69,82,83,0,87,65,82,80,95,73,78,86,69,82,83,69,95,77,65,80,0,87,65,82,80,95,80,79,76,65,82,95,76,73,78,69,65,82,0,87,65,82,80,95,80,79,76,65,82,95,76,79,71,0,95,73,110,112,117,116,65,114,114,97,121,95,67,85,68,65,95,71,80,85,95,77,65,84,0,95,73,110,112,117,116,65,114,114,97,121,95,67,85,68,65,95,72,79,83,84,95,77,69,77,0,95,73,110,112,117,116,65,114,114,97,121,95,69,88,80,82,0,95,73,110,112,117,116,65,114,114,97,121,95,70,73,88,69,68,95,83,73,90,69,0,95,73,110,112,117,116,65,114,114,97,121,95,70,73,88,69,68,95,84,89,80,69,0,95,73,110,112,117,116,65,114,114,97,121,95,75,73,78,68,95,77,65,83,75,0,95,73,110,112,117,116,65,114,114,97,121,95,75,73,78,68,95,83,72,73,70,84,0,95,73,110,112,117,116,65,114,114,97,121,95,77,65,84,0,95,73,110,112,117,116,65,114,114,97,121,95,77,65,84,88,0,95,73,110,112,117,116,65,114,114,97,121,95,78,79,78,69,0,95,73,110,112,117,116,65,114,114,97,121,95,79,80,69,78,71,76,95,66,85,70,70,69,82,0,95,73,110,112,117,116,65,114,114,97,121,95,83,84,68,95,65,82,82,65,89,0,95,73,110,112,117,116,65,114,114,97,121,95,83,84,68,95,65,82,82,65,89,95,77,65,84,0,95,73,110,112,117,116,65,114,114,97,121,95,83,84,68,95,66,79,79,76,95,86,69,67,84,79,82,0,95,73,110,112,117,116,65,114,114,97,121,95,83,84,68,95,86,69,67,84,79,82,0,95,73,110,112,117,116,65,114,114,97,121,95,83,84,68,95,86,69,67,84,79,82,95,67,85,68,65,95,71,80,85,95,77,65,84,0,95,73,110,112,117,116,65,114,114,97,121,95,83,84,68,95,86,69,67,84,79,82,95,77,65,84,0,95,73,110,112,117,116,65,114,114,97,121,95,83,84,68,95,86,69,67,84,79,82,95,85,77,65,84,0,95,73,110,112,117,116,65,114,114,97,121,95,83,84,68,95,86,69,67,84,79,82,95,86,69,67,84,79,82,0,95,73,110,112,117,116,65,114,114,97,121,95,85,77,65,84,0,95,79,117,116,112,117,116,65,114,114,97,121,95,68,69,80,84,72,95,77,65,83,75,95,49,54,83,0,95,79,117,116,112,117,116,65,114,114,97,121,95,68,69,80,84,72,95,77,65,83,75,95,49,54,85,0,95,79,117,116,112,117,116,65,114,114,97,121,95,68,69,80,84,72,95,77,65,83,75,95,51,50,70,0,95,79,117,116,112,117,116,65,114,114,97,121,95,68,69,80,84,72,95,77,65,83,75,95,51,50,83,0,95,79,117,116,112,117,116,65,114,114,97,121,95,68,69,80,84,72,95,77,65,83,75,95,54,52,70,0,95,79,117,116,112,117,116,65,114,114,97,121,95,68,69,80,84,72,95,77,65,83,75,95,56,83,0,95,79,117,116,112,117,116,65,114,114,97,121,95,68,69,80,84,72,95,77,65,83,75,95,56,85,0,95,79,117,116,112,117,116,65,114,114,97,121,95,68,69,80,84,72,95,77,65,83,75,95,65,76,76,0,95,79,117,116,112,117,116,65,114,114,97,121,95,68,69,80,84,72,95,77,65,83,75,95,65,76,76,95,66,85,84,95,56,83,0,95,79,117,116,112,117,116,65,114,114,97,121,95,68,69,80,84,72,95,77,65,83,75,95,70,76,84,0,95,95,85,77,65,84,95,85,83,65,71,69,95,70,76,65,71,83,95,51,50,66,73,84,0,66,97,100,65,108,105,103,110,0,66,97,100,65,108,112,104,97,67,104,97,110,110,101,108,0,66,97,100,67,79,73,0,66,97,100,67,97,108,108,66,97,99,107,0,66,97,100,68,97,116,97,80,116,114,0,66,97,100,68,101,112,116,104,0,66,97,100,73,109,97,103,101,83,105,122,101,0,66,97,100,77,111,100,101,108,79,114,67,104,83,101,113,0,66,97,100,78,117,109,67,104,97,110,110,101,108,49,85,0,66,97,100,78,117,109,67,104,97,110,110,101,108,115,0,66,97,100,79,102,102,115,101,116,0,66,97,100,79,114,100,101,114,0,66,97,100,79,114,105,103,105,110,0,66,97,100,82,79,73,83,105,122,101,0,66,97,100,83,116,101,112,0,66,97,100,84,105,108,101,83,105,122,101,0,71,112,117,65,112,105,67,97,108,108,69,114,114,111,114,0,71,112,117,78,111,116,83,117,112,112,111,114,116,101,100,0,72,101,97,100,101,114,73,115,78,117,108,108,0,77,97,115,107,73,115,84,105,108,101,100,0,79,112,101,110,67,76,65,112,105,67,97,108,108,69,114,114,111,114,0,79,112,101,110,67,76,68,111,117,98,108,101,78,111,116,83,117,112,112,111,114,116,101,100,0,79,112,101,110,67,76,73,110,105,116,69,114,114,111,114,0,79,112,101,110,67,76,78,111,65,77,68,66,108,97,115,70,102,116,0,79,112,101,110,71,108,65,112,105,67,97,108,108,69,114,114,111,114,0,79,112,101,110,71,108,78,111,116,83,117,112,112,111,114,116,101,100,0,83,116,115,65,115,115,101,114,116,0,83,116,115,65,117,116,111,84,114,97,99,101,0,83,116,115,66,97,99,107,84,114,97,99,101,0,83,116,115,66,97,100,65,114,103,0,83,116,115,66,97,100,70,108,97,103,0,83,116,115,66,97,100,70,117,110,99,0,83,116,115,66,97,100,77,97,115,107,0,83,116,115,66,97,100,77,101,109,66,108,111,99,107,0,83,116,115,66,97,100,80,111,105,110,116,0,83,116,115,66,97,100,83,105,122,101,0,83,116,115,68,105,118,66,121,90,101,114,111,0,83,116,115,69,114,114,111,114,0,83,116,115,70,105,108,116,101,114,79,102,102,115,101,116,69,114,114,0,83,116,115,70,105,108,116,101,114,83,116,114,117,99,116,67,111,110,116,101,110,116,69,114,114,0,83,116,115,73,110,112,108,97,99,101,78,111,116,83,117,112,112,111,114,116,101,100,0,83,116,115,73,110,116,101,114,110,97,108,0,83,116,115,75,101,114,110,101,108,83,116,114,117,99,116,67,111,110,116,101,110,116,69,114,114,0,83,116,115,78,111,67,111,110,118,0,83,116,115,78,111,77,101,109,0,83,116,115,78,111,116,73,109,112,108,101,109,101,110,116,101,100,0,83,116,115,78,117,108,108,80,116,114,0,83,116,115,79,98,106,101,99,116,78,111,116,70,111,117,110,100,0,83,116,115,79,107,0,83,116,115,79,117,116,79,102,82,97,110,103,101,0,83,116,115,80,97,114,115,101,69,114,114,111,114,0,83,116,115,85,110,109,97,116,99,104,101,100,70,111,114,109,97,116,115,0,83,116,115,85,110,109,97,116,99,104,101,100,83,105,122,101,115,0,83,116,115,85,110,115,117,112,112,111,114,116,101,100,70,111,114,109,97,116,0,83,116,115,86,101,99,76,101,110,103,116,104,69,114,114,0,84,69,83,84,95,67,85,83,84,79,77,0,84,69,83,84,95,69,81,0,84,69,83,84,95,71,69,0,84,69,83,84,95,71,84,0,84,69,83,84,95,76,69,0,84,69,83,84,95,76,84,0,84,69,83,84,95,78,69,0,68,78,78,95,66,65,67,75,69,78,68,95,68,69,70,65,85,76,84,0,68,78,78,95,66,65,67,75,69,78,68,95,72,65,76,73,68,69,0,68,78,78,95,66,65,67,75,69,78,68,95,73,78,70,69,82,69,78,67,69,95,69,78,71,73,78,69,0,68,78,78,95,66,65,67,75,69,78,68,95,79,80,69,78,67,86,0,68,78,78,95,84,65,82,71,69,84,95,67,80,85,0,68,78,78,95,84,65,82,71,69,84,95,77,89,82,73,65,68,0,68,78,78,95,84,65,82,71,69,84,95,79,80,69,78,67,76,0,68,78,78,95,84,65,82,71,69,84,95,79,80,69,78,67,76,95,70,80,49,54,0,70,76,65,71,83,95,69,88,80,65,78,68,95,83,65,77,69,95,78,65,77,69,83,0,70,76,65,71,83,95,77,65,80,80,73,78,71,0,70,76,65,71,83,95,78,79,78,69,0,73,77,80,76,95,73,80,80,0,73,77,80,76,95,79,80,69,78,67,76,0,73,77,80,76,95,80,76,65,73,78,0,84,89,80,69,95,70,85,78,0,84,89,80,69,95,71,69,78,69,82,65,76,0,84,89,80,69,95,77,65,82,75,69,82,0,84,89,80,69,95,87,82,65,80,80,69,82,0,78,50,99,118,54,80,111,105,110,116,95,73,102,69,69,0,78,50,99,118,49,49,82,111,116,97,116,101,100,82,101,99,116,69,0,78,50,99,118,53,82,101,99,116,95,73,105,69,69,0,112,117,115,104,95,98,97,99,107,0,115,101,116,0,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,105,78,83,95,57,97,108,108,111,99,97,116,111,114,73,105,69,69,69,69,0,78,83,116,51,95,95,50,49,51,95,95,118,101,99,116,111,114,95,98,97,115,101,73,105,78,83,95,57,97,108,108,111,99,97,116,111,114,73,105,69,69,69,69,0,78,83,116,51,95,95,50,50,48,95,95,118,101,99,116,111,114,95,98,97,115,101,95,99,111,109,109,111,110,73,76,98,49,69,69,69,0,80,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,105,78,83,95,57,97,108,108,111,99,97,116,111,114,73,105,69,69,69,69,0,80,75,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,105,78,83,95,57,97,108,108,111,99,97,116,111,114,73,105,69,69,69,69,0,105,105,0,118,0,118,105,0,118,105,105,105,0,118,105,105,105,105,0,105,105,105,0,78,49,48,101,109,115,99,114,105,112,116,101,110,51,118,97,108,69,0,105,105,105,105,0,105,105,105,105,105,0,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,102,78,83,95,57,97,108,108,111,99,97,116,111,114,73,102,69,69,69,69,0,78,83,116,51,95,95,50,49,51,95,95,118,101,99,116,111,114,95,98,97,115,101,73,102,78,83,95,57,97,108,108,111,99,97,116,111,114,73,102,69,69,69,69,0,80,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,102,78,83,95,57,97,108,108,111,99,97,116,111,114,73,102,69,69,69,69,0,80,75,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,102,78,83,95,57,97,108,108,111,99,97,116,111,114,73,102,69,69,69,69,0,118,105,105,102,0,118,105,105,105,102,0,105,105,105,105,102,0,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,100,78,83,95,57,97,108,108,111,99,97,116,111,114,73,100,69,69,69,69,0,78,83,116,51,95,95,50,49,51,95,95,118,101,99,116,111,114,95,98,97,115,101,73,100,78,83,95,57,97,108,108,111,99,97,116,111,114,73,100,69,69,69,69,0,80,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,100,78,83,95,57,97,108,108,111,99,97,116,111,114,73,100,69,69,69,69,0,80,75,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,100,78,83,95,57,97,108,108,111,99,97,116,111,114,73,100,69,69,69,69,0,118,105,105,100,0,118,105,105,105,100,0,105,105,105,105,100,0,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,78,50,99,118,54,80,111,105,110,116,95,73,105,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,69,69,0,78,83,116,51,95,95,50,49,51,95,95,118,101,99,116,111,114,95,98,97,115,101,73,78,50,99,118,54,80,111,105,110,116,95,73,105,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,69,69,0,80,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,78,50,99,118,54,80,111,105,110,116,95,73,105,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,69,69,0,80,75,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,78,50,99,118,54,80,111,105,110,116,95,73,105,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,80,111,105,110,116,95,73,105,69,69,0,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,78,50,99,118,51,77,97,116,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,50,95,69,69,69,69,0,78,83,116,51,95,95,50,49,51,95,95,118,101,99,116,111,114,95,98,97,115,101,73,78,50,99,118,51,77,97,116,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,50,95,69,69,69,69,0,80,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,78,50,99,118,51,77,97,116,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,50,95,69,69,69,69,0,80,75,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,78,50,99,118,51,77,97,116,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,50,95,69,69,69,69,0,78,50,99,118,51,77,97,116,69,0,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,78,50,99,118,53,82,101,99,116,95,73,105,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,69,69,0,78,83,116,51,95,95,50,49,51,95,95,118,101,99,116,111,114,95,98,97,115,101,73,78,50,99,118,53,82,101,99,116,95,73,105,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,69,69,0,80,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,78,50,99,118,53,82,101,99,116,95,73,105,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,69,69,0,80,75,78,83,116,51,95,95,50,54,118,101,99,116,111,114,73,78,50,99,118,53,82,101,99,116,95,73,105,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,83,51,95,69,69,69,69,0,80,78,50,99,118,51,77,97,116,69,0,80,75,78,50,99,118,51,77,97,116,69,0,78,50,99,118,53,83,105,122,101,95,73,105,69,69,0,78,50,99,118,55,83,99,97,108,97,114,95,73,100,69,69,0,78,50,99,118,51,86,101,99,73,100,76,105,52,69,69,69,0,78,50,99,118,52,77,97,116,120,73,100,76,105,52,69,76,105,49,69,69,69,0,105,105,105,105,105,105,0,105,105,105,105,105,105,105,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,104,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,99,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,116,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,115,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,105,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,102,69,69,0,78,49,48,101,109,115,99,114,105,112,116,101,110,49,49,109,101,109,111,114,121,95,118,105,101,119,73,100,69,69,0,118,105,105,105,105,100,100,0,118,105,105,105,105,100,0,118,105,105,105,105,105,0,78,50,99,118,53,82,97,110,103,101,69,0,100,105,105,105,0,102,105,105,105,0,102,105,105,105,105,0,102,105,105,105,105,105,0,100,105,105,105,105,105,0,100,105,105,105,105,0,78,50,99,118,49,50,84,101,114,109,67,114,105,116,101,114,105,97,69,0,100,105,105,0,78,50,99,118,53,83,105,122,101,95,73,102,69,69,0,102,105,105,0,78,50,99,118,53,82,101,99,116,95,73,102,69,69,0,78,49,51,98,105,110,100,105,110,103,95,117,116,105,108,115,57,77,105,110,77,97,120,76,111,99,69,0,78,49,51,98,105,110,100,105,110,103,95,117,116,105,108,115,54,67,105,114,99,108,101,69,0,78,50,99,118,55,77,111,109,101,110,116,115,69,0,78,83,116,51,95,95,50,49,50,98,97,115,105,99,95,115,116,114,105,110,103,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,78,83,116,51,95,95,50,50,49,95,95,98,97,115,105,99,95,115,116,114,105,110,103,95,99,111,109,109,111,110,73,76,98,49,69,69,69,0,108,101,110,103,116,104,0,78,50,99,118,54,83,116,114,105,110,103,69,0,118,105,105,105,100,100,105,105,0,118,105,105,105,100,100,105,0,118,105,105,105,100,100,0,118,105,105,105,105,100,100,105,0,118,105,105,105,105,100,100,100,100,105,105,0,118,105,105,105,105,100,100,100,100,105,0,118,105,105,105,105,100,100,100,100,0,118,105,105,105,105,100,100,100,0,118,105,105,105,100,100,105,100,100,100,100,0,118,105,105,105,100,100,105,100,100,100,0,118,105,105,105,100,100,105,100,100,0,118,105,105,105,100,100,105,100,0,118,105,105,105,105,105,100,100,105,0,118,105,105,105,105,105,100,100,0,118,105,105,105,105,105,100,0,118,105,105,105,105,105,105,100,100,105,0,118,105,105,105,105,105,105,100,100,0,118,105,105,105,105,105,105,100,0,118,105,105,105,105,105,105,0,118,105,105,105,105,105,105,105,100,100,105,0,118,105,105,105,105,105,105,105,100,100,0,118,105,105,105,105,105,105,105,100,0,118,105,105,105,105,105,105,105,0,118,105,105,105,100,105,105,105,100,0,118,105,105,100,105,100,100,105,105,0,118,105,105,100,105,100,100,105,0,118,105,105,105,100,105,0,118,105,105,105,105,105,105,105,105,0,118,105,105,105,105,100,105,105,105,105,100,105,0,118,105,105,105,105,105,105,105,105,105,105,105,100,0,118,105,105,105,105,105,105,105,105,105,105,105,0,118,105,105,105,105,105,105,105,105,105,105,0,118,105,105,105,105,105,105,105,105,105,0,105,105,105,105,105,105,105,105,0,118,105,105,105,105,105,100,105,0,118,105,105,105,105,100,105,0,118,105,100,105,105,105,0,118,105,100,105,105,0,118,105,105,105,105,100,100,100,105,105,105,105,0,118,105,105,105,105,100,100,100,105,105,105,0,118,105,105,105,105,100,100,100,105,105,0,118,105,105,105,105,100,100,100,105,0,105,105,105,105,105,105,100,105,0,118,105,105,105,105,105,105,100,105,0,100,105,105,105,105,105,105,105,0,100,105,105,105,105,105,105,0,118,105,105,105,100,105,100,105,105,0,118,105,105,105,100,105,100,105,0,105,105,105,100,100,0,118,105,105,105,105,100,100,105,105,105,100,0,118,105,105,105,105,100,100,105,105,105,0,118,105,105,105,105,100,100,105,105,0,118,105,105,105,105,100,100,105,105,105,105,100,0,118,105,105,105,105,100,100,105,105,105,105,0,100,105,105,105,105,105,105,105,105,0,100,105,105,105,105,100,0,118,105,105,105,100,100,105,105,105,0,118,105,105,100,105,0,118,105,105,105,105,105,100,105,105,105,105,0,118,105,105,105,105,105,100,105,105,105,0,118,105,105,105,105,105,100,105,105,0,118,105,105,105,105,105,105,105,100,105,0,118,105,105,0,100,105,105,105,100,100,105,0,105,105,105,100,105,105,105,105,105,0,105,105,105,100,105,105,105,105,0,105,105,105,100,105,105,105,0,105,105,105,100,105,105,0,105,105,105,100,105,0,105,105,105,100,0,78,50,99,118,51,100,110,110,50,50,101,120,112,101,114,105,109,101,110,116,97,108,95,100,110,110,95,51,52,95,118,55,51,78,101,116,69,0,80,78,50,99,118,49,51,72,79,71,68,101,115,99,114,105,112,116,111,114,69,0,80,75,78,50,99,118,49,51,72,79,71,68,101,115,99,114,105,112,116,111,114,69,0,105,105,105,105,105,105,105,105,100,105,100,105,105,105,0,118,105,105,105,105,105,100,105,105,100,100,105,0,118,105,105,105,105,105,100,105,105,100,100,0,118,105,105,105,105,105,100,105,105,100,0,78,50,99,118,50,48,66,97,99,107,103,114,111,117,110,100,83,117,98,116,114,97,99,116,111,114,69,0,80,78,50,99,118,50,48,66,97,99,107,103,114,111,117,110,100,83,117,98,116,114,97,99,116,111,114,69,0,80,75,78,50,99,118,50,48,66,97,99,107,103,114,111,117,110,100,83,117,98,116,114,97,99,116,111,114,69,0,78,50,99,118,50,52,66,97,99,107,103,114,111,117,110,100,83,117,98,116,114,97,99,116,111,114,77,79,71,50,69,0,80,78,50,99,118,50,52,66,97,99,107,103,114,111,117,110,100,83,117,98,116,114,97,99,116,111,114,77,79,71,50,69,0,80,75,78,50,99,118,50,52,66,97,99,107,103,114,111,117,110,100,83,117,98,116,114,97,99,116,111,114,77,79,71,50,69,0,78,50,99,118,51,80,116,114,73,78,83,95,50,52,66,97,99,107,103,114,111,117,110,100,83,117,98,116,114,97,99,116,111,114,77,79,71,50,69,69,69,0,78,50,99,118,53,67,76,65,72,69,69,0,80,78,50,99,118,53,67,76,65,72,69,69,0,80,75,78,50,99,118,53,67,76,65,72,69,69,0,78,50,99,118,51,80,116,114,73,78,83,95,53,67,76,65,72,69,69,69,69,0,105,105,100,105,0,105,105,100,0,80,78,50,99,118,57,65,108,103,111,114,105,116,104,109,69,0,80,75,78,50,99,118,57,65,108,103,111,114,105,116,104,109,69,0,80,78,50,99,118,51,100,110,110,50,50,101,120,112,101,114,105,109,101,110,116,97,108,95,100,110,110,95,51,52,95,118,55,51,78,101,116,69,0,80,75,78,50,99,118,51,100,110,110,50,50,101,120,112,101,114,105,109,101,110,116,97,108,95,100,110,110,95,51,52,95,118,55,51,78,101,116,69,0,78,50,99,118,49,55,67,97,115,99,97,100,101,67,108,97,115,115,105,102,105,101,114,69,0,80,78,50,99,118,49,55,67,97,115,99,97,100,101,67,108,97,115,115,105,102,105,101,114,69,0,80,75,78,50,99,118,49,55,67,97,115,99,97,100,101,67,108,97,115,115,105,102,105,101,114,69,0,118,105,105,105,105,105,105,100,105,105,105,105,105,0,118,105,105,105,105,105,105,100,105,105,105,105,0,118],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+174081);allocate([105,105,105,105,105,105,100,105,105,105,0,118,105,105,105,105,105,105,100,105,105,0,118,105,105,105,105,100,105,105,105,105,0,118,105,105,105,105,100,105,105,105,0,118,105,105,105,105,100,105,105,0,109,101,97,110,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,101,97,110,46,99,112,112,0,99,118,58,58,83,99,97,108,97,114,32,99,118,58,58,109,101,97,110,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,109,101,97,110,83,116,100,68,101,118,0,95,109,97,115,107,46,101,109,112,116,121,40,41,32,124,124,32,95,109,97,115,107,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,67,49,0,100,115,116,46,116,121,112,101,40,41,32,61,61,32,67,86,95,54,52,70,32,38,38,32,100,115,116,46,105,115,67,111,110,116,105,110,117,111,117,115,40,41,32,38,38,32,40,100,115,116,46,99,111,108,115,32,61,61,32,49,32,124,124,32,100,115,116,46,114,111,119,115,32,61,61,32,49,41,32,38,38,32,100,99,110,32,62,61,32,99,110,0,118,111,105,100,32,99,118,58,58,109,101,97,110,83,116,100,68,101,118,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,70,97,105,108,101,100,32,116,111,32,97,108,108,111,99,97,116,101,32,37,108,108,117,32,98,121,116,101,115,0,79,117,116,79,102,77,101,109,111,114,121,69,114,114,111,114,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,97,108,108,111,99,46,99,112,112,0,95,97,114,114,97,121,115,32,38,38,32,40,95,112,116,114,115,32,124,124,32,95,112,108,97,110,101,115,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,114,105,120,95,105,116,101,114,97,116,111,114,46,99,112,112,0,110,97,114,114,97,121,115,32,60,61,32,49,48,48,48,0,97,114,114,97,121,115,91,105,93,32,33,61,32,48,0,65,46,115,105,122,101,32,61,61,32,97,114,114,97,121,115,91,105,48,93,45,62,115,105,122,101,0,65,46,115,116,101,112,91,100,45,49,93,32,61,61,32,65,46,101,108,101,109,83,105,122,101,40,41,0,102,108,111,97,116,32,99,118,58,58,99,117,98,101,82,111,111,116,40,102,108,111,97,116,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,104,102,117,110,99,115,46,99,112,112,0,115,114,99,49,46,115,105,122,101,40,41,32,61,61,32,115,114,99,50,46,115,105,122,101,40,41,32,38,38,32,116,121,112,101,32,61,61,32,115,114,99,50,46,116,121,112,101,40,41,32,38,38,32,40,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,54,52,70,41,0,118,111,105,100,32,99,118,58,58,109,97,103,110,105,116,117,100,101,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,88,46,115,105,122,101,32,61,61,32,89,46,115,105,122,101,32,38,38,32,116,121,112,101,32,61,61,32,89,46,116,121,112,101,40,41,32,38,38,32,40,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,54,52,70,41,0,99,97,114,116,84,111,80,111,108,97,114,0,118,111,105,100,32,99,118,58,58,99,97,114,116,84,111,80,111,108,97,114,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,98,111,111,108,41,0,40,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,54,52,70,41,32,38,38,32,40,115,114,99,49,46,101,109,112,116,121,40,41,32,124,124,32,115,114,99,49,46,116,121,112,101,40,41,32,61,61,32,116,121,112,101,41,0,112,111,108,97,114,84,111,67,97,114,116,0,77,97,103,46,101,109,112,116,121,40,41,32,124,124,32,65,110,103,108,101,46,115,105,122,101,32,61,61,32,77,97,103,46,115,105,122,101,0,118,111,105,100,32,99,118,58,58,112,111,108,97,114,84,111,67,97,114,116,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,98,111,111,108,41,0,101,120,112,0,118,111,105,100,32,99,118,58,58,101,120,112,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,108,111,103,0,118,111,105,100,32,99,118,58,58,108,111,103,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,112,111,119,40,73,110,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,115,113,114,116,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,112,116,32,61,61,32,78,85,76,76,0,99,104,101,99,107,82,97,110,103,101,0,116,104,101,32,118,97,108,117,101,32,97,116,32,40,37,100,44,32,37,100,41,61,37,115,32,105,115,32,111,117,116,32,111,102,32,114,97,110,103,101,32,91,37,102,44,32,37,102,41,0,98,111,111,108,32,99,118,58,58,99,104,101,99,107,82,97,110,103,101,40,73,110,112,117,116,65,114,114,97,121,44,32,98,111,111,108,44,32,80,111,105,110,116,32,42,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,41,0,95,97,46,100,101,112,116,104,40,41,32,61,61,32,67,86,95,51,50,70,0,112,97,116,99,104,78,97,78,115,0,118,111,105,100,32,99,118,58,58,112,97,116,99,104,78,97,78,115,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,41,0,99,116,121,112,101,32,61,61,32,67,86,95,51,50,70,32,124,124,32,99,116,121,112,101,32,61,61,32,67,86,95,54,52,70,0,115,111,108,118,101,67,117,98,105,99,0,40,99,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,110,48,44,32,49,41,32,124,124,32,99,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,110,48,43,49,44,32,49,41,32,124,124,32,99,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,44,32,110,48,41,32,124,124,32,99,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,44,32,110,48,43,49,41,41,0,105,110,116,32,99,118,58,58,115,111,108,118,101,67,117,98,105,99,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,67,86,95,77,65,84,95,68,69,80,84,72,40,99,116,121,112,101,41,32,62,61,32,67,86,95,51,50,70,32,38,38,32,67,86,95,77,65,84,95,67,78,40,99,116,121,112,101,41,32,60,61,32,50,0,115,111,108,118,101,80,111,108,121,0,99,111,101,102,102,115,48,46,114,111,119,115,32,61,61,32,49,32,124,124,32,99,111,101,102,102,115,48,46,99,111,108,115,32,61,61,32,49,0,100,111,117,98,108,101,32,99,118,58,58,115,111,108,118,101,80,111,108,121,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,108,97,112,97,99,107,46,99,112,112,0,33,109,97,116,46,101,109,112,116,121,40,41,0,100,101,116,101,114,109,105,110,97,110,116,0,109,97,116,46,114,111,119,115,32,61,61,32,109,97,116,46,99,111,108,115,32,38,38,32,40,116,121,112,101,32,61,61,32,67,86,95,51,50,70,32,124,124,32,116,121,112,101,32,61,61,32,67,86,95,54,52,70,41,0,100,111,117,98,108,101,32,99,118,58,58,100,101,116,101,114,109,105,110,97,110,116,40,73,110,112,117,116,65,114,114,97,121,41,0,116,121,112,101,32,61,61,32,67,86,95,51,50,70,32,124,124,32,116,121,112,101,32,61,61,32,67,86,95,54,52,70,0,105,110,118,101,114,116,0,109,32,61,61,32,110,0,109,101,116,104,111,100,32,61,61,32,68,69,67,79,77,80,95,76,85,32,124,124,32,109,101,116,104,111,100,32,61,61,32,68,69,67,79,77,80,95,67,72,79,76,69,83,75,89,0,115,114,99,46,114,111,119,115,32,61,61,32,115,114,99,46,99,111,108,115,0,101,105,103,101,110,0,98,111,111,108,32,99,118,58,58,101,105,103,101,110,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,119,46,116,121,112,101,40,41,32,61,61,32,117,46,116,121,112,101,40,41,32,38,38,32,117,46,116,121,112,101,40,41,32,61,61,32,118,116,46,116,121,112,101,40,41,32,38,38,32,117,46,100,97,116,97,32,38,38,32,118,116,46,100,97,116,97,32,38,38,32,119,46,100,97,116,97,0,98,97,99,107,83,117,98,115,116,0,117,46,99,111,108,115,32,62,61,32,110,109,32,38,38,32,118,116,46,114,111,119,115,32,62,61,32,110,109,32,38,38,32,40,119,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,110,109,44,32,49,41,32,124,124,32,119,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,44,32,110,109,41,32,124,124,32,119,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,118,116,46,114,111,119,115,44,32,117,46,99,111,108,115,41,41,0,114,104,115,46,100,97,116,97,32,61,61,32,48,32,124,124,32,40,114,104,115,46,116,121,112,101,40,41,32,61,61,32,116,121,112,101,32,38,38,32,114,104,115,46,114,111,119,115,32,61,61,32,109,41,0,95,83,86,68,99,111,109,112,117,116,101,0,115,116,97,116,105,99,32,118,111,105,100,32,99,118,58,58,83,86,68,58,58,99,111,109,112,117,116,101,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,100,111,117,98,108,101,32,99,118,58,58,105,110,118,101,114,116,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,116,121,112,101,32,61,61,32,95,115,114,99,50,46,116,121,112,101,40,41,32,38,38,32,40,116,121,112,101,32,61,61,32,67,86,95,51,50,70,32,124,124,32,116,121,112,101,32,61,61,32,67,86,95,54,52,70,41,0,115,111,108,118,101,0,40,109,101,116,104,111,100,32,33,61,32,68,69,67,79,77,80,95,76,85,32,38,38,32,109,101,116,104,111,100,32,33,61,32,68,69,67,79,77,80,95,67,72,79,76,69,83,75,89,41,32,124,124,32,105,115,95,110,111,114,109,97,108,32,124,124,32,115,114,99,46,114,111,119,115,32,61,61,32,115,114,99,46,99,111,108,115,0,84,104,101,32,102,117,110,99,116,105,111,110,32,99,97,110,32,110,111,116,32,115,111,108,118,101,32,117,110,100,101,114,45,100,101,116,101,114,109,105,110,101,100,32,108,105,110,101,97,114,32,115,121,115,116,101,109,115,0,98,111,111,108,32,99,118,58,58,115,111,108,118,101,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,85,110,115,117,112,112,111,114,116,101,100,32,109,101,116,104,111,100,44,32,115,101,101,32,35,68,101,99,111,109,112,84,121,112,101,115,0,109,101,116,104,111,100,0,109,101,116,104,111,100,32,61,61,32,68,69,67,79,77,80,95,76,85,32,124,124,32,109,101,116,104,111,100,32,61,61,32,68,69,67,79,77,80,95,83,86,68,32,124,124,32,109,101,116,104,111,100,32,61,61,32,68,69,67,79,77,80,95,69,73,71,32,124,124,32,109,101,116,104,111,100,32,61,61,32,68,69,67,79,77,80,95,67,72,79,76,69,83,75,89,32,124,124,32,109,101,116,104,111,100,32,61,61,32,68,69,67,79,77,80,95,81,82,0,78,50,99,118,57,69,120,99,101,112,116,105,111,110,69,0,107,101,121,95,32,61,61,32,45,49,0,126,84,76,83,68,97,116,97,67,111,110,116,97,105,110,101,114,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,115,121,115,116,101,109,46,99,112,112,0,115,116,97,116,117,115,0,85,110,107,110,111,119,110,32,37,115,32,99,111,100,101,32,37,100,0,79,112,101,110,71,76,32,65,80,73,32,99,97,108,108,0,78,111,32,79,112,101,110,71,76,32,115,117,112,112,111,114,116,0,71,112,117,32,65,80,73,32,99,97,108,108,0,78,111,32,67,85,68,65,32,115,117,112,112,111,114,116,0,65,115,115,101,114,116,105,111,110,32,102,97,105,108,101,100,0,77,101,109,111,114,121,32,98,108,111,99,107,32,104,97,115,32,98,101,101,110,32,99,111,114,114,117,112,116,101,100,0,84,104,101,32,102,117,110,99,116,105,111,110,47,102,101,97,116,117,114,101,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,80,97,114,115,105,110,103,32,101,114,114,111,114,0,66,97,100,32,116,121,112,101,32,111,102,32,109,97,115,107,32,97,114,103,117,109,101,110,116,0,66,97,100,32,112,97,114,97,109,101,116,101,114,32,111,102,32,116,121,112,101,32,67,118,80,111,105,110,116,0,66,97,100,32,102,108,97,103,32,40,112,97,114,97,109,101,116,101,114,32,111,114,32,115,116,114,117,99,116,117,114,101,32,102,105,101,108,100,41,0,66,97,100,32,110,117,109,98,101,114,32,111,102,32,99,104,97,110,110,101,108,115,0,73,110,112,117,116,32,67,79,73,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,85,110,115,117,112,112,111,114,116,101,100,32,102,111,114,109,97,116,32,111,114,32,99,111,109,98,105,110,97,116,105,111,110,32,111,102,32,102,111,114,109,97,116,115,0,79,110,101,32,111,102,32,97,114,103,117,109,101,110,116,115,39,32,118,97,108,117,101,115,32,105,115,32,111,117,116,32,111,102,32,114,97,110,103,101,0,83,105,122,101,115,32,111,102,32,105,110,112,117,116,32,97,114,103,117,109,101,110,116,115,32,100,111,32,110,111,116,32,109,97,116,99,104,0,70,111,114,109,97,116,115,32,111,102,32,105,110,112,117,116,32,97,114,103,117,109,101,110,116,115,32,100,111,32,110,111,116,32,109,97,116,99,104,0,73,110,112,117,116,32,105,109,97,103,101,32,100,101,112,116,104,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,102,117,110,99,116,105,111,110,0,82,101,113,117,101,115,116,101,100,32,111,98,106,101,99,116,32,119,97,115,32,110,111,116,32,102,111,117,110,100,0,73,110,112,108,97,99,101,32,111,112,101,114,97,116,105,111,110,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,73,109,97,103,101,32,115,116,101,112,32,105,115,32,119,114,111,110,103,0,68,105,118,105,115,105,111,110,32,98,121,32,122,101,114,111,32,111,99,99,117,114,114,101,100,0,78,117,108,108,32,112,111,105,110,116,101,114,0,73,110,99,111,114,114,101,99,116,32,115,105,122,101,32,111,102,32,105,110,112,117,116,32,97,114,114,97,121,0,65,117,116,111,116,114,97,99,101,32,99,97,108,108,0,73,116,101,114,97,116,105,111,110,115,32,100,111,32,110,111,116,32,99,111,110,118,101,114,103,101,0,66,97,100,32,97,114,103,117,109,101,110,116,0,73,110,115,117,102,102,105,99,105,101,110,116,32,109,101,109,111,114,121,0,85,110,115,112,101,99,105,102,105,101,100,32,101,114,114,111,114,0,66,97,99,107,116,114,97,99,101,0,78,111,32,69,114,114,111,114,0,117,110,107,110,111,119,110,32,102,117,110,99,116,105,111,110,0,79,112,101,110,67,86,40,37,115,41,32,69,114,114,111,114,58,32,37,115,32,40,37,115,41,32,105,110,32,37,115,44,32,102,105,108,101,32,37,115,44,32,108,105,110,101,32,37,100,0,51,46,52,46,51,0,37,115,10,0,62,32,0,79,112,101,110,67,86,40,37,115,41,32,37,115,58,37,100,58,32,101,114,114,111,114,58,32,40,37,100,58,37,115,41,32,105,110,32,102,117,110,99,116,105,111,110,32,39,37,115,39,10,37,115,0,79,112,101,110,67,86,40,37,115,41,32,37,115,58,37,100,58,32,101,114,114,111,114,58,32,40,37,100,58,37,115,41,32,37,115,32,105,110,32,102,117,110,99,116,105,111,110,32,39,37,115,39,10,0,79,112,101,110,67,86,40,37,115,41,32,37,115,58,37,100,58,32,101,114,114,111,114,58,32,40,37,100,58,37,115,41,32,37,115,37,115,0,108,101,110,32,62,61,32,48,32,38,38,32,34,67,104,101,99,107,32,102,111,114,109,97,116,32,115,116,114,105,110,103,32,102,111,114,32,101,114,114,111,114,115,34,0,78,83,116,51,95,95,50,49,53,98,97,115,105,99,95,115,116,114,105,110,103,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,78,83,116,51,95,95,50,49,56,98,97,115,105,99,95,115,116,114,105,110,103,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,78,50,99,118,49,54,84,76,83,68,97,116,97,67,111,110,116,97,105,110,101,114,69,0,79,80,69,78,67,86,95,68,85,77,80,95,69,82,82,79,82,83,0,79,80,69,78,67,86,95,68,85,77,80,95,67,79,78,70,73,71,0,10,71,101,110,101,114,97,108,32,99,111,110,102,105,103,117,114,97,116,105,111,110,32,102,111,114,32,79,112,101,110,67,86,32,51,46,52,46,51,32,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,10,32,32,86,101,114,115,105,111,110,32,99,111,110,116,114,111,108,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,51,46,52,46,51,10,10,32,32,80,108,97,116,102,111,114,109,58,10,32,32,32,32,84,105,109,101,115,116,97,109,112,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,50,48,49,56,45,48,56,45,50,57,84,49,48,58,50,55,58,53,53,90,10,32,32,32,32,72,111,115,116,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,76,105,110,117,120,32,52,46,49,53,46,48,45,51,51,45,103,101,110,101,114,105,99,32,120,56,54,95,54,52,10,32,32,32,32,84,97,114,103,101,116,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,69,109,115,99,114,105,112,116,101,110,32,49,32,120,56,54,10,32,32,32,32,67,77,97,107,101,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,51,46,53,46,49,10,32,32,32,32,67,77,97,107,101,32,103,101,110,101,114,97,116,111,114,58,32,32,32,32,32,32,32,32,32,32,32,32,32,85,110,105,120,32,77,97,107,101,102,105,108,101,115,10,32,32,32,32,67,77,97,107,101,32,98,117,105,108,100,32,116,111,111,108,58,32,32,32,32,32,32,32,32,32,32,32,32,47,117,115,114,47,98,105,110,47,109,97,107,101,10,32,32,32,32,67,111,110,102,105,103,117,114,97,116,105,111,110,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,82,101,108,101,97,115,101,10,10,32,32,67,80,85,47,72,87,32,102,101,97,116,117,114,101,115,58,10,32,32,32,32,66,97,115,101,108,105,110,101,58,10,10,32,32,67,47,67,43,43,58,10,32,32,32,32,66,117,105,108,116,32,97,115,32,100,121,110,97,109,105,99,32,108,105,98,115,63,58,32,32,32,32,32,32,78,79,10,32,32,32,32,67,43,43,32,67,111,109,112,105,108,101,114,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,47,111,112,116,47,101,109,115,100,107,45,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,49,46,51,55,46,50,49,47,101,109,43,43,32,32,40,118,101,114,32,52,46,48,46,48,41,10,32,32,32,32,67,43,43,32,102,108,97,103,115,32,40,82,101,108,101,97,115,101,41,58,32,32,32,32,32,32,32,32,32,45,102,115,105,103,110,101,100,45,99,104,97,114,32,45,87,32,45,87,97,108,108,32,45,87,101,114,114,111,114,61,114,101,116,117,114,110,45,116,121,112,101,32,45,87,101,114,114,111,114,61,110,111,110,45,118,105,114,116,117,97,108,45,100,116,111,114,32,45,87,101,114,114,111,114,61,97,100,100,114,101,115,115,32,45,87,101,114,114,111,114,61,115,101,113,117,101,110,99,101,45,112,111,105,110,116,32,45,87,102,111,114,109,97,116,32,45,87,101,114,114,111,114,61,102,111,114,109,97,116,45,115,101,99,117,114,105,116,121,32,45,87,109,105,115,115,105,110,103,45,100,101,99,108,97,114,97,116,105,111,110,115,32,45,87,109,105,115,115,105,110,103,45,112,114,111,116,111,116,121,112,101,115,32,45,87,115,116,114,105,99,116,45,112,114,111,116,111,116,121,112,101,115,32,45,87,117,110,100,101,102,32,45,87,105,110,105,116,45,115,101,108,102,32,45,87,112,111,105,110,116,101,114,45,97,114,105,116,104,32,45,87,115,104,97,100,111,119,32,45,87,115,105,103,110,45,112,114,111,109,111,32,45,87,117,110,105,110,105,116,105,97,108,105,122,101,100,32,45,87,105,110,105,116,45,115,101,108,102,32,45,87,110,111,45,110,97,114,114,111,119,105,110,103,32,45,87,110,111,45,100,101,108,101,116,101,45,110,111,110,45,118,105,114,116,117,97,108,45,100,116,111,114,32,45,87,110,111,45,117,110,110,97,109,101,100,45,116,121,112,101,45,116,101,109,112,108,97,116,101,45,97,114,103,115,32,45,87,110,111,45,99,111,109,109,101,110,116,32,45,102,100,105,97,103,110,111,115,116,105,99,115,45,115,104,111,119,45,111,112,116,105,111,110,32,45,112,116,104,114,101,97,100,32,45,81,117,110,117,115,101,100,45,97,114,103,117,109,101,110,116,115,32,45,102,102,117,110,99,116,105,111,110,45,115,101,99,116,105,111,110,115,32,45,102,100,97,116,97,45,115,101,99,116,105,111,110,115,32,32,45,102,118,105,115,105,98,105,108,105,116,121,61,104,105,100,100,101,110,32,45,102,118,105,115,105,98,105,108,105,116,121,45,105,110,108,105,110,101,115,45,104,105,100,100,101,110,32,45,68,78,68,69,66,85,71,32,45,79,50,32,32,45,68,78,68,69,66,85,71,10,32,32,32,32,67,43,43,32,102,108,97,103,115,32,40,68,101,98,117,103,41,58,32,32,32,32,32,32,32,32,32,32,32,45,102,115,105,103,110,101,100,45,99,104,97,114,32,45,87,32,45,87,97,108,108,32,45,87,101,114,114,111,114,61,114,101,116,117,114,110,45,116,121,112,101,32,45,87,101,114,114,111,114,61,110,111,110,45,118,105,114,116,117,97,108,45,100,116,111,114,32,45,87,101,114,114,111,114,61,97,100,100,114,101,115,115,32,45,87,101,114,114,111,114,61,115,101,113,117,101,110,99,101,45,112,111,105,110,116,32,45,87,102,111,114,109,97,116,32,45,87,101,114,114,111,114,61,102,111,114,109,97,116,45,115,101,99,117,114,105,116,121,32,45,87,109,105,115,115,105,110,103,45,100,101,99,108,97,114,97,116,105,111,110,115,32,45,87,109,105,115,115,105,110,103,45,112,114,111,116,111,116,121,112,101,115,32,45,87,115,116,114,105,99,116,45,112,114,111,116,111,116,121,112,101,115,32,45,87,117,110,100,101,102,32,45,87,105,110,105,116,45,115,101,108,102,32,45,87,112,111,105,110,116,101,114,45,97,114,105,116,104,32,45,87,115,104,97,100,111,119,32,45,87,115,105,103,110,45,112,114,111,109,111,32,45,87,117,110,105,110,105,116,105,97,108,105,122,101,100,32,45,87,105,110,105,116,45,115,101,108,102,32,45,87,110,111,45,110,97,114,114,111,119,105,110,103,32,45,87,110,111,45,100,101,108,101,116,101,45,110,111,110,45,118,105,114,116,117,97,108,45,100,116,111,114,32,45,87,110,111,45,117,110,110,97,109,101,100,45,116,121,112,101,45,116,101,109,112,108,97,116,101,45,97,114,103,115,32,45,87,110,111,45,99,111,109,109,101,110,116,32,45,102,100,105,97,103,110,111,115,116,105,99,115,45,115,104,111,119,45,111,112,116,105,111,110,32,45,112,116,104,114,101,97,100,32,45,81,117,110,117,115,101,100,45,97,114,103,117,109,101,110,116,115,32,45,102,102,117,110,99,116,105,111,110,45,115,101,99,116,105,111,110,115,32,45,102,100,97,116,97,45,115,101,99,116,105,111,110,115,32,32,45,102,118,105,115,105,98,105,108,105,116,121,61,104,105,100,100,101,110,32,45,102,118,105,115,105,98,105,108,105,116,121,45,105,110,108,105,110,101,115,45,104,105,100,100,101,110,32,45,103,32,32,45,79,48,32,45,68,68,69,66,85,71,32,45,68,95,68,69,66,85,71,10,32,32,32,32,67,32,67,111,109,112,105,108,101,114,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,47,111,112,116,47,101,109,115,100,107,45,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,49,46,51,55,46,50,49,47,101,109,99,99,10,32,32,32,32,67,32,102,108,97,103,115,32,40,82,101,108,101,97,115,101,41,58,32,32,32,32,32,32,32,32,32,32,32,45,102,115,105,103,110,101,100,45,99,104,97,114,32,45,87,32,45,87,97,108,108,32,45,87,101,114,114,111,114,61,114,101,116,117,114,110,45,116,121,112,101,32,45,87,101,114,114,111,114,61,110,111,110,45,118,105,114,116,117,97,108,45,100,116,111,114,32,45,87,101,114,114,111,114,61,97,100,100,114,101,115,115,32,45,87,101,114,114,111,114,61,115,101,113,117,101,110,99,101,45,112,111,105,110,116,32,45,87,102,111,114,109,97,116,32,45,87,101,114,114,111,114,61,102,111,114,109,97,116,45,115,101,99,117,114,105,116,121,32,45,87,109,105,115,115,105,110,103,45,100,101,99,108,97,114,97,116,105,111,110,115,32,45,87,109,105,115,115,105,110,103,45,112,114,111,116,111,116,121,112,101,115,32,45,87,115,116,114,105,99,116,45,112,114,111,116,111,116,121,112,101,115,32,45,87,117,110,100,101,102,32,45,87,105,110,105,116,45,115,101,108,102,32,45,87,112,111,105,110,116,101,114,45,97,114,105,116,104,32,45,87,115,104,97,100,111,119,32,45,87,115,105,103,110,45,112,114,111,109,111,32,45,87,117,110,105,110,105,116,105,97,108,105,122,101,100,32,45,87,105,110,105,116,45,115,101,108,102,32,45,87,110,111,45,110,97,114,114,111,119,105,110,103,32,45,87,110,111,45,100,101,108,101,116,101,45,110,111,110,45,118,105,114,116,117,97,108,45,100,116,111,114,32,45,87,110,111,45,117,110,110,97,109,101,100,45,116,121,112,101,45,116,101,109,112,108,97,116,101,45,97,114,103,115,32,45,87,110,111,45,99,111,109,109,101,110,116,32,45,102,100,105,97,103,110,111,115,116,105,99,115,45,115,104,111,119,45,111,112,116,105,111,110,32,45,112,116,104,114,101,97,100,32,45,81,117,110,117,115,101,100,45,97,114,103,117,109,101,110,116,115,32,45,102,102,117,110,99,116,105,111,110,45,115,101,99,116,105,111,110,115,32,45,102,100,97,116,97,45,115,101,99,116,105,111,110,115,32,32,45,102,118,105,115,105,98,105,108,105,116,121,61,104,105,100,100,101,110,32,45,102,118,105,115,105,98,105,108,105,116,121,45,105,110,108,105,110,101,115,45,104,105,100,100,101,110,32,45,68,78,68,69,66,85,71,32,45,79,50,32,32,45,68,78,68,69,66,85,71,10,32,32,32,32,67,32,102,108,97,103,115,32,40,68,101,98,117,103,41,58,32,32,32,32,32,32,32,32,32,32,32,32,32,45,102,115,105,103,110,101,100,45,99,104,97,114,32,45,87,32,45,87,97,108,108,32,45,87,101,114,114,111,114,61,114,101,116,117,114,110,45,116,121,112,101,32,45,87,101,114,114,111,114,61,110,111,110,45,118,105,114,116,117,97,108,45,100,116,111,114,32,45,87,101,114,114,111,114,61,97,100,100,114,101,115,115,32,45,87,101,114,114,111,114,61,115,101,113,117,101,110,99,101,45,112,111,105,110,116,32,45,87,102,111,114,109,97,116,32,45,87,101,114,114,111,114,61,102,111,114,109,97,116,45,115,101,99,117,114,105,116,121,32,45,87,109,105,115,115,105,110,103,45,100,101,99,108,97,114,97,116,105,111,110,115,32,45,87,109,105,115,115,105,110,103,45,112,114,111,116,111,116,121,112,101,115,32,45,87,115,116,114,105,99,116,45,112,114,111,116,111,116,121,112,101,115,32,45,87,117,110,100,101,102,32,45,87,105,110,105,116,45,115,101,108,102,32,45,87,112,111,105,110,116,101,114,45,97,114,105,116,104,32,45,87,115,104,97,100,111,119,32,45,87,115,105,103,110,45,112,114,111,109,111,32,45,87,117,110,105,110,105,116,105,97,108,105,122,101,100,32,45,87,105,110,105,116,45,115,101,108,102,32,45,87,110,111,45,110,97,114,114,111,119,105,110,103,32,45,87,110,111,45,100,101,108,101,116,101,45,110,111,110,45,118,105,114,116,117,97,108,45,100,116,111,114,32,45,87,110,111,45,117,110,110,97,109,101,100,45,116,121,112,101,45,116,101,109,112,108,97,116,101,45,97,114,103,115,32,45,87,110,111,45,99,111,109,109,101,110,116,32,45,102,100,105,97,103,110,111,115,116,105,99,115,45,115,104,111,119,45,111,112,116,105,111,110,32,45,112,116,104,114,101,97,100,32,45,81,117,110,117,115,101,100,45,97,114,103,117,109,101,110,116,115,32,45,102,102,117,110,99,116,105,111,110,45,115,101,99,116,105,111,110,115,32,45,102,100,97,116,97,45,115,101,99,116,105,111,110,115,32,32,45,102,118,105,115,105,98,105,108,105,116,121,61,104,105,100,100,101,110,32,45,102,118,105,115,105,98,105,108,105,116,121,45,105,110,108,105,110,101,115,45,104,105,100,100,101,110,32,45,103,32,32,45,79,48,32,45,68,68,69,66,85,71,32,45,68,95,68,69,66,85,71,10,32,32,32,32,76,105,110,107,101,114,32,102,108,97,103,115,32,40,82,101,108,101,97,115,101,41,58,32,32,32,32,32,32,45,79,50,32,10,32,32,32,32,76,105,110,107,101,114,32,102,108,97,103,115,32,40,68,101,98,117,103,41,58,32,32,32,32,32,32,32,32,10,32,32,32,32,99,99,97,99,104,101,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,78,79,10,32,32,32,32,80,114,101,99,111,109,112,105,108,101,100,32,104,101,97,100,101,114,115,58,32,32,32,32,32,32,32,32,32,78,79,10,32,32,32,32,69,120,116,114,97,32,100,101,112,101,110,100,101,110,99,105,101,115,58,10,32,32,32,32,51,114,100,112,97,114,116,121,32,100,101,112,101,110,100,101,110,99,105,101,115,58,32,32,32,32,32,32,32,122,108,105,98,32,108,105,98,112,114,111,116,111,98,117,102,10,10,32,32,79,112,101,110,67,86,32,109,111,100,117,108,101,115,58,10,32,32,32,32,84,111,32,98,101,32,98,117,105,108,116,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,99,111,114,101,32,100,110,110,32,105,109,103,112,114,111,99,32,106,97,118,97,95,98,105,110,100,105,110,103,115,95,103,101,110,101,114,97,116,111,114,32,106,115,32,111,98,106,100,101,116,101,99,116,32,112,121,116,104,111,110,95,98,105,110,100,105,110,103,115,95,103,101,110,101,114,97,116,111,114,32,118,105,100,101,111,10,32,32,32,32,68,105,115,97,98,108,101,100,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,99,97,108,105,98,51,100,32,102,101,97,116,117,114,101,115,50,100,32,102,108,97,110,110,32,104,105,103,104,103,117,105,32,105,109,103,99,111,100,101,99,115,32,109,108,32,112,104,111,116,111,32,115,104,97,112,101,32,115,116,105,116,99,104,105,110,103,32,115,117,112,101,114,114,101,115,32,118,105,100,101,111,105,111,32,118,105,100,101,111,115,116,97,98,32,119,111,114,108,100,10,32,32,32,32,68,105,115,97,98,108,101,100,32,98,121,32,100,101,112,101,110,100,101,110,99,121,58,32,32,32,32,32,32,45,10,32,32,32,32,85,110,97,118,97,105,108,97,98,108,101,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,99,117,100,97,97,114,105,116,104,109,32,99,117,100,97,98,103,115,101,103,109,32,99,117,100,97,99,111,100,101,99,32,99,117,100,97,102,101,97,116,117,114,101,115,50,100,32,99,117,100,97,102,105,108,116,101,114,115,32,99,117,100,97,105,109,103,112,114,111,99,32,99,117,100,97,108,101,103,97,99,121,32,99,117,100,97,111,98,106,100,101,116,101,99,116,32,99,117,100,97,111,112,116,102,108,111,119,32,99,117,100,97,115,116,101,114,101,111,32,99,117,100,97,119,97,114,112,105,110,103,32,99,117,100,101,118,32,106,97,118,97,32,112,121,116,104,111,110,50,32,112,121,116,104,111,110,51,32,116,115,32,118,105,122,10,32,32,32,32,65,112,112,108,105,99,97,116,105,111,110,115,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,45,10,32,32,32,32,68,111,99,117,109,101,110,116,97,116,105,111,110,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,106,115,10,32,32,32,32,78,111,110,45,102,114,101,101,32,97,108,103,111,114,105,116,104,109,115,58,32,32,32,32,32,32,32,32,32,78,79,10,10,32,32,71,85,73,58,32,10,10,32,32,77,101,100,105,97,32,73,47,79,58,32,10,32,32,32,32,90,76,105,98,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,98,117,105,108,100,32,40,118,101,114,32,49,46,50,46,49,49,41,10,32,32,32,32,72,68,82,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,89,69,83,10,32,32,32,32,83,85,78,82,65,83,84,69,82,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,89,69,83,10,32,32,32,32,80,88,77,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,89,69,83,10,10,32,32,86,105,100,101,111,32,73,47,79,58,10,10,32,32,80,97,114,97,108,108,101,108,32,102,114,97,109,101,119,111,114,107,58,32,32,32,32,32,32,32,32,32,32,32,32,110,111,110,101,10,10,32,32,79,116,104,101,114,32,116,104,105,114,100,45,112,97,114,116,121,32,108,105,98,114,97,114,105,101,115,58,10,32,32,32,32,67,117,115,116,111,109,32,72,65,76,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,78,79,10,32,32,32,32,80,114,111,116,111,98,117,102,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,98,117,105,108,100,32,40,51,46,53,46,49,41,10,10,32,32,80,121,116,104,111,110,32,40,102,111,114,32,98,117,105,108,100,41,58,32,32,32,32,32,32,32,32,32,32,32,32,47,117,115,114,47,98,105,110,47,112,121,116,104,111,110,50,46,55,10,10,32,32,73,110,115,116,97,108,108,32,116,111,58,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,98,117,105,108,100,47,106,115,47,105,110,115,116,97,108,108,10,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,10,10,0,10,79,112,101,110,67,86,32,98,117,105,108,100,32,99,111,110,102,105,103,117,114,97,116,105,111,110,32,105,115,58,10,37,115,10,0,77,77,88,0,83,83,69,0,83,83,69,50,0,83,83,69,51,0,83,83,83,69,51,0,83,83,69,52,46,49,0,83,83,69,52,46,50,0,80,79,80,67,78,84,0,70,80,49,54,0,65,86,88,0,65,86,88,50,0,70,77,65,51,0,65,86,88,53,49,50,70,0,65,86,88,53,49,50,66,87,0,65,86,88,53,49,50,67,68,0,65,86,88,53,49,50,68,81,0,65,86,88,53,49,50,69,82,0,65,86,88,53,49,50,73,70,77,65,0,65,86,88,53,49,50,80,70,0,65,86,88,53,49,50,86,66,77,73,0,65,86,88,53,49,50,86,76,0,78,69,79,78,0,86,83,88,0,65,86,88,53,49,50,45,83,75,88,0,79,80,69,78,67,86,95,67,80,85,95,68,73,83,65,66,76,69,0,102,101,97,116,117,114,101,46,115,105,122,101,40,41,32,62,32,48,0,114,101,97,100,83,101,116,116,105,110,103,115,0,79,80,69,78,67,86,58,32,84,114,121,105,110,103,32,116,111,32,100,105,115,97,98,108,101,32,98,97,115,101,108,105,110,101,32,67,80,85,32,102,101,97,116,117,114,101,58,32,39,37,115,39,46,32,84,104,105,115,32,104,97,115,32,118,101,114,121,32,108,105,109,105,116,101,100,32,101,102,102,101,99,116,44,32,98,101,99,97,117,115,101,32,99,111,100,101,32,111,112,116,105,109,105,122,97,116,105,111,110,115,32,102,111,114,32,116,104,105,115,32,102,101,97,116,117,114,101,32,97,114,101,32,101,120,101,99,117,116,101,100,32,117,110,99,111,110,100,105,116,105,111,110,97,108,108,121,32,105,110,32,116,104,101,32,109,111,115,116,32,99,97,115,101,115,46,10,0,85,110,107,110,111,119,110,32,102,101,97,116,117,114,101,0,79,80,69,78,67,86,58,32,84,114,121,105,110,103,32,116,111,32,100,105,115,97,98,108,101,32,117,110,97,118,97,105,108,97,98,108,101,32,67,80,85,32,102,101,97,116,117,114,101,32,111,110,32,116,104,101,32,99,117,114,114,101,110,116,32,112,108,97,116,102,111,114,109,58,32,39,37,115,39,46,10,0,79,80,69,78,67,86,58,32,84,114,121,105,110,103,32,116,111,32,100,105,115,97,98,108,101,32,117,110,107,110,111,119,110,32,67,80,85,32,102,101,97,116,117,114,101,58,32,39,37,115,39,46,10,0,49,0,84,82,85,69,0,73,110,118,97,108,105,100,32,118,97,108,117,101,32,102,111,114,32,37,115,32,112,97,114,97,109,101,116,101,114,58,32,37,115,0,103,101,116,67,111,110,102,105,103,117,114,97,116,105,111,110,80,97,114,97,109,101,116,101,114,66,111,111,108,0,107,101,121,95,32,33,61,32,45,49,32,38,38,32,34,67,97,110,39,116,32,102,101,116,99,104,32,100,97,116,97,32,102,114,111,109,32,116,101,114,109,105,110,97,116,101,100,32,84,76,83,32,99,111,110,116,97,105,110,101,114,46,34,0,103,101,116,68,97,116,97,0,116,108,115,83,108,111,116,115,83,105,122,101,32,62,32,115,108,111,116,73,100,120,0,115,101,116,68,97,116,97,0,112,116,104,114,101,97,100,95,115,101,116,115,112,101,99,105,102,105,99,40,116,108,115,75,101,121,44,32,112,68,97,116,97,41,32,61,61,32,48,0,83,101,116,68,97,116,97,0,112,116,104,114,101,97,100,95,107,101,121,95,99,114,101,97,116,101,40,38,116,108,115,75,101,121,44,32,78,85,76,76,41,32,61,61,32,48,0,84,108,115,65,98,115,116,114,97,99,116,105,111,110,0,116,108,115,83,108,111,116,115,83,105,122,101,32,61,61,32,116,108,115,83,108,111,116,115,46,115,105,122,101,40,41,0,114,101,108,101,97,115,101,83,108,111,116,0,78,50,99,118,55,84,76,83,68,97,116,97,73,78,83,95,49,49,67,111,114,101,84,76,83,68,97,116,97,69,69,69,0,114,101,115,101,114,118,101,83,108,111,116,0,78,50,99,118,55,84,76,83,68,97,116,97,73,78,83,95,49,50,95,71,76,79,66,65,76,95,95,78,95,49,56,84,104,114,101,97,100,73,68,69,69,69,0,77,66,0,77,98,0,109,98,0,75,66,0,75,98,0,107,98,0,103,101,116,67,111,110,102,105,103,117,114,97,116,105,111,110,80,97,114,97,109,101,116,101,114,83,105,122,101,84,0,109,118,32,38,38,32,110,32,62,32,48,0,109,101,114,103,101,0,109,118,91,105,93,46,115,105,122,101,32,61,61,32,109,118,91,48,93,46,115,105,122,101,32,38,38,32,109,118,91,105,93,46,100,101,112,116,104,40,41,32,61,61,32,100,101,112,116,104,0,48,32,60,32,99,110,32,38,38,32,99,110,32,60,61,32,67,86,95,67,78,95,77,65,88,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+184321);allocate([109,101,114,103,101,46,99,112,112,0,118,111,105,100,32,99,118,58,58,109,101,114,103,101,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,42,44,32,115,105,122,101,95,116,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,109,101,114,103,101,40,73,110,112,117,116,65,114,114,97,121,79,102,65,114,114,97,121,115,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,1,1,1,1,2,2,2,1,2,2,2,1,2,2,2,1,2,2,2,2,3,3,3,2,3,3,3,2,3,3,3,1,2,2,2,2,3,3,3,2,3,3,3,2,3,3,3,1,2,2,2,2,3,3,3,2,3,3,3,2,3,3,3,1,2,2,2,2,3,3,3,2,3,3,3,2,3,3,3,2,3,3,3,3,4,4,4,3,4,4,4,3,4,4,4,2,3,3,3,3,4,4,4,3,4,4,4,3,4,4,4,2,3,3,3,3,4,4,4,3,4,4,4,3,4,4,4,1,2,2,2,2,3,3,3,2,3,3,3,2,3,3,3,2,3,3,3,3,4,4,4,3,4,4,4,3,4,4,4,2,3,3,3,3,4,4,4,3,4,4,4,3,4,4,4,2,3,3,3,3,4,4,4,3,4,4,4,3,4,4,4,1,2,2,2,2,3,3,3,2,3,3,3,2,3,3,3,2,3,3,3,3,4,4,4,3,4,4,4,3,4,4,4,2,3,3,3,3,4,4,4,3,4,4,4,3,4,4,4,2,3,3,3,3,4,4,4,3,4,4,4,3,4,4,4,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,73,78,70,32,124,124,32,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,76,49,32,124,124,32,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,76,50,32,124,124,32,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,76,50,83,81,82,32,124,124,32,40,40,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,72,65,77,77,73,78,71,32,124,124,32,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,72,65,77,77,73,78,71,50,41,32,38,38,32,95,115,114,99,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,41,0,110,111,114,109,0,109,97,115,107,46,101,109,112,116,121,40,41,32,124,124,32,109,97,115,107,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,110,111,114,109,46,99,112,112,0,100,111,117,98,108,101,32,99,118,58,58,110,111,114,109,40,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,73,110,112,117,116,65,114,114,97,121,41,0,95,115,114,99,49,46,115,97,109,101,83,105,122,101,40,95,115,114,99,50,41,32,38,38,32,95,115,114,99,49,46,116,121,112,101,40,41,32,61,61,32,95,115,114,99,50,46,116,121,112,101,40,41,0,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,73,78,70,32,124,124,32,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,76,49,32,124,124,32,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,76,50,32,124,124,32,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,76,50,83,81,82,32,124,124,32,40,40,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,72,65,77,77,73,78,71,32,124,124,32,110,111,114,109,84,121,112,101,32,61,61,32,78,79,82,77,95,72,65,77,77,73,78,71,50,41,32,38,38,32,115,114,99,49,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,41,0,100,111,117,98,108,101,32,99,118,58,58,110,111,114,109,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,73,110,112,117,116,65,114,114,97,121,41,0,99,111,117,110,116,78,111,110,90,101,114,111,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,99,111,117,110,116,95,110,111,110,95,122,101,114,111,46,99,112,112,0,105,110,116,32,99,118,58,58,99,111,117,110,116,78,111,110,90,101,114,111,40,73,110,112,117,116,65,114,114,97,121,41,0,109,121,95,111,98,106,101,99,116,0,118,105,114,116,117,97,108,32,99,118,58,58,83,116,114,105,110,103,32,99,118,58,58,65,108,103,111,114,105,116,104,109,58,58,103,101,116,68,101,102,97,117,108,116,78,97,109,101,40,41,32,99,111,110,115,116,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,97,108,103,111,114,105,116,104,109,46,99,112,112,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,65,108,103,111,114,105,116,104,109,58,58,115,97,118,101,40,99,111,110,115,116,32,99,118,58,58,83,116,114,105,110,103,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,99,118,58,58,65,108,103,111,114,105,116,104,109,58,58,126,65,108,103,111,114,105,116,104,109,40,41,0,78,50,99,118,57,65,108,103,111,114,105,116,104,109,69,0,99,118,58,58,65,108,103,111,114,105,116,104,109,58,58,65,108,103,111,114,105,116,104,109,40,41,0,102,111,114,109,97,116,0,118,111,105,100,32,99,118,58,58,65,108,103,111,114,105,116,104,109,58,58,119,114,105,116,101,70,111,114,109,97,116,40,99,118,58,58,70,105,108,101,83,116,111,114,97,103,101,32,38,41,32,99,111,110,115,116,0,105,110,116,32,99,118,58,58,104,97,108,58,58,76,85,51,50,102,40,102,108,111,97,116,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,44,32,102,108,111,97,116,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,114,105,120,95,100,101,99,111,109,112,46,99,112,112,0,105,110,116,32,99,118,58,58,104,97,108,58,58,76,85,54,52,102,40,100,111,117,98,108,101,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,44,32,100,111,117,98,108,101,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,41,0,98,111,111,108,32,99,118,58,58,104,97,108,58,58,67,104,111,108,101,115,107,121,51,50,102,40,102,108,111,97,116,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,44,32,102,108,111,97,116,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,41,0,98,111,111,108,32,99,118,58,58,104,97,108,58,58,67,104,111,108,101,115,107,121,54,52,102,40,100,111,117,98,108,101,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,44,32,100,111,117,98,108,101,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,41,0,105,110,116,32,99,118,58,58,104,97,108,58,58,81,82,51,50,102,40,102,108,111,97,116,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,102,108,111,97,116,32,42,44,32,115,105,122,101,95,116,44,32,102,108,111,97,116,32,42,41,0,105,110,116,32,99,118,58,58,104,97,108,58,58,81,82,54,52,102,40,100,111,117,98,108,101,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,100,111,117,98,108,101,32,42,44,32,115,105,122,101,95,116,44,32,100,111,117,98,108,101,32,42,41,0,40,99,110,32,61,61,32,49,32,38,38,32,40,95,109,97,115,107,46,101,109,112,116,121,40,41,32,124,124,32,95,109,97,115,107,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,41,41,32,124,124,32,40,99,110,32,62,32,49,32,38,38,32,95,109,97,115,107,46,101,109,112,116,121,40,41,32,38,38,32,33,109,105,110,73,100,120,32,38,38,32,33,109,97,120,73,100,120,41,0,109,105,110,77,97,120,73,100,120,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,105,110,109,97,120,46,99,112,112,0,118,111,105,100,32,99,118,58,58,109,105,110,77,97,120,73,100,120,40,73,110,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,32,42,44,32,105,110,116,32,42,44,32,73,110,112,117,116,65,114,114,97,121,41,0,95,105,109,103,46,100,105,109,115,40,41,32,60,61,32,50,0,109,105,110,77,97,120,76,111,99,0,118,111,105,100,32,99,118,58,58,109,105,110,77,97,120,76,111,99,40,73,110,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,80,111,105,110,116,32,42,44,32,80,111,105,110,116,32,42,44,32,73,110,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,102,97,115,116,65,116,97,110,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,44,32,98,111,111,108,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,104,102,117,110,99,115,95,99,111,114,101,46,115,105,109,100,46,104,112,112,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,102,97,115,116,65,116,97,110,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,44,32,98,111,111,108,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,109,97,103,110,105,116,117,100,101,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,109,97,103,110,105,116,117,100,101,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,105,110,118,83,113,114,116,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,105,110,118,83,113,114,116,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,115,113,114,116,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,115,113,114,116,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,101,120,112,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,101,120,112,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,108,111,103,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,99,112,117,95,98,97,115,101,108,105,110,101,58,58,108,111,103,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,102,97,115,116,65,116,97,110,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,44,32,98,111,111,108,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,104,102,117,110,99,115,95,99,111,114,101,46,100,105,115,112,97,116,99,104,46,99,112,112,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,102,97,115,116,65,116,97,110,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,44,32,98,111,111,108,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,109,97,103,110,105,116,117,100,101,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,109,97,103,110,105,116,117,100,101,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,105,110,118,83,113,114,116,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,105,110,118,83,113,114,116,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,115,113,114,116,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,115,113,114,116,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,101,120,112,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,101,120,112,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,108,111,103,51,50,102,40,99,111,110,115,116,32,102,108,111,97,116,32,42,44,32,102,108,111,97,116,32,42,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,108,111,103,54,52,102,40,99,111,110,115,116,32,100,111,117,98,108,101,32,42,44,32,100,111,117,98,108,101,32,42,44,32,105,110,116,41,0,79,80,69,78,67,86,95,75,77,69,65,78,83,95,80,65,82,65,76,76,69,76,95,71,82,65,78,85,76,65,82,73,84,89,0,100,97,116,97,48,46,100,105,109,115,32,60,61,32,50,32,38,38,32,116,121,112,101,32,61,61,32,67,86,95,51,50,70,32,38,38,32,75,32,62,32,48,0,107,109,101,97,110,115,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,107,109,101,97,110,115,46,99,112,112,0,78,32,62,61,32,75,0,40,98,101,115,116,95,108,97,98,101,108,115,46,99,111,108,115,32,61,61,32,49,32,124,124,32,98,101,115,116,95,108,97,98,101,108,115,46,114,111,119,115,32,61,61,32,49,41,32,38,38,32,98,101,115,116,95,108,97,98,101,108,115,46,99,111,108,115,42,98,101,115,116,95,108,97,98,101,108,115,46,114,111,119,115,32,61,61,32,78,32,38,38,32,98,101,115,116,95,108,97,98,101,108,115,46,116,121,112,101,40,41,32,61,61,32,67,86,95,51,50,83,32,38,38,32,98,101,115,116,95,108,97,98,101,108,115,46,105,115,67,111,110,116,105,110,117,111,117,115,40,41,0,40,117,110,115,105,103,110,101,100,41,95,108,97,98,101,108,115,46,97,116,60,105,110,116,62,40,105,41,32,60,32,40,117,110,115,105,103,110,101,100,41,75,0,99,111,117,110,116,101,114,115,91,107,93,32,33,61,32,48,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,75,77,101,97,110,115,68,105,115,116,97,110,99,101,67,111,109,112,117,116,101,114,60,102,97,108,115,101,62,58,58,111,112,101,114,97,116,111,114,40,41,40,99,111,110,115,116,32,99,118,58,58,82,97,110,103,101,32,38,41,32,99,111,110,115,116,32,91,111,110,108,121,68,105,115,116,97,110,99,101,32,61,32,102,97,108,115,101,93,0,78,50,99,118,50,50,75,77,101,97,110,115,68,105,115,116,97,110,99,101,67,111,109,112,117,116,101,114,73,76,98,48,69,69,69,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,75,77,101,97,110,115,68,105,115,116,97,110,99,101,67,111,109,112,117,116,101,114,60,116,114,117,101,62,58,58,111,112,101,114,97,116,111,114,40,41,40,99,111,110,115,116,32,99,118,58,58,82,97,110,103,101,32,38,41,32,99,111,110,115,116,32,91,111,110,108,121,68,105,115,116,97,110,99,101,32,61,32,116,114,117,101,93,0,78,50,99,118,50,50,75,77,101,97,110,115,68,105,115,116,97,110,99,101,67,111,109,112,117,116,101,114,73,76,98,49,69,69,69,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,75,77,101,97,110,115,80,80,68,105,115,116,97,110,99,101,67,111,109,112,117,116,101,114,58,58,111,112,101,114,97,116,111,114,40,41,40,99,111,110,115,116,32,99,118,58,58,82,97,110,103,101,32,38,41,32,99,111,110,115,116,0,78,50,99,118,50,52,75,77,101,97,110,115,80,80,68,105,115,116,97,110,99,101,67,111,109,112,117,116,101,114,69,0,118,111,105,100,32,99,118,58,58,103,101,110,101,114,97,116,101,67,101,110,116,101,114,115,80,80,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,38,44,32,99,118,58,58,77,97,116,32,38,44,32,105,110,116,44,32,99,118,58,58,82,78,71,32,38,44,32,105,110,116,41,0,100,111,117,98,108,101,32,99,118,58,58,107,109,101,97,110,115,40,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,99,118,58,58,84,101,114,109,67,114,105,116,101,114,105,97,44,32,105,110,116,44,32,105,110,116,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,109,97,112,99,111,117,110,116,32,61,61,32,48,0,126,85,77,97,116,68,97,116,97,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,117,109,97,116,114,105,120,46,99,112,112,0,117,115,97,103,101,95,99,111,117,110,116,32,61,61,32,48,0,108,111,99,107,0,112,116,114,0,103,101,116,82,101,102,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,105,110,99,108,117,100,101,47,111,112,101,110,99,118,50,47,99,111,114,101,47,117,116,105,108,105,116,121,46,104,112,112,0,78,50,99,118,55,84,76,83,68,97,116,97,73,78,83,95,49,56,85,77,97,116,68,97,116,97,65,117,116,111,76,111,99,107,101,114,69,69,69,0,117,115,97,103,101,95,99,111,117,110,116,32,61,61,32,49,0,100,97,116,97,32,61,61,32,100,97,116,97,115,116,97,114,116,0,97,108,108,111,99,97,116,101,100,0,85,77,97,116,0,100,115,116,46,117,0,117,45,62,100,97,116,97,32,33,61,32,48,32,38,38,32,34,69,114,114,111,114,32,109,97,112,112,105,110,103,32,111,102,32,85,77,97,116,32,116,111,32,104,111,115,116,32,109,101,109,111,114,121,46,34,0,103,101,116,77,97,116,0,118,111,105,100,32,99,118,58,58,85,77,97,116,58,58,99,111,110,118,101,114,116,84,111,40,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,41,32,99,111,110,115,116,0,118,111,105,100,32,99,118,58,58,85,77,97,116,58,58,99,111,112,121,84,111,40,79,117,116,112,117,116,65,114,114,97,121,41,32,99,111,110,115,116,0,99,118,58,58,85,77,97,116,32,38,99,118,58,58,85,77,97,116,58,58,115,101,116,84,111,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,98,111,111,108,32,99,118,58,58,111,99,108,58,58,104,97,118,101,79,112,101,110,67,76,40,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,111,99,108,46,99,112,112,0,78,50,99,118,50,48,66,117,102,102,101,114,80,111,111,108,67,111,110,116,114,111,108,108,101,114,69,0,78,83,116,51,95,95,50,49,57,98,97,115,105,99,95,111,115,116,114,105,110,103,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,99,104,97,110,110,101,108,115,40,41,32,61,61,32,67,86,95,77,65,84,95,67,78,40,100,116,121,112,101,41,0,100,115,116,46,117,32,33,61,32,78,85,76,76,0,100,105,109,115,32,62,61,32,48,32,38,38,32,100,105,109,115,32,60,32,67,86,95,77,65,88,95,68,73,77,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,99,111,112,121,46,99,112,112,0,118,111,105,100,32,99,118,58,58,77,97,116,58,58,99,111,112,121,84,111,40,79,117,116,112,117,116,65,114,114,97,121,41,32,99,111,110,115,116,0,109,97,115,107,46,100,101,112,116,104,40,41,32,61,61,32,67,86,95,56,85,32,38,38,32,40,109,99,110,32,61,61,32,49,32,124,124,32,109,99,110,32,61,61,32,99,110,41,0,115,105,122,101,40,41,32,61,61,32,109,97,115,107,46,115,105,122,101,40,41,0,115,122,32,60,61,32,115,105,122,101,111,102,40,115,99,97,108,97,114,41,0,99,118,58,58,77,97,116,32,38,99,118,58,58,77,97,116,58,58,111,112,101,114,97,116,111,114,61,40,99,111,110,115,116,32,83,99,97,108,97,114,32,38,41,0,118,111,105,100,32,99,118,58,58,77,97,116,58,58,99,111,112,121,84,111,40,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,32,99,111,110,115,116,0,99,104,101,99,107,83,99,97,108,97,114,40,118,97,108,117,101,44,32,116,121,112,101,40,41,44,32,95,118,97,108,117,101,46,107,105,110,100,40,41,44,32,95,73,110,112,117,116,65,114,114,97,121,58,58,77,65,84,32,41,0,109,97,115,107,46,101,109,112,116,121,40,41,32,124,124,32,40,109,97,115,107,46,100,101,112,116,104,40,41,32,61,61,32,67,86,95,56,85,32,38,38,32,40,109,99,110,32,61,61,32,49,32,124,124,32,109,99,110,32,61,61,32,99,110,41,32,38,38,32,115,105,122,101,32,61,61,32,109,97,115,107,46,115,105,122,101,41,0,99,118,58,58,77,97,116,32,38,99,118,58,58,77,97,116,58,58,115,101,116,84,111,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,102,108,105,112,0,118,111,105,100,32,99,118,58,58,102,108,105,112,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,95,115,114,99,46,103,101,116,79,98,106,40,41,32,33,61,32,95,100,115,116,46,103,101,116,79,98,106,40,41,0,114,101,112,101,97,116,0,110,121,32,62,32,48,32,38,38,32,110,120,32,62,32,48,0,118,111,105,100,32,99,118,58,58,114,101,112,101,97,116,40,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,98,111,114,100,101,114,73,110,116,101,114,112,111,108,97,116,101,0,85,110,107,110,111,119,110,47,117,110,115,117,112,112,111,114,116,101,100,32,98,111,114,100,101,114,32,116,121,112,101,0,116,111,112,32,62,61,32,48,32,38,38,32,98,111,116,116,111,109,32,62,61,32,48,32,38,38,32,108,101,102,116,32,62,61,32,48,32,38,38,32,114,105,103,104,116,32,62,61,32,48,0,99,111,112,121,77,97,107,101,66,111,114,100,101,114,0,118,97,108,117,101,91,48,93,32,61,61,32,118,97,108,117,101,91,49,93,32,38,38,32,118,97,108,117,101,91,48,93,32,61,61,32,118,97,108,117,101,91,50,93,32,38,38,32,118,97,108,117,101,91,48,93,32,61,61,32,118,97,108,117,101,91,51,93,0,118,111,105,100,32,99,118,58,58,99,111,112,121,77,97,107,101,66,111,114,100,101,114,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,41,0,109,97,115,107,97,114,114,32,61,61,32,48,0,99,118,67,111,112,121,0,115,114,99,46,100,101,112,116,104,40,41,32,61,61,32,100,115,116,46,100,101,112,116,104,40,41,32,38,38,32,115,114,99,46,115,105,122,101,32,61,61,32,100,115,116,46,115,105,122,101,0,40,99,111,105,49,32,33,61,32,48,32,124,124,32,115,114,99,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,41,32,38,38,32,40,99,111,105,50,32,33,61,32,48,32,124,124,32,100,115,116,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,41,0,115,114,99,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,100,115,116,46,99,104,97,110,110,101,108,115,40,41,0,33,95,109,97,116,46,101,109,112,116,121,40,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,114,97,110,100,46,99,112,112,0,95,112,97,114,97,109,49,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,32,38,38,32,40,95,112,97,114,97,109,49,46,114,111,119,115,32,61,61,32,49,32,124,124,32,95,112,97,114,97,109,49,46,99,111,108,115,32,61,61,32,49,41,32,38,38,32,40,95,112,97,114,97,109,49,46,114,111,119,115,32,43,32,95,112,97,114,97,109,49,46,99,111,108,115,32,45,32,49,32,61,61,32,99,110,32,124,124,32,95,112,97,114,97,109,49,46,114,111,119,115,32,43,32,95,112,97,114,97,109,49,46,99,111,108,115,32,45,32,49,32,61,61,32,49,32,124,124,32,40,95,112,97,114,97,109,49,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,44,32,52,41,32,38,38,32,95,112,97,114,97,109,49,46,116,121,112,101,40,41,32,61,61,32,67,86,95,54,52,70,32,38,38,32,99,110,32,60,61,32,52,41,41,0,95,112,97,114,97,109,50,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,32,38,38,32,40,40,40,95,112,97,114,97,109,50,46,114,111,119,115,32,61,61,32,49,32,124,124,32,95,112,97,114,97,109,50,46,99,111,108,115,32,61,61,32,49,41,32,38,38,32,40,95,112,97,114,97,109,50,46,114,111,119,115,32,43,32,95,112,97,114,97,109,50,46,99,111,108,115,32,45,32,49,32,61,61,32,99,110,32,124,124,32,95,112,97,114,97,109,50,46,114,111,119,115,32,43,32,95,112,97,114,97,109,50,46,99,111,108,115,32,45,32,49,32,61,61,32,49,32,124,124,32,40,95,112,97,114,97,109,49,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,44,32,52,41,32,38,38,32,95,112,97,114,97,109,49,46,116,121,112,101,40,41,32,61,61,32,67,86,95,54,52,70,32,38,38,32,99,110,32,60,61,32,52,41,41,41,32,124,124,32,40,95,112,97,114,97,109,50,46,114,111,119,115,32,61,61,32,99,110,32,38,38,32,95,112,97,114,97,109,50,46,99,111,108,115,32,61,61,32,99,110,32,38,38,32,100,105,115,116,116,121,112,101,32,61,61,32,78,79,82,77,65,76,41,41,0,115,99,97,108,101,70,117,110,99,32,33,61,32,48,0,85,110,107,110,111,119,110,32,100,105,115,116,114,105,98,117,116,105,111,110,32,116,121,112,101,0,118,111,105,100,32,99,118,58,58,114,97,110,100,117,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,114,97,110,100,110,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,105,32,60,32,48,0,103,101,116,77,97,116,95,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,114,105,120,95,119,114,97,112,46,99,112,112,0,48,32,60,61,32,105,32,38,38,32,105,32,60,32,40,105,110,116,41,118,118,46,115,105,122,101,40,41,0,48,32,60,61,32,105,32,38,38,32,105,32,60,32,40,105,110,116,41,118,46,115,105,122,101,40,41,0,48,32,60,61,32,105,32,38,38,32,105,32,60,32,115,122,46,104,101,105,103,104,116,0,89,111,117,32,115,104,111,117,108,100,32,101,120,112,108,105,99,105,116,108,121,32,99,97,108,108,32,109,97,112,72,111,115,116,47,117,110,109,97,112,72,111,115,116,32,109,101,116,104,111,100,115,32,102,111,114,32,111,103,108,58,58,66,117,102,102,101,114,32,111,98,106,101,99,116,0,89,111,117,32,115,104,111,117,108,100,32,101,120,112,108,105,99,105,116,108,121,32,99,97,108,108,32,100,111,119,110,108,111,97,100,32,109,101,116,104,111,100,32,102,111,114,32,99,117,100,97,58,58,71,112,117,77,97,116,32,111,98,106,101,99,116,0,85,110,107,110,111,119,110,47,117,110,115,117,112,112,111,114,116,101,100,32,97,114,114,97,121,32,116,121,112,101,0,40,102,108,97,103,115,32,38,32,70,73,88,69,68,95,84,89,80,69,41,32,33,61,32,48,0,105,32,60,32,40,105,110,116,41,118,118,46,115,105,122,101,40,41,0,105,32,60,32,115,122,46,104,101,105,103,104,116,0,103,101,116,85,77,97,116,0,103,101,116,77,97,116,86,101,99,116,111,114,0,100,105,109,115,0,101,109,112,116,121,0,40,115,105,122,101,95,116,41,105,32,60,32,118,118,46,115,105,122,101,40,41,0,105,115,67,111,110,116,105,110,117,111,117,115,0,105,32,62,32,48,32,38,38,32,105,32,60,32,115,122,46,104,101,105,103,104,116,0,99,111,112,121,84,111,0,33,102,105,120,101,100,83,105,122,101,40,41,0,114,101,108,101,97,115,101,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,40,40,77,97,116,42,41,111,98,106,41,45,62,115,105,122,101,46,111,112,101,114,97,116,111,114,40,41,40,41,32,61,61,32,95,115,122,0,33,102,105,120,101,100,84,121,112,101,40,41,32,124,124,32,40,40,77,97,116,42,41,111,98,106,41,45,62,116,121,112,101,40,41,32,61,61,32,109,116,121,112,101,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,40,40,85,77,97,116,42,41,111,98,106,41,45,62,115,105,122,101,46,111,112,101,114,97,116,111,114,40,41,40,41,32,61,61,32,95,115,122,0,33,102,105,120,101,100,84,121,112,101,40,41,32,124,124,32,40,40,85,77,97,116,42,41,111,98,106,41,45,62,116,121,112,101,40,41,32,61,61,32,109,116,121,112,101,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,40,40,99,117,100,97,58,58,71,112,117,77,97,116,42,41,111,98,106,41,45,62,115,105,122,101,40,41,32,61,61,32,95,115,122,0,33,102,105,120,101,100,84,121,112,101,40,41,32,124,124,32,40,40,99,117,100,97,58,58,71,112,117,77,97,116,42,41,111,98,106,41,45,62,116,121,112,101,40,41,32,61,61,32,109,116,121,112,101,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,40,40,111,103,108,58,58,66,117,102,102,101,114,42,41,111,98,106,41,45,62,115,105,122,101,40,41,32,61,61,32,95,115,122,0,33,102,105,120,101,100,84,121,112,101,40,41,32,124,124,32,40,40,111,103,108,58,58,66,117,102,102,101,114,42,41,111,98,106,41,45,62,116,121,112,101,40,41,32,61,61,32,109,116,121,112,101,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,40,40,99,117,100,97,58,58,72,111,115,116,77,101,109,42,41,111,98,106,41,45,62,115,105,122,101,40,41,32,61,61,32,95,115,122,0,33,102,105,120,101,100,84,121,112,101,40,41,32,124,124,32,40,40,99,117,100,97,58,58,72,111,115,116,77,101,109,42,41,111,98,106,41,45,62,116,121,112,101,40,41,32,61,61,32,109,116,121,112,101,0,33,102,105,120,101,100,84,121,112,101,40,41,32,38,38,32,33,102,105,120,101,100,83,105,122,101,40,41,0,67,86,95,77,65,84,95,84,89,80,69,40,109,116,121,112,101,41,32,61,61,32,109,46,116,121,112,101,40,41,0,109,46,100,105,109,115,32,61,61,32,100,0,109,46,115,105,122,101,91,106,93,32,61,61,32,115,105,122,101,115,91,106,93,0,109,116,121,112,101,32,61,61,32,116,121,112,101,48,32,124,124,32,40,67,86,95,77,65,84,95,67,78,40,109,116,121,112,101,41,32,61,61,32,49,32,38,38,32,40,40,49,32,60,60,32,116,121,112,101,48,41,32,38,32,102,105,120,101,100,68,101,112,116,104,77,97,115,107,41,32,33,61,32,48,41,0,100,32,61,61,32,50,32,38,38,32,40,40,115,105,122,101,115,91,48,93,32,61,61,32,115,122,46,104,101,105,103,104,116,32,38,38,32,115,105,122,101,115,91,49,93,32,61,61,32,115,122,46,119,105,100,116,104,41,32,124,124,32,40,97,108,108,111,119,84,114,97,110,115,112,111,115,101,100,32,38,38,32,115,105,122,101,115,91,48,93,32,61,61,32,115,122,46,119,105,100,116,104,32,38,38,32,115,105,122,101,115,91,49,93,32,61,61,32,115,122,46,104,101,105,103,104,116,41,41,0,100,32,61,61,32,50,32,38,38,32,115,122,46,97,114,101,97,40,41,32,61,61,32,115,105,122,101,115,91,48,93,42,115,105,122,101,115,91,49,93,0,100,32,61,61,32,50,32,38,38,32,40,115,105,122,101,115,91,48,93,32,61,61,32,49,32,124,124,32,115,105,122,101,115,91,49,93,32,61,61,32,49,32,124,124,32,115,105,122,101,115,91,48,93,42,115,105,122,101,115,91,49,93,32,61,61,32,48,41,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,108,101,110,32,61,61,32,118,118,46,115,105,122,101,40,41,0,109,116,121,112,101,32,61,61,32,116,121,112,101,48,32,124,124,32,40,67,86,95,77,65,84,95,67,78,40,109,116,121,112,101,41,32,61,61,32,67,86,95,77,65,84,95,67,78,40,116,121,112,101,48,41,32,38,38,32,40,40,49,32,60,60,32,116,121,112,101,48,41,32,38,32,102,105,120,101,100,68,101,112,116,104,77,97,115,107,41,32,33,61,32,48,41,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,108,101,110,32,61,61,32,40,40,115,116,100,58,58,118,101,99,116,111,114,60,117,99,104,97,114,62,42,41,118,41,45,62,115,105,122,101,40,41,32,47,32,101,115,122,0,86,101,99,116,111,114,115,32,119,105,116,104,32,101,108,101,109,101,110,116,32,115,105,122,101,32,37,100,32,97,114,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,46,32,80,108,101,97,115,101,44,32,109,111,100,105,102,121,32,79,117,116,112,117,116,65,114,114,97,121,58,58,99,114,101,97,116,101,40,41,10,0,99,114,101,97,116,101,40,41,32,99,97,108,108,101,100,32,102,111,114,32,116,104,101,32,109,105,115,115,105,110,103,32,111,117,116,112,117,116,32,97,114,114,97,121,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,108,101,110,32,61,61,32,108,101,110,48,0,118,91,106,93,46,101,109,112,116,121,40,41,0,105,32,60,32,40,105,110,116,41,118,46,115,105,122,101,40,41,0,108,101,110,32,61,61,32,108,101,110,48,0,103,101,116,77,97,116,82,101,102,0,107,32,61,61,32,83,84,68,95,86,69,67,84,79,82,95,77,65,84,32,124,124,32,107,32,61,61,32,83,84,68,95,65,82,82,65,89,95,77,65,84,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,40,40,77,97,116,42,41,111,98,106,41,45,62,115,105,122,101,46,111,112,101,114,97,116,111,114,40,41,40,41,32,61,61,32,83,105,122,101,40,95,99,111,108,115,44,32,95,114,111,119,115,41,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,40,40,85,77,97,116,42,41,111,98,106,41,45,62,115,105,122,101,46,111,112,101,114,97,116,111,114,40,41,40,41,32,61,61,32,83,105,122,101,40,95,99,111,108,115,44,32,95,114,111,119,115,41,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,40,40,99,117,100,97,58,58,71,112,117,77,97,116,42,41,111,98,106,41,45,62,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,95,99,111,108,115,44],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+194561);allocate([32,95,114,111,119,115,41,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,40,40,111,103,108,58,58,66,117,102,102,101,114,42,41,111,98,106,41,45,62,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,95,99,111,108,115,44,32,95,114,111,119,115,41,0,33,102,105,120,101,100,83,105,122,101,40,41,32,124,124,32,40,40,99,117,100,97,58,58,72,111,115,116,77,101,109,42,41,111,98,106,41,45,62,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,95,99,111,108,115,44,32,95,114,111,119,115,41,0,99,108,101,97,114,0,99,104,101,99,107,83,99,97,108,97,114,40,118,97,108,117,101,44,32,116,121,112,101,40,41,44,32,97,114,114,46,107,105,110,100,40,41,44,32,95,73,110,112,117,116,65,114,114,97,121,58,58,67,85,68,65,95,71,80,85,95,77,65,84,41,0,115,101,116,84,111,0,116,104,105,115,95,118,46,115,105,122,101,40,41,32,61,61,32,118,46,115,105,122,101,40,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,114,105,120,95,99,46,99,112,112,0,67,79,73,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,116,104,101,32,102,117,110,99,116,105,111,110,0,99,118,97,114,114,84,111,77,97,116,0,105,109,103,45,62,100,97,116,97,79,114,100,101,114,32,61,61,32,73,80,76,95,68,65,84,65,95,79,82,68,69,82,95,80,73,88,69,76,0,105,112,108,73,109,97,103,101,84,111,77,97,116,0,105,109,103,45,62,100,97,116,97,79,114,100,101,114,32,61,61,32,73,80,76,95,68,65,84,65,95,79,82,68,69,82,95,80,73,88,69,76,32,124,124,32,105,109,103,45,62,114,111,105,45,62,99,111,105,32,33,61,32,48,0,116,111,116,97,108,32,62,32,48,32,38,38,32,67,86,95,69,76,69,77,95,83,73,90,69,40,115,101,113,45,62,102,108,97,103,115,41,32,61,61,32,101,115,122,0,85,110,107,110,111,119,110,32,97,114,114,97,121,32,116,121,112,101,0,105,99,118,73,110,105,116,77,101,109,83,116,111,114,97,103,101,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,100,97,116,97,115,116,114,117,99,116,115,46,99,112,112,0,99,118,67,114,101,97,116,101,67,104,105,108,100,77,101,109,83,116,111,114,97,103,101,0,99,118,82,101,108,101,97,115,101,77,101,109,83,116,111,114,97,103,101,0,99,118,67,108,101,97,114,77,101,109,83,116,111,114,97,103,101,0,99,118,83,97,118,101,77,101,109,83,116,111,114,97,103,101,80,111,115,0,99,118,82,101,115,116,111,114,101,77,101,109,83,116,111,114,97,103,101,80,111,115,0,99,118,77,101,109,83,116,111,114,97,103,101,65,108,108,111,99,0,84,111,111,32,108,97,114,103,101,32,109,101,109,111,114,121,32,98,108,111,99,107,32,105,115,32,114,101,113,117,101,115,116,101,100,0,114,101,113,117,101,115,116,101,100,32,115,105,122,101,32,105,115,32,110,101,103,97,116,105,118,101,32,111,114,32,116,111,111,32,98,105,103,0,105,99,118,71,111,78,101,120,116,77,101,109,66,108,111,99,107,0,99,118,67,114,101,97,116,101,83,101,113,0,83,112,101,99,105,102,105,101,100,32,101,108,101,109,101,110,116,32,115,105,122,101,32,100,111,101,115,110,39,116,32,109,97,116,99,104,32,116,111,32,116,104,101,32,115,105,122,101,32,111,102,32,116,104,101,32,115,112,101,99,105,102,105,101,100,32,101,108,101,109,101,110,116,32,116,121,112,101,32,40,116,114,121,32,116,111,32,117,115,101,32,48,32,102,111,114,32,101,108,101,109,101,110,116,32,116,121,112,101,41,0,99,118,83,101,116,83,101,113,66,108,111,99,107,83,105,122,101,0,83,116,111,114,97,103,101,32,98,108,111,99,107,32,115,105,122,101,32,105,115,32,116,111,111,32,115,109,97,108,108,32,116,111,32,102,105,116,32,116,104,101,32,115,101,113,117,101,110,99,101,32,101,108,101,109,101,110,116,115,0,0,1,255,2,255,255,255,3,255,255,255,255,255,255,255,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,5,99,118,67,118,116,83,101,113,84,111,65,114,114,97,121,0,99,118,83,101,116,83,101,113,82,101,97,100,101,114,80,111,115,0,99,118,83,116,97,114,116,82,101,97,100,83,101,113,0,99,118,77,97,107,101,83,101,113,72,101,97,100,101,114,70,111,114,65,114,114,97,121,0,69,108,101,109,101,110,116,32,115,105,122,101,32,100,111,101,115,110,39,116,32,109,97,116,99,104,32,116,111,32,116,104,101,32,115,105,122,101,32,111,102,32,112,114,101,100,101,102,105,110,101,100,32,101,108,101,109,101,110,116,32,116,121,112,101,32,40,116,114,121,32,116,111,32,117,115,101,32,48,32,102,111,114,32,115,101,113,117,101,110,99,101,32,101,108,101,109,101,110,116,32,116,121,112,101,41,0,99,118,83,116,97,114,116,65,112,112,101,110,100,84,111,83,101,113,0,99,118,83,116,97,114,116,87,114,105,116,101,83,101,113,0,99,118,70,108,117,115,104,83,101,113,87,114,105,116,101,114,0,99,118,69,110,100,87,114,105,116,101,83,101,113,0,99,118,67,114,101,97,116,101,83,101,113,66,108,111,99,107,0,105,99,118,71,114,111,119,83,101,113,0,84,104,101,32,115,101,113,117,101,110,99,101,32,104,97,115,32,78,85,76,76,32,115,116,111,114,97,103,101,32,112,111,105,110,116,101,114,0,99,118,67,104,97,110,103,101,83,101,113,66,108,111,99,107,0,99,118,71,101,116,83,101,113,82,101,97,100,101,114,80,111,115,0,99,118,83,101,113,80,117,115,104,0,99,118,83,101,113,80,111,112,0,78,85,76,76,32,115,101,113,117,101,110,99,101,32,112,111,105,110,116,101,114,0,99,118,83,101,113,80,117,115,104,77,117,108,116,105,0,110,117,109,98,101,114,32,111,102,32,114,101,109,111,118,101,100,32,101,108,101,109,101,110,116,115,32,105,115,32,110,101,103,97,116,105,118,101,0,99,118,83,101,113,80,111,112,77,117,108,116,105,0,99,118,67,108,101,97,114,83,101,113,0,73,110,118,97,108,105,100,32,115,101,113,117,101,110,99,101,32,104,101,97,100,101,114,0,99,118,83,101,113,83,108,105,99,101,0,66,97,100,32,115,101,113,117,101,110,99,101,32,115,108,105,99,101,0,66,97,100,32,105,110,112,117,116,32,115,101,113,117,101,110,99,101,0,99,118,83,101,113,83,111,114,116,0,78,117,108,108,32,99,111,109,112,97,114,101,32,102,117,110,99,116,105,111,110,0,99,118,67,114,101,97,116,101,83,101,116,0,99,118,83,101,116,65,100,100,0,99,118,67,114,101,97,116,101,71,114,97,112,104,0,99,118,71,114,97,112,104,65,100,100,86,116,120,0,99,118,70,105,110,100,71,114,97,112,104,69,100,103,101,66,121,80,116,114,0,103,114,97,112,104,32,112,111,105,110,116,101,114,32,105,115,32,78,85,76,76,0,99,118,71,114,97,112,104,65,100,100,69,100,103,101,66,121,80,116,114,0,118,101,114,116,101,120,32,112,111,105,110,116,101,114,115,32,99,111,105,110,99,105,100,101,32,40,111,114,32,115,101,116,32,116,111,32,78,85,76,76,41,0,73,110,118,97,108,105,100,32,103,114,97,112,104,32,112,111,105,110,116,101,114,0,99,118,67,108,111,110,101,71,114,97,112,104,0,99,118,84,114,101,101,84,111,78,111,100,101,83,101,113,0,99,118,73,110,105,116,84,114,101,101,78,111,100,101,73,116,101,114,97,116,111,114,0,99,118,78,101,120,116,84,114,101,101,78,111,100,101,0,99,118,73,110,115,101,114,116,78,111,100,101,73,110,116,111,84,114,101,101,0,99,111,110,118,101,114,116,83,99,97,108,101,65,98,115,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,99,111,110,118,101,114,116,95,115,99,97,108,101,46,99,112,112,0,118,111,105,100,32,99,118,58,58,99,111,110,118,101,114,116,83,99,97,108,101,65,98,115,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,41,0,85,110,107,110,111,119,110,47,117,110,115,117,112,112,111,114,116,101,100,32,110,111,114,109,32,116,121,112,101,0,110,111,114,109,97,108,105,122,101,0,118,111,105,100,32,99,118,58,58,110,111,114,109,97,108,105,122,101,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,105,110,116,44,32,105,110,116,44,32,73,110,112,117,116,65,114,114,97,121,41,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,49,51,67,118,70,105,108,101,83,116,111,114,97,103,101,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,56,80,116,114,79,119,110,101,114,69,0,118,105,114,116,117,97,108,32,98,111,111,108,32,99,118,58,58,70,105,108,101,83,116,111,114,97,103,101,58,58,111,112,101,110,40,99,111,110,115,116,32,99,118,58,58,83,116,114,105,110,103,32,38,44,32,105,110,116,44,32,99,111,110,115,116,32,99,118,58,58,83,116,114,105,110,103,32,38,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,112,101,114,115,105,115,116,101,110,99,101,95,99,112,112,46,99,112,112,0,78,50,99,118,49,49,70,105,108,101,83,116,111,114,97,103,101,69,0,69,120,116,114,97,32,99,108,111,115,105,110,103,32,39,37,99,39,0,84,104,101,32,99,108,111,115,105,110,103,32,39,37,99,39,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,116,104,101,32,111,112,101,110,105,110,103,32,39,37,99,39,0,73,110,99,111,114,114,101,99,116,32,101,108,101,109,101,110,116,32,110,97,109,101,32,37,115,0,73,110,118,97,108,105,100,32,102,115,46,115,116,97,116,101,0,108,101,110,32,37,32,101,108,101,109,83,105,122,101,32,61,61,32,48,0,119,114,105,116,101,82,97,119,0,46,103,122,0,73,110,118,97,108,105,100,32,102,105,108,101,110,97,109,101,0,103,101,116,68,101,102,97,117,108,116,79,98,106,101,99,116,78,97,109,101,0,101,108,101,109,95,115,105,122,101,32,62,32,48,0,114,101,97,100,82,97,119,0,99,110,32,60,61,32,52,32,38,38,32,102,117,110,99,32,33,61,32,48,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,115,117,109,46,99,112,112,0,99,118,58,58,83,99,97,108,97,114,32,99,118,58,58,115,117,109,40,73,110,112,117,116,65,114,114,97,121,41,0,60,105,110,118,97,108,105,100,32,100,101,112,116,104,62,0,67,86,95,56,85,0,67,86,95,56,83,0,67,86,95,49,54,85,0,67,86,95,49,54,83,0,67,86,95,51,50,83,0,67,86,95,51,50,70,0,67,86,95,54,52,70,0,67,86,95,85,83,82,84,89,80,69,49,0,37,115,67,37,100,0,60,105,110,118,97,108,105,100,32,116,121,112,101,62,0,32,40,101,120,112,101,99,116,101,100,58,32,39,0,63,63,63,0,39,41,44,32,119,104,101,114,101,0,32,32,32,32,39,0,39,32,105,115,32,0,109,117,115,116,32,98,101,32,0,123,99,117,115,116,111,109,32,99,104,101,99,107,125,0,101,113,117,97,108,32,116,111,0,110,111,116,32,101,113,117,97,108,32,116,111,0,108,101,115,115,32,116,104,97,110,32,111,114,32,101,113,117,97,108,32,116,111,0,108,101,115,115,32,116,104,97,110,0,103,114,101,97,116,101,114,32,116,104,97,110,32,111,114,32,101,113,117,97,108,32,116,111,0,103,114,101,97,116,101,114,32,116,104,97,110,0,39,0,119,104,101,114,101,0,115,114,99,91,105,93,46,100,105,109,115,32,60,61,32,50,32,38,38,32,115,114,99,91,105,93,46,114,111,119,115,32,61,61,32,115,114,99,91,48,93,46,114,111,119,115,32,38,38,32,115,114,99,91,105,93,46,116,121,112,101,40,41,32,61,61,32,115,114,99,91,48,93,46,116,121,112,101,40,41,0,104,99,111,110,99,97,116,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,114,105,120,95,111,112,101,114,97,116,105,111,110,115,46,99,112,112,0,118,111,105,100,32,99,118,58,58,104,99,111,110,99,97,116,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,42,44,32,115,105,122,101,95,116,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,104,99,111,110,99,97,116,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,115,114,99,91,105,93,46,100,105,109,115,32,60,61,32,50,32,38,38,32,115,114,99,91,105,93,46,99,111,108,115,32,61,61,32,115,114,99,91,48,93,46,99,111,108,115,32,38,38,32,115,114,99,91,105,93,46,116,121,112,101,40,41,32,61,61,32,115,114,99,91,48,93,46,116,121,112,101,40,41,0,118,99,111,110,99,97,116,0,118,111,105,100,32,99,118,58,58,118,99,111,110,99,97,116,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,42,44,32,115,105,122,101,95,116,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,118,99,111,110,99,97,116,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,95,109,46,100,105,109,115,40,41,32,60,61,32,50,0,115,101,116,73,100,101,110,116,105,116,121,0,118,111,105,100,32,99,118,58,58,115,101,116,73,100,101,110,116,105,116,121,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,41,0,116,114,97,99,101,0,99,118,58,58,83,99,97,108,97,114,32,99,118,58,58,116,114,97,99,101,40,73,110,112,117,116,65,114,114,97,121,41,0,95,115,114,99,46,100,105,109,115,40,41,32,60,61,32,50,32,38,38,32,101,115,122,32,60,61,32,51,50,0,116,114,97,110,115,112,111,115,101,0,115,114,99,46,115,105,122,101,40,41,32,61,61,32,100,115,116,46,115,105,122,101,40,41,32,38,38,32,40,115,114,99,46,99,111,108,115,32,61,61,32,49,32,124,124,32,115,114,99,46,114,111,119,115,32,61,61,32,49,41,0,118,111,105,100,32,99,118,58,58,116,114,97,110,115,112,111,115,101,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,109,46,100,105,109,115,32,60,61,32,50,32,38,38,32,109,46,114,111,119,115,32,61,61,32,109,46,99,111,108,115,0,99,111,109,112,108,101,116,101,83,121,109,109,0,118,111,105,100,32,99,118,58,58,99,111,109,112,108,101,116,101,83,121,109,109,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,98,111,111,108,41,0,95,115,114,99,46,100,105,109,115,40,41,32,60,61,32,50,0,114,101,100,117,99,101,0,111,112,32,61,61,32,67,86,95,82,69,68,85,67,69,95,83,85,77,32,124,124,32,111,112,32,61,61,32,67,86,95,82,69,68,85,67,69,95,77,65,88,32,124,124,32,111,112,32,61,61,32,67,86,95,82,69,68,85,67,69,95,77,73,78,32,124,124,32,111,112,32,61,61,32,67,86,95,82,69,68,85,67,69,95,65,86,71,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,109,98,105,110,97,116,105,111,110,32,111,102,32,105,110,112,117,116,32,97,110,100,32,111,117,116,112,117,116,32,97,114,114,97,121,32,102,111,114,109,97,116,115,0,118,111,105,100,32,99,118,58,58,114,101,100,117,99,101,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,41,0,115,114,99,46,100,105,109,115,32,60,61,32,50,32,38,38,32,115,114,99,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,0,115,111,114,116,0,118,111,105,100,32,99,118,58,58,115,111,114,116,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,84,104,101,32,108,105,98,114,97,114,121,32,105,115,32,99,111,109,112,105,108,101,100,32,119,105,116,104,111,117,116,32,79,112,101,110,71,76,32,115,117,112,112,111,114,116,0,116,104,114,111,119,95,110,111,95,111,103,108,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,111,112,101,110,103,108,46,99,112,112,0,99,111,110,118,101,114,116,84,111,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,99,111,110,118,101,114,116,46,99,112,112,0,118,111,105,100,32,99,118,58,58,77,97,116,58,58,99,111,110,118,101,114,116,84,111,40,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,41,32,99,111,110,115,116,0,85,110,115,117,112,112,111,114,116,101,100,32,105,110,112,117,116,32,100,101,112,116,104,0,99,111,110,118,101,114,116,70,112,49,54,0,118,111,105,100,32,99,118,58,58,99,111,110,118,101,114,116,70,112,49,54,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,115,112,108,105,116,46,99,112,112,0,118,111,105,100,32,99,118,58,58,115,112,108,105,116,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,38,44,32,99,118,58,58,77,97,116,32,42,41,0,33,95,109,118,46,102,105,120,101,100,84,121,112,101,40,41,32,124,124,32,95,109,118,46,101,109,112,116,121,40,41,32,124,124,32,95,109,118,46,116,121,112,101,40,41,32,61,61,32,109,46,100,101,112,116,104,40,41,0,118,111,105,100,32,99,118,58,58,115,112,108,105,116,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,79,102,65,114,114,97,121,115,41,0,116,121,112,101,32,61,61,32,67,86,95,54,52,70,67,50,0,103,101,109,109,73,109,112,108,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,109,117,108,46,99,112,112,0,118,111,105,100,32,99,118,58,58,103,101,109,109,73,109,112,108,40,99,118,58,58,77,97,116,44,32,99,118,58,58,77,97,116,44,32,100,111,117,98,108,101,44,32,99,118,58,58,77,97,116,44,32,100,111,117,98,108,101,44,32,99,118,58,58,77,97,116,44,32,105,110,116,41,0,116,121,112,101,32,61,61,32,66,46,116,121,112,101,40,41,0,103,101,109,109,0,40,116,121,112,101,32,61,61,32,40,40,40,53,41,32,38,32,40,40,49,32,60,60,32,51,41,32,45,32,49,41,41,32,43,32,40,40,40,49,41,45,49,41,32,60,60,32,51,41,41,32,124,124,32,116,121,112,101,32,61,61,32,40,40,40,54,41,32,38,32,40,40,49,32,60,60,32,51,41,32,45,32,49,41,41,32,43,32,40,40,40,49,41,45,49,41,32,60,60,32,51,41,41,32,124,124,32,116,121,112,101,32,61,61,32,40,40,40,53,41,32,38,32,40,40,49,32,60,60,32,51,41,32,45,32,49,41,41,32,43,32,40,40,40,50,41,45,49,41,32,60,60,32,51,41,41,32,124,124,32,116,121,112,101,32,61,61,32,40,40,40,54,41,32,38,32,40,40,49,32,60,60,32,51,41,32,45,32,49,41,41,32,43,32,40,40,40,50,41,45,49,41,32,60,60,32,51,41,41,41,0,97,95,115,105,122,101,46,119,105,100,116,104,32,61,61,32,108,101,110,0,97,95,115,105,122,101,46,104,101,105,103,104,116,32,61,61,32,108,101,110,0,67,46,116,121,112,101,40,41,32,61,61,32,116,121,112,101,0,40,40,40,102,108,97,103,115,38,71,69,77,77,95,51,95,84,41,32,61,61,32,48,32,38,38,32,67,46,114,111,119,115,32,61,61,32,100,95,115,105,122,101,46,104,101,105,103,104,116,32,38,38,32,67,46,99,111,108,115,32,61,61,32,100,95,115,105,122,101,46,119,105,100,116,104,41,32,124,124,32,40,40,102,108,97,103,115,38,71,69,77,77,95,51,95,84,41,32,33,61,32,48,32,38,38,32,67,46,114,111,119,115,32,61,61,32,100,95,115,105,122,101,46,119,105,100,116,104,32,38,38,32,67,46,99,111,108,115,32,61,61,32,100,95,115,105,122,101,46,104,101,105,103,104,116,41,41,0,115,99,110,32,61,61,32,109,46,99,111,108,115,32,124,124,32,115,99,110,32,43,32,49,32,61,61,32,109,46,99,111,108,115,0,116,114,97,110,115,102,111,114,109,0,118,111,105,100,32,99,118,58,58,116,114,97,110,115,102,111,114,109,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,115,99,110,32,43,32,49,32,61,61,32,109,46,99,111,108,115,0,112,101,114,115,112,101,99,116,105,118,101,84,114,97,110,115,102,111,114,109,0,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,54,52,70,0,118,111,105,100,32,99,118,58,58,112,101,114,115,112,101,99,116,105,118,101,84,114,97,110,115,102,111,114,109,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,116,121,112,101,32,61,61,32,95,115,114,99,50,46,116,121,112,101,40,41,0,115,99,97,108,101,65,100,100,0,115,114,99,49,46,115,105,122,101,32,61,61,32,115,114,99,50,46,115,105,122,101,0,118,111,105,100,32,99,118,58,58,115,99,97,108,101,65,100,100,40,73,110,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,115,114,99,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,0,109,117,108,84,114,97,110,115,112,111,115,101,100,0,100,101,108,116,97,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,0,40,100,101,108,116,97,46,114,111,119,115,32,61,61,32,115,114,99,46,114,111,119,115,32,124,124,32,100,101,108,116,97,46,114,111,119,115,32,61,61,32,49,41,0,40,100,101,108,116,97,46,99,111,108,115,32,61,61,32,115,114,99,46,99,111,108,115,32,124,124,32,100,101,108,116,97,46,99,111,108,115,32,61,61,32,49,41,0,118,111,105,100,32,99,118,58,58,109,117,108,84,114,97,110,115,112,111,115,101,100,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,98,111,111,108,44,32,73,110,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,109,97,116,46,116,121,112,101,40,41,32,61,61,32,116,121,112,101,40,41,0,100,111,116,0,109,97,116,46,115,105,122,101,32,61,61,32,115,105,122,101,0,100,111,117,98,108,101,32,99,118,58,58,77,97,116,58,58,100,111,116,40,73,110,112,117,116,65,114,114,97,121,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,105,110,116,32,99,118,58,58,77,97,116,79,112,58,58,116,121,112,101,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,114,105,120,95,101,120,112,114,101,115,115,105,111,110,115,46,99,112,112,0,78,50,99,118,49,49,77,97,116,79,112,95,83,111,108,118,101,69,0,67,86,95,77,65,84,95,67,78,40,95,116,121,112,101,41,32,61,61,32,101,46,97,46,99,104,97,110,110,101,108,115,40,41,0,97,115,115,105,103,110,0,78,50,99,118,49,52,77,97,116,79,112,95,73,100,101,110,116,105,116,121,69,0,78,50,99,118,49,50,77,97,116,79,112,95,73,110,118,101,114,116,69,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,71,69,77,77,58,58,116,114,97,110,115,112,111,115,101,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,71,69,77,77,58,58,109,117,108,116,105,112,108,121,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,100,111,117,98,108,101,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,71,69,77,77,58,58,115,117,98,116,114,97,99,116,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,71,69,77,77,58,58,97,100,100,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,78,50,99,118,49,48,77,97,116,79,112,95,71,69,77,77,69,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,65,100,100,69,120,58,58,116,114,97,110,115,112,111,115,101,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,66,105,110,58,58,100,105,118,105,100,101,40,100,111,117,98,108,101,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,66,105,110,58,58,109,117,108,116,105,112,108,121,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,100,111,117,98,108,101,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,85,110,107,110,111,119,110,32,111,112,101,114,97,116,105,111,110,0,78,50,99,118,57,77,97,116,79,112,95,66,105,110,69,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,65,100,100,69,120,58,58,97,98,115,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,65,100,100,69,120,58,58,100,105,118,105,100,101,40,100,111,117,98,108,101,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,65,100,100,69,120,58,58,109,117,108,116,105,112,108,121,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,100,111,117,98,108,101,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,65,100,100,69,120,58,58,115,117,98,116,114,97,99,116,40,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,65,100,100,69,120,58,58,97,100,100,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,78,50,99,118,49,49,77,97,116,79,112,95,65,100,100,69,120,69,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,84,58,58,116,114,97,110,115,112,111,115,101,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,84,58,58,109,117,108,116,105,112,108,121,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,100,111,117,98,108,101,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,78,50,99,118,55,77,97,116,79,112,95,84,69,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,58,58,116,114,97,110,115,112,111,115,101,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,58,58,97,98,115,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,58,58,100,105,118,105,100,101,40,100,111,117,98,108,101,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,58,58,100,105,118,105,100,101,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,100,111,117,98,108,101,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,58,58,109,117,108,116,105,112,108,121,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,100,111,117,98,108,101,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,58,58,109,117,108,116,105,112,108,121,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,100,111,117,98,108,101,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,58,58,115,117,98,116,114,97,99,116,40,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,58,58,115,117,98,116,114,97,99,116,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,58,58,97,100,100,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,58,58,97,100,100,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,78,50,99,118,53,77,97,116,79,112,69,0,78,50,99,118,57,77,97,116,79,112,95,67,109,112,69,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,79,112,95,73,110,105,116,105,97,108,105,122,101,114,58,58,109,117,108,116,105,112,108,121,40,99,111,110,115,116,32,99,118,58,58,77,97,116,69,120,112,114,32,38,44,32,100,111,117,98,108,101,44,32,99,118,58,58,77,97,116,69,120,112,114,32,38,41,32,99,111,110,115,116,0,73,110,118,97,108,105,100,32,109,97,116,114,105,120,32,105,110,105,116,105,97,108,105,122,101,114,32,116,121,112,101,0,78,50,99,118,49,55,77,97,116,79,112,95,73,110,105,116,105,97,108,105,122,101,114,69,0,99,118,58,58,77,97,116,69,120,112,114,32,99,118,58,58,97,98,115,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,38,41,0,105,110,116,32,99,118,58,58,77,97,116,69,120,112,114,58,58,116,121,112,101,40,41,32,99,111,110,115,116,0,99,118,58,58,77,97,116,69,120,112,114,32,99,118,58,58,77,97,116,58,58,116,40,41,32,99,111,110,115,116,0,99,118,58,58,77,97,116,69,120,112,114,32,99,118,58,58,77,97,116,58,58,105,110,118,40,105,110,116,41,32,99,111,110,115,116,0,99,118,58,58,77,97,116,69,120,112,114,32,99,118,58,58,77,97,116,58,58,109,117,108,40,73,110,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,41,32,99,111,110,115,116,0,115,116,97,116,105,99,32,99,118,58,58,77,97,116,69,120,112,114,32,99,118,58,58,77,97,116,58,58,122,101,114,111,115,40,105,110,116,44,32,105,110,116,44,32,105,110,116,41,0,115,116,97,116,105,99,32,99,118,58,58,77,97,116,69,120,112,114,32,99,118,58,58,77,97,116,58,58,122,101,114,111,115,40,83,105,122,101,44,32,105,110,116,41,0,115,116,97,116,105,99,32,99,118,58,58,77,97,116,69,120,112,114,32,99,118,58,58,77,97,116,58,58,111,110,101,115,40,105,110,116,44,32,105,110,116,44,32,105,110,116,41,0,115,116,97,116,105,99,32,99,118,58,58,77,97,116,69,120,112,114,32,99,118,58,58,77,97,116,58,58,111,110,101,115,40,83,105,122,101,44,32,105,110,116,41,0,115,116,97,116,105,99,32,99,118,58,58,77,97,116,69,120,112,114,32,99,118,58,58,77,97,116,58,58,101,121,101,40,105,110,116,44,32,105,110,116,44,32,105,110,116,41,0,115,116,97,116,105,99,32,99,118,58,58,77,97,116,69,120,112,114,32,99,118,58,58,77,97,116,58,58,101,121,101,40,83,105,122,101,44,32,105,110,116,41,0,78,50,99,118,50,53,68,117,109,109,121,66,117,102,102,101,114,80,111,111,108,67,111,110,116,114,111,108,108,101,114,69,0,115,122,91,105,93,32,60,61,32,40,115,105,122,101,95,116,41,73,78,84,95,77,65,88,0,99,111,112,121,0,117,45,62,117,114,101,102,99,111,117,110,116,32,61,61,32,48,0,100,101,97,108,108,111,99,97,116,101,0,117,45,62,114,101,102,99,111,117,110,116,32,61,61,32,48,0,116,111,116,97,108,32,60,61,32,115,116,101,112,91,105,93,0,97,108,108,111,99,97,116,101,0,78,50,99,118,49,53,83,116,100,77,97,116,65,108,108,111,99,97,116,111,114,69,0,48,32,60,61,32,95,100,105,109,115,32,38,38,32,95,100,105,109,115,32,60,61,32,67,86,95,77,65,88,95,68,73,77,0,115,101,116,83,105,122,101,0,115,32,62,61,32,48,0,83,116,101,112,32,109,117,115,116,32,98,101,32,97,32,109,117,108,116,105,112,108,101,32,111,102,32,101,115,122,49,0,84,104,101,32,116,111,116,97,108,32,109,97,116,114,105,120,32,115,105,122,101,32,100,111,101,115,32,110,111,116,32,102,105,116,32,116,111,32,34,115,105,122,101,95,116,34,32,116,121,112,101,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,109,97,116,114,105,120,46,99,112,112,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,77,97,116,65,108,108,111,99,97,116,111,114,58,58,99,111,112,121,40,99,118,58,58,85,77,97,116,68,97,116,97,32,42,44,32,99,118,58,58,85,77,97,116,68,97,116,97,32,42,44,32,105,110,116,44,32,99,111,110,115,116,32,115,105,122,101,95,116,32,42,44,32,99,111,110,115,116,32,115,105,122,101,95,116,32,42,44,32,99,111,110,115,116,32,115,105,122,101,95,116,32,42,44,32,99,111,110,115,116,32,115,105,122,101,95,116,32,42,44,32,99,111,110,115,116,32,115,105,122,101,95,116,32,42,44,32,98,111,111,108,41,32,99,111,110,115,116,0,117,112,108,111,97,100,0,100,111,119,110,108,111,97,100,0,78,50,99,118,49,50,77,97,116,65,108,108,111,99,97,116,111,114,69,0,48,32,60,61,32,100,32,38,38,32,100,32,60,61,32,67,86,95,77,65,88,95,68,73,77,32,38,38,32,95,115,105,122,101,115,0,117,32,33,61,32,48,0,115,116,101,112,91,100,105,109,115,45,49,93,32,61,61,32,40,115,105,122,101,95,116,41,67,86,95,69,76,69,77,95,83,73,90,69,40,102,108,97,103,115,41,0,109,46,100,105,109,115,32,62,61,32,50,0,48,32,60,61,32,95,114,111,119,82,97,110,103,101,46,115,116,97,114,116,32,38,38,32,95,114,111,119,82,97,110,103,101,46,115,116,97,114,116,32,60,61,32,95,114,111,119,82,97,110,103,101,46,101,110,100,32,38,38,32,95,114,111,119,82,97,110,103,101,46,101,110,100,32,60,61,32,109,46,114,111,119,115,0,48,32,60,61,32,95,99,111,108,82,97,110,103,101,46,115,116,97,114,116,32,38,38,32,95,99,111,108,82,97,110,103,101,46,115,116,97,114,116,32,60,61,32,95,99,111,108,82,97,110,103,101,46,101,110,100,32,38,38,32,95,99,111,108,82,97,110,103,101,46,101,110,100,32,60,61,32,109,46,99,111,108,115,0,114,97,110,103,101,115,0,114,32,61,61,32,82,97,110,103,101,58,58,97,108,108,40,41,32,124,124,32,40,48,32,60,61,32,114,46,115,116,97,114,116,32,38,38,32,114,46,115,116,97,114,116,32,60,32,114,46,101,110,100,32,38,38,32,114,46,101,110,100,32,60,61,32,109,46,115,105,122,101,91,105,93,41,0,48,32,60,61,32,114,111,105,46,120,32,38,38,32,48,32,60,61,32,114,111,105,46,119,105,100,116,104,32,38,38,32,114,111,105,46,120,32,43,32,114,111,105,46,119,105,100,116,104,32,60,61,32,109,46,99,111,108,115,32,38,38,32,48,32,60,61,32,114,111,105,46,121,32,38,38,32,48,32,60,61,32,114,111,105,46,104,101,105,103,104,116,32,38,38,32,114,111,105,46,121,32,43,32,114,111,105,46,104,101,105,103,104,116,32,60,61,32,109,46,114,111,119,115,0,40,105,110,116,41,114,97,110,103,101,115,46,115,105,122,101,40,41,32,61,61,32,100,0,100,105,109,115,32,60,61,32,50,0,100,105,97,103,0,40,105,110,116,41,110,101,108,101,109,115,32,62,61,32,48,0,114,101,115,101,114,118,101,0,100,105,109,115,32,60,61,32,50,32,38,38,32,115,116,101,112,91,48,93,32,62,32,48,0,108,111,99,97,116,101,82,79,73,0,97,100,106,117,115,116,82,79,73,0,114,101,115,104,97,112,101,0,95,99,110,32,62,61,32,48,32,38,38,32,95,110,101,119,110,100,105,109,115,32,62,32,48,32,38,38,32,95,110,101,119,110],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+204801);allocate([100,105,109,115,32,60,61,32,67,86,95,77,65,88,95,68,73,77,32,38,38,32,95,110,101,119,115,122,0,95,99,110,32,60,61,32,67,86,95,67,78,95,77,65,88,0,95,110,101,119,115,122,91,105,93,32,62,61,32,48,0,67,111,112,121,32,100,105,109,101,110,115,105,111,110,32,40,119,104,105,99,104,32,104,97,115,32,122,101,114,111,32,115,105,122,101,41,32,105,115,32,110,111,116,32,112,114,101,115,101,110,116,32,105,110,32,115,111,117,114,99,101,32,109,97,116,114,105,120,0,82,101,113,117,101,115,116,101,100,32,97,110,100,32,115,111,117,114,99,101,32,109,97,116,114,105,99,101,115,32,104,97,118,101,32,100,105,102,102,101,114,101,110,116,32,99,111,117,110,116,32,111,102,32,101,108,101,109,101,110,116,115,0,82,101,115,104,97,112,105,110,103,32,111,102,32,110,45,100,105,109,101,110,115,105,111,110,97,108,32,110,111,110,45,99,111,110,116,105,110,117,111,117,115,32,109,97,116,114,105,99,101,115,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,121,101,116,0,101,109,112,116,121,40,41,0,100,46,99,111,108,115,32,61,61,32,49,32,124,124,32,100,46,114,111,119,115,32,61,61,32,49,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,53,79,99,118,68,102,116,66,97,115,105,99,73,109,112,108,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,99,46,102,97,99,116,111,114,115,91,48,93,32,61,61,32,99,46,102,97,99,116,111,114,115,91,99,46,110,102,45,49,93,0,68,70,84,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,100,120,116,46,99,112,112,0,0,128,64,192,32,160,96,224,16,144,80,208,48,176,112,240,8,136,72,200,40,168,104,232,24,152,88,216,56,184,120,248,4,132,68,196,36,164,100,228,20,148,84,212,52,180,116,244,12,140,76,204,44,172,108,236,28,156,92,220,60,188,124,252,2,130,66,194,34,162,98,226,18,146,82,210,50,178,114,242,10,138,74,202,42,170,106,234,26,154,90,218,58,186,122,250,6,134,70,198,38,166,102,230,22,150,86,214,54,182,118,246,14,142,78,206,46,174,110,238,30,158,94,222,62,190,126,254,1,129,65,193,33,161,97,225,17,145,81,209,49,177,113,241,9,137,73,201,41,169,105,233,25,153,89,217,57,185,121,249,5,133,69,197,37,165,101,229,21,149,85,213,53,181,117,245,13,141,77,205,45,173,109,237,29,157,93,221,61,189,125,253,3,131,67,195,35,163,99,227,19,147,83,211,51,179,115,243,11,139,75,203,43,171,107,235,27,155,91,219,59,187,123,251,7,135,71,199,39,167,103,231,23,151,87,215,55,183,119,247,15,143,79,207,47,175,111,239,31,159,95,223,63,191,127,255,78,50,99,118,49,53,79,99,118,68,102,116,66,97,115,105,99,73,109,112,108,69,0,78,50,99,118,51,104,97,108,53,68,70,84,49,68,69,0,78,50,99,118,49,54,82,101,112,108,97,99,101,109,101,110,116,68,70,84,49,68,69,0,84,104,105,115,32,109,111,100,101,32,40,117,115,105,110,103,32,110,111,110,122,101,114,111,95,114,111,119,115,32,119,105,116,104,32,97,32,115,105,110,103,108,101,45,99,111,108,117,109,110,32,109,97,116,114,105,120,41,32,98,114,101,97,107,115,32,116,104,101,32,102,117,110,99,116,105,111,110,39,115,32,108,111,103,105,99,44,32,115,111,32,105,116,32,105,115,32,112,114,111,104,105,98,105,116,101,100,46,10,70,111,114,32,102,97,115,116,32,99,111,110,118,111,108,117,116,105,111,110,47,99,111,114,114,101,108,97,116,105,111,110,32,117,115,101,32,50,45,99,111,108,117,109,110,32,109,97,116,114,105,120,32,111,114,32,115,105,110,103,108,101,45,114,111,119,32,109,97,116,114,105,120,32,105,110,115,116,101,97,100,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,48,79,99,118,68,102,116,73,109,112,108,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,78,50,99,118,49,48,79,99,118,68,102,116,73,109,112,108,69,0,78,50,99,118,51,104,97,108,53,68,70,84,50,68,69,0,78,50,99,118,49,54,82,101,112,108,97,99,101,109,101,110,116,68,70,84,50,68,69,0,116,121,112,101,32,61,61,32,67,86,95,51,50,70,67,49,32,124,124,32,116,121,112,101,32,61,61,32,67,86,95,51,50,70,67,50,32,124,124,32,116,121,112,101,32,61,61,32,67,86,95,54,52,70,67,49,32,124,124,32,116,121,112,101,32,61,61,32,67,86,95,54,52,70,67,50,0,100,102,116,0,33,40,40,102,108,97,103,115,32,38,32,68,70,84,95,67,79,77,80,76,69,88,95,73,78,80,85,84,41,32,38,38,32,115,114,99,46,99,104,97,110,110,101,108,115,40,41,32,33,61,32,50,41,0,118,111,105,100,32,99,118,58,58,100,102,116,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,41,0,116,121,112,101,32,61,61,32,115,114,99,66,46,116,121,112,101,40,41,32,38,38,32,115,114,99,65,46,115,105,122,101,40,41,32,61,61,32,115,114,99,66,46,115,105,122,101,40,41,0,109,117,108,83,112,101,99,116,114,117,109,115,0,118,111,105,100,32,99,118,58,58,109,117,108,83,112,101,99,116,114,117,109,115,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,98,111,111,108,41,0,115,114,99,32,38,38,32,110,115,114,99,115,32,62,32,48,32,38,38,32,100,115,116,32,38,38,32,110,100,115,116,115,32,62,32,48,32,38,38,32,102,114,111,109,84,111,32,38,38,32,110,112,97,105,114,115,32,62,32,48,0,109,105,120,67,104,97,110,110,101,108,115,0,106,32,60,32,110,115,114,99,115,32,38,38,32,115,114,99,91,106,93,46,100,101,112,116,104,40,41,32,61,61,32,100,101,112,116,104,0,105,49,32,62,61,32,48,32,38,38,32,106,32,60,32,110,100,115,116,115,32,38,38,32,100,115,116,91,106,93,46,100,101,112,116,104,40,41,32,61,61,32,100,101,112,116,104,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,99,104,97,110,110,101,108,115,46,99,112,112,0,118,111,105,100,32,99,118,58,58,109,105,120,67,104,97,110,110,101,108,115,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,42,44,32,115,105,122,101,95,116,44,32,99,118,58,58,77,97,116,32,42,44,32,115,105,122,101,95,116,44,32,99,111,110,115,116,32,105,110,116,32,42,44,32,115,105,122,101,95,116,41,0,102,114,111,109,84,111,46,115,105,122,101,40,41,37,50,32,61,61,32,48,32,38,38,32,110,115,114,99,32,62,32,48,32,38,38,32,110,100,115,116,32,62,32,48,0,118,111,105,100,32,99,118,58,58,109,105,120,67,104,97,110,110,101,108,115,40,73,110,112,117,116,65,114,114,97,121,79,102,65,114,114,97,121,115,44,32,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,79,102,65,114,114,97,121,115,44,32,99,111,110,115,116,32,115,116,100,58,58,118,101,99,116,111,114,60,105,110,116,62,32,38,41,0,48,32,60,61,32,99,111,105,32,38,38,32,99,111,105,32,60,32,99,110,0,101,120,116,114,97,99,116,67,104,97,110,110,101,108,0,118,111,105,100,32,99,118,58,58,101,120,116,114,97,99,116,67,104,97,110,110,101,108,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,105,110,116,32,99,118,58,58,104,97,108,58,58,110,111,114,109,72,97,109,109,105,110,103,40,99,111,110,115,116,32,117,99,104,97,114,32,42,44,32,105,110,116,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,115,116,97,116,46,100,105,115,112,97,116,99,104,46,99,112,112,0,105,110,116,32,99,118,58,58,104,97,108,58,58,110,111,114,109,72,97,109,109,105,110,103,40,99,111,110,115,116,32,117,99,104,97,114,32,42,44,32,99,111,110,115,116,32,117,99,104,97,114,32,42,44,32,105,110,116,41,0,99,111,110,118,101,114,116,65,110,100,85,110,114,111,108,108,83,99,97,108,97,114,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,97,114,105,116,104,109,46,99,112,112,0,84,104,101,32,111,112,101,114,97,116,105,111,110,32,105,115,32,110,101,105,116,104,101,114,32,39,97,114,114,97,121,32,111,112,32,97,114,114,97,121,39,32,40,119,104,101,114,101,32,97,114,114,97,121,115,32,104,97,118,101,32,116,104,101,32,115,97,109,101,32,115,105,122,101,32,97,110,100,32,116,121,112,101,41,44,32,110,111,114,32,39,97,114,114,97,121,32,111,112,32,115,99,97,108,97,114,39,44,32,110,111,114,32,39,115,99,97,108,97,114,32,111,112,32,97,114,114,97,121,39,0,98,105,110,97,114,121,95,111,112,0,112,115,114,99,49,45,62,115,97,109,101,83,105,122,101,40,42,112,115,114,99,50,41,32,38,38,32,116,121,112,101,49,32,61,61,32,116,121,112,101,50,0,40,109,116,121,112,101,32,61,61,32,67,86,95,56,85,32,124,124,32,109,116,121,112,101,32,61,61,32,67,86,95,56,83,41,32,38,38,32,95,109,97,115,107,46,115,97,109,101,83,105,122,101,40,42,112,115,114,99,49,41,0,118,111,105,100,32,99,118,58,58,98,105,116,119,105,115,101,95,97,110,100,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,98,105,116,119,105,115,101,95,111,114,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,98,105,116,119,105,115,101,95,120,111,114,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,98,105,116,119,105,115,101,95,110,111,116,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,109,97,120,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,109,105,110,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,109,97,120,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,38,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,32,38,44,32,99,118,58,58,77,97,116,32,38,41,0,118,111,105,100,32,99,118,58,58,109,105,110,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,38,44,32,99,111,110,115,116,32,99,118,58,58,77,97,116,32,38,44,32,99,118,58,58,77,97,116,32,38,41,0,84,104,101,32,111,112,101,114,97,116,105,111,110,32,105,115,32,110,101,105,116,104,101,114,32,39,97,114,114,97,121,32,111,112,32,97,114,114,97,121,39,32,40,119,104,101,114,101,32,97,114,114,97,121,115,32,104,97,118,101,32,116,104,101,32,115,97,109,101,32,115,105,122,101,32,97,110,100,32,116,104,101,32,115,97,109,101,32,110,117,109,98,101,114,32,111,102,32,99,104,97,110,110,101,108,115,41,44,32,110,111,114,32,39,97,114,114,97,121,32,111,112,32,115,99,97,108,97,114,39,44,32,110,111,114,32,39,115,99,97,108,97,114,32,111,112,32,97,114,114,97,121,39,0,97,114,105,116,104,109,95,111,112,0,116,121,112,101,50,32,61,61,32,67,86,95,54,52,70,32,38,38,32,40,115,122,50,46,104,101,105,103,104,116,32,61,61,32,49,32,124,124,32,115,122,50,46,104,101,105,103,104,116,32,61,61,32,52,41,0,87,104,101,110,32,116,104,101,32,105,110,112,117,116,32,97,114,114,97,121,115,32,105,110,32,97,100,100,47,115,117,98,116,114,97,99,116,47,109,117,108,116,105,112,108,121,47,100,105,118,105,100,101,32,102,117,110,99,116,105,111,110,115,32,104,97,118,101,32,100,105,102,102,101,114,101,110,116,32,116,121,112,101,115,44,32,116,104,101,32,111,117,116,112,117,116,32,97,114,114,97,121,32,116,121,112,101,32,109,117,115,116,32,98,101,32,101,120,112,108,105,99,105,116,108,121,32,115,112,101,99,105,102,105,101,100,0,40,109,116,121,112,101,32,61,61,32,67,86,95,56,85,67,49,32,124,124,32,109,116,121,112,101,32,61,61,32,67,86,95,56,83,67,49,41,32,38,38,32,95,109,97,115,107,46,115,97,109,101,83,105,122,101,40,42,112,115,114,99,49,41,0,118,111,105,100,32,99,118,58,58,97,100,100,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,115,117,98,116,114,97,99,116,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,97,98,115,100,105,102,102,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,118,111,105,100,32,99,118,58,58,109,117,108,116,105,112,108,121,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,100,105,118,105,100,101,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,100,105,118,105,100,101,40,100,111,117,98,108,101,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,97,100,100,87,101,105,103,104,116,101,100,40,73,110,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,73,110,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,111,112,32,61,61,32,67,77,80,95,76,84,32,124,124,32,111,112,32,61,61,32,67,77,80,95,76,69,32,124,124,32,111,112,32,61,61,32,67,77,80,95,69,81,32,124,124,32,111,112,32,61,61,32,67,77,80,95,78,69,32,124,124,32,111,112,32,61,61,32,67,77,80,95,71,69,32,124,124,32,111,112,32,61,61,32,67,77,80,95,71,84,0,99,111,109,112,97,114,101,0,95,115,114,99,49,46,101,109,112,116,121,40,41,32,61,61,32,95,115,114,99,50,46,101,109,112,116,121,40,41,0,84,104,101,32,111,112,101,114,97,116,105,111,110,32,105,115,32,110,101,105,116,104,101,114,32,39,97,114,114,97,121,32,111,112,32,97,114,114,97,121,39,32,40,119,104,101,114,101,32,97,114,114,97,121,115,32,104,97,118,101,32,116,104,101,32,115,97,109,101,32,115,105,122,101,32,97,110,100,32,116,104,101,32,115,97,109,101,32,116,121,112,101,41,44,32,110,111,114,32,39,97,114,114,97,121,32,111,112,32,115,99,97,108,97,114,39,44,32,110,111,114,32,39,115,99,97,108,97,114,32,111,112,32,97,114,114,97,121,39,0,118,111,105,100,32,99,118,58,58,99,111,109,112,97,114,101,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,33,32,95,115,114,99,46,101,109,112,116,121,40,41,0,105,110,82,97,110,103,101,0,84,104,101,32,108,111,119,101,114,32,98,111,117,110,100,97,114,121,32,105,115,32,110,101,105,116,104,101,114,32,97,110,32,97,114,114,97,121,32,111,102,32,116,104,101,32,115,97,109,101,32,115,105,122,101,32,97,110,100,32,115,97,109,101,32,116,121,112,101,32,97,115,32,115,114,99,44,32,110,111,114,32,97,32,115,99,97,108,97,114,0,84,104,101,32,117,112,112,101,114,32,98,111,117,110,100,97,114,121,32,105,115,32,110,101,105,116,104,101,114,32,97,110,32,97,114,114,97,121,32,111,102,32,116,104,101,32,115,97,109,101,32,115,105,122,101,32,97,110,100,32,115,97,109,101,32,116,121,112,101,32,97,115,32,115,114,99,44,32,110,111,114,32,97,32,115,99,97,108,97,114,0,108,98,83,99,97,108,97,114,32,61,61,32,117,98,83,99,97,108,97,114,0,108,98,46,116,121,112,101,40,41,32,61,61,32,117,98,46,116,121,112,101,40,41,0,118,111,105,100,32,99,118,58,58,105,110,82,97,110,103,101,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,78,50,99,118,57,70,111,114,109,97,116,116,101,100,69,0,78,50,99,118,57,70,111,114,109,97,116,116,101,114,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,48,67,70,111,114,109,97,116,116,101,114,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,0,0,44,0,0,123,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,51,70,111,114,109,97,116,116,101,100,73,109,112,108,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,109,46,100,105,109,115,32,60,61,32,50,0,70,111,114,109,97,116,116,101,100,73,109,112,108,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,111,117,116,46,99,112,112,0,37,37,46,37,100,103,0,37,51,100,0,10,40,58,44,32,58,44,32,37,100,41,32,61,32,10,0,40,58,44,32,58,44,32,37,100,41,32,61,32,10,0,78,50,99,118,49,51,70,111,114,109,97,116,116,101,100,73,109,112,108,69,0,78,50,99,118,49,48,67,70,111,114,109,97,116,116,101,114,69,0,78,50,99,118,49,51,70,111,114,109,97,116,116,101,114,66,97,115,101,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,52,78,117,109,112,121,70,111,114,109,97,116,116,101,114,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,91,93,44,91,93,93,44,32,100,116,121,112,101,61,39,37,115,39,41,0,97,114,114,97,121,40,91,0,117,105,110,116,56,0,105,110,116,56,0,117,105,110,116,49,54,0,105,110,116,49,54,0,102,108,111,97,116,51,50,0,102,108,111,97,116,54,52,0,78,50,99,118,49,52,78,117,109,112,121,70,111,114,109,97,116,116,101,114,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,53,80,121,116,104,111,110,70,111,114,109,97,116,116,101,114,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,78,50,99,118,49,53,80,121,116,104,111,110,70,111,114,109,97,116,116,101,114,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,67,83,86,70,111,114,109,97,116,116,101,114,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,78,50,99,118,49,50,67,83,86,70,111,114,109,97,116,116,101,114,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,53,77,97,116,108,97,98,70,111,114,109,97,116,116,101,114,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,0,0,59,0,0,78,50,99,118,49,53,77,97,116,108,97,98,70,111,114,109,97,116,116,101,114,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,68,101,102,97,117,108,116,70,111,114,109,97,116,116,101,114,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,78,50,99,118,49,54,68,101,102,97,117,108,116,70,111,114,109,97,116,116,101,114,69,0,84,104,101,32,108,105,98,114,97,114,121,32,105,115,32,99,111,109,112,105,108,101,100,32,119,105,116,104,111,117,116,32,67,85,68,65,32,115,117,112,112,111,114,116,0,116,104,114,111,119,95,110,111,95,99,117,100,97,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,105,110,99,108,117,100,101,47,111,112,101,110,99,118,50,47,99,111,114,101,47,112,114,105,118,97,116,101,46,99,117,100,97,46,104,112,112,0,78,50,99,118,49,54,80,97,114,97,108,108,101,108,76,111,111,112,66,111,100,121,69,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,97,114,114,97,121,46,99,112,112,0,68,97,116,97,32,105,115,32,97,108,114,101,97,100,121,32,97,108,108,111,99,97,116,101,100,0,99,118,67,114,101,97,116,101,68,97,116,97,0,84,111,111,32,98,105,103,32,98,117,102,102,101,114,32,105,115,32,97,108,108,111,99,97,116,101,100,0,79,118,101,114,102,108,111,119,32,102,111,114,32,105,109,97,103,101,83,105,122,101,0,117,110,114,101,99,111,103,110,105,122,101,100,32,111,114,32,117,110,115,117,112,112,111,114,116,101,100,32,97,114,114,97,121,32,116,121,112,101,0,78,111,110,45,112,111,115,105,116,105,118,101,32,119,105,100,116,104,32,111,114,32,104,101,105,103,104,116,0,99,118,67,114,101,97,116,101,77,97,116,72,101,97,100,101,114,0,73,110,118,97,108,105,100,32,109,97,116,114,105,120,32,116,121,112,101,0,99,118,73,110,105,116,77,97,116,72,101,97,100,101,114,0,78,111,110,45,112,111,115,105,116,105,118,101,32,99,111,108,115,32,111,114,32,114,111,119,115,0,99,118,82,101,108,101,97,115,101,77,97,116,0,66,97,100,32,67,118,77,97,116,32,104,101,97,100,101,114,0,99,118,67,108,111,110,101,77,97,116,0,78,85,76,76,32,109,97,116,114,105,120,32,104,101,97,100,101,114,32,112,111,105,110,116,101,114,0,99,118,73,110,105,116,77,97,116,78,68,72,101,97,100,101,114,0,105,110,118,97,108,105,100,32,97,114,114,97,121,32,100,97,116,97,32,116,121,112,101,0,78,85,76,76,32,60,115,105,122,101,115,62,32,112,111,105,110,116,101,114,0,110,111,110,45,112,111,115,105,116,105,118,101,32,111,114,32,116,111,111,32,108,97,114,103,101,32,110,117,109,98,101,114,32,111,102,32,100,105,109,101,110,115,105,111,110,115,0,111,110,101,32,111,102,32,100,105,109,101,115,105,111,110,32,115,105,122,101,115,32,105,115,32,110,111,110,45,112,111,115,105,116,105,118,101,0,84,104,101,32,97,114,114,97,121,32,105,115,32,116,111,111,32,98,105,103,0,99,118,67,114,101,97,116,101,77,97,116,78,68,72,101,97,100,101,114,0,66,97,100,32,67,118,77,97,116,78,68,32,104,101,97,100,101,114,0,99,118,67,108,111,110,101,77,97,116,78,68,0,115,114,99,45,62,100,105,109,115,32,60,61,32,67,86,95,77,65,88,95,68,73,77,0,95,100,115,116,46,100,97,116,97,32,61,61,32,100,97,116,97,48,0,73,110,99,111,114,114,101,99,116,32,110,117,109,98,101,114,32,111,102,32,97,114,114,97,121,115,0,99,118,73,110,105,116,78,65,114,114,97,121,73,116,101,114,97,116,111,114,0,83,111,109,101,32,111,102,32,114,101,113,117,105,114,101,100,32,97,114,114,97,121,32,112,111,105,110,116,101,114,115,32,105,115,32,78,85,76,76,0,73,116,101,114,97,116,111,114,32,112,111,105,110,116,101,114,32,105,115,32,78,85,76,76,0,73,116,101,114,97,116,111,114,32,119,105,116,104,32,109,97,115,107,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,67,79,73,32,115,101,116,32,105,115,32,110,111,116,32,97,108,108,111,119,101,100,32,104,101,114,101,0,78,117,109,98,101,114,32,111,102,32,100,105,109,101,110,115,105,111,110,115,32,105,115,32,116,104,101,32,115,97,109,101,32,102,111,114,32,97,108,108,32,97,114,114,97,121,115,0,68,97,116,97,32,116,121,112,101,32,105,115,32,110,111,116,32,116,104,101,32,115,97,109,101,32,102,111,114,32,97,108,108,32,97,114,114,97,121,115,0,78,117,109,98,101,114,32,111,102,32,99,104,97,110,110,101,108,115,32,105,115,32,110,111,116,32,116,104,101,32,115,97,109,101,32,102,111,114,32,97,108,108,32,97,114,114,97,121,115,0,68,101,112,116,104,32,105,115,32,110,111,116,32,116,104,101,32,115,97,109,101,32,102,111,114,32,97,108,108,32,97,114,114,97,121,115,0,68,105,109,101,110,115,105,111,110,32,115,105,122,101,115,32,97,114,101,32,116,104,101,32,115,97,109,101,32,102,111,114,32,97,108,108,32,97,114,114,97,121,115,0,78,85,76,76,32,97,114,114,97,121,32,112,111,105,110,116,101,114,32,105,115,32,112,97,115,115,101,100,0,99,118,71,101,116,77,97,116,78,68,0,84,104,101,32,109,97,116,114,105,120,32,104,97,115,32,78,85,76,76,32,100,97,116,97,32,112,111,105,110,116,101,114,0,85,110,114,101,99,111,103,110,105,122,101,100,32,111,114,32,117,110,115,117,112,112,111,114,116,101,100,32,97,114,114,97,121,32,116,121,112,101,0,73,110,112,117,116,32,97,114,114,97,121,32,104,97,115,32,78,85,76,76,32,100,97,116,97,32,112,111,105,110,116,101,114,0,99,118,71,101,116,77,97,116,0,84,104,101,32,105,109,97,103,101,32,104,97,115,32,78,85,76,76,32,100,97,116,97,32,112,111,105,110,116,101,114,0,73,109,97,103,101,115,32,119,105,116,104,32,112,108,97,110,97,114,32,100,97,116,97,32,108,97,121,111,117,116,32,115,104,111,117,108,100,32,98,101,32,117,115,101,100,32,119,105,116,104,32,67,79,73,32,115,101,108,101,99,116,101,100,0,84,104,101,32,105,109,97,103,101,32,105,115,32,105,110,116,101,114,108,101,97,118,101,100,32,97,110,100,32,104,97,115,32,111,118,101,114,32,67,86,95,67,78,95,77,65,88,32,99,104,97,110,110,101,108,115,0,80,105,120,101,108,32,111,114,100,101,114,32,115,104,111,117,108,100,32,98,101,32,117,115,101,100,32,119,105,116,104,32,99,111,105,32,61,61,32,48,0,79,110,108,121,32,99,111,110,116,105,110,117,111,117,115,32,110,68,32,97,114,114,97,121,115,32,97,114,101,32,115,117,112,112,111,114,116,101,100,32,104,101,114,101,0,99,118,67,114,101,97,116,101,83,112,97,114,115,101,77,97,116,0,98,97,100,32,110,117,109,98,101,114,32,111,102,32,100,105,109,101,110,115,105,111,110,115,0,99,118,82,101,108,101,97,115,101,83,112,97,114,115,101,77,97,116,0,73,110,118,97,108,105,100,32,115,112,97,114,115,101,32,97,114,114,97,121,32,104,101,97,100,101,114,0,99,118,67,108,111,110,101,83,112,97,114,115,101,77,97,116,0,73,110,118,97,108,105,100,32,115,112,97,114,115,101,32,109,97,116,114,105,120,32,104,101,97,100,101,114,0,99,118,73,110,105,116,83,112,97,114,115,101,77,97,116,73,116,101,114,97,116,111,114,0,78,85,76,76,32,105,116,101,114,97,116,111,114,32,112,111,105,110,116,101,114,0,99,118,82,101,108,101,97,115,101,68,97,116,97,0,105,110,100,101,120,32,105,115,32,111,117,116,32,111,102,32,114,97,110,103,101,0,99,118,80,116,114,50,68,0,67,79,73,32,109,117,115,116,32,98,101,32,110,111,110,45,110,117,108,108,32,105,110,32,99,97,115,101,32,111,102,32,112,108,97,110,97,114,32,105,109,97,103,101,115,0,40,40,67,118,83,112,97,114,115,101,77,97,116,42,41,97,114,114,41,45,62,100,105,109,115,32,61,61,32,50,0,79,110,101,32,111,102,32,105,110,100,105,99,101,115,32,105,115,32,111,117,116,32,111,102,32,114,97,110,103,101,0,105,99,118,71,101,116,78,111,100,101,80,116,114,0,99,118,71,101,116,69,108,101,109,84,121,112,101,0,99,118,71,101,116,68,105,109,115,0,65,114,114,97,121,32,115,104,111,117,108,100,32,98,101,32,67,118,77,97,116,32,111,114,32,73,112,108,73,109,97,103,101,0,99,118,71,101,116,83,105,122,101,0,78,85,76,76,32,112,111,105,110,116,101,114,32,116,111,32,105,110,100,105,99,101,115,0,99,118,80,116,114,78,68,0,84,104,101,32,116,111,116,97,108,32,110,117,109,98,101,114,32,111,102,32,109,97,116,114,105,120,32,101,108,101,109,101,110,116,115,32,105,115,32,110,111,116,32,100,105,118,105,115,105,98,108,101,32,98,121,32,116,104,101,32,110,101,119,32,110,117,109,98,101,114,32,111,102,32,114,111,119,115,0,99,118,82,101,115,104,97,112,101,0,84,104,101,32,109,97,116,114,105,120,32,105,115,32,110,111,116,32,99,111,110,116,105,110,117,111,117,115,44,32,116,104,117,115,32,105,116,115,32,110,117,109,98,101,114,32,111,102,32,114,111,119,115,32,99,97,110,32,110,111,116,32,98,101,32,99,104,97,110,103,101,100,0,66,97,100,32,110,101,119,32,110,117,109,98,101,114,32,111,102,32,114,111,119,115,0,84,104,101,32,116,111,116,97,108,32,119,105,100,116,104,32,105,115,32,110,111,116,32,100,105,118,105,115,105,98,108,101,32,98,121,32,116,104,101,32,110,101,119,32,110,117,109,98,101,114,32,111,102,32,99,104,97,110,110,101,108,115,0,110,117,108,108,32,112,111,105,110,116,101,114,32,116,111,32,104,101,97,100,101,114,0,99,118,73,110,105,116,73,109,97,103,101,72,101,97,100,101,114,0,66,97,100,32,105,110,112,117,116,32,114,111,105,0,85,110,115,117,112,112,111,114,116,101,100,32,102,111,114,109,97,116,0,66,97,100,32,105,110,112,117,116,32,111,114,105,103,105,110,0,66,97,100,32,105,110,112,117,116,32,97,108,105,103,110,0,71,82,65,89,0,82,71,66,0,66,71,82,0,66,71,82,65,0,99,118,82,101,108,101,97,115,101,73,109,97,103,101,0,99,118,83,101,116,73,109,97,103,101,82,79,73,0,114,101,99,116,46,119,105,100,116,104,32,62,61,32,48,32,38,38,32,114,101,99,116,46,104,101,105,103,104,116,32,62,61,32,48,32,38,38,32,114,101,99,116,46,120,32,60,32,105,109,97,103,101,45,62,119,105,100,116,104,32,38,38,32,114,101,99,116,46,121,32,60,32,105,109,97,103,101,45,62,104,101,105,103,104,116,32,38,38,32,114,101,99,116,46,120,32,43,32,114,101,99,116,46,119,105,100,116,104,32,62,61,32,40,105,110,116,41,40,114,101,99,116,46,119,105,100,116,104,32,62,32,48,41,32,38,38,32,114,101,99,116,46,121,32,43,32,114,101,99,116,46,104,101,105,103,104,116,32,62,61,32,40,105,110,116,41,40,114,101,99,116,46,104,101,105,103,104,116,32,62,32,48,41,0,99,118,83,101,116,73,109,97,103,101,67,79,73,0,99,118,71,101,116,73,109,97,103,101,67,79,73,0,66,97,100,32,105,109,97,103,101,32,104,101,97,100,101,114,0,99,118,67,108,111,110,101,73,109,97,103,101,0,99,110,32,60,61,32,52,0,115,99,97,108,97,114,84,111,82,97,119,68,97,116,97,0,118,111,105,100,32,99,118,58,58,115,99,97,108,97,114,84,111,82,97,119,68,97,116,97,40,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,118,111,105,100,32,42,44,32,105,110,116,44,32,105,110,116,41,0,84,104,101,32,115,116,111,114,97,103,101,32,105,115,32,110,111,116,32,111,112,101,110,101,100,0,105,99,118,80,117,116,115,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,112,101,114,115,105,115,116,101,110,99,101,46,99,112,112,0,106,32,60,32,109,97,120,67,111,117,110,116,32,45,32,49,32,38,38,32,34,79,112,101,110,67,86,32,112,101,114,115,105,115,116,101,110,99,101,32,100,111,101,115,110,39,116,32,115,117,112,112,111,114,116,32,118,101,114,121,32,108,111,110,103,32,108,105,110,101,115,34,0,105,99,118,71,101,116,115,0,115,122,32,60,32,40,115,105,122,101,95,116,41,40,109,97,120,67,111,117,110,116,32,45,32,49,41,32,38,38,32,34,79,112,101,110,67,86,32,112,101,114,115,105,115,116,101,110,99,101,32,100,111,101,115,110,39,116,32,115,117,112,112,111,114,116,32,118,101,114,121,32,108,111,110,103,32,108,105,110,101,115,34,0,84,111,111,32,115,109,97,108,108,32,109,97,112,32,104,101,97,100,101,114,95,115,105,122,101,0,99,118,67,114,101,97,116,101,77,97,112,0,37,115,40,37,100,41,58,32,37,115,0,105,99,118,70,83,67,114,101,97,116,101,67,111,108,108,101,99,116,105,111,110,0,105,99,118,67,108,111,115,101,0,60,47,111,112,101,110,99,118,95,115,116,111,114,97,103,101,62,10,0,37,100,46,0,37,46,49,54,101,0,46,78,97,110,0,45,46,73,110,102,0,46,73,110,102,0,37,46,56,101,0,105,99,118,80,114,111,99,101,115,115,83,112,101,99,105,97,108,68,111,117,98,108,101,0,66,97,100,32,102,111,114,109,97,116,32,111,102,32,102,108,111,97,116,105,110,103,45,112,111,105,110,116,32,99,111,110,115,116,97,110,116,0,85,110,101,120,112,101,99,116,101,100,32,101,114,114,111,114,44,32,117,110,97,98,108,101,32,116,111,32,100,101,116,101,114,109,105,110,101,32,116,104,101,32,66,97,115,101,54,52,32,115,116,97,116,101,46,0,115,119,105,116,99,104,95,116,111,95,66,97,115,101,54,52,95,115,116,97,116,101,0,85,110,101,120,112,101,99,116,101,100,32,101,114,114,111,114,44,32,117,110,97,98,108,101,32,116,111,32,115,119,105,116,99,104,32,116,111,32,116,104,105,115,32,115,116,97,116,101,46,0,102,115,45,62,105,115,95,119,114,105,116,101,95,115,116,114,117,99,116,95,100,101,108,97,121,101,100,32,61,61,32,102,97,108,115,101,0,109,97,107,101,95,119,114,105,116,101,95,115,116,114,117,99,116,95,100,101,108,97,121,101,100,0,100,101,112,116,104,32,62,61,48,32,38,38,32,100,101,112,116,104,32,60,32,57,0,105,99,118,84,121,112,101,83,121,109,98,111,108,0,117,99,119,115,105,102,100,114,0,73,110,118,97,108,105,100,32,100,97,116,97,32,116,121,112,101,32,115,112,101,99,105,102,105,99,97,116,105,111,110,0,105,99,118,68,101,99,111,100,101,70,111,114,109,97,116,0,105,99,118,83,121,109,98,111,108,84,111,84,121,112,101,0,84,111,111,32,108,111,110,103,32,100,97,116,97,32,116,121,112,101,32,115,112,101,99,105,102,105,99,97,116,105,111,110,0,84,111,111,32,99,111,109,112,108,101,120,32,102,111,114,109,97,116,32,102,111,114,32,116,104,101,32,109,97,116,114,105,120,0,105,99,118,68,101,99,111,100,101,83,105,109,112,108,101,70,111,114,109,97,116,0,98,97,115,101,54,52,0,78,85,76,76,32,111,114,32,101,109,112,116,121,32,102,105,108,101,110,97,109,101,0,78,85,76,76,32,111,114,32,101,109,112,116,121,32,98,117,102,102,101,114,0,99,118,79,112,101,110,70,105,108,101,83,116,111,114,97,103,101,0,67,86,95,83,84,79,82,65,71,69,95,65,80,80,69,78,68,32,97,110,100,32,67,86,95,83,84,79,82,65,71,69,95,77,69,77,79,82,89,32,97,114,101,32,110,111,116,32,99,117,114,114,101,110,116,108,121,32,99,111,109,112,97,116,105,98,108,101,0,65,112,112,101,110,100,105,110,103,32,100,97,116,97,32,116,111,32,99,111,109,112,114,101,115,115,101,100,32,102,105,108,101,32,105,115,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,97,43,116,0,119,116,0,114,116,0,85,84,70,45,49,54,0,117,116,102,45,49,54,0,85,116,102,45,49,54,0,85,84,70,45,49,54,32,88,77,76,32,101,110,99,111,100,105,110,103,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,33,32,85,115,101,32,56,45,98,105,116,32,101,110,99,111,100,105,110,103,10,0,115,116,114,108,101,110,40,101,110,99,111,100,105,110,103,41,32,60,32,49,48,48,48,0,60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,32,101,110,99,111,100,105,110,103,61,34,37,115,34,63,62,10,0,60,63,120,109,108,32,118,101,114,115,105,111,110,61,34,49,46,48,34,63,62,10,0,60,111,112,101,110,99,118,95,115,116,111,114,97,103,101,62,10,0,60,47,111,112,101,110,99,118,95,115,116,111,114,97,103,101,62,0,67,111,117,108,100,32,110,111,116,32,102,105,110,100,32,60,47,111,112,101,110,99,118,95,115,116,111,114,97,103,101,62,32,105,110,32,116,104,101,32,101,110,100,32,111,102,32,102,105,108,101,46,10,0,114,43,116,0,32,60,33,45,45,32,114,101,115,117,109,101,100,32,45,45,62,0,37,89,65,77,76,58,49,46,48,10,45,45,45,10,0,46,46,46,10,45,45,45,10,0,67,111,117,108,100,32,110,111,116,32,102,105,110,100,32,39,125,39,32,105,110,32,116,104,101,32,101,110,100,32,111,102,32,102,105,108,101,46,10,0,73,110,112,117,116,32,102,105,108,101,32,105,115,32,101,109,112,116,121,0,85,110,115,117,112,112,111,114,116,101,100,32,102,105,108,101,32,115,116,111,114,97,103,101,32,102,111,114,109,97,116,0,78,85,76,76,32,100,111,117,98,108,101,32,112,111,105,110,116,101,114,32,116,111,32,102,105,108,101,32,115,116,111,114,97,103,101,0,99,118,82,101,108,101,97,115,101,70,105,108,101,83,116,111,114,97,103,101,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,112,101,114,115,105,115,116,101,110,99,101,95,99,46,99,112,112,0,110,111,100,101,32,33,61,32,78,85,76,76,0,99,118,76,111,97,100,0,67,111,117,108,100,32,110,111,116,32,102,105,110,100,32,116,104,101,47,97,110,32,111,98,106,101,99,116,32,105,110,32,102,105,108,101,32,115,116,111,114,97,103,101,0,78,85,76,76,32,109,101,109,111,114,121,32,115,116,111,114,97,103,101,32,105,115,32,112,97,115,115,101,100,32,45,32,116,104,101,32,108,111,97,100,101,100,32,100,121,110,97,109,105,99,32,115,116,114,117,99,116,117,114,101,32,99,97,110,32,110,111,116,32,98,101,32,115,116,111,114,101,100,0,99,118,82,101,108,101,97,115,101,0,85,110,107,110,111,119,110,32,111,98,106,101,99,116,32,116,121,112,101,0,114,101,108,101,97,115,101,32,102,117,110,99,116,105,111,110,32,112,111,105,110,116,101,114,32,105,115,32,78,85,76,76,0,99,118,82,101,97,100,0,84,104,101,32,110,111,100,101,32,100,111,101,115,32,110,111,116,32,114,101,112,114,101,115,101,110,116,32,97,32,117,115,101,114,32,111,98,106,101,99,116,32,40,117,110,107,110,111,119,110,32,116,121,112,101,63,41,0,99,118,71,101,116,70,105,108,101,78,111,100,101,66,121,78,97,109,101,0,78,117,108,108,32,101,108,101,109,101,110,116,32,110,97,109,101,0,84,104,101,32,110,111,100,101,32,105,115,32,110,101,105,116,104,101,114,32,97,32,109,97,112,32,110,111,114,32,97,110,32,101,109,112,116,121,32,99,111,108,108,101,99,116,105,111,110,0,99,118,71,101,116,70,105,108,101,78,111,100,101,0,78,117,108,108,32,107,101,121,32,101,108,101,109,101,110,116,0,109,97,112,95,110,111,100,101,32,33,61,32,78,85,76,76,0,68,117,112,108,105,99,97,116,101,100,32,107,101,121,0,99,118,71,101,116,82,111,111,116,70,105,108,101,78,111,100,101,0,99,118,83,116,97,114,116,87,114,105,116,101,83,116,114,117,99,116,0,109,117,115,116,32,115,101,116,32,39],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+215041);allocate([115,116,114,117,99,116,95,102,108,97,103,115,32,124,61,32,67,86,95,78,79,68,69,95,83,69,81,39,32,105,102,32,117,115,105,110,103,32,66,97,115,101,54,52,46,0,102,117,110,99,116,105,111,110,32,39,99,118,83,116,97,114,116,87,114,105,116,101,83,116,114,117,99,116,39,32,99,97,108,108,115,32,99,97,110,110,111,116,32,98,101,32,110,101,115,116,101,100,32,105,102,32,117,115,105,110,103,32,66,97,115,101,54,52,46,0,65,116,32,116,104,101,32,101,110,100,32,111,102,32,116,104,101,32,111,117,116,112,117,116,32,66,97,115,101,54,52,44,32,96,99,118,69,110,100,87,114,105,116,101,83,116,114,117,99,116,96,32,105,115,32,110,101,101,100,101,100,46,0,99,118,69,110,100,87,114,105,116,101,83,116,114,117,99,116,0,99,118,87,114,105,116,101,73,110,116,0,99,118,87,114,105,116,101,82,101,97,108,0,99,118,87,114,105,116,101,83,116,114,105,110,103,0,99,118,87,114,105,116,101,67,111,109,109,101,110,116,0,99,118,87,114,105,116,101,82,97,119,68,97,116,97,0,78,101,103,97,116,105,118,101,32,110,117,109,98,101,114,32,111,102,32,101,108,101,109,101,110,116,115,0,78,117,108,108,32,100,97,116,97,32,112,111,105,110,116,101,114,0,99,118,83,116,97,114,116,82,101,97,100,82,97,119,68,97,116,97,0,78,117,108,108,32,112,111,105,110,116,101,114,32,116,111,32,115,111,117,114,99,101,32,102,105,108,101,32,110,111,100,101,32,111,114,32,114,101,97,100,101,114,0,84,104,101,32,102,105,108,101,32,110,111,100,101,32,115,104,111,117,108,100,32,98,101,32,97,32,110,117,109,101,114,105,99,97,108,32,115,99,97,108,97,114,32,111,114,32,97,32,115,101,113,117,101,110,99,101,0,99,118,82,101,97,100,82,97,119,68,97,116,97,83,108,105,99,101,0,78,117,108,108,32,112,111,105,110,116,101,114,32,116,111,32,114,101,97,100,101,114,32,111,114,32,100,101,115,116,105,110,97,116,105,111,110,32,97,114,114,97,121,0,84,104,101,32,114,101,97,100,32,115,101,113,117,101,110,99,101,32,105,115,32,97,32,115,99,97,108,97,114,44,32,116,104,117,115,32,108,101,110,32,109,117,115,116,32,98,101,32,49,0,84,104,101,32,115,101,113,117,101,110,99,101,32,101,108,101,109,101,110,116,32,105,115,32,110,111,116,32,97,32,110,117,109,101,114,105,99,97,108,32,115,99,97,108,97,114,0,84,104,101,32,115,101,113,117,101,110,99,101,32,115,108,105,99,101,32,100,111,101,115,32,110,111,116,32,102,105,116,32,97,110,32,105,110,116,101,103,101,114,32,110,117,109,98,101,114,32,111,102,32,114,101,99,111,114,100,115,0,78,117,108,108,32,112,111,105,110,116,101,114,115,32,116,111,32,115,111,117,114,99,101,32,102,105,108,101,32,110,111,100,101,32,111,114,32,100,101,115,116,105,110,97,116,105,111,110,32,97,114,114,97,121,0,99,118,82,101,97,100,82,97,119,68,97,116,97,0,73,110,118,97,108,105,100,32,116,121,112,101,32,105,110,102,111,0,99,118,82,101,103,105,115,116,101,114,84,121,112,101,0,83,111,109,101,32,111,102,32,114,101,113,117,105,114,101,100,32,102,117,110,99,116,105,111,110,32,112,111,105,110,116,101,114,115,32,40,105,115,95,105,110,115,116,97,110,99,101,44,32,114,101,108,101,97,115,101,44,32,114,101,97,100,32,111,114,32,119,114,105,116,101,41,32,97,114,101,32,78,85,76,76,0,84,121,112,101,32,110,97,109,101,32,115,104,111,117,108,100,32,115,116,97,114,116,32,119,105,116,104,32,97,32,108,101,116,116,101,114,32,111,114,32,95,0,84,121,112,101,32,110,97,109,101,32,115,104,111,117,108,100,32,99,111,110,116,97,105,110,32,111,110,108,121,32,108,101,116,116,101,114,115,44,32,100,105,103,105,116,115,44,32,45,32,97,110,100,32,95,0,99,118,87,114,105,116,101,0,78,117,108,108,32,112,111,105,110,116,101,114,32,116,111,32,116,104,101,32,119,114,105,116,116,101,110,32,111,98,106,101,99,116,0,85,110,107,110,111,119,110,32,111,98,106,101,99,116,0,84,104,101,32,111,98,106,101,99,116,32,100,111,101,115,32,110,111,116,32,104,97,118,101,32,119,114,105,116,101,32,102,117,110,99,116,105,111,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,60,63,120,109,108,0,105,99,118,88,77,76,80,97,114,115,101,0,86,97,108,105,100,32,88,77,76,32,115,104,111,117,108,100,32,115,116,97,114,116,32,119,105,116,104,32,39,60,63,120,109,108,32,46,46,46,63,62,39,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,112,101,114,115,105,115,116,101,110,99,101,95,120,109,108,46,99,112,112,0,111,112,101,110,99,118,95,115,116,111,114,97,103,101,0,60,111,112,101,110,99,118,95,115,116,111,114,97,103,101,62,32,116,97,103,32,105,115,32,109,105,115,115,105,110,103,0,60,47,111,112,101,110,99,118,95,115,116,111,114,97,103,101,62,32,116,97,103,32,105,115,32,109,105,115,115,105,110,103,0,102,115,45,62,100,117,109,109,121,95,101,111,102,32,33,61,32,48,0,105,99,118,88,77,76,80,97,114,115,101,86,97,108,117,101,0,68,105,114,101,99,116,105,118,101,32,116,97,103,115,32,97,114,101,32,110,111,116,32,97,108,108,111,119,101,100,32,104,101,114,101,0,69,109,112,116,121,32,116,97,103,115,32,97,114,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,116,97,103,95,116,121,112,101,32,61,61,32,67,86,95,88,77,76,95,79,80,69,78,73,78,71,95,84,65,71,0,77,97,112,32,101,108,101,109,101,110,116,32,115,104,111,117,108,100,32,104,97,118,101,32,97,32,110,97,109,101,0,83,101,113,117,101,110,99,101,32,101,108,101,109,101,110,116,32,115,104,111,117,108,100,32,110,111,116,32,104,97,118,101,32,110,97,109,101,32,40,117,115,101,32,60,95,62,60,47,95,62,41,0,105,99,118,88,77,76,71,101,116,77,117,108,116,105,108,105,110,101,83,116,114,105,110,103,67,111,110,116,101,110,116,0,105,99,118,88,77,76,80,97,114,115,101,66,97,115,101,54,52,0,100,97,116,97,32,115,105,122,101,32,110,111,116,32,109,97,116,99,104,101,115,32,101,108,101,109,101,109,116,32,115,105,122,101,0,77,105,115,109,97,116,99,104,101,100,32,99,108,111,115,105,110,103,32,116,97,103,0,84,104,101,114,101,32,115,104,111,117,108,100,32,98,101,32,115,112,97,99,101,32,98,101,116,119,101,101,110,32,108,105,116,101,114,97,108,115,0,76,105,116,101,114,97,108,32,34,32,105,115,32,110,111,116,32,97,108,108,111,119,101,100,32,119,105,116,104,105,110,32,97,32,115,116,114,105,110,103,46,32,85,115,101,32,38,113,117,111,116,59,0,67,108,111,115,105,110,103,32,34,32,105,115,32,101,120,112,101,99,116,101,100,0,76,105,116,101,114,97,108,32,39,32,111,114,32,62,32,97,114,101,32,110,111,116,32,97,108,108,111,119,101,100,46,32,85,115,101,32,38,97,112,111,115,59,32,111,114,32,38,103,116,59,0,73,110,118,97,108,105,100,32,110,117,109,101,114,105,99,32,118,97,108,117,101,32,105,110,32,116,104,101,32,115,116,114,105,110,103,0,73,110,118,97,108,105,100,32,99,104,97,114,97,99,116,101,114,32,105,110,32,116,104,101,32,115,121,109,98,111,108,32,101,110,116,105,116,121,32,110,97,109,101,0,108,116,0,103,116,0,97,109,112,0,97,112,111,115,0,113,117,111,116,0,84,104,101,32,97,99,116,117,97,108,32,116,121,112,101,32,105,115,32,100,105,102,102,101,114,101,110,116,32,102,114,111,109,32,116,104,101,32,115,112,101,99,105,102,105,101,100,32,116,121,112,101,0,105,99,118,88,77,76,80,97,114,115,101,84,97,103,0,80,114,101,108,105,109,105,110,97,114,121,32,101,110,100,32,111,102,32,116,104,101,32,115,116,114,101,97,109,0,84,97,103,32,115,104,111,117,108,100,32,115,116,97,114,116,32,119,105,116,104,32,39,60,39,0,85,110,107,110,111,119,110,32,116,97,103,32,116,121,112,101,0,78,97,109,101,32,115,104,111,117,108,100,32,115,116,97,114,116,32,119,105,116,104,32,97,32,108,101,116,116,101,114,32,111,114,32,117,110,100,101,114,115,99,111,114,101,0,67,108,111,115,105,110,103,32,116,97,103,32,115,104,111,117,108,100,32,110,111,116,32,99,111,110,116,97,105,110,32,97,110,121,32,97,116,116,114,105,98,117,116,101,115,0,65,116,116,114,105,98,117,116,101,32,110,97,109,101,32,115,104,111,117,108,100,32,98,101,32,102,111,108,108,111,119,101,100,32,98,121,32,39,61,39,0,65,116,116,114,105,98,117,116,101,32,118,97,108,117,101,32,115,104,111,117,108,100,32,98,101,32,112,117,116,32,105,110,116,111,32,115,105,110,103,108,101,32,111,114,32,100,111,117,98,108,101,32,113,117,111,116,101,115,0,73,110,118,97,108,105,100,32,99,108,111,115,105,110,103,32,116,97,103,32,102,111,114,32,60,63,120,109,108,32,46,46,46,0,84,104,101,114,101,32,115,104,111,117,108,100,32,98,101,32,115,112,97,99,101,32,98,101,116,119,101,101,110,32,97,116,116,114,105,98,117,116,101,115,0,105,99,118,88,77,76,83,107,105,112,83,112,97,99,101,115,0,67,111,109,109,101,110,116,115,32,97,114,101,32,110,111,116,32,97,108,108,111,119,101,100,32,104,101,114,101,0,83,111,109,101,32,99,111,108,108,101,99,116,105,111,110,32,116,121,112,101,58,32,67,86,95,78,79,68,69,95,83,69,81,32,111,114,32,67,86,95,78,79,68,69,95,77,65,80,32,109,117,115,116,32,98,101,32,115,112,101,99,105,102,105,101,100,0,105,99,118,88,77,76,83,116,97,114,116,87,114,105,116,101,83,116,114,117,99,116,0,105,99,118,88,77,76,87,114,105,116,101,84,97,103,0,65,32,115,105,110,103,108,101,32,95,32,105,115,32,97,32,114,101,115,101,114,118,101,100,32,116,97,103,32,110,97,109,101,0,95,0,67,108,111,115,105,110,103,32,116,97,103,32,115,104,111,117,108,100,32,110,111,116,32,105,110,99,108,117,100,101,32,97,110,121,32,97,116,116,114,105,98,117,116,101,115,0,75,101,121,32,115,104,111,117,108,100,32,115,116,97,114,116,32,119,105,116,104,32,97,32,108,101,116,116,101,114,32,111,114,32,95,0,75,101,121,32,110,97,109,101,32,109,97,121,32,111,110,108,121,32,99,111,110,116,97,105,110,32,97,108,112,104,97,110,117,109,101,114,105,99,32,99,104,97,114,97,99,116,101,114,115,32,91,97,45,122,65,45,90,48,45,57,93,44,32,39,45,39,32,97,110,100,32,39,95,39,0,65,110,32,101,120,116,114,97,32,99,108,111,115,105,110,103,32,116,97,103,0,105,99,118,88,77,76,69,110,100,87,114,105,116,101,83,116,114,117,99,116,0,10,60,33,45,45,32,110,101,120,116,32,115,116,114,101,97,109,32,45,45,62,10,0,67,117,114,114,101,110,116,108,121,32,111,110,108,121,32,66,97,115,101,54,52,32,100,97,116,97,32,105,115,32,97,108,108,111,119,101,100,46,0,105,99,118,88,77,76,87,114,105,116,101,83,99,97,108,97,114,0,101,108,101,109,101,110,116,115,32,119,105,116,104,32,107,101,121,115,32,99,97,110,32,110,111,116,32,98,101,32,119,114,105,116,116,101,110,32,116,111,32,115,101,113,117,101,110,99,101,0,105,99,118,88,77,76,87,114,105,116,101,83,116,114,105,110,103,0,35,120,37,48,50,120,0,105,99,118,88,77,76,87,114,105,116,101,67,111,109,109,101,110,116,0,68,111,117,98,108,101,32,104,121,112,104,101,110,32,39,45,45,39,32,105,115,32,110,111,116,32,97,108,108,111,119,101,100,32,105,110,32,116,104,101,32,99,111,109,109,101,110,116,115,0,60,33,45,45,0,60,33,45,45,32,37,115,32,45,45,62,0,45,45,45,0,37,89,65,77,76,0,37,89,65,77,76,58,49,46,0,37,89,65,77,76,32,49,46,0,105,99,118,89,77,76,80,97,114,115,101,0,85,110,115,117,112,112,111,114,116,101,100,32,89,65,77,76,32,118,101,114,115,105,111,110,32,40,105,116,32,109,117,115,116,32,98,101,32,49,46,120,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,112,101,114,115,105,115,116,101,110,99,101,95,121,109,108,46,99,112,112,0,84,104,101,32,89,65,77,76,32,115,116,114,101,97,109,115,32,109,117,115,116,32,115,116,97,114,116,32,119,105,116,104,32,39,45,45,45,39,44,32,101,120,99,101,112,116,32,116,104,101,32,102,105,114,115,116,32,111,110,101,0,73,110,118,97,108,105,100,32,111,114,32,117,110,115,117,112,112,111,114,116,101,100,32,115,121,110,116,97,120,0,79,110,108,121,32,99,111,108,108,101,99,116,105,111,110,115,32,97,115,32,89,65,77,76,32,115,116,114,101,97,109,115,32,97,114,101,32,115,117,112,112,111,114,116,101,100,32,98,121,32,116,104,105,115,32,112,97,114,115,101,114,0,60,116,97,103,58,121,97,109,108,46,111,114,103,44,50,48,48,50,58,0,105,99,118,89,77,76,80,97,114,115,101,86,97,108,117,101,0,69,109,112,116,121,32,116,121,112,101,32,110,97,109,101,0,115,116,114,0,109,97,112,0,105,99,118,89,77,76,71,101,116,77,117,108,116,105,108,105,110,101,83,116,114,105,110,103,67,111,110,116,101,110,116,0,85,110,101,120,112,101,99,116,101,100,32,101,110,100,32,111,102,32,108,105,110,101,0,105,99,118,89,77,76,80,97,114,115,101,66,97,115,101,54,52,0,73,110,118,97,108,105,100,32,99,104,97,114,97,99,116,101,114,0,84,111,111,32,108,111,110,103,32,115,116,114,105,110,103,32,108,105,116,101,114,97,108,0,84,104,101,32,119,114,111,110,103,32,99,108,111,115,105,110,103,32,98,114,97,99,107,101,116,0,77,105,115,115,105,110,103,32,44,32,98,101,116,119,101,101,110,32,116,104,101,32,101,108,101,109,101,110,116,115,0,67,111,109,112,108,101,120,32,107,101,121,115,32,97,114,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,77,117,108,116,105,45,108,105,110,101,32,116,101,120,116,32,108,105,116,101,114,97,108,115,32,97,114,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,66,108,111,99,107,32,115,101,113,117,101,110,99,101,32,101,108,101,109,101,110,116,115,32,109,117,115,116,32,98,101,32,112,114,101,99,101,100,101,100,32,119,105,116,104,32,39,45,39,0,73,110,99,111,114,114,101,99,116,32,105,110,100,101,110,116,97,116,105,111,110,0,105,99,118,89,77,76,80,97,114,115,101,75,101,121,0,75,101,121,32,109,97,121,32,110,111,116,32,115,116,97,114,116,32,119,105,116,104,32,39,45,39,0,77,105,115,115,105,110,103,32,39,58,39,0,65,110,32,101,109,112,116,121,32,107,101,121,0,105,99,118,89,77,76,83,107,105,112,83,112,97,99,101,115,0,84,111,111,32,108,111,110,103,32,115,116,114,105,110,103,32,111,114,32,97,32,108,97,115,116,32,115,116,114,105,110,103,32,119,47,111,32,110,101,119,108,105,110,101,0,84,97,98,115,32,97,114,101,32,112,114,111,104,105,98,105,116,101,100,32,105,110,32,89,65,77,76,33,0,105,99,118,89,77,76,87,114,105,116,101,0,105,99,118,89,77,76,83,116,97,114,116,87,114,105,116,101,83,116,114,117,99,116,0,33,33,98,105,110,97,114,121,32,124,0,33,33,37,115,32,37,99,0,33,33,37,115,0,105,99,118,89,77,76,69,110,100,87,114,105,116,101,83,116,114,117,99,116,0,46,46,46,10,0,45,45,45,10,0,105,99,118,89,77,76,87,114,105,116,101,83,116,114,105,110,103,0,120,37,48,50,120,0,105,99,118,89,77,76,87,114,105,116,101,67,111,109,109,101,110,116,0,105,99,118,74,83,79,78,80,97,114,115,101,0,108,101,102,116,45,98,114,97,99,101,32,111,102,32,116,111,112,32,108,101,118,101,108,32,105,115,32,109,105,115,115,105,110,103,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,112,101,114,115,105,115,116,101,110,99,101,95,106,115,111,110,46,99,112,112,0,85,110,101,120,112,101,99,116,101,100,32,69,110,100,45,79,102,45,70,105,108,101,0,105,99,118,74,83,79,78,80,97,114,115,101,83,101,113,0,112,116,114,32,105,115,32,78,85,76,76,0,39,91,39,32,45,32,108,101,102,116,45,98,114,97,99,101,32,111,102,32,115,101,113,32,105,115,32,109,105,115,115,105,110,103,0,85,110,101,120,112,101,99,116,101,100,32,99,104,97,114,97,99,116,101,114,0,39,93,39,32,45,32,114,105,103,104,116,45,98,114,97,99,101,32,111,102,32,115,101,113,32,105,115,32,109,105,115,115,105,110,103,0,105,99,118,74,83,79,78,80,97,114,115,101,86,97,108,117,101,0,36,98,97,115,101,54,52,36,0,39,34,39,32,45,32,114,105,103,104,116,45,113,117,111,116,101,32,111,102,32,115,116,114,105,110,103,32,105,115,32,109,105,115,115,105,110,103,0,73,110,118,97,108,105,100,32,96,100,116,96,32,105,110,32,66,97,115,101,54,52,32,104,101,97,100,101,114,0,73,110,118,97,108,105,100,32,66,97,115,101,54,52,32,100,97,116,97,46,0,66,121,116,101,32,115,105,122,101,32,110,111,116,32,109,97,116,99,104,32,101,108,101,109,101,109,116,32,115,105,122,101,0,85,110,114,101,99,111,103,110,105,122,101,100,32,66,97,115,101,54,52,32,104,101,97,100,101,114,0,39,92,117,88,88,88,88,39,32,99,117,114,114,101,110,116,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,73,110,118,97,108,105,100,32,101,115,99,97,112,101,32,99,104,97,114,97,99,116,101,114,0,40,112,116,114,91,48,93,32,33,61,32,48,32,124,124,32,112,116,114,32,33,61,32,102,115,45,62,98,117,102,102,101,114,95,101,110,100,32,45,32,49,41,32,38,38,32,34,79,112,101,110,67,86,32,112,101,114,115,105,115,116,101,110,99,101,32,100,111,101,115,110,39,116,32,115,117,112,112,111,114,116,32,118,101,114,121,32,108,111,110,103,32,108,105,110,101,115,34,0,73,110,118,97,108,105,100,32,110,117,109,101,114,105,99,32,118,97,108,117,101,32,40,105,110,99,111,110,115,105,115,116,101,110,116,32,101,120,112,108,105,99,105,116,32,116,121,112,101,32,115,112,101,99,105,102,105,99,97,116,105,111,110,63,41,0,110,117,108,108,0,86,97,108,117,101,32,39,110,117,108,108,39,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,116,104,105,115,32,112,97,114,115,101,114,0,85,110,114,101,99,111,103,110,105,122,101,100,32,118,97,108,117,101,0,105,99,118,74,83,79,78,80,97,114,115,101,77,97,112,0,39,123,39,32,45,32,108,101,102,116,45,98,114,97,99,101,32,111,102,32,109,97,112,32,105,115,32,109,105,115,115,105,110,103,0,105,99,118,74,83,79,78,80,97,114,115,101,75,101,121,0,75,101,121,32,109,117,115,116,32,101,110,100,32,119,105,116,104,32,39,34,39,0,77,105,115,115,105,110,103,32,39,58,39,32,98,101,116,119,101,101,110,32,107,101,121,32,97,110,100,32,118,97,108,117,101,0,75,101,121,32,105,115,32,101,109,112,116,121,0,116,121,112,101,95,105,100,0,34,116,121,112,101,95,105,100,34,32,115,104,111,117,108,100,32,98,101,32,111,102,32,116,121,112,101,32,115,116,114,105,110,103,0,39,125,39,32,45,32,114,105,103,104,116,45,98,114,97,99,101,32,111,102,32,109,97,112,32,105,115,32,109,105,115,115,105,110,103,0,105,99,118,74,83,79,78,83,107,105,112,83,112,97,99,101,115,0,78,111,116,32,115,117,112,112,111,114,116,101,100,32,101,115,99,97,112,101,32,99,104,97,114,97,99,116,101,114,0,73,110,118,97,108,105,100,32,99,104,97,114,97,99,116,101,114,32,105,110,32,116,104,101,32,115,116,114,101,97,109,0,65,116,32,112,114,101,115,101,110,116,44,32,111,117,116,112,117,116,32,66,97,115,101,54,52,32,100,97,116,97,32,111,110,108,121,46,0,105,99,118,74,83,79,78,87,114,105,116,101,0,84,104,101,32,107,101,121,32,105,115,32,97,110,32,101,109,112,116,121,0,84,104,101,32,107,101,121,32,105,115,32,116,111,111,32,108,111,110,103,0,65,110,32,97,116,116,101,109,112,116,32,116,111,32,97,100,100,32,101,108,101,109,101,110,116,32,119,105,116,104,111,117,116,32,97,32,107,101,121,32,116,111,32,97,32,109,97,112,44,32,111,114,32,97,100,100,32,101,108,101,109,101,110,116,32,119,105,116,104,32,107,101,121,32,116,111,32,115,101,113,117,101,110,99,101,0,75,101,121,32,109,117,115,116,32,115,116,97,114,116,32,119,105,116,104,32,97,32,108,101,116,116,101,114,32,111,114,32,95,0,75,101,121,32,110,97,109,101,115,32,109,97,121,32,111,110,108,121,32,99,111,110,116,97,105,110,32,97,108,112,104,97,110,117,109,101,114,105,99,32,99,104,97,114,97,99,116,101,114,115,32,91,97,45,122,65,45,90,48,45,57,93,44,32,39,45,39,44,32,39,95,39,32,97,110,100,32,39,32,39,0,83,111,109,101,32,99,111,108,108,101,99,116,105,111,110,32,116,121,112,101,32,45,32,67,86,95,78,79,68,69,95,83,69,81,32,111,114,32,67,86,95,78,79,68,69,95,77,65,80,44,32,109,117,115,116,32,98,101,32,115,112,101,99,105,102,105,101,100,0,105,99,118,74,83,79,78,83,116,97,114,116,87,114,105,116,101,83,116,114,117,99,116,0,98,105,110,97,114,121,0,69,110,100,87,114,105,116,101,83,116,114,117,99,116,32,119,47,111,32,109,97,116,99,104,105,110,103,32,83,116,97,114,116,87,114,105,116,101,83,116,114,117,99,116,0,105,99,118,74,83,79,78,69,110,100,87,114,105,116,101,83,116,114,117,99,116,0,78,117,108,108,32,115,116,114,105,110,103,32,112,111,105,110,116,101,114,0,105,99,118,74,83,79,78,87,114,105,116,101,83,116,114,105,110,103,0,84,104,101,32,119,114,105,116,116,101,110,32,115,116,114,105,110,103,32,105,115,32,116,111,111,32,108,111,110,103,0,78,117,108,108,32,99,111,109,109,101,110,116,0,105,99,118,74,83,79,78,87,114,105,116,101,67,111,109,109,101,110,116,0,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,48,49,50,51,52,53,54,55,56,57,43,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,62,0,0,0,63,52,53,54,55,56,57,58,59,60,61,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,0,0,0,0,0,0,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,0,0,0,0,98,117,102,102,101,114,46,115,105,122,101,40,41,32,60,32,72,69,65,68,69,82,95,83,73,90,69,0,109,97,107,101,95,98,97,115,101,54,52,95,104,101,97,100,101,114,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,112,101,114,115,105,115,116,101,110,99,101,95,98,97,115,101,54,52,46,99,112,112,0,78,83,116,51,95,95,50,49,57,98,97,115,105,99,95,105,115,116,114,105,110,103,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,102,108,117,115,104,0,100,115,116,95,99,117,114,32,43,32,108,101,110,32,60,32,100,115,116,95,101,110,100,0,102,108,117,115,104,40,41,0,73,110,118,97,108,105,100,32,112,111,105,110,116,101,114,32,116,111,32,102,105,108,101,32,115,116,111,114,97,103,101,0,66,97,115,101,54,52,87,114,105,116,101,114,0,84,104,101,32,102,105,108,101,32,115,116,111,114,97,103,101,32,105,115,32,111,112,101,110,101,100,32,102,111,114,32,114,101,97,100,105,110,103,0,66,97,115,101,54,52,67,111,110,116,101,120,116,69,109,105,116,116,101,114,0,34,36,98,97,115,101,54,52,36,0,115,114,99,0,82,97,119,68,97,116,97,84,111,66,105,110,97,114,121,67,111,110,118,101,114,116,111,114,0,33,100,116,46,101,109,112,116,121,40,41,0,108,101,110,32,62,32,48,0,109,97,107,101,95,116,111,95,98,105,110,97,114,121,95,102,117,110,99,115,0,116,121,112,101,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,105,115,115,46,101,111,102,40,41,0,73,110,118,97,108,105,100,32,39,100,116,39,46,0,99,104,101,99,107,95,100,116,0,39,100,116,39,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,46,0,66,105,110,97,114,121,84,111,67,118,83,101,113,67,111,110,118,101,114,116,111,114,0,109,97,107,101,95,102,117,110,99,115,0,98,105,110,97,114,121,95,116,111,95,102,117,110,99,115,46,115,105,122,101,40,41,0,99,118,87,114,105,116,101,82,97,119,68,97,116,97,66,97,115,101,54,52,0,66,97,115,101,54,52,32,115,104,111,117,108,100,32,110,111,116,32,98,101,32,117,115,101,100,32,97,116,32,112,114,101,115,101,110,116,46,0,111,112,101,110,99,118,45,115,101,113,117,101,110,99,101,0,111,112,101,110,99,118,45,115,101,113,117,101,110,99,101,45,116,114,101,101,0,111,112,101,110,99,118,45,103,114,97,112,104,0,111,112,101,110,99,118,45,115,112,97,114,115,101,45,109,97,116,114,105,120,0,111,112,101,110,99,118,45,105,109,97,103,101,0,111,112,101,110,99,118,45,109,97,116,114,105,120,0,111,112,101,110,99,118,45,110,100,45,109,97,116,114,105,120,0,115,105,122,101,115,0,105,0,100,116,0,83,111,109,101,32,111,102,32,101,115,115,101,110,116,105,97,108,32,109,97,116,114,105,120,32,97,116,116,114,105,98,117,116,101,115,32,97,114,101,32,97,98,115,101,110,116,0,105,99,118,82,101,97,100,77,97,116,78,68,0,67,111,117,108,100,32,110,111,116,32,100,101,116,101,114,109,105,110,101,32,116,104,101,32,109,97,116,114,105,120,32,100,105,109,101,110,115,105,111,110,97,108,105,116,121,0,84,104,101,32,109,97,116,114,105,120,32,100,97,116,97,32,105,115,32,110,111,116,32,102,111,117,110,100,32,105,110,32,102,105,108,101,32,115,116,111,114,97,103,101,0,84,104,101,32,109,97,116,114,105,120,32,115,105,122,101,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,116,111,32,116,104,101,32,110,117,109,98,101,114,32,111,102,32,115,116,111,114,101,100,32,101,108,101,109,101,110,116,115,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,99,111,114,101,47,115,114,99,47,112,101,114,115,105,115,116,101,110,99,101,95,116,121,112,101,115,46,99,112,112,0,114,111,119,115,0,99,111,108,115,0,105,99,118,82,101,97,100,77,97,116,0,73,109,97,103,101,115,32,119,105,116,104,32,112,108,97,110,97,114,32,100,97,116,97,32,108,97,121,111,117,116,32,97,114,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,105,99,118,87,114,105,116,101,73,109,97,103,101,0,116,111,112,45,108,101,102,116,0,98,111,116,116,111,109,45,108,101,102,116,0,111,114,105,103,105,110,0,112,108,97,110,97,114,0,105,110,116,101,114,108,101,97,118,101,100,0,108,97,121,111,117,116,0,114,111,105,0,121,0,99,111,105,0,37,100,37,99,0,83,111,109,101,32,111,102,32,101,115,115,101,110,116,105,97,108,32,105,109,97,103,101,32,97,116,116,114,105,98,117,116,101,115,32,97,114,101,32,97,98,115,101,110,116,0,105,99,118,82,101,97,100,73,109,97,103,101,0,79,110,108,121,32,105,110,116,101,114,108,101,97,118,101,100,32,105,109,97,103,101,115,32,99,97,110,32,98,101,32,114,101,97,100,0,84,104,101,32,105,109,97,103,101,32,100,97,116,97,32,105,115,32,110,111,116,32,102,111,117,110,100,32,105,110,32,102,105,108,101,32,115,116,111,114,97,103,101,0,105,99,118,82,101,97,100,83,112,97,114,115,101,77,97,116,0,67,111,117,108,100,32,110,111,116,32,100,101,116,101,114,109,105,110,101,32,115,112,97,114,115,101,32,109,97,116,114,105,120,32,100,105,109,101,110,115,105,111,110,97,108,105,116,121,0,83,112,97,114,115,101,32,109,97,116,114,105,120,32,100,97,116,97,32,105,115,32,99,111,114,114,117,112,116,101,100,0,111,114,105,101,110,116,101,100,0,102,108,97,103,115,0,118,101,114,116,101,120,95,99,111,117,110,116,0,118,101,114,116,101,120,95,100,116,0,101,100,103,101,95,99,111,117,110,116,0,101,100,103,101,95,100,116,0,50,105,102,37,115,0,118,101,114,116,105,99,101,115,0,101,100,103,101,115,0,104,101,97,100,101,114,95,100,116,0,84,104,101,32,115,105,122,101,32,111,102,32,104,101,97,100,101,114,32,99,97,108,99,117,108,97,116,101,100,32,102,114,111,109,32,34,104,101,97,100,101,114,95,100,116,34,32,105,115,32,103,114,101,97,116,101,114,32,116,104,97,110,32,104,101,97,100,101,114,95,115,105,122,101,0,105,99,118,87,114,105,116,101,72,101,97,100,101,114,68,97,116,97,0,99,111,108,111,114,0,37,117,105,0,37,117,117,0,104,101,97,100,101,114,95,117,115,101,114,95,100,97,116,97,0,84,104,101,32,115,105,122,101,32,111,102,32,101,108,101,109,101,110,116,32,99,97,108,99,117,108,97,116,101,100,32,102,114,111,109,32,34,100,116,34,32,97,110,100,32,116,104,101,32,101,108,101,109,95,115,105,122,101,32,100,111,32,110,111,116,32,109,97,116,99,104,0,105,99,118,71,101,116,70,111,114,109,97,116,0,83,105,122,101,32,111,102,32,115,101,113,117,101,110,99,101,32,101,108,101,109,101,110,116,32,40,101,108,101,109,95,115,105,122,101,41,32,105,115,32,105,110,99,111,110,115,105,115,116,101,110,116,32,119,105,116,104,32,115,101,113,45,62,102,108,97,103,115,0,83,111,109,101,32,111,102,32,101,115,115,101,110,116,105,97,108,32,103,114,97,112,104,32,97,116,116,114,105,98,117,116,101,115,32,97,114,101,32,97,98,115,101,110,116,0,105,99,118,82,101,97,100,71,114,97,112,104,0,84,104,101,32,115,101,113,117,101,110,99,101,32,102,108,97,103,115,32,97,114,101,32,105,110,118,97,108,105,100,0,79,110,101,32,111,102,32,34,104,101,97,100,101,114,95,100,116,34,32,97,110,100,32,34,104,101,97,100,101,114,95,117,115,101,114,95,100,97,116,97,34,32,105,115,32,116,104,101,114,101,44,32,119,104,105,108,101,32,116,104,101,32,111,116,104,101,114,32,105,115,32,110,111,116,0,71,114,97,112,104,32,101,100,103,101,115,32,115,104,111,117,108,100,32,115,116,97,114,116,32,119,105,116,104,32,50,32,105,110,116,101,103,101,114,115,32,97,110,100,32,97,32,102,108,111,97,116,0,37,100,102,37,115,0,78,111,32,101,100,103,101,115,32,100,97,116,97,0,78,111,32,118,101,114,116,105,99,101,115,32,100,97,116,97,0,83,111,109,101,32,111,102,32,115,116,111,114,101,100,32,118,101,114,116,101,120,32,105,110,100,105,99,101,115,32,97,114,101,32,111,117,116,32,111,102,32,114,97,110,103,101,0,68,117,112,108,105,99,97,116,101,100,32,101,100,103,101,32,104,97,115,32,111,99,99,117,114,114,101,100,0,78,85,76,76,32,100,111,117,98,108,101,32,112,111,105,110,116,101,114,0,105,99,118,82,101,108,101,97,115,101,71,114,97,112,104,0,115,101,113,117,101,110,99,101,115,0,111,112,101,110,99,118,45,115,101,113,117,101,110,99,101,45,116,114,101,101,32,105,110,115,116,97,110,99,101,32,115,104,111,117,108,100,32,99,111,110,116,97,105,110,32,97,32,102,105,101,108,100,32,34,115,101,113,117,101,110,99,101,115,34,32,116,104,97,116,32,115,104,111,117,108,100,32,98,101,32,97,32,115,101,113,117,101,110,99,101,0,105,99,118,82,101,97,100,83,101,113,84,114,101,101,0,115,101,113,0,108,101,118,101,108,0,65,108,108,32,116,104,101,32,115,101,113,117,101,110,99,101,32,116,114,101,101,32,110,111,100,101,115,32,115,104,111,117,108,100,32,99,111,110,116,97,105,110,32,34,108,101,118,101,108,34,32,102,105,101,108,100,0,114,101,99,117,114,115,105,118,101,0,70,65,76,83,69,0,32,104,111,108,101,0,32,99,117,114,118,101,0,32,117,110,116,121,112,101,100,0,99,111,117,110,116,0,83,111,109,101,32,111,102,32,101,115,115,101,110,116,105,97,108,32,115,101,113,117,101,110,99,101,32,97,116,116,114,105,98,117,116,101,115,32,97,114,101,32,97,98,115,101,110,116,0,105,99,118,82,101,97,100,83,101,113,0,99,117,114,118,101,0,99,108,111,115,101,100,0,104,111,108,101,0,117,110,116,121,112,101,100,0,79,110,108,121,32,111,110,101,32,111,102,32,34,104,101,97,100,101,114,95,117,115,101,114,95,100,97,116,97,34,44,32,34,114,101,99,116,34,32,97,110,100,32,34,111,114,105,103,105,110,34,32,116,97,103,115,32,109,97,121,32,111,99,99,117,114,0,84,104,101,32,110,117,109,98,101,114,32,111,102,32,115,116,111,114,101,100,32,101,108,101,109,101,110,116,115,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,116,111,32,34,99,111,117,110,116,34,0,105,99,118,82,101,108,101,97,115,101,83,101,113,0,85,110,107,110,111,119,110,47,117,110,115,117,112,112,111,114,116,101,100,32,105,110,116,101,114,112,111,108,97,116,105,111,110,32,116,121,112,101,0,105,110,105,116,73,110,116,101,114,84,97,98,50,68,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,105,109,103,119,97,114,112,46,99,112,112,0,105,110,105,116,73,110,116,101,114,84,97,98,49,68,0,95,109,97,112,49,46,115,105,122,101,40,41,46,97,114,101,97,40,41,32,62,32,48,0,114,101,109,97,112,0,95,109,97,112,50,46,101,109,112,116,121,40,41,32,124,124,32,40,95,109,97,112,50,46,115,105,122,101,40,41,32,61,61,32,95,109,97,112,49,46,115,105,122,101,40,41,41,0,100,115,116,46,99,111,108,115,32,60,32,83,72,82,84,95,77,65,88,32,38,38,32,100,115,116,46,114,111,119,115,32,60,32,83,72,82,84,95,77,65,88,32,38,38,32,115,114,99,46,99,111,108,115,32,60,32,83,72,82,84,95,77,65,88,32,38,38,32,115,114,99,46,114,111,119,115,32,60,32,83,72,82,84,95,77,65,88,0,110,110,102,117,110,99,32,33,61,32,48,0,95,115,114,99,46,99,104,97,110,110,101,108,115,40,41,32,60,61,32,52,0,105,102,117,110,99,32,33,61,32,48,0,40,40,109,97,112,49,46,116,121,112,101,40,41,32,61,61,32,67,86,95,51,50,70,67,50,32,124,124,32,109,97,112,49,46,116,121,112,101,40,41,32,61,61,32,67,86,95,49,54,83,67,50,41,32,38,38,32,109,97,112,50,46,101,109,112,116,121,40,41,41,32,124,124,32,40,109,97,112,49,46,116,121,112,101,40,41,32,61,61,32,67,86,95,51,50,70,67,49,32,38,38,32,109,97,112,50,46,116,121,112,101,40,41,32,61,61,32,67,86,95,51,50,70,67,49,41,0,78,50,99,118,49,50,82,101,109,97,112,73,110,118,111,107,101,114,69,0,115,115,105,122,101,46,97,114,101,97,40,41,32,62,32,48,0,114,101,109,97,112,66,105,108,105,110,101,97,114,0,118,111,105,100,32,99,118,58,58,114,101,109,97,112,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,41,0,78,50,99,118,49,55,87,97,114,112,65,102,102,105,110,101,73,110,118,111,107,101,114,69,0,95,115,114,99,46,99,104,97,110,110,101,108,115,40,41,32,60,61,32,52,32,124,124,32,40,105,110,116,101,114,112,111,108,97,116,105,111,110,32,33,61,32,73,78,84,69,82,95,76,65,78,67,90,79,83,52,32,38,38,32,105,110,116,101,114,112,111,108,97,116,105,111,110,32,33,61,32,73,78,84,69,82,95,67,85,66,73,67,41,0,119,97,114,112,65,102,102,105,110,101,0,115,114,99,46,99,111,108,115,32,62,32,48,32,38,38,32,115,114,99,46,114,111,119,115,32,62,32,48,0,40,77,48,46,116,121,112,101,40,41,32,61,61,32,67,86,95,51,50,70,32,124,124,32,77,48,46,116,121,112,101,40,41,32,61,61,32,67,86,95,54,52,70,41,32,38,38,32,77,48,46,114,111,119,115,32,61,61,32,50,32,38,38,32,77,48,46,99,111,108,115,32,61,61,32,51,0,118,111,105,100,32,99,118,58,58,119,97,114,112,65,102,102,105,110,101,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,83,105,122,101,44,32,105,110,116,44,32,105,110,116,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,41,0,78,50,99,118,50,50,87,97,114,112,80,101,114,115,112,101,99,116,105,118,101,73,110,118,111,107,101,114,69,0,95,115,114,99,46,116,111,116,97,108,40,41,32,62,32,48,0,119,97,114,112,80,101,114,115,112,101,99,116,105,118,101,0,40,77,48,46,116,121,112,101,40,41,32,61,61,32,67,86,95,51,50,70,32,124,124,32,77,48,46,116,121,112,101,40,41,32,61,61,32,67,86,95,54,52,70,41,32,38,38,32,77,48,46,114,111,119,115,32,61,61,32,51,32,38,38,32,77,48,46,99,111,108,115,32,61,61,32,51,0,118,111,105,100,32,99,118,58,58,119,97,114,112,80,101,114,115,112,101,99,116,105,118,101,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,83,105,122,101,44,32,105,110,116,44,32,105,110,116,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,41,0,99,118,58,58,77,97,116,32,99,118,58,58,103,101,116,82,111,116,97,116,105,111,110,77,97,116,114,105,120,50,68,40,80,111,105,110,116,50,102,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,41,0,79,80,69,78,67,86,95,73,77,71,80,82,79],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+225281);allocate([67,95,71,69,84,80,69,82,83,80,69,67,84,73,86,69,84,82,65,78,83,70,79,82,77,95,83,79,76,86,69,95,77,69,84,72,79,68,0,99,118,58,58,77,97,116,32,99,118,58,58,103,101,116,80,101,114,115,112,101,99,116,105,118,101,84,114,97,110,115,102,111,114,109,40,99,111,110,115,116,32,80,111,105,110,116,50,102,32,42,44,32,99,111,110,115,116,32,80,111,105,110,116,50,102,32,42,41,0,115,114,99,46,99,104,101,99,107,86,101,99,116,111,114,40,50,44,32,67,86,95,51,50,70,41,32,61,61,32,52,32,38,38,32,100,115,116,46,99,104,101,99,107,86,101,99,116,111,114,40,50,44,32,67,86,95,51,50,70,41,32,61,61,32,52,0,103,101,116,80,101,114,115,112,101,99,116,105,118,101,84,114,97,110,115,102,111,114,109,0,115,114,99,46,99,104,101,99,107,86,101,99,116,111,114,40,50,44,32,67,86,95,51,50,70,41,32,61,61,32,51,32,38,38,32,100,115,116,46,99,104,101,99,107,86,101,99,116,111,114,40,50,44,32,67,86,95,51,50,70,41,32,61,61,32,51,0,103,101,116,65,102,102,105,110,101,84,114,97,110,115,102,111,114,109,0,110,112,111,105,110,116,115,50,32,62,61,32,48,32,124,124,32,110,112,111,105,110,116,115,51,32,62,61,32,48,0,102,105,116,76,105,110,101,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,108,105,110,101,102,105,116,46,99,112,112,0,85,110,107,110,111,119,110,32,100,105,115,116,97,110,99,101,32,116,121,112,101,0,102,105,116,76,105,110,101,50,68,0,85,110,107,110,111,119,110,32,100,105,115,116,97,110,99,101,0,102,105,116,76,105,110,101,51,68,0,99,111,117,110,116,32,62,32,48,0,102,105,116,76,105,110,101,51,68,95,119,111,100,115,0,102,105,116,76,105,110,101,50,68,95,119,111,100,115,0,118,111,105,100,32,99,118,58,58,102,105,116,76,105,110,101,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,41,0,95,109,111,100,101,108,32,109,117,115,116,32,104,97,118,101,32,67,86,95,54,52,70,67,49,32,116,121,112,101,44,32,114,111,119,115,32,61,61,32,49,32,97,110,100,32,99,111,108,115,32,61,61,32,49,51,42,99,111,109,112,111,110,101,110,116,115,67,111,117,110,116,0,71,77,77,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,103,114,97,98,99,117,116,46,99,112,112,0,100,116,114,109,32,62,32,115,116,100,58,58,110,117,109,101,114,105,99,95,108,105,109,105,116,115,60,100,111,117,98,108,101,62,58,58,101,112,115,105,108,111,110,40,41,0,99,97,108,99,73,110,118,101,114,115,101,67,111,118,65,110,100,68,101,116,101,114,109,0,99,111,118,68,101,116,101,114,109,115,91,99,105,93,32,62,32,115,116,100,58,58,110,117,109,101,114,105,99,95,108,105,109,105,116,115,60,100,111,117,98,108,101,62,58,58,101,112,115,105,108,111,110,40,41,0,116,111,116,97,108,83,97,109,112,108,101,67,111,117,110,116,32,62,32,48,0,101,110,100,76,101,97,114,110,105,110,103,0,105,109,97,103,101,32,105,115,32,101,109,112,116,121,0,103,114,97,98,67,117,116,0,105,109,97,103,101,32,109,117,115,116,32,104,97,118,101,32,67,86,95,56,85,67,51,32,116,121,112,101,0,33,98,103,100,83,97,109,112,108,101,115,46,101,109,112,116,121,40,41,32,38,38,32,33,102,103,100,83,97,109,112,108,101,115,46,101,109,112,116,121,40,41,0,105,110,105,116,71,77,77,115,0,105,62,61,48,32,38,38,32,105,60,40,105,110,116,41,118,116,99,115,46,115,105,122,101,40,41,0,97,100,100,84,101,114,109,87,101,105,103,104,116,115,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,103,99,103,114,97,112,104,46,104,112,112,0,105,110,83,111,117,114,99,101,83,101,103,109,101,110,116,0,109,105,110,87,101,105,103,104,116,32,62,32,48,0,109,97,120,70,108,111,119,0,97,100,100,69,100,103,101,115,0,106,62,61,48,32,38,38,32,106,60,40,105,110,116,41,118,116,99,115,46,115,105,122,101,40,41,0,119,62,61,48,32,38,38,32,114,101,118,119,62,61,48,0,105,32,33,61,32,106,0,109,97,115,107,32,105,115,32,101,109,112,116,121,0,99,104,101,99,107,77,97,115,107,0,109,97,115,107,32,109,117,115,116,32,104,97,118,101,32,67,86,95,56,85,67,49,32,116,121,112,101,0,109,97,115,107,32,109,117,115,116,32,104,97,118,101,32,97,115,32,109,97,110,121,32,114,111,119,115,32,97,110,100,32,99,111,108,115,32,97,115,32,105,109,103,0,109,97,115,107,32,101,108,101,109,101,110,116,32,118,97,108,117,101,32,109,117,115,116,32,98,101,32,101,113,117,97,108,32,71,67,95,66,71,68,32,111,114,32,71,67,95,70,71,68,32,111,114,32,71,67,95,80,82,95,66,71,68,32,111,114,32,71,67,95,80,82,95,70,71,68,0,118,111,105,100,32,99,118,58,58,103,114,97,98,67,117,116,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,82,101,99,116,44,32,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,103,101,111,109,101,116,114,121,46,99,112,112,0,116,111,116,97,108,32,62,61,32,48,32,38,38,32,40,100,101,112,116,104,32,61,61,32,67,86,95,51,50,83,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,41,0,112,111,105,110,116,80,111,108,121,103,111,110,84,101,115,116,0,100,111,117,98,108,101,32,99,118,58,58,112,111,105,110,116,80,111,108,121,103,111,110,84,101,115,116,40,73,110,112,117,116,65,114,114,97,121,44,32,80,111,105,110,116,50,102,44,32,98,111,111,108,41,0,105,109,103,46,100,105,109,115,32,60,61,32,50,32,38,38,32,116,101,109,112,108,46,100,105,109,115,32,60,61,32,50,32,38,38,32,99,111,114,114,46,100,105,109,115,32,60,61,32,50,0,99,114,111,115,115,67,111,114,114,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,116,101,109,112,108,109,97,116,99,104,46,99,112,112,0,100,101,112,116,104,32,61,61,32,116,100,101,112,116,104,32,124,124,32,116,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,0,99,111,114,114,115,105,122,101,46,104,101,105,103,104,116,32,60,61,32,105,109,103,46,114,111,119,115,32,43,32,116,101,109,112,108,46,114,111,119,115,32,45,32,49,32,38,38,32,99,111,114,114,115,105,122,101,46,119,105,100,116,104,32,60,61,32,105,109,103,46,99,111,108,115,32,43,32,116,101,109,112,108,46,99,111,108,115,32,45,32,49,0,99,99,110,32,61,61,32,49,32,124,124,32,100,101,108,116,97,32,61,61,32,48,0,116,104,101,32,105,110,112,117,116,32,97,114,114,97,121,115,32,97,114,101,32,116,111,111,32,98,105,103,0,116,111,116,97,108,40,41,32,61,61,32,48,32,124,124,32,100,97,116,97,32,33,61,32,78,85,76,76,0,77,97,116,0,67,86,95,84,77,95,83,81,68,73,70,70,32,60,61,32,109,101,116,104,111,100,32,38,38,32,109,101,116,104,111,100,32,60,61,32,67,86,95,84,77,95,67,67,79,69,70,70,95,78,79,82,77,69,68,0,109,97,116,99,104,84,101,109,112,108,97,116,101,77,97,115,107,0,40,100,101,112,116,104,32,61,61,32,67,86,95,56,85,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,41,32,38,38,32,116,121,112,101,32,61,61,32,95,116,101,109,112,108,46,116,121,112,101,40,41,32,38,38,32,95,105,109,103,46,100,105,109,115,40,41,32,60,61,32,50,0,109,97,116,99,104,84,101,109,112,108,97,116,101,0,95,105,109,103,46,115,105,122,101,40,41,46,104,101,105,103,104,116,32,60,61,32,95,116,101,109,112,108,46,115,105,122,101,40,41,46,104,101,105,103,104,116,32,38,38,32,95,105,109,103,46,115,105,122,101,40,41,46,119,105,100,116,104,32,60,61,32,95,116,101,109,112,108,46,115,105,122,101,40,41,46,119,105,100,116,104,0,115,113,115,117,109,46,100,97,116,97,32,33,61,32,78,85,76,76,0,99,111,109,109,111,110,95,109,97,116,99,104,84,101,109,112,108,97,116,101,0,115,117,109,46,100,97,116,97,32,33,61,32,78,85,76,76,0,118,111,105,100,32,99,118,58,58,109,97,116,99,104,84,101,109,112,108,97,116,101,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,73,110,112,117,116,65,114,114,97,121,41,0,111,114,105,101,110,116,97,116,105,111,110,32,33,61,32,48,0,114,111,116,97,116,105,110,103,67,97,108,105,112,101,114,115,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,114,111,116,99,97,108,105,112,101,114,115,46,99,112,112,0,99,118,58,58,82,111,116,97,116,101,100,82,101,99,116,32,99,118,58,58,109,105,110,65,114,101,97,82,101,99,116,40,73,110,112,117,116,65,114,114,97,121,41,0,78,50,99,118,49,51,66,97,115,101,82,111,119,70,105,108,116,101,114,69,0,78,50,99,118,49,54,66,97,115,101,67,111,108,117,109,110,70,105,108,116,101,114,69,0,78,50,99,118,49,48,66,97,115,101,70,105,108,116,101,114,69,0,115,114,99,46,116,121,112,101,40,41,32,61,61,32,115,114,99,84,121,112,101,32,38,38,32,100,115,116,46,116,121,112,101,40,41,32,61,61,32,100,115,116,84,121,112,101,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,102,105,108,116,101,114,46,99,112,112,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,70,105,108,116,101,114,69,110,103,105,110,101,58,58,97,112,112,108,121,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,38,44,32,99,118,58,58,77,97,116,32,38,44,32,99,111,110,115,116,32,83,105,122,101,32,38,44,32,99,111,110,115,116,32,80,111,105,110,116,32,38,41,0,119,104,111,108,101,83,105,122,101,46,119,105,100,116,104,32,62,32,48,32,38,38,32,119,104,111,108,101,83,105,122,101,46,104,101,105,103,104,116,32,62,32,48,0,112,114,111,99,101,101,100,0,115,114,99,32,38,38,32,100,115,116,32,38,38,32,99,111,117,110,116,32,62,32,48,0,115,114,99,89,32,62,61,32,115,116,97,114,116,89,0,100,115,116,89,32,60,61,32,114,111,105,46,104,101,105,103,104,116,0,114,111,105,46,120,32,62,61,32,48,32,38,38,32,114,111,105,46,121,32,62,61,32,48,32,38,38,32,114,111,105,46,119,105,100,116,104,32,62,61,32,48,32,38,38,32,114,111,105,46,104,101,105,103,104,116,32,62,61,32,48,32,38,38,32,114,111,105,46,120,32,43,32,114,111,105,46,119,105,100,116,104,32,60,61,32,119,104,111,108,101,83,105,122,101,46,119,105,100,116,104,32,38,38,32,114,111,105,46,121,32,43,32,114,111,105,46,104,101,105,103,104,116,32,60,61,32,119,104,111,108,101,83,105,122,101,46,104,101,105,103,104,116,0,115,116,97,114,116,0,99,111,110,115,116,86,97,108,32,33,61,32,78,85,76,76,0,78,50,99,118,49,50,70,105,108,116,101,114,69,110,103,105,110,101,69,0,99,111,108,117,109,110,66,111,114,100,101,114,84,121,112,101,32,33,61,32,66,79,82,68,69,82,95,87,82,65,80,0,105,110,105,116,0,114,111,119,70,105,108,116,101,114,32,38,38,32,99,111,108,117,109,110,70,105,108,116,101,114,0,98,117,102,84,121,112,101,32,61,61,32,115,114,99,84,121,112,101,0,48,32,60,61,32,97,110,99,104,111,114,46,120,32,38,38,32,97,110,99,104,111,114,46,120,32,60,32,107,115,105,122,101,46,119,105,100,116,104,32,38,38,32,48,32,60,61,32,97,110,99,104,111,114,46,121,32,38,38,32,97,110,99,104,111,114,46,121,32,60,32,107,115,105,122,101,46,104,101,105,103,104,116,0,95,107,101,114,110,101,108,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,0,103,101,116,75,101,114,110,101,108,84,121,112,101,0,99,110,32,61,61,32,67,86,95,77,65,84,95,67,78,40,98,117,102,84,121,112,101,41,32,38,38,32,100,100,101,112,116,104,32,62,61,32,115,116,100,58,58,109,97,120,40,115,100,101,112,116,104,44,32,67,86,95,51,50,83,41,32,38,38,32,107,101,114,110,101,108,46,116,121,112,101,40,41,32,61,61,32,100,100,101,112,116,104,0,103,101,116,76,105,110,101,97,114,82,111,119,70,105,108,116,101,114,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,82,111,119,70,105,108,116,101,114,73,100,100,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,107,101,114,110,101,108,46,116,121,112,101,40,41,32,61,61,32,68,97,116,97,84,121,112,101,60,68,84,62,58,58,116,121,112,101,32,38,38,32,40,107,101,114,110,101,108,46,114,111,119,115,32,61,61,32,49,32,124,124,32,107,101,114,110,101,108,46,99,111,108,115,32,61,61,32,49,41,0,82,111,119,70,105,108,116,101,114,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,100,100,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,82,111,119,70,105,108,116,101,114,73,102,100,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,102,100,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,82,111,119,70,105,108,116,101,114,73,102,102,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,102,102,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,82,111,119,70,105,108,116,101,114,73,115,100,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,115,100,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,82,111,119,70,105,108,116,101,114,73,115,102,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,115,102,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,82,111,119,70,105,108,116,101,114,73,116,100,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,116,100,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,82,111,119,70,105,108,116,101,114,73,116,102,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,116,102,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,82,111,119,70,105,108,116,101,114,73,104,100,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,104,100,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,82,111,119,70,105,108,116,101,114,73,104,102,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,104,102,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,82,111,119,70,105,108,116,101,114,73,104,105,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,104,105,78,83,95,56,82,111,119,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,56,83,121,109,109,82,111,119,83,109,97,108,108,70,105,108,116,101,114,73,102,102,78,83,95,49,55,83,121,109,109,82,111,119,83,109,97,108,108,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,40,115,121,109,109,101,116,114,121,84,121,112,101,32,38,32,40,75,69,82,78,69,76,95,83,89,77,77,69,84,82,73,67,65,76,32,124,32,75,69,82,78,69,76,95,65,83,89,77,77,69,84,82,73,67,65,76,41,41,32,33,61,32,48,32,38,38,32,116,104,105,115,45,62,107,115,105,122,101,32,60,61,32,53,0,83,121,109,109,82,111,119,83,109,97,108,108,70,105,108,116,101,114,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,102,102,78,83,95,49,55,83,121,109,109,82,111,119,83,109,97,108,108,78,111,86,101,99,69,69,69,0,78,50,99,118,49,56,83,121,109,109,82,111,119,83,109,97,108,108,70,105,108,116,101,114,73,102,102,78,83,95,49,55,83,121,109,109,82,111,119,83,109,97,108,108,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,56,83,121,109,109,82,111,119,83,109,97,108,108,70,105,108,116,101,114,73,104,105,78,83,95,49,55,83,121,109,109,82,111,119,83,109,97,108,108,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,50,99,118,57,82,111,119,70,105,108,116,101,114,73,104,105,78,83,95,49,55,83,121,109,109,82,111,119,83,109,97,108,108,78,111,86,101,99,69,69,69,0,78,50,99,118,49,56,83,121,109,109,82,111,119,83,109,97,108,108,70,105,108,116,101,114,73,104,105,78,83,95,49,55,83,121,109,109,82,111,119,83,109,97,108,108,78,111,86,101,99,69,69,69,0,99,110,32,61,61,32,67,86,95,77,65,84,95,67,78,40,98,117,102,84,121,112,101,41,32,38,38,32,115,100,101,112,116,104,32,62,61,32,115,116,100,58,58,109,97,120,40,100,100,101,112,116,104,44,32,67,86,95,51,50,83,41,32,38,38,32,107,101,114,110,101,108,46,116,121,112,101,40,41,32,61,61,32,115,100,101,112,116,104,0,103,101,116,76,105,110,101,97,114,67,111,108,117,109,110,70,105,108,116,101,114,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,109,98,105,110,97,116,105,111,110,32,111,102,32,98,117,102,102,101,114,32,102,111,114,109,97,116,32,40,61,37,100,41,44,32,97,110,100,32,100,101,115,116,105,110,97,116,105,111,110,32,102,111,114,109,97,116,32,40,61,37,100,41,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,40,115,121,109,109,101,116,114,121,84,121,112,101,32,38,32,40,75,69,82,78,69,76,95,83,89,77,77,69,84,82,73,67,65,76,32,124,32,75,69,82,78,69,76,95,65,83,89,77,77,69,84,82,73,67,65,76,41,41,32,33,61,32,48,0,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,105,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,105,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,105,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,107,101,114,110,101,108,46,116,121,112,101,40,41,32,61,61,32,68,97,116,97,84,121,112,101,60,83,84,62,58,58,116,121,112,101,32,38,38,32,40,107,101,114,110,101,108,46,114,111,119,115,32,61,61,32,49,32,124,124,32,107,101,114,110,101,108,46,99,111,108,115,32,61,61,32,49,41,0,67,111,108,117,109,110,70,105,108,116,101,114,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,116,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,116,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,116,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,49,51,70,105,120,101,100,80,116,67,97,115,116,69,120,73,105,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,49,51,70,105,120,101,100,80,116,67,97,115,116,69,120,73,105,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,49,51,70,105,120,101,100,80,116,67,97,115,116,69,120,73,105,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,50,49,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,50,48,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,116,104,105,115,45,62,107,115,105,122,101,32,61,61,32,51,0,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,70,105,108,116,101,114,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,50,48,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,78,111,86,101,99,69,69,69,0,78,50,99,118,50,49,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,50,48,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,50,48,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,50,49,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,105,115,69,69,78,83,95,50,48,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,105,115,69,69,78,83,95,50,48,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,78,111,86,101,99,69,69,69,0,78,50,99,118,50,49,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,105,115,69,69,78,83,95,50,48,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,78,111,86,101,99,69,69,69,0,78,50,99,118,49,54,83,121,109,109,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,105,115,69,69,78,83,95,50,48,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,50,49,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,70,105,108,116,101,114,73,78,83,95,49,51,70,105,120,101,100,80,116,67,97,115,116,69,120,73,105,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,50,49,83,121,109,109,67,111,108,117,109,110,83,109,97,108,108,70,105,108,116,101,114,73,78,83,95,49,51,70,105,120,101,100,80,116,67,97,115,116,69,120,73,105,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,116,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,100,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,52,67,97,115,116,73,102,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,67,111,108,117,109,110,70,105,108,116,101,114,73,78,83,95,49,51,70,105,120,101,100,80,116,67,97,115,116,69,120,73,105,104,69,69,78,83,95,49,49,67,111,108,117,109,110,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,99,110,32,61,61,32,67,86,95,77,65,84,95,67,78,40,95,100,115,116,84,121,112,101,41,0,99,114,101,97,116,101,83,101,112,97,114,97,98,108,101,76,105,110,101,97,114,70,105,108,116,101,114,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,49,50,70,105,108,116,101,114,69,110,103,105,110,101,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,50,95,69,69,69,69,0,107,116,121,112,101,32,61,61,32,67,86,95,56,85,32,124,124,32,107,116,121,112,101,32,61,61,32,67,86,95,51,50,83,32,124,124,32,107,116,121,112,101,32,61,61,32,67,86,95,51,50,70,32,124,124,32,107,116,121,112,101,32,61,61,32,67,86,95,54,52,70,0,112,114,101,112,114,111,99,101,115,115,50,68,75,101,114,110,101,108,0,99,110,32,61,61,32,67,86,95,77,65,84,95,67,78,40,100,115,116,84,121,112,101,41,32,38,38,32,100,100,101,112,116,104,32,62,61,32,115,100,101,112,116,104,0,103,101,116,76,105,110,101,97,114,70,105,108,116,101,114,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,109,98,105,110,97,116,105,111,110,32,111,102,32,115,111,117,114,99,101,32,102,111,114,109,97,116,32,40,61,37,100,41,44,32,97,110,100,32,100,101,115,116,105,110,97,116,105,111,110,32,102,111,114,109,97,116,32,40,61,37,100,41,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,100,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,95,107,101,114,110,101,108,46,116,121,112,101,40,41,32,61,61,32,68,97,116,97,84,121,112,101,60,75,84,62,58,58,116,121,112,101,0,70,105,108,116,101,114,50,68,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,100,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,102,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,102,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,70,105,108],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+235521);allocate([116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,115,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,115,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,115,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,115,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,115,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,115,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,116,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,116,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,116,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,116,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,116,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,116,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,104,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,104,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,104,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,104,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,104,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,104,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,104,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,104,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,56,70,105,108,116,101,114,50,68,73,104,78,83,95,52,67,97,115,116,73,102,104,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,54,95,69,69,69,69,0,78,50,99,118,56,70,105,108,116,101,114,50,68,73,104,78,83,95,52,67,97,115,116,73,102,104,69,69,78,83,95,49,49,70,105,108,116,101,114,78,111,86,101,99,69,69,69,0,99,114,101,97,116,101,76,105,110,101,97,114,70,105,108,116,101,114,0,118,111,105,100,32,99,118,58,58,102,105,108,116,101,114,50,68,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,73,110,112,117,116,65,114,114,97,121,44,32,80,111,105,110,116,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,107,101,114,110,101,108,88,46,116,121,112,101,40,41,32,61,61,32,107,101,114,110,101,108,89,46,116,121,112,101,40,41,32,38,38,32,40,107,101,114,110,101,108,88,46,99,111,108,115,32,61,61,32,49,32,124,124,32,107,101,114,110,101,108,88,46,114,111,119,115,32,61,61,32,49,41,32,38,38,32,40,107,101,114,110,101,108,89,46,99,111,108,115,32,61,61,32,49,32,124,124,32,107,101,114,110,101,108,89,46,114,111,119,115,32,61,61,32,49,41,0,115,101,112,70,105,108,116,101,114,50,68,0,118,111,105,100,32,99,118,58,58,115,101,112,70,105,108,116,101,114,50,68,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,80,111,105,110,116,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,105,110,116,101,103,114,97,108,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,115,117,109,112,105,120,101,108,115,46,99,112,112,0,118,111,105,100,32,99,118,58,58,105,110,116,101,103,114,97,108,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,105,110,116,101,103,114,97,108,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,105,110,116,101,103,114,97,108,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,41,0,115,117,109,46,100,97,116,97,32,61,61,32,115,117,109,48,46,100,97,116,97,32,38,38,32,115,113,115,117,109,46,100,97,116,97,32,61,61,32,115,113,115,117,109,48,46,100,97,116,97,32,38,38,32,116,105,108,116,101,100,46,100,97,116,97,32,61,61,32,116,105,108,116,101,100,48,46,100,97,116,97,0,99,118,73,110,116,101,103,114,97,108,0,113,117,97,108,105,116,121,76,101,118,101,108,32,62,32,48,32,38,38,32,109,105,110,68,105,115,116,97,110,99,101,32,62,61,32,48,32,38,38,32,109,97,120,67,111,114,110,101,114,115,32,62,61,32,48,0,103,111,111,100,70,101,97,116,117,114,101,115,84,111,84,114,97,99,107,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,102,101,97,116,117,114,101,115,101,108,101,99,116,46,99,112,112,0,95,109,97,115,107,46,101,109,112,116,121,40,41,32,124,124,32,40,95,109,97,115,107,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,67,49,32,38,38,32,95,109,97,115,107,46,115,97,109,101,83,105,122,101,40,95,105,109,97,103,101,41,41,0,118,111,105,100,32,99,118,58,58,103,111,111,100,70,101,97,116,117,114,101,115,84,111,84,114,97,99,107,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,44,32,98,111,111,108,44,32,100,111,117,98,108,101,41,0,40,100,115,116,95,119,105,100,116,104,32,62,32,48,32,38,38,32,100,115,116,95,104,101,105,103,104,116,32,62,32,48,41,32,124,124,32,40,105,110,118,95,115,99,97,108,101,95,120,32,62,32,48,32,38,38,32,105,110,118,95,115,99,97,108,101,95,121,32,62,32,48,41,0,114,101,115,105,122,101,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,114,101,115,105,122,101,46,99,112,112,0,33,100,115,105,122,101,46,101,109,112,116,121,40,41,0,102,117,110,99,32,33,61,32,48,0,102,117,110,99,32,33,61,32,48,32,38,38,32,99,110,32,60,61,32,52,0,85,110,107,110,111,119,110,32,105,110,116,101,114,112,111,108,97,116,105,111,110,32,109,101,116,104,111,100,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,50,72,82,101,115,105,122,101,67,117,98,105,99,73,100,100,102,69,69,78,83,95,49,50,86,82,101,115,105,122,101,67,117,98,105,99,73,100,100,102,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,107,115,105,122,101,32,60,61,32,77,65,88,95,69,83,73,90,69,0,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,50,72,82,101,115,105,122,101,67,117,98,105,99,73,102,102,102,69,69,78,83,95,49,50,86,82,101,115,105,122,101,67,117,98,105,99,73,102,102,102,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,50,72,82,101,115,105,122,101,67,117,98,105,99,73,115,102,102,69,69,78,83,95,49,50,86,82,101,115,105,122,101,67,117,98,105,99,73,115,102,102,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,50,72,82,101,115,105,122,101,67,117,98,105,99,73,116,102,102,69,69,78,83,95,49,50,86,82,101,115,105,122,101,67,117,98,105,99,73,116,102,102,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,50,72,82,101,115,105,122,101,67,117,98,105,99,73,104,105,115,69,69,78,83,95,49,50,86,82,101,115,105,122,101,67,117,98,105,99,73,104,105,115,78,83,95,49,49,70,105,120,101,100,80,116,67,97,115,116,73,105,104,76,105,50,50,69,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,51,72,82,101,115,105,122,101,76,105,110,101,97,114,73,100,100,102,76,105,49,69,78,83,95,49,50,72,82,101,115,105,122,101,78,111,86,101,99,69,69,69,78,83,95,49,51,86,82,101,115,105,122,101,76,105,110,101,97,114,73,100,100,102,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,51,72,82,101,115,105,122,101,76,105,110,101,97,114,73,102,102,102,76,105,49,69,78,83,95,49,50,72,82,101,115,105,122,101,78,111,86,101,99,69,69,69,78,83,95,49,51,86,82,101,115,105,122,101,76,105,110,101,97,114,73,102,102,102,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,51,72,82,101,115,105,122,101,76,105,110,101,97,114,73,115,102,102,76,105,49,69,78,83,95,49,50,72,82,101,115,105,122,101,78,111,86,101,99,69,69,69,78,83,95,49,51,86,82,101,115,105,122,101,76,105,110,101,97,114,73,115,102,102,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,51,72,82,101,115,105,122,101,76,105,110,101,97,114,73,116,102,102,76,105,49,69,78,83,95,49,50,72,82,101,115,105,122,101,78,111,86,101,99,69,69,69,78,83,95,49,51,86,82,101,115,105,122,101,76,105,110,101,97,114,73,116,102,102,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,51,72,82,101,115,105,122,101,76,105,110,101,97,114,73,104,105,115,76,105,50,48,52,56,69,78,83,95,49,50,72,82,101,115,105,122,101,78,111,86,101,99,69,69,69,78,83,95,49,51,86,82,101,115,105,122,101,76,105,110,101,97,114,73,104,105,115,78,83,95,49,49,70,105,120,101,100,80,116,67,97,115,116,73,105,104,76,105,50,50,69,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,53,72,82,101,115,105,122,101,76,97,110,99,122,111,115,52,73,100,100,102,69,69,78,83,95,49,53,86,82,101,115,105,122,101,76,97,110,99,122,111,115,52,73,100,100,102,78,83,95,52,67,97,115,116,73,100,100,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,53,72,82,101,115,105,122,101,76,97,110,99,122,111,115,52,73,102,102,102,69,69,78,83,95,49,53,86,82,101,115,105,122,101,76,97,110,99,122,111,115,52,73,102,102,102,78,83,95,52,67,97,115,116,73,102,102,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,53,72,82,101,115,105,122,101,76,97,110,99,122,111,115,52,73,115,102,102,69,69,78,83,95,49,53,86,82,101,115,105,122,101,76,97,110,99,122,111,115,52,73,115,102,102,78,83,95,52,67,97,115,116,73,102,115,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,53,72,82,101,115,105,122,101,76,97,110,99,122,111,115,52,73,116,102,102,69,69,78,83,95,49,53,86,82,101,115,105,122,101,76,97,110,99,122,111,115,52,73,116,102,102,78,83,95,52,67,97,115,116,73,102,116,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,50,49,114,101,115,105,122,101,71,101,110,101,114,105,99,95,73,110,118,111,107,101,114,73,78,83,95,49,53,72,82,101,115,105,122,101,76,97,110,99,122,111,115,52,73,104,105,115,69,69,78,83,95,49,53,86,82,101,115,105,122,101,76,97,110,99,122,111,115,52,73,104,105,115,78,83,95,49,49,70,105,120,101,100,80,116,67,97,115,116,73,105,104,76,105,50,50,69,69,69,78,83,95,49,50,86,82,101,115,105,122,101,78,111,86,101,99,69,69,69,69,69,0,78,50,99,118,49,56,82,101,115,105,122,101,65,114,101,97,95,73,110,118,111,107,101,114,73,100,100,69,69,0,78,50,99,118,49,56,82,101,115,105,122,101,65,114,101,97,95,73,110,118,111,107,101,114,73,102,102,69,69,0,78,50,99,118,49,56,82,101,115,105,122,101,65,114,101,97,95,73,110,118,111,107,101,114,73,115,102,69,69,0,78,50,99,118,49,56,82,101,115,105,122,101,65,114,101,97,95,73,110,118,111,107,101,114,73,116,102,69,69,0,78,50,99,118,49,56,82,101,115,105,122,101,65,114,101,97,95,73,110,118,111,107,101,114,73,104,102,69,69,0,78,50,99,118,50,50,114,101,115,105,122,101,65,114,101,97,70,97,115,116,95,73,110,118,111,107,101,114,73,100,100,78,83,95,49,57,82,101,115,105,122,101,65,114,101,97,70,97,115,116,78,111,86,101,99,73,100,100,69,69,69,69,0,78,50,99,118,50,50,114,101,115,105,122,101,65,114,101,97,70,97,115,116,95,73,110,118,111,107,101,114,73,102,102,78,83,95,49,57,82,101,115,105,122,101,65,114,101,97,70,97,115,116,78,111,86,101,99,73,102,102,69,69,69,69,0,99,110,32,61,61,32,52,0,78,50,99,118,50,50,114,101,115,105,122,101,65,114,101,97,70,97,115,116,95,73,110,118,111,107,101,114,73,115,102,78,83,95,49,55,82,101,115,105,122,101,65,114,101,97,70,97,115,116,86,101,99,73,115,78,83,95,49,57,82,101,115,105,122,101,65,114,101,97,70,97,115,116,78,111,86,101,99,73,115,115,69,69,69,69,69,69,0,78,50,99,118,50,50,114,101,115,105,122,101,65,114,101,97,70,97,115,116,95,73,110,118,111,107,101,114,73,116,102,78,83,95,49,55,82,101,115,105,122,101,65,114,101,97,70,97,115,116,86,101,99,73,116,78,83,95,49,57,82,101,115,105,122,101,65,114,101,97,70,97,115,116,78,111,86,101,99,73,116,116,69,69,69,69,69,69,0,78,50,99,118,50,50,114,101,115,105,122,101,65,114,101,97,70,97,115,116,95,73,110,118,111,107,101,114,73,104,105,78,83,95,49,55,82,101,115,105,122,101,65,114,101,97,70,97,115,116,86,101,99,73,104,78,83,95,49,57,82,101,115,105,122,101,65,114,101,97,70,97,115,116,78,111,86,101,99,73,104,104,69,69,69,69,69,69,0,78,50,99,118,49,53,114,101,115,105,122,101,78,78,73,110,118,111,107,101,114,69,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,50,50,114,101,115,105,122,101,95,98,105,116,69,120,97,99,116,73,110,118,111,107,101,114,73,105,78,83,95,49,50,102,105,120,101,100,112,111,105,110,116,54,52,69,76,105,50,69,69,69,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,50,50,114,101,115,105,122,101,95,98,105,116,69,120,97,99,116,73,110,118,111,107,101,114,73,115,78,83,95,49,50,102,105,120,101,100,112,111,105,110,116,51,50,69,76,105,50,69,69,69,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,50,50,114,101,115,105,122,101,95,98,105,116,69,120,97,99,116,73,110,118,111,107,101,114,73,116,78,83,95,49,51,117,102,105,120,101,100,112,111,105,110,116,51,50,69,76,105,50,69,69,69,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,50,50,114,101,115,105,122,101,95,98,105,116,69,120,97,99,116,73,110,118,111,107,101,114,73,97,78,83,95,49,50,102,105,120,101,100,112,111,105,110,116,51,50,69,76,105,50,69,69,69,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,50,50,114,101,115,105,122,101,95,98,105,116,69,120,97,99,116,73,110,118,111,107,101,114,73,104,78,83,95,49,51,117,102,105,120,101,100,112,111,105,110,116,49,54,69,76,105,50,69,69,69,0,118,111,105,100,32,99,118,58,58,104,97,108,58,58,114,101,115,105,122,101,40,105,110,116,44,32,99,111,110,115,116,32,117,99,104,97,114,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,44,32,105,110,116,44,32,117,99,104,97,114,32,42,44,32,115,105,122,101,95,116,44,32,105,110,116,44,32,105,110,116,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,33,115,115,105,122,101,46,101,109,112,116,121,40,41,0,33,100,115,105,122,101,46,101,109,112,116,121,40,41,32,124,124,32,40,105,110,118,95,115,99,97,108,101,95,120,32,62,32,48,32,38,38,32,105,110,118,95,115,99,97,108,101,95,121,32,62,32,48,41,0,118,111,105,100,32,99,118,58,58,114,101,115,105,122,101,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,83,105,122,101,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,99,118,82,101,115,105,122,101,0,97,117,116,111,109,97,116,105,99,95,116,104,114,101,115,104,32,33,61,32,40,67,86,95,84,72,82,69,83,72,95,79,84,83,85,32,124,32,67,86,95,84,72,82,69,83,72,95,84,82,73,65,78,71,76,69,41,0,116,104,114,101,115,104,71,101,110,101,114,105,99,0,78,50,99,118,49,53,84,104,114,101,115,104,111,108,100,82,117,110,110,101,114,69,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,116,104,114,101,115,104,46,99,112,112,0,100,111,117,98,108,101,32,99,118,58,58,116,104,114,101,115,104,111,108,100,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,97,100,97,112,116,105,118,101,84,104,114,101,115,104,111,108,100,0,98,108,111,99,107,83,105,122,101,32,37,32,50,32,61,61,32,49,32,38,38,32,98,108,111,99,107,83,105,122,101,32,62,32,49,0,85,110,107,110,111,119,110,47,117,110,115,117,112,112,111,114,116,101,100,32,97,100,97,112,116,105,118,101,32,116,104,114,101,115,104,111,108,100,32,109,101,116,104,111,100,0,85,110,107,110,111,119,110,47,117,110,115,117,112,112,111,114,116,101,100,32,116,104,114,101,115,104,111,108,100,32,116,121,112,101,0,118,111,105,100,32,99,118,58,58,97,100,97,112,116,105,118,101,84,104,114,101,115,104,111,108,100,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,100,111,117,98,108,101,41,0,115,114,99,46,115,105,122,101,32,61,61,32,100,115,116,46,115,105,122,101,32,38,38,32,115,114,99,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,100,115,116,46,99,104,97,110,110,101,108,115,40,41,32,38,38,32,40,115,114,99,46,100,101,112,116,104,40,41,32,61,61,32,100,115,116,46,100,101,112,116,104,40,41,32,124,124,32,100,115,116,46,100,101,112,116,104,40,41,32,61,61,32,67,86,95,56,85,41,0,99,118,84,104,114,101,115,104,111,108,100,0,99,111,117,110,116,32,62,61,32,48,32,38,38,32,40,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,51,50,83,41,0,109,105,110,69,110,99,108,111,115,105,110,103,67,105,114,99,108,101,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,115,104,97,112,101,100,101,115,99,114,46,99,112,112,0,118,111,105,100,32,99,118,58,58,109,105,110,69,110,99,108,111,115,105,110,103,67,105,114,99,108,101,40,73,110,112,117,116,65,114,114,97,121,44,32,80,111,105,110,116,50,102,32,38,44,32,102,108,111,97,116,32,38,41,0,97,114,99,76,101,110,103,116,104,0,100,111,117,98,108,101,32,99,118,58,58,97,114,99,76,101,110,103,116,104,40,73,110,112,117,116,65,114,114,97,121,44,32,98,111,111,108,41,0,110,112,111,105,110,116,115,32,62,61,32,48,32,38,38,32,40,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,51,50,83,41,0,99,111,110,116,111,117,114,65,114,101,97,0,100,111,117,98,108,101,32,99,118,58,58,99,111,110,116,111,117,114,65,114,101,97,40,73,110,112,117,116,65,114,114,97,121,44,32,98,111,111,108,41,0,110,32,62,61,32,48,32,38,38,32,40,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,51,50,83,41,0,102,105,116,69,108,108,105,112,115,101,0,84,104,101,114,101,32,115,104,111,117,108,100,32,98,101,32,97,116,32,108,101,97,115,116,32,53,32,112,111,105,110,116,115,32,116,111,32,102,105,116,32,116,104,101,32,101,108,108,105,112,115,101,0,99,118,58,58,82,111,116,97,116,101,100,82,101,99,116,32,99,118,58,58,102,105,116,69,108,108,105,112,115,101,40,73,110,112,117,116,65,114,114,97,121,41,0,112,111,105,110,116,83,101,116,66,111,117,110,100,105,110,103,82,101,99,116,0,105,109,103,46,100,101,112,116,104,40,41,32,60,61,32,67,86,95,56,83,32,38,38,32,105,109,103,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,0,109,97,115,107,66,111,117,110,100,105,110,103,82,101,99,116,0,99,118,58,58,82,101,99,116,32,99,118,58,58,98,111,117,110,100,105,110,103,82,101,99,116,40,73,110,112,117,116,65,114,114,97,121,41,0,85,110,115,117,112,112,111,114,116,101,100,32,115,101,113,117,101,110,99,101,32,116,121,112,101,0,99,118,66,111,117,110,100,105,110,103,82,101,99,116,0,84,104,101,32,105,109,97,103,101,47,109,97,116,114,105,120,32,102,111,114,109,97,116,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,116,104,101,32,102,117,110,99,116,105,111,110,0,103,101,116,83,111,98,101,108,75,101,114,110,101,108,115,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,100,101,114,105,118,46,99,112,112,0,84,104,101,32,107,101,114,110,101,108,32,115,105,122,101,32,109,117,115,116,32,98,101,32,111,100,100,32,97,110,100,32,110,111,116,32,108,97,114,103,101,114,32,116,104,97,110,32,51,49,0,100,120,32,62,61,32,48,32,38,38,32,100,121,32,62,61,32,48,32,38,38,32,100,120,43,100,121,32,62,32,48,0,107,115,105,122,101,32,62,32,111,114,100,101,114,0,103,101,116,83,99,104,97,114,114,75,101,114,110,101,108,115,0,100,120,32,62,61,32,48,32,38,38,32,100,121,32,62,61,32,48,32,38,38,32,100,120,43,100,121,32,61,61,32,49,0,118,111,105,100,32,99,118,58,58,83,111,98,101,108,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,83,99,104,97,114,114,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,76,97,112,108,97,99,105,97,110,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,95,115,114,99,46,100,101,112,116,104,40,41,32,61,61,32,67,86,95,56,85,0,67,97,110,110,121,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,99,97,110,110,121,46,99,112,112,0,40,95,100,115,116,46,103,101,116,79,98,106,40,41,32,33,61,32,95,115,114,99,46,103,101,116,79,98,106,40,41,32,124,124,32,95,115,114,99,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,67,49,41,32,38,38,32,34,73,110,112,108,97,99,101,32,112,97,114,97,109,101,116,101,114,115,32,97,114,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,34,0,65,112,101,114,116,117,114,101,32,115,105,122,101,32,115,104,111,117,108,100,32,98,101,32,111,100,100,32,98,101,116,119,101,101,110,32,51,32,97,110,100,32,55,0,78,50,99,118,57,102,105,110,97,108,80,97,115,115,69,0,102,105,110,97,108,80,97,115,115,0,103,108,111,98,97,108,95,104,121,115,116,101,114,101,115,105,115,0,104,121,115,116,101,114,101,115,105,115,0,109,97,103,110,105,116,117,100,101,0,103,114,97,100,105,101,110,116,0,118,105,114,116,117,97,108,32,118,111,105,100,32,99,118,58,58,112,97,114,97,108,108,101,108,67,97,110,110,121,58,58,111,112,101,114,97,116,111,114,40,41,40,99,111,110,115,116,32,99,118,58,58,82,97,110,103,101,32,38,41,32,99,111,110,115,116,0,78,50,99,118,49,51,112,97,114,97,108,108,101,108,67,97,110,110,121,69,0,118,111,105,100,32,99,118,58,58,67,97,110,110,121,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,105,110,116,44,32,98,111,111,108,41,0,95,100,120,46,100,105,109,115,40,41,32,61,61,32,50,0,95,100,120,46,116,121,112,101,40,41,32,61,61,32,67,86,95,49,54,83,67,49,32,124,124,32,95,100,120,46,116,121,112,101,40,41,32,61,61,32,67,86,95,49,54,83,67,51,0,95,100,121,46,116,121,112,101,40,41,32,61,61,32,95,100,120,46,116,121,112,101,40,41,0,95,100,120,46,115,97,109,101,83,105,122,101,40,95,100,121,41,0,118,111,105,100,32,99,118,58,58,67,97,110,110,121,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,98,111,111,108,41,0,115,114,99,46,115,105,122,101,32,61,61,32,100,115,116,46,115,105,122,101,32,38,38,32,115,114,99,46,100,101,112,116,104,40,41,32,61,61,32,67,86,95,56,85,32,38,38,32,100,115,116,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,0,99,118,67,97,110,110,121,0,111,112,101,110,99,118,45,104,105,115,116,0,68,101,115,116,105,110,97,116,105,111,110,32,100,111,117,98,108,101,32,112,111,105,110,116,101,114,32,105,115,32,78,85,76,76,0,99,118,67,111,112,121,72,105,115,116,0,73,110,118,97,108,105,100,32,104,105,115,116,111,103,114,97,109,32,104,101,97,100,101,114,91,115,93,0,78,85,76,76,32,114,97,110,103,101,115,32,112,111,105,110,116,101,114,0,99,118,83,101,116,72,105,115,116,66,105,110,82,97,110,103,101,115,0,73,110,118,97,108,105,100,32,104,105,115,116,111,103,114,97,109,32,104,101,97,100,101,114,0,79,110,101,32,111,102,32,60,114,97,110,103,101,115,62,32,101,108,101,109,101,110,116,115,32,105,115,32,78,85,76,76,0,66,105,110,32,114,97,110,103,101,115,32,115,104,111,117,108,100,32,103,111,32,105,110,32,97,115,99,101,110,116,105,110,103,32,111,114,100,101,114,0,78,117,109,98,101,114,32,111,102,32,100,105,109,101,110,115,105,111,110,115,32,105,115,32,111,117,116,32,111,102,32,114,97,110,103,101,0,99,118,67,114,101,97,116,101,72,105,115,116,0,78,117,108,108,32,60,115,105,122,101,115,62,32,112,111,105,110,116,101,114,0,73,110,118,97,108,105,100,32,104,105,115,116,111,103,114,97,109,32,116,121,112,101,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,104,105,115,116,111,103,114,97,109,46,99,112,112,0,105,115,95,117,110,105,102,111,114,109,0,104,97,118,101,95,114,97,110,103,101,115,0,109,97,116,0,98,105,110,115,0,69,120,112,101,99,116,101,100,32,67,118,77,97,116,78,68,0,105,99,118,82,101,97,100,72,105,115,116,0,85,110,107,110,111,119,110,32,72,105,115,116,111,103,114,97,109,32,116,121,112,101,0,39,116,104,114,101,115,104,39,32,110,111,100,101,32,105,115,32,109,105,115,115,105,110,103,0,99,118,82,101,108,101,97,115,101,72,105,115,116,0,100,105,109,115,32,62,32,48,32,38,38,32,104,105,115,116,83,105,122,101,0,99,97,108,99,72,105,115,116,0,109,97,115,107,46,101,109,112,116,121,40,41,32,124,124,32,109,97,115,107,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,67,49,0,69,105,116,104,101,114,32,114,97,110,103,101,115,44,32,101,105,116,104,101,114,32,117,110,105,102,111,114,109,32,114,97,110,103,101,115,32,115,104,111,117,108,100,32,98,101,32,112,114,111,118,105,100,101,100,0,99,97,108,99,72,105,115,116,95,0,99,97,108,99,72,105,115,116,76,111,111,107,117,112,84,97,98,108,101,115,95,56,117,0,99,104,97,110,110,101,108,115,32,33,61,32,48,32,124,124,32,110,105,109,97,103,101,115,32,61,61,32,100,105,109,115,0,104,105,115,116,80,114,101,112,97,114,101,73,109,97,103,101,115,0,105,109,97,103,101,115,91,106,93,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,0,99,32,62,61,32,48,0,106,32,60,32,110,105,109,97,103,101,115,0,105,109,97,103,101,115,91,106,93,46,115,105,122,101,40,41,32,61,61,32,105,109,115,105,122,101,32,38,38,32,105,109,97,103,101,115,91,106,93,46,100,101,112,116,104,40,41,32,61,61,32,100,101,112,116,104,0,109,97,115,107,46,115,105,122,101,40,41,32,61,61,32,105,109,115,105,122,101,32,38,38,32,109,97,115,107,46,99,104,97,110,110,101,108,115,40,41,32,61,61,32,49,0,114,97,110,103,101,115,91,105,93,32,38,38,32,114,97,110,103,101,115,91,105,93,91,48,93,32,60,32,114,97,110,103,101,115,91,105,93,91,49,93,0,114,97,110,103,101,115,91,105,93,91,107,93,32,60,32,114,97,110,103,101,115,91,105,93,91,107,43,49,93,0,118,111,105,100,32,99,118,58,58,99,97,108,99,72,105,115,116,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,42,44,32,105,110,116,44,32,99,111,110,115,116,32,105,110,116,32,42,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,99,111,110,115,116,32,105,110,116,32,42,44,32,99,111,110,115,116,32,102,108,111,97,116,32,42,42,44,32,98,111,111,108,44,32,98,111,111,108,41,0,110,105,109,97,103,101,115,32,62,32,48,32,38,38,32,100,105,109,115,32,62,32,48,0,114,115,122,32,61,61,32,100,105,109,115,42,50,32,124,124,32,40,114,115,122,32,61,61,32,48,32,38,38,32,105,109,97,103,101,115,46,100,101,112,116,104,40,48,41,32,61,61,32,67,86,95,56,85,41,0,99,115,122,32,61,61,32,48,32,124,124,32,99,115,122,32,61,61,32,100,105,109,115,0,118,111,105,100,32,99,118,58,58,99,97,108,99,72,105,115,116,40,73,110,112,117,116,65,114,114,97,121,79,102,65,114,114,97,121,115,44,32,99,111,110,115,116,32,115,116,100,58,58,118,101,99,116,111,114,60,105,110,116,62,32,38,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,99,111,110,115,116,32,115,116,100,58,58,118,101,99,116,111,114,60,105,110,116,62,32,38,44,32,99,111,110,115,116,32,115,116,100,58,58,118,101,99,116,111,114,60,102,108,111,97,116,62,32,38,44,32,98,111,111,108,41,0,100,105,109,115,32,62,32,48,32,38,38,32,33,104,105,115,116,46,101,109,112,116,121,40,41,0,99,97,108,99,66,97,99,107,80,114,111,106,101,99,116,0,99,97,108,99,66,97,99,107,80,114,111,106,95,0,118,111,105,100,32,99,118,58,58,99,97,108,99,66,97,99,107,80,114,111,106,101,99,116,40,99,111,110,115,116,32,99,118,58,58,77,97,116,32,42,44,32,105,110,116,44,32,99,111,110,115,116,32,105,110,116,32,42,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,99,111,110,115,116,32,102,108,111,97,116,32,42,42,44,32,100,111,117,98,108,101,44,32,98,111,111,108,41,0,72,48,46,105,115,67,111,110,116,105,110,117,111,117,115,40,41,0,110,105,109,97,103,101,115,32,62,32,48,0,114,115,122,32,61,61,32,100,105,109,115,42,50,32,124,124,32,40,114,115,122,32,61,61,32,50,32,38,38,32,95,49,100,41,32,124,124,32,40,114,115,122,32,61,61,32,48,32,38,38,32,105,109,97,103,101,115,46,100,101,112,116,104,40,48,41,32,61,61,32,67,86,95,56,85,41,0,99,115,122,32,61,61,32,48,32,124,124,32,99,115,122,32,61,61,32,100,105,109,115,32,124,124,32,40,99,115,122,32,61,61,32,49,32,38,38,32,95,49,100,41,0,118,111,105,100,32,99,118,58,58,99,97,108,99,66,97,99,107,80,114,111,106,101,99,116,40,73,110,112,117,116,65,114,114,97,121,79,102,65,114,114,97,121,115,44,32,99,111,110,115,116,32,115,116,100,58,58,118,101,99,116,111,114,60,105,110,116,62,32,38,44,32,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,99,111,110,115,116,32,115,116,100,58,58,118,101,99,116,111,114,60,102,108,111,97,116,62,32,38,44,32,100,111,117,98,108,101,41,0,72,49,46,116,121,112,101,40,41,32,61,61,32,72,50,46,116,121,112,101,40,41,32,38,38,32,72,49,46,100,101,112,116,104,40,41,32,61,61,32,67,86,95,51,50,70,0,99,111,109,112,97,114,101,72,105,115,116,0,105,116,46,112,108,97,110,101,115,91,48,93,46,105,115],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+245761);allocate([67,111,110,116,105,110,117,111,117,115,40,41,32,38,38,32,105,116,46,112,108,97,110,101,115,91,49,93,46,105,115,67,111,110,116,105,110,117,111,117,115,40,41,0,100,111,117,98,108,101,32,99,118,58,58,99,111,109,112,97,114,101,72,105,115,116,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,95,115,114,99,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,67,49,0,101,113,117,97,108,105,122,101,72,105,115,116,0,50,51,69,113,117,97,108,105,122,101,72,105,115,116,76,117,116,95,73,110,118,111,107,101,114,0,50,56,69,113,117,97,108,105,122,101,72,105,115,116,67,97,108,99,72,105,115,116,95,73,110,118,111,107,101,114,0,118,111,105,100,32,99,118,58,58,101,113,117,97,108,105,122,101,72,105,115,116,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,41,0,109,49,116,121,112,101,32,61,61,32,67,86,95,49,54,83,67,50,32,124,124,32,109,49,116,121,112,101,32,61,61,32,67,86,95,51,50,70,67,49,32,124,124,32,109,49,116,121,112,101,32,61,61,32,67,86,95,51,50,70,67,50,0,105,110,105,116,85,110,100,105,115,116,111,114,116,82,101,99,116,105,102,121,77,97,112,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,117,110,100,105,115,116,111,114,116,46,99,112,112,0,65,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,51,44,51,41,32,38,38,32,65,46,115,105,122,101,40,41,32,61,61,32,82,46,115,105,122,101,40,41,0,65,114,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,51,44,51,41,32,124,124,32,65,114,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,52,44,32,51,41,0,100,105,115,116,67,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,44,32,52,41,32,124,124,32,100,105,115,116,67,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,52,44,32,49,41,32,124,124,32,100,105,115,116,67,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,44,32,53,41,32,124,124,32,100,105,115,116,67,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,53,44,32,49,41,32,124,124,32,100,105,115,116,67,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,44,32,56,41,32,124,124,32,100,105,115,116,67,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,56,44,32,49,41,32,124,124,32,100,105,115,116,67,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,44,32,49,50,41,32,124,124,32,100,105,115,116,67,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,50,44,32,49,41,32,124,124,32,100,105,115,116,67,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,44,32,49,52,41,32,124,124,32,100,105,115,116,67,111,101,102,102,115,46,115,105,122,101,40,41,32,61,61,32,83,105,122,101,40,49,52,44,32,49,41,0,109,49,32,33,61,32,78,85,76,76,32,38,38,32,109,50,32,33,61,32,78,85,76,76,0,109,49,102,32,33,61,32,78,85,76,76,32,38,38,32,109,50,102,32,33,61,32,78,85,76,76,0,109,49,32,33,61,32,78,85,76,76,0,51,49,105,110,105,116,85,110,100,105,115,116,111,114,116,82,101,99,116,105,102,121,77,97,112,67,111,109,112,117,116,101,114,0,68,97,116,97,84,121,112,101,60,95,84,112,62,58,58,99,104,97,110,110,101,108,115,32,61,61,32,109,46,99,104,97,110,110,101,108,115,40,41,32,124,124,32,109,46,101,109,112,116,121,40,41,0,100,115,116,46,100,97,116,97,32,33,61,32,115,114,99,46,100,97,116,97,0,117,110,100,105,115,116,111,114,116,0,118,111,105,100,32,99,118,58,58,117,110,100,105,115,116,111,114,116,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,41,0,97,114,114,32,33,61,32,48,32,38,38,32,99,111,110,116,111,117,114,95,104,101,97,100,101,114,32,33,61,32,48,32,38,38,32,98,108,111,99,107,32,33,61,32,48,0,99,118,80,111,105,110,116,83,101,113,70,114,111,109,77,97,116,0,73,110,112,117,116,32,97,114,114,97,121,32,105,115,32,110,111,116,32,97,32,118,97,108,105,100,32,109,97,116,114,105,120,0,84,104,101,32,109,97,116,114,105,120,32,99,97,110,32,110,111,116,32,98,101,32,99,111,110,118,101,114,116,101,100,32,116,111,32,112,111,105,110,116,32,115,101,113,117,101,110,99,101,32,98,101,99,97,117,115,101,32,111,102,32,105,110,97,112,112,114,111,112,114,105,97,116,101,32,101,108,101,109,101,110,116,32,116,121,112,101,0,84,104,101,32,109,97,116,114,105,120,32,99,111,110,118,101,114,116,101,100,32,116,111,32,112,111,105,110,116,32,115,101,113,117,101,110,99,101,32,109,117,115,116,32,98,101,32,49,45,100,105,109,101,110,115,105,111,110,97,108,32,97,110,100,32,99,111,110,116,105,110,117,111,117,115,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,117,116,105,108,115,46,99,112,112,0,100,101,112,116,104,32,61,61,32,67,86,95,56,85,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,49,54,85,0,115,99,110,32,61,61,32,49,32,38,38,32,100,99,110,32,61,61,32,49,0,66,97,121,101,114,45,62,71,114,97,121,32,100,101,109,111,115,97,105,99,105,110,103,32,111,110,108,121,32,115,117,112,112,111,114,116,115,32,56,117,32,97,110,100,32,49,54,117,32,116,121,112,101,115,0,115,99,110,32,61,61,32,49,32,38,38,32,40,100,99,110,32,61,61,32,51,32,124,124,32,100,99,110,32,61,61,32,52,41,0,66,97,121,101,114,45,62,82,71,66,32,100,101,109,111,115,97,105,99,105,110,103,32,111,110,108,121,32,115,117,112,112,111,114,116,115,32,56,117,32,97,110,100,32,49,54,117,32,116,121,112,101,115,0,115,99,110,32,61,61,32,49,32,38,38,32,100,99,110,32,61,61,32,51,0,66,97,121,101,114,45,62,82,71,66,32,69,100,103,101,45,65,119,97,114,101,32,100,101,109,111,115,97,105,99,105,110,103,32,111,110,108,121,32,99,117,114,114,101,110,116,108,121,32,115,117,112,112,111,114,116,115,32,56,117,32,97,110,100,32,49,54,117,32,116,121,112,101,115,0,85,110,107,110,111,119,110,32,47,32,117,110,115,117,112,112,111,114,116,101,100,32,99,111,108,111,114,32,99,111,110,118,101,114,115,105,111,110,32,99,111,100,101,0,78,50,99,118,50,57,66,97,121,101,114,50,82,71,66,95,69,100,103,101,65,119,97,114,101,95,84,95,73,110,118,111,107,101,114,73,116,78,83,95,50,54,83,73,77,68,66,97,121,101,114,83,116,117,98,73,110,116,101,114,112,111,108,97,116,111,114,95,73,116,69,69,69,69,0,78,50,99,118,50,57,66,97,121,101,114,50,82,71,66,95,69,100,103,101,65,119,97,114,101,95,84,95,73,110,118,111,107,101,114,73,104,78,83,95,50,54,83,73,77,68,66,97,121,101,114,83,116,117,98,73,110,116,101,114,112,111,108,97,116,111,114,95,73,104,69,69,69,69,0,78,50,99,118,49,55,66,97,121,101,114,50,82,71,66,95,73,110,118,111,107,101,114,73,116,78,83,95,50,54,83,73,77,68,66,97,121,101,114,83,116,117,98,73,110,116,101,114,112,111,108,97,116,111,114,95,73,116,69,69,69,69,0,78,50,99,118,49,55,66,97,121,101,114,50,82,71,66,95,73,110,118,111,107,101,114,73,104,78,83,95,50,54,83,73,77,68,66,97,121,101,114,83,116,117,98,73,110,116,101,114,112,111,108,97,116,111,114,95,73,104,69,69,69,69,0,78,50,99,118,49,56,66,97,121,101,114,50,71,114,97,121,95,73,110,118,111,107,101,114,73,116,78,83,95,50,54,83,73,77,68,66,97,121,101,114,83,116,117,98,73,110,116,101,114,112,111,108,97,116,111,114,95,73,116,69,69,69,69,0,78,50,99,118,49,56,66,97,121,101,114,50,71,114,97,121,95,73,110,118,111,107,101,114,73,104,78,83,95,50,54,83,73,77,68,66,97,121,101,114,83,116,117,98,73,110,116,101,114,112,111,108,97,116,111,114,95,73,104,69,69,69,69,0,100,101,109,111,115,97,105,99,105,110,103,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,100,101,109,111,115,97,105,99,105,110,103,46,99,112,112,0,118,111,105,100,32,99,118,58,58,100,101,109,111,115,97,105,99,105,110,103,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,41,0,98,111,114,100,101,114,84,121,112,101,32,33,61,32,66,79,82,68,69,82,95,67,79,78,83,84,65,78,84,0,112,121,114,68,111,119,110,0,112,121,114,68,111,119,110,95,0,115,115,105,122,101,46,119,105,100,116,104,32,62,32,48,32,38,38,32,115,115,105,122,101,46,104,101,105,103,104,116,32,62,32,48,32,38,38,32,115,116,100,58,58,97,98,115,40,100,115,105,122,101,46,119,105,100,116,104,42,50,32,45,32,115,115,105,122,101,46,119,105,100,116,104,41,32,60,61,32,50,32,38,38,32,115,116,100,58,58,97,98,115,40,100,115,105,122,101,46,104,101,105,103,104,116,42,50,32,45,32,115,115,105,122,101,46,104,101,105,103,104,116,41,32,60,61,32,50,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,112,121,114,97,109,105,100,115,46,99,112,112,0,118,111,105,100,32,99,118,58,58,112,121,114,68,111,119,110,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,99,111,110,115,116,32,83,105,122,101,32,38,44,32,105,110,116,41,0,98,111,114,100,101,114,84,121,112,101,32,61,61,32,66,79,82,68,69,82,95,68,69,70,65,85,76,84,0,112,121,114,85,112,0,115,116,100,58,58,97,98,115,40,100,115,105,122,101,46,119,105,100,116,104,32,45,32,115,115,105,122,101,46,119,105,100,116,104,42,50,41,32,61,61,32,100,115,105,122,101,46,119,105,100,116,104,32,37,32,50,32,38,38,32,115,116,100,58,58,97,98,115,40,100,115,105,122,101,46,104,101,105,103,104,116,32,45,32,115,115,105,122,101,46,104,101,105,103,104,116,42,50,41,32,61,61,32,100,115,105,122,101,46,104,101,105,103,104,116,32,37,32,50,0,112,121,114,85,112,95,0,118,111,105,100,32,99,118,58,58,112,121,114,85,112,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,99,111,110,115,116,32,83,105,122,101,32,38,44,32,105,110,116,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,99,111,108,111,114,46,99,112,112,0,99,118,116,67,111,108,111,114,0,118,111,105,100,32,99,118,58,58,99,118,116,67,111,108,111,114,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,105,110,116,41,0,115,114,99,46,100,101,112,116,104,40,41,32,61,61,32,100,115,116,46,100,101,112,116,104,40,41,0,99,118,67,118,116,67,111,108,111,114,0,100,115,116,46,100,97,116,97,32,61,61,32,100,115,116,48,46,100,97,116,97,0,85,110,107,110,111,119,110,32,99,111,109,112,97,114,105,115,111,110,32,109,101,116,104,111,100,0,109,97,116,99,104,83,104,97,112,101,115,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,109,97,116,99,104,99,111,110,116,111,117,114,115,46,99,112,112,0,100,111,117,98,108,101,32,99,118,58,58,109,97,116,99,104,83,104,97,112,101,115,40,73,110,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,100,111,117,98,108,101,41,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,49,48,67,76,65,72,69,95,73,109,112,108,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,95,115,114,99,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,67,49,32,124,124,32,95,115,114,99,46,116,121,112,101,40,41,32,61,61,32,67,86,95,49,54,85,67,49,0,85,110,115,117,112,112,111,114,116,101,100,32,116,121,112,101,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,50,52,67,76,65,72,69,95,73,110,116,101,114,112,111,108,97,116,105,111,110,95,66,111,100,121,73,116,76,105,48,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,50,52,67,76,65,72,69,95,73,110,116,101,114,112,111,108,97,116,105,111,110,95,66,111,100,121,73,116,76,105,48,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,50,52,67,76,65,72,69,95,73,110,116,101,114,112,111,108,97,116,105,111,110,95,66,111,100,121,73,104,76,105,48,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,50,52,67,76,65,72,69,95,73,110,116,101,114,112,111,108,97,116,105,111,110,95,66,111,100,121,73,104,76,105,48,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,49,56,67,76,65,72,69,95,67,97,108,99,76,117,116,95,66,111,100,121,73,116,76,105,54,53,53,51,54,69,76,105,48,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,49,56,67,76,65,72,69,95,67,97,108,99,76,117,116,95,66,111,100,121,73,116,76,105,54,53,53,51,54,69,76,105,48,69,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,49,56,67,76,65,72,69,95,67,97,108,99,76,117,116,95,66,111,100,121,73,104,76,105,50,53,54,69,76,105,48,69,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,52,95,69,69,69,69,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,49,56,67,76,65,72,69,95,67,97,108,99,76,117,116,95,66,111,100,121,73,104,76,105,50,53,54,69,76,105,48,69,69,69,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,99,108,97,104,101,46,99,112,112,0,118,105,114,116,117,97,108,32,118,111,105,100,32,40,97,110,111,110,121,109,111,117,115,32,110,97,109,101,115,112,97,99,101,41,58,58,67,76,65,72,69,95,73,109,112,108,58,58,97,112,112,108,121,40,99,118,58,58,73,110,112,117,116,65,114,114,97,121,44,32,99,118,58,58,79,117,116,112,117,116,65,114,114,97,121,41,0,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,49,48,67,76,65,72,69,95,73,109,112,108,69,0,67,86,95,77,65,84,95,67,78,40,115,117,109,84,121,112,101,41,32,61,61,32,67,86,95,77,65,84,95,67,78,40,115,114,99,84,121,112,101,41,0,103,101,116,82,111,119,83,117,109,70,105,108,116,101,114,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,109,98,105,110,97,116,105,111,110,32,111,102,32,115,111,117,114,99,101,32,102,111,114,109,97,116,32,40,61,37,100,41,44,32,97,110,100,32,98,117,102,102,101,114,32,102,111,114,109,97,116,32,40,61,37,100,41,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,54,82,111,119,83,117,109,73,100,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,82,111,119,83,117,109,73,100,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,54,82,111,119,83,117,109,73,102,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,82,111,119,83,117,109,73,102,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,54,82,111,119,83,117,109,73,115,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,82,111,119,83,117,109,73,115,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,54,82,111,119,83,117,109,73,105,105,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,82,111,119,83,117,109,73,105,105,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,54,82,111,119,83,117,109,73,115,105,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,82,111,119,83,117,109,73,115,105,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,54,82,111,119,83,117,109,73,116,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,82,111,119,83,117,109,73,116,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,54,82,111,119,83,117,109,73,116,105,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,82,111,119,83,117,109,73,116,105,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,54,82,111,119,83,117,109,73,104,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,82,111,119,83,117,109,73,104,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,54,82,111,119,83,117,109,73,104,116,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,82,111,119,83,117,109,73,104,116,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,54,82,111,119,83,117,109,73,104,105,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,54,82,111,119,83,117,109,73,104,105,69,69,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,115,109,111,111,116,104,46,99,112,112,0,67,86,95,77,65,84,95,67,78,40,115,117,109,84,121,112,101,41,32,61,61,32,67,86,95,77,65,84,95,67,78,40,100,115,116,84,121,112,101,41,0,103,101,116,67,111,108,117,109,110,83,117,109,70,105,108,116,101,114,0,85,110,115,117,112,112,111,114,116,101,100,32,99,111,109,98,105,110,97,116,105,111,110,32,111,102,32,115,117,109,32,102,111,114,109,97,116,32,40,61,37,100,41,44,32,97,110,100,32,100,101,115,116,105,110,97,116,105,111,110,32,102,111,114,109,97,116,32,40,61,37,100,41,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,100,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,115,117,109,67,111,117,110,116,32,61,61,32,107,115,105,122,101,45,49,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,100,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,105,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,105,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,100,102,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,100,102,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,105,102,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,105,102,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,105,105,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,105,105,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,100,115,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,100,115,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,105,115,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,105,115,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,100,116,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,100,116,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,105,116,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,105,116,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,100,104,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,100,104,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,116,104,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,116,104,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,67,111,108,117,109,110,83,117,109,73,105,104,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,67,111,108,117,109,110,83,117,109,73,105,104,69,69,0,118,111,105,100,32,99,118,58,58,98,111,120,70,105,108,116,101,114,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,83,105,122,101,44,32,80,111,105,110,116,44,32,98,111,111,108,44,32,105,110,116,41,0,118,111,105,100,32,99,118,58,58,98,108,117,114,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,83,105,122,101,44,32,80,111,105,110,116,44,32,105,110,116,41,0,103,101,116,83,113,114,82,111,119,83,117,109,70,105,108,116,101,114,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,83,113,114,82,111,119,83,117,109,73,100,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,83,113,114,82,111,119,83,117,109,73,100,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,83,113,114,82,111,119,83,117,109,73,102,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,83,113,114,82,111,119,83,117,109,73,102,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,83,113,114,82,111,119,83,117,109,73,115,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,83,113,114,82,111,119,83,117,109,73,115,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,83,113,114,82,111,119,83,117,109,73,116,100,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,83,113,114,82,111,119,83,117,109,73,116,100,69,69,0,78,50,99,118,54,100,101,116,97,105,108,49,50,80,116,114,79,119,110,101,114,73,109,112,108,73,78,83,95,57,83,113,114,82,111,119,83,117,109,73,104,105,69,69,78,83,95,49,52,68,101,102,97,117,108,116,68,101,108,101,116,101,114,73,83,51,95,69,69,69,69,0,78,50,99,118,57,83,113,114,82,111,119,83,117,109,73,104,105,69,69,0,118,111,105,100,32,99,118,58,58,115,113,114,66,111,120,70,105,108,116,101,114,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,83,105,122,101,44,32,80,111,105,110,116,44,32,98,111,111,108,44,32,105,110,116,41,0,103,101,116,71,97,117,115,115,105,97,110,75,101,114,110,101,108,0,107,116,121,112,101,32,61,61,32,67,86,95,51,50,70,32,124,124,32,107,116,121,112,101,32,61,61,32,67,86,95,54,52,70,0,107,115,105,122,101,46,119,105,100,116,104,32,62,32,48,32,38,38,32,107,115,105,122,101,46,119,105,100,116,104,32,37,32,50,32,61,61,32,49,32,38,38,32,107,115,105,122,101,46,104,101,105,103,104,116,32,62,32,48,32,38,38,32,107,115,105,122,101,46,104,101,105,103,104,116,32,37,32,50,32,61,61,32,49,0,99,114,101,97,116,101,71,97,117,115,115,105,97,110,75,101,114,110,101,108,115,0,78,50,99,118,49,56,102,105,120,101,100,83,109,111,111,116,104,73,110,118,111,107,101,114,73,104,78,49,50,95,71,76,79,66,65,76,95,95,78,95,49,49,51,117,102,105,120,101,100,112,111,105,110,116,49,54,69,69,69,0,118,111,105,100,32,99,118,58,58,71,97,117,115,115,105,97,110,66,108,117,114,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,83,105,122,101,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,40,107,115,105,122,101,32,37,32,50,32,61,61,32,49,41,32,38,38,32,40,95,115,114,99,48,46,100,105,109,115,40,41,32,60,61,32,50,32,41,0,109,101,100,105,97,110,66,108,117,114,0,115,114,99,46,100,101,112,116,104,40,41,32,61,61,32,67,86,95,56,85,32,38,38,32,40,99,110,32,61,61,32,49,32,124,124,32,99,110,32,61,61,32,51,32,124,124,32,99,110,32,61,61,32,52,41,0,99,110,32,62,32,48,32,38,38,32,99,110,32,60,61,32,52,0,109,101,100,105,97,110,66,108,117,114,95,56,117,95,79,109,0,109,101,100,105,97,110,66,108,117,114,95,56,117,95,79,49,0,107,32,60,32,49,54,0,98,32,60,32,49,54,0,118,111,105,100,32,99,118,58,58,109,101,100,105,97,110,66,108,117,114,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,41,0,40,115,114,99,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,67,49,32,124,124,32,115,114,99,46,116,121,112,101,40,41,32,61,61,32,67,86,95,56,85,67,51,41,32,38,38,32,115,114,99,46,100,97,116,97,32,33,61,32,100,115,116,46,100,97,116,97,0,98,105,108,97,116,101,114,97,108,70,105,108,116,101,114,95,56,117,0,40,115,114,99,46,116,121,112,101,40,41,32,61,61,32,67,86,95,51,50,70,67,49,32,124,124,32,115,114,99,46,116,121,112,101,40,41,32,61,61,32,67,86,95,51,50,70,67,51,41,32,38,38,32,115,114,99,46,100,97,116,97,32,33,61,32,100,115,116,46,100,97,116,97,0,98,105,108,97,116,101,114,97,108,70,105,108,116,101,114,95,51,50,102,0,66,105,108,97,116,101,114,97,108,32,102,105,108,116,101,114,105,110,103,32,105,115,32,111,110,108,121,32,105,109,112,108,101,109,101,110,116,101,100,32,102,111,114,32,56,117,32,97,110,100,32,51,50,102,32,105,109,97,103,101,115,0,98,105,108,97,116,101,114,97,108,70,105,108,116,101,114,0,99,110,32,61,61,32,51,0,78,50,99,118,50,55,66,105,108,97,116,101,114,97,108,70,105,108,116,101,114,95,51,50,102,95,73,110,118,111,107,101,114,69,0,78,50,99,118,50,54,66,105,108,97,116,101,114,97,108,70,105,108,116,101,114,95,56,117,95,73,110,118,111,107,101,114,69,0,118,111,105,100,32,99,118,58,58,98,105,108,97,116,101,114,97,108,70,105,108,116,101,114,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,105,110,116,41,0,98,111,111,108,32,99,118,58,58,99,108,105,112,76,105,110,101,40,83,105,122,101,50,108,44,32,80,111,105,110,116,50,108,32,38,44,32,80,111,105,110,116,50,108,32,38,41,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,100,114,97,119,105,110,103,46,99,112,112,0,76,105,110,101,73,116,101,114,97,116,111,114,0,118,111,105,100,32,99,118,58,58,101,108,108,105,112,115,101,50,80,111,108,121,40,80,111,105,110,116,50,100,44,32,83,105,122,101,50,100,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,44,32,115,116,100,58,58,118,101,99,116,111,114,60,80,111,105,110,116,50,100,62,32,38,41,0,48,32,60,32,116,104,105,99,107,110,101,115,115,32,38,38,32,116,104,105,99,107,110,101,115,115,32,60,61,32,77,65,88,95,84,72,73,67,75,78,69,83,83,0,108,105,110,101,0,48,32,60,61,32,115,104,105,102,116,32,38,38,32,115,104,105,102,116,32,60,61,32,88,89,95,83,72,73,70,84,0,48,32,60,61,32,115,104,105,102,116,32,38,38,32,115,104,105,102,116,32,60,61,32,88,89,95,83,72,73,70,84,32,38,38,32,116,104,105,99,107,110,101,115,115,32,62,61,32,48,0,80,111,108,121,76,105,110,101,0,181,181,181,182,182,183,184,185,187,188,190,192,194,196,198,201,203,206,209,211,214,218,221,224,227,231,235,238,242,246,250,254,118,111,105,100,32,99,118,58,58,108,105,110,101,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,80,111,105,110,116,44,32,80,111,105,110,116,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,41,0,116,104,105,99,107,110,101,115,115,32,60,61,32,77,65,88,95,84,72,73,67,75,78,69,83,83,0,114,101,99,116,97,110,103,108,101,0,118,111,105,100,32,99,118,58,58,114,101,99,116,97,110,103,108,101,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,80,111,105,110,116,44,32,80,111,105,110,116,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,41,0,114,97,100,105,117,115,32,62,61,32,48,32,38,38,32,116,104,105,99,107,110,101,115,115,32,60,61,32,77,65,88,95,84,72,73,67,75,78,69,83,83,32,38,38,32,48,32,60,61,32,115,104,105,102,116,32,38,38,32,115,104,105,102,116,32,60,61,32,88,89,95,83,72,73,70,84,0,99,105,114,99,108,101,0,118,111,105,100,32,99,118,58,58,99,105,114,99,108,101,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,80,111,105,110,116,44,32,105,110,116,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,41,0,97,120,101,115,46,119,105,100,116,104,32,62,61,32,48,32,38,38,32,97,120,101,115,46,104,101,105,103,104,116,32,62,61,32,48,32,38,38,32,116,104,105,99,107,110,101,115,115,32,60,61,32,77,65,88,95,84,72,73,67,75,78,69,83,83,32,38,38,32,48,32,60,61,32,115,104,105,102,116,32,38,38,32,115,104,105,102,116,32,60,61,32,88,89,95,83,72,73,70,84,0,101,108,108,105,112,115,101,0,118,111,105,100,32,99,118,58,58,101,108,108,105,112,115,101,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,80,111,105,110,116,44,32,83,105,122,101,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,100,111,117,98,108,101,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,105,110,116,44,32,105,110,116,44,32,105,110,116,41,0,98,111,120,46,115,105,122,101,46,119,105,100,116,104,32,62,61,32,48,32,38,38,32,98,111,120,46,115,105,122,101,46,104,101,105,103,104,116,32,62,61,32,48,32,38,38,32,116,104,105,99,107,110,101,115,115,32,60,61,32,77,65,88,95,84,72,73,67,75,78,69,83,83,0,118,111,105,100,32,99,118,58,58,101,108,108,105,112,115,101,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,99,111,110,115,116,32,99,118,58,58,82,111,116,97,116,101,100,82,101,99,116,32,38,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,105,110,116,44,32,105,110,116,41,0,85,110,107,110,111,119,110,32,102,111,110,116,32,116,121,112,101,0,103,101,116,70,111,110,116,68,97,116,97,0,118,111,105,100,32,99,118,58,58,112,117,116,84,101,120,116,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,99,111,110,115,116,32,99,118,58,58,83,116,114,105,110,103,32,38,44,32,80,111,105,110,116,44,32,105,110,116,44,32,100,111,117,98,108,101,44,32,83,99,97,108,97,114,44,32,105,110,116,44,32,105,110,116,44,32,98,111,111,108,41,0,48,32,60,61,32,99,111,110,116,111,117,114,73,100,120,32,38,38,32,99,111,110,116,111,117,114,73,100,120,32,60,32,40,105,110,116,41,108,97,115,116,0,100,114,97,119,67,111,110,116,111,117,114,115,0,110,112,111,105,110,116,115,32,62,32,48,0,104,105,101,114,97,114,99,104,121,46,116,111,116,97,108,40,41,32,61,61,32,110,99,111,110,116,111,117,114,115,32,38,38,32,104,105,101,114,97,114,99,104,121,46,116,121,112,101,40,41,32,61,61,32,67,86,95,51,50,83,67,52,0,99,118,68,114,97,119,67,111,110,116,111,117,114,115,0,114,101,97,100,101,114,46,112,116,114,32,33,61,32,78,85,76,76,0,101,108,101,109,95,116,121,112,101,32,61,61,32,67,86,95,51,50,83,67,50,0,118,111,105,100,32,99,118,58,58,100,114,97,119,67,111,110,116,111,117,114,115,40,73,110,112,117,116,79,117,116,112,117,116,65,114,114,97,121,44,32,73,110,112,117,116,65,114,114,97,121,79,102,65,114,114,97,121,115,44,32,105,110,116,44,32,99,111,110,115,116,32,83,99,97,108,97,114,32,38,44,32,105,110,116,44,32,105,110,116,44,32,73,110,112,117,116,65,114,114,97,121,44,32,105,110,116,44,32,80,111,105,110,116,41,0,67,86,95,73,83,95,83,69,81,95,67,72,65,73,78,95,67,79,78,84,79,85,82,40,32,99,104,97,105,110,32,41,0,105,99,118,65,112,112,114,111,120,105,109,97,116,101,67,104,97,105,110,84,67,56,57,0,47,98,117,105,108,100,47,51,95,52,45,99,111,110,116,114,105,98,95,100,111,99,115,45,108,105,110,54,52,47,111,112,101,110,99,118,47,109,111,100,117,108,101,115,47,105,109,103,112,114,111,99,47,115,114,99,47,97,112,112,114,111,120,46,99,112,112,0,104,101,97,100,101,114,95,115,105,122,101,32,62,61,32,40,105,110,116,41,115,105,122,101,111,102,40,67,118,67,111,110,116,111,117,114,41,0,110,112,111,105,110,116,115,32,62,61,32,48,32,38,38,32,40,100,101,112,116,104,32,61,61,32,67,86,95,51,50,83,32,124,124,32,100,101,112,116,104,32,61,61,32,67,86,95,51,50,70,41,0,97,112,112,114,111,120,80,111,108,121,68,80,0,118,111,105,100,32,99,118,58,58,97,112,112,114,111,120,80,111,108,121,68,80,40,73,110,112,117,116,65,114,114,97,121,44,32,79,117,116,112,117,116,65,114,114,97,121,44,32,100,111,117,98,108,101,44,32,98,111,111,108,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+256001);allocate([60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,77,87,82,77,78,86,32,82,77,86,86,32,80,83,84,83,0,77,87,79,77,79,86,32,79,77,83,77,85,78,85,80,83,81,32,79,81,83,81,85,82,85,85,83,86,79,86,0,77,88,86,78,84,77,82,77,80,78,79,80,79,83,80,85,82,86,84,86,86,85,0,77,87,79,77,79,86,32,79,77,82,77,84,78,85,80,85,83,84,85,82,86,79,86,0,77,87,79,77,79,86,32,79,77,85,77,32,79,81,83,81,32,79,86,85,86,0,77,86,79,77,79,86,32,79,77,85,77,32,79,81,83,81,0,77,88,86,78,84,77,82,77,80,78,79,80,79,83,80,85,82,86,84,86,86,85,86,82,32,83,82,86,82,0,77,87,79,77,79,86,32,85,77,85,86,32,79,81,85,81,0,80,84,82,77,82,86,0,78,85,83,77,83,84,82,86,80,86,79,84,79,83,0,77,87,79,77,79,86,32,85,77,79,83,32,81,81,85,86,0,77,86,79,77,79,86,32,79,86,85,86,0,76,88,78,77,78,86,32,78,77,82,86,32,86,77,82,86,32,86,77,86,86,0,77,87,79,77,79,86,32,79,77,85,86,32,85,77,85,86,0,77,88,82,77,80,78,79,80,79,83,80,85,82,86,83,86,85,85,86,83,86,80,85,78,83,77,82,77,0,77,87,79,77,79,86,32,79,77,83,77,85,78,85,81,83,82,79,82,0,77,88,82,77,80,78,79,80,79,83,80,85,82,86,83,86,85,85,86,83,86,80,85,78,83,77,82,77,32,83,84,86,87,0,77,87,79,77,79,86,32,79,77,83,77,85,78,85,81,83,82,79,82,32,82,82,85,86,0,77,87,85,78,83,77,81,77,79,78,79,79,80,80,84,82,85,83,85,85,83,86,81,86,79,85,0,77,87,82,77,82,86,32,78,77,86,77,0,77,88,79,77,79,83,80,85,82,86,83,86,85,85,86,83,86,77,0,77,87,78,77,82,86,32,86,77,82,86,0,76,88,78,77,80,86,32,82,77,80,86,32,82,77,84,86,32,86,77,84,86,0,77,87,79,77,85,86,32,85,77,79,86,0,77,87,78,77,82,81,82,86,32,86,77,82,81,0,77,87,85,77,79,86,32,79,77,85,77,32,79,86,85,86,0,77,86,79,77,79,86,32,79,77,85,77,0,77,87,82,77,78,86,32,82,77,86,86,32,78,86,86,86,0,77,88,82,77,80,78,79,80,79,83,80,85,82,86,83,86,85,85,86,83,86,80,85,78,83,77,82,77,32,81,81,84,82,32,84,81,81,82,0,77,87,82,77,78,86,32,82,77,86,86,0,77,87,79,77,85,77,32,80,81,84,82,32,84,81,80,82,32,79,86,85,86,0,77,87,79,77,79,86,32,85,77,85,86,32,79,77,85,77,0,77,87,79,77,82,81,79,86,32,79,77,85,77,32,79,86,85,86,0,77,87,78,79,78,78,79,77,80,77,81,78,82,80,82,86,32,86,79,86,78,85,77,84,77,83,78,82,80,0,76,88,82,77,82,86,32,80,79,78,80,78,83,80,84,84,84,86,83,86,80,84,79,80,79,0,76,88,82,77,82,86,32,78,79,79,80,79,83,81,84,83,84,85,83,85,80,86,79,0,77,88,79,86,81,86,79,82,79,80,80,78,82,77,83,77,85,78,86,80,86,82,84,86,86,86,0,77,87,83,77,77,86,32,83,77,85,86,32,79,83,84,83,0,77,87,81,77,78,86,32,81,77,84,77,86,78,86,80,83,81,80,81,32,83,81,85,82,85,84,84,85,82,86,78,86,0,76,88,86,80,85,78,84,77,82,77,80,78,79,79,78,81,78,83,79,85,80,86,82,86,84,85,85,84,0,77,88,81,77,78,86,32,81,77,85,77,86,79,86,81,85,84,84,85,82,86,78,86,0,77,86,81,77,78,86,32,81,77,86,77,32,80,81,83,81,32,78,86,83,86,0,77,86,81,77,78,86,32,81,77,86,77,32,80,81,83,81,0,76,88,86,80,85,78,84,77,82,77,80,78,79,79,78,81,78,83,79,85,80,86,82,86,84,85,85,83,82,83,0,77,88,81,77,78,86,32,87,77,84,86,32,80,81,85,81,0,80,85,84,77,81,86,0,79,86,85,77,83,83,82,85,81,86,80,86,79,85,79,84,0,77,86,81,77,78,86,32,86,77,79,83,32,82,81,84,86,0,78,86,82,77,79,86,32,79,86,84,86,0,76,89,80,77,77,86,32,80,77,81,86,32,88,77,81,86,32,88,77,85,86,0,77,88,81,77,78,86,32,81,77,84,86,32,87,77,84,86,0,76,88,82,77,80,78,79,79,78,81,78,83,79,85,80,86,82,86,84,85,85,84,86,82,86,80,85,78,84,77,82,77,0,77,87,81,77,78,86,32,81,77,85,77,86,78,86,80,85,81,83,82,80,82,0,76,88,82,77,80,78,79,79,78,81,78,83,79,85,80,86,82,86,84,85,85,84,86,82,86,80,85,78,84,77,82,77,32,81,86,80,85,80,84,81,83,82,83,83,84,84,86,85,87,86,87,0,77,87,81,77,78,86,32,81,77,85,77,86,78,86,80,85,81,83,82,80,82,32,81,82,82,85,83,86,84,86,85,85,0,77,87,86,78,84,77,82,77,80,78,80,80,81,81,84,82,85,83,85,85,83,86,80,86,78,85,0,77,86,83,77,80,86,32,80,77,86,77,0,76,88,80,77,78,83,78,85,79,86,82,86,84,85,85,83,87,77,0,77,87,79,77,81,86,32,87,77,81,86,0,75,88,78,77,78,86,32,83,77,78,86,32,83,77,83,86,32,88,77,83,86,0,78,87,81,77,84,86,32,87,77,78,86,0,78,87,81,77,83,81,81,86,32,87,77,83,81,0,77,87,81,77,87,77,78,86,84,86,0,76,88,78,77,82,86,32,86,77,82,86,32,78,77,86,77,0,77,87,78,76,86,88,0,76,88,82,79,78,85,32,82,79,86,85,0,77,87,78,86,86,86,0,80,86,82,77,85,81,0,77,87,77,77,79,75,81,75,84,77,86,77,87,75,0,78,87,81,80,84,80,85,81,85,86,32,85,82,81,83,80,84,80,85,81,86,83,86,85,85,0,77,87,79,77,79,86,32,79,83,80,85,82,86,84,85,85,83,84,81,82,80,80,81,79,83,0,77,87,85,81,83,80,82,80,80,81,79,83,80,85,82,86,83,86,85,85,0,77,87,85,77,85,86,32,85,83,84,81,82,80,80,81,79,83,80,85,82,86,84,85,85,83,0,77,87,79,83,85,83,84,81,82,80,80,81,79,83,80,85,82,86,84,86,0,78,86,85,78,84,77,83,77,82,78,82,86,32,80,80,84,80,0,77,87,85,80,85,86,84,88,82,89,80,89,32,85,83,84,81,82,80,80,81,79,83,80,85,82,86,84,85,85,83,0,77,87,79,77,79,86,32,79,83,80,81,82,80,84,81,85,83,85,86,0,80,84,82,76,81,77,82,78,83,77,82,76,32,82,80,82,86,0,80,85,83,76,82,77,83,78,84,77,83,76,32,83,80,83,88,82,89,81,89,80,88,0,78,87,80,77,80,86,32,85,80,80,84,32,82,83,85,86,0,75,89,77,80,77,86,32,77,83,78,81,79,80,80,80,81,81,82,83,82,86,32,82,83,83,81,84,80,85,80,86,81,87,83,87,86,0,77,87,79,80,79,86,32,79,83,80,81,82,80,84,81,85,83,85,86,0,77,87,82,80,80,81,79,83,80,85,82,86,84,85,85,83,84,81,82,80,0,77,87,79,80,79,89,32,79,83,80,85,82,86,84,85,85,83,84,81,82,80,80,81,79,83,0,77,87,85,80,85,89,32,85,83,84,81,82,80,80,81,79,83,80,85,82,86,84,85,85,83,0,78,86,80,80,80,86,32,80,83,81,81,83,80,84,80,0,78,87,85,81,84,80,81,80,80,81,80,82,81,83,84,83,85,84,85,85,84,86,81,86,80,85,0,78,86,82,77,82,85,83,86,84,86,85,85,32,80,80,84,80,0,77,87,85,80,85,86,32,79,80,79,83,80,85,82,86,84,85,85,83,0,78,86,79,80,82,86,32,85,80,82,86,0,76,88,78,80,80,86,32,82,80,80,86,32,82,80,84,86,32,86,80,84,86,0,77,87,79,80,85,86,32,85,80,79,86,0,77,87,79,80,82,86,32,85,80,82,86,81,88,80,89,79,89,0,77,87,79,80,85,80,79,86,85,86,0,77,88,86,80,85,83,84,85,82,86,80,85,79,83,80,81,82,80,84,81,85,85,86,86,0,77,87,79,84,81,86,83,86,84,85,84,83,83,82,80,81,82,81,84,80,85,79,85,78,84,77,82,77,81,78,80,80,79,84,78,89,0,77,88,78,81,79,80,81,80,82,81,82,83,81,87,32,86,80,85,82,83,84,81,87,80,89,0,77,87,84,78,83,77,82,77,81,78,81,79,82,80,84,81,85,83,84,85,82,86,80,85,79,83,80,81,82,80,0,78,87,85,81,83,80,81,80,80,81,80,82,81,83,32,83,83,81,83,80,84,80,85,81,86,83,86,85,85,0,78,87,84,77,83,78,83,79,84,80,32,85,80,83,80,81,81,80,83,80,85,81,86,83,87,83,88,82,89,81,89,0,76,88,78,81,79,80,80,80,81,81,81,83,80,86,32,81,83,82,81,84,80,85,80,86,81,86,83,85,86,84,89,0,76,88,78,81,79,80,80,80,81,81,81,85,82,86,83,86,84,85,85,83,86,80,86,78,85,77,84,77,83,78,83,80,84,82,85,83,87,84,0,79,86,82,80,81,83,81,85,82,86,83,86,84,85,0,77,87,81,80,79,86,32,85,80,84,80,82,81,80,83,32,80,83,81,85,83,86,84,86,0,77,87,79,77,80,77,81,78,82,80,85,86,32,82,80,79,86,0,76,89,80,80,77,89,32,85,80,84,83,83,85,81,86,80,86,79,85,79,83,32,84,83,84,85,85,86,86,86,87,85,0,77,87,78,80,79,80,79,86,32,85,80,84,83,82,85,79,86,0,78,87,84,77,83,78,83,79,84,80,32,85,80,83,80,81,81,81,82,82,83,84,83,32,83,83,81,84,80,85,80,86,81,87,83,88,83,89,82,90,81,90,0,77,88,79,81,81,80,86,80,32,81,80,81,82,80,86,32,84,80,84,82,85,86,0,77,87,79,83,80,85,82,86,84,85,85,83,84,81,82,80,80,81,79,83,78,89,0,77,88,86,80,82,80,80,81,79,83,80,85,82,86,84,85,85,83,84,81,82,80,0,77,88,79,81,81,80,86,80,32,83,80,82,86,0,75,88,77,81,78,80,79,80,80,81,80,85,81,86,83,86,84,85,85,83,86,80,0,77,88,80,80,79,81,79,83,80,85,82,86,83,86,85,85,86,83,86,81,85,80,84,80,83,81,82,83,81,89,0,77,87,79,80,80,80,81,81,83,88,84,89,85,89,32,85,80,84,82,80,87,79,89,0,75,89,84,77,82,89,32,77,81,78,80,79,80,80,81,80,85,81,86,84,86,85,85,86,83,87,80,0,76,88,79,80,78,82,78,84,79,86,81,86,82,84,82,82,32,85,80,86,82,86,84,85,86,83,86,82,84,0,76,87,84,83,83,81,81,80,79,81,78,83,79,85,81,86,83,85,84,83,32,85,80,84,83,84,85,85,86,86,86,0,77,87,81,77,79,83,80,85,82,86,84,85,85,83,84,81,82,80,80,81,79,83,0,77,87,85,81,83,80,82,80,80,81,79,83,80,85,82,86,84,86,0,76,87,84,83,83,81,81,80,79,81,78,83,79,85,81,86,83,85,84,83,32,86,77,84,83,84,85,85,86,86,86,0,77,87,79,83,84,83,85,82,85,81,83,80,82,80,80,81,79,83,80,85,82,86,84,86,0,79,86,86,77,85,77,84,78,83,80,81,86,80,88,79,89,78,89,32,81,80,85,80,0,77,88,85,83,84,81,82,80,80,81,79,83,80,85,82,86,84,85,85,83,32,86,80,84,86,83,88,82,89,80,89,79,88,0,77,86,81,77,78,86,32,79,83,80,81,81,80,83,80,84,81,84,82,83,84,83,85,84,86,85,86,0,80,85,83,77,83,78,84,78,84,77,83,77,32,81,80,82,80,83,81,83,82,82,84,82,85,83,86,84,86,0,79,85,83,77,83,78,84,78,84,77,83,77,32,81,80,82,80,83,81,83,82,82,86,81,88,80,89,79,89,78,88,0,78,86,82,77,79,86,32,85,80,84,80,82,81,80,83,32,80,83,81,85,83,86,84,86,0,79,84,83,77,81,83,81,85,82,86,83,86,0,74,89,75,80,76,80,77,81,77,83,76,86,32,77,83,78,81,79,80,81,80,82,81,82,83,81,86,32,82,83,83,81,84,80,86,80,87,81,87,82,86,84,86,85,87,86,88,86,0,77,87,78,80,79,80,80,81,80,83,79,86,32,80,83,81,81,82,80,84,80,85,81,85,82,84,84,84,85,85,86,86,86,0,77,88,78,80,79,80,80,81,80,83,78,89,32,80,83,81,85,83,86,85,85,86,83,85,81,83,80,81,81,80,83,0,77,88,85,83,84,81,82,80,80,81,79,83,80,85,82,86,84,85,85,83,32,86,80,83,89,0,77,86,79,80,80,80,81,81,81,83,80,86,32,85,81,84,80,83,80,82,81,81,83,0,78,86,84,81,83,80,81,80,80,81,80,82,81,83,82,83,83,84,83,85,82,86,80,86,79,85,0,78,85,83,77,81,83,81,85,82,86,83,86,32,80,80,84,80,0,77,87,78,80,79,80,80,81,80,82,79,84,79,85,80,86,82,86,83,85,84,83,32,85,80,84,83,84,85,85,86,86,86,0,77,87,78,80,79,80,80,81,80,82,79,84,79,85,80,86,82,86,84,85,85,82,85,80,0,75,89,76,80,77,80,78,81,78,82,77,84,77,85,78,86,80,86,81,85,82,83,83,80,32,82,83,82,85,83,86,85,86,86,85,87,82,87,80,0,77,87,79,81,80,80,81,80,82,81,82,85,83,86,84,86,85,85,32,86,81,85,80,84,80,83,81,81,85,80,86,79,86,78,85,0,77,87,78,80,79,80,80,81,80,82,79,84,79,85,80,86,82,86,83,85,84,83,32,85,80,83,86,82,88,81,89,79,89,78,88,0,78,86,85,80,79,86,32,80,81,81,80,83,80,84,81,32,80,85,81,86,83,86,84,85,0,77,87,85,83,84,81,82,80,80,81,79,83,80,85,82,86,84,85,85,83,85,80,84,78,82,77,81,77,0,77,87,85,81,83,80,82,80,80,81,79,83,80,85,82,86,83,86,85,85,32,79,83,83,83,0,77,87,82,77,81,78,80,80,79,83,79,86,80,87,82,87,83,86,84,84,85,81,85,78,84,77,82,77,32,80,82,84,82,0,77,87,84,77,81,89,32,82,80,80,81,79,83,80,85,82,86,83,86,85,85,86,83,85,81,83,80,82,80,0,77,87,85,81,83,80,81,80,79,81,79,83,80,84,82,85,83,86,83,87,82,88,81,88,0,75,89,84,80,84,83,85,84,86,84,87,83,87,81,86,79,85,78,83,77,81,77,79,78,78,79,77,81,77,83,78,85,79,86,81,87,83,87,85,86,32,84,81,83,80,81,80,80,81,80,83,81,84,83,84,84,83,0,77,87,85,78,79,82,85,86,0,77,87,79,78,85,82,79,86,0,79,85,84,75,81,75,81,89,84,89,0,79,85,80,75,83,75,83,89,80,89,0,79,85,84,75,83,76,82,78,82,79,83,81,81,82,83,83,82,85,82,86,83,88,84,89,0,79,85,80,75,81,76,82,78,82,79,81,81,83,82,81,83,82,85,82,86,81,88,80,89,0,76,89,80,77,81,78,81,79,80,80,79,80,78,79,78,78,79,77,80,77,83,78,85,78,87,77,78,86,32,85,83,84,84,84,85,85,86,86,86,87,85,87,84,86,83,85,83,0,80,84,0,78,86,0,77,87,82,77,80,78,79,80,79,83,80,85,82,86,84,85,85,83,85,80,84,78,82,77,0,77,87,80,79,82,77,82,86,0,77,87,79,78,81,77,83,77,85,78,85,80,84,82,79,86,85,86,0,77,87,79,78,81,77,83,77,85,78,85,80,83,81,32,82,81,83,81,85,82,85,85,83,86,81,86,79,85,0,77,87,83,77,83,86,32,83,77,78,83,86,83,0,77,87,80,77,79,81,81,80,82,80,84,81,85,83,84,85,82,86,81,86,79,85,32,80,77,84,77,0,77,87,84,77,82,77,80,78,79,80,79,83,80,85,82,86,84,85,85,83,84,81,82,80,80,81,79,83,0,77,87,85,77,81,86,32,79,77,85,77,0,77,87,81,77,79,78,79,80,81,81,83,81,85,80,85,78,83,77,81,77,32,81,81,79,82,79,85,81,86,83,86,85,85,85,82,83,81,0,77,87,85,80,84,82,82,83,80,82,79,80,80,78,82,77,84,78,85,80,85,83,84,85,82,86,80,86,0,80,85,82,85,82,86,83,86,83,85,82,85,0,80,85,83,86,82,86,82,85,83,85,83,87,82,89,0,80,85,82,80,82,81,83,81,83,80,82,80,32,82,85,82,86,83,86,83,85,82,85,0,80,85,82,80,82,81,83,81,83,80,82,80,32,83,86,82,86,82,85,83,85,83,87,82,89,0,80,85,82,77,82,82,32,83,77,83,82,32,82,85,82,86,83,86,83,85,82,85,0,78,87,80,78,82,77,83,77,85,78,85,80,82,81,82,82,83,82,83,81,85,80,32,82,85,82,86,83,86,83,85,82,85,0,80,84,82,77,82,81,0,78,86,80,77,80,81,32,84,77,84,81,0,78,86,81,77,80,78,80,80,81,81,83,81,84,80,84,78,83,77,81,77,0,77,87,82,75,82,88,32,85,78,83,77,81,77,79,78,79,80,81,81,84,82,85,83,85,85,83,86,81,86,79,85,0,77,87,86,76,78,88,0,79,85,84,75,82,78,81,81,81,83,82,86,84,89,0,79,85,80,75,82,78,83,81,83,83,82,86,80,89,0,80,84,82,75,82,89,0,76,88,78,82,86,82,0,76,88,82,78,82,86,32,78,82,86,82,0,76,88,78,80,86,80,32,78,84,86,84,0,77,87,79,79,85,85,32,85,79,79,85,0,77,87,82,79,82,85,32,79,80,85,84,32,85,80,79,84,0,80,85,82,81,82,82,83,82,83,81,82,81,0,80,85,83,77,82,79,82,81,83,81,83,80,82,80,0,80,85,83,78,82,78,82,77,83,77,83,79,82,81,0,76,88,83,79,86,82,83,85,32,78,82,86,82,0,77,88,81,76,81,89,32,84,76,84,89,32,79,81,86,81,32,79,84,86,84,0,76,88,86,82,85,82,84,83,83,85,82,86,79,86,78,85,78,83,79,82,82,81,83,80,83,78,82,77,80,77,79,78,79,80,81,83,83,85,85,86,86,86,0,76,88,78,78,79,81,79,83,78,86,32,86,78,85,81,85,83,86,86,32,78,78,81,79,83,79,86,78,32,78,86,81,85,83,85,86,86,0,76,89,82,81,81,80,79,80,78,81,78,83,79,84,81,84,82,83,83,81,84,80,86,80,87,81,87,83,86,84,84,84,83,83,82,81,0,72,92,78,82,77,81,76,82,77,83,78,82,32,86,82,87,81,88,82,87,83,86,82,0,72,92,77,80,76,81,76,82,77,83,78,83,79,82,79,81,78,80,77,80,32,77,81,77,82,78,82,78,81,77,81,32,87,80,86,81,86,82,87,83,88,83,89,82,89,81,88,80,87,80,32,87,81,87,82,88,82,88,81,87,81,0,73,91,75,82,89,82,0,72,92,82,85,74,80,82,84,90,80,82,85,0,70,94,73,83,74,81,76,80,78,80,80,81,84,84,86,85,88,85,90,84,91,81,32,73,83,74,80,76,79,78,79,80,80,84,83,86,84,88,84,90,83,91,81,32,73,89,74,87,76,86,78,86,80,87,84,90,86,91,88,91,90,90,91,87,32,73,89,74,86,76,85,78,85,80,86,84,89,86,90,88,90,90,89,91,87,0,70,94,73,83,74,81,76,80,78,80,80,81,84,84,86,85,88,85,90,84,91,81,32,73,83,74,80,76,79,78,79,80,80,84,83,86,84,88,84,90,83,91,81,32,73,87,91,87,32,73,91,91,91,0,67,97,71,79,93,79,88,73,32,76,91,71,85,93,85,0,68,96,70,94,94,94,94,70,70,70,70,94,0,75,89,81,86,79,85,78,83,78,81,79,79,81,78,83,78,85,79,86,81,86,83,85,85,83,86,81,86,32,83,86,86,83,32,81,86,86,81,32,79,85,85,79,32,78,83,83,78,32,78,81,81,78,0,72,92,73,82,91,82,0,72,92,73,82,91,82,32,73,81,91,81,0,76,89,80,70,83,67,83,80,32,82,68,82,80,32,79,80,86,80,32,77,82,88,82,32,79,86,79,87,78,87,78,86,79,85,81,84,84,84,86,85,87,87,86,89,84,90,81,91,79,92,78,94,78,97,32,84,84,85,85,86,87,85,89,84,90,32,78,96,79,95,80,95,83,96,86,96,87,95,32,80,95,83,97,86,97,87,95,87,94,0,76,89,80,70,83,67,83,80,32,82,68,82,80,32,79,80,86,80,32,77,82,88,82,32,79,86,79,87,78,87,78,86,79,85,81,84,84,84,86,85,87,87,86,89,84,90,32,84,84,85,85,86,87,85,89,84,90,32,82,90,84,90,86,91,87,93,87,94,86,96,84,97,81,97,79,96,78,95,78,94,79,94,79,95,32,84,90,85,91,86,93,86,94,85,96,84,97,0,76,89,80,70,83,67,83,80,32,82,68,82,80,32,79,80,86,80,32,77,82,88,82,32,86,86,86,87,87,87,87,86,86,85,84,84,82,84,80,85,79,86,78,89,78,94,79,96,81,97,84,97,86,96,87,94,87,92,86,90,84,89,81,89,78,91,32,82,84,80,86,79,89,79,94,80,96,81,97,32,84,97,85,96,86,94,86,92,85,90,84,89,0,76,89,80,70,83,67,83,80,32,82,68,82,80,32,79,80,86,80,32,77,82,88,82,32,81,84,79,85,78,87,79,89,81,90,84,90,86,89,87,87,86,85,84,84,81,84,32,81,84,80,85,79,87,80,89,81,90,32,84,90,85,89,86,87,85,85,84,84,32,81,90,79,91,78,93,78,94,79,96,81,97,84,97,86,96,87,94,87,93,86,91,84,90,32,81,90,80,91,79,93,79,94,80,96,81,97,32,84,97,85,96,86,94,86,93,85,91,84,90,0,76,89,79,69,79,70,78,70,78,69,79,68,81,67,84,67,86,68,87,70,86,72,84,73,81,74,79,75,78,77,78,80,32,84,67,85,68,86,70,85,72,84,73,32,78,79,79,78,80,78,83,79,86,79,87,78,32,80,78,83,80,86,80,87,78,87,77,32,77,82,88,82,32,79,86,79,87,78,87,78,86,79,85,81,84,84,84,86,85,87,87,86,89,84,90,32,84,84,85,85,86,87,85,89,84,90,32,82,90,84,90,86,91,87,93,87,94,86,96,84,97,81,97,79,96,78,95,78,94,79,94,79,95,32,84,90,85,91,86,93,86,94,85,96,84,97,0,76,89,79,69,79,70,78,70,78,69,79,68,81,67,84,67,86,68,87,70,86,72,84,73,32,84,67,85,68,86,70,85,72,84,73,32,82,73,84,73,86,74,87,76,87,77,86,79,84,80,81,80,79,79,78,78,78,77,79,77,79,78,32,84,73,85,74,86,76,86,77,85,79,84,80,32,77,82,88,82,32,81,84,79,85,78,87,79,89,81,90,84,90,86,89,87,87,86,85,84,84,81,84,32,81,84,80,85,79,87,80,89,81,90,32,84,90,85,89,86,87,85,85,84,84,32,81,90,79,91,78,93,78,94,79,96,81,97,84,97,86,96,87,94,87,93,86,91,84,90,32,81,90,80,91,79,93,79,94,80,96,81,97,32,84,97,85,96,86,94,86,93,85,91,84,90,0,76,89,79,67,78,73,32,79,67,86,67,32,79,68,83,68,86,67,32,78,73,79,72,81,71,84,71,86,72,87,74,87,77,86,79,84,80,81,80,79,79,78,78,78,77,79,77,79,78,32,84,71,85,72,86,74,86,77,85,79,84,80,32,77,82,88,82,32,81,84,79,85,78,87,79,89,81,90,84,90,86,89,87,87,86,85,84,84,81,84,32,81,84,80,85,79,87,80,89,81,90,32,84,90,85,89,86,87,85,85,84,84,32,81,90,79,91,78,93,78,94,79,96,81,97,84,97,86,96,87,94,87,93,86,91,84,90,32,81,90,80,91,79,93,79,94,80,96,81,97,32,84,97,85,96,86,94,86,93,85,91,84,90,0,76,89,78,67,78,71,32,86,69,82,76,80,80,32,87,67,84,73,81,80,32,78,69,80,67,82,67,85,69,32,78,69,80,68,82,68,85,69,86,69,32,77,82,88,82,32,81,84,79,85,78,87,79,89,81,90,84,90,86,89,87,87,86,85,84,84,81,84,32,81,84,80,85,79,87,80,89,81,90,32,84,90,85,89,86,87,85,85,84,84,32,81,90,79,91,78,93,78,94,79,96,81,97,84,97,86,96,87,94,87,93,86,91,84,90,32,81,90,80,91,79,93,79,94,80,96,81,97,32,84,97,85,96,86,94,86,93,85,91,84,90,0,76,89,79,67,78,73,32,79,67,86,67,32,79,68,83,68,86,67,32,78,73,79,72,81,71,84,71,86,72,87,74,87,77,86,79,84,80,81,80,79,79,78,78,78,77,79,77,79,78,32,84,71,85,72,86,74,86,77,85,79,84,80,32,77,82,88,82,32,86,86,86,87,87,87,87,86,86,85,84,84,82,84,80,85,79,86,78,89,78,94,79,96,81,97,84,97,86,96,87,94,87,92,86,90,84,89,81,89,78,91,32,82,84,80,86,79,89,79,94,80,96,81,97,32,84,97,85,96,86,94,86,92,85,90,84,89,0,76,89,80,70,83,67,83,80,32,82,68,82,80,32,79,80,86,80,32,77,82,88,82,32,83,86,83,97,32,84,84,84,97,32,84,84,77,93,88,93,32,81,97,86,97,0,76,89,79,69,79,70,78,70,78,69,79,68,81,67,84,67,86,68,87,70,86,72,84,73,32,84,67,85,68,86,70,85,72,84,73,32,82,73,84,73,86,74,87,76,87,77,86,79,84,80,81,80,79,79,78,78,78,77,79,77,79,78,32,84,73,85,74,86,76,86,77,85,79,84,80,32,77,82,88,82,32,83,86,83,97,32,84,84,84,97,32,84,84,77,93,88,93,32,81,97,86,97,0,70,94,89,88,87,90,85,91,82,91,80,90,77,88,75,87,73,87,72,88,72,90,73,91,75,91,77,90,79,87,80,85,82,81,84,75,87,71,89,70,90,70,91,71,92,72,91,73,90,72,91,71,91,70,90,70,89,70,87,71,86,72,84,76,82,80,80,86,78,90,77,90,32,79,80,85,80,0,69,94,80,91,77,90,74,88,72,85,71,82,71,79,72,76,74,73,77,71,80,70,84,70,87,71,89,73,91,76,92,79,92,82,91,85,89,88,86,90,83,91,80,91,32,78,74,78,87,32,79,74,79,87,32,76,74,83,74,86,75,87,77,87,78,86,80,83,81,79,81,32,83,74,85,75,86,77,86,78,85,80,83,81,32,76,87,81,87,32,83,81,84,82,85,86,86,87,87,87,88,86,32,83,81,85,82,86,86,87,87,0,69,94,80,91,77,90,74,88,72,85,71,82,71,79,72,76,74,73,77,71,80,70,84,70,87,71,89,73,91,76,92,79,92,82,91,85,89,88,86,90,83,91,80,91,32,85,75,86,74,86,78,85,75,83,74,80,74,78,75,77,76,76,79,76,82,77,85,78,86,80,87,83,87,85,86,86,84,32,80,74,78,76,77,79,77,82,78,85,80,87,0,69,95,73,77,91,77,32,73,82,91,82,32,73,87,91,87,32,75,91,89,73,0,67,97,72,81,71,82,72,83,73,82,72,81,32,82,81,81,82,82,83,83,82,82,81,32,92,81,91,82,92,83,93,82,92,81,0,69,95,78,87,76,84,73,82,76,80,78,77,32,76,80,74,82,76,84,32,74,82,90,82,32,86,87,88,84,91,82,88,80,86,77,32,88,80,90,82,88,84,0,74,90,87,78,84,76,82,73,80,76,77,78,32,80,76,82,74,84,76,32,82,74,82,90,32,87,86,84,88,82,91,80,88,77,86,32,80,88,82,90,84,88,0,70,94,90,74,83,74,79,75,77,76,75,78,74,81,74,83,75,86,77,88,79,89,83,90,90,90,32,83,70,83,94,0,70,94,74,74,81,74,85,75,87,76,89,78,90,81,90,83,89,86,87,88,85,89,81,90,74,90,32,81,70,81,94,0,70,94,74,74,81,74,85,75,87,76,89,78,90,81,90,83,89,86,87,88,85,89,81,90,74,90,32,79,82,90,82,0,72,92,76,66,76,91,32,82,66,82,91,32,88,66,88,91,0,73,91,82,70,74,91,32,82,70,90,91,32,77,84,87,84,0,71,92,75,70,75,91,32,75,70,84,70,87,71,88,72,89,74,89,76,88,78,87,79,84,80,32,75,80,84,80,87,81,88,82,89,84,89,87,88,89,87,90,84,91,75,91,0,72,93,90,75,89,73,87,71,85,70,81,70,79,71,77,73,76,75,75,78,75,83,76,86,77,88,79,90,81,91,85,91,87,90,89,88,90,86,0,71,92,75,70,75,91,32,75,70,82,70,85,71,87,73,88,75,89,78,89,83,88,86,87,88,85,90,82,91,75,91,0,72,91,76,70,76,91,32,76,70,89,70,32,76,80,84,80,32,76,91,89,91,0,72,90,76,70,76,91,32,76,70,89,70,32,76,80,84,80,0,72,93,90,75,89,73,87,71,85,70,81,70,79,71,77,73,76,75,75,78,75,83,76,86,77,88,79,90,81,91,85,91,87,90,89,88,90,86,90,83,32,85,83,90,83,0,71,93,75,70,75,91,32,89,70,89,91,32,75,80,89,80,0,78,86,82,70,82,91,0,74,90,86,70,86,86,85,89,84,90,82,91,80,91,78,90,77,89,76,86,76,84,0,71,92,75,70,75,91,32,89,70,75,84,32,80,79,89,91,0,72,89,76,70,76,91,32,76,91,88,91,0,70,94,74,70,74,91,32,74,70,82,91,32,90,70,82,91,32,90,70,90,91,0,71,93,75,70,75,91,32,75,70,89,91,32,89,70,89,91,0,71,93,80,70,78,71,76,73,75,75,74,78,74,83,75,86,76,88,78,90,80,91,84,91,86,90,88,88,89,86,90,83,90,78,89,75,88,73,86,71,84,70,80,70,0,71,92,75,70,75,91,32,75,70,84,70,87,71,88,72,89,74,89,77,88,79,87,80,84,81,75,81,0,71,93,80,70,78,71,76,73,75,75,74,78,74,83,75,86,76,88,78,90,80,91,84,91,86,90,88,88,89,86,90,83,90,78,89,75,88,73,86,71,84,70,80,70,32,83,87,89,93,0,71,92,75,70,75,91,32,75,70,84,70,87,71,88,72,89,74,89,76,88,78,87,79,84,80,75,80,32,82,80,89,91,0,72,92,89,73,87,71,84,70,80,70,77,71,75,73,75,75,76,77,77,78,79,79,85,81,87,82,88,83,89,85,89,88,87,90,84,91,80,91,77,90,75,88,0,74,90,82,70,82,91,32,75,70,89,70,0,71,93,75,70,75,85,76,88,78,90,81,91,83,91,86,90,88,88,89,85,89,70,0,73,91,74,70,82,91,32,90,70,82,91,0,70,94,72,70,77,91,32,82,70,77,91,32,82,70,87,91,32,92,70,87,91,0,72,92,75,70,89,91,32,89,70,75,91,0,73,91,74,70,82,80,82,91,32,90,70,82,80,0,72,92,89,70,75,91,32,75,70,89,70,32,75,91,89,91,0,72,89,76,70,76,91,32,76,70,88,70,0,73,91,82,70,74,91,32,82,70,90,91,32,74,91,90,91,0,71,93,80,70,78,71,76,73,75,75,74,78,74,83,75,86,76,88,78,90,80,91,84,91,86,90,88,88,89,86,90,83,90,78,89,75,88,73,86,71,84,70,80,70,32,79,80,85,80,0,73,91,82,70,74,91,32,82,70,90,91,0,73,91,75,70,89,70,32,79,80,85,80,32,75,91,89,91,0,71,93,75,70,75,91,32,89,70,89,91,32,75,70,89,70,0,73,91,75,70,82,80,75,91,32,75,70,89,70,32,75,91,89,91,0,73,91,75,75,75,73,76,71,77,70,79,70,80,71,81,73,82,77,82,91,32,89,75,89,73,88,71,87,70,85,70,84,71,83,73,82,77,0,72,92,82,70,82,91,32,80,75,77,76,76,77,75,79,75,82,76,84,77,85,80,86,84,86,87,85,88,84,89,82,89,79,88,77,87,76,84,75,80,75,0,72,92,75,70,89,91,32,75,91,89,70,0,71,93,82,70,82,91,32,73,76,74,76,75,77,76,81,77,83,78,84,81,85,83,85,86,84,87,83,88,81,89,77,90,76,91,76,0,72,92,75,91,79,91,76,84,75,80,75,76,76,73,78,71,81,70,83,70,86,71,88,73,89,76,89,80,88,84,85,91,89,91,0,71,91,71,91,73,90,76,87,79,83,83,76,86,70,86,91,85,88,83,85,81,83,78,81,76,81,75,82,75,84,76,86,78,88,81,90,84,91,89,91,0,70,93,83,72,84,73,84,76,83,80,82,83,81,85,79,88,77,90,75,91,74,91,73,90,73,87,74,82,75,79,76,77,78,74,80,72,82,71,85,70,88,70,90,71,91,73,91,75,90,77,89,78,87,79,84,80,32,83,80,84,80,87,81,88,82,89,84,89,87,88,89,87,90,85,91,82,91,80,90,79,88,0,72,92,84,76,84,77,85,78,87,78,89,77,90,75,90,73,89,71,87,70,84,70,81,71,79,73,77,76,76,78,75,82,75,86,76,89,77,90,79,91,81,91,84,90,86,88,87,86,0,71,94,84,70,82,71,81,73,80,77,79,83,78,86,77,88,75,90,73,91,71,91,70,90,70,88,71,87,73,87,75,88,77,90,80,91,83,91,86,90,88,88,90,84,91,79,91,75,90,72,89,71,87,70,84,70,82,72,82,74,83,77,85,80,87,82,90,84,92,85,0,72,92,86,74,86,75,87,76,89,76,90,75,90,73,89,71,86,70,82,70,79,71,78,73,78,76,79,78,80,79,83,80,80,80,77,81,76,82,75,84,75,87,76,89,77,90,80,91,83,91,86,90,88,88,89,86,0,72,92,82,76,80,76,78,75,77,73,78,71,81,70,84,70,88,71,91,71,93,70,32,88,71,86,78,84,84,82,88,80,90,78,91,76,91,74,90,73,88,73,86,74,85,76,85,78,86,32,81,80,90,80,0,71,94,71,91,73,90,77,86,80,81,81,78,82,74,82,71,81,70,80,70,79,71,78,73,78,76,79,78,81,79,85,79,88,78,89,77,90,75,90,81,89,86,88,88,86,90,83,91,79,91,76,90,74,88,73,86,73,84,0,70,94,77,77,75,76,74,74,74,73,75,71,77,70,78,70,80,71,81,73,81,75,80,79,78,85,76,89,74,91,72,91,71,90,71,88,32,77,82,86,79,88,78,91,76,93,74,94,72,94,71,93,70,92,70,90,72,88,76,86,82,85,87,85,90,86,91,87,91,89,90,90,89,92,86,0,73,90,87,86,85,84,83,81,82,79,81,76,81,73,82,71,83,70,85,70,86,71,87,73,87,76,86,81,84,86,83,88,81,90,79,91,77,91,75,90,74,88,74,86,75,85,77,85,79,86,0,74,89,84,94,82,91,80,86,79,80,79,74,80,71,82,70,84,70,85,71,86,74,86,77,85,82,82,91,80,97,79,100,78,102,76,103,75,102,75,100,76,97,78,94,80,92,83,90,87,88,0,70,94,77,77,75,76,74,74,74,73,75,71,77,70,78,70,80,71,81,73,81,75,80,79,78,85,76,89,74,91,72,91,71,90,71,88,32,94,73,94,71,93,70,92,70,90,71,88,73,86,76,84,78,82,79,80,79,32,82,79,83,81,83,88,84,90,85,91,86,91,88,90,89,89,91,86,0,73,92,77,82,79,82,83,81,86,79,88,77,89,75,89,72,88,70,86,70,85,71,84,73,83,78,82,83,81,86,80,88,78,90,76,91,74,91,73,90,73,88,74,87,76,87,78,88,81,90,84,91,86,91,89,90,91,88,0,64,97,69,77,67,76,66,74,66,73,67,71,69,70,70,70,72,71,73,73,73,75,72,80,71,84,69,91,32,71,84,74,76,76,72,77,71,79,70,80,70,82,71,83,73,83,75,82,80,81,84,79,91,32,81,84,84,76,86,72,87,71,89,70,90,70,92,71,93,73,93,75,92,80,90,87,90,90,91,91,92,91,94,90,95,89,97,86,0,69,93,74,77,72,76,71,74,71,73,72,71,74,70,75,70,77,71,78,73,78,75,77,80,76,84,74,91,32,76,84,79,76,81,72,82,71,84,70,86,70,88,71,89,73,89,75,88,80,86,87,86,90,87,91,88,91,90,90,91,89,93,86,0,72,93,84,70,81,71,79,73,77,76,76,78,75,82,75,86,76,89,77,90,79,91,81,91,84,90,86,88,88,85,89,83,90,79,90,75,89,72,88,71,86,70,84,70,82,72,82,75,83,78,85,81,87,83,90,85,92,86,0,70,95,83,72,84,73,84,76,83,80,82,83,81,85,79,88,77,90,75,91,74,91,73,90,73,87,74,82,75,79,76,77,78,74,80,72,82,71,85,70,90,70,92,71,93,72,94,74,94,77,93,79,92,80,90,81,87,81,85,80,84,79,0,72,94,85,76,84,78,83,79,81,80,79,80,78,78,78,76,79,73,81,71,84,70,87,70,89,71,90,73,90,77,89,80,87,83,83,87,80,89,78,90,75,91,73,91,72,90,72,88,73,87,75,87,77,88,80,90,83,91,86,91,89,90,91,88,0,70,95,83,72,84,73,84,76,83,80,82,83,81,85,79,88,77,90,75,91,74,91,73,90,73,87,74,82,75,79,76,77,78,74,80,72,82,71,85,70,89,70,91,71,92,72,93,74,93,77,92,79,91,80,89,81,86,81,83,80,84,81,85,83,85,88,86,90,88,91,90,90,91,89,93,86,0,72,92,72,91,74,90,76,88,79,84,81,81,83,77,84,74,84,71,83,70,82,70,81,71,80,73,80,75,81,77,83,79,86,81,88,83,89,85,89,87,88,89,87,90,84,91,80,91,77,90,75,88,74,86,74,84,0,72,91,82,76,80,76,78,75,77,73,78,71,81,70,84,70,88,71,91,71,93,70,32,88,71,86,78,84,84,82,88,80,90,78,91,76,91,74,90,73,88,73,86,74,85,76,85,78,86,0,69,93,74,77,72,76,71,74,71,73,72,71,74,70,75,70,77,71,78,73,78,75,77,79,76,82,75,86,75,88,76,90,78,91,80,91,82,90,83,89,85,85,88,77,90,70,32,88,77,87,81,86,87,86,90,87,91,88,91,90,90,91,89,93,86,0,70,93,75,77,73,76,72,74,72,73,73,71,75,70,76,70,78,71,79,73,79,75,78,79,77,82,76,86,76,89,77,91,79,91,81,90,84,87,86,84,88,80,89,77,90,73,90,71,89,70,88,70,87,71,86,73,86,75,87,78,89,80,91,81,0,67,95,72,77,70,76,69,74,69,73,70,71,72,70,73,70,75,71,76,73,76,76,75,91,32,85,70,75,91,32,85,70,83,91,32,97,70,95,71,92,74,89,78,86,84,83,91,0,70,94,78,76,76,76,75,75,75,73,76,71,78,70,80,70,82,71,83,73,83,76,81,85,81,88,82,90,84,91,86,91,88,90,89,88,89,86,88,85,86,85,32,93,73,93,71,92,70,90,70,88,71,86,73,84,76,80,85,78,88,76,90,74,91,72,91,71,90,71,88,0,70,93,75,77,73,76,72,74,72,73,73,71,75,70,76,70,78,71,79,73,79,75,78,79,77,82,76,86,76,88,77,90,78,91,80,91,82,90,84,88,86,85,87,83,89,77,32,91,70,89,77,86,87,84,93,82,98,80,102,78,103,77,102,77,100,78,97,80,94,83,91,86,89,91,86,0,72,93,85,76,84,78,83,79,81,80,79,80,78,78,78,76,79,73,81,71,84,70,87,70,89,71,90,73,90,77,89,80,87,84,84,87,80,90,78,91,75,91,74,90,74,88,75,87,78,87,80,88,81,89,82,91,82,94,81,97,80,99,78,102,76,103,75,102,75,100,76,97,78,94,81,91,84,89,90,86,0,73,91,74,70,82,91,32,90,70,82,91,32,74,70,90,70,0,71,93,73,76,91,98,0,69,95,82,74,73,90,32,82,74,91,90,0,73,91,74,91,90,91,0,73,91,74,91,90,91,90,90,74,90,74,91,0,73,92,88,77,88,91,32,88,80,86,78,84,77,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,84,91,86,90,88,88,0,72,91,76,70,76,91,32,76,80,78,78,80,77,83,77,85,78,87,80,88,83,88,85,87,88,85,90,83,91,80,91,78,90,76,88,0,73,91,88,80,86,78,84,77,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,84,91,86,90,88,88,0,73,92,88,70,88,91,32,88,80,86,78,84,77,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,84,91,86,90,88,88,0,73,91,76,83,88,83,88,81,87,79,86,78,84,77,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,84,91,86,90,88,88,0,77,89,87,70,85,70,83,71,82,74,82,91,32,79,77,86,77,0,73,92,88,77,88,93,87,96,86,97,84,98,81,98,79,97,32,88,80,86,78,84,77,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,84,91,86,90,88,88,0,73,92,77,70,77,91,32,77,81,80,78,82,77,85,77,87,78,88,81,88,91,0,78,86,81,70,82,71,83,70,82,69,81,70,32,82,77,82,91,0,77,87,82,70,83,71,84,70,83,69,82,70,32,83,77,83,94,82,97,80,98,78,98,0,73,90,77,70,77,91,32,87,77,77,87,32,81,83,88,91,0,67,97,71,77,71,91,32,71,81,74,78,76,77,79,77,81,78,82,81,82,91,32,82,81,85,78,87,77,90,77,92,78,93,81,93,91,0,73,92,77,77,77,91,32,77,81,80,78,82,77,85,77,87,78,88,81,88,91,0,73,92,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,84,91,86,90,88,88,89,85,89,83,88,80,86,78,84,77,81,77,0,72,91,76,77,76,98,32,76,80,78,78,80,77,83,77,85,78,87,80,88,83,88,85,87,88,85,90,83,91,80,91,78,90,76,88,0,73,92,88,77,88,98,32,88,80,86,78,84,77,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,84,91,86,90,88,88,0,75,88,79,77,79,91,32,79,83,80,80,82,78,84,77,87,77,0,74,91,88,80,87,78,84,77,81,77,78,78,77,80,78,82,80,83,85,84,87,85,88,87,88,88,87,90,84,91,81,91,78,90,77,88,0,77,89,82,70,82,87,83,90,85,91,87,91,32,79,77,86,77,0,73,92,77,77,77,87,78,90,80,91,83],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+266241);allocate([91,85,90,88,87,32,88,77,88,91,0,74,90,76,77,82,91,32,88,77,82,91,0,71,93,74,77,78,91,32,82,77,78,91,32,82,77,86,91,32,90,77,86,91,0,74,91,77,77,88,91,32,88,77,77,91,0,74,90,76,77,82,91,32,88,77,82,91,80,95,78,97,76,98,75,98,0,74,91,88,77,77,91,32,77,77,88,77,32,77,91,88,91,0,72,93,81,77,79,78,77,80,76,82,75,85,75,88,76,90,78,91,80,91,82,90,85,87,87,84,89,80,90,77,32,81,77,83,77,84,78,85,80,87,88,88,90,89,91,90,91,0,73,92,85,70,83,71,81,73,79,77,78,80,77,84,76,90,75,98,32,85,70,87,70,89,72,89,75,88,77,87,78,85,79,82,79,32,82,79,84,80,86,82,87,84,87,87,86,89,85,90,83,91,81,91,79,90,78,89,77,86,0,73,92,74,80,76,78,78,77,79,77,81,78,82,79,83,82,83,86,82,91,32,90,77,89,80,88,82,82,91,80,95,79,98,0,73,91,84,77,81,77,79,78,77,80,76,83,76,86,77,89,78,90,80,91,82,91,84,90,86,88,87,85,87,82,86,79,84,77,82,75,81,73,81,71,82,70,84,70,86,71,88,73,0,74,90,87,79,86,78,84,77,81,77,79,78,79,80,80,82,83,83,32,83,83,79,84,77,86,77,88,78,90,80,91,83,91,85,90,87,88,0,74,89,84,70,82,71,81,72,81,73,82,74,85,75,88,75,32,88,75,84,77,81,79,78,82,77,85,77,87,78,89,80,91,83,93,84,95,84,97,83,98,81,98,80,96,0,72,92,73,81,74,79,76,77,78,77,79,78,79,80,78,84,76,91,32,78,84,80,80,82,78,84,77,86,77,88,79,88,82,87,87,84,98,0,71,92,72,81,73,79,75,77,77,77,78,78,78,80,77,85,77,88,78,90,79,91,81,91,83,90,85,87,86,85,87,82,88,77,88,74,87,71,85,70,83,70,82,72,82,74,83,77,85,80,87,82,90,84,0,76,87,82,77,80,84,79,88,79,90,80,91,82,91,84,89,85,87,0,73,91,79,77,75,91,32,89,78,88,77,87,77,85,78,81,82,79,83,78,83,32,78,83,80,84,81,85,83,90,84,91,85,91,86,90,0,74,90,75,70,77,70,79,71,80,72,88,91,32,82,77,76,91,0,72,93,79,77,73,98,32,78,81,77,86,77,89,79,91,81,91,83,90,85,88,87,84,32,89,77,87,84,86,88,86,90,87,91,89,91,91,89,92,87,0,73,91,76,77,79,77,78,83,77,88,76,91,32,89,77,88,80,87,82,85,85,82,88,79,90,76,91,0,74,90,84,70,82,71,81,72,81,73,82,74,85,75,88,75,32,85,75,82,76,80,77,79,79,79,81,81,83,84,84,86,84,32,84,84,80,85,78,86,77,88,77,90,79,92,83,94,84,95,84,97,82,98,80,98,0,74,91,82,77,80,78,78,80,77,83,77,86,78,89,79,90,81,91,83,91,85,90,87,88,88,85,88,82,87,79,86,78,84,77,82,77,0,71,93,80,77,76,91,32,85,77,86,83,87,88,88,91,32,73,80,75,78,78,77,91,77,0,73,91,77,83,77,86,78,89,79,90,81,91,83,91,85,90,87,88,88,85,88,82,87,79,86,78,84,77,82,77,80,78,78,80,77,83,73,98,0,73,93,91,77,81,77,79,78,77,80,76,83,76,86,77,89,78,90,80,91,82,91,84,90,86,88,87,85,87,82,86,79,85,78,83,77,0,72,92,83,77,80,91,32,74,80,76,78,79,77,90,77,0,72,92,73,81,74,79,76,77,78,77,79,78,79,80,77,86,77,89,79,91,81,91,84,90,86,88,88,84,89,80,89,77,0,71,93,79,78,77,79,75,81,74,84,74,87,75,89,76,90,78,91,81,91,84,90,87,88,89,85,90,82,90,79,88,77,86,77,84,79,82,83,80,88,77,98,0,73,91,75,77,77,77,79,79,85,96,87,98,89,98,32,90,77,89,79,87,82,77,93,75,96,74,98,0,70,93,86,70,78,98,32,71,81,72,79,74,77,76,77,77,78,77,80,76,85,76,88,77,90,79,91,81,91,84,90,86,88,88,85,90,80,91,77,0,70,93,78,77,76,78,74,81,73,84,73,87,74,90,75,91,77,91,79,90,81,87,32,82,83,81,87,82,90,83,91,85,91,87,90,89,87,90,84,90,81,89,78,88,77,0,76,92,85,85,84,83,82,82,80,82,78,83,77,84,76,86,76,88,77,90,79,91,81,91,83,90,84,88,86,82,85,87,85,90,86,91,87,91,89,90,90,89,92,86,0,77,91,77,86,79,83,82,78,83,76,84,73,84,71,83,70,81,71,80,73,79,77,78,84,78,90,79,91,80,91,82,90,84,88,85,85,85,82,86,86,87,87,89,87,91,86,0,77,88,84,84,84,83,83,82,81,82,79,83,78,84,77,86,77,88,78,90,80,91,83,91,86,89,88,86,0,76,92,85,85,84,83,82,82,80,82,78,83,77,84,76,86,76,88,77,90,79,91,81,91,83,90,84,88,90,70,32,86,82,85,87,85,90,86,91,87,91,89,90,90,89,92,86,0,78,88,79,89,81,88,82,87,83,85,83,83,82,82,81,82,79,83,78,85,78,88,79,90,81,91,83,91,85,90,86,89,88,86,0,79,87,79,86,83,81,85,78,86,76,87,73,87,71,86,70,84,71,83,73,81,81,78,90,75,97,74,100,74,102,75,103,77,102,78,99,79,90,80,91,82,91,84,90,85,89,87,86,0,76,91,85,85,84,83,82,82,80,82,78,83,77,84,76,86,76,88,77,90,79,91,81,91,83,90,84,89,32,86,82,84,89,80,100,79,102,77,103,76,102,76,100,77,97,80,94,83,92,85,91,88,89,91,86,0,77,92,77,86,79,83,82,78,83,76,84,73,84,71,83,70,81,71,80,73,79,77,78,83,77,91,32,77,91,78,88,79,86,81,83,83,82,85,82,86,83,86,85,85,88,85,90,86,91,87,91,89,90,90,89,92,86,0,80,87,83,77,83,78,84,78,84,77,83,77,32,80,86,82,82,80,88,80,90,81,91,82,91,84,90,85,89,87,86,0,80,87,83,77,83,78,84,78,84,77,83,77,32,80,86,82,82,76,100,75,102,73,103,72,102,72,100,73,97,76,94,79,92,81,91,84,89,87,86,0,77,91,77,86,79,83,82,78,83,76,84,73,84,71,83,70,81,71,80,73,79,77,78,83,77,91,32,77,91,78,88,79,86,81,83,83,82,85,82,86,83,86,85,84,86,81,86,32,81,86,83,87,84,90,85,91,86,91,88,90,89,89,91,86,0,79,87,79,86,81,83,84,78,85,76,86,73,86,71,85,70,83,71,82,73,81,77,80,84,80,90,81,91,82,91,84,90,85,89,87,86,0,69,94,69,86,71,83,73,82,74,83,74,84,73,88,72,91,32,73,88,74,86,76,83,78,82,80,82,81,83,81,84,80,88,79,91,32,80,88,81,86,83,83,85,82,87,82,88,83,88,85,87,88,87,90,88,91,89,91,91,90,92,89,94,86,0,74,92,74,86,76,83,78,82,79,83,79,84,78,88,77,91,32,78,88,79,86,81,83,83,82,85,82,86,83,86,85,85,88,85,90,86,91,87,91,89,90,90,89,92,86,0,76,90,82,82,80,82,78,83,77,84,76,86,76,88,77,90,79,91,81,91,83,90,84,89,85,87,85,85,84,83,82,82,81,83,81,85,82,87,84,88,87,88,89,87,90,86,0,75,90,75,86,77,83,78,81,77,85,71,103,32,77,85,78,83,80,82,82,82,84,83,85,85,85,87,84,89,83,90,81,91,32,77,90,79,91,82,91,85,90,87,89,90,86,0,76,91,85,85,84,83,82,82,80,82,78,83,77,84,76,86,76,88,77,90,79,91,81,91,83,90,32,86,82,85,85,83,90,80,97,79,100,79,102,80,103,82,102,83,99,83,92,85,91,88,89,91,86,0,77,90,77,86,79,83,80,81,80,83,83,83,84,84,84,86,83,89,83,90,84,91,85,91,87,90,88,89,90,86,0,78,89,78,86,80,83,81,81,81,83,83,86,84,88,84,90,82,91,32,78,90,80,91,84,91,86,90,87,89,89,86,0,79,88,79,86,81,83,83,79,32,86,70,80,88,80,90,81,91,83,91,85,90,86,89,88,86,32,80,78,87,78,0,76,91,76,86,78,82,76,88,76,90,77,91,79,91,81,90,83,88,85,85,32,86,82,84,88,84,90,85,91,86,91,88,90,89,89,91,86,0,76,91,76,86,78,82,77,87,77,90,78,91,79,91,82,90,84,88,85,85,85,82,32,85,82,86,86,87,87,89,87,91,86,0,73,94,76,82,74,84,73,87,73,89,74,91,76,91,78,90,80,88,32,82,82,80,88,80,90,81,91,83,91,85,90,87,88,88,85,88,82,32,88,82,89,86,90,87,92,87,94,86,0,74,90,74,86,76,83,78,82,80,82,81,83,81,90,82,91,85,91,88,89,90,86,32,87,83,86,82,84,82,83,83,79,90,78,91,76,91,75,90,0,76,91,76,86,78,82,76,88,76,90,77,91,79,91,81,90,83,88,85,85,32,86,82,80,100,79,102,77,103,76,102,76,100,77,97,80,94,83,92,85,91,88,89,91,86,0,76,90,76,86,78,83,80,82,82,82,84,84,84,86,83,88,81,90,78,91,80,92,81,94,81,97,80,100,79,102,77,103,76,102,76,100,77,97,80,94,83,92,87,89,90,86,0,74,92,75,91,78,90,81,88,83,86,85,83,87,79,88,75,88,73,87,71,85,70,83,71,82,72,81,74,80,79,80,84,81,88,82,90,84,91,86,91,88,90,89,89,0,73,91,87,85,87,82,86,79,85,78,83,77,81,77,79,78,77,80,76,83,76,86,77,89,78,90,80,91,82,91,84,90,86,88,87,85,88,80,88,75,87,72,86,71,84,70,82,70,80,71,78,73,0,74,90,87,78,85,77,82,77,80,78,78,80,77,83,77,86,78,89,79,90,81,91,84,91,86,90,32,77,84,85,84,0,74,91,84,70,82,71,80,74,79,76,78,79,77,84,77,88,78,90,79,91,81,91,83,90,85,87,86,85,87,82,88,77,88,73,87,71,86,70,84,70,32,78,80,87,80,0,72,92,86,70,78,98,32,81,77,78,78,76,80,75,83,75,86,76,88,78,90,81,91,83,91,86,90,88,88,89,85,89,82,88,80,86,78,83,77,81,77,0,73,91,88,79,87,78,84,77,81,77,78,78,77,79,76,81,76,83,77,85,79,87,83,90,84,92,84,94,83,95,81,95,0,68,97,87,78,86,76,84,75,81,75,79,76,78,77,77,79,77,82,78,84,79,85,81,86,84,86,86,85,87,83,32,87,75,87,83,88,85,89,86,91,86,92,85,93,83,93,79,92,76,91,74,89,72,87,71,84,70,81,70,78,71,76,72,74,74,73,76,72,79,72,82,73,85,74,87,76,89,78,90,81,91,84,91,87,90,89,89,0,70,94,90,73,74,82,90,91,0,70,94,74,73,90,82,74,91,0,75,89,79,66,79,98,32,79,66,86,66,32,79,98,86,98,0,75,89,85,66,85,98,32,78,66,85,66,32,78,98,85,98,0,75,89,84,66,81,69,80,72,80,74,81,77,83,79,83,80,79,82,83,84,83,85,81,87,80,90,80,92,81,95,84,98,0,75,89,80,66,83,69,84,72,84,74,83,77,81,79,81,80,85,82,81,84,81,85,83,87,84,90,84,92,83,95,80,98,0,70,94,91,70,89,71,86,72,83,72,80,71,78,70,76,70,74,71,73,73,73,75,75,77,77,77,79,76,80,74,80,72,78,70,32,91,70,73,91,32,89,84,87,84,85,85,84,87,84,89,86,91,88,91,90,90,91,88,91,86,89,84,0,74,90,0,72,92,81,70,78,71,76,74,75,79,75,82,76,87,78,90,81,91,83,91,86,90,88,87,89,82,89,79,88,74,86,71,83,70,81,70,0,72,92,78,74,80,73,83,70,83,91,0,72,92,76,75,76,74,77,72,78,71,80,70,84,70,86,71,87,72,88,74,88,76,87,78,85,81,75,91,89,91,0,72,92,77,70,88,70,82,78,85,78,87,79,88,80,89,83,89,85,88,88,86,90,83,91,80,91,77,90,76,89,75,87,0,72,92,85,70,75,84,90,84,32,85,70,85,91,0,72,92,87,70,77,70,76,79,77,78,80,77,83,77,86,78,88,80,89,83,89,85,88,88,86,90,83,91,80,91,77,90,76,89,75,87,0,72,92,88,73,87,71,84,70,82,70,79,71,77,74,76,79,76,84,77,88,79,90,82,91,83,91,86,90,88,88,89,85,89,84,88,81,86,79,83,78,82,78,79,79,77,81,76,84,0,72,92,89,70,79,91,32,75,70,89,70,0,72,92,80,70,77,71,76,73,76,75,77,77,79,78,83,79,86,80,88,82,89,84,89,87,88,89,87,90,84,91,80,91,77,90,76,89,75,87,75,84,76,82,78,80,81,79,85,78,87,77,88,75,88,73,87,71,84,70,80,70,0,72,92,88,77,87,80,85,82,82,83,81,83,78,82,76,80,75,77,75,76,76,73,78,71,81,70,82,70,85,71,87,73,88,77,88,82,87,87,85,90,82,91,80,91,77,90,76,88,0,77,87,82,89,81,90,82,91,83,90,82,89,0,77,87,83,90,82,91,81,90,82,89,83,90,83,92,82,94,81,95,0,77,87,82,77,81,78,82,79,83,78,82,77,32,82,89,81,90,82,91,83,90,82,89,0,77,87,82,77,81,78,82,79,83,78,82,77,32,83,90,82,91,81,90,82,89,83,90,83,92,82,94,81,95,0,77,87,82,70,82,84,32,82,89,81,90,82,91,83,90,82,89,0,73,91,76,75,76,74,77,72,78,71,80,70,84,70,86,71,87,72,88,74,88,76,87,78,86,79,82,81,82,84,32,82,89,81,90,82,91,83,90,82,89,0,78,86,82,70,82,77,0,74,90,78,70,78,77,32,86,70,86,77,0,75,89,81,70,79,71,78,73,78,75,79,77,81,78,83,78,85,77,86,75,86,73,85,71,83,70,81,70,0,72,92,80,66,80,95,32,84,66,84,95,32,89,73,87,71,84,70,80,70,77,71,75,73,75,75,76,77,77,78,79,79,85,81,87,82,88,83,89,85,89,88,87,90,84,91,80,91,77,90,75,88,0,71,93,91,66,73,98,0,75,89,86,66,84,68,82,71,80,75,79,80,79,84,80,89,82,93,84,96,86,98,0,75,89,78,66,80,68,82,71,84,75,85,80,85,84,84,89,82,93,80,96,78,98,0,78,86,82,66,82,98,0,69,95,73,82,91,82,0,69,95,82,73,82,91,32,73,82,91,82,0,69,95,73,79,91,79,32,73,85,91,85,0,71,93,75,75,89,89,32,89,75,75,89,0,74,90,82,76,82,88,32,77,79,87,85,32,87,79,77,85,0,77,87,82,81,81,82,82,83,83,82,82,81,0,77,87,83,70,82,71,81,73,81,75,82,76,83,75,82,74,0,77,87,82,72,81,71,82,70,83,71,83,73,82,75,81,76,0,69,95,85,77,88,80,91,82,88,84,85,87,32,73,82,91,82,0,71,93,79,70,79,98,32,85,70,85,98,32,74,81,90,81,32,74,87,90,87,0,69,95,92,79,92,78,91,77,90,77,89,78,88,80,86,85,84,88,82,90,80,91,76,91,74,90,73,89,72,87,72,85,73,83,74,82,81,78,82,77,83,75,83,73,82,71,80,70,78,71,77,73,77,75,78,78,80,81,85,88,87,90,89,91,91,91,92,90,92,89,0,71,93,73,73,74,75,75,79,75,85,74,89,73,91,32,91,73,90,75,89,79,89,85,90,89,91,91,32,73,73,75,74,79,75,85,75,89,74,91,73,32,73,91,75,90,79,89,85,89,89,90,91,91,0,70,95,92,81,91,79,89,78,87,78,85,79,84,80,81,84,80,85,78,86,76,86,74,85,73,83,73,81,74,79,76,78,78,78,80,79,81,80,84,84,85,85,87,86,89,86,91,85,92,83,92,81,0,75,89,79,66,79,91,32,85,66,85,91,0,70,94,82,66,82,91,32,73,91,91,91,0,70,94,91,66,73,91,91,91,0,69,95,82,73,81,74,82,75,83,74,82,73,32,73,89,72,90,73,91,74,90,73,89,32,91,89,90,90,91,91,92,90,91,89,0,70,94,82,72,78,76,75,80,74,83,74,85,75,87,77,88,79,88,81,87,82,85,32,82,72,86,76,89,80,90,83,90,85,89,87,87,88,85,88,83,87,82,85,32,82,85,81,89,80,92,32,82,85,83,89,84,92,32,80,92,84,92,0,70,94,82,78,81,75,80,73,78,72,77,72,75,73,74,75,74,79,75,82,76,84,78,87,82,92,32,82,78,83,75,84,73,86,72,87,72,89,73,90,75,90,79,89,82,88,84,86,87,82,92,0,70,94,82,71,80,74,76,79,73,82,32,82,71,84,74,88,79,91,82,32,73,82,76,85,80,90,82,93,32,91,82,88,85,84,90,82,93,0,70,94,82,84,84,87,86,88,88,88,90,87,91,85,91,83,90,81,88,80,86,80,83,81,32,83,81,85,79,86,77,86,75,85,73,83,72,81,72,79,73,78,75,78,77,79,79,81,81,32,81,81,78,80,76,80,74,81,73,83,73,85,74,87,76,88,78,88,80,87,82,84,32,82,84,81,89,80,92,32,82,84,83,89,84,92,32,80,92,84,92,0,70,94,82,82,82,91,81,92,32,82,86,81,92,32,82,73,81,72,79,72,78,73,78,75,79,78,82,82,32,82,73,83,72,85,72,86,73,86,75,85,78,82,82,32,82,82,78,79,76,78,74,78,73,79,73,81,74,82,32,82,82,86,79,88,78,90,78,91,79,91,81,90,82,32,82,82,78,85,76,86,74,86,73,85,73,83,74,82,32,82,82,86,85,88,86,90,86,91,85,91,83,90,82,0,70,94,73,83,74,83,76,84,77,86,77,88,76,90,32,73,83,73,82,74,81,76,81,77,82,78,84,78,87,77,89,76,90,32,82,71,80,73,79,76,79,79,81,85,81,88,80,90,82,92,32,82,71,84,73,85,76,85,79,83,85,83,88,84,90,82,92,32,91,83,91,82,90,81,88,81,87,82,86,84,86,87,87,89,88,90,32,91,83,90,83,88,84,87,86,87,88,88,90,32,75,86,89,86,0,80,83,83,82,82,83,81,83,80,82,80,81,81,80,82,80,83,81,83,83,82,85,81,86,32,81,81,81,82,82,82,82,81,81,81,0,80,84,81,80,80,81,80,83,81,84,83,84,84,83,84,81,83,80,81,80,32,82,81,81,82,82,83,83,82,82,81,0,78,86,80,79,84,85,32,84,79,80,85,32,78,82,86,82,0,77,87,82,75,81,77,79,80,77,82,32,82,75,83,77,85,80,87,82,32,82,77,79,81,32,82,77,85,81,32,82,79,80,81,32,82,79,84,81,32,81,81,83,81,32,77,82,87,82,0,77,87,77,82,77,81,78,79,79,78,81,77,83,77,85,78,86,79,87,81,87,82,32,80,78,84,78,32,79,79,85,79,32,78,80,86,80,32,78,81,86,81,32,77,82,87,82,0,76,82,76,70,76,82,82,82,76,70,32,76,73,80,81,32,76,76,79,82,32,76,79,77,81,0,77,87,82,75,81,77,79,80,77,82,32,82,75,83,77,85,80,87,82,0,77,87,87,82,87,81,86,79,85,78,83,77,81,77,79,78,78,79,77,81,77,82,0,71,93,93,82,93,80,92,77,90,74,87,72,84,71,80,71,77,72,74,74,72,77,71,80,71,82,0,77,87,77,82,77,83,78,85,79,86,81,87,83,87,85,86,86,85,87,83,87,82,0,76,88,76,80,78,82,81,83,83,83,86,82,88,80,0,82,85,82,85,84,84,85,82,84,80,82,79,0,82,86,82,82,85,80,86,78,86,76,85,75,84,75,0,78,82,82,82,79,80,78,78,78,76,79,75,80,75,0,77,87,87,72,86,71,84,70,81,70,79,71,78,72,77,74,77,76,78,78,79,79,85,83,86,84,87,86,87,88,86,90,85,91,83,92,80,92,78,91,77,90,0,71,93,73,87,72,86,71,84,71,81,72,79,73,78,75,77,77,77,79,78,80,79,84,85,85,86,87,87,89,87,91,86,92,85,93,83,93,80,92,78,91,77,0,71,93,82,82,84,85,85,86,87,87,89,87,91,86,92,85,93,83,93,81,92,79,91,78,89,77,87,77,85,78,84,79,80,85,79,86,77,87,75,87,73,86,72,85,71,83,71,81,72,79,73,78,75,77,77,77,79,78,80,79,82,82,0,72,92,75,70,75,91,32,72,70,91,70,81,80,91,90,32,90,86,91,89,92,91,32,90,86,90,89,32,87,89,90,89,32,87,89,90,90,92,91,0,75,89,85,65,82,66,80,67,78,69,76,72,75,76,75,82,76,85,78,87,81,88,83,88,86,87,88,85,89,82,32,75,80,76,77,78,75,81,74,83,74,86,75,88,77,89,80,89,86,88,90,86,93,84,95,82,96,79,97,0,62,102,62,82,102,82,0,68,96,68,96,96,68,0,82,82,82,62,82,102,0,68,96,68,68,96,96,0,68,96,68,82,96,82,0,70,94,70,89,94,75,0,75,89,75,94,89,70,0,75,89,75,70,89,94,0,70,94,70,75,94,89,0,75,89,75,82,89,82,0,77,87,77,87,87,77,0,77,87,77,77,87,87,0,68,96,68,79,71,81,75,83,80,84,84,84,89,83,93,81,96,79,0,80,85,85,68,83,71,81,75,80,80,80,84,81,89,83,93,85,96,0,79,84,79,68,81,71,83,75,84,80,84,84,83,89,81,93,79,96,0,68,96,68,85,71,83,75,81,80,80,84,80,89,81,93,83,96,85,0,75,89,82,74,89,78,75,86,82,90,0,74,90,74,82,78,75,86,89,90,82,0,75,89,75,86,75,78,89,86,89,78,0,74,90,76,88,74,80,90,84,88,76,0,74,90,74,93,76,93,79,92,81,91,84,88,85,86,86,83,86,79,85,76,84,74,83,73,81,73,80,74,79,76,78,79,78,83,79,86,80,88,83,91,85,92,88,93,90,93,0,73,93,93,90,93,88,92,85,91,83,88,80,86,79,83,78,79,78,76,79,74,80,73,81,73,83,74,84,76,85,79,86,83,86,86,85,88,84,91,81,92,79,93,76,93,74,0,74,90,90,71,88,71,85,72,83,73,80,76,79,78,78,81,78,85,79,88,80,90,81,91,83,91,84,90,85,88,86,85,86,81,85,78,84,76,81,73,79,72,76,71,74,71,0,71,91,71,74,71,76,72,79,73,81,76,84,78,85,81,86,85,86,88,85,90,84,91,83,91,81,90,80,88,79,85,78,81,78,78,79,76,80,73,83,72,85,71,88,71,90,0,69,91,69,80,70,82,72,84,74,85,77,86,81,86,85,85,88,83,90,80,91,78,90,76,87,76,83,77,81,78,78,80,76,83,75,86,75,89,76,92,77,94,0,69,89,69,84,72,86,75,87,80,87,83,86,86,84,88,81,89,78,89,76,88,75,86,75,83,76,80,78,78,81,77,84,77,89,78,92,80,95,0,79,85,81,79,79,81,79,83,81,85,83,85,85,83,85,81,83,79,81,79,32,81,80,80,81,80,83,81,84,83,84,84,83,84,81,83,80,81,80,32,82,81,81,82,82,83,83,82,82,81,0,68,96,68,82,74,82,32,79,82,85,82,32,90,82,96,82,0,68,96,68,85,68,79,96,79,96,85,0,74,90,82,68,74,82,32,82,68,90,82,0,68,96,68,82,96,82,32,74,89,90,89,32,80,96,84,96,0,68,96,68,82,96,82,32,68,82,82,98,32,96,82,82,98,0,75,89,81,75,78,76,76,78,75,81,75,83,76,86,78,88,81,89,83,89,86,88,88,86,89,83,89,81,88,78,86,76,83,75,81,75,0,76,88,76,76,76,88,88,88,88,76,76,76,0,75,89,82,74,75,86,89,86,82,74,0,76,88,82,72,76,82,82,92,88,82,82,72,0,74,90,82,73,80,79,74,79,79,83,77,89,82,85,87,89,85,83,90,79,84,79,82,73,0,75,89,82,75,82,89,32,75,82,89,82,0,77,87,77,77,87,87,32,87,77,77,87,0,77,87,82,76,82,88,32,77,79,87,85,32,87,79,77,85,0,78,86,81,78,79,79,78,81,78,83,79,85,81,86,83,86,85,85,86,83,86,81,85,79,83,78,81,78,32,79,81,79,83,32,80,80,80,84,32,81,79,81,85,32,82,79,82,85,32,83,79,83,85,32,84,80,84,84,32,85,81,85,83,0,78,86,78,78,78,86,86,86,86,78,78,78,32,79,79,79,85,32,80,79,80,85,32,81,79,81,85,32,82,79,82,85,32,83,79,83,85,32,84,79,84,85,32,85,79,85,85,0,77,87,82,76,77,85,87,85,82,76,32,82,79,79,84,32,82,79,85,84,32,82,82,81,84,32,82,82,83,84,0,76,85,76,82,85,87,85,77,76,82,32,79,82,84,85,32,79,82,84,79,32,82,82,84,83,32,82,82,84,81,0,77,87,82,88,87,79,77,79,82,88,32,82,85,85,80,32,82,85,79,80,32,82,82,83,80,32,82,82,81,80,0,79,88,88,82,79,77,79,87,88,82,32,85,82,80,79,32,85,82,80,85,32,82,82,80,81,32,82,82,80,83,0,76,88,82,76,78,87,88,80,76,80,86,87,82,76,32,82,82,82,76,32,82,82,76,80,32,82,82,78,87,32,82,82,86,87,32,82,82,88,80,0,77,87,82,76,82,88,32,79,79,85,79,32,77,85,79,87,81,88,83,88,85,87,87,85,0,76,88,82,76,82,88,32,76,81,77,79,87,79,88,81,32,80,87,84,87,0,75,89,77,78,87,88,32,87,78,77,88,32,79,76,76,79,75,81,32,85,76,88,79,89,81,0,73,91,78,73,73,91,32,86,73,91,91,32,77,77,91,91,32,87,77,73,91,32,78,73,86,73,32,77,77,87,77,0,73,91,82,71,82,86,32,77,74,87,80,32,87,74,77,80,32,73,86,76,92,32,91,86,88,92,32,73,86,91,86,32,76,92,88,92,0,71,91,77,74,83,86,32,75,80,83,76,32,71,92,91,92,91,82,71,92,0,76,88,80,76,80,80,76,80,76,84,80,84,80,88,84,88,84,84,88,84,88,80,84,80,84,76,80,76,0,75,89,89,80,88,78,86,76,83,75,81,75,78,76,76,78,75,81,75,83,76,86,78,88,81,89,83,89,86,88,88,86,89,84,32,89,80,87,78,85,77,83,77,81,78,80,79,79,81,79,83,80,85,81,86,83,87,85,87,87,86,89,84,0,75,89,82,74,75,86,89,86,82,74,32,82,90,89,78,75,78,82,90,0,71,93,80,73,80,71,81,70,83,70,84,71,84,73,32,71,90,72,88,74,86,75,84,76,80,76,75,77,74,79,73,85,73,87,74,88,75,88,80,89,84,90,86,92,88,93,90,32,71,90,93,90,32,81,90,80,91,81,92,83,92,84,91,83,90,0,74,90,82,77,82,83,32,82,83,81,92,32,82,83,83,92,32,81,92,83,92,32,82,77,81,74,80,72,78,71,32,81,74,78,71,32,82,77,83,74,84,72,86,71,32,83,74,86,71,32,82,77,78,75,76,75,74,77,32,80,76,76,76,74,77,32,82,77,86,75,88,75,90,77,32,84,76,88,76,90,77,32,82,77,80,78,79,79,79,82,32,82,77,80,79,79,82,32,82,77,84,78,85,79,85,82,32,82,77,84,79,85,82,0,74,90,82,73,82,75,32,82,78,82,80,32,82,83,82,85,32,82,89,81,92,32,82,89,83,92,32,81,92,83,92,32,82,71,81,73,80,74,32,82,71,83,73,84,74,32,80,74,82,73,84,74,32,82,75,80,78,78,79,77,78,32,82,75,84,78,86,79,87,78,32,78,79,80,79,82,78,84,79,86,79,32,82,80,80,83,78,84,76,84,75,82,75,83,76,84,32,82,80,84,83,86,84,88,84,89,82,89,83,88,84,32,78,84,80,84,82,83,84,84,86,84,32,82,85,80,88,79,89,77,90,76,90,75,89,74,87,74,89,76,90,32,82,85,84,88,85,89,87,90,88,90,89,89,90,87,90,89,88,90,32,77,90,79,90,82,89,85,90,87,90,0,74,90,82,89,81,92,32,82,89,83,92,32,81,92,83,92,32,82,89,85,90,88,90,90,88,90,85,89,84,87,84,89,82,90,79,89,77,87,76,85,77,86,74,85,72,83,71,81,71,79,72,78,74,79,77,77,76,75,77,74,79,75,82,77,84,75,84,74,85,74,88,76,90,79,90,82,89,0,74,90,82,89,81,92,32,82,89,83,92,32,81,92,83,92,32,82,89,86,88,86,86,88,85,88,82,90,81,90,76,89,73,88,72,86,72,84,71,80,71,78,72,76,72,75,73,74,76,74,81,76,82,76,85,78,86,78,88,82,89,0,73,91,73,80,75,82,32,76,75,78,80,32,82,71,82,79,32,88,75,86,80,32,91,80,89,82,0,81,83,82,81,81,82,82,83,83,82,82,81,0,80,84,81,80,80,81,80,83,81,84,83,84,84,83,84,81,83,80,81,80,0,78,86,81,78,79,79,78,81,78,83,79,85,81,86,83,86,85,85,86,83,86,81,85,79,83,78,81,78,0,77,87,81,77,79,78,78,79,77,81,77,83,78,85,79,86,81,87,83,87,85,86,86,85,87,83,87,81,86,79,85,78,83,77,81,77,0,71,93,80,71,77,72,74,74,72,77,71,80,71,84,72,87,74,90,77,92,80,93,84,93,87,92,90,90,92,87,93,84,93,80,92,77,90,74,87,72,84,71,80,71,0,65,99,80,65,76,66,74,67,71,69,69,71,67,74,66,76,65,80,65,84,66,88,67,90,69,93,71,95,74,97,76,98,80,99,84,99,88,98,90,97,93,95,95,93,97,90,98,88,99,84,99,80,98,76,97,74,95,71,93,69,90,67,88,66,84,65,80,65,0,60,104,80,60,75,61,71,63,68,65,65,68,63,71,61,75,60,80,60,84,61,89,63,93,65,96,68,99,71,101,75,103,80,104,84,104,89,103,93,101,96,99,99,96,101,93,103,89,104,84,104,80,103,75,101,71,99,68,96,65,93,63,89,61,84,60,80,60,0,41,123,79,41,73,42,69,43,64,45,59,48,55,51,51,55,48,59,45,64,43,69,42,73,41,79,41,85,42,91,43,95,45,100,48,105,51,109,55,113,59,116,64,119,69,121,73,122,79,123,85,123,91,122,95,121,100,119,105,116,109,113,113,109,116,105,119,100,121,95,122,91,123,85,123,79,122,73,121,69,119,64,116,59,113,55,109,51,105,48,100,45,95,43,91,42,85,41,79,41,0,62,102,82,65,80,67,77,68,74,68,71,67,69,65,62,72,64,74,65,77,65,90,66,93,68,95,71,96,77,96,80,97,82,99,32,82,65,84,67,87,68,90,68,93,67,95,65,102,72,100,74,99,77,99,90,98,93,96,95,93,96,87,96,84,97,82,99,0,65,99,82,65,80,67,77,68,74,68,71,67,69,65,66,71,65,75,65,80,66,84,68,88,71,92,76,96,82,99,32,82,65,84,67,87,68,90,68,93,67,95,65,98,71,99,75,99,80,98,84,96,88,93,92,88,96,82,99,32,66,72,98,72,0,72,91,87,80,86,81,87,82,88,81,88,80,86,78,84,77,81,77,78,78,76,80,75,83,75,85,76,88,78,90,81,91,83,91,86,90,88,88,32,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,32,76,98,88,70,0,75,89,82,75,77,88,32,82,78,86,88,32,82,75,87,88,32,79,84,84,84,32,75,88,80,88,32,84,88,89,88,0,74,90,78,75,78,88,32,79,75,79,88,32,76,75,83,75,86,76,87,78,86,80,83,81,32,83,75,85,76,86,78,85,80,83,81,32,79,81,83,81,86,82,87,84,87,85,86,87,83,88,76,88,32,83,81,85,82,86,84,86,85,85,87,83,88,0,75,89,86,76,87,75,87,79,86,76,84,75,81,75,79,76,78,77,77,80,77,83,78,86,79,87,81,88,84,88,86,87,87,85,32,81,75,79,77,78,80,78,83,79,86,81,88,0,74,90,78,75,78,88,32,79,75,79,88,32,76,75,83,75,86,76,87,77,88,80,88,83,87,86,86,87,83,88,76,88,32,83,75,85,76,86,77,87,80,87,83,86,86,85,87,83,88,0,74,89,78,75,78,88,32,79,75,79,88,32,83,79,83,83,32,76,75,86,75,86,79,85,75,32,79,81,83,81,32,76,88,86,88,86,84,85,88,0,74,88,78,75,78,88,32,79,75,79,88,32,83,79,83,83,32,76,75,86,75,86,79,85,75,32,79,81,83,81,32,76,88,81,88,0,75,91,86,76,87,75,87,79,86,76,84,75,81,75,79,76,78,77,77,80,77,83,78,86,79,87,81,88,84,88,86,87,32,81,75,79,77,78,80,78,83,79,86,81,88,32,84,88,85,87,86,85,32,86,83,86,88,32,87,83,87,88,32,84,83,89,83,0,74,91,78,75,78,88,32,79,75,79,88,32,86,75,86,88,32,87,75,87,88,32,76,75,81,75,32,84,75,89,75,32,79,81,86,81,32,76,88,81,88,32,84,88,89,88,0,78,87,82,75,82,88,32,83,75,83,88,32,80,75,85,75,32,80,88,85,88,0,76,88,83,75,83,85,82,87,81,88,32,84,75,84,85,83,87,81,88,80,88,78,87,77,85,78,84,79,85,78,86,32,81,75,86,75,0,74,90,78,75,78,88,32,79,75,79,88,32,87,75,79,83,32,81,81,86,88,32,82,81,87,88,32,76,75,81,75,32,84,75,89,75,32,76,88,81,88,32,84,88,89,88,0,75,88,79,75,79,88,32,80,75,80,88,32,77,75,82,75,32,77,88,87,88,87,84,86,88,0,73,92,77,75,77,88,32,78,78,82,88,32,78,75,82,85,32,87,75,82,88,32,87,75,87,88,32,88,75,88,88,32,75,75,78,75,32,87,75,90,75,32,75,88,79,88,32,85,88,90,88,0,74,90,78,75,78,88,32,79,77,86,88,32,79,75,86,86,32,86,75,86,88,32,76,75,79,75,32,84,75,88,75,32,76,88,80,88,0,75,90,81,75,79,76,78,77,77,80,77,83,78,86,79,87,81,88,84,88,86,87,87,86,88,83,88,80,87,77,86,76,84,75,81,75,32,81,75,79,77,78,80,78,83,79,86,81,88,32,84,88,86,86,87,83,87,80,86,77,84,75,0,74,89,78,75,78,88,32,79,75,79,88,32,76,75,83,75,86,76,87,78,87,79,86,81,83,82,79,82,32,83,75,85,76,86,78,86,79,85,81,83,82,32,76,88,81,88,0,75,90,81,75,79,76,78,77,77,80,77,83,78,86,79,87,81,88,84,88,86,87,87,86,88,83,88,80,87,77,86,76,84,75,81,75,32,81,75,79,77,78,80,78,83,79,86,81,88,32,84,88,86,86,87,83,87,80,86,77,84,75,32,80,87,80,85,81,84,83,84,84,85,85,90,86,91,87,91,88,90,32,84,85,85,88,86,90,87,91,0,74,90,78,75,78,88,32,79,75,79,88,32,76,75,83,75,86,76,87,78,87,79,86,81,83,82,79,82,32,83,75,85,76,86,78,86,79,85,81,83,82,32,76,88,81,88,32,83,82,84,83,85,87,86,88,87,88,88,87,32,83,82,85,83,86,87,87,88,0,75,90,86,77,87,75,87,79,86,77,85,76,83,75,81,75,79,76,78,77,78,79,79,80,81,81,84,82,86,83,87,84,32,78,78,79,79,81,80,84,81,86,82,87,83,87,86,86,87,84,88,82,88,80,87,79,86,78,84,78,88,79,86,0,75,90,82,75,82,88,32,83,75,83,88,32,78,75,77,79,77,75,88,75,88,79,87,75,32,80,88,85,88,0,74,91,78,75,78,85,79,87,81,88,84,88,86,87,87,85,87,75,32,79,75,79,85,80,87,81,88,32,76,75,81,75,32,85,75,89,75,0,75,89,77,75,82,88,32,78,75,82,85,32,87,75,82,88,32,75,75,80,75,32,84,75,89,75,0,73,91,76,75,79,88,32,77,75,79,84,32,82,75,79,88,32,82,75,85,88,32,83,75,85,84,32,88,75,85,88,32,74,75,79,75,32,86,75,90,75,0,75,90,78,75,86,88,32,79,75,87,88,32,87,75,78,88,32,76,75,81,75,32,84,75,89,75,32,76,88,81,88,32,84,88,89,88,0,76,89,78,75,82,82,82,88,32,79,75,83,82,32,87,75,83,82,83,88,32,76,75,81,75,32,84,75,89,75,32,80,88,85,88,0,76,89,86,75,78,88,32,87,75,79,88,32,79,75,78,79,78,75,87,75,32,78,88,87,88,87,84,86,88,0,75,88,79,75,79,88,32,80,75,80,88,32,77,75,87,75,87,79,86,75,32,77,88,82,88,0,75,89,82,75,76,88,32,82,77,87,88,32,82,75,88,88,32,77,87,86,87,32,76,88,88,88,0,75,90,81,75,79,76,78,77,77,80,77,83,78,86,79,87,81,88,84,88,86,87,87,86,88,83,88,80,87,77,86,76,84,75,81,75,32,81,75,79,77,78,80,78,83,79,86,81,88,32,84,88,86,86,87,83,87,80,86,77,84,75,32,81,79,81,84,32,84,79,84,84,32,81,81,84,81,32,81,82,84,82,0,75,89,82,75,77,88,32,82,78,86,88,32,82,75,87,88,32,75,88,80,88,32,84,88,89,88,0,74,90,77,74,76,77,32,88,74,87,77,32,80,80,79,83,32,85,80,84,83,32,77,86,76,89,32,88,86,87,89,32,77,75,87,75,32,77,76,87,76,32,80,81,84,81,32,80,82,84,82,32,77,87,87,87,32,77,88,87,88,0,74,91,78,75,78,88,32,79,75,79,88,32,86,75,86,88,32,87,75,87,88,32,76,75,89,75,32,76,88,81,88,32,84,88,89,88,0,75,91,77,75,82,81,32,78,75,83,81,77,88,32,77,75,87,75,88,79,86,75,32,78,87,87,87,32,77,88,87,88,88,84,86,88,0,75,90,77,79,78,76,79,75,80,75,81,76,82,79,82,88,32,88,79,87,76,86,75,85,75,84,76,83,79,83,88,32,77,79,78,77,79,76,80,76,81,77,82,79,32,88,79,87,77,86,76,85,76,84,77,83,79,32,80,88,85,88,0,75,90,82,75,82,88,32,83,75,83,88,32,81,78,78,79,77,81,77,82,78,84,81,85,84,85,87,84,88,82,88,81,87,79,84,78,81,78,32,81,78,79,79,78,81,78,82,79,84,81,85,32,84,85,86,84,87,82,87,81,86,79,84,78,32,80,75,85,75,32,80,88,85,88,0,74,91,82,75,82,88,32,83,75,83,88,32,76,80,77,79,78,79,79,83,81,85,32,84,85,86,83,87,79,88,79,89,80,32,77,79,78,82,79,84,81,85,84,85,86,84,87,82,88,79,32,80,75,85,75,32,80,88,85,88,0,75,90,77,86,78,88,81,88,77,82,77,79,78,77,79,76,81,75,84,75,86,76,87,77,88,79,88,82,84,88,87,88,88,86,32,79,85,78,82,78,79,79,77,81,75,32,84,75,86,77,87,79,87,82,86,85,32,78,87,80,87,32,85,87,87,87,0,75,89,84,75,75,88,32,83,77,84,88,32,84,75,85,88,32,78,84,84,84,32,73,88,78,88,32,82,88,87,88,0,74,89,80,75,76,88,32,81,75,77,88,32,78,75,85,75,87,76,87,78,86,80,83,81,32,85,75,86,76,86,78,85,80,83,81,32,79,81,82,81,84,82,85,83,85,85,84,87,81,88,74,88,32,82,81,84,83,84,85,83,87,81,88,0,75,88,86,76,87,76,88,75,87,78,86,76,84,75,82,75,80,76,79,77,78,79,77,82,77,85,78,87,80,88,82,88,84,87,85,85,32,82,75,80,77,79,79,78,82,78,86,80,88,0,74,89,80,75,76,88,32,81,75,77,88,32,78,75,84,75,86,76,87,78,87,81,86,84,85,86,84,87,81,88,74,88,32,84,75,85,76,86,78,86,81,85,84,84,86,83,87,81,88,0,74,89,80,75,76,88,32,81,75,77,88,32,83,79,82,83,32,78,75,88,75,87,78,87,75,32,79,81,82,81,32,74,88,84,88,85,85,83,88,0,74,88,80,75,76,88,32,81,75,77,88,32,83,79,82,83,32,78,75,88,75,87,78,87,75,32,79,81,82,81,32,74,88,79,88,0,75,89,86,76,87,76,88,75,87,78,86,76,84,75,82,75,80,76,79,77,78,79,77,82,77,85,78,87,80,88,82,88,84,87,85,86,86,83,32,82,75,80,77,79,79,78,82,78,86,80,88,32,82,88,84,86,85,83,32,83,83,88,83,0,74,91,80,75,76,88,32,81,75,77,88,32,88,75,84,88,32,89,75,85,88,32,78,75,83,75,32,86,75,91,75,32,79,81,86,81,32,74,88,79,88,32,82,88,87,88,0,78,87,84,75,80,88,32,85,75,81,88,32,82,75,87,75,32,78,88,83,88,0,76,88,85,75,82,85,81,87,80,88,32,86,75,83,85,82,87,80,88,79,88,77,87,76,85,77,84,78,85,77,86,32,83,75,88,75,0,74,90,80,75,76,88,32,81,75,77,88,32,89,75,79,82,32,82,80,84,88,32,83,80,85,88,32,78,75,83,75,32,86,75,91,75,32,74,88,79,88,32,82,88,87,88,0,75,88,81,75,77,88,32,82,75,78,88,32,79,75,84,75,32,75,88,85,88,86,85,84,88,0,73,92,79,75,75,88,32,79,77,80,88,32,80,75,81,86,32,89,75,80,88,32,89,75,85,88,32,90,75,86,88,32,77,75,80,75,32,89,75,92,75,32,73,88,77,88,32,83,88,88,88,0,74,90,80,75,76,88,32,80,75,84,88,32,81,75,84,85,32,88,75,84,88,32,78,75,81,75,32,86,75,90,75,32,74,88,78,88,0,75,89,82,75,80,76,79,77,78,79,77,82,77,85,78,87,80,88,82,88,84,87,85,86,86,84,87,81,87,78,86,76,84,75,82,75,32,82,75,80,77,79,79,78,82,78,86,80,88,32,82,88,84,86,85,84,86,81,86,77,84,75,0,74,89,80,75,76,88,32,81,75,77,88,32,78,75,85,75,87,76,88,77,88,79,87,81,84,82,79,82,32,85,75,87,77,87,79,86,81,84,82,32,74,88,79,88,0,75,89,82,75,80,76,79,77,78,79,77,82,77,85,78,87,80,88,82,88,84,87,85,86,86,84,87,81,87,78,86,76,84,75,82,75,32,82,75,80,77,79,79,78,82,78,86,80,88,32,82,88,84,86,85,84,86,81,86,77,84,75,32,79,87,79,86,80,85,81,85,82,86,82,90,83,91,84,91,85,90,32,82,86,83,90,84,91,0,74,90,80,75,76,88,32,81,75,77,88,32,78,75,85,75,87,76,88,77,88,79,87,81,84,82,79,82,32,85,75,87,77,87,79,86,81,84,82,32,83,82,84,87,85,88,86,88,87,87,32,83,82,84,83,85,87,86,88,32,74,88,79,88,0,75,90,87,76,88,76,89,75,88,78,87,76,85,75,82,75,80,76,79,77,79,79,80,80,85,83,86,84,32,79,78,80,79,85,82,86,83,86,86,85,87,83,88,80,88,78,87,77,85,76,88,77,87,78,87,0,75,90,84,75,80,88,32,85,75,81,88,32,80,75,78,78,79,75,90,75,89,78,89,75,32,78,88,83,88,0,74,91,80,75,77,85,77,87,79,88,83,88,85,87,86,85,89,75,32,81,75,78,85,78,87,79,88,32,78,75,83,75,32,87,75,91,75,0,75,89,79,75,80,88,32,80,75,81,86,32,89,75,80,88,32,77,75,82,75,32,86,75,91,75,0,73,91,78,75,77,88,32,79,75,78,86,32,84,75,77,88,32,84,75,83,88,32,85,75,84,86,32,90,75,83,88,32,76,75,81,75,32,88,75,92,75,0,75,90,80,75,84,88,32,81,75,85,88,32,89,75,76,88,32,78,75,83,75,32,86,75,91,75,32,74,88,79,88,32,82,88,87,88,0,76,89,80,75,82,81,80,88,32,81,75,83,81,32,89,75,83,81,81,88,32,78,75,83,75,32,86,75,91,75,32,78,88,83,88,0,76,89,88,75,76,88,32,89,75,77,88,32,81,75,79,78,80,75,89,75,32,76,88,85,88,86,85,84,88,0,75,90,77,72,88,92,0,74,90,82,77,76,87,32,82,77,88,87,0,76,90,81,79,80,80,80,81,79,81,79,80,81,79,84,79,86,81,86,87,87,88,88,88,32,84,79,85,81,85,87,87,88,32,85,82,82,83,80,84,79,85,79,87,80,88,83,88,84,87,85,85,32,82,83,80,85,80,87,81,88,0,74,89,78,75,78,88,32,79,75,79,88,32,79,82,80,80,82,79,84,79,86,80,87,82,87,85,86,87,84,88,82,88,80,87,79,85,32,84,79,85,80,86,82,86,85,85,87,84,88,32,76,75,79,75,0,76,88,86,81,85,81,85,82,86,82,86,81,85,80,83,79,81,79,79,80,78,82,78,85,79,87,81,88,83,88,85,87,86],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+276481);allocate([86,32,81,79,80,80,79,82,79,85,80,87,81,88,0,76,91,86,75,86,88,32,87,75,87,88,32,86,82,85,80,83,79,81,79,79,80,78,82,78,85,79,87,81,88,83,88,85,87,86,85,32,81,79,80,80,79,82,79,85,80,87,81,88,32,84,75,87,75,32,86,88,89,88,0,76,88,79,83,86,83,86,82,85,80,83,79,81,79,79,80,78,82,78,85,79,87,81,88,83,88,85,87,86,86,32,85,83,85,81,83,79,32,81,79,80,80,79,82,79,85,80,87,81,88,0,76,87,84,75,85,76,85,77,86,77,86,76,84,75,82,75,80,77,80,88,32,82,75,81,77,81,88,32,78,79,83,79,32,78,88,83,88,0,76,89,81,79,79,81,79,83,81,85,83,85,85,83,85,81,83,79,81,79,32,81,79,80,81,80,83,81,85,32,83,85,84,83,84,81,83,79,32,84,80,85,79,86,79,32,80,84,79,85,79,88,80,89,84,89,86,90,32,79,87,80,88,84,88,86,89,86,91,84,92,80,92,78,91,78,89,80,88,0,74,91,78,75,78,88,32,79,75,79,88,32,79,82,80,80,82,79,84,79,86,80,87,82,87,88,32,84,79,85,80,86,82,86,88,32,76,75,79,75,32,76,88,81,88,32,84,88,89,88,0,78,87,82,75,82,76,83,76,83,75,82,75,32,82,79,82,88,32,83,79,83,88,32,80,79,83,79,32,80,88,85,88,0,78,87,83,75,83,76,84,76,84,75,83,75,32,83,79,83,90,82,92,32,84,79,84,90,82,92,80,92,79,91,79,90,80,90,80,91,79,91,32,81,79,84,79,0,74,90,78,75,78,88,32,79,75,79,88,32,87,79,79,85,32,82,83,86,88,32,83,83,87,88,32,76,75,79,75,32,84,79,89,79,32,76,88,81,88,32,84,88,89,88,0,78,87,82,75,82,88,32,83,75,83,88,32,80,75,83,75,32,80,88,85,88,0,70,95,74,79,74,88,32,75,79,75,88,32,75,82,76,80,78,79,80,79,82,80,83,82,83,88,32,80,79,81,80,82,82,82,88,32,83,82,84,80,86,79,88,79,90,80,91,82,91,88,32,88,79,89,80,90,82,90,88,32,72,79,75,79,32,72,88,77,88,32,80,88,85,88,32,88,88,93,88,0,74,91,78,79,78,88,32,79,79,79,88,32,79,82,80,80,82,79,84,79,86,80,87,82,87,88,32,84,79,85,80,86,82,86,88,32,76,79,79,79,32,76,88,81,88,32,84,88,89,88,0,76,89,81,79,79,80,78,82,78,85,79,87,81,88,84,88,86,87,87,85,87,82,86,80,84,79,81,79,32,81,79,80,80,79,82,79,85,80,87,81,88,32,84,88,85,87,86,85,86,82,85,80,84,79,0,74,89,78,79,78,92,32,79,79,79,92,32,79,82,80,80,82,79,84,79,86,80,87,82,87,85,86,87,84,88,82,88,80,87,79,85,32,84,79,85,80,86,82,86,85,85,87,84,88,32,76,79,79,79,32,76,92,81,92,0,75,89,85,79,85,92,32,86,79,86,92,32,85,82,84,80,82,79,80,79,78,80,77,82,77,85,78,87,80,88,82,88,84,87,85,85,32,80,79,79,80,78,82,78,85,79,87,80,88,32,83,92,88,92,0,75,88,79,79,79,88,32,80,79,80,88,32,80,82,81,80,83,79,85,79,86,80,86,81,85,81,85,80,86,80,32,77,79,80,79,32,77,88,82,88,0,76,89,84,79,85,80,85,81,86,81,86,80,84,79,81,79,79,80,79,82,81,83,84,84,86,85,32,79,81,81,82,84,83,86,84,86,87,84,88,81,88,79,87,79,86,80,86,80,87,81,88,0,76,87,80,75,80,86,82,88,84,88,85,87,85,86,32,81,75,81,86,82,88,32,78,79,84,79,0,74,91,78,79,78,85,79,87,81,88,83,88,85,87,86,85,32,79,79,79,85,80,87,81,88,32,86,79,86,88,32,87,79,87,88,32,76,79,79,79,32,84,79,87,79,32,86,88,89,88,0,75,89,78,79,82,88,32,79,79,82,86,32,86,79,82,88,32,76,79,81,79,32,84,79,88,79,0,73,91,76,79,79,88,32,77,79,79,85,32,82,79,79,88,32,82,79,85,88,32,83,79,85,85,32,88,79,85,88,32,74,79,79,79,32,86,79,90,79,0,75,89,78,79,85,88,32,79,79,86,88,32,86,79,78,88,32,76,79,81,79,32,84,79,88,79,32,76,88,80,88,32,83,88,88,88,0,75,89,78,79,82,88,32,79,79,82,86,32,86,79,82,88,80,91,78,92,77,92,76,91,76,90,77,90,77,91,76,91,32,76,79,81,79,32,84,79,88,79,0,76,88,85,79,78,88,32,86,79,79,88,32,79,79,78,81,78,79,86,79,32,78,88,86,88,86,86,85,88,0,75,91,81,79,79,80,78,81,77,83,77,85,78,87,80,88,81,88,83,87,85,85,87,82,88,79,32,81,79,79,81,78,83,78,85,79,87,80,88,32,81,79,83,79,85,80,87,87,88,88,32,83,79,84,80,86,87,88,88,89,88,0,75,88,82,75,80,77,79,79,77,85,75,92,32,81,76,80,78,78,84,76,92,32,82,75,84,75,86,76,86,78,85,80,82,81,32,84,75,85,76,85,78,84,80,82,81,32,82,81,84,82,85,84,85,86,84,87,82,88,81,88,79,87,78,84,32,82,81,83,82,84,84,84,86,82,88,0,75,89,76,81,78,79,80,79,82,80,83,83,83,88,82,92,32,76,81,78,80,80,80,82,81,83,83,32,87,79,86,82,83,88,81,92,0,75,89,83,79,81,79,79,80,78,81,77,83,77,85,78,87,80,88,82,88,84,87,85,86,86,84,86,82,85,80,82,78,81,76,81,75,82,74,84,74,85,75,86,77,32,81,79,79,81,78,83,78,86,80,88,32,82,88,84,86,85,84,85,81,83,79,32,81,76,82,75,84,75,86,77,0,76,88,86,80,84,79,81,79,79,80,79,81,80,82,82,83,32,81,79,80,80,80,81,82,83,32,82,83,79,84,78,85,78,87,80,88,83,88,85,87,32,82,83,80,84,79,85,79,87,80,88,0,76,87,82,75,81,76,81,77,83,78,86,78,86,77,83,78,80,79,79,80,78,82,78,84,79,86,80,87,82,88,83,89,83,91,82,92,80,92,79,91,32,83,78,81,79,80,80,79,82,79,84,80,86,82,88,0,73,89,74,82,75,80,76,79,78,79,79,80,79,81,77,88,32,77,79,78,80,78,81,76,88,32,79,81,80,80,82,79,84,79,86,80,86,82,83,92,32,84,79,85,80,85,82,82,92,0,73,89,74,83,75,81,76,80,78,80,79,81,79,86,80,88,32,77,80,78,81,78,85,79,87,80,88,81,88,83,87,84,86,85,84,86,81,86,78,85,76,84,75,82,75,81,76,81,78,82,80,85,82,87,83,32,81,88,83,86,84,84,85,81,85,78,84,75,0,78,87,82,79,80,86,80,87,81,88,83,88,85,87,86,85,32,83,79,81,86,81,87,82,88,0,75,89,79,79,76,88,32,80,79,77,88,32,85,79,86,80,87,80,86,79,84,79,82,81,79,82,32,79,82,80,83,82,87,84,88,86,87,87,85,32,79,82,81,83,83,87,84,88,0,76,88,76,75,78,75,80,76,87,88,32,78,75,79,76,86,88,32,82,80,77,88,32,82,80,78,88,0,75,90,79,79,75,92,32,80,79,76,92,32,78,85,78,87,79,88,81,88,83,87,84,86,32,86,79,84,86,84,87,85,88,87,88,88,87,89,85,32,87,79,85,86,85,87,86,88,0,74,89,78,79,77,88,32,79,79,78,85,77,88,32,86,82,86,79,87,79,86,82,84,85,81,87,78,88,77,88,32,76,79,79,79,0,77,88,82,75,81,76,81,77,83,78,86,78,32,84,78,81,79,80,80,80,82,82,83,85,83,32,84,78,82,79,81,80,81,82,82,83,32,83,83,80,84,79,85,79,87,81,88,83,89,84,90,84,91,83,92,81,92,32,83,83,81,84,80,85,80,87,81,88,0,75,88,81,79,79,80,78,81,77,83,77,85,78,87,80,88,82,88,84,87,85,86,86,84,86,82,85,80,83,79,81,79,32,81,79,79,81,78,83,78,86,80,88,32,82,88,84,86,85,84,85,81,83,79,0,73,90,80,80,77,88,32,80,80,78,88,32,84,80,83,88,32,84,80,84,88,32,75,81,77,79,88,79,32,75,81,77,80,88,80,0,74,88,83,79,81,79,79,80,78,81,77,83,74,92,32,81,79,79,81,78,83,75,92,32,83,79,85,80,86,82,86,84,85,86,84,87,82,88,80,88,78,87,77,85,32,83,79,85,81,85,84,84,86,82,88,0,75,91,89,79,81,79,79,80,78,81,77,83,77,85,78,87,80,88,82,88,84,87,85,86,86,84,86,82,85,80,89,80,32,81,79,79,81,78,83,78,86,80,88,32,82,88,84,86,85,84,85,81,83,79,0,75,90,83,80,81,88,32,83,80,82,88,32,77,81,79,79,88,79,32,77,81,79,80,88,80,0,74,88,75,82,76,80,77,79,79,79,80,80,80,82,79,85,79,87,80,88,32,78,79,79,80,79,82,78,85,78,87,80,88,81,88,83,87,85,85,86,82,86,79,85,79,86,80,0,75,90,79,80,78,81,77,83,77,85,78,87,80,88,82,88,85,87,87,85,88,82,88,80,87,79,85,79,84,80,83,82,82,85,79,92,32,77,85,78,86,80,87,82,87,85,86,87,84,88,82,32,88,81,87,80,85,80,83,82,32,82,85,81,88,80,92,0,75,88,77,79,78,79,80,80,83,91,84,92,32,78,79,79,80,82,91,84,92,85,92,32,86,79,84,82,78,89,76,92,0,73,91,84,75,81,92,32,85,75,80,92,32,74,82,75,80,76,79,78,79,79,80,79,86,80,87,83,87,85,86,87,84,32,77,79,78,80,78,84,79,87,80,88,83,88,85,87,87,84,88,82,89,79,0,74,90,78,80,80,80,80,79,78,80,77,81,76,83,76,85,77,87,78,88,80,88,81,87,82,85,83,82,32,76,85,78,87,80,87,82,85,32,82,82,82,87,83,88,85,88,87,86,88,84,88,82,87,80,86,79,86,80,87,80,32,82,85,83,87,85,87,87,86,0,75,90,86,79,84,86,84,87,85,88,87,88,88,87,89,85,32,87,79,85,86,85,87,86,88,32,85,83,85,81,83,79,81,79,79,80,78,81,77,83,77,85,78,87,80,88,82,88,84,86,32,81,79,79,81,78,83,78,86,80,88,0,74,88,79,75,77,82,32,80,75,78,82,78,86,80,88,32,78,82,79,80,81,79,83,79,85,80,86,82,86,84,85,86,84,87,82,88,80,88,78,87,77,85,77,82,32,83,79,85,81,85,84,84,86,82,88,32,77,75,80,75,0,75,88,85,80,85,81,86,81,85,80,83,79,81,79,79,80,78,81,77,83,77,85,78,87,80,88,82,88,84,87,85,86,32,81,79,79,81,78,83,78,86,80,88,0,75,90,87,75,84,86,84,87,85,88,87,88,88,87,89,85,32,88,75,85,86,85,87,86,88,32,85,83,85,81,83,79,81,79,79,80,78,81,77,83,77,85,78,87,80,88,82,88,84,86,32,81,79,79,81,78,83,78,86,80,88,32,85,75,88,75,0,75,87,78,85,82,84,84,83,85,82,85,80,83,79,81,79,79,80,78,81,77,83,77,85,78,87,80,88,82,88,84,87,85,86,32,81,79,79,81,78,83,78,86,80,88,0,77,88,87,75,88,76,88,75,86,75,84,76,83,78,80,89,79,91,78,92,32,86,75,85,76,84,78,81,89,80,91,78,92,76,92,76,91,77,92,32,80,79,86,79,0,75,89,86,79,84,86,83,89,82,91,32,87,79,85,86,84,89,82,91,80,92,77,92,76,91,77,91,78,92,32,85,83,85,81,83,79,81,79,79,80,78,81,77,83,77,85,78,87,80,88,82,88,84,86,32,81,79,79,81,78,83,78,86,80,88,0,75,90,80,75,76,88,32,81,75,77,88,32,79,81,80,80,82,79,84,79,86,80,86,82,85,85,85,87,86,88,32,84,79,85,80,85,82,84,85,84,87,85,88,87,88,88,87,89,85,32,78,75,81,75,0,77,87,83,75,83,76,84,76,84,75,83,75,32,78,82,79,80,80,79,82,79,83,80,83,82,82,85,82,87,83,88,32,81,79,82,80,82,82,81,85,81,87,82,88,84,88,85,87,86,85,0,77,87,84,75,84,76,85,76,85,75,84,75,32,79,82,80,80,81,79,83,79,84,80,84,82,82,89,81,91,79,92,77,92,77,91,78,92,32,82,79,83,80,83,82,81,89,80,91,79,92,0,75,88,80,75,76,88,32,81,75,77,88,32,86,80,85,81,86,81,86,80,85,79,84,79,82,81,80,82,79,82,32,79,82,80,83,81,87,82,88,84,88,85,87,86,85,32,79,82,81,83,82,87,83,88,32,78,75,81,75,0,78,86,83,75,80,86,80,87,81,88,83,88,84,87,85,85,32,84,75,81,86,81,87,82,88,32,81,75,84,75,0,70,94,71,82,72,80,73,79,75,79,76,80,76,81,74,88,32,74,79,75,80,75,81,73,88,32,76,81,77,80,79,79,81,79,83,80,83,81,81,88,32,81,79,82,80,82,81,80,88,32,83,81,84,80,86,79,88,79,90,80,90,82,89,85,89,87,90,88,32,88,79,89,80,89,82,88,85,88,87,89,88,91,88,92,87,93,85,0,74,91,75,82,76,80,77,79,79,79,80,80,80,81,78,88,32,78,79,79,80,79,81,77,88,32,80,81,81,80,83,79,85,79,87,80,87,82,86,85,86,87,87,88,32,85,79,86,80,86,82,85,85,85,87,86,88,88,88,89,87,90,85,0,74,89,75,82,76,80,77,79,79,79,80,80,80,81,77,92,32,78,79,79,80,79,81,76,92,32,80,81,82,79,84,79,86,80,87,82,87,84,86,86,85,87,83,88,81,88,79,86,79,84,32,84,79,86,81,86,84,85,86,83,88,32,74,92,79,92,0,75,89,86,79,82,92,32,87,79,83,92,32,85,83,85,81,83,79,81,79,79,80,78,81,77,83,77,85,78,87,80,88,82,88,84,86,32,81,79,79,81,78,83,78,86,80,88,32,80,92,85,92,0,76,88,77,82,78,80,79,79,81,79,82,80,82,81,80,88,32,80,79,81,80,81,81,79,88,32,82,81,83,80,85,79,86,79,87,80,87,81,86,81,87,80,0,76,89,86,80,86,81,87,81,86,80,84,79,81,79,79,80,79,82,81,83,84,84,86,85,32,79,81,81,82,84,83,86,84,86,87,84,88,81,88,79,87,78,86,79,86,79,87,0,78,87,83,75,80,86,80,87,81,88,83,88,84,87,85,85,32,84,75,81,86,81,87,82,88,32,80,79,85,79,0,73,90,74,82,75,80,76,79,78,79,79,80,79,82,78,85,78,87,79,88,32,77,79,78,80,78,82,77,85,77,87,79,88,81,88,83,87,84,86,32,86,79,84,86,84,87,85,88,87,88,88,87,89,85,32,87,79,85,86,85,87,86,88,0,72,92,73,82,74,80,75,79,77,79,78,80,78,82,77,85,77,87,78,88,32,76,79,77,80,77,82,76,85,76,87,78,88,79,88,81,87,82,86,32,84,79,82,86,82,87,84,88,32,85,79,83,86,83,87,84,88,85,88,87,87,89,85,90,82,90,79,89,79,90,80,0,74,90,77,82,78,80,80,79,82,79,83,80,83,82,32,81,79,82,80,82,82,81,85,80,87,78,88,77,88,76,87,76,86,77,86,76,87,32,88,80,87,81,88,81,88,80,87,79,86,79,84,80,83,82,82,85,82,87,83,88,32,81,85,81,87,82,88,84,88,86,87,87,85,0,73,89,74,82,75,80,76,79,78,79,79,80,79,82,78,85,78,87,79,88,32,77,79,78,80,78,82,77,85,77,87,79,88,81,88,83,87,84,86,32,86,79,84,86,83,89,82,91,32,87,79,85,86,84,89,82,91,80,92,77,92,76,91,77,91,78,92,0,75,89,87,79,87,80,86,81,78,86,77,87,77,88,32,78,81,79,79,82,79,85,81,32,79,80,82,80,85,81,86,81,32,78,86,79,86,82,87,85,87,32,79,86,82,88,85,88,86,86,0,72,91,82,75,83,76,83,77,84,77,84,76,82,75,79,75,77,76,76,78,76,88,32,79,75,78,76,77,78,77,88,32,88,75,89,76,89,77,90,77,90,76,88,75,86,75,84,77,84,88,32,86,75,85,77,85,88,32,74,79,87,79,32,74,88,79,88,32,82,88,87,88,0,74,91,85,75,86,76,87,76,87,75,81,75,79,76,78,78,78,88,32,81,75,80,76,79,78,79,88,32,86,79,86,88,32,87,79,87,88,32,76,79,87,79,32,76,88,81,88,32,84,88,89,88,0,74,91,87,75,81,75,79,76,78,78,78,88,32,81,75,80,76,79,78,79,88,32,85,75,86,76,86,88,32,87,75,87,88,32,76,79,86,79,32,76,88,81,88,32,84,88,89,88,0,70,95,80,75,81,76,81,77,82,77,82,76,80,75,77,75,75,76,74,78,74,88,32,77,75,76,76,75,78,75,88,32,89,75,90,76,91,76,91,75,85,75,83,76,82,78,82,88,32,85,75,84,76,83,78,83,88,32,90,79,90,88,32,91,79,91,88,32,72,79,91,79,32,72,88,77,88,32,80,88,85,88,32,88,88,93,88,0,70,95,80,75,81,76,81,77,82,77,82,76,80,75,77,75,75,76,74,78,74,88,32,77,75,76,76,75,78,75,88,32,91,75,85,75,83,76,82,78,82,88,32,85,75,84,76,83,78,83,88,32,89,75,90,76,90,88,32,91,75,91,88,32,72,79,90,79,32,72,88,77,88,32,80,88,85,88,32,88,88,93,88,0,78,87,82,79,82,88,32,83,79,83,88,32,80,79,83,79,32,80,88,85,88,0,76,88,86,80,84,79,82,79,80,80,79,81,78,83,78,85,79,87,81,88,83,88,85,87,32,82,79,80,81,79,83,79,86,81,88,32,79,83,83,83,0,76,89,83,75,81,76,80,77,79,79,78,82,78,85,79,87,80,88,82,88,84,87,85,86,86,84,87,81,87,78,86,76,85,75,83,75,32,83,75,81,77,80,79,79,83,79,86,80,88,32,82,88,84,86,85,84,86,80,86,77,85,75,32,79,81,86,81,0,75,90,84,75,81,92,32,85,75,80,92,32,81,79,78,80,77,82,77,85,78,87,81,88,84,88,87,87,88,85,88,82,87,80,84,79,81,79,32,81,79,79,80,78,82,78,85,79,87,81,88,32,84,88,86,87,87,85,87,82,86,80,84,79,0,76,88,85,80,86,82,86,81,85,80,83,79,81,79,79,80,78,82,78,84,79,86,82,88,32,81,79,79,81,79,84,80,86,82,88,83,89,83,91,82,92,80,92,0,73,91,86,75,87,76,88,76,86,75,83,75,81,76,80,77,79,79,76,89,75,91,74,92,32,83,75,81,77,80,79,77,89,76,91,74,92,72,92,72,91,73,92,32,90,75,91,76,91,75,89,75,87,76,86,78,83,89,82,91,81,92,32,89,75,88,76,87,78,84,89,83,91,81,92,79,92,79,91,80,92,32,76,79,89,79,0,73,90,86,75,87,76,88,76,88,75,83,75,81,76,80,77,79,79,76,89,75,91,74,92,32,83,75,81,77,80,79,77,89,76,91,74,92,72,92,72,91,73,92,32,86,79,84,86,84,87,85,88,87,88,88,87,89,85,32,87,79,85,86,85,87,86,88,32,76,79,87,79,0,73,90,86,75,87,76,32,88,75,83,75,81,76,80,77,79,79,76,89,75,91,74,92,32,83,75,81,77,80,79,77,89,76,91,74,92,72,92,72,91,73,92,32,87,75,84,86,84,87,85,88,87,88,88,87,89,85,32,88,75,85,86,85,87,86,88,32,76,79,86,79,0,70,94,83,75,84,76,84,77,32,85,76,83,75,80,75,78,76,77,77,76,79,73,89,72,91,71,92,32,80,75,78,77,77,79,74,89,73,91,71,92,69,92,69,91,70,92,32,90,75,91,76,92,76,92,75,87,75,85,76,32,84,77,83,79,80,89,79,91,78,92,32,87,75,85,77,84,79,81,89,80,91,78,92,76,92,76,91,77,92,32,90,79,88,86,88,87,89,88,91,88,92,87,93,85,32,91,79,89,86,89,87,90,88,32,73,79,91,79,0,70,94,83,75,84,76,84,77,32,85,76,83,75,80,75,78,76,77,77,76,79,73,89,72,91,71,92,32,80,75,78,77,77,79,74,89,73,91,71,92,69,92,69,91,70,92,32,90,75,91,76,32,92,75,87,75,85,76,32,84,77,83,79,80,89,79,91,78,92,32,87,75,85,77,84,79,81,89,80,91,78,92,76,92,76,91,77,92,32,91,75,88,86,88,87,89,88,91,88,92,87,93,85,32,92,75,89,86,89,87,90,88,32,73,79,90,79,0,77,87,78,82,79,80,80,79,82,79,83,80,83,82,82,85,82,87,83,88,32,81,79,82,80,82,82,81,85,81,87,82,88,84,88,85,87,86,85,0,79,85,0,76,88,0,76,89,81,75,79,76,78,79,78,84,79,87,81,88,84,88,86,87,87,84,87,79,86,76,84,75,81,75,32,81,75,80,76,79,79,79,84,80,87,81,88,32,84,88,85,87,86,84,86,79,85,76,84,75,0,76,89,80,78,83,75,83,88,32,82,76,82,88,32,79,88,86,88,0,76,89,79,77,79,78,78,78,78,77,79,76,81,75,84,75,86,76,87,78,86,80,84,81,81,82,79,83,78,85,78,88,32,84,75,85,76,86,78,85,80,84,81,32,78,87,79,86,80,86,83,87,86,87,87,86,32,80,86,83,88,86,88,87,86,87,85,0,76,89,79,77,79,78,78,78,78,77,79,76,81,75,84,75,86,76,87,78,86,80,84,81,32,84,75,85,76,86,78,85,80,84,81,32,82,81,84,81,86,82,87,84,87,85,86,87,84,88,81,88,79,87,78,86,78,85,79,85,79,86,32,84,81,85,82,86,84,86,85,85,87,84,88,0,76,89,83,77,83,88,32,84,75,84,88,32,84,75,77,84,88,84,32,81,88,86,88,0,76,89,79,75,78,81,32,79,75,86,75,32,79,76,83,76,86,75,32,78,81,79,80,81,79,84,79,86,80,87,82,87,85,86,87,84,88,81,88,79,87,78,86,78,85,79,85,79,86,32,84,79,85,80,86,82,86,85,85,87,84,88,0,76,89,86,77,86,78,87,78,87,77,86,76,84,75,82,75,80,76,79,77,78,80,78,85,79,87,81,88,84,88,86,87,87,85,87,83,86,81,84,80,81,80,78,82,32,82,75,80,77,79,80,79,85,80,87,81,88,32,84,88,85,87,86,85,86,83,85,81,84,80,0,76,89,78,75,78,79,32,86,77,82,84,80,88,32,87,75,84,81,81,88,32,78,77,80,75,82,75,85,77,32,78,77,80,76,82,76,85,77,86,77,0,76,89,81,75,79,76,78,78,79,80,81,81,84,81,86,80,87,78,86,76,84,75,81,75,32,81,75,80,76,79,78,80,80,81,81,32,84,81,85,80,86,78,85,76,84,75,32,81,81,79,82,78,84,78,85,79,87,81,88,84,88,86,87,87,85,87,84,86,82,84,81,32,81,81,80,82,79,84,79,85,80,87,81,88,32,84,88,85,87,86,85,86,84,85,82,84,81,0,76,89,79,86,79,85,78,85,78,86,79,87,81,88,83,88,85,87,86,86,87,83,87,78,86,76,84,75,81,75,79,76,78,78,78,80,79,82,81,83,84,83,87,81,32,83,88,85,86,86,83,86,78,85,76,84,75,32,81,75,80,76,79,78,79,80,80,82,81,83,0,78,86,82,86,81,87,82,88,83,87,82,86,0,78,86,83,87,82,88,81,87,82,86,83,87,83,89,81,91,0,78,86,82,79,81,80,82,81,83,80,82,79,32,82,86,81,87,82,88,83,87,82,86,0,78,86,82,79,81,80,82,81,83,80,82,79,32,83,87,82,88,81,87,82,86,83,87,83,89,81,91,0,78,86,82,75,81,76,82,83,83,76,82,75,32,82,76,82,79,32,82,86,81,87,82,88,83,87,82,86,0,76,89,78,78,79,78,79,79,78,79,78,78,79,76,81,75,84,75,86,76,87,78,87,79,86,81,83,82,82,83,82,84,83,84,32,84,75,86,77,86,80,85,81,83,82,32,82,87,82,88,83,88,83,87,82,87,0,79,86,82,75,82,80,32,83,75,82,80,0,76,88,79,75,79,80,32,80,75,79,80,32,85,75,85,80,32,86,75,85,80,0,77,87,81,75,80,76,80,78,81,79,83,79,84,78,84,76,83,75,81,75,0,77,87,82,74,82,80,32,79,75,85,79,32,85,75,79,79,0,75,90,88,72,77,92,0,77,87,85,72,83,74,81,77,80,80,80,84,81,87,83,90,85,92,32,83,74,82,76,81,80,81,84,82,88,83,90,0,77,87,79,72,81,74,83,77,84,80,84,84,83,87,81,90,79,92,32,81,74,82,76,83,80,83,84,82,88,81,90,0,77,87,80,72,80,92,32,81,72,81,92,32,80,72,85,72,32,80,92,85,92,0,77,87,83,72,83,92,32,84,72,84,92,32,79,72,84,72,32,79,92,84,92,0,76,87,83,72,82,73,81,75,81,77,82,79,82,80,80,82,82,84,82,85,81,87,81,89,82,91,83,92,32,82,73,81,77,32,81,75,82,79,32,82,85,81,89,32,81,87,82,91,0,77,88,81,72,82,73,83,75,83,77,82,79,82,80,84,82,82,84,82,85,83,87,83,89,82,91,81,92,32,82,73,83,77,32,83,75,82,79,32,82,85,83,89,32,83,87,82,91,0,77,87,84,72,80,82,84,92,0,77,87,80,72,84,82,80,92,0,79,85,82,72,82,92,0,77,87,80,72,80,92,32,84,72,84,92,0,73,91,76,82,88,82,0,73,91,82,76,82,88,32,76,82,88,82,0,74,90,82,77,82,88,32,77,82,87,82,32,77,88,87,88,0,74,90,82,77,82,88,32,77,77,87,77,32,77,82,87,82,0,74,90,77,77,87,87,32,87,77,77,87,0,78,86,82,81,81,82,82,83,83,82,82,81,0,73,91,82,76,81,77,82,78,83,77,82,76,32,76,82,88,82,32,82,86,81,87,82,88,83,87,82,86,0,73,91,76,80,88,80,32,76,84,88,84,0,73,91,87,76,77,88,32,76,80,88,80,32,76,84,88,84,0,73,91,76,78,88,78,32,76,82,88,82,32,76,86,88,86,0,74,90,87,76,77,82,87,88,0,74,90,77,76,87,82,77,88,0,74,90,87,75,77,79,87,83,32,77,84,87,84,32,77,88,87,88,0,74,90,77,75,87,79,77,83,32,77,84,87,84,32,77,88,87,88,0,72,91,89,85,87,85,85,84,84,83,82,80,81,79,79,78,78,78,76,79,75,81,75,82,76,84,78,85,79,85,81,84,82,83,84,80,85,79,87,78,89,78,0,74,90,76,84,76,82,77,80,79,80,85,83,87,83,88,82,32,76,82,77,81,79,81,85,84,87,84,88,82,88,80,0,74,90,77,83,82,80,87,83,32,77,83,82,81,87,83,0,78,86,83,75,80,79,32,83,75,84,76,80,79,0,78,86,81,75,84,79,32,81,75,80,76,84,79,0,76,88,78,75,79,77,81,78,83,78,85,77,86,75,32,78,75,79,78,81,79,83,79,85,78,86,75,0,78,86,83,76,82,77,81,76,82,75,83,76,83,78,81,80,0,78,86,83,75,81,77,81,79,82,80,83,79,82,78,81,79,0,78,86,81,76,82,77,83,76,82,75,81,76,81,78,83,80,0,78,86,81,75,83,77,83,79,82,80,81,79,82,78,83,79,0,74,90,87,77,81,77,79,78,78,79,77,81,77,83,78,85,79,86,81,87,87,87,0,74,90,77,77,77,83,78,85,79,86,81,87,83,87,85,86,86,85,87,83,87,77,0,74,90,77,77,83,77,85,78,86,79,87,81,87,83,86,85,85,86,83,87,77,87,0,74,90,77,87,77,81,78,79,79,78,81,77,83,77,85,78,86,79,87,81,87,87,0,74,90,87,77,81,77,79,78,78,79,77,81,77,83,78,85,79,86,81,87,87,87,32,77,82,85,82,0,73,91,84,79,85,80,88,82,85,84,84,85,32,85,80,87,82,85,84,32,76,82,87,82,0,77,87,82,77,82,88,32,79,80,80,79,82,76,84,79,85,80,32,80,79,82,77,84,79,0,73,91,80,79,79,80,76,82,79,84,80,85,32,79,80,77,82,79,84,32,77,82,88,82,0,77,87,82,76,82,87,32,79,84,80,85,82,88,84,85,85,84,32,80,85,82,87,84,85,0,75,89,86,83,85,80,83,79,81,79,79,80,78,81,77,83,77,85,78,87,80,88,82,88,84,87,85,86,86,84,87,81,87,78,86,76,84,75,81,75,80,76,81,76,82,75,32,81,79,79,81,78,83,78,86,80,88,32,82,88,84,86,85,84,86,81,86,78,85,76,84,75,0,74,90,76,75,82,88,32,77,75,82,86,32,88,75,82,88,32,76,75,88,75,32,78,76,87,76,0,71,91,73,79,76,79,82,87,32,75,79,82,88,32,91,70,82,88,0,73,91,88,73,88,74,89,74,89,73,88,72,86,72,84,74,83,76,82,79,81,85,80,89,79,91,32,85,73,84,75,83,79,82,85,81,88,80,90,78,92,76,92,75,91,75,90,76,90,76,91,0,73,91,88,73,88,74,89,74,89,73,88,72,86,72,84,74,83,76,82,79,81,85,80,89,79,91,32,85,73,84,75,83,79,82,85,81,88,80,90,78,92,76,92,75,91,75,90,76,90,76,91,32,81,78,79,79,78,81,78,83,79,85,81,86,83,86,85,85,86,83,86,81,85,79,83,78,81,78,0,72,92,90,82,89,84,87,85,86,85,84,84,83,83,81,80,80,79,78,78,77,78,75,79,74,81,74,82,75,84,77,85,78,85,80,84,81,83,83,80,84,79,86,78,87,78,89,79,90,81,90,82,0,74,90,88,75,76,88,32,79,75,80,76,80,78,79,79,77,79,76,78,76,76,77,75,79,75,83,76,86,76,88,75,32,85,84,84,85,84,87,85,88,87,88,88,87,88,85,87,84,85,84,0,74,91,89,80,88,80,88,81,89,81,89,80,88,79,87,79,86,80,85,84,84,86,83,87,81,88,79,88,77,87,76,86,76,84,77,83,79,82,82,80,83,78,83,76,82,75,80,75,79,76,79,78,80,81,85,87,87,88,88,88,89,87,32,79,88,77,86,77,84,79,82,32,79,78,80,80,86,87,87,88,0,74,91,85,80,83,79,81,79,80,81,80,82,81,84,83,84,85,83,32,85,79,85,83,86,84,88,84,89,82,89,81,88,78,86,76,83,75,82,75,79,76,77,78,76,81,76,82,77,85,79,87,82,88,83,88,86,87,0,75,90,81,72,81,92,32,84,72,84,92,32,87,76,86,76,86,77,87,77,87,76,85,75,80,75,78,76,78,78,79,80,86,83,87,84,32,78,78,79,79,86,82,87,84,87,86,86,87,84,88,81,88,79,87,78,86,78,85,79,85,79,86,78,86,0,75,89,80,75,80,91,32,84,75,84,91,32,77,81,87,81,32,77,85,87,85,0,76,88,84,76,83,76,83,77,84,77,84,76,83,75,81,75,80,76,80,78,81,80,84,82,85,83,32,80,78,81,79,84,81,85,83,85,85,83,87,32,81,80,79,82,79,84,80,86,83,88,84,89,32,79,84,80,85,83,87,84,89,84,91,83,92,81,92,80,91,80,90,81,90,81,91,80,91,0,76,88,82,75,81,76,82,77,83,76,82,75,32,82,77,82,81,32,82,81,81,83,82,86,83,83,82,81,32,82,86,82,92,32,80,79,79,78,78,79,79,80,80,79,84,79,85,78,86,79,85,80,84,79,0,76,88,82,77,83,76,82,75,81,76,82,77,82,81,81,82,83,85,82,86,32,82,81,83,82,81,85,82,86,82,90,81,91,82,92,83,91,82,90,32,80,79,79,78,78,79,79,80,80,79,84,79,85,78,86,79,85,80,84,79,32,80,88,79,87,78,88,79,89,80,88,84,88,85,87,86,88,85,89,84,88,0,76,89,86,75,86,88,32,78,75,86,75,32,81,81,86,81,32,78,88,86,88,0,72,92,81,75,78,76,76,78,75,81,75,83,76,86,78,88,81,89,83,89,86,88,88,86,89,83,89,81,88,78,86,76,83,75,81,75,32,82,81,81,82,82,83,83,82,82,81,0,76,89,81,75,80,76,80,77,81,78,32,84,75,85,76,85,77,84,78,32,82,78,80,79,79,81,79,82,80,84,82,85,83,85,85,84,86,82,86,81,85,79,83,78,82,78,32,82,85,82,89,32,83,85,83,89,32,79,87,86,87,0,76,89,82,75,80,76,79,78,79,79,80,81,82,82,83,82,85,81,86,79,86,78,85,76,83,75,82,75,32,82,82,82,88,32,83,82,83,88,32,79,85,86,85,0,72,92,81,75,78,76,76,78,75,81,75,83,76,86,78,88,81,89,83,89,86,88,88,86,89,83,89,81,88,78,86,76,83,75,81,75,32,82,75,82,89,32,75,82,89,82,0,74,89,82,82,80,81,79,81,77,82,76,84,76,85,77,87,79,88,80,88,82,87,83,85,83,84,82,82,32,87,77,82,82,32,82,77,87,77,87,82,32,82,77,86,78,87,82,0,74,90,76,76,77,75,79,75,81,76,82,78,82,80,81,82,80,83,78,84,32,79,75,80,76,81,78,81,81,80,83,32,86,75,85,88,32,87,75,84,88,32,78,84,88,84,0,74,89,78,75,78,85,32,79,75,78,82,32,78,82,79,80,81,79,83,79,85,80,86,81,86,84,84,86,84,88,85,89,86,89,87,88,32,83,79,85,81,85,84,84,86,32,76,75,79,75,0,76,89,79,78,82,75,82,81,32,86,78,83,75,83,81,32,82,81,80,82,79,84,79,85,80,87,82,88,83,88,85,87,86,85,86,84,85,82,83,81,32,82,84,82,85,83,85,83,84,82,84,0,74,90,82,75,82,89,32,77,75,77,80,78,82,80,83,84,83,86,82,87,80,87,75,32,76,77,77,75,78,77,32,81,77,82,75,83,77,32,86,77,87,75,88,77,32,79,86,85,86,0,74,89,78,75,78,88,32,79,75,79,88,32,76,75,83,75,86,76,87,78,87,79,86,81,83,82,79,82,32,83,75,85,76,86,78,86,79,85,81,83,82,32,76,88,86,88,86,85,85,88,0,76,89,87,75,84,75,81,76,79,78,78,81,78,83,79,86,81,88,84,89,87,89,32,87,75,84,76,82,78,81,81,81,83,82,86,84,88,87,89,0,74,90,82,82,80,81,79,81,77,82,76,84,76,85,77,87,79,88,80,88,82,87,83,85,83,84,82,82,32,83,76,81,81,32,87,77,82,82,32,88,81,83,83,0,75,89,80,77,84,87,32,84,77,80,87,32,77,80,87,84,32,87,80,77,84,0,74,91,79,85,77,85,76,86,76,88,77,89,79,89,80,88,80,86,78,84,77,82,77,79,78,77,79,76,81,75,84,75,86,76,87,77,88,79,88,82,87,84,85,86,85,88,86,89,88,89,89,88,89,86,88,85,86,85,32,78,77,80,76,85,76,87,77,0,74,91,79,79,77,79,76,78,76,76,77,75,79,75,80,76,80,78,78,80,77,82,77,85,78,87,79,88,81,89,84,89,86,88,87,87,88,85,88,82,87,80,85,78,85,76,86,75,88,75,89,76,89,78,88,79,86,79,32,78,87,80,88,85,88,87,87,0,70,94,75,72,75,92,32,76,72,76,92,32,88,72,88,92,32,89,72,89,92,32,72,72,92,72,32,72,92,79,92,32,85,92,92,92,0,72,93,75,72,82,81,74,92,32,74,72,81,81,32,74,72,89,72,90,77,88,72,32,75,91,88,91,32,74,92,89,92,90,87,88,92,0,75,89,86,66,84,68,82,71,80,75,79,80,79,84,80,89,82,93,84,96,86,98,32,84,68,82,72,81,75,80,80,80,84,81,89,82,92,84,96,0,75,89,78,66,80,68,82,71,84,75,85,80,85,84,84,89,82,93,80,96,78,98,32,80,68,82,72,83,75,84,80,84,84,83,89,82,92,80,96,0,75,89,79,66,79,98,32,80,66,80,98,32,79,66,86,66,32,79,98,86,98,0,75,89,84,66,84,98,32,85,66,85,98,32,78,66,85,66,32,78,98,85,98,0,74,89,84,66,81,69,80,72,80,74,81,77,83,79,83,80,79,82,83,84,83,85,81,87,80,90,80,92,81,95,84,98,32,82,68,81,71,81,75,82,78,32,82,86,81,89,81,93,82,96,0,75,90,80,66,83,69,84,72,84,74,83,77,81,79,81,80,85,82,81,84,81,85,83,87,84,90,84,92,83,95,80,98,32,82,68,83,71,83,75,82,78,32,82,86,83,89,83,93,82,96,0,75,89,85,64,82,67,80,70,79,73,79,76,80,79,83,86,84,89,84,92,83,95,82,97,32,82,67,81,69,80,72,80,75,81,78,84,85,85,88,85,91,84,94,82,97,79,100,0,75,89,79,64,82,67,84,70,85,73,85,76,84,79,81,86,80,89,80,92,81,95,82,97,32,82,67,83,69,84,72,84,75,83,78,80,85,79,88,79,91,80,94,82,97,85,100,0,65,88,67,82,71,82,82,96,32,71,83,82,97,32,70,83,82,98,32,88,58,82,98,0,70,94,91,67,90,68,91,69,92,68,92,67,91,66,89,66,87,67,85,69,84,71,83,74,82,78,80,90,79,94,78,96,32,86,68,85,70,84,74,82,86,81,90,80,93,79,95,77,97,75,98,73,98,72,97,72,96,73,95,74,96,73,97,0,72,92,82,70,75,91,32,82,70,89,91,32,82,73,88,91,32,77,85,86,85,32,73,91,79,91,32,85,91,91,91,0,71,93,76,70,76,91,32,77,70,77,91,32,73,70,85,70,88,71,89,72,90,74,90,76,89,78,88,79,85,80,32,85,70,87,71,88,72,89,74,89,76,88,78,87,79,85,80,32,77,80,85,80,88,81,89,82,90,84,90,87,89,89,88,90,85,91,73,91,32,85,80,87,81,88,82,89,84,89,87,88,89,87,90,85,91,0,71,92,88,73,89,76,89,70,88,73,86,71,83,70,81,70,78,71,76,73,75,75,74,78,74,83,75,86,76,88,78,90,81,91,83,91,86,90,88,88,89,86,32,81,70,79,71,77,73,76,75,75,78,75,83,76,86,77,88,79,90,81,91,0,71,93,76,70,76,91,32,77,70,77,91,32,73,70,83,70,86,71,88,73,89,75,90,78,90,83,89,86,88,88,86,90,83,91,73,91,32,83,70,85,71,87,73,88,75,89,78,89,83,88,86,87,88,85,90,83,91,0,71,92,76,70,76,91,32,77,70,77,91,32,83,76,83,84,32,73,70,89,70,89,76,88,70,32,77,80,83,80,32,73,91,89,91,89,85,88,91,0,71,91,76,70,76,91,32,77,70,77,91,32,83,76,83,84,32,73,70,89,70,89,76,88,70,32,77,80,83,80,32,73,91,80,91,0,71,94,88,73,89,76,89,70,88,73,86,71,83,70,81,70,78,71,76,73,75,75,74,78,74,83,75,86,76,88,78,90,81,91,83,91,86,90,88,88,32,81,70,79,71,77,73,76,75,75,78,75,83,76,86,77,88,79,90,81,91,32,88,83,88,91,32,89,83,89,91,32,85,83,92,83,0,70,94,75,70,75,91,32,76,70,76,91,32,88,70,88,91,32,89,70,89,91,32,72,70,79,70,32,85,70,92,70,32,76,80,88,80,32,72,91,79,91,32,85,91,92,91,0,77,88,82,70,82,91,32,83,70,83,91,32,79,70,86,70,32,79,91,86,91,0,75,90,85,70,85,87,84,90,82,91,80,91,78,90,77,88,77,86,78,85,79,86,78,87,32,84,70,84,87,83,90,82,91,32,81,70,88,70,0,70,92,75,70,75,91,32,76,70,76,91,32,89,70,76,83,32,81,79,89,91,32,80,79,88,91,32,72,70,79,70,32,85,70,91,70,32,72,91,79,91,32,85,91,91,91,0,73,91,78,70,78,91,32,79,70,79,91,32,75,70,82,70,32,75,91,90,91,90,85,89,91,0,70,95,75,70,75,91,32,76,70,82,88,32,75,70,82,91,32,89,70,82,91,32,89,70,89,91,32,90,70,90,91,32,72,70,76,70,32,89,70,93,70,32,72,91,78,91,32,86,91,93,91,0,71,94,76,70,76,91,32,77,70,89,89,32,77,72,89,91,32,89,70,89,91,32,73,70,77,70,32,86,70,92,70,32,73,91,79,91,0,71,93,81,70,78,71,76,73,75,75,74,79,74,82,75,86,76,88,78,90,81,91,83,91,86,90,88,88,89,86,90,82,90,79,89,75,88,73,86,71,83,70,81,70,32,81,70,79,71,77,73,76,75,75,79,75,82,76,86,77,88,79,90,81,91,32,83,91,85,90,87,88,88,86,89,82,89,79,88,75,87,73,85,71,83,70,0,71,93,76,70,76,91,32,77,70,77,91,32,73,70,85,70,88,71,89,72,90,74,90,77,89,79,88,80,85,81,77,81,32,85,70,87,71,88,72,89,74,89,77,88,79,87,80,85,81,32,73,91,80,91,0,71,93,81,70,78,71,76,73,75,75,74,79,74,82,75,86,76,88,78,90,81,91,83,91,86,90,88,88,89,86,90,82,90,79,89,75,88,73,86,71,83,70,81,70,32,81,70,79,71,77,73,76,75,75,79,75,82,76,86,77,88,79,90,81,91,32,83,91,85,90,87,88,88,86,89,82,89,79,88,75,87,73,85,71,83,70,32,78,89,78,88,79,86,81,85,82,85,84,86,85,88,86,95,87,96,89,96,90,94,90,93,32,85,88,86,92,87,94,88,95,89,95,90,94,0,71,93,76,70,76,91,32,77,70,77,91,32,73,70,85,70,88,71,89,72,90,74,90,76,89,78,88,79,85,80,77,80,32,85,70,87,71,88,72,89,74,89,76,88,78,87,79,85,80,32,73,91,80,91,32,82,80,84,81,85,82,88,89,89,90,90,90,91,89,32,84,81,85,83,87,90,88,91,90,91,91,89,91,88,0,72,92,88,73,89,70,89,76,88,73,86,71,83,70,80,70,77,71,75,73,75,75,76,77,77,78,79,79,85,81,87,82,89,84,32,75,75,77,77,79,78,85,80,87,81,88,82,89,84,89,88,87,90,84,91,81,91,78,90,76,88,75,85,75,91,76,88,0,73,92,82,70,82,91,32,83,70,83,91,32,76,70,75,76,75,70,90,70,90,76,89,70,32,79,91,86,91,0,70,94,75,70,75,85,76,88,78,90,81,91,83,91,86,90,88,88,89,85,89,70,32,76,70,76,85,77,88,79,90,81,91,32,72,70,79,70,32,86,70,92,70,0,72,92,75,70,82,91,32,76,70,82,88,32,89,70,82,91,32,73,70,79,70,32,85,70,91,70,0,70,94,74,70,78,91,32,75,70,78,86,32,82,70,78,91,32,82,70,86,91,32,83,70,86,86,32,90,70,86,91,32,71,70,78,70,32,87,70,93,70,0,72,92,75,70,88,91,32,76,70,89,91,32,89,70,75,91,32,73,70,79,70,32,85,70,91,70,32,73,91,79,91,32,85,91,91,91,0,72,93,75,70,82,81,82,91,32,76,70,83,81,83,91,32,90,70,83,81,32,73,70,79,70,32,86,70,92,70,32,79,91,86,91,0,72,92,88,70,75,91,32,89,70,76,91,32,76,70,75,76,75,70,89,70,32,75,91,89,91,89,85,88,91,0,73,91,78,70,78,91,32,79,70,79,91,32,75,70,90,70,90,76,89,70,32,75,91,82,91,0,72,92,82,70,74,91,32,82,70,90,91,32,82,73,89,91,32,75,90,89,90,32,74,91,90,91,0,71,93,81,70,78,71,76,73,75,75,74,79,74,82,75,86,76,88,78,90,81,91,83,91,86,90,88,88,89,86,90,82,90,79,89,75,88,73,86,71,83,70,81,70,32,81,70,79,71,77,73,76,75,75,79,75,82,76,86,77,88,79,90,81,91,32,83,91,85,90,87,88,88,86,89,82,89,79,88,75,87,73,85,71,83,70,32,79,77,79,84,32,85,77,85,84,32,79,80,85,80,32,79,81,85,81,0,72,92,82,70,75,91,32,82,70,89,91,32,82,73,88,91,32,73,91,79,91,32,85,91,91,91,0,71,93,75,69,74,74,32,90,69,89,74,32,79,78,78,83,32,86,78,85,83,32,75,87,74,92,32,90,87,89,92,32,75,71,89,71,32,75,72,89,72,32,79,80,85,80,32,79,81,85,81,32,75,89,89,89,32,75,90,89,90,0,70,94,75,70,75,91,32,76,70,76,91,32,88,70,88,91,32,89,70,89,91,32,72,70,92,70,32,72,91,79,91,32,85,91,92,91,0,72,93,75,70,82,80,74,91,32,74,70,81,80,32,74,70,89,70,90,76,88,70,32,75,90,88,90,32,74,91,89,91,90,85,88,91,0,73,92,75,75,75,73,76,71,77,70,79,70,80,71,81,73,82,77,82,91,32,75,73,77,71,79,71,81,73,32,90,75],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+286721);allocate([90,73,89,71,88,70,86,70,85,71,84,73,83,77,83,91,32,90,73,88,71,86,71,84,73,32,79,91,86,91,0,72,93,82,70,82,91,32,83,70,83,91,32,80,75,77,76,76,77,75,79,75,82,76,84,77,85,80,86,85,86,88,85,89,84,90,82,90,79,89,77,88,76,85,75,80,75,32,80,75,78,76,77,77,76,79,76,82,77,84,78,85,80,86,32,85,86,87,85,88,84,89,82,89,79,88,77,87,76,85,75,32,79,70,86,70,32,79,91,86,91,0,71,94,82,70,82,91,32,83,70,83,91,32,73,77,74,76,76,77,77,81,78,83,79,84,81,85,32,74,76,75,77,76,81,77,83,78,84,81,85,84,85,87,84,88,83,89,81,90,77,91,76,32,84,85,86,84,87,83,88,81,89,77,91,76,92,77,32,79,70,86,70,32,79,91,86,91,0,71,93,74,88,75,91,79,91,77,87,75,83,74,80,74,76,75,73,77,71,80,70,84,70,87,71,89,73,90,76,90,80,89,83,87,87,85,91,89,91,90,88,32,77,87,76,84,75,80,75,76,76,73,78,71,80,70,32,84,70,86,71,88,73,89,76,89,80,88,84,87,87,32,75,90,78,90,32,86,90,89,90,0,72,92,85,70,72,91,32,85,70,86,91,32,84,72,85,91,32,76,85,85,85,32,70,91,76,91,32,82,91,88,91,0,70,94,79,70,73,91,32,80,70,74,91,32,76,70,87,70,90,71,91,73,91,75,90,78,89,79,86,80,32,87,70,89,71,90,73,90,75,89,78,88,79,86,80,32,77,80,86,80,88,81,89,83,89,85,88,88,86,90,82,91,70,91,32,86,80,87,81,88,83,88,85,87,88,85,90,82,91,0,72,93,90,72,91,72,92,70,91,76,91,74,90,72,89,71,87,70,84,70,81,71,79,73,77,76,76,79,75,83,75,86,76,89,77,90,80,91,83,91,85,90,87,88,88,86,32,84,70,82,71,80,73,78,76,77,79,76,83,76,86,77,89,78,90,80,91,0,70,93,79,70,73,91,32,80,70,74,91,32,76,70,85,70,88,71,89,72,90,75,90,79,89,83,87,87,85,89,83,90,79,91,70,91,32,85,70,87,71,88,72,89,75,89,79,88,83,86,87,84,89,82,90,79,91,0,70,93,79,70,73,91,32,80,70,74,91,32,84,76,82,84,32,76,70,91,70,90,76,90,70,32,77,80,83,80,32,70,91,85,91,87,86,84,91,0,70,92,79,70,73,91,32,80,70,74,91,32,84,76,82,84,32,76,70,91,70,90,76,90,70,32,77,80,83,80,32,70,91,77,91,0,72,94,90,72,91,72,92,70,91,76,91,74,90,72,89,71,87,70,84,70,81,71,79,73,77,76,76,79,75,83,75,86,76,89,77,90,80,91,82,91,85,90,87,88,89,84,32,84,70,82,71,80,73,78,76,77,79,76,83,76,86,77,89,78,90,80,91,32,82,91,84,90,86,88,88,84,32,85,84,92,84,0,69,95,78,70,72,91,32,79,70,73,91,32,91,70,85,91,32,92,70,86,91,32,75,70,82,70,32,88,70,95,70,32,76,80,88,80,32,69,91,76,91,32,82,91,89,91,0,76,89,85,70,79,91,32,86,70,80,91,32,82,70,89,70,32,76,91,83,91,0,73,91,88,70,83,87,82,89,81,90,79,91,77,91,75,90,74,88,74,86,75,85,76,86,75,87,32,87,70,82,87,81,89,79,91,32,84,70,91,70,0,70,93,79,70,73,91,32,80,70,74,91,32,93,70,76,83,32,83,79,87,91,32,82,79,86,91,32,76,70,83,70,32,89,70,95,70,32,70,91,77,91,32,83,91,89,91,0,72,92,81,70,75,91,32,82,70,76,91,32,78,70,85,70,32,72,91,87,91,89,85,86,91,0,69,96,78,70,72,91,32,78,70,79,91,32,79,70,80,89,32,92,70,79,91,32,92,70,86,91,32,93,70,87,91,32,75,70,79,70,32,92,70,96,70,32,69,91,75,91,32,83,91,90,91,0,70,95,79,70,73,91,32,79,70,86,88,32,79,73,86,91,32,92,70,86,91,32,76,70,79,70,32,89,70,95,70,32,70,91,76,91,0,71,93,83,70,80,71,78,73,76,76,75,79,74,83,74,86,75,89,76,90,78,91,81,91,84,90,86,88,88,85,89,82,90,78,90,75,89,72,88,71,86,70,83,70,32,83,70,81,71,79,73,77,76,76,79,75,83,75,86,76,89,78,91,32,81,91,83,90,85,88,87,85,88,82,89,78,89,75,88,72,86,70,0,70,93,79,70,73,91,32,80,70,74,91,32,76,70,88,70,91,71,92,73,92,75,91,78,89,80,85,81,77,81,32,88,70,90,71,91,73,91,75,90,78,88,80,85,81,32,70,91,77,91,0,71,93,83,70,80,71,78,73,76,76,75,79,74,83,74,86,75,89,76,90,78,91,81,91,84,90,86,88,88,85,89,82,90,78,90,75,89,72,88,71,86,70,83,70,32,83,70,81,71,79,73,77,76,76,79,75,83,75,86,76,89,78,91,32,81,91,83,90,85,88,87,85,88,82,89,78,89,75,88,72,86,70,32,76,89,76,88,77,86,79,85,80,85,82,86,83,88,83,95,84,96,86,96,87,94,87,93,32,83,88,84,94,85,95,86,95,87,94,0,70,94,79,70,73,91,32,80,70,74,91,32,76,70,87,70,90,71,91,73,91,75,90,78,89,79,86,80,77,80,32,87,70,89,71,90,73,90,75,89,78,88,79,86,80,32,82,80,84,81,85,82,86,90,87,91,89,91,90,89,90,88,32,85,82,87,89,88,90,89,90,90,89,32,70,91,77,91,0,71,94,90,72,91,72,92,70,91,76,91,74,90,72,89,71,86,70,82,70,79,71,77,73,77,75,78,77,79,78,86,82,88,84,32,77,75,79,77,86,81,87,82,88,84,88,87,87,89,86,90,83,91,79,91,76,90,75,89,74,87,74,85,73,91,74,89,75,89,0,72,93,85,70,79,91,32,86,70,80,91,32,79,70,76,76,78,70,93,70,92,76,92,70,32,76,91,83,91,0,70,95,78,70,75,81,74,85,74,88,75,90,78,91,82,91,85,90,87,88,88,85,92,70,32,79,70,76,81,75,85,75,88,76,90,78,91,32,75,70,82,70,32,89,70,95,70,0,72,92,78,70,79,91,32,79,70,80,89,32,92,70,79,91,32,76,70,82,70,32,88,70,94,70,0,69,95,77,70,75,91,32,78,70,76,89,32,85,70,75,91,32,85,70,83,91,32,86,70,84,89,32,93,70,83,91,32,74,70,81,70,32,90,70,96,70,0,71,93,78,70,85,91,32,79,70,86,91,32,92,70,72,91,32,76,70,82,70,32,88,70,94,70,32,70,91,76,91,32,82,91,88,91,0,72,93,78,70,82,80,79,91,32,79,70,83,80,80,91,32,93,70,83,80,32,76,70,82,70,32,89,70,95,70,32,76,91,83,91,0,71,93,91,70,72,91,32,92,70,73,91,32,79,70,76,76,78,70,92,70,32,72,91,86,91,88,85,85,91,0,72,92,75,73,76,75,88,87,89,89,89,91,32,76,76,88,88,32,75,73,75,75,76,77,88,89,89,91,32,80,80,76,84,75,86,75,88,76,90,75,91,32,75,86,77,90,32,76,84,76,86,77,88,77,90,75,91,32,83,83,88,78,32,86,73,86,76,87,78,89,78,89,76,87,75,86,73,32,86,73,87,76,89,78,0,72,92,81,73,75,91,32,83,73,89,91,32,82,73,88,91,32,77,85,86,85,32,73,91,79,91,32,85,91,91,91,32,81,66,79,67,78,69,78,71,79,73,81,74,83,74,85,73,86,71,86,69,85,67,83,66,81,66,0,71,93,73,66,91,98,0,70,94,82,74,73,90,32,82,74,91,90,0,73,93,78,79,78,80,77,80,77,79,78,78,80,77,84,77,86,78,87,79,88,81,88,88,89,90,90,91,32,87,79,87,88,88,90,90,91,91,91,32,87,81,86,82,80,83,77,84,76,86,76,88,77,90,80,91,83,91,85,90,87,88,32,80,83,78,84,77,86,77,88,78,90,80,91,0,71,92,76,70,76,91,32,77,70,77,91,32,77,80,79,78,81,77,83,77,86,78,88,80,89,83,89,85,88,88,86,90,83,91,81,91,79,90,77,88,32,83,77,85,78,87,80,88,83,88,85,87,88,85,90,83,91,32,73,70,77,70,0,72,91,87,80,86,81,87,82,88,81,88,80,86,78,84,77,81,77,78,78,76,80,75,83,75,85,76,88,78,90,81,91,83,91,86,90,88,88,32,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,0,72,93,87,70,87,91,32,88,70,88,91,32,87,80,85,78,83,77,81,77,78,78,76,80,75,83,75,85,76,88,78,90,81,91,83,91,85,90,87,88,32,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,32,84,70,88,70,32,87,91,91,91,0,72,91,76,83,88,83,88,81,87,79,86,78,84,77,81,77,78,78,76,80,75,83,75,85,76,88,78,90,81,91,83,91,86,90,88,88,32,87,83,87,80,86,78,32,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,0,75,88,85,71,84,72,85,73,86,72,86,71,85,70,83,70,81,71,80,73,80,91,32,83,70,82,71,81,73,81,91,32,77,77,85,77,32,77,91,84,91,0,73,92,81,77,79,78,78,79,77,81,77,83,78,85,79,86,81,87,83,87,85,86,86,85,87,83,87,81,86,79,85,78,83,77,81,77,32,79,78,78,80,78,84,79,86,32,85,86,86,84,86,80,85,78,32,86,79,87,78,89,77,89,78,87,78,32,78,85,77,86,76,88,76,89,77,91,80,92,85,92,88,93,89,94,32,76,89,77,90,80,91,85,91,88,92,89,94,89,95,88,97,85,98,79,98,76,97,75,95,75,94,76,92,79,91,0,71,93,76,70,76,91,32,77,70,77,91,32,77,80,79,78,82,77,84,77,87,78,88,80,88,91,32,84,77,86,78,87,80,87,91,32,73,70,77,70,32,73,91,80,91,32,84,91,91,91,0,77,88,82,70,81,71,82,72,83,71,82,70,32,82,77,82,91,32,83,77,83,91,32,79,77,83,77,32,79,91,86,91,0,77,88,83,70,82,71,83,72,84,71,83,70,32,84,77,84,95,83,97,81,98,79,98,78,97,78,96,79,95,80,96,79,97,32,83,77,83,95,82,97,81,98,32,80,77,84,77,0,71,92,76,70,76,91,32,77,70,77,91,32,87,77,77,87,32,82,83,88,91,32,81,83,87,91,32,73,70,77,70,32,84,77,90,77,32,73,91,80,91,32,84,91,90,91,0,77,88,82,70,82,91,32,83,70,83,91,32,79,70,83,70,32,79,91,86,91,0,66,99,71,77,71,91,32,72,77,72,91,32,72,80,74,78,77,77,79,77,82,78,83,80,83,91,32,79,77,81,78,82,80,82,91,32,83,80,85,78,88,77,90,77,93,78,94,80,94,91,32,90,77,92,78,93,80,93,91,32,68,77,72,77,32,68,91,75,91,32,79,91,86,91,32,90,91,97,91,0,71,93,76,77,76,91,32,77,77,77,91,32,77,80,79,78,82,77,84,77,87,78,88,80,88,91,32,84,77,86,78,87,80,87,91,32,73,77,77,77,32,73,91,80,91,32,84,91,91,91,0,72,92,81,77,78,78,76,80,75,83,75,85,76,88,78,90,81,91,83,91,86,90,88,88,89,85,89,83,88,80,86,78,83,77,81,77,32,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,32,83,91,85,90,87,88,88,85,88,83,87,80,85,78,83,77,0,71,92,76,77,76,98,32,77,77,77,98,32,77,80,79,78,81,77,83,77,86,78,88,80,89,83,89,85,88,88,86,90,83,91,81,91,79,90,77,88,32,83,77,85,78,87,80,88,83,88,85,87,88,85,90,83,91,32,73,77,77,77,32,73,98,80,98,0,72,92,87,77,87,98,32,88,77,88,98,32,87,80,85,78,83,77,81,77,78,78,76,80,75,83,75,85,76,88,78,90,81,91,83,91,85,90,87,88,32,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,32,84,98,91,98,0,73,90,78,77,78,91,32,79,77,79,91,32,79,83,80,80,82,78,84,77,87,77,88,78,88,79,87,80,86,79,87,78,32,75,77,79,77,32,75,91,82,91,0,74,91,87,79,88,77,88,81,87,79,86,78,84,77,80,77,78,78,77,79,77,81,78,82,80,83,85,85,87,86,88,87,32,77,80,78,81,80,82,85,84,87,85,88,86,88,89,87,90,85,91,81,91,79,90,78,89,77,87,77,91,78,89,0,75,90,80,70,80,87,81,90,83,91,85,91,87,90,88,88,32,81,70,81,87,82,90,83,91,32,77,77,85,77,0,71,93,76,77,76,88,77,90,80,91,82,91,85,90,87,88,32,77,77,77,88,78,90,80,91,32,87,77,87,91,32,88,77,88,91,32,73,77,77,77,32,84,77,88,77,32,87,91,91,91,0,73,91,76,77,82,91,32,77,77,82,89,32,88,77,82,91,32,74,77,80,77,32,84,77,90,77,0,70,94,74,77,78,91,32,75,77,78,88,32,82,77,78,91,32,82,77,86,91,32,83,77,86,88,32,90,77,86,91,32,71,77,78,77,32,87,77,93,77,0,72,92,76,77,87,91,32,77,77,88,91,32,88,77,76,91,32,74,77,80,77,32,84,77,90,77,32,74,91,80,91,32,84,91,90,91,0,72,91,76,77,82,91,32,77,77,82,89,32,88,77,82,91,80,95,78,97,76,98,75,98,74,97,75,96,76,97,32,74,77,80,77,32,84,77,90,77,0,73,91,87,77,76,91,32,88,77,77,91,32,77,77,76,81,76,77,88,77,32,76,91,88,91,88,87,87,91,0,71,94,81,77,78,78,76,80,75,82,74,85,74,88,75,90,78,91,80,91,82,90,85,87,87,84,89,80,90,77,32,81,77,79,78,77,80,76,82,75,85,75,88,76,90,78,91,32,81,77,83,77,85,78,86,80,88,88,89,90,90,91,32,83,77,84,78,85,80,87,88,88,90,90,91,91,91,0,71,92,84,70,81,71,79,73,77,77,76,80,75,84,74,90,73,98,32,84,70,82,71,80,73,78,77,77,80,76,84,75,90,74,98,32,84,70,86,70,88,71,89,72,89,75,88,77,87,78,84,79,80,79,32,86,70,88,72,88,75,87,77,86,78,84,79,32,80,79,84,80,86,82,87,84,87,87,86,89,85,90,82,91,80,91,78,90,77,89,76,86,32,80,79,83,80,85,82,86,84,86,87,85,89,84,90,82,91,0,72,92,73,80,75,78,77,77,79,77,81,78,82,79,83,82,83,86,82,90,79,98,32,74,79,76,78,80,78,82,79,32,90,77,89,80,88,82,83,89,80,94,78,98,32,89,77,88,80,87,82,83,89,0,73,92,86,78,84,77,82,77,79,78,77,81,76,84,76,87,77,89,78,90,80,91,82,91,85,90,87,87,88,84,88,81,87,79,83,74,82,72,82,70,83,69,85,69,87,70,89,72,32,82,77,80,78,78,81,77,84,77,88,78,90,32,82,91,84,90,86,87,87,84,87,80,86,78,84,75,83,73,83,71,84,70,86,70,89,72,0,73,91,88,80,86,78,84,77,80,77,78,78,78,80,80,82,83,83,32,80,77,79,78,79,80,81,82,83,83,32,83,83,78,84,76,86,76,88,77,90,80,91,83,91,85,90,87,88,32,83,83,79,84,77,86,77,88,78,90,80,91,0,73,91,84,70,82,71,81,72,81,73,82,74,85,75,90,75,90,74,87,75,83,77,80,79,77,82,76,85,76,87,77,89,80,91,83,93,84,95,84,97,83,98,81,98,80,97,32,85,76,81,79,78,82,77,85,77,87,78,89,80,91,0,71,93,72,81,73,79,75,77,78,77,79,78,79,80,78,84,76,91,32,77,77,78,78,78,80,77,84,75,91,32,78,84,80,80,82,78,84,77,86,77,88,78,89,79,89,82,88,87,85,98,32,86,77,88,79,88,82,87,87,84,98,0,70,93,71,81,72,79,74,77,77,77,78,78,78,80,77,85,77,88,78,90,79,91,32,76,77,77,78,77,80,76,85,76,88,77,90,79,91,81,91,83,90,85,88,87,85,88,82,89,77,89,73,88,71,86,70,84,70,82,72,82,74,83,77,85,80,87,82,90,84,32,83,90,85,87,86,85,87,82,88,77,88,73,87,71,86,70,0,76,88,82,77,80,84,79,88,79,90,80,91,83,91,85,89,86,87,32,83,77,81,84,80,88,80,90,81,91,0,72,92,78,77,74,91,32,79,77,75,91,32,88,77,89,78,90,78,89,77,87,77,85,78,81,82,79,83,77,83,32,79,83,81,84,83,90,84,91,32,79,83,80,84,82,90,83,91,85,91,87,90,89,87,0,72,92,75,70,77,70,79,71,80,72,81,74,87,88,88,90,89,91,32,77,70,79,72,80,74,86,88,87,90,89,91,90,91,32,82,77,74,91,32,82,77,75,91,0,70,93,77,77,71,98,32,78,77,72,98,32,77,80,76,86,76,89,78,91,80,91,82,90,84,88,86,85,32,88,77,85,88,85,90,86,91,89,91,91,89,92,87,32,89,77,86,88,86,90,87,91,0,72,92,78,77,76,91,32,79,77,78,83,77,88,76,91,32,89,77,88,81,86,85,32,90,77,89,80,88,82,86,85,84,87,81,89,79,90,76,91,32,75,77,79,77,0,73,90,84,70,82,71,81,72,81,73,82,74,85,75,88,75,32,85,75,81,76,79,77,78,79,78,81,80,83,83,84,86,84,32,85,75,82,76,80,77,79,79,79,81,81,83,83,84,32,83,84,79,85,77,86,76,88,76,90,78,92,83,94,84,95,84,97,82,98,80,98,32,83,84,80,85,78,86,77,88,77,90,79,92,83,94,0,73,91,82,77,79,78,77,81,76,84,76,87,77,89,78,90,80,91,82,91,85,90,87,87,88,84,88,81,87,79,86,78,84,77,82,77,32,82,77,80,78,78,81,77,84,77,88,78,90,32,82,91,84,90,86,87,87,84,87,80,86,78,0,71,93,80,78,76,91,32,80,78,77,91,32,86,78,86,91,32,86,78,87,91,32,73,80,75,78,78,77,91,77,32,73,80,75,79,78,78,91,78,0,72,91,76,86,77,89,78,90,80,91,82,91,85,90,87,87,88,84,88,81,87,79,86,78,84,77,82,77,79,78,77,81,76,84,72,98,32,82,91,84,90,86,87,87,84,87,80,86,78,32,82,77,80,78,78,81,77,84,73,98,0,72,93,91,77,81,77,78,78,76,81,75,84,75,87,76,89,77,90,79,91,81,91,84,90,86,87,87,84,87,81,86,79,85,78,83,77,32,81,77,79,78,77,81,76,84,76,88,77,90,32,81,91,83,90,85,87,86,84,86,80,85,78,32,85,78,91,78,0,72,92,83,78,80,91,32,83,78,81,91,32,74,80,76,78,79,77,90,77,32,74,80,76,79,79,78,90,78,0,72,92,73,81,74,79,76,77,79,77,80,78,80,80,78,86,78,89,80,91,32,78,77,79,78,79,80,77,86,77,89,78,90,80,91,81,91,84,90,86,88,88,85,89,82,89,79,88,77,87,78,88,79,89,82,32,88,85,89,79,0,71,93,79,78,77,79,75,81,74,84,74,87,75,89,76,90,78,91,81,91,84,90,87,88,89,85,90,82,90,79,88,77,86,77,84,79,82,83,80,88,77,98,32,74,87,76,89,78,90,81,90,84,89,87,87,89,85,32,90,79,88,78,86,78,84,80,82,83,80,89,78,98,0,73,91,75,77,77,77,79,78,80,80,85,95,86,97,87,98,32,77,77,78,78,79,80,84,95,85,97,87,98,89,98,32,90,77,89,79,87,82,77,93,75,96,74,98,0,70,93,85,70,79,98,32,86,70,78,98,32,71,81,72,79,74,77,77,77,78,78,78,80,77,85,77,88,79,90,82,90,84,89,87,86,89,83,32,76,77,77,78,77,80,76,85,76,88,77,90,79,91,82,91,84,90,86,88,88,85,89,83,91,77,0,70,93,74,81,76,79,79,78,78,77,76,78,74,81,73,84,73,87,74,90,75,91,77,91,79,90,81,87,82,84,32,73,87,74,89,75,90,77,90,79,89,81,87,32,81,84,81,87,82,90,83,91,85,91,87,90,89,87,90,84,90,81,89,78,88,77,87,78,89,79,90,81,32,81,87,82,89,83,90,85,90,87,89,89,87,0,72,93,88,77,86,84,85,88,85,90,86,91,89,91,91,89,92,87,32,89,77,87,84,86,88,86,90,87,91,32,86,84,86,81,85,78,83,77,81,77,78,78,76,81,75,84,75,87,76,89,77,90,79,91,81,91,83,90,85,87,86,84,32,81,77,79,78,77,81,76,84,76,88,77,90,0,72,91,80,70,76,83,76,86,77,89,78,90,32,81,70,77,83,32,77,83,78,80,80,78,82,77,84,77,86,78,87,79,88,81,88,84,87,87,85,90,82,91,80,91,78,90,77,87,77,83,32,86,78,87,80,87,84,86,87,84,90,82,91,32,77,70,81,70,0,73,91,87,80,87,81,88,81,88,80,87,78,85,77,82,77,79,78,77,81,76,84,76,87,77,89,78,90,80,91,82,91,85,90,87,87,32,82,77,80,78,78,81,77,84,77,88,78,90,0,72,93,90,70,86,84,85,88,85,90,86,91,89,91,91,89,92,87,32,91,70,87,84,86,88,86,90,87,91,32,86,84,86,81,85,78,83,77,81,77,78,78,76,81,75,84,75,87,76,89,77,90,79,91,81,91,83,90,85,87,86,84,32,81,77,79,78,77,81,76,84,76,88,77,90,32,87,70,91,70,0,73,91,77,86,81,85,84,84,87,82,88,80,87,78,85,77,82,77,79,78,77,81,76,84,76,87,77,89,78,90,80,91,82,91,85,90,87,88,32,82,77,80,78,78,81,77,84,77,88,78,90,0,75,90,90,71,89,72,90,73,91,72,91,71,90,70,88,70,86,71,85,72,84,74,83,77,80,91,79,95,78,97,32,88,70,86,72,85,74,84,78,82,87,81,91,80,94,79,96,78,97,76,98,74,98,73,97,73,96,74,95,75,96,74,97,32,79,77,89,77,0,72,92,89,77,85,91,84,94,82,97,79,98,76,98,74,97,73,96,73,95,74,94,75,95,74,96,32,88,77,84,91,83,94,81,97,79,98,32,86,84,86,81,85,78,83,77,81,77,78,78,76,81,75,84,75,87,76,89,77,90,79,91,81,91,83,90,85,87,86,84,32,81,77,79,78,77,81,76,84,76,88,77,90,0,72,93,80,70,74,91,32,81,70,75,91,32,77,84,79,80,81,78,83,77,85,77,87,78,88,79,88,81,86,87,86,90,87,91,32,85,77,87,79,87,81,85,87,85,90,86,91,89,91,91,89,92,87,32,77,70,81,70,0,76,89,85,70,84,71,85,72,86,71,85,70,32,77,81,78,79,80,77,83,77,84,78,84,81,82,87,82,90,83,91,32,82,77,83,78,83,81,81,87,81,90,82,91,85,91,87,89,88,87,0,76,89,86,70,85,71,86,72,87,71,86,70,32,78,81,79,79,81,77,84,77,85,78,85,81,82,91,81,94,80,96,79,97,77,98,75,98,74,97,74,96,75,95,76,96,75,97,32,83,77,84,78,84,81,81,91,80,94,79,96,77,98,0,72,92,80,70,74,91,32,81,70,75,91,32,88,78,87,79,88,80,89,79,89,78,88,77,87,77,85,78,81,82,79,83,77,83,32,79,83,81,84,83,90,84,91,32,79,83,80,84,82,90,83,91,85,91,87,90,89,87,32,77,70,81,70,0,77,89,85,70,81,84,80,88,80,90,81,91,84,91,86,89,87,87,32,86,70,82,84,81,88,81,90,82,91,32,82,70,86,70,0,65,98,66,81,67,79,69,77,72,77,73,78,73,80,72,84,70,91,32,71,77,72,78,72,80,71,84,69,91,32,72,84,74,80,76,78,78,77,80,77,82,78,83,79,83,81,80,91,32,80,77,82,79,82,81,79,91,32,82,84,84,80,86,78,88,77,90,77,92,78,93,79,93,81,91,87,91,90,92,91,32,90,77,92,79,92,81,90,87,90,90,91,91,94,91,96,89,97,87,0,70,93,71,81,72,79,74,77,77,77,78,78,78,80,77,84,75,91,32,76,77,77,78,77,80,76,84,74,91,32,77,84,79,80,81,78,83,77,85,77,87,78,88,79,88,81,86,87,86,90,87,91,32,85,77,87,79,87,81,85,87,85,90,86,91,89,91,91,89,92,87,0,71,92,72,81,73,79,75,77,78,77,79,78,79,80,78,84,74,98,32,77,77,78,78,78,80,77,84,73,98,32,78,84,79,81,81,78,83,77,85,77,87,78,88,79,89,81,89,84,88,87,86,90,83,91,81,91,79,90,78,87,78,84,32,87,78,88,80,88,84,87,87,85,90,83,91,32,70,98,77,98,0,72,92,88,77,82,98,32,89,77,83,98,32,86,84,86,81,85,78,83,77,81,77,78,78,76,81,75,84,75,87,76,89,77,90,79,91,81,91,83,90,85,87,86,84,32,81,77,79,78,77,81,76,84,76,88,77,90,32,79,98,86,98,0,73,90,74,81,75,79,77,77,80,77,81,78,81,80,80,84,78,91,32,79,77,80,78,80,80,79,84,77,91,32,80,84,82,80,84,78,86,77,88,77,89,78,89,79,88,80,87,79,88,78,0,74,91,88,79,88,80,89,80,89,79,88,78,85,77,82,77,79,78,78,79,78,81,79,82,86,86,87,87,32,78,80,79,81,86,85,87,86,87,89,86,90,83,91,80,91,77,90,76,89,76,88,77,88,77,89,0,75,89,84,70,80,84,79,88,79,90,80,91,83,91,85,89,86,87,32,85,70,81,84,80,88,80,90,81,91,32,78,77,87,77,0,70,93,71,81,72,79,74,77,77,77,78,78,78,81,76,87,76,89,78,91,32,76,77,77,78,77,81,75,87,75,89,76,90,78,91,80,91,82,90,84,88,86,84,32,88,77,86,84,85,88,85,90,86,91,89,91,91,89,92,87,32,89,77,87,84,86,88,86,90,87,91,0,72,92,73,81,74,79,76,77,79,77,80,78,80,81,78,87,78,89,80,91,32,78,77,79,78,79,81,77,87,77,89,78,90,80,91,81,91,84,90,86,88,88,85,89,81,89,77,88,77,89,79,0,67,96,68,81,69,79,71,77,74,77,75,78,75,81,73,87,73,89,75,91,32,73,77,74,78,74,81,72,87,72,89,73,90,75,91,77,91,79,90,81,88,82,86,32,84,77,82,86,82,89,83,90,85,91,87,91,89,90,91,88,92,86,93,82,93,77,92,77,93,79,32,85,77,83,86,83,89,85,91,0,72,92,75,81,77,78,79,77,82,77,83,79,83,82,32,81,77,82,79,82,82,81,86,80,88,78,90,76,91,75,91,74,90,74,89,75,88,76,89,75,90,32,81,86,81,89,82,91,85,91,87,90,89,87,32,89,78,88,79,89,80,90,79,90,78,89,77,88,77,86,78,84,80,83,82,82,86,82,89,83,91,0,71,92,72,81,73,79,75,77,78,77,79,78,79,81,77,87,77,89,79,91,32,77,77,78,78,78,81,76,87,76,89,77,90,79,91,81,91,83,90,85,88,87,84,32,90,77,86,91,85,94,83,97,80,98,77,98,75,97,74,96,74,95,75,94,76,95,75,96,32,89,77,85,91,84,94,82,97,80,98,0,72,92,89,77,88,79,86,81,78,87,76,89,75,91,32,76,81,77,79,79,77,82,77,86,79,32,77,79,79,78,82,78,86,79,88,79,32,76,89,78,89,82,90,85,90,87,89,32,78,89,82,91,85,91,87,89,88,87,0,71,94,86,71,85,72,86,73,87,72,87,71,85,70,82,70,79,71,77,73,76,76,76,91,32,82,70,80,71,78,73,77,76,77,91,32,92,71,91,72,92,73,93,72,93,71,92,70,90,70,88,71,87,73,87,91,32,90,70,89,71,88,73,88,91,32,73,77,91,77,32,73,91,80,91,32,84,91,91,91,0,71,93,87,71,86,72,87,73,88,72,87,71,85,70,82,70,79,71,77,73,76,76,76,91,32,82,70,80,71,78,73,77,76,77,91,32,87,77,87,91,32,88,77,88,91,32,73,77,88,77,32,73,91,80,91,32,84,91,91,91,0,71,93,86,71,85,72,86,73,87,72,87,71,85,70,32,88,70,82,70,79,71,77,73,76,76,76,91,32,82,70,80,71,78,73,77,76,77,91,32,87,72,87,91,32,88,70,88,91,32,73,77,87,77,32,73,91,80,91,32,84,91,91,91,0,66,99,82,71,81,72,82,73,83,72,82,71,80,70,77,70,74,71,72,73,71,76,71,91,32,77,70,75,71,73,73,72,76,72,91,32,93,71,92,72,93,73,94,72,93,71,91,70,88,70,85,71,83,73,82,76,82,91,32,88,70,86,71,84,73,83,76,83,91,32,93,77,93,91,32,94,77,94,91,32,68,77,94,77,32,68,91,75,91,32,79,91,86,91,32,90,91,97,91,0,66,99,82,71,81,72,82,73,83,72,82,71,80,70,77,70,74,71,72,73,71,76,71,91,32,77,70,75,71,73,73,72,76,72,91,32,92,71,91,72,92,73,93,72,93,71,91,70,32,94,70,88,70,85,71,83,73,82,76,82,91,32,88,70,86,71,84,73,83,76,83,91,32,93,72,93,91,32,94,70,94,91,32,68,77,93,77,32,68,91,75,91,32,79,91,86,91,32,90,91,97,91,0,77,88,82,77,82,91,32,83,77,83,91,32,79,77,83,77,32,79,91,86,91,0,73,90,87,78,85,77,82,77,79,78,77,80,76,83,76,86,77,89,78,90,81,91,84,91,86,90,32,82,77,80,78,78,80,77,83,77,86,78,89,79,90,81,91,32,77,84,85,84,0,73,92,84,70,81,71,79,74,78,76,77,79,76,84,76,88,77,90,79,91,81,91,84,90,86,87,87,85,88,82,89,77,89,73,88,71,86,70,84,70,32,84,70,82,71,80,74,79,76,78,79,77,84,77,88,78,90,79,91,32,81,91,83,90,85,87,86,85,87,82,88,77,88,73,87,71,86,70,32,78,80,87,80,0,71,93,85,70,79,98,32,86,70,78,98,32,81,77,77,78,75,80,74,83,74,86,75,88,77,90,80,91,83,91,87,90,89,88,90,85,90,82,89,80,87,78,84,77,81,77,32,81,77,78,78,76,80,75,83,75,86,76,88,78,90,80,91,32,83,91,86,90,88,88,89,85,89,82,88,80,86,78,84,77,0,73,91,84,77,86,78,88,80,88,79,87,78,84,77,81,77,78,78,77,79,76,81,76,83,77,85,79,87,83,90,32,81,77,79,78,78,79,77,81,77,83,78,85,83,90,84,92,84,94,83,95,81,95,0,71,93,76,77,75,78,74,80,74,82,75,85,79,89,80,91,32,74,82,75,84,79,88,80,91,80,93,79,96,77,98,76,98,75,97,74,95,74,92,75,88,77,84,79,81,82,78,84,77,86,77,89,78,90,80,90,84,89,88,87,90,85,91,84,91,83,90,83,88,84,87,85,88,84,89,32,86,77,88,78,89,80,89,84,88,88,87,90,0,69,95,89,71,88,72,89,73,90,72,89,71,87,70,84,70,81,71,79,73,78,75,77,78,76,82,74,91,73,95,72,97,32,84,70,82,71,80,73,79,75,78,78,76,87,75,91,74,94,73,96,72,97,70,98,68,98,67,97,67,96,68,95,69,96,68,97,32,95,71,94,72,95,73,96,72,96,71,95,70,93,70,91,71,90,72,89,74,88,77,85,91,84,95,83,97,32,93,70,91,72,90,74,89,78,87,87,86,91,85,94,84,96,83,97,81,98,79,98,78,97,78,96,79,95,80,96,79,97,32,73,77,94,77,0,70,94,91,71,90,72,91,73,92,72,91,71,88,70,85,70,82,71,80,73,79,75,78,78,77,82,75,91,74,95,73,97,32,85,70,83,71,81,73,80,75,79,78,77,87,76,91,75,94,74,96,73,97,71,98,69,98,68,97,68,96,69,95,70,96,69,97,32,89,77,87,84,86,88,86,90,87,91,90,91,92,89,93,87,32,90,77,88,84,87,88,87,90,88,91,32,74,77,90,77,0,70,94,89,71,88,72,89,73,90,72,90,71,88,70,32,92,70,85,70,82,71,80,73,79,75,78,78,77,82,75,91,74,95,73,97,32,85,70,83,71,81,73,80,75,79,78,77,87,76,91,75,94,74,96,73,97,71,98,69,98,68,97,68,96,69,95,70,96,69,97,32,91,70,87,84,86,88,86,90,87,91,90,91,92,89,93,87,32,92,70,88,84,87,88,87,90,88,91,32,74,77,89,77,0,64,99,84,71,83,72,84,73,85,72,84,71,82,70,79,70,76,71,74,73,73,75,72,78,71,82,69,91,68,95,67,97,32,79,70,77,71,75,73,74,75,73,78,71,87,70,91,69,94,68,96,67,97,65,98,63,98,62,97,62,96,63,95,64,96,63,97,32,96,71,95,72,96,73,97,72,96,71,93,70,90,70,87,71,85,73,84,75,83,78,82,82,80,91,79,95,78,97,32,90,70,88,71,86,73,85,75,84,78,82,87,81,91,80,94,79,96,78,97,76,98,74,98,73,97,73,96,74,95,75,96,74,97,32,94,77,92,84,91,88,91,90,92,91,95,91,97,89,98,87,32,95,77,93,84,92,88,92,90,93,91,32,68,77,95,77,0,64,99,84,71,83,72,84,73,85,72,84,71,82,70,79,70,76,71,74,73,73,75,72,78,71,82,69,91,68,95,67,97,32,79,70,77,71,75,73,74,75,73,78,71,87,70,91,69,94,68,96,67,97,65,98,63,98,62,97,62,96,63,95,64,96,63,97,32,94,71,93,72,94,73,95,72,95,71,93,70,32,97,70,90,70,87,71,85,73,84,75,83,78,82,82,80,91,79,95,78,97,32,90,70,88,71,86,73,85,75,84,78,82,87,81,91,80,94,79,96,78,97,76,98,74,98,73,97,73,96,74,95,75,96,74,97,32,96,70,92,84,91,88,91,90,92,91,95,91,97,89,98,87,32,97,70,93,84,92,88,92,90,93,91,32,68,77,94,77,0,76,89,77,81,78,79,80,77,83,77,84,78,84,81,82,87,82,90,83,91,32,82,77,83,78,83,81,81,87,81,90,82,91,85,91,87,89,88,87,0,72,92,81,70,78,71,76,74,75,79,75,82,76,87,78,90,81,91,83,91,86,90,88,87,89,82,89,79,88,74,86,71,83,70,81,70,32,81,70,79,71,78,72,77,74,76,79,76,82,77,87,78,89,79,90,81,91,32,83,91,85,90,86,89,87,87,88,82,88,79,87,74,86,72,85,71,83,70,0,72,92,78,74,80,73,83,70,83,91,32,82,71,82,91,32,78,91,87,91,0,72,92,76,74,77,75,76,76,75,75,75,74,76,72,77,71,80,70,84,70,87,71,88,72,89,74,89,76,88,78,85,80,80,82,78,83,76,85,75,88,75,91,32,84,70,86,71,87,72,88,74,88,76,87,78,84,80,80,82,32,75,89,76,88,78,88,83,90,86,90,88,89,89,88,32,78,88,83,91,87,91,88,90,89,88,89,86,0,72,92,76,74,77,75,76,76,75,75,75,74,76,72,77,71,80,70,84,70,87,71,88,73,88,76,87,78,84,79,81,79,32,84,70,86,71,87,73,87,76,86,78,84,79,32,84,79,86,80,88,82,89,84,89,87,88,89,87,90,84,91,80,91,77,90,76,89,75,87,75,86,76,85,77,86,76,87,32,87,81,88,84,88,87,87,89,86,90,84,91,0,72,92,84,72,84,91,32,85,70,85,91,32,85,70,74,85,90,85,32,81,91,88,91,0,72,92,77,70,75,80,32,75,80,77,78,80,77,83,77,86,78,88,80,89,83,89,85,88,88,86,90,83,91,80,91,77,90,76,89,75,87,75,86,76,85,77,86,76,87,32,83,77,85,78,87,80,88,83,88,85,87,88,85,90,83,91,32,77,70,87,70,32,77,71,82,71,87,70,0,72,92,87,73,86,74,87,75,88,74,88,73,87,71,85,70,82,70,79,71,77,73,76,75,75,79,75,85,76,88,78,90,81,91,83,91,86,90,88,88,89,85,89,84,88,81,86,79,83,78,82,78,79,79,77,81,76,84,32,82,70,80,71,78,73,77,75,76,79,76,85,77,88,79,90,81,91,32,83,91,85,90,87,88,88,85,88,84,87,81,85,79,83,78,0,72,92,75,70,75,76,32,75,74,76,72,78,70,80,70,85,73,87,73,88,72,89,70,32,76,72,78,71,80,71,85,73,32,89,70,89,73,88,76,84,81,83,83,82,86,82,91,32,88,76,83,81,82,83,81,86,81,91,0,72,92,80,70,77,71,76,73,76,76,77,78,80,79,84,79,87,78,88,76,88,73,87,71,84,70,80,70,32,80,70,78,71,77,73,77,76,78,78,80,79,32,84,79,86,78,87,76,87,73,86,71,84,70,32,80,79,77,80,76,81,75,83,75,87,76,89,77,90,80,91,84,91,87,90,88,89,89,87,89,83,88,81,87,80,84,79,32,80,79,78,80,77,81,76,83,76,87,77,89,78,90,80,91,32,84,91,86,90,87,89,88,87,88,83,87,81,86,80,84,79,0,72,92,88,77,87,80,85,82,82,83,81,83,78,82,76,80,75,77,75,76,76,73,78,71,81,70,83,70,86,71,88,73,89,76,89,82,88,86,87,88,85,90,82,91,79,91,77,90,76,88,76,87,77,86,78,87,77,88,32,81,83,79,82,77,80,76,77,76,76,77,73,79,71,81,70,32,83,70,85,71,87,73,88,76,88,82,87,86,86,88,84,90,82,91,0,77,87,82,91,81,90,82,89,83,90,83,92,82,94,81,95,0,77,87,82,77,81,78,82,79,83,78,82,77,32,82,91,81,90,82,89,83,90,83,92,82,94,81,95,0,77,87,82,70,81,72,82,84,83,72,82,70,32,82,72,82,78,32,82,89,81,90,82,91,83,90,82,89,0,73,91,77,74,78,75,77,76,76,75,76,74,77,72,78,71,80,70,83,70,86,71,87,72,88,74,88,76,87,78,86,79,82,81,82,84,32,83,70,85,71,86,72,87,74,87,76,86,78,84,80,32,82,89,81,90,82,91,83,90,82,89,0,78,86,82,70,81,77,32,83,70,81,77,0,74,90,78,70,77,77,32,79,70,77,77,32,86,70,85,77,32,87,70,85,77,0,74,90,82,70,82,82,32,77,73,87,79,32,87,73,77,79,0,75,89,85,66,78,82,85,98,0,75,89,79,66,86,82,79,98,0,75,89,79,66,79,98,32,85,66,85,98,0,70,94,82,74,82,91,32,74,82,90,82,32,74,91,90,91,0,70,94,82,74,82,91,32,74,74,90,74,32,74,82,90,82,0,77,87,81,81,81,83,83,83,83,81,81,81,32,82,81,82,83,32,81,82,83,82,0,69,95,82,73,81,74,82,75,83,74,82,73,32,73,82,91,82,32,82,89,81,90,82,91,83,90,82,89,0,69,95,89,73,75,91,32,73,79,91,79,32,73,85,91,85,0,69,95,73,77,91,77,32,73,82,91,82,32,73,87,91,87,0,70,94,90,70,74,77,90,84,32,74,86,90,86,32,74,91,90,91,0,70,94,74,70,90,77,74,84,32,74,86,90,86,32,74,91,90,91,0,70,95,91,87,89,87,87,86,85,84,82,80,81,79,79,78,77,78,75,79,74,81,74,83,75,85,77,86,79,86,81,85,82,84,85,80,87,78,89,77,91,77,0,70,94,73,85,73,83,74,80,76,79,78,79,80,80,84,83,86,84,88,84,90,83,91,81,32,73,83,74,81,76,80,78,80,80,81,84,84,86,85,88,85,90,84,91,81,91,79,0,71,93,74,84,82,79,90,84,32,74,84,82,80,90,84,0,76,88,84,70,79,76,32,84,70,85,71,79,76,0,76,88,80,70,85,76,32,80,70,79,71,85,76,0,72,92,75,70,76,72,78,74,81,75,83,75,86,74,88,72,89,70,32,75,70,76,73,78,75,81,76,83,76,86,75,88,73,89,70,0,77,87,82,72,83,71,82,70,81,71,81,73,82,75,83,76,0,77,87,81,70,82,71,83,73,83,75,82,76,81,75,82,74,0,69,91,72,77,76,77,82,89,32,75,77,82,91,32,91,66,82,91,0,70,94,90,74,83,74,79,75,77,76,75,78,74,81,74,83,75,86,77,88,79,89,83,90,90,90,0,70,94,74,74,74,81,75,85,76,87,78,89,81,90,83,90,86,89,88,87,89,85,90,81,90,74,0,70,94,74,74,81,74,85,75,87,76,89,78,90,81,90,83,89,86,87,88,85,89,81,90,74,90,0,70,94,74,90,74,83,75,79,76,77,78,75,81,74,83,74,86,75,88,77,89,79,90,83,90,90,0,70,94,90,74,83,74,79,75,77,76,75,78,74,81,74,83,75,86,77,88,79,89,83,90,90,90,32,74,82,86,82,0,69,95,88,80,91,82,88,84,32,85,77,90,82,85,87,32,73,82,90,82,0,74,90,80,76,82,73,84,76,32,77,79,82,74,87,79,32,82,74,82,91,0,69,95,76,80,73,82,76,84,32,79,77,74,82,79,87,32,74,82,91,82,0,74,90,80,88,82,91,84,88,32,77,85,82,90,87,85,32,82,73,82,90,0,73,92,88,82,87,79,86,78,84,77,82,77,79,78,77,81,76,84,76,87,77,89,78,90,80,91,82,91,85,90,87,88,88,85,89,80,89,75,88,72,87,71,85,70,82,70,80,71,79,72,79,73,80,73,80,72,32,82,77,80,78,78,81,77,84,77,88,78,90,32,82,91,84,90,86,88,87,85,88,80,88,75,87,72,85,70,0,72,92,74,70,82,91,32,75,70,82,89,32,90,70,82,91,32,74,70,90,70,32,75,71,89,71,0,65,98,68,77,73,77,82,89,32,72,78,82,91,32,98,58,82,91,0,70,94,91,67,90,68,91,69,92,68,92,67,91,66,89,66,87,67,85,69,84,71,83,74,82,78,80,90,79,94,78,96,32,86,68,85,70,84,74,82,86,81,90,80,93,79,95,77,97,75,98,73,98,72,97,72,96,73,95,74,96,73,97,32,81,75,78,76,76,78,75,81,75,83,76,86,78,88,81,89,83,89,86,88,88,86,89,83,89,81,88,78,86,76,83,75,81,75,0,70,95,92,83,91,85,89,86,87,86,85,85,84,84,81,80,80,79,78,78,76,78,74,79,73,81,73,83,74,85,76,86,78,86,80,85,81,84,84,80,85,79,87,78,89,78,91,79,92,81,92,83,0,70,94,91,70,73,91,32,78,70,80,72,80,74,79,76,77,77,75,77,73,75,73,73,74,71,76,70,78,70,80,71,83,72,86,72,89,71,91,70,32,87,84,85,85,84,87,84,89,86,91,88,91,90,90,91,88,91,86,89,84,87,84,0,70,95,91,78,90,79,91,80,92,79,92,78,91,77,90,77,89,78,88,80,86,85,84,88,82,90,80,91,77,91,74,90,73,88,73,85,74,83,80,79,82,77,83,75,83,73,82,71,80,70,78,71,77,73,77,75,78,78,80,81,85,88,87,90,90,91,91,91,92,90,92,89,32,77,91,75,90,74,88,74,85,75,83,77,81,32,77,75,78,77,86,88,88,90,90,91,0,69,96,87,78,86,76,84,75,81,75,79,76,78,77,77,80,77,83,78,85,80,86,83,86,85,85,86,83,32,81,75,79,77,78,80,78,83,79,85,80,86,32,87,75,86,83,86,85,88,86,90,86,92,84,93,81,93,79,92,76,91,74,89,72,87,71,84,70,81,70,78,71,76,72,74,74,73,76,72,79,72,82,73,85,74,87,76,89,78,90,81,91,84,91,87,90,89,89,90,88,32,88,75,87,83,87,85,88,86,0,72,92,80,66,80,95,32,84,66,84,95,32,88,73,87,74,88,75,89,74,89,73,87,71,84,70,80,70,77,71,75,73,75,75,76,77,77,78,79,79,85,81,87,82,89,84,32,75,75,77,77,79,78,85,80,87,81,88,82,89,84,89,88,87,90,84,91,80,91,77,90,75,88,75,87,76,86,77,87,76,88,0,74,90,85,73,84,74,85,75,86,74,86,73,85,71,83,70,81,70,79,71,78,73,78,75,79,77,81,79,86,82,32,79,77,84,80,86,82,87,84,87,86,86,88,84,90,32,80,78,78,80,77,82,77,84,78,86,80,88,85,91,32,78,86,83,89,85,91,86,93,86,95,85,97,83,98,81,98,79,97,78,95,78,94,79,93,80,94,79,95,0,74,90,82,70,81,72,82,74,83,72,82,70,32,82,70,82,98,32,82,81,81,84,82,98,83,84,82,81,32,76,77,78,78,80,77,78,76,76,77,32,76,77,88,77,32,84,77,86,78,88,77,86,76,84,77,0,74,90,82,70,81,72,82,74,83,72,82,70,32,82,70,82,84,32,82,80,81,82,83,86,82,88,81,86,83,82,82,80,32,82,84,82,98,32,82,94,81,96,82,98,83,96,82,94,32,76,77,78,78,80,77,78,76,76,77,32,76,77,88,77,32,84,77,86,78,88,77,86,76,84,77,32,76,91,78,92,80,91,78,90,76,91,32,76],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+296961);allocate([91,88,91,32,84,91,86,92,88,91,86,90,84,91,0,73,92,88,70,88,91,32,75,70,88,70,32,80,80,88,80,32,75,91,88,91,0,69,96,81,70,78,71,75,73,73,76,72,79,72,82,73,85,75,88,78,90,81,91,84,91,87,90,90,88,92,85,93,82,93,79,92,76,90,73,87,71,84,70,81,70,32,82,79,81,80,81,81,82,82,83,82,84,81,84,80,83,79,82,79,32,82,80,82,81,83,81,83,80,82,80,0,74,91,80,70,78,71,79,73,81,74,32,80,70,79,71,79,73,32,85,70,87,71,86,73,84,74,32,85,70,86,71,86,73,32,81,74,79,75,78,76,77,78,77,81,78,83,79,84,81,85,84,85,86,84,87,83,88,81,88,78,87,76,86,75,84,74,81,74,32,82,85,82,91,32,83,85,83,91,32,78,88,87,88,0,73,92,82,70,79,71,77,73,76,76,76,77,77,80,79,82,82,83,83,83,86,82,88,80,89,77,89,76,88,73,86,71,83,70,82,70,32,82,83,82,91,32,83,83,83,91,32,78,87,87,87,0,68,96,80,70,77,71,74,73,72,76,71,79,71,83,72,86,74,89,77,91,80,92,84,92,87,91,90,89,92,86,93,83,93,79,92,76,90,73,87,71,84,70,80,70,32,82,70,82,92,32,71,81,93,81,0,71,96,80,77,77,78,75,80,74,83,74,84,75,87,77,89,80,90,81,90,84,89,86,87,87,84,87,83,86,80,84,78,81,77,80,77,32,93,71,87,71,91,72,85,78,32,93,71,93,77,92,73,86,79,32,92,72,86,78,0,70,92,73,73,74,71,76,70,79,70,81,71,82,73,82,76,81,79,80,81,78,83,75,85,32,79,70,80,71,81,73,81,77,80,80,78,83,32,86,70,84,91,32,87,70,83,91,32,75,85,89,85,0,73,92,77,70,77,85,32,78,70,77,81,32,77,81,78,79,79,78,81,77,84,77,87,78,88,80,88,82,87,84,85,86,32,84,77,86,78,87,80,87,82,84,88,84,90,85,91,87,91,89,89,32,75,70,78,70,0,73,92,82,78,79,79,77,81,76,84,76,85,77,88,79,90,82,91,83,91,86,90,88,88,89,85,89,84,88,81,86,79,83,78,82,78,32,82,72,78,74,82,70,82,78,32,83,72,87,74,83,70,83,78,32,82,83,81,84,81,85,82,86,83,86,84,85,84,84,83,83,82,83,32,82,84,82,85,83,85,83,84,82,84,0,71,94,81,72,82,70,82,91,32,84,72,83,70,83,91,32,74,72,75,70,75,77,76,80,78,82,81,83,82,83,32,77,72,76,70,76,78,77,81,32,91,72,90,70,90,77,89,80,87,82,84,83,83,83,32,88,72,89,70,89,78,88,81,32,78,87,87,87,0,71,93,76,70,76,91,32,77,70,77,91,32,73,70,85,70,88,71,89,72,90,74,90,77,89,79,88,80,85,81,77,81,32,85,70,87,71,88,72,89,74,89,77,88,79,87,80,85,81,32,73,91,89,91,89,86,88,91,0,72,91,89,71,85,71,81,72,78,74,76,77,75,80,75,83,76,86,78,89,81,91,85,92,89,92,32,89,71,86,72,83,74,81,77,80,80,80,83,81,86,83,89,86,91,89,92,0,70,95,79,81,77,81,75,82,74,83,73,85,73,87,74,89,75,90,77,91,79,91,81,90,82,89,83,87,83,85,82,83,81,82,79,81,32,83,72,80,81,32,90,74,82,82,32,92,81,83,84,0,72,92,79,75,85,89,32,85,75,79,89,32,75,79,89,85,32,89,79,75,85,0,70,94,78,86,76,85,75,85,73,86,72,88,72,89,73,91,75,92,76,92,78,91,79,89,79,88,78,86,75,82,74,79,74,77,75,74,77,72,80,71,84,71,87,72,89,74,90,77,90,79,89,82,86,86,85,88,85,89,86,91,88,92,89,92,91,91,92,89,92,88,91,86,89,85,88,85,86,86,32,74,77,75,75,77,73,80,72,84,72,87,73,89,75,90,77,0,70,94,78,77,76,78,75,78,73,77,72,75,72,74,73,72,75,71,76,71,78,72,79,74,79,75,78,77,75,81,74,84,74,86,75,89,77,91,80,92,84,92,87,91,89,89,90,86,90,84,89,81,86,77,85,75,85,74,86,72,88,71,89,71,91,72,92,74,92,75,91,77,89,78,88,78,86,77,32,74,86,75,88,77,90,80,91,84,91,87,90,89,88,90,86,0,73,91,75,89,89,75,32,81,76,85,76,89,75,88,79,88,83,32,85,76,88,76,88,79,0,73,91,89,75,75,89,32,76,81,76,85,75,89,79,88,83,88,32,76,85,76,88,79,88,0,73,91,89,89,75,75,32,83,76,79,76,75,75,76,79,76,83,32,79,76,76,76,76,79,0,73,91,75,75,89,89,32,81,88,85,88,89,89,88,85,88,81,32,85,88,88,88,88,85,0,70,95,74,77,73,76,73,74,74,72,76,71,78,71,80,72,81,73,82,75,83,80,32,73,74,75,72,77,72,79,73,80,74,81,76,82,80,82,91,32,91,77,92,76,92,74,91,72,89,71,87,71,85,72,84,73,83,75,82,80,32,92,74,90,72,88,72,86,73,85,74,84,76,83,80,83,91,0,70,94,73,71,74,75,75,77,77,79,80,80,84,80,87,79,89,77,90,75,91,71,32,73,71,74,74,75,76,77,78,80,79,84,79,87,78,89,76,90,74,91,71,32,80,79,78,80,77,81,76,83,76,86,77,88,79,90,81,91,83,91,85,90,87,88,88,86,88,83,87,81,86,80,84,79,32,80,80,78,81,77,83,77,86,78,89,32,86,89,87,86,87,83,86,81,84,80,0,70,94,77,74,77,86,32,78,75,78,85,32,86,75,86,85,32,87,74,87,86,32,73,71,75,73,77,74,80,75,84,75,87,74,89,73,91,71,32,73,89,75,87,77,86,80,85,84,85,87,86,89,87,91,89,0,70,94,91,73,76,73,74,74,73,76,73,78,74,80,76,81,78,81,80,80,81,78,81,76,80,74,91,74,32,73,77,74,79,75,80,77,81,32,81,77,80,75,79,74,77,73,32,73,88,88,88,90,87,91,85,91,83,90,81,88,80,86,80,84,81,83,83,83,85,84,87,73,87,32,91,84,90,82,89,81,87,80,32,83,84,84,86,85,87,87,88,0,70,93,79,85,77,84,76,84,74,85,73,87,73,88,74,90,76,91,77,91,79,90,80,88,80,87,79,85,74,80,73,78,73,75,74,73,76,72,79,71,83,71,87,72,89,74,90,76,90,79,89,82,86,85,85,87,85,89,86,91,88,91,89,90,90,88,32,77,83,75,80,74,78,74,75,75,73,76,72,32,83,71,86,72,88,74,89,76,89,79,88,82,86,85,0,71,95,72,75,75,72,77,75,77,86,32,74,73,76,76,76,86,32,77,75,80,72,82,75,82,85,32,79,73,81,76,81,85,32,82,75,85,72,87,75,87,91,32,84,73,86,76,86,91,32,87,75,90,72,91,74,92,77,92,80,91,83,90,85,88,87,85,89,80,91,32,89,73,90,74,91,77,91,80,90,83,89,85,87,87,84,89,80,91,0,70,94,73,83,77,83,76,82,75,79,75,77,76,74,78,72,81,71,83,71,86,72,88,74,89,77,89,79,88,82,87,83,91,83,32,73,84,79,84,77,82,76,79,76,77,77,74,79,72,81,71,32,83,71,85,72,87,74,88,77,88,79,87,82,85,84,91,84,32,75,88,89,88,32,75,89,89,89,0,70,95,71,76,74,73,77,76,77,88,32,73,74,76,77,76,88,32,77,76,80,73,83,76,83,88,32,79,74,82,77,82,88,32,83,76,86,73,89,76,89,87,91,89,32,85,74,88,77,88,88,90,90,93,87,0,71,93,90,73,74,89,32,90,73,87,74,81,74,32,88,75,85,75,81,74,32,90,73,89,76,89,82,32,88,75,88,78,89,82,32,81,82,74,82,32,80,83,77,83,74,82,32,81,82,81,89,32,80,83,80,86,81,89,0,70,94,72,79,74,75,79,85,32,74,77,79,87,82,80,87,80,90,79,91,77,91,75,90,73,88,72,87,72,85,73,84,75,84,77,85,80,86,82,87,85,87,88,85,90,32,87,72,86,73,85,75,85,77,87,81,88,84,88,87,87,89,85,90,0,70,94,73,79,76,76,80,78,32,75,77,79,79,82,76,85,78,32,81,77,84,79,87,76,89,78,32,86,77,88,79,91,76,32,73,85,76,82,80,84,32,75,83,79,85,82,82,85,84,32,81,83,84,85,87,82,89,84,32,86,83,88,85,91,82,0,70,94,74,72,78,74,80,76,81,79,81,82,80,85,78,87,74,89,32,74,72,77,73,79,74,81,76,82,79,32,82,82,81,85,79,87,77,88,74,89,32,90,72,87,73,85,74,83,76,82,79,32,82,82,83,85,85,87,87,88,90,89,32,90,72,86,74,84,76,83,79,83,82,84,85,86,87,90,89,32,73,80,91,80,32,73,81,91,81,0,78,86,81,81,81,83,83,83,83,81,81,81,32,81,81,83,83,32,83,81,81,83,0,74,90,77,80,81,82,84,84,86,86,87,89,87,91,86,93,85,94,32,77,81,83,84,32,77,82,80,83,84,85,86,87,87,89,0,74,90,87,75,86,77,84,79,80,81,77,82,32,83,80,77,83,32,85,70,86,71,87,73,87,75,86,78,84,80,81,82,77,84,0,72,92,83,77,79,78,76,80,75,82,75,84,76,86,78,87,81,87,85,86,88,84,89,82,89,80,88,78,86,77,83,77,32,88,78,83,77,32,86,77,81,78,76,80,32,79,78,75,82,32,76,86,81,87,32,78,87,83,86,88,84,32,85,86,89,82,0,74,91,83,77,80,78,78,80,77,82,77,84,78,86,80,87,82,87,85,86,87,84,88,82,88,80,87,78,85,77,83,77,32,79,80,85,77,32,78,82,86,78,32,77,84,87,79,32,78,85,88,80,32,79,86,87,82,32,80,87,86,84,0,74,90,79,71,79,94,32,85,70,85,93,32,77,78,87,76,32,77,79,87,77,32,77,87,87,85,32,77,88,87,86,0,74,90,78,70,78,88,32,86,76,86,94,32,78,78,86,76,32,78,79,86,77,32,78,87,86,85,32,78,88,86,86,0,74,90,78,66,78,87,32,78,78,81,76,84,76,86,77,87,79,87,81,86,83,83,85,81,86,78,87,32,78,78,81,77,84,77,86,78,32,85,77,86,79,86,81,85,83,83,85,0,69,95,72,73,72,76,32,92,73,92,76,32,72,73,92,73,32,72,74,92,74,32,72,75,92,75,32,72,76,92,76,0,74,90,77,78,77,81,32,87,78,87,81,32,77,78,87,78,32,77,79,87,79,32,77,80,87,80,32,77,81,87,81,0,74,90,77,76,87,88,32,77,76,79,78,81,79,84,79,86,78,87,77,87,75,85,75,85,77,84,79,32,79,78,84,79,32,81,79,87,77,32,86,75,86,78,32,85,76,87,76,32,87,88,85,86,83,85,80,85,78,86,77,87,77,89,79,89,79,87,80,85,32,85,86,80,85,32,83,85,77,87,32,78,86,78,89,32,77,88,79,88,0,74,90,80,79,79,77,79,75,77,75,77,77,78,78,80,79,83,79,85,78,87,76,32,78,75,78,78,32,77,76,79,76,32,77,77,83,79,32,80,79,85,78,32,87,76,87,89,0,65,94,71,102,72,102,73,101,73,100,72,99,71,99,70,100,70,102,71,104,73,105,75,105,78,104,80,102,81,100,82,96,82,85,81,59,81,52,82,47,83,45,85,44,86,44,88,45,89,47,89,51,88,54,87,56,85,59,80,63,74,67,72,69,70,72,69,74,68,78,68,82,69,86,71,89,74,91,78,92,82,92,86,91,88,90,90,87,91,84,91,80,90,77,89,75,87,73,84,72,80,72,77,73,75,75,74,78,74,82,75,85,77,87,32,71,100,71,101,72,101,72,100,71,100,32,85,59,81,63,76,67,73,70,71,73,70,75,69,78,69,82,70,86,71,88,74,91,32,82,92,85,91,87,90,89,87,90,84,90,80,89,77,88,75,86,73,84,72,0,69,102,78,83,79,85,81,86,83,86,85,85,86,83,86,81,85,79,83,78,81,78,79,79,78,80,77,83,77,86,78,89,80,91,83,92,86,92,89,91,91,89,92,87,93,84,93,80,92,77,90,74,88,73,85,72,82,72,79,73,77,74,75,76,73,79,72,83,72,88,73,93,75,97,77,99,80,101,84,102,89,102,93,101,96,99,98,97,32,75,76,74,78,73,82,73,88,74,92,76,96,78,98,81,100,85,101,89,101,93,100,95,99,98,97,32,80,79,84,79,32,79,80,85,80,32,78,81,86,81,32,78,82,86,82,32,78,83,86,83,32,79,84,85,84,32,80,85,84,85,32,97,76,97,78,99,78,99,76,97,76,32,98,76,98,78,32,97,77,99,77,32,97,86,97,88,99,88,99,86,97,86,32,98,86,98,88,32,97,87,99,87,0,68,96,72,64,72,100,32,77,64,77,100,32,87,64,87,100,32,92,64,92,100,32,77,77,87,75,32,77,78,87,76,32,77,79,87,77,32,77,87,87,85,32,77,88,87,86,32,77,89,87,87,0,72,92,80,77,77,78,76,79,75,81,75,83,76,85,77,86,80,87,84,87,87,86,88,85,89,83,89,81,88,79,87,78,84,77,80,77,32,77,78,76,80,76,83,77,85,78,86,80,87,32,87,86,88,84,88,81,87,79,86,78,84,77,0,74,90,81,67,86,77,82,84,82,85,32,85,76,81,83,32,84,73,84,75,80,82,82,85,85,89,32,87,92,85,89,83,88,81,88,79,89,78,91,78,93,79,95,82,97,32,87,92,85,90,83,89,79,89,79,93,80,95,82,97,32,83,88,80,90,78,93,0,74,90,80,79,79,77,79,75,77,75,77,77,78,78,80,79,83,79,85,78,87,76,32,78,75,78,78,32,77,76,79,76,32,77,77,83,79,32,80,79,85,78,32,87,76,83,89,0,73,106,78,81,79,79,81,78,83,78,85,79,86,81,86,83,85,85,83,86,81,86,79,85,78,84,77,81,77,78,78,75,80,73,83,72,87,72,91,73,94,75,96,78,97,82,97,87,96,91,95,93,93,96,90,99,86,102,81,105,77,107,32,87,72,90,73,93,75,95,78,96,82,96,87,95,91,94,93,92,96,89,99,84,103,81,105,32,80,79,84,79,32,79,80,85,80,32,78,81,86,81,32,78,82,86,82,32,78,83,86,83,32,79,84,85,84,32,80,85,84,85,32,101,76,101,78,103,78,103,76,101,76,32,102,76,102,78,32,101,77,103,77,32,101,86,101,88,103,88,103,86,101,86,32,102,86,102,88,32,101,87,103,87,0,68,96,72,62,72,102,32,73,62,73,102,32,77,62,77,102,32,81,66,83,66,83,68,81,68,81,65,82,63,84,62,87,62,89,63,91,65,92,68,92,73,91,76,89,78,87,79,85,79,83,78,82,76,81,78,79,81,78,82,79,83,81,86,82,88,83,86,85,85,87,85,89,86,91,88,92,91,92,96,91,99,89,101,87,102,84,102,82,101,81,99,81,96,83,96,83,98,81,98,32,82,66,82,68,32,81,67,83,67,32,89,63,90,65,91,68,91,73,90,76,89,78,32,82,76,82,78,80,81,78,82,80,83,82,86,82,88,32,89,86,90,88,91,91,91,96,90,99,89,101,32,82,96,82,98,32,81,97,83,97,0,65,99,72,66,72,98,32,73,66,73,98,32,91,66,91,98,32,92,66,92,98,32,68,66,96,66,32,68,98,77,98,32,87,98,96,98,0,66,97,71,66,81,80,70,98,32,70,66,80,80,32,69,66,80,81,32,69,66,92,66,94,73,91,66,32,71,97,92,97,32,70,98,92,98,94,91,91,98,0,73,91,88,43,85,49,82,56,80,61,79,65,78,70,77,78,77,86,78,94,79,99,80,103,82,108,85,115,88,121,32,85,49,83,54,81,60,80,64,79,70,78,78,78,86,79,94,80,100,81,104,83,110,85,115,0,73,91,76,43,79,49,82,56,84,61,85,65,86,70,87,78,87,86,86,94,85,99,84,103,82,108,79,115,76,121,32,79,49,81,54,83,60,84,64,85,70,86,78,86,86,85,94,84,100,83,104,81,110,79,115,0,73,91,77,43,77,82,77,121,32,78,43,78,82,78,121,32,77,43,88,43,32,77,121,88,121,0,73,91,86,43,86,82,86,121,32,87,43,87,82,87,121,32,76,43,87,43,32,76,121,87,121,0,72,91,86,43,82,49,80,53,79,58,79,62,80,66,84,74,84,76,83,78,82,79,77,82,82,85,83,86,84,88,84,90,80,98,79,102,79,106,80,111,82,115,86,121,32,84,46,82,50,81,53,80,58,80,62,81,67,82,70,32,82,94,81,97,80,102,80,106,81,111,82,114,84,118,0,73,92,78,43,82,49,84,53,85,58,85,62,84,66,80,74,80,76,81,78,82,79,87,82,82,85,81,86,80,88,80,90,84,98,85,102,85,106,84,111,82,115,78,121,32,80,46,82,50,83,53,84,58,84,62,83,67,82,70,32,82,94,83,97,84,102,84,106,83,111,82,114,80,118,0,73,91,86,46,83,49,81,52,79,56,78,61,78,67,79,73,80,77,83,88,84,92,85,98,85,103,84,108,83,111,81,115,32,83,49,81,53,80,56,79,61,79,66,80,72,81,76,84,87,85,91,86,97,86,103,85,108,83,112,81,115,78,118,0,73,91,78,46,81,49,83,52,85,56,86,61,86,67,85,73,84,77,81,88,80,92,79,98,79,103,80,108,81,111,83,115,32,81,49,83,53,84,56,85,61,85,66,84,72,83,76,80,87,79,91,78,97,78,103,79,108,81,112,83,115,86,118,0,55,90,58,82,65,82,82,111,32,64,82,81,111,32,63,82,82,114,32,90,34,86,74,82,114,0,67,97,93,46,92,46,91,47,91,48,92,49,93,49,94,48,94,46,93,44,91,43,89,43,87,44,85,46,84,48,83,51,82,58,81,74,81,106,80,115,79,118,32,92,47,92,48,93,48,93,47,92,47,32,82,58,82,106,32,85,46,84,49,83,58,83,90,82,106,81,113,80,116,79,118,77,120,75,121,73,121,71,120,70,118,70,116,71,115,72,115,73,116,73,117,72,118,71,118,32,71,116,71,117,72,117,72,116,71,116,0,72,92,82,70,74,91,32,82,73,75,91,74,91,32,82,73,89,91,90,91,32,82,70,90,91,32,77,85,87,85,32,76,86,88,86,0,72,92,76,70,76,91,32,77,71,77,90,32,76,70,84,70,87,71,88,72,89,74,89,77,88,79,87,80,84,81,32,77,71,84,71,87,72,88,74,88,77,87,79,84,80,32,77,80,84,80,87,81,88,82,89,84,89,87,88,89,87,90,84,91,76,91,32,77,81,84,81,87,82,88,84,88,87,87,89,84,90,77,90,0,72,93,90,75,89,73,87,71,85,70,81,70,79,71,77,73,76,75,75,78,75,83,76,86,77,88,79,90,81,91,85,91,87,90,89,88,90,86,32,90,75,89,75,88,73,87,72,85,71,81,71,79,72,77,75,76,78,76,83,77,86,79,89,81,90,85,90,87,89,88,88,89,86,90,86,0,72,93,76,70,76,91,32,77,71,77,90,32,76,70,83,70,86,71,88,73,89,75,90,78,90,83,89,86,88,88,86,90,83,91,76,91,32,77,71,83,71,86,72,87,73,88,75,89,78,89,83,88,86,87,88,86,89,83,90,77,90,0,73,92,77,70,77,91,32,78,71,78,90,32,77,70,89,70,32,78,71,89,71,89,70,32,78,80,84,80,84,81,32,78,81,84,81,32,78,90,89,90,89,91,32,77,91,89,91,0,73,91,77,70,77,91,32,78,71,78,91,77,91,32,77,70,89,70,32,78,71,89,71,89,70,32,78,80,84,80,84,81,32,78,81,84,81,0,72,93,90,75,89,73,87,71,85,70,81,70,79,71,77,73,76,75,75,78,75,83,76,86,77,88,79,90,81,91,85,91,87,90,89,88,90,86,90,82,85,82,32,90,75,89,75,88,73,87,72,85,71,81,71,79,72,78,73,77,75,76,78,76,83,77,86,78,88,79,89,81,90,85,90,87,89,88,88,89,86,89,83,85,83,85,82,0,71,93,75,70,75,91,32,75,70,76,70,76,91,75,91,32,89,70,88,70,88,91,89,91,32,89,70,89,91,32,76,80,88,80,32,76,81,88,81,0,78,87,82,70,82,91,83,91,32,82,70,83,70,83,91,0,74,91,86,70,86,86,85,89,83,90,81,90,79,89,78,86,77,86,32,86,70,87,70,87,86,86,89,85,90,83,91,81,91,79,90,78,89,77,86,0,72,93,76,70,76,91,77,91,32,76,70,77,70,77,91,32,90,70,89,70,77,82,32,90,70,77,83,32,80,79,89,91,90,91,32,81,79,90,91,0,73,90,77,70,77,91,32,77,70,78,70,78,90,32,78,90,89,90,89,91,32,77,91,89,91,0,70,94,74,70,74,91,32,75,75,75,91,74,91,32,75,75,82,91,32,74,70,82,88,32,90,70,82,88,32,89,75,82,91,32,89,75,89,91,90,91,32,90,70,90,91,0,71,93,75,70,75,91,32,76,73,76,91,75,91,32,76,73,89,91,32,75,70,88,88,32,88,70,88,88,32,88,70,89,70,89,91,0,71,93,80,70,78,71,76,73,75,75,74,78,74,83,75,86,76,88,78,90,80,91,84,91,86,90,88,88,89,86,90,83,90,78,89,75,88,73,86,71,84,70,80,70,32,81,71,78,72,76,75,75,78,75,83,76,86,78,89,81,90,83,90,86,89,88,86,89,83,89,78,88,75,86,72,83,71,81,71,0,72,92,76,70,76,91,32,77,71,77,91,76,91,32,76,70,85,70,87,71,88,72,89,74,89,77,88,79,87,80,85,81,77,81,32,77,71,85,71,87,72,88,74,88,77,87,79,85,80,77,80,0,71,93,80,70,78,71,76,73,75,75,74,78,74,83,75,86,76,88,78,90,80,91,84,91,86,90,88,88,89,86,90,83,90,78,89,75,88,73,86,71,84,70,80,70,32,81,71,78,72,76,75,75,78,75,83,76,86,78,89,81,90,83,90,86,89,88,86,89,83,89,78,88,75,86,72,83,71,81,71,32,83,88,88,93,89,93,32,83,88,84,88,89,93,0,72,92,76,70,76,91,32,77,71,77,91,76,91,32,76,70,84,70,87,71,88,72,89,74,89,77,88,79,87,80,84,81,77,81,32,77,71,84,71,87,72,88,74,88,77,87,79,84,80,77,80,32,82,81,88,91,89,91,32,83,81,89,91,0,72,92,89,73,87,71,84,70,80,70,77,71,75,73,75,75,76,77,77,78,79,79,84,81,86,82,87,83,88,85,88,88,87,89,84,90,80,90,78,89,77,88,75,88,32,89,73,87,73,86,72,84,71,80,71,77,72,76,73,76,75,77,77,79,78,84,80,86,81,88,83,89,85,89,88,87,90,84,91,80,91,77,90,75,88,0,74,91,82,71,82,91,32,83,71,83,91,82,91,32,76,70,89,70,89,71,32,76,70,76,71,89,71,0,71,93,75,70,75,85,76,88,78,90,81,91,83,91,86,90,88,88,89,85,89,70,32,75,70,76,70,76,85,77,88,78,89,81,90,83,90,86,89,87,88,88,85,88,70,89,70,0,72,92,74,70,82,91,32,74,70,75,70,82,88,32,90,70,89,70,82,88,32,90,70,82,91,0,69,95,71,70,77,91,32,71,70,72,70,77,88,32,82,70,77,88,32,82,73,77,91,32,82,73,87,91,32,82,70,87,88,32,93,70,92,70,87,88,32,93,70,87,91,0,72,92,75,70,88,91,89,91,32,75,70,76,70,89,91,32,89,70,88,70,75,91,32,89,70,76,91,75,91,0,73,92,75,70,82,80,82,91,83,91,32,75,70,76,70,83,80,32,90,70,89,70,82,80,32,90,70,83,80,83,91,0,72,92,88,70,75,91,32,89,70,76,91,32,75,70,89,70,32,75,70,75,71,88,71,32,76,90,89,90,89,91,32,75,91,89,91,0,69,92,88,70,86,72,84,75,81,80,79,83,76,87,73,90,71,91,69,91,68,90,68,88,69,87,70,88,69,89,32,88,70,87,74,85,84,84,91,32,88,70,85,91,32,84,91,84,89,83,86,82,84,80,82,78,81,76,81,75,82,75,84,76,87,79,90,82,91,86,91,88,90,0,70,94,85,71,84,72,83,74,81,79,79,85,78,87,76,90,74,91,32,84,72,83,75,81,83,80,86,79,88,77,90,74,91,72,91,71,90,71,88,72,87,73,88,72,89,32,79,76,78,78,77,79,75,79,74,78,74,76,75,74,77,72,79,71,82,70,88,70,90,71,91,73,91,75,90,77,88,78,84,79,82,79,32,88,70,89,71,90,73,90,75,89,77,88,78,32,84,79,87,80,88,81,89,83,89,86,88,89,87,90,85,91,83,91,82,90,82,88,83,85,32,84,79,86,80,87,81,88,83,88,86,87,89,85,91,0,72,93,75,72,74,74,74,76,75,78,78,79,81,79,85,78,87,77,89,75,90,73,90,71,89,70,87,70,84,71,81,74,79,77,77,81,76,85,76,88,77,90,80,91,82,91,85,90,87,88,88,86,88,84,87,82,85,82,83,83,82,85,32,87,70,85,71,82,74,80,77,78,81,77,85,77,88,78,90,80,91,0,70,93,85,71,84,72,83,74,81,79,79,85,78,87,76,90,74,91,32,84,72,83,75,81,83,80,86,79,88,77,90,74,91,72,91,71,90,71,88,72,87,74,87,76,88,78,90,80,91,83,91,85,90,87,88,89,84,90,79,90,76,89,73,87,71,85,70,80,70,77,71,75,73,74,75,74,77,75,78,77,78,78,77,79,75,0,73,92,87,73,86,74,86,76,87,77,89,77,90,75,90,73,89,71,87,70,84,70,82,71,81,72,80,74,80,76,81,78,83,79,32,84,70,82,72,81,74,81,77,83,79,32,83,79,81,79,78,80,76,82,75,84,75,87,76,89,77,90,79,91,82,91,85,90,87,88,88,86,88,84,87,82,85,82,83,83,82,85,32,81,79,79,80,77,82,76,84,76,88,77,90,0,71,92,87,72,86,74,84,79,82,85,81,87,79,90,77,91,32,81,76,80,78,78,79,76,79,75,77,75,75,76,73,78,71,81,70,91,70,88,71,87,72,86,75,84,83,83,86,82,88,80,90,77,91,75,91,73,90,72,89,72,88,73,87,74,88,73,89,32,83,70,87,71,88,71,32,79,83,80,82,82,81,86,81,88,80,90,77,88,84,0,71,93,74,73,73,75,73,77,74,79,76,80,79,80,82,79,84,78,87,75,88,72,88,71,87,70,86,70,84,71,82,73,81,75,80,78,80,81,81,83,83,84,85,84,87,83,89,81,90,79,32,87,70,85,71,83,73,82,75,81,78,81,82,83,84,32,90,79,89,83,87,87,85,89,83,90,79,91,76,91,74,90,73,88,73,87,74,86,75,87,74,88,32,89,83,87,86,85,88,82,90,79,91,0,70,94,76,76,75,75,75,73,76,71,79,70,82,70,79,81,77,87,76,89,75,90,73,91,71,91,70,90,70,88,71,87,72,88,71,89,32,82,70,79,79,78,82,76,87,75,89,73,91,32,74,84,75,83,77,82,86,79,88,78,91,76,93,74,94,72,94,71,93,70,92,70,90,71,88,74,87,76,85,82,84,86,84,89,86,91,87,91,89,90,91,88,32,92,70,90,72,88,76,86,82,85,86,85,89,86,91,0,73,89,87,72,85,75,83,80,81,85,80,87,78,90,76,91,32,89,76,87,78,84,79,81,79,79,78,78,76,78,74,79,72,81,71,85,70,89,70,87,72,86,74,84,80,82,86,81,88,79,90,76,91,74,91,73,90,73,88,74,87,75,88,74,89,0,73,90,89,70,87,72,85,75,83,80,80,89,78,93,32,89,77,87,79,84,80,81,80,79,79,78,77,78,75,79,73,81,71,85,70,89,70,87,73,86,75,83,84,81,88,80,90,78,93,77,94,75,95,74,94,74,92,75,90,77,88,79,87,82,86,86,85,0,70,94,76,76,75,75,75,73,77,71,80,70,82,70,79,81,77,87,76,89,75,90,73,91,71,91,70,90,70,88,71,87,72,88,71,89,32,82,70,79,79,78,82,76,87,75,89,73,91,32,90,71,87,75,85,77,83,78,80,79,32,93,71,92,72,93,73,94,72,94,71,93,70,92,70,90,71,87,76,86,77,84,78,80,79,32,80,79,83,80,84,82,85,89,86,91,32,80,79,82,80,83,82,84,89,86,91,87,91,89,90,91,88,0,73,91,77,73,76,75,76,77,77,79,79,80,82,80,85,79,87,78,90,75,91,72,91,71,90,70,89,70,87,71,86,72,84,75,80,85,79,87,77,90,75,91,32,86,72,84,76,82,83,81,86,80,88,78,90,75,91,73,91,72,90,72,88,73,87,75,87,77,88,80,90,82,91,85,91,87,90,89,88,0,68,96,82,70,78,79,75,85,73,88,71,90,69,91,67,91,66,90,66,88,67,87,68,88,67,89,32,82,70,80,77,79,81,78,86,78,90,80,91,32,82,70,81,74,80,79,79,86,79,90,80,91,32,91,70,87,79,82,88,80,91,32,91,70,89,77,88,81,87,86,87,90,89,91,90,91,92,90,94,88,32,91,70,90,74,89,79,88,86,88,90,89,91,0,71,94,82,70,81,74,79,80,77,85,76,87,74,90,72,91,70,91,69,90,69,88,70,87,71,88,70,89,32,82,70,82,75,83,86,84,91,32,82,70,83,75,84,86,84,91,32,96,71,95,72,96,73,97,72,97,71,96,70,94,70,92,71,90,74,89,76,87,81,85,87,84,91,0,72,93,83,70,81,71,79,73,77,76,76,78,75,82,75,86,76,89,77,90,79,91,81,91,84,90,86,88,88,85,89,83,90,79,90,75,89,72,88,71,87,71,85,72,83,74,81,78,80,83,80,86,32,81,71,79,74,77,78,76,82,76,86,77,89,79,91,0,70,93,85,71,84,72,83,74,81,79,79,85,78,87,76,90,74,91,32,84,72,83,75,81,83,80,86,79,88,77,90,74,91,72,91,71,90,71,88,72,87,73,88,72,89,32,79,76,78,78,77,79,75,79,74,78,74,76,75,74,77,72,79,71,82,70,86,70,89,71,90,72,91,74,91,77,90,79,89,80,86,81,84,81,82,80,32,86,70,88,71,89,72,90,74,90,77,89,79,88,80,86,81,0,72,93,85,74,85,76,84,78,83,79,81,80,79,80,78,78,78,76,79,73,81,71,84,70,87,70,89,71,90,73,90,77,89,80,87,83,83,87,80,89,78,90,75,91,73,91,72,90,72,88,73,87,75,87,77,88,80,90,83,91,86,91,88,90,90,88,32,87,70,88,71,89,73,89,77,88,80,86,83,83,86,79,89,75,91,0,70,94,85,71,84,72,83,74,81,79,79,85,78,87,76,90,74,91,32,84,72,83,75,81,83,80,86,79,88,77,90,74,91,72,91,71,90,71,88,72,87,73,88,72,89,32,79,76,78,78,77,79,75,79,74,78,74,76,75,74,77,72,79,71,82,70,87,70,90,71,91,73,91,75,90,77,89,78,86,79,82,79,32,87,70,89,71,90,73,90,75,89,77,88,78,86,79,32,82,79,85,80,86,82,87,89,88,91,32,82,79,84,80,85,82,86,89,88,91,89,91,91,90,93,88,0,72,92,78,73,77,75,77,77,78,79,80,80,83,80,86,79,88,78,91,75,92,72,92,71,91,70,90,70,88,71,87,72,86,74,85,77,83,84,82,87,80,90,78,91,32,86,74,85,78,84,85,83,88,81,90,78,91,75,91,73,90,72,88,72,87,73,86,74,87,73,88,0,73,91,89,72,88,74,86,79,84,85,83,87,81,90,79,91,32,83,76,82,78,80,79,78,79,77,77,77,75,78,73,80,71,83,70,92,70,90,71,89,72,88,75,86,83,85,86,84,88,82,90,79,91,77,91,75,90,74,89,74,88,75,87,76,88,75,89,32,85,70,89,71,90,71,0,71,93,72,74,74,71,76,70,77,70,79,72,79,75,78,78,75,86,75,89,76,91,32,77,70,78,72,78,75,75,83,74,86,74,89,76,91,78,91,80,90,83,87,85,84,86,82,32,90,70,86,82,85,86,85,89,87,91,88,91,90,90,92,88,32,91,70,87,82,86,86,86,89,87,91,0,71,92,72,74,74,71,76,70,77,70,79,72,79,75,78,79,76,86,76,89,77,91,32,77,70,78,72,78,75,76,82,75,86,75,89,77,91,78,91,81,90,84,87,86,84,88,80,89,77,90,73,90,71,89,70,88,70,87,71,86,73,86,76,87,78,89,80,91,81,93,81,0,70,93,73,76,72,76,71,75,71,73,72,71,74,70,78,70,77,72,76,76,75,85,74,91,32,76,76,76,85,75,91,32,86,70,84,72,82,76,79,85,77,89,75,91,32,86,70,85,72,84,76,83,85,82,91,32,84,76,84,85,83,91,32,96,70,94,71,92,73,90,76,87,85,85,89,83,91,0,72,92,80,75,79,76,77,76,76,75,76,73,77,71,79,70,81,70,83,71,84,73,84,76,83,80,81,85,79,88,77,90,74,91,72,91,71,90,71,88,72,87,73,88,72,89,32,81,70,82,71,83,73,83,76,82,80,80,85,78,88,76,90,74,91,32,93,71,92,72,93,73,94,72,94,71,93,70,91,70,89,71,87,73,85,76,83,80,82,85,82,88,83,90,84,91,85,91,87,90,89,88,0,71,93,74,74,76,71,78,70,79,70,81,71,81,73,79,79,79,82,80,84,32,79,70,80,71,80,73,78,79,78,82,80,84,82,84,85,83,87,81,89,78,90,76,32,92,70,90,76,87,84,85,88,32,93,70,91,76,89,81,87,85,85,88,83,90,80,91,76,91,74,90,73,88,73,87,74,86,75,87,74,88,0,71,92,90,72,89,74,87,79,86,82,85,84,83,87,81,89,79,90,76,91,32,83,76,82,78,80,79,78,79,77,77,77,75,78,73,80,71,83,70,93,70,91,71,90,72,89,75,88,79,86,85,84,88,81,90,76,91,72,91,71,90,71,88,72,87,74,87,76,88,79,90,81,91,84,91,87,90,89,88,32,86,70,90,71,91,71,0,72,92,87,77,87,91,88,91,32,87,77,88,77,88,91,32,87,80,85,78,83,77,80,77,78,78,76,80,75,83,75,85,76,88,78,90,80,91,83,91,85,90,87,88,32,87,80,83,78,80,78,78,79,77,80,76,83,76,85,77,88,78,89,80,90,83,90,87,88,0,72,92,76,70,76,91,77,91,32,76,70,77,70,77,91,32,77,80,79,78,81,77,84,77,86,78,88,80,89,83,89,85,88,88,86,90,84,91,81,91,79,90,77,88,32,77,80,81,78,84,78,86,79,87,80,88,83,88,85,87,88,86,89,84,90,81,90,77,88,0,73,91,88,80,86,78,84,77,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,84,91,86,90,88,88,32,88,80,87,81,86,79,84,78,81,78,79,79,78,80,77,83,77,85,78,88,79,89,81,90,84,90,86,89,87,87,88,88,0,72,92,87,70,87,91,88,91,32,87,70,88,70,88,91,32,87,80,85,78,83,77,80,77,78,78,76,80,75,83,75,85,76,88,78,90,80,91,83,91,85,90,87,88,32,87,80,83,78,80,78,78,79,77,80,76,83,76,85,77,88,78,89,80,90,83,90,87,88,0,73,91,77,84,88,84,88,81,87,79,86,78,84,77,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,84,91,86,90,88,88,32,77,83,87,83,87,81,86,79,84,78,81,78,79,79,78,80,77,83,77,85,78,88,79,89,81,90,84,90,86,89,87,87,88,88,0,76,90,87,70,85,70,83,71,82,74,82,91,83,91,32,87,70,87,71,85,71,83,72,32,84,71,83,74,83,91,32,79,77,86,77,86,78,32,79,77,79,78,86,78,0,72,92,88,77,87,77,87,92,86,95,85,96,83,97,81,97,79,96,78,95,76,95,32,88,77,88,92,87,95,85,97,83,98,80,98,78,97,76,95,32,87,80,85,78,83,77,80,77,78,78,76,80,75,83,75,85,76,88,78,90,80,91,83,91,85,90,87,88,32,87,80,83,78,80,78,78,79,77,80,76,83,76,85,77,88,78,89,80,90,83,90,87,88,0,72,92,76,70,76,91,77,91,32,76,70,77,70,77,91,32,77,81,80,78,82,77,85,77,87,78,88,81,88,91,32,77,81,80,79,82,78,84,78,86,79,87,81,87,91,88,91,0,78,87,82,70,81,71,81,72,82,73,83,73,84,72,84,71,83,70,82,70,32,82,71,82,72,83,72,83,71,82,71,32,82,77,82,91,83,91,32,82,77,83,77,83,91,0,78,87,82,70,81,71,81,72,82,73,83,73,84,72,84,71,83,70,82,70,32,82,71,82,72,83,72,83,71,82,71,32,82,77,82,98,83,98,32,82,77,83,77,83,98,0,72,91,76,70,76,91,77,91,32,76,70,77,70,77,91,32,88,77,87,77,77,87,32,88,77,77,88,32,80,84,86,91,88,91,32,81,83,88,91,0,67,98,71,77,71,91,72,91,32,71,77,72,77,72,91,32,72,81,75,78,77,77,80,77,82,78,83,81,83,91,32,72,81,75,79,77,78,79,78,81,79,82,81,82,91,83,91,32,83,81,86,78,88,77,91,77,93,78,94,81,94,91,32,83,81,86,79,88,78,90,78,92,79,93,81,93,91,94,91,0,72,92,76,77,76,91,77,91,32,76,77,77,77,77,91,32,77,81,80,78,82,77,85,77,87,78,88,81,88,91,32,77,81,80,79,82,78,84,78,86,79,87,81,87,91,88,91,0,73,92,81,77,79,78,77,80,76,83,76,85,77,88,79,90,81,91,84,91,86,90,88,88,89,85,89,83,88,80,86,78,84,77,81,77,32,81,78,79,79,78,80,77,83,77,85,78,88,79,89,81,90,84,90,86,89,87,88,88,85,88,83,87,80,86,79,84,78,81,78,0,72,92,76,77,76,98,77,98,32,76,77,77,77,77,98,32,77,80,79,78,81,77,84,77,86,78,88,80,89,83,89,85,88,88,86,90,84,91,81,91,79,90,77,88,32,77,80,81,78,84,78,86,79,87,80,88,83,88,85,87,88,86,89,84,90,81,90,77,88,0,72,92,87,77,87,98,88,98,32,87,77,88,77,88,98,32,87,80,85,78,83,77,80,77,78,78,76,80,75,83,75,85,76,88,78,90,80,91,83,91,85,90,87,88,32,87,80,83,78,80,78,78,79,77,80,76,83,76,85,77,88,78,89,80,90,83,90,87,88,0,75,89,79,77,79,91,80,91,32,79,77,80,77,80,91,32,80,83,81,80,83,78,85,77,88,77,32,80,83,81,81,83,79,85,78,88,78,88,77,0,74,91,88,80,87,78,84,77,81,77,78,78,77,80,78,82,80,83,85,85,87,86,32,86,85,87,87,87,88,86,90,32,87,89,84,90,81,90,78,89,32,79,90,78,88,77,88,32,88,80,87,80,86,78,32,87,79,84,78,81,78,78,79,32,79,78,78,80,79,82,32,78,81,80,82,85,84,87,85,88,87,88,88,87,90,84,91,81,91,78,90,77,88,0,77,88,82,70,82,91,83,91,32,82,70,83,70,83,91,32,79,77,86,77,86,78,32,79,77,79,78,86,78,0,72,92,76,77,76,87,77,90,79,91,82,91,84,90,87,87,32,76,77,77,77,77,87,78,89,80,90,82,90,84,89,87,87,32,87,77,87,91,88,91,32,87,77,88,77,88,91,0,74,90,76,77,82,91,32,76,77,77,77,82,89,32,88,77,87,77,82,89,32,88,77,82,91,0,70,94,73,77,78,91,32,73,77,74,77,78,88,32,82,77,78,88,32,82,80,78,91,32,82,80,86,91,32,82,77,86,88,32,91,77,90,77,86,88,32,91,77,86,91,0,73,91,76,77,87,91,88,91,32,76,77,77,77,88,91,32,88,77,87,77,76,91,32,88,77,77,91,76,91,0,74,90,76,77,82,91,32,76,77,77,77,82,89,32,88,77,87,77,82,89,78,98,32,88,77,82,91,79,98,78,98,0,73,91,86,78,76,91,32,88,77,78,90,32,76,77,88,77,32,76,77,76,78,86,78,32,78,90,88,90,88,91,32,76,91,88,91,0,75,91,85,85,84,83,82,82,80,82,78,83,77,84,76,86,76,88,77,90,79,91,81,91,83,90,84,88,32,80,82,78,84,77,86,77,89,79,91,32,86,82,84,88,84,90,86,91,88,90,89,89,91,86,32,87,82,85,88,85,90,86,91,0,76,90,76,86,78,83,80,79,32,83,70,77,88,77,90,79,91,80,91,82,90,84,88,85,85,85,82,86,86,87,87,88,87,90,86,32,84,70,78,88,78,90,79,91,0,76,88,84,83,83,84,84,84,84,83,83,82,81,82,79,83,78,84,77,86,77,88,78,90,80,91,83,91,86,89,88,86,32,81,82,79,84,78,86,78,89,80,91,0,75,91,85,85,84,83,82,82,80,82,78,83,77,84,76,86,76,88,77,90,79,91,81,91,83,90,84,88,32,80,82,78,84,77,86,77,89,79,91,32,90,70,84,88,84,90,86,91,88,90,89,89,91,86,32,91,70,85,88,85,90,86,91,0,76,88,79,89,81,88,82,87,83,85,83,83,82,82,81,82,79,83,78,84,77,86,77,88,78,90,80,91,83,91,86,89,88,86,32,81,82,79,84,78,86,78,89,80,91,0,79,88,82,82,85,79,87,76,88,73,88,71,87,70,85,71,84,73,75,100,75,102,76,103,78,102,79,99,80,90,81,91,83,91,85,90,86,89,88,86,32,84,73,83,78,82,82,79,91,77,96,75,100,0,75,91,85,85,84,83,82,82,80,82,78,83,77,84,76,86,76,88,77,90,79,91,81,91,83,90,84,88,32,80,82,78,84,77,86,77,89,79,91,32,86,82,80,100,32,87,82,84,91,82,96,80,100,79,102,77,103,76,102,76,100,77,97,79,95,82,93,86,91,89,89,91,86,0,76,91,76,86,78,83,80,79,32,83,70,76,91,32,84,70,77,91,32,79,85,81,83,83,82,84,82,86,83,86,85,85,88,85,90,86,91,32,84,82,85,83,85,85,84,88,84,90,86,91,88,90,89,89,91,86,0,78,86,83,76,82,77,83,78,84,77,83,76,32,81,82,79,88,79,90,81,91,83,90,84,89,86,86,32,82,82,80,88,80,90,81,91,0,78,86,83,76,82,77,83,78,84,77,83,76,32,81,82,75,100,32,82,82,79,91,77,96,75,100,74,102,72,103,71,102,71,100,72,97,74,95,77,93,81,91,84,89,86,86,0,76,90,76,86,78,83,80,79,32,83,70,76,91,32,84,70,77,91,32,85,82,85,83,86,83,85,82,84,82,82,84,79,85,32,79,85,82,86,83,90,84,91,32,79,85,81,86,82,90,84,91,85,91,88,89,90,86,0,78,86,78,86,80,83,82,79,32,85,70,79,88,79,90,81,91,83,90,84,89,86,86,32,86,70,80,88,80,90,81,91,0,69,94,69,86,71,83,73,82,75,83,75,85,73,91,32,73,82,74,83,74,85,72,91,32,75,85,77,83,79,82,80,82,82,83,82,85,80,91,32,80,82,81,83,81,85,79,91,32,82,85,84,83,86,82,87,82,89,83,89,85,88,88,88,90,89,91,32,87,82,88,83,88,85,87,88,87,90,89,91,91,90,92,89,94,86,0,73,91,73,86,75,83,77,82,79,83,79,85,77,91,32,77,82,78,83,78,85,76,91,32,79,85,81,83,83,82,84,82,86,83,86,85,85,88,85,90,86,91,32,84,82,85,83,85,85,84,88,84,90,86,91,88,90,89,89,91,86,0,75,89,82,82,80,82,78,83,77,84,76,86,76,88,77,90,79,91,81,91,83,90,84,89,85,87,85,85,84,83,82,82,81,83,81,85,82,87,84,88,86,88,88,87,89,86,32,80,82,78,84,77,86,77,89,79,91,0,76,91,76,86,78,83,80,79,32,81,76,72,103,32,82,76,73,103,32,79,85,81,83,83,82,84,82,86,83,86,85,85,88,85,90,86,91,32,84,82,85,83,85,85,84,88,84,90,86,91,88,90,89,89,91,86,0,75,91,85,85,84,83,82,82,80,82,78,83,77,84,76,86,76,88,77,90,79,91,81,91,83,90,32,80,82,78,84,77,86,77,89,79,91,32,86,82,80,100,80,102,81,103,83,102,84,99,84,91,86,91,89,89,91,86,32,87,82,84,91,82,96,80,100,0,76,90,76,86,78,83,80,82,82,83,82,85,80,91,32,80,82,81,83,81,85,79,91,32,82,85,84,83,86,82,87,82,86,85,32,86,82,86,85,87,87,88,87,90,86,0,78,90,78,86,80,83,81,81,81,83,84,85,85,87,85,89,84,90,82,91,32,81,83,83,85,84,87,84,89,82,91,32,78,90,80,91,85,91,88,89,90,86,0,78,86,78,86,80,83,82,79,32,85,70,79,88,79,90,81,91,83,90,84,89,86,86,32,86,70,80,88,80,90,81,91,32,80,78,86,78,0,75,91,78,82,76,88,76,90,78,91,79,91,81,90,83,88,85,85,32,79,82,77,88,77,90,78,91,32,86,82,84,88,84,90],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+307201);allocate([86,91,88,90,89,89,91,86,32,87,82,85,88,85,90,86,91,0,75,90,78,82,77,84,76,87,76,90,78,91,79,91,82,90,84,88,85,85,85,82,32,79,82,78,84,77,87,77,90,78,91,32,85,82,86,86,87,87,88,87,90,86,0,72,93,76,82,74,84,73,87,73,90,75,91,76,91,78,90,80,88,32,77,82,75,84,74,87,74,90,75,91,32,82,82,80,88,80,90,82,91,83,91,85,90,87,88,88,85,88,82,32,83,82,81,88,81,90,82,91,32,88,82,89,86,90,87,91,87,93,86,0,74,90,74,86,76,83,78,82,80,82,81,83,81,85,80,88,79,90,77,91,76,91,75,90,75,89,76,89,75,90,32,87,83,86,84,87,84,87,83,86,82,85,82,83,83,82,85,81,88,81,90,82,91,85,91,88,89,90,86,32,81,83,82,85,32,83,83,81,85,32,80,88,81,90,32,81,88,79,90,0,75,91,78,82,76,88,76,90,78,91,79,91,81,90,83,88,85,85,32,79,82,77,88,77,90,78,91,32,86,82,80,100,32,87,82,84,91,82,96,80,100,79,102,77,103,76,102,76,100,77,97,79,95,82,93,86,91,89,89,91,86,0,76,89,76,86,78,83,80,82,82,82,84,83,84,86,83,88,80,90,78,91,32,82,82,83,83,83,86,82,88,80,90,32,78,91,80,92,81,94,81,97,80,100,78,102,76,103,75,102,75,100,76,97,79,94,82,92,86,89,89,86,32,78,91,79,92,80,94,80,97,79,100,78,102,0,72,92,81,70,78,71,76,74,75,79,75,82,76,87,78,90,81,91,83,91,86,90,88,87,89,82,89,79,88,74,86,71,83,70,81,70,32,79,71,77,74,76,79,76,82,77,87,79,90,32,78,89,81,90,83,90,86,89,32,85,90,87,87,88,82,88,79,87,74,85,71,32,86,72,83,71,81,71,78,72,0,72,92,78,74,80,73,83,70,83,91,32,78,74,78,75,80,74,82,72,82,91,83,91,0,72,92,76,75,76,74,77,72,78,71,80,70,84,70,86,71,87,72,88,74,88,76,87,78,85,81,76,91,32,76,75,77,75,77,74,78,72,80,71,84,71,86,72,87,74,87,76,86,78,84,81,75,91,32,76,90,89,90,89,91,32,75,91,89,91,0,72,92,77,70,88,70,81,79,32,77,70,77,71,87,71,32,87,70,80,79,32,81,78,83,78,86,79,88,81,89,84,89,85,88,88,86,90,83,91,80,91,77,90,76,89,75,87,76,87,32,80,79,83,79,86,80,88,83,32,84,79,87,81,88,84,88,85,87,88,84,90,32,88,86,86,89,83,90,80,90,77,89,76,87,32,79,90,76,88,0,72,92,85,73,85,91,86,91,32,86,70,86,91,32,86,70,75,86,90,86,32,85,73,76,86,32,76,85,90,85,90,86,0,72,92,77,70,76,79,32,78,71,77,78,32,77,70,87,70,87,71,32,78,71,87,71,32,77,78,80,77,83,77,86,78,88,80,89,83,89,85,88,88,86,90,83,91,80,91,77,90,76,89,75,87,76,87,32,76,79,77,79,79,78,83,78,86,79,88,82,32,84,78,87,80,88,83,88,85,87,88,84,90,32,88,86,86,89,83,90,80,90,77,89,76,87,32,79,90,76,88,0,72,92,86,71,87,73,88,73,87,71,84,70,82,70,79,71,77,74,76,79,76,84,77,88,79,90,82,91,83,91,86,90,88,88,89,85,89,84,88,81,86,79,83,78,82,78,79,79,77,81,32,87,72,84,71,82,71,79,72,32,80,71,78,74,77,79,77,84,78,88,81,90,32,77,86,79,89,82,90,83,90,86,89,88,86,32,84,90,87,88,88,85,88,84,87,81,84,79,32,88,83,86,80,83,79,82,79,79,80,77,83,32,81,79,78,81,77,84,0,72,92,75,70,89,70,79,91,32,75,70,75,71,88,71,32,88,70,78,91,79,91,0,72,92,80,70,77,71,76,73,76,75,77,77,78,78,80,79,84,80,86,81,87,82,88,84,88,87,87,89,84,90,80,90,77,89,76,87,76,84,77,82,78,81,80,80,84,79,86,78,87,77,88,75,88,73,87,71,84,70,80,70,32,78,71,77,73,77,75,78,77,80,78,84,79,86,80,88,82,89,84,89,87,88,89,87,90,84,91,80,91,77,90,76,89,75,87,75,84,76,82,78,80,80,79,84,78,86,77,87,75,87,73,86,71,32,87,72,84,71,80,71,77,72,32,76,88,79,90,32,85,90,88,88,0,72,92,87,80,85,82,82,83,81,83,78,82,76,80,75,77,75,76,76,73,78,71,81,70,82,70,85,71,87,73,88,77,88,82,87,87,85,90,82,91,80,91,77,90,76,88,77,88,78,90,32,87,77,86,80,83,82,32,87,78,85,81,82,82,81,82,78,81,76,78,32,80,82,77,80,76,77,76,76,77,73,80,71,32,76,75,78,72,81,71,82,71,85,72,87,75,32,83,71,86,73,87,77,87,82,86,87,84,90,32,85,89,82,90,80,90,77,89,0,77,88,82,88,81,89,81,90,82,91,83,91,84,90,84,89,83,88,82,88,32,82,89,82,90,83,90,83,89,82,89,0,77,88,84,90,83,91,82,91,81,90,81,89,82,88,83,88,84,89,84,92,83,94,81,95,32,82,89,82,90,83,90,83,89,82,89,32,83,91,84,92,32,84,90,83,94,0,77,88,82,77,81,78,81,79,82,80,83,80,84,79,84,78,83,77,82,77,32,82,78,82,79,83,79,83,78,82,78,32,82,88,81,89,81,90,82,91,83,91,84,90,84,89,83,88,82,88,32,82,89,82,90,83,90,83,89,82,89,0,77,88,82,77,81,78,81,79,82,80,83,80,84,79,84,78,83,77,82,77,32,82,78,82,79,83,79,83,78,82,78,32,84,90,83,91,82,91,81,90,81,89,82,88,83,88,84,89,84,92,83,94,81,95,32,82,89,82,90,83,90,83,89,82,89,32,83,91,84,92,32,84,90,83,94,0,77,88,82,70,82,84,83,84,32,82,70,83,70,83,84,32,82,88,81,89,81,90,82,91,83,91,84,90,84,89,83,88,82,88,32,82,89,82,90,83,90,83,89,82,89,0,73,92,76,75,76,74,77,72,78,71,81,70,84,70,87,71,88,72,89,74,89,76,88,78,87,79,85,80,82,81,32,76,75,77,75,77,74,78,72,81,71,84,71,87,72,88,74,88,76,87,78,85,79,82,80,32,77,73,80,71,32,85,71,88,73,32,88,77,84,80,32,82,80,82,84,83,84,83,80,32,82,88,81,89,81,90,82,91,83,91,84,90,84,89,83,88,82,88,32,82,89,82,90,83,90,83,89,82,89,0,77,88,84,70,82,71,81,73,81,76,82,77,83,77,84,76,84,75,83,74,82,74,81,75,32,82,75,82,76,83,76,83,75,82,75,32,82,71,81,75,32,81,73,82,74,0,77,88,84,72,83,73,82,73,81,72,81,71,82,70,83,70,84,71,84,74,83,76,81,77,32,82,71,82,72,83,72,83,71,82,71,32,83,73,84,74,32,84,72,83,76,0,70,95,92,77,90,77,88,78,87,80,85,86,84,88,83,89,81,90,77,90,75,89,74,87,74,85,75,83,76,82,81,79,83,77,84,75,84,73,83,71,81,70,80,70,78,71,77,73,77,75,78,78,80,81,85,87,88,90,90,91,92,91,32,92,77,92,78,90,78,87,80,32,90,77,88,80,86,86,85,88,83,90,81,91,77,91,75,90,74,89,73,87,73,85,74,83,76,81,81,78,82,77,83,75,83,73,82,71,32,83,72,81,71,80,71,78,72,32,79,71,78,73,78,75,79,78,81,81,86,87,88,89,90,90,92,90,92,91,0,73,92,82,66,82,95,83,95,32,82,66,83,66,83,95,32,87,73,89,73,87,71,84,70,81,70,78,71,76,73,76,75,77,77,78,78,86,82,87,83,88,85,88,87,87,89,84,90,81,90,79,89,78,88,32,87,73,86,72,84,71,81,71,78,72,77,73,77,75,78,77,86,81,88,83,89,85,89,87,88,89,87,90,84,91,81,91,78,90,76,88,78,88,32,88,88,85,90,0,71,94,91,66,73,98,74,98,32,91,66,92,66,74,98,0,75,89,85,66,83,68,81,71,79,75,78,80,78,84,79,89,81,93,83,96,85,98,86,98,32,85,66,86,66,84,68,82,71,80,75,79,80,79,84,80,89,82,93,84,96,86,98,0,75,89,78,66,80,68,82,71,84,75,85,80,85,84,84,89,82,93,80,96,78,98,79,98,32,78,66,79,66,81,68,83,71,85,75,86,80,86,84,85,89,83,93,81,96,79,98,0,74,90,82,70,81,71,83,81,82,82,32,82,70,82,82,32,82,70,83,71,81,81,82,82,32,77,73,78,73,86,79,87,79,32,77,73,87,79,32,77,73,77,74,87,78,87,79,32,87,73,86,73,78,79,77,79,32,87,73,77,79,32,87,73,87,74,77,78,77,79,0,70,95,74,81,91,81,91,82,32,74,81,74,82,91,82,0,70,95,82,73,82,90,83,90,32,82,73,83,73,83,90,32,74,81,91,81,91,82,32,74,81,74,82,91,82,0,70,95,74,77,91,77,91,78,32,74,77,74,78,91,78,32,74,85,91,85,91,86,32,74,85,74,86,91,86,0,78,87,83,70,82,71,82,77,32,83,71,82,77,32,83,70,84,71,82,77,0,73,91,78,70,77,71,77,77,32,78,71,77,77,32,78,70,79,71,77,77,32,87,70,86,71,86,77,32,87,71,86,77,32,87,70,88,71,86,77,0,75,89,81,70,79,71,78,73,78,75,79,77,81,78,83,78,85,77,86,75,86,73,85,71,83,70,81,70,32,81,70,78,73,79,77,83,78,86,75,85,71,81,70,32,83,70,79,71,78,75,81,78,85,77,86,73,83,70,0,70,94,90,73,74,82,90,91,32,90,73,90,74,76,82,90,90,90,91,0,70,94,74,73,90,82,74,91,32,74,73,74,74,88,82,74,90,74,91,0,71,94,79,70,79,98,80,98,32,79,70,80,70,80,98,32,85,70,85,98,86,98,32,85,70,86,70,86,98,32,74,80,91,80,91,81,32,74,80,74,81,91,81,32,74,87,91,87,91,88,32,74,87,74,88,91,88,0,70,94,91,70,89,71,86,72,83,72,80,71,78,70,76,70,74,71,73,73,73,75,75,77,77,77,79,76,80,74,80,72,78,70,32,91,70,72,91,73,91,32,91,70,92,70,73,91,32,89,84,87,84,85,85,84,87,84,89,86,91,88,91,90,90,91,88,91,86,89,84,32,78,70,74,71,73,75,77,77,80,74,78,70,32,76,70,73,73,75,77,79,76,80,72,76,70,32,89,84,85,85,84,89,88,91,91,88,89,84,32,87,84,84,87,86,91,90,90,91,86,87,84,0,69,96,87,77,84,75,81,75,79,76,78,77,77,79,77,82,78,84,79,85,81,86,84,86,87,84,32,87,77,84,76,81,76,79,77,78,79,78,82,79,84,81,85,84,85,87,84,32,86,75,86,83,87,85,89,86,90,86,92,85,93,83,93,79,92,76,91,74,89,72,87,71,84,70,81,70,78,71,76,72,74,74,73,76,72,79,72,82,73,85,74,87,76,89,78,90,81,91,85,91,89,90,32,86,75,87,75,87,83,88,85,90,86,32,89,86,91,85,92,83,92,79,91,76,90,74,89,73,87,72,84,71,81,71,78,72,76,73,75,74,74,76,73,79,73,82,74,85,75,87,76,88,78,89,81,90,85,90,89,89,89,90,0,69,95,74,80,76,79,78,79,80,80,83,84,84,85,86,86,88,86,90,85,91,83,91,81,90,79,88,78,86,78,84,79,83,80,80,84,78,85,76,85,74,84,32,90,80,88,79,86,79,84,80,81,84,80,85,78,86,76,86,74,85,73,83,73,81,74,79,76,78,78,78,80,79,81,80,84,84,86,85,88,85,90,84,32,75,79,74,81,74,83,75,85,32,89,85,90,83,90,81,89,79,0,72,93,84,70,81,71,79,73,77,76,76,79,75,83,75,86,76,89,77,90,79,91,81,91,84,90,86,88,88,85,89,82,90,78,90,75,89,72,88,71,86,70,84,70,32,84,70,82,71,80,73,78,76,77,79,76,83,76,86,77,89,79,91,32,81,91,83,90,85,88,87,85,88,82,89,78,89,75,88,72,86,70,0,72,93,84,74,79,91,32,86,70,80,91,32,86,70,83,73,80,75,78,76,32,85,73,81,75,78,76,0,72,93,79,74,80,75,79,76,78,75,78,74,79,72,80,71,83,70,86,70,89,71,90,73,90,75,89,77,87,79,84,81,80,83,77,85,75,87,73,91,32,86,70,88,71,89,73,89,75,88,77,86,79,80,83,32,74,89,75,88,77,88,82,90,85,90,87,89,88,87,32,77,88,82,91,85,91,87,90,88,87,0,72,93,79,74,80,75,79,76,78,75,78,74,79,72,80,71,83,70,86,70,89,71,90,73,90,75,89,77,86,79,83,80,32,86,70,88,71,89,73,89,75,88,77,86,79,32,81,80,83,80,86,81,87,82,88,84,88,87,87,89,86,90,83,91,79,91,76,90,75,89,74,87,74,86,75,85,76,86,75,87,32,83,80,85,81,86,82,87,84,87,87,86,89,85,90,83,91,0,72,93,88,71,82,91,32,89,70,83,91,32,89,70,74,85,90,85,0,72,93,81,70,76,80,32,81,70,91,70,32,81,71,86,71,91,70,32,76,80,77,79,80,78,83,78,86,79,87,80,88,82,88,85,87,88,85,90,82,91,79,91,76,90,75,89,74,87,74,86,75,85,76,86,75,87,32,83,78,85,79,86,80,87,82,87,85,86,88,84,90,82,91,0,72,93,89,73,88,74,89,75,90,74,90,73,89,71,87,70,84,70,81,71,79,73,77,76,76,79,75,83,75,87,76,89,77,90,79,91,82,91,85,90,87,88,88,86,88,83,87,81,86,80,84,79,81,79,79,80,77,82,76,84,32,84,70,82,71,80,73,78,76,77,79,76,83,76,88,77,90,32,82,91,84,90,86,88,87,86,87,82,86,80,0,72,93,78,70,76,76,32,91,70,90,73,88,76,83,82,81,85,80,87,79,91,32,88,76,82,82,80,85,79,87,78,91,32,77,73,80,70,82,70,87,73,32,78,72,80,71,82,71,87,73,89,73,90,72,91,70,0,72,93,83,70,80,71,79,72,78,74,78,77,79,79,81,80,84,80,88,79,89,78,90,76,90,73,89,71,86