c                                                                1/15/81
c***********************************************************************
c  stst -- test driver for sparse symmetric matrix package
c***********************************************************************
c
c  description
c
c    program stst tests the reordering and symmetric positive definite
c    matrix routines from the yale sparse matrix package.  the test
c    problem is a system of five-point finite-difference equations on an
c    ng by ng grid.
c
c
c  variables
c
c    ng  - size of the grid used to generate the test problem
c
c    n   - number of variables/equations (= ng x ng)
c
c    ia  - integer one-dimensional array containing pointers to delimit
c          rows in ja and a;  dimension = n+1
c
c    ja  - integer one-dimensional array containing the column indices
c          corresponding to the elements of a;  dimension = number of
c          nonzero entries in (the upper triangle of) m
c
c    a   - real one-dimensional array containing the nonzero entries in
c          (the upper triangle of) m, stored by rows;  dimension =
c          number of nonzero entries in (the upper triangle of) m
c
c    z   - real one-dimensional array containing the solution x;
c          dimension = n
c
c    b   - real one-dimensional array containing the right-hand-side b;
c          dimension = n
c
c    p   - integer one-dimensional array containing a permutation of
c          the rows and columns of m;  dimension = n
c
c    ip  - integer one-dimensional array containing the inverse of the
c          permutation stored in p;  dimension = n
c
c    nsp - declared dimension of the one-dimensional arrays isp and rsp
c
c    isp - integer one-dimensional array used as working storage
c          (equivalenced to rsp);  dimension = nsp
c
c    rsp - real one-dimensional array used as working storage
c          (equivalenced to isp);  dimension = nsp
c
c    esp - integer variable containing the amount of extra storage
c          available in isp/rsp
c
c-----------------------------------------------------------------------
c
        integer  ia(101), ja(500),  p(100), ip(100),  isp(1500), esp,
     *     case, path, flag,  aptr,vp,vq,  x,xmin,xmax,  y,ymin,ymax
        real  a(500), z(100), b(100),  rsp(1500),  sum, rms
c...    double precision  a(500), z(100), b(100),  rsp(1500),  sum, rms
        equivalence  (isp(1), rsp(1))
        data  nsp/1500/,  eps/1e-5/,  ng/3/
c
        index(i,j) = ng*i + j - ng
c
        n = ng*ng
c
c--case=1 => store entire coefficient matrix
c--case=2 => store upper triangle of coefficient matrix
      do 5 case=1,2
c
c----set up five-point finite-difference equations on ng by ng grid
c----for each grid point (i,j)=vp
        aptr = 1
        do 2 i=1,ng
        do 2 j=1,ng
          vp = index (i, j)
          ia(vp) = aptr
          b(vp) = 0
c
c------for each neighboring grid point (x,y)=vq
          xmin = max0 ( 1, i-1)
          xmax = min0 (ng, i+1)
          ymin = max0 ( 1, j-1)
          ymax = min0 (ng, j+1)
          do 1 x=xmin,xmax
          do 1 y=ymin,ymax
            if ((x-i) * (y-j) .ne. 0)  go to 1
              vq = index(x, y)
c
c--------insert m(vp,vq) in (ia,ja,a) structure and update b(vp) ...
              ja(aptr) = vq
              a(aptr) = 4
              if (vp .ne. vq)  a(aptr) = -1
              b(vp) = b(vp)  +  a(aptr) * vq
c
c--------... but do not store elements to left of diagonal if case=2
              if (vp.le.vq .or. case.ne.2)  aptr = aptr + 1
   1        continue
   2      continue
c
        ia(n+1) = aptr
        np1 = n+1
        nza = ia(n+1) - 1
c
c----output coefficient matrix m in (ia,ja,a) format
        if (case.eq.1)  write (6,101)  ng,ng
 101    format (50h1system of five-point finite-difference equations,
     *          4hon a, i2, 3h by, i2, 5h grid
     *         /37h   (entire coefficient matrix stored))
        if (case.eq.2)  write (6,102)  ng,ng
 102    format (50h1system of five-point finite-difference equations,
     *          4hon a, i2, 3h by, i2, 5h grid
     *         /48h   (upper triangle of coefficient matrix stored))
c
        write (6,103)  (i,ia(i), i=1,np1)
 103    format (//21h coefficient matrix m
     *          //5(10h     i  ia)
     *           /(5(i6, i4)))
        write (6,104)  (i,ja(i),a(i), i=1,nza)
 104    format ( /5(16h     i ja    a  )
     *           /(5(i6, i3, f7.2)))
        write (6,105)  (b(i), i=1,n)
 105    format (//18h right-hand side b
     *          //(5f12.5))
c
c----call odrv to find minimum degree ordering of variables/equations
        path = case
        call  odrv
     *     (n, ia,ja,a, p,ip, nsp,isp, path, flag)
        if (flag.ne.0)  go to 11
c
c----output ordering and symmetrically reordered (ia,ja,a)
        write (6,106)  (i,p(i),ip(i), i=1,n)
 106    format (//30h row/column ordering from odrv
     *          //5(12h     i  p ip)
     *           /(5(i6, i3, i3)))
c
        if (case.ne.2)  go to 3
        write (6,107)  (i,ia(i), i=1,np1)
 107    format (//35h symmetrically reordered (ia,ja,a)
     *          //5(10h     i  ia)
     *           /(5(i6, i4)))
        write (6,104)  (i,ja(i),a(i), i=1,nza)
c
c----call sdrv to solve system  mx = b
   3    path = 1
        call  sdrv
     *     (n, p,ip, ia,ja,a, b, z, nsp,isp,rsp,esp, path, flag)
        if (flag.ne.0)  go to 12
c
c----compute root-mean-square error
        sum = 0
        do 4 i=1,n
   4      sum = sum + ((z(i)-i)/i)**2
        rms = sqrt(sum/n)
c
c----output solution, error, and amount of extra storage
        write (6,108)  (z(i),i=1,n)
 108    format (//19h solution from sdrv
     *          //(5f12.5))
c
        if (rms.le.eps)  write (6,109)  rms, esp
 109    format (//32h solution correct -- rms error =, 1pe9.2
     *         ///26h extra storage available =, i5)
        if (rms.gt.eps)  write (6,110)  rms
 110    format (/34h solution incorrect -- rms error =, 1pe9.2)
c
   5    continue
c
        stop
c
c ** error in odrv
  11    write (6,111)  flag
 111    format (//24h error in odrv -- flag =, i5)
        stop
c
c ** error in sdrv
  12    write (6,112)  flag
 112    format (//24h error in sdrv -- flag =, i5)
        stop
        end
c                           appendix 4                           1/15/81
c
c       test driver for sparse nonsymmetric matrix package
c
c
c*** program ntst
c*** test driver for nonsymmetric codes in yale sparse matrix package
c
c  variables
c
c     ng   -  size of grid used to generate test problem.
c
c     n    -  number of variables and equations (= ng x ng).
c
c     ia   -  integer one-dimensional array used to store row pointers
c             to ja and a;  dimension = n+1.
c
c     ja   -  integer one-dimensional array used to store column
c             indices of nonzero elements of m;  dimension = number of
c             nonzero entries in m.
c
c     a    -  real one-dimensional array used to store nonzero elements
c             of m;  dimension = number of nonzero entries in m.
c
c     x    -  real one-dimensional array used to store solution x;
c             dimension = n.
c
c     b    -  real one-dimensional array used to store right-hand-side b
c             dimension = n.
c
c     p    -  integer one-dimensional array used to store permutation of
c             rows and columns for reordering linear system;
c             dimension = n.
c
c     ip   -  integer one-dimensional array used to store inverse of
c             permutation stored in p;  dimension = n.
c
c     nsp  -  declared dimension of one-dimensional arrays isp and rsp.
c
c     isp  -  integer one-dimensional array used as working storage
c             (equivalenced to rsp);  dimension = nsp.
c
c     rsp  -  real one-dimensional array used as working storage
c             (equivalenced to isp);  dimension = nsp.
c
c     esp  -  integer amount of excess storage available
c
c
        integer  ia(101), ja(500),  p(100), ip(100),  isp(1500), esp,
     *     case, path, flag,  aptr,vp,vq,  x,xmin,xmax,  y,ymin,ymax
        real  a(500), z(100), b(100),  rsp(1500),  sum, rms
c...    double precision  a(500), z(100), b(100),  rsp(1500),  sum, rms
        real  name(3)
        equivalence  (isp(1), rsp(1))
        data  nsp/1500/, eps/1e-5/,
     *     name(1)/1hn/, name(2)/1ht/, name(3)/1hc/
c
        index(i,j) = ng*i + j - ng
c
        ng = 3
        n = ng*ng
c
c  ******  case=1 => ndrv,  case=2 => tdrv,  case=3 => cdrv  ***********
        do 5 case=1,3
c
c  ******  set up matrix for five-point finite difference operator *****
        aptr = 1
        do 2 i=1,ng
          do 2 j=1,ng
            vp = index (i, j)
            p(vp) = vp
            ip(vp) = vp
            ia(vp) = aptr
            sum = 0
            xmin = max0 ( 1, i-1)
            xmax = min0 (ng, i+1)
            ymin = max0 ( 1, j-1)
            ymax = min0 (ng, j+1)
            do 1 x=xmin,xmax
              do 1 y=ymin,ymax
                if ((x-i) * (y-j) .ne. 0)  go to 1
                  vq = index(x, y)
                  ja(aptr) = vq
                  a(aptr) = 8
                  if (vp .lt. vq)  a(aptr) = -1
                  if (vp .gt. vq)  a(aptr) = -2
                  sum = sum + a(aptr) * vq
                  aptr = aptr + 1
   1            continue
            b(vp) = sum
   2        continue
        ia(n+1) = aptr
        nza = ia(n+1) - 1
c
c  ******  output original array a  ************************************
        if (case.eq.1)  write (6,1001)  ng,ng
1001    format (/27h1*** five-point operator on, i2, 3h by, i2, 5h grid)
        if (case.eq.1)  write (6,1002)  (ia(i),i=1,n), ia(n+1)
1002    format (/43h coefficient matrix                        ,
     *         //43h    ia (indices of first elements in rows) ,
     *          /(10i5))
        if (case.eq.1)  write (6,1003)  (i,ja(i),a(i), i=1,nza)
1003    format (/43h              ja             a             ,
     *          /43h    i   column indices     matrix          ,
     *          /(i5, i11, f17.5))
        if (case.eq.1)  write (6,1004)  (b(i), i=1,n)
1004    format (/43h right hand side b                         ,
     *          /(5f11.5))
c
c  ******  call odrv  **************************************************
        path = 1
        call  odrv
     *     (n, ia,ja,a, p,ip, nsp,isp, path, flag)
        if (flag.ne.0)  go to 101
c
c  ******  output ordering of variables/equations  *********************
        if (case.eq.1)  write (6,1005)  (i,p(i),ip(i), i=1,n)
1005    format (/43h row/column ordering from odrv             ,
     *         //43h               p                  ip       ,
     *          /43h    i   row/col ordering   inverse ordering,
     *          /(i5, i11, i20))
c
c  ******  call ndrv / tdrv / cdrv  ************************************
        path = 1
        if (case.eq.1)  call  ndrv
     *     (n, p,p,ip, ia,ja,a, b, z, nsp,isp,rsp,esp, path, flag)
        if (case.eq.2)  call  tdrv
     *     (n, p,  ip, ia,ja,a, b, z, nsp,isp,rsp,esp,       flag)
        if (case.eq.3)  call  cdrv
     *     (n, p,p,ip, ia,ja,a, b, z, nsp,isp,rsp,esp, path, flag)
        if (flag.eq.0)  go to 3
          write (6,1006)  name(case),  flag
1006      format (/10h error in , a1, 13hdrv -- flag =, i5)
          go to 5
c
c  ******  calculate error  ********************************************
   3    sum = 0
        do 4 i=1,n
   4      sum = sum + ((z(i)-i)/i)**2
        rms = sqrt(sum/n)
c
c  ******  output solution and error measure  **************************
        write (6,1007)  name(case),  (z(i), i=1,n)
1007    format (/15h solution from , a1, 3hdrv
     *          /(5f11.5))
c
        if (rms.le.eps)  write (6,1008)  rms
1008    format (/32h solution correct -- rms error =, 1pe9.2)
        if (rms.gt.eps)  write (6,1009)  rms
1009    format (/34h solution incorrect -- rms error =, 1pe9.2)
c
        write (6,1010)  esp
1010    format (/26h extra storage available =, i5)
c
   5    continue
        stop
c
c  ******  error messages  *********************************************
 101    write (6,1011)  flag
1011    format (/24h error in odrv -- flag =, i5)
        stop
        end
