/*
*			vectorprotos.h
*
*	Copyright 1999 by The University at Stony Brook, All rights reserved.
*
*/
#if !defined(_VECTORPROTOS_H)
#define _VECTORPROTOS_H

#include <cdecs.h>

		/* dextrabla.f */
FORTRAN void FORTRAN_NAME(dypax)(int,double*,int,double*,int,double*,int);
FORTRAN void FORTRAN_NAME(dxayz)(int,double*,int,double,double*,
				int,double*,int);
FORTRAN void FORTRAN_NAME(dvvm)(int,double*,int,double*,int);
FORTRAN void FORTRAN_NAME(dvvd)(int,double*,int,double*,int);
FORTRAN void FORTRAN_NAME(dasv)(int,double,double*,int);
FORTRAN void FORTRAN_NAME(dves)(int,double*,int,double);
FORTRAN void FORTRAN_NAME(dvespv)(int,double*,int,double,double*,int);
FORTRAN void FORTRAN_NAME(dvesmv)(int,double*,int,double,double*,int);

		/* sextrabla.f */
FORTRAN void FORTRAN_NAME(sypax)(int,float*,int,float*,int,float*,int);
FORTRAN void FORTRAN_NAME(sxayz)(int,float*,int,float,float*,int,float*,int);
FORTRAN void FORTRAN_NAME(svvm)(int,float*,int,float*,int);
FORTRAN void FORTRAN_NAME(svvd)(int,float*,int,float*,int);
FORTRAN void FORTRAN_NAME(sasv)(int,float,float*,int);
FORTRAN void FORTRAN_NAME(svesf)(int,float*,int,float);
FORTRAN void FORTRAN_NAME(svspvf)(int,float*,int,float,float*,int);
FORTRAN void FORTRAN_NAME(svsmvf)(int,float*,int,float,float*,int);

#ifdef __cplusplus
extern "C" {
#endif
		/* toblas.c */
IMPORT void	subtract_vector_from_vector(int,float*,float*);
IMPORT void	add_scalar_times_vector_to_vector(int,float,float*,float*);
IMPORT void	add_vector_times_vector_to_vector(int,float*,float*,float*);
IMPORT void	copy_vector_to_vector(int,float*,float*);
IMPORT void	multiply_vector_by_scalar(int,float*,float);
IMPORT void	multiply_vector_by_vector(int,float*,float*);
IMPORT void	divide_vector_by_vector(int,float*,float*);
IMPORT void	vector_equals_scalar(int,float*,float);
IMPORT void	add_scalar_to_vector(int,float,float*);
IMPORT void	min_max_vector(int,float*,float*,float*);
IMPORT void	vector_equals_scalar_plus_vector(int,float*,float,float*);
IMPORT void	vector_equals_scalar_times_vector(int,float*,float,float*);
IMPORT void	sum_elements_of_vector(int,float*,float*);
IMPORT void	vector_equals_vector_plus_scalar_times_vector(int,float*,float*,
							  float,float*);
IMPORT void	vector_equals_vector_minus_vector(int,float*,float*,float*);
IMPORT float inner_product(int,float*,float*);
IMPORT float norm_vector(int,float*);
IMPORT void	izero_vector(int,int*);
IMPORT void	zero_vector(int,float*);
IMPORT void	dzero_vector(int,double*);
IMPORT void	dsubtract_vector_from_vector(int,double*,double*);
IMPORT void	dadd_scalar_times_vector_to_vector(int,double,double*,double*);
IMPORT void	dadd_vector_times_vector_to_vector(int,double*,double*,double*);
IMPORT void	dcopy_vector_to_vector(int,double*,double*);
IMPORT void	dmultiply_vector_by_scalar(int,double*,double a);
IMPORT void	dmultiply_vector_by_vector(int,double*,double*);
IMPORT void	ddivide_vector_by_vector(int,double*,double*);
IMPORT void	dvector_equals_scalar(int,double*,double a);
IMPORT void	dadd_scalar_to_vector(int,double,double*);
IMPORT void	dmin_max_vector(int,double*,double*,double*);
IMPORT void	dvector_equals_scalar_plus_vector(int,double*,double,double*);
IMPORT void	dvector_equals_scalar_times_vector(int,double*,double,double*);
IMPORT void	dsum_elements_of_vector(int,double*,double*);
IMPORT void	dvector_equals_vector_plus_scalar_times_vector(int,double*,
							       double*,double,
							       double*);
IMPORT void	dvector_equals_vector_minus_vector(int,double*,double*,double*);
IMPORT double dinner_product(int,double*,double*);
IMPORT double dnorm_vector(int,double*);
IMPORT void	copy_fvector_to_dvector(int,float*,double*);
IMPORT void	copy_dvector_to_fvector(int,double*,float*);
IMPORT void	add_fvector_times_dvector_to_dvector(int,float*,
						     double*,double*);
IMPORT void	multiply_dvector_by_fvector(int,double*,float*);
IMPORT void	divide_dvector_by_fvector(int,double*,float*);
IMPORT void	c_subtract_vector_from_vector(int,float*,float*);
IMPORT void	c_add_scalar_times_vector_to_vector(int,float,float*,float*);
IMPORT void	c_add_vector_times_vector_to_vector(int,float*,float*,float*);
IMPORT void	c_copy_vector_to_vector(int,float*,float*);
IMPORT void	c_multiply_vector_by_scalar(int,float*,float);
IMPORT void	c_multiply_vector_by_vector(int,float*,float*);
IMPORT void	c_divide_vector_by_vector(int,float*,float*);
IMPORT void	c_add_scalar_to_vector(int,float,float*);
IMPORT void	c_sum_elements_of_vector(int,float*,float*);
IMPORT void	c_vector_equals_vector_plus_scalar_times_vector(int,float*,
								float*,float,
								float*);
IMPORT void	c_vector_equals_vector_minus_vector(int,float*,float*,float*);
IMPORT float	c_inner_product(int,float*,float*);
IMPORT float	c_norm_vector(int,float*);
IMPORT void	c_zero_vector(int,float*,int);
IMPORT void	c_vector_equals_scalar(int,float*,float);
IMPORT void	c_vector_equals_scalar_plus_vector(int,float*,float,float*);
IMPORT void	c_vector_equals_scalar_times_vector(int,float*,float,float*);

#if defined(RealEqualsFloat)

#   define ZERO_RVECTOR zero_vector
#   define PRINT_REAL_VECTOR_AS_MATRIX print_float_vector_as_matrix
#   define COPY_RVECTOR_TO_RVECTOR  copy_vector_to_vector
#   define COPY_RVECTOR_TO_DVECTOR  copy_fvector_to_dvector
#   define COPY_DVECTOR_TO_RVECTOR  copy_dvector_to_fvector
#   define SUBTRACT_RVECTOR_FROM_RVECTOR subtract_vector_from_vector
#   define MULTIPLY_RVECTOR_BY_RSCALAR multiply_vector_by_scalar
#   define NORM_RVECTOR norm_vector
#   define RINNER_PRODUCT inner_product
#   define RVECTOR_EQUALS_RVECTOR_PLUS_SCALAR_TIMES_RVECTOR \
	vector_equals_vector_plus_scalar_times_vector
#   define ADD_SCALAR_TIMES_RVECTOR_TO_RVECTOR \
	add_scalar_times_vector_to_vector
#   define RVECTOR_EQUALS_RVECTOR_MINUS_RVECTOR \
	vector_equals_vector_minus_vector
#   define ADD_FVECTOR_TIMES_RVECTOR_TO_RVECTOR \
	add_vector_times_vector_to_vector
#   define MULTIPLY_RVECTOR_BY_FVECTOR multiply_vector_by_vector
#   define DIVIDE_RVECTOR_BY_FVECTOR divide_vector_by_vector

#else /* defined(RealEqualsFloat) */

#   define ZERO_RVECTOR dzero_vector
#   define PRINT_REAL_VECTOR_AS_MATRIX print_double_vector_as_matrix
#   define COPY_RVECTOR_TO_RVECTOR  dcopy_vector_to_vector
#   define COPY_RVECTOR_TO_DVECTOR  dcopy_vector_to_vector
#   define COPY_DVECTOR_TO_RVECTOR  dcopy_vector_to_vector
#   define SUBTRACT_RVECTOR_FROM_RVECTOR dsubtract_vector_from_vector
#   define MULTIPLY_RVECTOR_BY_RSCALAR dmultiply_vector_by_scalar
#   define NORM_RVECTOR dnorm_vector
#   define RINNER_PRODUCT dinner_product
#   define RVECTOR_EQUALS_RVECTOR_PLUS_SCALAR_TIMES_RVECTOR \
	dvector_equals_vector_plus_scalar_times_vector
#   define ADD_SCALAR_TIMES_RVECTOR_TO_RVECTOR \
	dadd_scalar_times_vector_to_vector
#   define RVECTOR_EQUALS_RVECTOR_MINUS_RVECTOR \
	dvector_equals_vector_minus_vector

#   if !defined(float)

#       define ADD_FVECTOR_TIMES_RVECTOR_TO_RVECTOR \
	    add_fvector_times_dvector_to_dvector
#       define MULTIPLY_RVECTOR_BY_FVECTOR multiply_dvector_by_fvector
#       define DIVIDE_RVECTOR_BY_FVECTOR divide_dvector_by_fvector

#   else /* !defined(float) */

#       define ADD_FVECTOR_TIMES_RVECTOR_TO_RVECTOR \
	    dadd_vector_times_vector_to_vector
#       define MULTIPLY_RVECTOR_BY_FVECTOR dmultiply_vector_by_vector
#       define DIVIDE_RVECTOR_BY_FVECTOR ddivide_vector_by_vector

#   endif /* !defined(float) */

#endif  /* defined(RealEqualsFloat) */

#ifdef __cplusplus
}
#endif

#endif /* !defined(_VECTORPROTOS_H) */
