      subroutine sypax(n,sa,inca,sx,incx,sy,incy)
c
c     y plus a time x i.e. y(i) = y(i) + a(i)*x(i)
c
c     uses unrolled loop for increments equal to one.
c     oliver mcbryan.
c
      real sx(1),sy(1),sa(1)
      integer i,inca,incx,incy,ia,ix,iy,m,n,n4,n41
c
      if(n.le.0)return
      if(inca.eq.1.and.incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ia = 1
      ix = 1
      iy = 1
      if(inca.lt.0)ia = (-n+1)*inca + 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        sy(iy) = sy(iy) + sa(ia)*sx(ix)
        ia = ia + inca
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      n4 = n-m
      if( m .eq. 0 ) go to 40
      n41 = n4+1
      do 30 i = n41,n
        sy(i) = sy(i) + sa(i)*sx(i)
   30 continue
      if( n .lt. 4 ) return

 
   40 do 50 i = 1,n4,4
        sy(i) = sy(i) + sa(i)*sx(i)
        sy(i + 1) = sy(i + 1) + sa(i+1)*sx(i + 1)
        sy(i + 2) = sy(i + 2) + sa(i+2)*sx(i + 2)
        sy(i + 3) = sy(i + 3) + sa(i+3)*sx(i + 3)
   50 continue

      return
      end


c	this is temporary - delete soon
c
      subroutine ypax(n,sa,sx,incx,sy,incy)
c
c     y plus a time x i.e. y(i) = y(i) + a(i)*x(i)
c	same as sypax above
c
      real sx(1),sy(1),sa(1)
      integer incx,incy,n
      call sypax(n,sa,1,sx,incx,sy,incy)
      return
      end





      real function ssum(n,sx,incx)
c
c     takes the sum of the elements of vector.
c     uses unrolled loops for increment equal to one.
c     oliver mcbryan.
c
      real sx(1),stemp
      integer i,incx,m,mp1,n,nincx
c
      ssum = 0.0e0
      stemp = 0.0e0
      if(n.le.0)return
      if(incx.eq.1)go to 20
c
c        code for increment not equal to 1
c
      nincx = n*incx
      do 10 i = 1,nincx,incx
        stemp = stemp + sx(i)
   10 continue
      ssum = stemp
      return
c
c        code for increment equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,6)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        stemp = stemp + sx(i)
   30 continue
      if( n .lt. 6 ) go to 60
   40 mp1 = m + 1
      do 50 i = mp1,n,6
        stemp = stemp + sx(i) + sx(i + 1) + sx(i + 2)
     *  + sx(i + 3) + sx(i + 4) + sx(i + 5)
   50 continue
   60 ssum = stemp
      return
      end




      subroutine sxayz(n,sx,incx,sa,sy,incy,sz,incz)
c
c     x plus a time y i.e. z(i) = x(i) + a*y(i)
c
c     uses unrolled loop for increments equal to one.
c     oliver mcbryan.
c
      real sx(1),sy(1),sz(1),sa
      integer i,incx,incy,ix,iy,m,mp1,n
c
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1.and.incz.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      if(incz.lt.0)iz = (-n+1)*incz + 1
      do 10 i = 1,n
        sz(iz) = sx(ix) + sa*sy(iy)
        ix = ix + incx
        iy = iy + incy
        iz = iz + incz
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        sz(i) = sx(i) + sa*sy(i)
   30 continue
      if( n .lt. 4 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,4
        sz(i) = sx(i) + sa*sy(i)
        sz(i + 1) = sx(i + 1) + sa*sy(i + 1)
        sz(i + 2) = sx(i + 2) + sa*sy(i + 2)
        sz(i + 3) = sx(i + 3) + sa*sy(i + 3)
   50 continue
      return
      end


      subroutine svvm(n,sx,incx,sy,incy)
c
c     vector x times a vector y:  ie x[i] = x[i]*y[i]
c
c     uses unrolled loop for increments equal to one.
c     oliver mcbryan.
c
      real sx(1),sy(1)
      integer i,incx,incy,ix,iy,m,mp1,n
c
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        sx(ix) = sx(ix)*sy(iy)
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        sx(i) = sx(i)*sy(i)
   30 continue
      if( n .lt. 4 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,4
        sx(i) = sx(i)*sy(i)
        sx(i + 1) = sx(i + 1)*sy(i+1)
        sx(i + 2) = sx(i + 2)*sy(i+2)
        sx(i + 3) = sx(i + 3)*sy(i+3)
   50 continue
      return
      end



      subroutine svvd(n,sx,incx,sy,incy)
c
c     vector x diveded by  a vector y:  ie x[i] = x[i]/y[i]
c
c     uses unrolled loop for increments equal to one.
c     oliver mcbryan.
c
      real sx(1),sy(1)
      integer i,incx,incy,ix,iy,m,mp1,n
c
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        sx(ix) = sx(ix)/sy(iy)
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        sx(i) = sx(i)/sy(i)
   30 continue
      if( n .lt. 4 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,4
        sx(i) = sx(i)/sy(i)
        sx(i + 1) = sx(i + 1)/sy(i+1)
        sx(i + 2) = sx(i + 2)/sy(i+2)
        sx(i + 3) = sx(i + 3)/sy(i+3)
   50 continue
      return
      end




      subroutine sasv(n,sa,sx,incx)
c
c     x plus a  i.e. x(i) = x(i) + a
c
c     uses unrolled loop for increments equal to one.
c     oliver mcbryan.
c
      real sx(1),sa
      integer i,incx,ix,m,mp1,n
c
      if(n.le.0)return
      if(incx.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      do 10 i = 1,n
        sx(ix) = sx(ix) + sa
        ix = ix + incx
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        sx(i) = sx(i) + sa
   30 continue
      if( n .lt. 4 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,4
        sx(i) = sx(i) + sa
        sx(i + 1) = sx(i + 1) + sa
        sx(i + 2) = sx(i + 2) + sa
        sx(i + 3) = sx(i + 3) + sa
   50 continue
      return
      end



      subroutine svesf(n,sx,incx,sa)
c
c     x = a  i.e. x(i) = a
c
c     uses unrolled loop for increments equal to one.
c     oliver mcbryan.
c
      real sx(1),sa
      integer i,incx,ix,m,mp1,n
c
      if(n.le.0)return
      if(incx.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      do 10 i = 1,n
        sx(ix) = sa
        ix = ix + incx
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        sx(i) = sa
   30 continue
      if( n .lt. 4 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,4
        sx(i) = sa
        sx(i + 1) = sa
        sx(i + 2) = sa
        sx(i + 3) = sa
   50 continue
      return
      end


      subroutine svspvf(n,sz,incz,sa,sx,incx)
c
c     x equals a plus x  i.e. sz(i) = sa + sx(i)
c
c     uses unrolled loop for increments equal to one.
c     oliver mcbryan.
c
      real sx(1),sz(1),sa
      integer i,incx,incz,ix,iz,m,mp1,n
c
      if(n.le.0)return
      if(incx.eq.1.and.incz.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iz = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incz.lt.0)iz = (-n+1)*incz + 1
      do 10 i = 1,n
        sz(iz) = sx(ix) + sa
        ix = ix + incx
        iz = iz + incz
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        sz(i) = sx(i) + sa
   30 continue
      if( n .lt. 4 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,4
        sz(i) = sx(i) + sa
        sz(i + 1) = sx(i + 1) + sa
        sz(i + 2) = sx(i + 2) + sa
        sz(i + 3) = sx(i + 3) + sa
   50 continue
      return
      end


      subroutine svsmvf(n,sz,incz,sa,sx,incx)
c
c     x equals a times x  i.e. sz(i) = sa * sx(i)
c
c     uses unrolled loop for increments equal to one.
c     oliver mcbryan.
c
      real sx(1),sz(1),sa
      integer i,incx,incz,ix,iz,m,mp1,n
c
      if(n.le.0)return
      if(incx.eq.1.and.incz.eq.1)go to 20
c
c        code for unequal increments or equal increments
c          not equal to 1
c
      ix = 1
      iz = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incz.lt.0)iz = (-n+1)*incz + 1
      do 10 i = 1,n
        sz(iz) = sx(ix) * sa
        ix = ix + incx
        iz = iz + incz
   10 continue
      return
c
c        code for both increments equal to 1
c
c
c        clean-up loop
c
   20 m = mod(n,4)
      if( m .eq. 0 ) go to 40
      do 30 i = 1,m
        sz(i) = sx(i) * sa
   30 continue
      if( n .lt. 4 ) return
   40 mp1 = m + 1
      do 50 i = mp1,n,4
        sz(i) = sx(i) * sa
        sz(i + 1) = sx(i + 1) * sa
        sz(i + 2) = sx(i + 2) * sa
        sz(i + 3) = sx(i + 3) * sa
   50 continue
      return
      end


