#include <cdecs.h>

float FORTRAN_NAME(r1mach)(int *pi)
{
    int          i;
    static int   first = 1;
    static float rmach[5];

    i = *pi;
    if (first)
    {
	first = 0;
	rmach[0] = FLT_MIN;
	rmach[1] = FLT_MAX;
	rmach[2] = 0.5*FLT_EPSILON;
	rmach[3] = FLT_EPSILON;
	rmach[4] = log10(2.0);
    }

/*
*  double-precision machine constants
*  r1mach( 1) = b**(emin-1), the smallest positive magnitude. 
*  r1mach( 2) = b**emax*(1 - b**(-t)), the largest magnitude.
*  r1mach( 3) = b**(-t), the smallest relative spacing.
*  r1mach( 4) = b**(1-t), the largest relative spacing.
*  r1mach( 5) = log10(b) 
*/

    if (i < 1 || i > 5)
    {
        (void) printf("r1mach - i = %d out of bounds\n",i);
        return 0.0;
    }
    return rmach[i - 1];
}	/* end FORTRAN_NAME(r1mach) */
