*DECK MATGEN1
      SUBROUTINE MATGEN1( NMAX, NELTMAX, FACTOR, SCALE,
     $     N1, N2, N, NELT, ISYM, 
     $     IA, JA, A, A0, A1, A2, A3, A4, F, SOLN )
C----------------------------------------------------------------------
C         This routine generates a "stiffness" matrix for the Elliptic
C         Partial Differential Equation:
C         
C         -d/dx(p(x,y)du/dx) - d/dy(p(x,y)du/dy) = f(x,y)
C         
C         0 .lt. x .lt. 1 ,   0 .lt. y .lt. 1
C         
C         with boundary conditions
C         
C         u(x,0) = u(x,1) = u(0,y) = u(1,y) = 0
C         
C using the finite element method with piecewise bilinear finite
C elements.
C----------------------------------------------------------------------
      INTEGER NMAX, NELTMAX, N1, N2, N, NELT, ISYM
      INTEGER IA(NELTMAX), JA(NELTMAX)
      REAL    FACTOR, A(NELTMAX)
      REAL    A0(NMAX), A1(NMAX), A2(NMAX), A3(NMAX), A4(NMAX)
      REAL    F(NMAX), SOLN(NMAX)
C         
C..       set problem size.
      N = N1*N2
      N1P1 = N1 + 1
      N2P1 = N2 + 1
      H1 = 1./N1P1
      H2 = 1./N2P1
      H1H2 = H1*H2
      NZ = N1P1*N2P1
C         
C..       zero out matrix and right-hand side.
      DO 10 I=1,N
         A0(I) = 0.
         A1(I) = 0.
         A2(I) = 0.
         A3(I) = 0.
         A4(I) = 0.
         F(I) = 0.
 10   CONTINUE
C         
C         
C..       loop over zones.
CVD$ NOCONCUR
      DO 101 J=1,N2P1
CVD$ NOVECTOR
CVD$ NOCONCUR
         DO 100 K=1,N1P1
C         
C..       calculate coords of zone.
            XL = (K-1)*H1
            XU = XL + H1
            YL = (J-1)*H2
            YU = YL + H2
C         
C..       set gauss quadrature pts.
            X1 = (XL+XU)/2. - H1/(2.*SQRT(3.))
            X2 = (XL+XU)/2. + H1/(2.*SQRT(3.))
            Y1 = (YL+YU)/2. - H2/(2.*SQRT(3.))
            Y2 = (YL+YU)/2. + H2/(2.*SQRT(3.))
C         
C..       evaluate p at gauss quadrature pts.
            P11 = P(X1,Y1)
            P12 = P(X1,Y2)
            P21 = P(X2,Y1)
            P22 = P(X2,Y2)
C         
C..       calculate node indices of the vertices of this zone.
            ILL = (J-2)*N1 + (K-1)
            ILR = ILL + 1
            IUL = ILL + N1
            IUR = IUL + 1
C         
C..       evaluate integral involving lower left basis function.
            IF(J .EQ. 1 .OR. K .EQ. 1) GO TO 50
C         
            X1T = H1/2. - H1/(2.*SQRT(3.))
            X2T = H1/2. + H1/(2.*SQRT(3.))
            Y1T = H2/2. - H2/(2.*SQRT(3.))
            Y2T = H2/2. + H2/(2.*SQRT(3.))
C         
            BII11 = (1./H1 - Y1T/H1H2)**2 + (1./H2 - X1T/H1H2)**2
            BII12 = (1./H1 - Y2T/H1H2)**2 + (1./H2 - X1T/H1H2)**2
            BII21 = (1./H1 - Y1T/H1H2)**2 + (1./H2 - X2T/H1H2)**2
            BII22 = (1./H1 - Y2T/H1H2)**2 + (1./H2 - X2T/H1H2)**2
C         
            V1 = .5 * H1 * (P11*BII11 + P21*BII21)
            V2 = .5 * H1 * (P12*BII12 + P22*BII22)
            V = .5 * H2 * (V1 + V2)
C         
            A0(ILL) = A0(ILL) + V
C         
C..       evaluate integral involving lower right basis function.
 50         IF(J .EQ. 1 .OR. K .EQ. N1P1) GO TO 60
C         
            X1T = -H1/2. - H1/(2.*SQRT(3.))
            X2T = -H1/2. + H1/(2.*SQRT(3.))
            Y1T = H2/2. - H2/(2.*SQRT(3.))
            Y2T = H2/2. + H2/(2.*SQRT(3.))
C         
            BII11 = (1./H1 - Y1T/H1H2)**2 + (1./H2 + X1T/H1H2)**2
            BII12 = (1./H1 - Y2T/H1H2)**2 + (1./H2 + X1T/H1H2)**2
            BII21 = (1./H1 - Y1T/H1H2)**2 + (1./H2 + X2T/H1H2)**2
            BII22 = (1./H1 - Y2T/H1H2)**2 + (1./H2 + X2T/H1H2)**2
C         
            V1 = .5 * H1 * (P11*BII11 + P21*BII21)
            V2 = .5 * H1 * (P12*BII12 + P22*BII22)
            V = .5 * H2 * (V1 + V2)
C         
            A0(ILR) = A0(ILR) + V
C         
C..       evaluate integral involving lower right and lower left
C..       basis functions.
            IF(K .EQ. 1) GO TO 60
C         
            BIJ11 = -(1./H1-Y1T/H1H2)**2-(1./H2+X1T/H1H2)*(X1T/H1H2)
            BIJ12 = -(1./H1-Y2T/H1H2)**2-(1./H2+X1T/H1H2)*(X1T/H1H2)
            BIJ21 = -(1./H1-Y1T/H1H2)**2-(1./H2+X2T/H1H2)*(X2T/H1H2)
            BIJ22 = -(1./H1-Y2T/H1H2)**2-(1./H2+X2T/H1H2)*(X2T/H1H2)
C         
            V1 = .5 * H1 * (P11*BIJ11 + P21*BIJ21)
            V2 = .5 * H1 * (P12*BIJ12 + P22*BIJ22)
            V = .5 * H2 * (V1 + V2)
C         
            A1(ILL) = A1(ILL) + V
C         
C..       evaluate integral involving upper left basis function.
 60         IF(J .EQ. N2P1 .OR. K .EQ. 1) GO TO 70
C         
            X1T = H1/2. - H1/(2.*SQRT(3.))
            X2T = H1/2. + H1/(2.*SQRT(3.))
            Y1T = -H2/2. - H2/(2.*SQRT(3.))
            Y2T = -H2/2. + H2/(2.*SQRT(3.))
C         
            BII11 = (1./H1 + Y1T/H1H2)**2 + (1./H2 - X1T/H1H2)**2
            BII12 = (1./H1 + Y2T/H1H2)**2 + (1./H2 - X1T/H1H2)**2
            BII21 = (1./H1 + Y1T/H1H2)**2 + (1./H2 - X2T/H1H2)**2
            BII22 = (1./H1 + Y2T/H1H2)**2 + (1./H2 - X2T/H1H2)**2
C         
            V1 = .5 * H1 * (P11*BII11 + P21*BII21)
            V2 = .5 * H1 * (P12*BII12 + P22*BII22)
            V = .5 * H2 * (V1 + V2)
C         
            A0(IUL) = A0(IUL) + V
C         
C..       evaluate integral involving upper left and lower left
C..       basis functions.
            IF(J .EQ. 1) GO TO 70
C         
            BIK11 = -(1./H1+Y1T/H1H2)*(Y1T/H1H2)-(1./H2-X1T/H1H2)**2
            BIK12 = -(1./H1+Y2T/H1H2)*(Y2T/H1H2)-(1./H2-X1T/H1H2)**2
            BIK21 = -(1./H1+Y1T/H1H2)*(Y1T/H1H2)-(1./H2-X2T/H1H2)**2
            BIK22 = -(1./H1+Y2T/H1H2)*(Y2T/H1H2)-(1./H2-X2T/H1H2)**2
C         
            V1 = .5 * H1 * (P11*BIK11+P21*BIK21)
            V2 = .5 * H1 * (P12*BIK12+P22*BIK22)
            V = .5 * H2 * (V1+V2)
C         
            A3(ILL) = A3(ILL)+V
C         
C..       evaluate integral involving upper left and lower right
C..       basis functions.
            IF(K .EQ. N1P1) GO TO 70
C         
            BIL11 = (1./H1+Y1T/H1H2)*(Y1T/H1H2)+(1./H2-X1T/H1H2)*
     $           (-X1T/H1H2)
            BIL12 = (1./H1+Y2T/H1H2)*(Y2T/H1H2)+(1./H2-X1T/H1H2)*
     $           (-X1T/H1H2)
            BIL21 = (1./H1+Y1T/H1H2)*(Y1T/H1H2)+(1./H2-X2T/H1H2)*
     $           (-X2T/H1H2)
            BIL22 = (1./H1+Y2T/H1H2)*(Y2T/H1H2)+(1./H2-X2T/H1H2)*
     $           (-X2T/H1H2)
C         
            V1 = .5 * H1 * (P11*BIL11 + P21*BIL21)
            V2 = .5 * H1 * (P12*BIL12 + P22*BIL22)
            V = .5 * H2 * (V1 + V2)
C         
            A2(ILR) = A2(ILR) + V
C         
C..       evaluate integral involving upper right basis function.
 70         IF(J .EQ. N2P1 .OR. K .EQ. N1P1) GO TO 100
C         
            X1T = -H1/2. - H1/(2.*SQRT(3.))
            X2T = -H1/2. + H1/(2.*SQRT(3.))
            Y1T = -H2/2. - H2/(2.*SQRT(3.))
            Y2T = -H2/2. + H2/(2.*SQRT(3.))
C         
            BII11 = (1./H1 + Y1T/H1H2)**2 + (1./H2 + X1T/H1H2)**2
            BII12 = (1./H1 + Y2T/H1H2)**2 + (1./H2 + X1T/H1H2)**2
            BII21 = (1./H1 + Y1T/H1H2)**2 + (1./H2 + X2T/H1H2)**2
            BII22 = (1./H1 + Y2T/H1H2)**2 + (1./H2 + X2T/H1H2)**2
C         
            V1 = .5 * H1 * (P11*BII11 + P21*BII21)
            V2 = .5 * H1 * (P12*BII12 + P22*BII22)
            V = .5 * H2 * (V1 + V2)
C         
            A0(IUR) = A0(IUR) + V
C         
C..       evaluate integral involving upper right and upper left
C..       basis functions.
            IF(K .EQ. 1) GO TO 80
C         
            BIJ11 = -(1./H1 + Y1T/H1H2)**2-(1./H2 + X1T/H1H2)*(X1T/H1H2)
            BIJ12 = -(1./H1 + Y2T/H1H2)**2-(1./H2 + X1T/H1H2)*(X1T/H1H2)
            BIJ21 = -(1./H1 + Y1T/H1H2)**2-(1./H2 + X2T/H1H2)*(X2T/H1H2)
            BIJ22 = -(1./H1 + Y2T/H1H2)**2-(1./H2 + X2T/H1H2)*(X2T/H1H2)
C         
            V1 = .5 * H1 * (P11*BIJ11 + P21*BIJ21)
            V2 = .5 * H1 * (P12*BIJ12 + P22*BIJ22)
            V = .5 * H2 * (V1 + V2)
C         
            A1(IUL) = A1(IUL) + V
C         
C..       evaluate integral involving upper right and lower left
C..       basis functions.
            IF(J .EQ. 1) GO TO 100
C         
            BIM11 = (1./H1+Y1T/H1H2)*(Y1T/H1H2)+(1./H2+X1T/H1H2)*
     $           (X1T/H1H2)
            BIM12 = (1./H1+Y2T/H1H2)*(Y2T/H1H2)+(1./H2+X1T/H1H2)*
     $           (X1T/H1H2)
            BIM21 = (1./H1+Y1T/H1H2)*(Y1T/H1H2)+(1./H2+X2T/H1H2)*
     $           (X2T/H1H2)
            BIM22 = (1./H1+Y2T/H1H2)*(Y2T/H1H2)+(1./H2+X2T/H1H2)*
     $           (X2T/H1H2)
C         
            V1 = .5 * H1 * (P11*BIM11 + P21*BIM21)
            V2 = .5 * H1 * (P12*BIM12 + P22*BIM22)
            V = .5 * H2 * (V1 + V2)
C         
            A4(ILL) = A4(ILL) + V
C         
C..       evaluate integral involving upper right and lower right
C..       basis functions.
 80         IF(J .EQ. 1) GO TO 100
C         
            BIK11 = -(1./H1+Y1T/H1H2)*(Y1T/H1H2)-(1./H2+X1T/H1H2)**2
            BIK12 = -(1./H1+Y2T/H1H2)*(Y2T/H1H2)-(1./H2+X1T/H1H2)**2
            BIK21 = -(1./H1+Y1T/H1H2)*(Y1T/H1H2)-(1./H2+X2T/H1H2)**2
            BIK22 = -(1./H1+Y2T/H1H2)*(Y2T/H1H2)-(1./H2+X2T/H1H2)**2
C         
            V1 = .5 * H1 * (P11*BIK11 + P21*BIK21)
            V2 = .5 * H1 * (P12*BIK12 + P22*BIK22)
            V = .5 * H2 * (V1 + V2)
C         
            A3(ILR) = A3(ILR) + V
C         
 100     CONTINUE
 101  CONTINUE
C         
C..       matrix has been generated.  set random solution and calculate
C..       right-hand side.
C$$$      dum = 0.
C$$$      iseed = ranset( 1234 )
C$$$CVD$ NOVECTOR
C$$$CVD$ NOCONCUR
C$$$      do 110 i=1,n
C$$$         soln(i) = ranf(dum)
C$$$ 110  continue
      DO 110 I = 1, N
         SOLN(I) = 1.0
 110  CONTINUE
      IF( SCALE.LT.1.0 ) SCALE = 1.01
      DO 121 I = 1, N
         A0(I) = SCALE*A0(I)
 121  CONTINUE
      F(1) = A0(1)*SOLN(1) + A1(1)*SOLN(2)
      DO 120 I=2,N-1
         F(I) = A0(I)*SOLN(I) + A1(I-1)*SOLN(I-1) + A1(I)*SOLN(I+1)
 120  CONTINUE
      F(N) = A0(N)*SOLN(N) + A1(N-1)*SOLN(N-1)
C         
      DO 170 I=1,N-N1-1
         F(I) = F(I) + A2(I)*SOLN(I+N1-1) + A3(I)*SOLN(I+N1) +
     $        A4(I)*SOLN(I+N1+1)
 170  CONTINUE
      F(N-N1) = F(N-N1) + A2(N-N1)*SOLN(N-1) + A3(N-N1)*SOLN(N)
      F(N-N1+1) = F(N-N1+1) + A2(N-N1+1)*SOLN(N)
C         
      F(N1) = F(N1) + A2(1)*SOLN(1)
      F(N1+1) = F(N1+1) + A2(2)*SOLN(2) + A3(1)*SOLN(1)
      DO 160 I=N1+2,N
         F(I) = F(I) + A2(I-N1+1)*SOLN(I-N1+1) + A3(I-N1)*SOLN(I-N1) +
     $        A4(I-N1-1)*SOLN(I-N1-1)
 160  CONTINUE
C$$$      write(3,206) (i,a0(i),a1(i),a2(i),a3(i),a4(i), i=1,n)
C$$$ 206  format(/'    I            A0(I)            A1(I)            ',
C$$$     $     'A2(I)            A3(I)            A4(I)'/
C$$$     $     (1x,i3,1x,e16.7,1x,e16.7,1x,e16.7,1x,e16.7,1x,e16.7))
C         
C*******************************************************************
C         
C         Problem is set up.  Put matrix in SLAP triad format.
C         
C*******************************************************************
C
      IF(ISYM .EQ. 0) THEN
C         Store the whole durn thing..
C         FACTOR denotes the amount of asymmetry the user desires...
         DO 210 I=1,N
            A(I) = A0(I)
            IA(I) = I
            JA(I) = I
 210     CONTINUE
         DO 220 I=1,N-1
            A(N+I) = A1(I)*FACTOR
            IA(N+I) = I
            JA(N+I) = I + 1
 220     CONTINUE
         DO 230 I=1,N-1
            A(2*N-1+I) = A1(I)
            IA(2*N-1+I) = I + 1
            JA(2*N-1+I) = I
 230     CONTINUE
         DO 240 I=1,N-N1+1
            A(3*N-2+I) = A2(I)*FACTOR
            IA(3*N-2+I) = I
            JA(3*N-2+I) = I + N1 - 1
 240     CONTINUE
         DO 250 I=1,N-N1+1
            A(4*N-N1-1+I) = A2(I)
            IA(4*N-N1-1+I) = I + N1 - 1
            JA(4*N-N1-1+I) = I
 250     CONTINUE
         DO 260 I=1,N-N1
            A(5*N-2*N1+I) = A3(I)*FACTOR
            IA(5*N-2*N1+I) = I
            JA(5*N-2*N1+I) = I + N1
 260     CONTINUE
         DO 270 I=1,N-N1
            A(6*N-3*N1+I) = A3(I)
            IA(6*N-3*N1+I) = I + N1
            JA(6*N-3*N1+I) = I
 270     CONTINUE
         DO 280 I=1,N-N1-1
            A(7*N-4*N1+I) = A4(I)*FACTOR
            IA(7*N-4*N1+I) = I
            JA(7*N-4*N1+I) = I + N1 + 1
 280     CONTINUE
         DO 290 I=1,N-N1-1
            A(8*N-5*N1-1+I) = A4(I)
            IA(8*N-5*N1-1+I) = I + N1 + 1
            JA(8*N-5*N1-1+I) = I
 290     CONTINUE
         NELT = 9*N-6*N1-2
      ELSE
C         Store the lower triangle of the Matrix...
         DO 310 I=1,N
            A(I) = A0(I)
            IA(I) = I
            JA(I) = I
 310     CONTINUE
         DO 320 I=1,N-1
            A(N+I) = A1(I)
            IA(N+I) = I + 1
            JA(N+I) = I
 320     CONTINUE
         DO 330 I=1,N-N1+1
            A(2*N-1+I) = A2(I)
            IA(2*N-1+I) = I + N1 -1
            JA(2*N-1+I) = I
 330     CONTINUE
         DO 340 I=1,N-N1
            A(3*N-N1+I) = A3(I)
            IA(3*N-N1+I) = I + N1
            JA(3*N-N1+I) = I
 340     CONTINUE
         DO 350 I=1,N-N1-1
            A(4*N-2*N1+I) = A4(I)
            IA(4*N-2*N1+I) = I + N1 + 1
            JA(4*N-2*N1+I) = I
 350     CONTINUE
         NELT = 5*N-3*N1-1
      ENDIF
      RETURN
      END
*DECK FIVEPT
      SUBROUTINE FIVEPT(NMAX, NELTMAX, IERR, NX, NY, N, NELT, ISYM,
     $     IA, JA, AZ, RHS, SOLN )
C
C         FIVEPT generates the  itpack matrices jcoef,  coef, and  rhs
C         for a 5-point   central  difference  approximation  of   the
C         PDE:
C
C         (A*u )   + (C*u )   + D*u   + E*u   + F*u  =  G
C             x x        y y       x       y
C
C         Where the coefficients A, C, D, E, F, and G are functions of
C         (x,y) (supplied by the  user)  and  the  domain is  the unit
C         square (0,1)x(0,1).    Dirichlet  boundary  conditions   are
C         imposed upon the   boundary  in the  form of    the function
C         UB(x,y) also supplied by the user.  If the solution is known
C         it should be plugged into UXY(x,y)
C
C     parameters -- 
C
C        NX, NY  Number of grid lines in the x and y dimensions (Input).
C        IERR    IERR = 0 => All went well.
C                      -1 => Number of grid points N = NX*NY too large.
C                      -2 => Number of non-zeros got too large.
C        N       Number of linear equations(Output).  N = NX*NY.
C        NELT    Number of non-zeros in the IA, JA, A arrays (Output).
C        ISYM    ISYM = 0 => All Non-zeros of the matrix must be stored.
C                            The coeficients D(X,Y) and E(X,Y) are 
C                            assumed to be non-zero in this case.
C                     = 1 => Generate a symmetric matrix and store only
C                            the lower triangle.  The coeficients D(X,Y)
C                            and E(X,Y) are assumed to be *ZERO* in this
C                            case.
C        IA, JA  Row and Column indicies of the non-zeros (Output).
C        AZ      Non-zeros (Output).
C        RHS     Vector of right-hand-side values (Output).
C        SOLN    Solution vector, if known (Output).
C
C     Specifications for parameters
C
      INTEGER  NMAX, NELTMAX, IERR, NX, NY, N, NELT, ISYM
      INTEGER  IA(NELTMAX), JA(NELTMAX)
      REAL     AZ(NELTMAX), RHS(NMAX), SOLN(NMAX)
C
      LOGICAL SYMM
C
C         Statement functions.  Define the PDE coeficients here.
C
      A(X,Y) = 1.0
      C(X,Y) = 1.0
      D(X,Y) = 4.0
      E(X,Y) = 4.0
      F(X,Y) = 1.0
      G(X,Y) = 1.0
      UB(X,Y) = 1.0
      UXY(X,Y) = 0.0
C
C         Set up the grid.  Assuming a natural ordering from 
C         left to right (X-Axis) and from down to up (Y-Axis).
C         
      N = NX*NY
      IF( N.LT.1 .OR. N.GT.NMAX ) GOTO 100
      HX = 1.0/FLOAT(NX+1)
      HY = 1.0/FLOAT(NY+1)
      HALFHX = HX/2.0 
      HALFHY = HY/2.0 
      SYMM   = ISYM .EQ. 0
C
C         Loop on equations, assuming a natural ordering from
C         left to right and from down to up.
C
      NEQ = 0
      NELT = 0
      DO 25 J = 1, NY
         YY = FLOAT(J)*HY
         DO 20 I = 1, NX
            XX = FLOAT(I)*HX
            NEQ = NEQ + 1
            SOLN(NEQ) = UXY( XX, YY)
            AE = A( XX+HALFHX, YY)
            AW = A( XX-HALFHX, YY)
            CN = C( XX, YY+HALFHY)
            CS = C( XX, YY-HALFHY)
            IF( SYMM ) THEN
               DE = 0.0
               EN = 0.0
            ELSE
               DE = D( XX+HALFHX, YY)
               EN = E( XX, YY+HALFHY)
            ENDIF
            FP = F( XX, YY)
            GP = G( XX, YY)
            CC = AE + CN + AW + CS - (HX*DE + HY*EN + HX*HY*FP)
C
C ... Center point.
C
            NELT = NELT + 1
            IF( NELT.GT.NELTMAX ) GOTO 110
            AZ(NELT)  = CC
            IA(NELT) = NEQ
            JA(NELT) = NEQ
            RHS(NEQ) = -HX*HY*GP
C
C ... East point.
C
            IF( I.NE.NX ) THEN
               IF( .NOT.SYMM ) THEN
                  NELT = NELT + 1
                  IF( NELT.GT.NELTMAX ) GOTO 110
                  AZ(NELT)  = -AE - HX*DE
                  IA(NELT) = NEQ
                  JA(NELT) = NEQ + 1
               ENDIF
            ELSE
               RHS(NEQ) = RHS(NEQ) + (AE + HX*DE)*UB( 1.0, YY) 
            ENDIF
C
C ... North point.
C
            IF( J.NE.NY) THEN
               IF( .NOT.SYMM ) THEN
                  NELT = NELT + 1
                  IF( NELT.GT.NELTMAX ) GOTO 110
                  AZ(NELT)  = -CN - HY*EN
                  IA(NELT) = NEQ
                  JA(NELT) = NEQ + NX
               ENDIF
            ELSE
               RHS(NEQ) = RHS(NEQ) + (CN + HY*EN)*UB( XX, 1.0) 
            ENDIF
C
C ... West point.
C
            IF( I.NE.1 ) THEN
               NELT = NELT + 1
               IF( NELT.GT.NELTMAX ) GOTO 110
               AZ(NELT)  = -AW
               IA(NELT) = NEQ
               JA(NELT) = NEQ - 1
            ELSE
               RHS(NEQ) = RHS(NEQ) + AW*UB(0.0,YY)
            ENDIF
C
C ... South point.
C
            IF( J.NE.1 ) THEN
               NELT = NELT + 1
               IF( NELT.GT.NELTMAX ) GOTO 110
               AZ(NELT) = -CS
               IA(NELT) = NEQ
               JA(NELT) = NEQ - NX
            ELSE
               RHS(NEQ) = RHS(NEQ) + CS*UB(XX,0.0)
            ENDIF
 20      CONTINUE
 25   CONTINUE
C
C         Normal return.
      IERR = 0
      RETURN
C
C         Error return.
 100  IERR = -1
      RETURN
 110  IERR = -2
      RETURN
      END 
      REAL FUNCTION P(X,Y)
C
C..         Coeficient function for the PDE in MATGEN1
      P = .01 + X**2 + Y**2
      RETURN
      END
