C                               tridia():
C
C       Solves The Tridiagonal System Required For a Fast Poisson 
C       Solver.   This is correct for either Neumann or Dirichlet 
C       B.C. provided the Coefficient array ck[] is correctly 
C       initialized before call by calling init_tridia() - 
C       see psfivefft.c.

        SUBROUTINE tridia(n,ck,z)
        INTEGER n
        REAL ck(1),z(1)
C
        INTEGER j,m

        m = n+1
        z(1) = z(1)*ck(1)

        do 10 j=2,m
                z(j) = ck(j)*(z(j)+z(j-1))
   10   continue

        do 20 j=n,1,-1
                z(j) = z(j) + ck(j)*z(j+1)
   20   continue

        return
        end


C
C               Program to test the Gauss-Seidel Operator:
C
C       program test
C       real x(100),f(100),di(10000),fnorm
C       integer numdi,indi(100),m,n,prev,i,r,offset,j1,j2
C
C       m = 3
C       n = m*m
C       indi(1) = 0
C       indi(2) = 1
C       indi(3) = m
C       numdi = 3
C       do 10 i=1,n
C               x(i) = 0.
C               f(i) =  1 
C               di(i) = 4.0
C               prev = 0
C               do 20 r=2,numdi
C                       offset = indi(r)
C                       j1 = i + offset
C                       j2 = i - offset
C                       prev = prev + n
C                       if (j1 .le. n)  di(prev+i)  = -1.0
C                       if (j2 .gt. 0)  di(prev+j2) = -1.0
C   20          continue
C       
C   10  continue
C
C       call gausss(n,x,f,numdi,indi,di,fnorm)
C       write (6,1000) fnorm
C 1000  format ('fnorm =',1pe10.3)
C
C       stop 
C       end





C                               gausss():
C
C       Gauss-Seidel for a Symmetric Matrix:
C
        SUBROUTINE gausss(n,x,f,numdi,indi,di,fnorm)
        INTEGER    n,numdi,indi(1)
        REAL       x(1),f(1),di(1),fnorm
C
        INTEGER    i,r,offset,j1,j2,prev,bot,top
        REAL       res

        bot = indi(numdi)
        top = n - indi(numdi)
        fnorm = 0.0

C                       Bottom end:
        do 10 i=1,bot
                res = di(i)*x(i) - f(i)
                prev = 0
                do 20 r=2,numdi
                        offset = indi(r)
                        j1 = i + offset
                        j2 = i - offset
                        prev = prev + n
                        if (j1 .le. n)  res = res + di(prev+i)*x(j1)
                        if (j2 .gt. 0)  res = res + di(prev+j2)*x(j2)
   20           continue
                fnorm = fnorm + res*res
C               write (6,1000) i,res,fnorm
                x(i) = x(i) - res/di(i)
   10   continue

C                       Central Region:
C       THIS IS THE CRITICAL SEGMENT OF THE CODE:
C
        bot = bot+1
        do 30 i=bot,top
                res = di(i)*x(i) - f(i)
                prev = 0
                do 40 r=2,numdi
                        offset = indi(r)
                        j1 = i + offset
                        j2 = i - offset
                        prev = prev + n
                        res = res + di(prev+i)*x(j1) + di(prev+j2)*x(j2)
   40           continue
                
                fnorm = fnorm + res*res
C               write (6,1000) i,res,fnorm
                x(i) = x(i) - res/di(i)
   30   continue

C       END OF THE CRITICAL SEGMENT

C
C                       Top end:
        top = top+1
        do 50 i=top,n
                res = di(i)*x(i) - f(i)
                prev = 0
                do 60 r=2,numdi
                        offset = indi(r)
                        j1 = i + offset
                        j2 = i - offset
                        prev = prev + n
                        if (j1 .le. n)  res = res + di(prev+i)*x(j1)
                        if (j2 .gt. 0)  res = res + di(prev+j2)*x(j2)
   60           continue

                fnorm = fnorm + res*res
C               write (6,1000) i,res,fnorm
                x(i) = x(i) - res/di(i)
   50   continue

C1000   format ('i= ',i4, ' res= ',1pe10.3, ' norm= ',1pe10.3)
        fnorm = sqrt(fnorm)
        return
        end






C                               lgauss():
C
C       Local Gauss-Seidel for a Symmetric Matrix:   
C       The array local() of length nlocal, records those points
C       at which the gauss-seidel is to be performed.
C
        SUBROUTINE lgauss(n,x,f,numdi,indi,di,local,nlocal,fnorm)
        INTEGER    n,numdi,indi(1),local(1),nlocal
        REAL       x(1),f(1),di(1),fnorm
C
        INTEGER    i,r,offset,j1,j2,prev
        REAL       res

        fnorm = 0.0

        do 10 l=1,nlocal
                i = local(l)+1
                res = di(i)*x(i) - f(i)
                prev = 0
                do 20 r=2,numdi
                        offset = indi(r)
                        j1 = i + offset
                        j2 = i - offset
                        prev = prev + n
                        if (j1 .le. n)  res = res + di(prev+i)*x(j1)
                        if (j2 .gt. 0)  res = res + di(prev+j2)*x(j2)
   20           continue
                fnorm = fnorm + res*res
C               write (6,1000) i,res,fnorm
                x(i) = x(i) - res/di(i)
   10   continue

C1000   format ('i= ',i4, ' res= ',1pe10.3, ' norm= ',1pe10.3)
        fnorm = sqrt(fnorm)
        return
        end



C                               colorg():
C
C       Colored Gauss-Seidel for a Symmetric Matrix:
C
        SUBROUTINE colorg(numcol,n,x,f,numdi,indi,di,fnorm)
        INTEGER    numcol,n,numdi,indi(1)
        REAL       x(1),f(1),di(1),fnorm
C
        INTEGER    i,r,offset,j1,j2,prev,bot,top,color
        REAL       res

        bot = indi(numdi)
        top = n - indi(numdi)
        fnorm = 0.0

C                       Bottom end:
        do  1 color=numcol-1,0,-1
        do 10 i=1,bot
                if (mod(i,numcol) .ne. color) goto 10
                res = di(i)*x(i) - f(i)
                prev = 0
                do 20 r=2,numdi
                        offset = indi(r)
                        j1 = i + offset
                        j2 = i - offset
                        prev = prev + n
                        if (j1 .le. n)  res = res + di(prev+i)*x(j1)
                        if (j2 .gt. 0)  res = res + di(prev+j2)*x(j2)
   20           continue
                fnorm = fnorm + res*res
C               write (6,1000) i,res,fnorm
                x(i) = x(i) - res/di(i)
   10   continue

C                       Central Region:
C       THIS IS THE CRITICAL SEGMENT OF THE CODE:
C
        bot = bot+1

        do 30 i=bot,top
                if (mod(i,numcol) .ne. color) goto 30
                res = di(i)*x(i) - f(i)
                prev = 0
                do 40 r=2,numdi
                        offset = indi(r)
                        j1 = i + offset
                        j2 = i - offset
                        prev = prev + n
                        res = res + di(prev+i)*x(j1) + di(prev+j2)*x(j2)
   40           continue
                
                fnorm = fnorm + res*res
C               write (6,1000) i,res,fnorm
                x(i) = x(i) - res/di(i)
   30   continue

C       END OF THE CRITICAL SEGMENT

C
C                       Top end:
        top = top+1
        do 50 i=top,n
                if (mod(i,numcol) .ne. color) goto 50
                res = di(i)*x(i) - f(i)
                prev = 0
                do 60 r=2,numdi
                        offset = indi(r)
                        j1 = i + offset
                        j2 = i - offset
                        prev = prev + n
                        if (j1 .le. n)  res = res + di(prev+i)*x(j1)
                        if (j2 .gt. 0)  res = res + di(prev+j2)*x(j2)
   60           continue

                fnorm = fnorm + res*res
C               write (6,1000) i,res,fnorm
                x(i) = x(i) - res/di(i)
   50   continue
    1   continue

C1000   format ('i= ',i4, ' res= ',1pe10.3, ' norm= ',1pe10.3)
        fnorm = sqrt(fnorm)
        return
        end

