#if !defined(_FITPACK_H)
#define _FITPACK_H

#include <cdecs.h>

#if defined(__cplusplus)
extern "C" {
#endif /* defined(__cplusplus) */

#   if defined(cray)

#       if defined(float)

#           define curv2  DCURV2
#           define curvd  DCURVD
#           define curvi  DCURVI
#           define curvp2 DCURVP2
#           define curvpi DCURVPI
#           define surf2  DSURF2
#           define curv1  DCURV1
#           define curvp1 DCURVP1
#           define curvps DCURVPS
#           define curvs  DCURVS
#           define kurv1  DKURV1
#           define kurv2  DKURV2
#           define kurvd  DKURVD
#           define kurvp1 DKURVP1
#           define kurvp2 DKURVP2
#           define kurvpd DKURVPD
#           define surf1  DSURF1

#           if defined(EXPORT_FITPACK_LOCALS)
#               define intrvl DINTRVL
#               define intrvp DINTRVP
#               define ceez   DCEEZ
#               define curvpp DCURVPP
#               define curvss DCURVSS
#               define snhcsh DSNHCSH
#               define terms  DTERMS
#           endif /*defined(EXPORT_FITPACK_LOCALS)*/

#       else /* defined(float) */

#           define curv2  CURV2
#           define curvd  CURVD
#           define curvi  CURVI
#           define curvp2 CURVP2
#           define curvpi CURVPI
#           define surf2  SURF2
#           define curv1  CURV1
#           define curvp1 CURVP1
#           define curvps CURVPS
#           define curvs  CURVS
#           define kurv1  KURV1
#           define kurv2  KURV2
#           define kurvd  KURVD
#           define kurvp1 KURVP1
#           define kurvp2 KURVP2
#           define kurvpd KURVPD
#           define surf1  SURF1

#           if defined(EXPORT_FITPACK_LOCALS)
#               define intrvl INTRVL
#               define intrvp INTRVP
#               define ceez   CEEZ
#               define curvpp CURVPP
#               define curvss CURVSS
#               define snhcsh SNHCSH
#               define terms  TERMS
#           endif /*defined(EXPORT_FITPACK_LOCALS)*/

#       endif /* defined(float) */

#   else /*defined(cray)*/

#       if defined(float)
#           define curv2  dcurv2
#           define curvd  dcurvd
#           define curvi  dcurvi
#           define curvp2 dcurvp2
#           define curvpi dcurvpi
#           define surf2  dsurf2
#           define curv1  dcurv1
#           define curvp1 dcurvp1
#           define curvps dcurvps
#           define curvs  dcurvs
#           define kurv1  dkurv1
#           define kurv2  dkurv2
#           define kurvd  dkurvd
#           define kurvp1 dkurvp1
#           define kurvp2 dkurvp2
#           define kurvpd dkurvpd
#           define surf1  dsurf1

#           if defined(EXPORT_FITPACK_LOCALS)
#               define intrvl dintrvl
#               define intrvp dintrvp
#               define ceez   dceez
#               define curvpp dcurvpp
#               define curvss dcurvss
#               define snhcsh dsnhcsh
#               define terms  dterms
#           endif /*defined(EXPORT_FITPACK_LOCALS)*/
#       endif /* defined(float) */

#   endif /*defined(cray)*/

#if !defined(float)
FORTRAN float FORTRAN_NAME(dcurv2)(double*,int*,double*,double*,double*,
                                   double*);
FORTRAN double FORTRAN_NAME(dcurvd)(double*,int*,double*,double*,double*,
                                    double*);
FORTRAN double FORTRAN_NAME(dcurvi)(double*,double*,int*,double*,double*,
                                    double*,double*);
FORTRAN double FORTRAN_NAME(dcurvp2)(double*,int*,double*,double*,double*,
                                     double*,double*);
FORTRAN double FORTRAN_NAME(dcurvpi)(double*,double*,int*,double*,double*,
                                     double*,double*,double*);
FORTRAN double FORTRAN_NAME(dsurf2)(double*,double*,int*,int*,double*,double*,
                                    double*,int*,double*,double*);
FORTRAN void FORTRAN_NAME(dcurv1)(int*,double*,double*,double*,double*,
                                  int*,double*,double*,double*,int*);
FORTRAN void FORTRAN_NAME(dcurvp1)(int*,double*,double*,double*,double*,
                                   double*,double*,int*);
FORTRAN void FORTRAN_NAME(dcurvps)(int*,double*,double*,double*,double*,int*,
                                   double*,double*,double*,double*,double*,
				   double*,int*);
FORTRAN void FORTRAN_NAME(dcurvs)(int*,double*,double*,double*,int*,double*,
                                  double*,double*,double*,double*,double*,int*);
FORTRAN void FORTRAN_NAME(dkurv1)(int*,double*,double*,double*,double*,int*,
                                  double*,double*,double*,double*,double*,int*);
FORTRAN void FORTRAN_NAME(dkurv2)(double*,double*,double*,int*,double*,double*,
                                  double*,double*,double*,double*);
FORTRAN void FORTRAN_NAME(dkurvd)(double*,double*,double*,double*,double*,
                                  double*,double*,int*,double*,double*,
				  double*,double*,double*,double*);
FORTRAN void FORTRAN_NAME(dkurvp1)(int*,double*,double*,double*,double*,
                                   double*,double*,double*,int*);
FORTRAN void FORTRAN_NAME(dkurvp2)(double*,double*,double*,int*,double*,
                                   double*,double*,double*,double*,double*);
FORTRAN void FORTRAN_NAME(dkurvpd)(double*,double*,double*,double*,double*,
                                   double*,double*,int*,double*,double*,
				   double*,double*,double*,double*);
FORTRAN void FORTRAN_NAME(dsurf1)(int*,int*,double*,double*,double*,int*,
                                  double*,double*,double*,double*,double*,
				  double*,double*,double*,int*,double*,
				  double*,double*,int*);

#if defined(EXPORT_FITPACK_LOCALS)
/* LOCAL TO Library */
FORTRAN int FORTRAN_NAME(dintrvl)(double*,double*,int*);
FORTRAN int FORTRAN_NAME(dintrvp)(double*,double*,int*,double*,double*);
FORTRAN void FORTRAN_NAME(dceez)(double*,double*,double*,double*,double*,
                                double*,int*);
FORTRAN void FORTRAN_NAME(dcurvpp)(int*,double*,double*,double*,double*,int*,
                                  double*,double*,double*,double*,double*,
				  double*,double*,double*,double*,double*,
				  double*,double*,double*,double*,double*,
				  double*,int*);
FORTRAN void FORTRAN_NAME(dcurvss)(int*,double*,double*,double*,int*,double*,
				  double*,double*,double*,double*,double*,
				  double*,double*,double*,double*,double*,
				  double*,double*,double*,int*);
FORTRAN void FORTRAN_NAME(dsnhcsh)(double*,double*,double*,int*);
FORTRAN void  FORTRAN_NAME(dterms)(double*,double*,double*,double*);
#endif /*defined(EXPORT_FITPACK_LOCALS)*/

#endif /*!defined(float)*/

FORTRAN float FORTRAN_NAME(curv2)(float*,int*,float*,float*,float*,float*);
FORTRAN float FORTRAN_NAME(curvd)(float*,int*,float*,float*,float*,float*);
FORTRAN float FORTRAN_NAME(curvi)(float*,float*,int*,float*,float*,
                                  float*,float*);
FORTRAN float FORTRAN_NAME(curvp2)(float*,int*,float*,float*,float*,
                                   float*,float*);
FORTRAN float FORTRAN_NAME(curvpi)(float*,float*,int*,float*,float*,
                                   float*,float*,float*);
FORTRAN float FORTRAN_NAME(surf2)(float*,float*,int*,int*,float*,float*,
                                  float*,int*,float*,float*);
FORTRAN void FORTRAN_NAME(curv1)(int*,float*,float*,float*,float*,
                                 int*,float*,float*,float*,int*);
FORTRAN void FORTRAN_NAME(curvp1)(int*,float*,float*,float*,float*,
                                  float*,float*,int*);
FORTRAN void FORTRAN_NAME(curvps)(int*,float*,float*,float*,float*,int*,float*,
                                  float*,float*,float*,float*,float*,int*);
FORTRAN void FORTRAN_NAME(curvs)(int*,float*,float*,float*,int*,float*,float*,
                                 float*,float*,float*,float*,int*);
FORTRAN void FORTRAN_NAME(kurv1)(int*,float*,float*,float*,float*,int*,float*,
                                 float*,float*,float*,float*,int*);
FORTRAN void FORTRAN_NAME(kurv2)(float*,float*,float*,int*,float*,float*,
                                 float*,float*,float*,float*);
FORTRAN void FORTRAN_NAME(kurvd)(float*,float*,float*,float*,float*,float*,
                                 float*,int*,float*,float*,float*,float*,
				 float*,float*);
FORTRAN void FORTRAN_NAME(kurvp1)(int*,float*,float*,float*,float*,float*,
                                  float*,float*,int*);
FORTRAN void FORTRAN_NAME(kurvp2)(float*,float*,float*,int*,float*,float*,
                                  float*,float*,float*,float*);
FORTRAN void FORTRAN_NAME(kurvpd)(float*,float*,float*,float*,float*,float*,
                                  float*,int*,float*,float*,float*,float*,
				  float*,float*);
FORTRAN void FORTRAN_NAME(surf1)(int*,int*,float*,float*,float*,int*,float*,
                                 float*,float*,float*,float*,float*,float*,
				 float*,int*,float*,float*,float*,int*);

#if defined(EXPORT_FITPACK_LOCALS)
/* LOCAL TO Library */
FORTRAN int FORTRAN_NAME(intrvl)(float*,float*,int*);
FORTRAN int FORTRAN_NAME(intrvp)(float*,float*,int*,float*,float*);
FORTRAN void FORTRAN_NAME(ceez)(float*,float*,float*,float*,float*,float*,int*);
FORTRAN void FORTRAN_NAME(curvpp)(int*,float*,float*,float*,float*,int*,
                                  float*,float*,float*,float*,float*,float*,
				  float*,float*,float*,float*,float*,float*,
				  float*,float*,float*,float*,int*);
FORTRAN void FORTRAN_NAME(curvss)(int*,float*,float*,float*,int*,float*,float*,
                                  float*,float*,float*,float*,float*,float*,
				  float*,float*,float*,float*,float*,float*,
				  int*);
FORTRAN void FORTRAN_NAME(snhcsh)(float*,float*,float*,int*);
FORTRAN void  FORTRAN_NAME(terms)(float*,float*,float*,float*);
#endif /*defined(EXPORT_FITPACK_LOCALS)*/

#if defined(__cplusplus)
}
#endif /* defined(__cplusplus) */

#endif /*!defined(_FITPACK_H)*/
