C FISHPAK11  FROM PORTLIB                                  07/25/81
      SUBROUTINE HSTCSP (INTL,A,B,M,MBDCND,BDA,BDB,C,D,N,NBDCND,BDC,
     1                   BDD,ELMBDA,F,IDIMF,PERTRB,IERROR,W)
C
C
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C     *                                                               *
C     *                        F I S H P A K                          *
C     *                                                               *
C     *                                                               *
C     *     A PACKAGE OF FORTRAN SUBPROGRAMS FOR THE SOLUTION OF      *
C     *                                                               *
C     *      SEPARABLE ELLIPTIC PARTIAL DIFFERENTIAL EQUATIONS        *
C     *                                                               *
C     *                  (VERSION 3.1 , OCTOBER 1980)                  *
C     *                                                               *
C     *                             BY                                *
C     *                                                               *
C     *        JOHN ADAMS, PAUL SWARZTRAUBER AND ROLAND SWEET         *
C     *                                                               *
C     *                             OF                                *
C     *                                                               *
C     *         THE NATIONAL CENTER FOR ATMOSPHERIC RESEARCH          *
C     *                                                               *
C     *                BOULDER, COLORADO  (80307)  U.S.A.             *
C     *                                                               *
C     *                   WHICH IS SPONSORED BY                       *
C     *                                                               *
C     *              THE NATIONAL SCIENCE FOUNDATION                  *
C     *                                                               *
C     * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
C
C    * * * * * * * * *  PURPOSE    * * * * * * * * * * * * * * * * * *
C
C     HSTCSP SOLVES THE STANDARD FIVE-POINT FINITE DIFFERENCE
C     APPROXIMATION ON A STAGGERED GRID TO THE MODIFIED HELMHOLTZ EQUATI
C     SPHERICAL COORDINATES ASSUMING AXISYMMETRY (NO DEPENDENCE ON
C     LONGITUDE)
C
C                  (1/R**2)(D/DR)(R**2(DU/DR)) +
C
C       1/(R**2*SIN(THETA))(D/DTHETA)(SIN(THETA)(DU/DTHETA)) +
C
C            (LAMBDA/(R*SIN(THETA))**2)U  =  F(THETA,R)
C
C     WHERE THETA IS COLATITUDE AND R IS THE RADIAL COORDINATE.
C     THIS TWO-DIMENSIONAL MODIFIED HELMHOLTZ EQUATION RESULTS FROM
C     THE FOURIER TRANSFORM OF THE THREE-DIMENSIONAL POISSON EQUATION.
C
C    * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
C
C    * * * * * * * *    PARAMETER DESCRIPTION     * * * * * * * * * *
C
C
C            * * * * * *   ON INPUT    * * * * * *
C
C   INTL
C     = 0  ON INITIAL ENTRY TO HSTCSP OR IF ANY OF THE ARGUMENTS
C          C, D, N, OR NBDCND ARE CHANGED FROM A PREVIOUS CALL
C
C     = 1  IF C, D, N, AND NBDCND ARE ALL UNCHANGED FROM PREVIOUS
C          CALL TO HSTCSP
C
C     NOTE:  A CALL WITH INTL = 0 TAKES APPROXIMATELY 1.5 TIMES AS MUCH
C            TIME AS A CALL WITH INTL = 1.  ONCE A CALL WITH INTL = 0
C            HAS BEEN MADE THEN SUBSEQUENT SOLUTIONS CORRESPONDING TO
C            DIFFERENT F, BDA, BDB, BDC, AND BDD CAN BE OBTAINED
C            FASTER WITH INTL = 1 SINCE INITIALIZATION IS NOT REPEATED.
C
C   A,B
C     THE RANGE OF THETA (COLATITUDE), I.E. A .LE. THETA .LE. B.  A
C     MUST BE LESS THAN B AND A MUST BE NON-NEGATIVE.  A AND B ARE IN
C     RADIANS.  A = 0 CORRESPONDS TO THE NORTH POLE AND B = PI
C     CORRESPONDS TO THE SOUTH POLE.
C
C                  * * *  IMPORTANT  * * *
C
C     IF B IS EQUAL TO PI, THEN B MUST BE COMPUTED USING THE STATEMENT
C
C     B = PIMACH(DUM)
C
C     THIS INSURES THAT B IN THE USER'S PROGRAM IS EQUAL TO PI IN THIS
C     PROGRAM WHICH PERMITS SEVERAL TESTS OF THE INPUT PARAMETERS THAT
C     OTHERWISE WOULD NOT BE POSSIBLE.
C
C                  * * * * * * * * * * * *
C
C   M
C     THE NUMBER OF GRID POINTS IN THE INTERVAL (A,B).  THE GRID POINTS
C     IN THE THETA-DIRECTION ARE GIVEN BY THETA(I) = A + (I-0.5)DTHETA
C     FOR I=1,2,...,M WHERE DTHETA =(B-A)/M.  M MUST BE GREATER THAN 4.
C
C   MBDCND
C     INDICATES THE TYPE OF BOUNDARY CONDITIONS AT THETA = A AND
C     THETA = B.
C
C     = 1  IF THE SOLUTION IS SPECIFIED AT THETA = A AND THETA = B.
C          (SEE NOTES 1, 2 BELOW)
C
C     = 2  IF THE SOLUTION IS SPECIFIED AT THETA = A AND THE DERIVATIVE
C          OF THE SOLUTION WITH RESPECT TO THETA IS SPECIFIED AT
C          THETA = B (SEE NOTES 1, 2 BELOW).
C
C     = 3  IF THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO THETA IS
C          SPECIFIED AT THETA = A (SEE NOTES 1, 2 BELOW) AND THETA = B.
C
C     = 4  IF THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO THETA IS
C          SPECIFIED AT THETA = A (SEE NOTES 1, 2 BELOW) AND THE
C          SOLUTION IS SPECIFIED AT THETA = B.
C
C     = 5  IF THE SOLUTION IS UNSPECIFIED AT THETA = A = 0 AND THE
C          SOLUTION IS SPECIFIED AT THETA = B. (SEE NOTE 2 BELOW)
C
C     = 6  IF THE SOLUTION IS UNSPECIFIED AT THETA = A = 0 AND THE
C          DERIVATIVE OF THE SOLUTION WITH RESPECT TO THETA IS
C          SPECIFIED AT THETA = B (SEE NOTE 2 BELOW).
C
C     = 7  IF THE SOLUTION IS SPECIFIED AT THETA = A AND THE
C          SOLUTION IS UNSPECIFIED AT THETA = B = PI.
C
C     = 8  IF THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO
C          THETA IS SPECIFIED AT THETA = A (SEE NOTE 1 BELOW)
C          AND THE SOLUTION IS UNSPECIFIED AT THETA = B = PI.
C
C     = 9  IF THE SOLUTION IS UNSPECIFIED AT THETA = A = 0 AND
C          THETA = B = PI.
C
C     NOTES:  1.  IF A = 0, DO NOT USE MBDCND = 1,2,3,4,7 OR 8,
C                 BUT INSTEAD USE MBDCND = 5, 6, OR 9.
C
C             2.  IF B = PI, DO NOT USE MBDCND = 1,2,3,4,5 OR 6,
C                 BUT INSTEAD USE MBDCND = 7, 8, OR 9.
C
C             WHEN A = 0  AND/OR B = PI THE ONLY MEANINGFUL BOUNDARY
C             CONDITION IS DU/DTHETA = 0.  (SEE D. GREENSPAN, "NUMERICAL
C             ANALYSIS OF ELLIPTIC BOUNDARY VALUE PROBLEMS," HARPER AND
C             ROW, 1965, CHAPTER 5.)
C
C   BDA
C     A ONE-DIMENSIONAL ARRAY OF LENGTH N THAT SPECIFIES THE BOUNDARY
C     VALUES (IF ANY) OF THE SOLUTION AT THETA = A.  WHEN
C     MBDCND = 1, 2, OR 7,
C
C              BDA(J) = U(A,R(J)) ,              J=1,2,...,N.
C
C     WHEN MBDCND = 3, 4, OR 8,
C
C              BDA(J) = (D/DTHETA)U(A,R(J)) ,    J=1,2,...,N.
C
C     WHEN MBDCND HAS ANY OTHER VALUE, BDA IS A DUMMY VARIABLE.
C
C   BDB
C     A ONE-DIMENSIONAL ARRAY OF LENGTH N THAT SPECIFIES THE BOUNDARY
C     VALUES OF THE SOLUTION AT THETA = B.  WHEN MBDCND = 1, 4, OR 5,
C
C              BDB(J) = U(B,R(J)) ,              J=1,2,...,N.
C
C     WHEN MBDCND = 2,3, OR 6,
C
C              BDB(J) = (D/DTHETA)U(B,R(J)) ,    J=1,2,...,N.
C
C     WHEN MBDCND HAS ANY OTHER VALUE, BDB IS A DUMMY VARIABLE.
C
C   C,D
C     THE RANGE OF R , I.E. C .LE. R .LE. D.
C     C MUST BE LESS THAN D.  C MUST BE NON-NEGATIVE.
C
C   N
C     THE NUMBER OF UNKNOWNS IN THE INTERVAL (C,D).  THE UNKNOWNS IN
C     THE R-DIRECTION ARE GIVEN BY R(J) = C + (J-0.5)DR,
C     J=1,2,...,N, WHERE DR = (D-C)/N.  N MUST BE GREATER THAN 4.
C
C   NBDCND
C     INDICATES THE TYPE OF BOUNDARY CONDITIONS AT R = C
C     AND R = D.
C
C     = 1  IF THE SOLUTION IS SPECIFIED AT R = C AND R = D.
C
C     = 2  IF THE SOLUTION IS SPECIFIED AT R = C AND THE DERIVATIVE
C          OF THE SOLUTION WITH RESPECT TO R IS SPECIFIED AT
C          R = D. (SEE NOTE 1 BELOW)
C
C     = 3  IF THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO R IS
C          SPECIFIED AT R = C AND R = D.
C
C     = 4  IF THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO R IS
C          SPECIFIED AT R = C AND THE SOLUTION IS SPECIFIED AT
C          R = D.
C
C     = 5  IF THE SOLUTION IS UNSPECIFIED AT R = C = 0 (SEE NOTE 2
C          BELOW) AND THE SOLUTION IS SPECIFIED AT R = D.
C
C     = 6  IF THE SOLUTION IS UNSPECIFIED AT R = C = 0 (SEE NOTE 2
C          BELOW) AND THE DERIVATIVE OF THE SOLUTION WITH RESPECT TO R
C          IS SPECIFIED AT R = D.
C
C     NOTE 1:  IF C = 0 AND MBDCND = 3,6,8 OR 9, THE SYSTEM OF EQUATIONS
C              TO BE SOLVED IS SINGULAR.  THE UNIQUE SOLUTION IS
C              DETERMINED BY EXTRAPOLATION TO THE SPECIFICATION OF
C              U(THETA(1),C).  BUT IN THESE CASES THE RIGHT SIDE OF THE
C              SYSTEM WILL BE PERTURBED BY THE CONSTANT PERTRB.
C
C     NOTE 2:  NBDCND = 5 OR 6 CANNOT BE USED WITH MBDCND = 1, 2, 4, 5,
C              OR 7 (THE FORMER INDICATES THAT THE SOLUTION IS
C              UNSPECIFIED AT R = 0; THE LATTER INDICATES THAT THE
C              SOLUTION IS SPECIFIED).  USE INSTEAD NBDCND = 1 OR 2.
C
C   BDC
C     A ONE DIMENSIONAL ARRAY OF LENGTH M THAT SPECIFIES THE BOUNDARY
C     VALUES OF THE SOLUTION AT R = C.   WHEN NBDCND = 1 OR 2,
C
C              BDC(I) = U(THETA(I),C) ,              I=1,2,...,M.
C
C     WHEN NBDCND = 3 OR 4,
C
C              BDC(I) = (D/DR)U(THETA(I),C),         I=1,2,...,M.
C
C     WHEN NBDCND HAS ANY OTHER VALUE, BDC IS A DUMMY VARIABLE.
C
C   BDD
C     A ONE-DIMENSIONAL ARRAY OF LENGTH M THAT SPECIFIES THE BOUNDARY
C     VALUES OF THE SOLUTION AT R = D.  WHEN NBDCND = 1 OR 4,
C
C              BDD(I) = U(THETA(I),D) ,              I=1,2,...,M.
C
C     WHEN NBDCND = 2 OR 3,
C
C              BDD(I) = (D/DR)U(THETA(I),D) ,        I=1,2,...,M.
C
C     WHEN NBDCND HAS ANY OTHER VALUE, BDD IS A DUMMY VARIABLE.
C
C   ELMBDA
C     THE CONSTANT LAMBDA IN THE MODIFIED HELMHOLTZ EQUATION.  IF
C     LAMBDA IS GREATER THAN 0, A SOLUTION MAY NOT EXIST.  HOWEVER,
C     HSTCSP WILL ATTEMPT TO FIND A SOLUTION.
C
C   F
C     A TWO-DIMENSIONAL ARRAY THAT SPECIFIES THE VALUES OF THE RIGHT
C     SIDE OF THE MODIFIED HELMHOLTZ EQUATION.  FOR I=1,2,...,M AND
C     J=1,2,...,N
C
C              F(I,J) = F(THETA(I),R(J)) .
C
C     F MUST BE DIMENSIONED AT LEAST M X N.
C
C   IDIMF
C     THE ROW (OR FIRST) DIMENSION OF THE ARRAY F AS IT APPEARS IN THE
C     PROGRAM CALLING HSTCSP.  THIS PARAMETER IS USED TO SPECIFY THE
C     VARIABLE DIMENSION OF F.  IDIMF MUST BE AT LEAST M.
C
C   W
C     A ONE-DIMENSIONAL ARRAY THAT MUST BE PROVIDED BY THE USER FOR
C     WORK SPACE.  WITH K = INT(LOG2(N))+1 AND L = 2**(K+1), W MAY
C     REQUIRE UP TO (K-2)*L+K+MAX(2N,6M)+4(N+M)+5 LOCATIONS.  THE
C     ACTUAL NUMBER OF LOCATIONS USED IS COMPUTED BY HSTCSP AND IS
C     RETURNED IN THE LOCATION W(1).
C
C
C            * * * * * *   ON OUTPUT   * * * * * *
C
C   F
C     CONTAINS THE SOLUTION U(I,J) OF THE FINITE DIFFERENCE
C     APPROXIMATION FOR THE GRID POINT (THETA(I),R(J)) FOR
C     I=1,2,...,M, J=1,2,...,N.
C
C   PERTRB
C     IF A COMBINATION OF PERIODIC, DERIVATIVE, OR UNSPECIFIED
C     BOUNDARY CONDITIONS IS SPECIFIED FOR A POISSON EQUATION
C     (LAMBDA = 0), A SOLUTION MAY NOT EXIST.  PERTRB IS A CON-
C     STANT, CALCULATED AND SUBTRACTED FROM F, WHICH ENSURES
C     THAT A SOLUTION EXISTS.  HSTCSP THEN COMPUTES THIS
C     SOLUTION, WHICH IS A LEAST SQUARES SOLUTION TO THE
C     ORIGINAL APPROXIMATION.  THIS SOLUTION PLUS ANY CONSTANT IS ALSO
C     A SOLUTION; HENCE, THE SOLUTION IS NOT UNIQUE.  THE VALUE OF
C     PERTRB SHOULD BE SMALL COMPARED TO THE RIGHT SIDE F.
C     OTHERWISE, A SOLUTION IS OBTAINED TO AN ESSENTIALLY DIFFERENT
C     PROBLEM.  THIS COMPARISON SHOULD ALWAYS BE MADE TO INSURE THAT
C     A MEANINGFUL SOLUTION HAS BEEN OBTAINED.
C
C   IERROR
C     AN ERROR FLAG THAT INDICATES INVALID INPUT PARAMETERS.
C     EXCEPT FOR NUMBERS 0 AND 10, A SOLUTION IS NOT ATTEMPTED.
C
C     =  0  NO ERROR
C
C     =  1  A .LT. 0 OR B .GT. PI
C
C     =  2  A .GE. B
C
C     =  3  MBDCND .LT. 1 OR MBDCND .GT. 9
C
C     =  4  C .LT. 0
C
C     =  5  C .GE. D
C
C     =  6  NBDCND .LT. 1 OR NBDCND .GT. 6
C
C     =  7  N .LT. 5
C
C     =  8  NBDCND = 5 OR 6 AND MBDCND = 1, 2, 4, 5, OR 7
C
C     =  9  C .GT. 0 AND NBDCND .GE. 5
C
C     = 10  ELMBDA .GT. 0
C
C     = 11  IDIMF .LT. M
C
C     = 12  M .LT. 5
C
C     = 13  A = 0 AND MBDCND =1,2,3,4,7 OR 8
C
C     = 14  B = PI AND MBDCND .LE. 6
C
C     = 15  A .GT. 0 AND MBDCND = 5, 6, OR 9
C
C     = 16  B .LT. PI AND MBDCND .GE. 7
C
C     = 17  LAMBDA .NE. 0 AND NBDCND .GE. 5
C
C     SINCE THIS IS THE ONLY MEANS OF INDICATING A POSSIBLY
C     INCORRECT CALL TO HSTCSP, THE USER SHOULD TEST IERROR AFTER
C     THE CALL.
C
C   W
C     W(1) CONTAINS THE REQUIRED LENGTH OF W.  ALSO  W CONTAINS
C     INTERMEDIATE VALUES THAT MUST NOT BE DESTROYED IF HSTCSP
C     WILL BE CALLED AGAIN WITH INTL = 1.
C
C
C    * * * * * * *   PROGRAM SPECIFICATIONS    * * * * * * * * * * * *
C
C    DIMENSION OF   BDA(N),BDB(N),BDC(M),BDD(M),F(IDIMF,N),
C    ARGUMENTS      W(SEE ARGUMENT LIST)
C
C    LATEST         JUNE 1979
C    REVISION
C
C    SUBPROGRAMS    HSTCSP,HSTCS1,BLKTRI,BLKTR1,INDXA,INDXB,INDXC,
C    REQUIRED       PROD,PRODP,CPROD,CPRODP,PPADD,PSGF,BSRH,PPSGF,
C                   PPSPF,COMPB,TEVLS,EPMACH,STORE
C
C    SPECIAL        NONE
C    CONDITIONS
C
C    COMMON         CBLKT,VALU1
C    BLOCKS
C
C    I/O            NONE
C
C    PRECISION      SINGLE
C
C    SPECIALIST     ROLAND SWEET
C
C    LANGUAGE       FORTRAN
C
C    HISTORY        WRITTEN BY ROLAND SWEET AT NCAR IN MAY, 1977
C
C    ALGORITHM      THIS SUBROUTINE DEFINES THE FINITE-DIFFERENCE
C                   EQUATIONS, INCORPORATES BOUNDARY DATA, ADJUSTS THE
C                   RIGHT SIDE WHEN THE SYSTEM IS SINGULAR AND CALLS
C                   BLKTRI WHICH SOLVES THE LINEAR SYSTEM OF EQUATIONS.
C
C    SPACE          5269(DECIMAL) = 12225(OCTAL) LOCATIONS ON THE
C    REQUIRED       NCAR CONTROL DATA 7600
C
C    TIMING AND        THE EXECUTION TIME T ON THE NCAR CONTROL DATA
C    ACCURACY       7600 FOR SUBROUTINE HSTCSP IS ROUGHLY PROPORTIONAL
C                   TO M*N*LOG2(N), BUT DEPENDS ON THE INPUT PARAMETER
C                   INTL.  SOME VALUES ARE LISTED IN THE TABLE BELOW.
C                      THE SOLUTION PROCESS EMPLOYED RESULTS IN A LOSS
C                   OF NO MORE THAN FOUR SIGNIFICANT DIGITS FOR N AND M
C                   AS LARGE AS 64.  MORE DETAILED INFORMATION ABOUT
C                   ACCURACY CAN BE FOUND IN THE DOCUMENTATION FOR
C                   SUBROUTINE BLKTRI WHICH IS THE ROUTINE THAT
C                   ACTUALLY SOLVES THE FINITE DIFFERENCE EQUATIONS.
C
C
C                      M(=N)     INTL      MBDCND(=NBDCND)     T(MSECS)
C                      -----     ----      ---------------     --------
C
C                       32        0              1-6             132
C                       32        1              1-6              88
C                       64        0              1-6             546
C                       64        1              1-6             380
C
C    PORTABILITY    AMERICAN NATIONAL STANDARDS INSTITUTE FORTRAN.
C                   AN APPROXIMATE MACHINE EPSILON IS COMPUTED IN
C                   FUNCTION PIMACH.
C
C    REQUIRED       COS,SIN,CABS,CSQRT
C    RESIDENT
C    ROUTINES
C
C    REFERENCE      SWARZTRAUBER, P.N., 'A DIRECT METHOD FOR THE
C                   DISCRETE SOLUTION OF SEPARABLE ELLIPTIC EQUATIONS,'
C                   SIAM J. NUMER. ANAL. 11(1974), PP. 1136-1150.
C                   ARBITRARY SIZE,' J. COMP. PHYS. 20(1976),
C                   PP. 171-182.
C
C    * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
      DIMENSION       F(IDIMF,1) ,BDA(1)     ,BDB(1)     ,BDC(1)     ,
     1                BDD(1)     ,W(1)
      PI = PIMACH(DUM)
C
C     CHECK FOR INVALID INPUT PARAMETERS
C
      IERROR = 0
      IF (A.LT.0. .OR. B.GT.PI) IERROR = 1
      IF (A .GE. B) IERROR = 2
      IF (MBDCND.LT.1 .OR. MBDCND.GT.9) IERROR = 3
      IF (C .LT. 0.) IERROR = 4
      IF (C .GE. D) IERROR = 5
      IF (NBDCND.LT.1 .OR. NBDCND.GT.6) IERROR = 6
      IF (N .LT. 5) IERROR = 7
      IF ((NBDCND.EQ.5 .OR. NBDCND.EQ.6) .AND. (MBDCND.EQ.1 .OR.
     1    MBDCND.EQ.2 .OR. MBDCND.EQ.4 .OR. MBDCND.EQ.5 .OR.
     2                                                     MBDCND.EQ.7))
     3    IERROR = 8
      IF (C.GT.0. .AND. NBDCND.GE.5) IERROR = 9
      IF (IDIMF .LT. M) IERROR = 11
      IF (M .LT. 5) IERROR = 12
      IF (A.EQ.0. .AND. MBDCND.NE.5 .AND. MBDCND.NE.6 .AND. MBDCND.NE.9)
     1    IERROR = 13
      IF (B.EQ.PI .AND. MBDCND.LE.6) IERROR = 14
      IF (A.GT.0. .AND. (MBDCND.EQ.5 .OR. MBDCND.EQ.6 .OR. MBDCND.EQ.9))
     1    IERROR = 15
      IF (B.LT.PI .AND. MBDCND.GE.7) IERROR = 16
      IF (ELMBDA.NE.0. .AND. NBDCND.GE.5) IERROR = 17
      IF (IERROR .NE. 0) GO TO 101
      IWBM = M+1
      IWCM = IWBM+M
      IWAN = IWCM+M
      IWBN = IWAN+N
      IWCN = IWBN+N
      IWSNTH = IWCN+N
      IWRSQ = IWSNTH+M
      IWWRK = IWRSQ+N
      IERR1 = 0
      CALL HSTCS1 (INTL,A,B,M,MBDCND,BDA,BDB,C,D,N,NBDCND,BDC,BDD,
     1             ELMBDA,F,IDIMF,PERTRB,IERR1,W,W(IWBM),W(IWCM),
     2             W(IWAN),W(IWBN),W(IWCN),W(IWSNTH),W(IWRSQ),W(IWWRK))
      W(1) = W(IWWRK)+FLOAT(IWWRK-1)
      IERROR = IERR1
  101 CONTINUE
      RETURN
      END
      SUBROUTINE HSTCS1 (INTL,A,B,M,MBDCND,BDA,BDB,C,D,N,NBDCND,BDC,
     1                   BDD,ELMBDA,F,IDIMF,PERTRB,IERR1,AM,BM,CM,AN,
     2                   BN,CN,SNTH,RSQ,WRK)
      DIMENSION       BDA(1)     ,BDB(1)     ,BDC(1)     ,BDD(1)     ,
     1                F(IDIMF,1) ,AM(1)      ,BM(1)      ,CM(1)      ,
     2                AN(1)      ,BN(1)      ,CN(1)      ,SNTH(1)    ,
     3                RSQ(1)     ,WRK(1)
      DTH = (B-A)/FLOAT(M)
      DTHSQ = DTH*DTH
      DO 101 I=1,M
         SNTH(I) = SIN(A+(FLOAT(I)-0.5)*DTH)
  101 CONTINUE
      DR = (D-C)/FLOAT(N)
      DO 102 J=1,N
         RSQ(J) = (C+(FLOAT(J)-0.5)*DR)**2
  102 CONTINUE
C
C     MULTIPLY RIGHT SIDE BY R(J)**2
C
      DO 104 J=1,N
         X = RSQ(J)
         DO 103 I=1,M
            F(I,J) = X*F(I,J)
  103    CONTINUE
  104 CONTINUE
C
C      DEFINE COEFFICIENTS AM,BM,CM
C
      X = 1./(2.*COS(DTH/2.))
      DO 105 I=2,M
         AM(I) = (SNTH(I-1)+SNTH(I))*X
         CM(I-1) = AM(I)
  105 CONTINUE
      AM(1) = SIN(A)
      CM(M) = SIN(B)
      DO 106 I=1,M
         X = 1./SNTH(I)
         Y = X/DTHSQ
         AM(I) = AM(I)*Y
         CM(I) = CM(I)*Y
         BM(I) = ELMBDA*X*X-AM(I)-CM(I)
  106 CONTINUE
C
C     DEFINE COEFFICIENTS AN,BN,CN
C
      X = C/DR
      DO 107 J=1,N
         AN(J) = (X+FLOAT(J-1))**2
         CN(J) = (X+FLOAT(J))**2
         BN(J) = -(AN(J)+CN(J))
  107 CONTINUE
      ISW = 1
      NB = NBDCND
      IF (C.EQ.0. .AND. NB.EQ.2) NB = 6
C
C     ENTER DATA ON THETA BOUNDARIES
C
      GO TO (108,108,110,110,112,112,108,110,112),MBDCND
  108 BM(1) = BM(1)-AM(1)
      X = 2.*AM(1)
      DO 109 J=1,N
         F(1,J) = F(1,J)-X*BDA(J)
  109 CONTINUE
      GO TO 112
  110 BM(1) = BM(1)+AM(1)
      X = DTH*AM(1)
      DO 111 J=1,N
         F(1,J) = F(1,J)+X*BDA(J)
  111 CONTINUE
  112 CONTINUE
      GO TO (113,115,115,113,113,115,117,117,117),MBDCND
  113 BM(M) = BM(M)-CM(M)
      X = 2.*CM(M)
      DO 114 J=1,N
         F(M,J) = F(M,J)-X*BDB(J)
  114 CONTINUE
      GO TO 117
  115 BM(M) = BM(M)+CM(M)
      X = DTH*CM(M)
      DO 116 J=1,N
         F(M,J) = F(M,J)-X*BDB(J)
  116 CONTINUE
  117 CONTINUE
C
C     ENTER DATA ON R BOUNDARIES
C
      GO TO (118,118,120,120,122,122),NB
  118 BN(1) = BN(1)-AN(1)
      X = 2.*AN(1)
      DO 119 I=1,M
         F(I,1) = F(I,1)-X*BDC(I)
  119 CONTINUE
      GO TO 122
  120 BN(1) = BN(1)+AN(1)
      X = DR*AN(1)
      DO 121 I=1,M
         F(I,1) = F(I,1)+X*BDC(I)
  121 CONTINUE
  122 CONTINUE
      GO TO (123,125,125,123,123,125),NB
  123 BN(N) = BN(N)-CN(N)
      X = 2.*CN(N)
      DO 124 I=1,M
         F(I,N) = F(I,N)-X*BDD(I)
  124 CONTINUE
      GO TO 127
  125 BN(N) = BN(N)+CN(N)
      X = DR*CN(N)
      DO 126 I=1,M
         F(I,N) = F(I,N)-X*BDD(I)
  126 CONTINUE
  127 CONTINUE
C
C     CHECK FOR SINGULAR PROBLEM.  IF SINGULAR, PERTURB F.
C
      PERTRB = 0.
      GO TO (137,137,128,137,137,128,137,128,128),MBDCND
  128 GO TO (137,137,129,137,137,129),NB
  129 IF (ELMBDA) 137,131,130
  130 IERR1 = 10
      GO TO 137
  131 CONTINUE
      ISW = 2
      DO 133 I=1,M
         X = 0.
         DO 132 J=1,N
            X = X+F(I,J)
  132    CONTINUE
         PERTRB = PERTRB+X*SNTH(I)
  133 CONTINUE
      X = 0.
      DO 134 J=1,N
         X = X+RSQ(J)
  134 CONTINUE
      PERTRB = 2.*(PERTRB*SIN(DTH/2.))/(X*(COS(A)-COS(B)))
      DO 136 J=1,N
         X = RSQ(J)*PERTRB
         DO 135 I=1,M
            F(I,J) = F(I,J)-X
  135    CONTINUE
  136 CONTINUE
  137 CONTINUE
      A2 = 0.
      DO 138 I=1,M
         A2 = A2+F(I,1)
  138 CONTINUE
      A2 = A2/RSQ(1)
C
C     INITIALIZE BLKTRI
C
      IF (INTL .NE. 0) GO TO 139
      CALL BLKTRI (0,1,N,AN,BN,CN,1,M,AM,BM,CM,IDIMF,F,IERR1,WRK)
  139 CONTINUE
C
C     CALL BLKTRI TO SOLVE SYSTEM OF EQUATIONS.
C
      CALL BLKTRI (1,1,N,AN,BN,CN,1,M,AM,BM,CM,IDIMF,F,IERR1,WRK)
      IF (ISW.NE.2 .OR. C.NE.0. .OR. NBDCND.NE.2) GO TO 143
      A1 = 0.
      A3 = 0.
      DO 140 I=1,M
         A1 = A1+SNTH(I)*F(I,1)
         A3 = A3+SNTH(I)
  140 CONTINUE
      A1 = A1+RSQ(1)*A2/2.
      IF (MBDCND .EQ. 3)
     1    A1 = A1+(SIN(B)*BDB(1)-SIN(A)*BDA(1))/(2.*(B-A))
      A1 = A1/A3
      A1 = BDC(1)-A1
      DO 142 I=1,M
         DO 141 J=1,N
            F(I,J) = F(I,J)+A1
  141    CONTINUE
  142 CONTINUE
  143 CONTINUE
      RETURN
      END
