c
c		fishpak21  from portlib                   07/25/81
c
c	Modified to double precision. Nov. 7, 1990,
c	by Brent Lindquist, Dept. Appl. Math. & Stat., SUNY Stony Brook
c
c	and retaining only routines needed for cost() and sint()
c				
c
c
c
      subroutine dcosti (n,wsave)
      implicit double precision (a-h,o-z)
      double precision wsave(1)
      data pi /3.14159265358979/
      if (n .le. 3) return
      nm1 = n-1
      np1 = n+1
      ns2 = n/2
      dnm1 = nm1
      dt = pi/dnm1
      fk = 0.0d0
      do 101 k=2,ns2
         kc = np1-k
         fk = fk+1.0d0
         wsave(k)  = 2.0d0*dsin(fk*dt)
         wsave(kc) = 2.0d0*dcos(fk*dt)
  101 continue
      call drffti (nm1,wsave(n+1))
      return
      end
c
c
c
      subroutine dcost (n,x,wsave)
      implicit double precision (a-h,o-z)
      double precision x(1), wsave(1)
      nm1 = n-1
      np1 = n+1
      ns2 = n/2
      if (n-2) 106,101,102
  101 x1h = x(1)+x(2)
      x(2) = x(1)-x(2)
      x(1) = x1h
      return
  102 if (n .gt. 3) go to 103
      x1p3 = x(1)+x(3)
      tx2 = x(2)+x(2)
      x(2) = x(1)-x(3)
      x(1) = x1p3+tx2
      x(3) = x1p3-tx2
      return
  103 c1 = x(1)-x(n)
      x(1) = x(1)+x(n)
      do 104 k=2,ns2
         kc = np1-k
         t1 = x(k)+x(kc)
         t2 = x(k)-x(kc)
         c1 = c1+wsave(kc)*t2
         t2 = wsave(k)*t2
         x(k ) = t1-t2
         x(kc) = t1+t2
  104 continue
      modn = mod(n,2)
      if (modn .ne. 0) x(ns2+1) = x(ns2+1)+x(ns2+1)
      call drfftf (nm1,x,wsave(n+1))
      xim2 = x(2)
      x(2) = c1
      do 105 i=4,n,2
         xi = x(i)
         x(i) = x(i-2)-x(i-1)
         x(i-1) = xim2
         xim2 = xi
  105 continue
      if (modn .ne. 0) x(n) = xim2
  106 return
      end
c
c
c
      subroutine dsinti (n,wsave)
      implicit double precision (a-h,o-z)
      double precision wsave(1)
      data pi /3.14159265358979/
      if (n .le. 1) return
      np1 = n+1
      ns2 = n/2
      dnp1 = np1
      dt = pi/dnp1
      fk = 0.0d0
      do 101 k=1,ns2
         fk = fk+1.0d0
         wsave(k) = 2.0d0*dsin(fk*dt)
  101 continue
      call drffti (np1,wsave(ns2+1))
      return
      end
c
c
c
      subroutine dsint (n,x,wsave)
      implicit double precision (a-h,o-z)
      double precision x(1), wsave(1)
      data sqrt3 /1.73205080756888/
      if (n-2) 101,102,103
  101 x(1) = x(1)+x(1)
      return
  102 xh = sqrt3*(x(1)+x(2))
      x(2) = sqrt3*(x(1)-x(2))
      x(1) = xh
      return
  103 np1 = n+1
      ns2 = n/2
      x1 = x(1)
      x(1) = 0.0d0
      do 104 k=1,ns2
         kc = np1-k
         t1 = x1-x(kc)
         t2 = wsave(k)*(x1+x(kc))
         x1 = x(k+1)
         x(k+1 ) = t1+t2
         x(kc+1) = t2-t1
  104 continue
      modn = mod(n,2)
      if (modn .ne. 0) x(ns2+2) = 4.0d0*x1
      call drfftf (np1,x,wsave(ns2+1))
      x(1) = 0.5d0*x(1)
      do 105 i=3,n,2
         xim1 = x(i-1)
         x(i-1) = -x(i)
         x(i) = x(i-2)+xim1
  105 continue
      if (modn .ne. 0) return
      x(n) = -x(n+1)
      return
      end
c
c
c
      subroutine drffti (n,wsave)
      implicit double precision (a-h,o-z)
      double precision wsave(1)
      if (n .eq. 1) return
      call drffti1 (n,wsave(n+1),wsave(2*n+1))
      return
      end
c
c
c
      subroutine drffti1 (n,wa,ifac)
      implicit double precision (a-h,o-z)
      double precision wa(1)
      dimension ifac(1), ntryh(4)
      data ntryh(1),ntryh(2),ntryh(3),ntryh(4)/4,2,3,5/
      nl = n
      nf = 0
      j = 0
  101 j = j+1
      if (j-4) 102,102,103
  102 ntry = ntryh(j)
      go to 104
  103 ntry = ntry+2
  104 nq = nl/ntry
      nr = nl-ntry*nq
      if (nr) 101,105,101
  105 nf = nf+1
      ifac(nf+2) = ntry
      nl = nq
      if (ntry .ne. 2) go to 107
      if (nf   .eq. 1) go to 107
      do 106 i=2,nf
         ib = nf-i+2
         ifac(ib+2) = ifac(ib+1)
  106 continue
      ifac(3) = 2
  107 if (nl .ne. 1) go to 104
      ifac(1) = n
      ifac(2) = nf
      tpi = 6.28318530717959
      dn = n
      argh = tpi/dn
      is = 0
      nfm1 = nf-1
      l1 = 1
      if (nfm1 .eq. 0) return
      do 110 k1=1,nfm1
         ip = ifac(k1+2)
         ld = 0
         l2 = l1*ip
         ido = n/l2
         ipm = ip-1
         do 109 j=1,ipm
            ld = ld+l1
            i = is
	    dld = ld
            argld = dld*argh
            fi = 0.0d0
            do 108 ii=3,ido,2
               i = i+2
               fi = fi+1.0d0
               arg = fi*argld
               wa(i-1) = dcos(arg)
               wa(i)   = dsin(arg)
  108       continue
            is = is+ido
  109    continue
         l1 = l2
  110 continue
      return
      end
c
c
c
      subroutine drfftf (n,r,wsave)
      implicit double precision (a-h,o-z)
      double precision r(1), wsave(1)
      if (n .eq. 1) return
      call drfftf1 (n,r,wsave,wsave(n+1),wsave(2*n+1))
      return
      end
c
c
c
      subroutine drfftf1 (n,c,ch,wa,ifac)
      implicit double precision (a-h,o-z)
      double precision ch(1), c(1), wa(1)
      dimension ifac(1)
      nf = ifac(2)
      na = 1
      l2 = n
      iw = n
      do 111 k1=1,nf
         kh = nf-k1
         ip = ifac(kh+3)
         l1 = l2/ip
         ido = n/l2
         idl1 = ido*l1
         iw = iw-(ip-1)*ido
         na = 1-na
         if (ip .ne. 4) go to 102
         ix2 = iw+ido
         ix3 = ix2+ido
         if (na .ne. 0) go to 101
         call dradf4 (ido,l1,c,ch,wa(iw),wa(ix2),wa(ix3))
         go to 110
  101    call dradf4 (ido,l1,ch,c,wa(iw),wa(ix2),wa(ix3))
         go to 110
  102    if (ip .ne. 2) go to 104
         if (na .ne. 0) go to 103
         call dradf2 (ido,l1,c,ch,wa(iw))
         go to 110
  103    call dradf2 (ido,l1,ch,c,wa(iw))
         go to 110
  104    if (ip .ne. 3) go to 106
         ix2 = iw+ido
         if (na .ne. 0) go to 105
         call dradf3 (ido,l1,c,ch,wa(iw),wa(ix2))
         go to 110
  105    call dradf3 (ido,l1,ch,c,wa(iw),wa(ix2))
         go to 110
  106    if (ip .ne. 5) go to 108
         ix2 = iw+ido
         ix3 = ix2+ido
         ix4 = ix3+ido
         if (na .ne. 0) go to 107
         call dradf5 (ido,l1,c,ch,wa(iw),wa(ix2),wa(ix3),wa(ix4))
         go to 110
  107    call dradf5 (ido,l1,ch,c,wa(iw),wa(ix2),wa(ix3),wa(ix4))
         go to 110
  108    if (ido .eq. 1) na = 1-na
         if (na .ne. 0) go to 109
         call dradfg (ido,ip,l1,idl1,c,c,c,ch,ch,wa(iw))
         na = 1
         go to 110
  109    call dradfg (ido,ip,l1,idl1,ch,ch,ch,c,c,wa(iw))
         na = 0
  110    l2 = l1
  111 continue
      if (na .eq. 1) return
      do 112 i=1,n
         c(i) = ch(i)
  112 continue
      return
      end
c
c
c
      subroutine dradf2 (ido,l1,cc,ch,wa1)
      implicit double precision (a-h,o-z)
      double precision ch(ido,2,l1), cc(ido,l1,2), wa1(1)
      do 101 k=1,l1
         ch(1  ,1,k) = cc(1,k,1)+cc(1,k,2)
         ch(ido,2,k) = cc(1,k,1)-cc(1,k,2)
  101 continue
      if (ido-2) 107,105,102
  102 idp2 = ido+2
      do 104 k=1,l1
         do 103 i=3,ido,2
            ic = idp2-i
            tr2 = wa1(i-2)*cc(i-1,k,2)+wa1(i-1)*cc(i  ,k,2)
            ti2 = wa1(i-2)*cc(i  ,k,2)-wa1(i-1)*cc(i-1,k,2)
            ch(i   ,1,k) = cc(i  ,k,1)+ti2
            ch(ic  ,2,k) = ti2-cc(i,k,1)
            ch(i-1 ,1,k) = cc(i-1,k,1)+tr2
            ch(ic-1,2,k) = cc(i-1,k,1)-tr2
  103    continue
  104 continue
      if (mod(ido,2) .eq. 1) return
  105 do 106 k=1,l1
         ch(1,2,k)   = -cc(ido,k,2)
         ch(ido,1,k) =  cc(ido,k,1)
  106 continue
  107 return
      end
c
c
c
      subroutine dradf3 (ido,l1,cc,ch,wa1,wa2)
      implicit double precision (a-h,o-z)
      double precision  ch(ido,3,l1) ,cc(ido,l1,3),
     1                  wa1(1), wa2(1)
      data taur,taui /-0.5d0,0.866025403784439/
      do 101 k=1,l1
         cr2 = cc(1,k,2)+cc(1,k,3)
         ch(1  ,1,k) = cc(1,k,1)+cr2
         ch(1  ,3,k) = taui*(cc(1,k,3)-cc(1,k,2))
         ch(ido,2,k) = cc(1,k,1)+taur*cr2
  101 continue
      if (ido .eq. 1) return
      idp2 = ido+2
      do 103 k=1,l1
         do 102 i=3,ido,2
            ic = idp2-i
            dr2 = wa1(i-2)*cc(i-1,k,2)+wa1(i-1)*cc(i  ,k,2)
            di2 = wa1(i-2)*cc(i  ,k,2)-wa1(i-1)*cc(i-1,k,2)
            dr3 = wa2(i-2)*cc(i-1,k,3)+wa2(i-1)*cc(i  ,k,3)
            di3 = wa2(i-2)*cc(i  ,k,3)-wa2(i-1)*cc(i-1,k,3)
            cr2 = dr2+dr3
            ci2 = di2+di3
            ch(i-1,1,k) = cc(i-1,k,1)+cr2
            ch(i  ,1,k) = cc(i  ,k,1)+ci2
            tr2 = cc(i-1,k,1)+taur*cr2
            ti2 = cc(i  ,k,1)+taur*ci2
            tr3 = taui*(di2-di3)
            ti3 = taui*(dr3-dr2)
            ch(i-1 ,3,k) = tr2+tr3
            ch(ic-1,2,k) = tr2-tr3
            ch(i   ,3,k) = ti2+ti3
            ch(ic  ,2,k) = ti3-ti2
  102    continue
  103 continue
      return
      end
c
c
c
      subroutine dradf4 (ido,l1,cc,ch,wa1,wa2,wa3)
      implicit double precision (a-h,o-z)
      double precision cc(ido,l1,4), ch(ido,4,l1),
     1                 wa1(1), wa2(1), wa3(1)
      data hsqt2 /0.7071067811865475/
      do 101 k=1,l1
         tr1 = cc(1,k,2)+cc(1,k,4)
         tr2 = cc(1,k,1)+cc(1,k,3)
         ch(1,1,k) = tr1+tr2
         ch(ido,4,k) = tr2-tr1
         ch(ido,2,k) = cc(1,k,1)-cc(1,k,3)
         ch(1  ,3,k) = cc(1,k,4)-cc(1,k,2)
  101 continue
      if (ido-2) 107,105,102
  102 idp2 = ido+2
      do 104 k=1,l1
         do 103 i=3,ido,2
            ic = idp2-i
            cr2 = wa1(i-2)*cc(i-1,k,2)+wa1(i-1)*cc(i  ,k,2)
            ci2 = wa1(i-2)*cc(i  ,k,2)-wa1(i-1)*cc(i-1,k,2)
            cr3 = wa2(i-2)*cc(i-1,k,3)+wa2(i-1)*cc(i  ,k,3)
            ci3 = wa2(i-2)*cc(i  ,k,3)-wa2(i-1)*cc(i-1,k,3)
            cr4 = wa3(i-2)*cc(i-1,k,4)+wa3(i-1)*cc(i  ,k,4)
            ci4 = wa3(i-2)*cc(i  ,k,4)-wa3(i-1)*cc(i-1,k,4)
            tr1 = cr2+cr4
            tr4 = cr4-cr2
            ti1 = ci2+ci4
            ti4 = ci2-ci4
            ti2 = cc(i  ,k,1)+ci3
            ti3 = cc(i  ,k,1)-ci3
            tr2 = cc(i-1,k,1)+cr3
            tr3 = cc(i-1,k,1)-cr3
            ch(i-1 ,1,k) = tr1+tr2
            ch(ic-1,4,k) = tr2-tr1
            ch(i   ,1,k) = ti1+ti2
            ch(ic  ,4,k) = ti1-ti2
            ch(i-1 ,3,k) = ti4+tr3
            ch(ic-1,2,k) = tr3-ti4
            ch(i   ,3,k) = tr4+ti3
            ch(ic  ,2,k) = tr4-ti3
  103    continue
  104 continue
      if (mod(ido,2) .eq. 1) return
  105 continue
      do 106 k=1,l1
         ti1 = -hsqt2*(cc(ido,k,2)+cc(ido,k,4))
         tr1 =  hsqt2*(cc(ido,k,2)-cc(ido,k,4))
         ch(ido,1,k) = tr1+cc(ido,k,1)
         ch(ido,3,k) = cc(ido,k,1)-tr1
         ch(1  ,2,k) = ti1-cc(ido,k,3)
         ch(1  ,4,k) = ti1+cc(ido,k,3)
  106 continue
  107 return
      end
c
c
c
      subroutine dradf5 (ido,l1,cc,ch,wa1,wa2,wa3,wa4)
      implicit double precision (a-h,o-z)
      double precision cc(ido,l1,5), ch(ido,5,l1),
     1                wa1(1), wa2(1), wa3(1), wa4(1)
      data tr11,ti11,tr12,ti12 /.309016994374947,.951056516295154,
     1                         -.809016994374947,.587785252292473/
      do 101 k=1,l1
         cr2 = cc(1,k,5)+cc(1,k,2)
         ci5 = cc(1,k,5)-cc(1,k,2)
         cr3 = cc(1,k,4)+cc(1,k,3)
         ci4 = cc(1,k,4)-cc(1,k,3)
         ch(1  ,1,k) = cc(1,k,1)+cr2+cr3
         ch(ido,2,k) = cc(1,k,1)+tr11*cr2+tr12*cr3
         ch(1  ,3,k) = ti11*ci5+ti12*ci4
         ch(ido,4,k) = cc(1,k,1)+tr12*cr2+tr11*cr3
         ch(1  ,5,k) = ti12*ci5-ti11*ci4
  101 continue
      if (ido .eq. 1) return
      idp2 = ido+2
      do 103 k=1,l1
         do 102 i=3,ido,2
            ic = idp2-i
            dr2 = wa1(i-2)*cc(i-1,k,2)+wa1(i-1)*cc(i  ,k,2)
            di2 = wa1(i-2)*cc(i  ,k,2)-wa1(i-1)*cc(i-1,k,2)
            dr3 = wa2(i-2)*cc(i-1,k,3)+wa2(i-1)*cc(i  ,k,3)
            di3 = wa2(i-2)*cc(i  ,k,3)-wa2(i-1)*cc(i-1,k,3)
            dr4 = wa3(i-2)*cc(i-1,k,4)+wa3(i-1)*cc(i  ,k,4)
            di4 = wa3(i-2)*cc(i  ,k,4)-wa3(i-1)*cc(i-1,k,4)
            dr5 = wa4(i-2)*cc(i-1,k,5)+wa4(i-1)*cc(i  ,k,5)
            di5 = wa4(i-2)*cc(i  ,k,5)-wa4(i-1)*cc(i-1,k,5)
            cr2 = dr2+dr5
            ci5 = dr5-dr2
            cr5 = di2-di5
            ci2 = di2+di5
            cr3 = dr3+dr4
            ci4 = dr4-dr3
            cr4 = di3-di4
            ci3 = di3+di4
            ch(i-1,1,k) = cc(i-1,k,1)+cr2+cr3
            ch(i,1,k) = cc(i,k,1)+ci2+ci3
            tr2 = cc(i-1,k,1)+tr11*cr2+tr12*cr3
            ti2 = cc(i  ,k,1)+tr11*ci2+tr12*ci3
            tr3 = cc(i-1,k,1)+tr12*cr2+tr11*cr3
            ti3 = cc(i  ,k,1)+tr12*ci2+tr11*ci3
            tr5 = ti11*cr5+ti12*cr4
            ti5 = ti11*ci5+ti12*ci4
            tr4 = ti12*cr5-ti11*cr4
            ti4 = ti12*ci5-ti11*ci4
            ch(i-1 ,3,k) = tr2+tr5
            ch(ic-1,2,k) = tr2-tr5
            ch(i   ,3,k) = ti2+ti5
            ch(ic  ,2,k) = ti5-ti2
            ch(i-1 ,5,k) = tr3+tr4
            ch(ic-1,4,k) = tr3-tr4
            ch(i   ,5,k) = ti3+ti4
            ch(ic  ,4,k) = ti4-ti3
  102    continue
  103 continue
      return
      end
c
c
c
      subroutine dradfg (ido,ip,l1,idl1,cc,c1,c2,ch,ch2,wa)
      implicit double precision (a-h,o-z)
      double precision ch(ido,l1,ip), cc(ido,ip,l1),
     1                 c1(ido,l1,ip), c2(idl1,ip),
     2                 ch2(idl1,ip),  wa(1)
      data tpi/6.28318530717959/
      dip = ip
      arg = tpi/dip
      dcp = dcos(arg)
      dsp = dsin(arg)
      ipph = (ip+1)/2
      ipp2 = ip+2
      idp2 = ido+2
      nbd = (ido-1)/2
      if (ido .eq. 1) go to 119
      do 101 ik=1,idl1
         ch2(ik,1) = c2(ik,1)
  101 continue
      do 103 j=2,ip
         do 102 k=1,l1
            ch(1,k,j) = c1(1,k,j)
  102    continue
  103 continue
      if (nbd .gt. l1) go to 107
      is = -ido
      do 106 j=2,ip
         is = is+ido
         idij = is
         do 105 i=3,ido,2
            idij = idij+2
            do 104 k=1,l1
               ch(i-1,k,j) = wa(idij-1)*c1(i-1,k,j)+wa(idij)*c1(i,k,j)
               ch(i  ,k,j) = wa(idij-1)*c1(i,k,j)-wa(idij)*c1(i-1,k,j)
  104       continue
  105    continue
  106 continue
      go to 111
  107 is = -ido
      do 110 j=2,ip
         is = is+ido
         do 109 k=1,l1
            idij = is
            do 108 i=3,ido,2
               idij = idij+2
               ch(i-1,k,j) = wa(idij-1)*c1(i-1,k,j)+wa(idij)*c1(i,k,j)
               ch(i  ,k,j) = wa(idij-1)*c1(i,k,j)-wa(idij)*c1(i-1,k,j)
  108       continue
  109    continue
  110 continue
  111 if (nbd .lt. l1) go to 115
      do 114 j=2,ipph
         jc = ipp2-j
         do 113 k=1,l1
            do 112 i=3,ido,2
               c1(i-1,k,j ) = ch(i-1,k,j )+ch(i-1,k,jc)
               c1(i-1,k,jc) = ch(i  ,k,j )-ch(i  ,k,jc)
               c1(i  ,k,j ) = ch(i  ,k,j )+ch(i  ,k,jc)
               c1(i  ,k,jc) = ch(i-1,k,jc)-ch(i-1,k,j )
  112       continue
  113    continue
  114 continue
      go to 121
  115 do 118 j=2,ipph
         jc = ipp2-j
         do 117 i=3,ido,2
            do 116 k=1,l1
               c1(i-1,k,j ) = ch(i-1,k,j )+ch(i-1,k,jc)
               c1(i-1,k,jc) = ch(i  ,k,j )-ch(i  ,k,jc)
               c1(i  ,k,j ) = ch(i  ,k,j )+ch(i  ,k,jc)
               c1(i  ,k,jc) = ch(i-1,k,jc)-ch(i-1,k,j )
  116       continue
  117    continue
  118 continue
      go to 121
  119 do 120 ik=1,idl1
         c2(ik,1) = ch2(ik,1)
  120 continue
  121 do 123 j=2,ipph
         jc = ipp2-j
         do 122 k=1,l1
            c1(1,k,j ) = ch(1,k,j )+ch(1,k,jc)
            c1(1,k,jc) = ch(1,k,jc)-ch(1,k,j )
  122    continue
  123 continue
c
      ar1 = 1.0d0
      ai1 = 0.0d0
      do 127 l=2,ipph
         lc = ipp2-l
         ar1h = dcp*ar1-dsp*ai1
         ai1  = dcp*ai1+dsp*ar1
         ar1  = ar1h
         do 124 ik=1,idl1
            ch2(ik,l ) = c2(ik,1)+ar1*c2(ik,2)
            ch2(ik,lc) = ai1*c2(ik,ip)
  124    continue
         dc2 = ar1
         ds2 = ai1
         ar2 = ar1
         ai2 = ai1
         do 126 j=3,ipph
            jc = ipp2-j
            ar2h = dc2*ar2-ds2*ai2
            ai2  = dc2*ai2+ds2*ar2
            ar2  = ar2h
            do 125 ik=1,idl1
               ch2(ik,l ) = ch2(ik,l )+ar2*c2(ik,j )
               ch2(ik,lc) = ch2(ik,lc)+ai2*c2(ik,jc)
  125       continue
  126    continue
  127 continue
      do 129 j=2,ipph
         do 128 ik=1,idl1
            ch2(ik,1) = ch2(ik,1)+c2(ik,j)
  128    continue
  129 continue
c
      if (ido .lt. l1) go to 132
      do 131 k=1,l1
         do 130 i=1,ido
            cc(i,1,k) = ch(i,k,1)
  130    continue
  131 continue
      go to 135
  132 do 134 i=1,ido
         do 133 k=1,l1
            cc(i,1,k) = ch(i,k,1)
  133    continue
  134 continue
  135 do 137 j=2,ipph
         jc = ipp2-j
         j2 = j+j
         do 136 k=1,l1
            cc(ido,j2-2,k) = ch(1,k,j )
            cc(1  ,j2-1,k) = ch(1,k,jc)
  136    continue
  137 continue
      if (ido .eq. 1) return
      if (nbd .lt. l1) go to 141
      do 140 j=2,ipph
         jc = ipp2-j
         j2 = j+j
         do 139 k=1,l1
            do 138 i=3,ido,2
               ic = idp2-i
               cc(i-1 ,j2-1,k) = ch(i-1,k,j )+ch(i-1,k,jc)
               cc(ic-1,j2-2,k) = ch(i-1,k,j )-ch(i-1,k,jc)
               cc(i   ,j2-1,k) = ch(i  ,k,j )+ch(i  ,k,jc)
               cc(ic  ,j2-2,k) = ch(i  ,k,jc)-ch(i  ,k,j )
  138       continue
  139    continue
  140 continue
      return
  141 do 144 j=2,ipph
         jc = ipp2-j
         j2 = j+j
         do 143 i=3,ido,2
            ic = idp2-i
            do 142 k=1,l1
               cc(i-1 ,j2-1,k) = ch(i-1,k,j )+ch(i-1,k,jc)
               cc(ic-1,j2-2,k) = ch(i-1,k,j )-ch(i-1,k,jc)
               cc(i   ,j2-1,k) = ch(i  ,k,j )+ch(i  ,k,jc)
               cc(ic  ,j2-2,k) = ch(i  ,k,jc)-ch(i  ,k,j )
  142       continue
  143    continue
  144 continue
      return
      end
