C
C     ------------------------------------------------------------------
C
      SUBROUTINE FIGI2(NM,N,T,D,E,Z,IERR)
C
      INTEGER I,J,N,NM,IERR
      REAL T(NM,3),D(N),E(N),Z(NM,N)
      REAL H
C     REAL SQRT
C
C     GIVEN A NONSYMMETRIC TRIDIAGONAL MATRIX SUCH THAT THE PRODUCTS
C     OF CORRESPONDING PAIRS OF OFF-DIAGONAL ELEMENTS ARE ALL
C     NON-NEGATIVE, AND ZERO ONLY WHEN BOTH FACTORS ARE ZERO, THIS
C     SUBROUTINE REDUCES IT TO A SYMMETRIC TRIDIAGONAL MATRIX
C     USING AND ACCUMULATING DIAGONAL SIMILARITY TRANSFORMATIONS.
C
C     ON INPUT-
C
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C          DIMENSION STATEMENT,
C
C        N IS THE ORDER OF THE MATRIX,
C
C        T CONTAINS THE INPUT MATRIX.  ITS SUBDIAGONAL IS
C          STORED IN THE LAST N-1 POSITIONS OF THE FIRST COLUMN,
C          ITS DIAGONAL IN THE N POSITIONS OF THE SECOND COLUMN,
C          AND ITS SUPERDIAGONAL IN THE FIRST N-1 POSITIONS OF
C          THE THIRD COLUMN.  T(1,1) AND T(N,3) ARE ARBITRARY.
C
C     ON OUTPUT-
C
C        T IS UNALTERED,
C
C        D CONTAINS THE DIAGONAL ELEMENTS OF THE SYMMETRIC MATRIX,
C
C        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE SYMMETRIC
C          MATRIX IN ITS LAST N-1 POSITIONS.  E(1) IS NOT SET,
C
C        Z CONTAINS THE TRANSFORMATION MATRIX PRODUCED IN
C          THE REDUCTION,
C
C        IERR IS SET TO
C          ZERO       FOR NORMAL RETURN,
C          N+I        IF T(I,1)*T(I-1,3) IS NEGATIVE,
C          2*N+I      IF T(I,1)*T(I-1,3) IS ZERO WITH
C                     ONE FACTOR NON-ZERO.
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO B. S. GARBOW,
C     APPLIED MATHEMATICS DIVISION, ARGONNE NATIONAL LABORATORY
C
C     ------------------------------------------------------------------
C
      IERR = 0
C
      DO 100 I = 1, N
C
         DO 50 J = 1, N
   50    Z(I,J) = 0.0
C
      IF (I .EQ. 1) GO TO 70
         H = T(I,1) * T(I-1,3)
      IF (H) 900, 60, 80
   60 IF (T(I,1) .NE. 0.0 .OR. T(I-1,3) .NE. 0.0) GO TO 1000
         E(I) = 0.0
   70    Z(I,I) = 1.0
         GO TO 90
   80    E(I) = SQRT(H)
         Z(I,I) = Z(I-1,I-1) * E(I) / T(I-1,3)
   90    D(I) = T(I,2)
  100 CONTINUE
C
      GO TO 1001
C     ********** SET ERROR -- PRODUCT OF SOME PAIR OF OFF-DIAGONAL
C                ELEMENTS IS NEGATIVE **********
  900 IERR = N + I
      GO TO 1001
C     ********** SET ERROR -- PRODUCT OF SOME PAIR OF OFF-DIAGONAL
C                ELEMENTS IS ZERO WITH ONE MEMBER NON-ZERO **********
 1000 IERR = 2 * N + I
 1001 RETURN
C     ********** LAST CARD OF FIGI2 **********
      END
