C
C     ------------------------------------------------------------------
C
      SUBROUTINE FIGI(NM,N,T,D,E,E2,IERR)
C
      INTEGER I,N,NM,IERR
      REAL T(NM,3),D(N),E(N),E2(N)
C     REAL SQRT
C
C     GIVEN A NONSYMMETRIC TRIDIAGONAL MATRIX SUCH THAT THE PRODUCTS
C     OF CORRESPONDING PAIRS OF OFF-DIAGONAL ELEMENTS ARE ALL
C     NON-NEGATIVE, THIS SUBROUTINE REDUCES IT TO A SYMMETRIC
C     TRIDIAGONAL MATRIX WITH THE SAME EIGENVALUES.  IF, FURTHER,
C     A ZERO PRODUCT ONLY OCCURS WHEN BOTH FACTORS ARE ZERO,
C     THE REDUCED MATRIX IS SIMILAR TO THE ORIGINAL MATRIX.
C
C     ON INPUT-
C
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C          DIMENSION STATEMENT,
C
C        N IS THE ORDER OF THE MATRIX,
C
C        T CONTAINS THE INPUT MATRIX.  ITS SUBDIAGONAL IS
C          STORED IN THE LAST N-1 POSITIONS OF THE FIRST COLUMN,
C          ITS DIAGONAL IN THE N POSITIONS OF THE SECOND COLUMN,
C          AND ITS SUPERDIAGONAL IN THE FIRST N-1 POSITIONS OF
C          THE THIRD COLUMN.  T(1,1) AND T(N,3) ARE ARBITRARY.
C
C     ON OUTPUT-
C
C        T IS UNALTERED,
C
C        D CONTAINS THE DIAGONAL ELEMENTS OF THE SYMMETRIC MATRIX,
C
C        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE SYMMETRIC
C          MATRIX IN ITS LAST N-1 POSITIONS.  E(1) IS NOT SET,
C
C        E2 CONTAINS THE SQUARES OF THE CORRESPONDING ELEMENTS OF E.
C          E2 MAY COINCIDE WITH E IF THE SQUARES ARE NOT NEEDED,
C
C        IERR IS SET TO
C          ZERO       FOR NORMAL RETURN,
C          N+I        IF T(I,1)*T(I-1,3) IS NEGATIVE,
C          -(3*N+I)   IF T(I,1)*T(I-1,3) IS ZERO WITH ONE FACTOR
C                     NON-ZERO.  IN THIS CASE, THE EIGENVECTORS OF
C                     THE SYMMETRIC MATRIX ARE NOT SIMPLY RELATED
C                     TO THOSE OF  T  AND SHOULD NOT BE SOUGHT.
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO B. S. GARBOW,
C     APPLIED MATHEMATICS DIVISION, ARGONNE NATIONAL LABORATORY
C
C     ------------------------------------------------------------------
C
      IERR = 0
C
      DO 100 I = 1, N
      IF (I .EQ. 1) GO TO 90
         E2(I) = T(I,1) * T(I-1,3)
      IF (E2(I)) 1000, 60, 80
   60 IF (T(I,1) .EQ. 0.0 .AND. T(I-1,3) .EQ. 0.0) GO TO 80
C     ********** SET ERROR -- PRODUCT OF SOME PAIR OF OFF-DIAGONAL
C                ELEMENTS IS ZERO WITH ONE MEMBER NON-ZERO **********
         IERR = -(3 * N + I)
   80    E(I) = SQRT(E2(I))
   90    D(I) = T(I,2)
  100 CONTINUE
C
      GO TO 1001
C     ********** SET ERROR -- PRODUCT OF SOME PAIR OF OFF-DIAGONAL
C                ELEMENTS IS NEGATIVE **********
 1000 IERR = N + I
 1001 RETURN
C     ********** LAST CARD OF FIGI **********
      END
