C
C     ------------------------------------------------------------------
C
      SUBROUTINE BQR(NM,N,MB,A,T,R,IERR,NV,RV)
C
      INTEGER I,J,K,L,M,N,II,IK,JK,JM,KJ,KK,KM,LL,MB,MK,MN,MZ,
     X        M1,M2,M3,M4,NI,NM,NV,ITS,KJ1,M21,M31,IERR,IMULT
      REAL A(NM,MB),RV(NV)
      REAL F,G,Q,R,S,T,SCALE
C     REAL SQRT,ABS,SIGN
C     INTEGER MAX0,MIN0
C
C     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE BQR,
C     NUM. MATH. 16, 85-92(1970) BY MARTIN, REINSCH, AND WILKINSON.
C     HANDBOOK FOR AUTO. COMP., VOL II-LINEAR ALGEBRA, 266-272(1971).
C
C     THIS SUBROUTINE FINDS THE EIGENVALUE OF SMALLEST (USUALLY)
C     MAGNITUDE OF A REAL SYMMETRIC BAND MATRIX USING THE
C     QR ALGORITHM WITH SHIFTS OF ORIGIN.  CONSECUTIVE CALLS
C     CAN BE MADE TO FIND FURTHER EIGENVALUES.
C
C     ON INPUT-
C
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C          DIMENSION STATEMENT,
C
C        N IS THE ORDER OF THE MATRIX,
C
C        MB IS THE (HALF) BAND WIDTH OF THE MATRIX, DEFINED AS THE
C          NUMBER OF ADJACENT DIAGONALS, INCLUDING THE PRINCIPAL
C          DIAGONAL, REQUIRED TO SPECIFY THE NON-ZERO PORTION OF THE
C          LOWER TRIANGLE OF THE MATRIX,
C
C        A CONTAINS THE LOWER TRIANGLE OF THE SYMMETRIC BAND INPUT
C          MATRIX STORED AS AN N BY MB ARRAY.  ITS LOWEST SUBDIAGONAL
C          IS STORED IN THE LAST N+1-MB POSITIONS OF THE FIRST COLUMN,
C          ITS NEXT SUBDIAGONAL IN THE LAST N+2-MB POSITIONS OF THE
C          SECOND COLUMN, FURTHER SUBDIAGONALS SIMILARLY, AND FINALLY
C          ITS PRINCIPAL DIAGONAL IN THE N POSITIONS OF THE LAST COLUMN.
C          CONTENTS OF STORAGES NOT PART OF THE MATRIX ARE ARBITRARY.
C          ON A SUBSEQUENT CALL, ITS OUTPUT CONTENTS FROM THE PREVIOUS
C          CALL SHOULD BE PASSED,
C
C        T SPECIFIES THE SHIFT (OF EIGENVALUES) APPLIED TO THE DIAGONAL
C          OF A IN FORMING THE INPUT MATRIX, WHAT IS ACTUALLY DETERMINED
C          IS THE EIGENVALUE OF A+TI (I IS THE IDENTITY MATRIX) NEAREST
C          TO T.  ON A SUBSEQUENT CALL, THE OUTPUT VALUE OF T FROM THE
C          PREVIOUS CALL SHOULD BE PASSED IF THE NEXT NEAREST EIGENVALUE
C          IS SOUGHT,
C
C        R SHOULD BE SPECIFIED AS ZERO ON THE FIRST CALL, AND AS ITS
C          OUTPUT VALUE FROM THE PREVIOUS CALL ON A SUBSEQUENT CALL.
C          IT IS USED TO DETERMINE WHEN THE LAST ROW AND COLUMN OF
C          THE TRANSFORMED BAND MATRIX CAN BE REGARDED AS NEGLIGIBLE,
C
C        NV MUST BE SET TO THE DIMENSION OF THE ARRAY PARAMETER RV
C          AS DECLARED IN THE CALLING PROGRAM DIMENSION STATEMENT.
C
C     ON OUTPUT-
C
C        A CONTAINS THE TRANSFORMED BAND MATRIX.  THE MATRIX A+TI
C          DERIVED FROM THE OUTPUT PARAMETERS IS SIMILAR TO THE
C          INPUT A+TI TO WITHIN ROUNDING ERRORS.  ITS LAST ROW AND
C          COLUMN ARE NULL (IF IERR IS ZERO),
C
C        T CONTAINS THE COMPUTED EIGENVALUE OF A+TI (IF IERR IS ZERO),
C
C        R CONTAINS THE MAXIMUM OF ITS INPUT VALUE AND THE NORM OF THE
C          LAST COLUMN OF THE INPUT MATRIX A,
C
C        IERR IS SET TO
C          ZERO       FOR NORMAL RETURN,
C          N          IF THE EIGENVALUE HAS NOT BEEN
C                     DETERMINED AFTER 30 ITERATIONS,
C
C        RV IS A TEMPORARY STORAGE ARRAY OF DIMENSION AT LEAST
C          (2*MB**2+4*MB-3).  THE FIRST (3*MB-2) LOCATIONS CORRESPOND
C          TO THE ALGOL ARRAY B, THE NEXT (2*MB-1) LOCATIONS CORRESPOND
C          TO THE ALGOL ARRAY H, AND THE FINAL (2*MB**2-MB) LOCATIONS
C          CORRESPOND TO THE MB BY (2*MB-1) ALGOL ARRAY U.
C
C     NOTE- FOR A SUBSEQUENT CALL, N SHOULD BE REPLACED BY N-1, BUT
C     MB SHOULD NOT BE ALTERED EVEN WHEN IT EXCEEDS THE CURRENT N.
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO B. S. GARBOW,
C     APPLIED MATHEMATICS DIVISION, ARGONNE NATIONAL LABORATORY
C
C     ------------------------------------------------------------------
C
      IERR = 0
      M1 = MIN0(MB,N)
      M = M1 - 1
      M2 = M + M
      M21 = M2 + 1
      M3 = M21 + M
      M31 = M3 + 1
      M4 = M31 + M2
      MN = M + N
      MZ = MB - M1
      ITS = 0
C     ********** TEST FOR CONVERGENCE **********
   40 G = A(N,MB)
      IF (M .EQ. 0) GO TO 360
      F = 0.0
C
      DO 50 K = 1, M
         MK = K + MZ
         F = F + ABS(A(N,MK))
   50 CONTINUE
C
      IF (ITS .EQ. 0 .AND. F .GT. R) R = F
      IF (R + F .LE. R) GO TO 360
      IF (ITS .EQ. 30) GO TO 1000
      ITS = ITS + 1
C     ********** FORM SHIFT FROM BOTTOM 2 BY 2 MINOR **********
      IF (F .GT. 0.25 * R .AND. ITS .LT. 5) GO TO 90
      F = A(N,MB-1)
      IF (F .EQ. 0.0) GO TO 70
      Q = (A(N-1,MB) - G) / (2.0 * F)
      S = SQRT(Q*Q+1.0)
      G = G - F / (Q + SIGN(S,Q))
   70 T = T + G
C
      DO 80 I = 1, N
   80 A(I,MB) = A(I,MB) - G
C
   90 DO 100 K = M31, M4
  100 RV(K) = 0.0
C
      DO 350 II = 1, MN
         I = II - M
         NI = N - II
      IF (NI .LT. 0) GO TO 230
C     ********** FORM COLUMN OF SHIFTED MATRIX A-G*I **********
         L = MAX0(1,2-I)
C
         DO 110 K = 1, M3
  110    RV(K) = 0.0
C
         DO 120 K = L, M1
            KM = K + M
            MK = K + MZ
            RV(KM) = A(II,MK)
  120    CONTINUE
C
         LL = MIN0(M,NI)
      IF (LL .EQ. 0) GO TO 135
C
         DO 130 K = 1, LL
            KM = K + M21
            IK = II + K
            MK = MB - K
            RV(KM) = A(IK,MK)
  130    CONTINUE
C     ********** PRE-MULTIPLY WITH HOUSEHOLDER REFLECTIONS **********
  135    LL = M2
         IMULT = 0
C     ********** MULTIPLICATION PROCEDURE **********
  140    KJ = M4 - M1
C
         DO 170 J = 1, LL
            KJ = KJ + M1
            JM = J + M3
      IF (RV(JM) .EQ. 0.0) GO TO 170
            F = 0.0
C
            DO 150 K = 1, M1
               KJ = KJ + 1
               JK = J + K - 1
               F = F + RV(KJ) * RV(JK)
  150       CONTINUE
C
            F = F / RV(JM)
            KJ = KJ - M1
C
            DO 160 K = 1, M1
               KJ = KJ + 1
               JK = J + K - 1
               RV(JK) = RV(JK) - RV(KJ) * F
  160       CONTINUE
C
            KJ = KJ - M1
  170    CONTINUE
C
      IF (IMULT .NE. 0) GO TO 280
C     ********** HOUSEHOLDER REFLECTION **********
         F = RV(M21)
         S = 0.0
         RV(M4) = 0.0
         SCALE = 0.0
C
         DO 180 K = M21, M3
  180    SCALE = SCALE + ABS(RV(K))
C
      IF (SCALE .EQ. 0.0) GO TO 210
C
         DO 190 K = M21, M3
  190    S = S + (RV(K)/SCALE)**2
C
         S = SCALE * SCALE * S
         G = -SIGN(SQRT(S),F)
         RV(M21) = G
         RV(M4) = S - F * G
         KJ = M4 + M2 * M1 + 1
         RV(KJ) = F - G
C
         DO 200 K = 2, M1
            KJ = KJ + 1
            KM = K + M2
            RV(KJ) = RV(KM)
  200    CONTINUE
C     ********** SAVE COLUMN OF TRIANGULAR FACTOR R **********
  210    DO 220 K = L, M1
            KM = K + M
            MK = K + MZ
            A(II,MK) = RV(KM)
  220    CONTINUE
C
  230    L = MAX0(1,M1+1-I)
      IF (I .LE. 0) GO TO 300
C     ********** PERFORM ADDITIONAL STEPS **********
         DO 240 K = 1, M21
  240    RV(K) = 0.0
C
         LL = MIN0(M1,NI+M1)
C     ********** GET ROW OF TRIANGULAR FACTOR R **********
         DO 250 KK = 1, LL
            K = KK - 1
            KM = K + M1
            IK = I + K
            MK = MB - K
            RV(KM) = A(IK,MK)
  250    CONTINUE
C     ********** POST-MULTIPLY WITH HOUSEHOLDER REFLECTIONS **********
         LL = M1
         IMULT = 1
         GO TO 140
C     ********** STORE COLUMN OF NEW A MATRIX **********
  280    DO 290 K = L, M1
            MK = K + MZ
            A(I,MK) = RV(K)
  290    CONTINUE
C     ********** UPDATE HOUSEHOLDER REFLECTIONS **********
  300 IF (L .GT. 1) L = L - 1
         KJ1 = M4 + L * M1
C
         DO 320 J = L, M2
            JM = J + M3
            RV(JM) = RV(JM+1)
C
            DO 320 K = 1, M1
               KJ1 = KJ1 + 1
               KJ = KJ1 - M1
               RV(KJ) = RV(KJ1)
  320    CONTINUE
C
  350 CONTINUE
C
      GO TO 40
C     ********** CONVERGENCE **********
  360 T = T + G
C
      DO 380 I = 1, N
  380 A(I,MB) = A(I,MB) - G
C
      DO 400 K = 1, M1
         MK = K + MZ
         A(N,MK) = 0.0
  400 CONTINUE
C
      GO TO 1001
C     ********** SET ERROR -- NO CONVERGENCE TO
C                EIGENVALUE AFTER 30 ITERATIONS **********
 1000 IERR = N
 1001 RETURN
C     ********** LAST CARD OF BQR **********
      END
