C
C     ------------------------------------------------------------------
C
      SUBROUTINE BANDV(NM,N,MBW,A,E21,M,W,Z,IERR,NV,RV,RV6)
C
      INTEGER I,J,K,M,N,R,II,IJ,JJ,KJ,MB,M1,NM,NV,IJ1,ITS,KJ1,MBW,M21,
     X        IERR,MAXJ,MAXK,GROUP
      REAL A(NM,MBW),W(M),Z(NM,M),RV(NV),RV6(N)
      REAL U,V,UK,XU,X0,X1,E21,EPS2,EPS3,EPS4,NORM,ORDER,MACHEP
C     REAL SQRT,ABS,FLOAT,SIGN
C     INTEGER MIN0
C
C     THIS SUBROUTINE FINDS THOSE EIGENVECTORS OF A REAL SYMMETRIC
C     BAND MATRIX CORRESPONDING TO SPECIFIED EIGENVALUES, USING INVERSE
C     ITERATION.  THE SUBROUTINE MAY ALSO BE USED TO SOLVE SYSTEMS
C     OF LINEAR EQUATIONS WITH A SYMMETRIC OR NON-SYMMETRIC BAND
C     COEFFICIENT MATRIX.
C
C     ON INPUT-
C
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C          DIMENSION STATEMENT,
C
C        N IS THE ORDER OF THE MATRIX,
C
C        MBW IS THE NUMBER OF COLUMNS OF THE ARRAY A USED TO STORE THE
C          BAND MATRIX.  IF THE MATRIX IS SYMMETRIC, MBW IS ITS (HALF)
C          BAND WIDTH, DENOTED MB AND DEFINED AS THE NUMBER OF ADJACENT
C          DIAGONALS, INCLUDING THE PRINCIPAL DIAGONAL, REQUIRED TO
C          SPECIFY THE NON-ZERO PORTION OF THE LOWER TRIANGLE OF THE
C          MATRIX.  IF THE SUBROUTINE IS BEING USED TO SOLVE SYSTEMS
C          OF LINEAR EQUATIONS AND THE COEFFICIENT MATRIX IS NOT
C          SYMMETRIC, IT MUST HOWEVER HAVE THE SAME NUMBER OF ADJACENT
C          DIAGONALS ABOVE THE MAIN DIAGONAL AS BELOW, AND IN THIS
C          CASE, MBW=2*MB-1,
C
C        A CONTAINS THE LOWER TRIANGLE OF THE SYMMETRIC BAND INPUT
C          MATRIX STORED AS AN N BY MB ARRAY.  ITS LOWEST SUBDIAGONAL
C          IS STORED IN THE LAST N+1-MB POSITIONS OF THE FIRST COLUMN,
C          ITS NEXT SUBDIAGONAL IN THE LAST N+2-MB POSITIONS OF THE
C          SECOND COLUMN, FURTHER SUBDIAGONALS SIMILARLY, AND FINALLY
C          ITS PRINCIPAL DIAGONAL IN THE N POSITIONS OF COLUMN MB.
C          IF THE SUBROUTINE IS BEING USED TO SOLVE SYSTEMS OF LINEAR
C          EQUATIONS AND THE COEFFICIENT MATRIX IS NOT SYMMETRIC, A IS
C          N BY 2*MB-1 INSTEAD WITH LOWER TRIANGLE AS ABOVE AND WITH
C          ITS FIRST SUPERDIAGONAL STORED IN THE FIRST N-1 POSITIONS OF
C          COLUMN MB+1, ITS SECOND SUPERDIAGONAL IN THE FIRST N-2
C          POSITIONS OF COLUMN MB+2, FURTHER SUPERDIAGONALS SIMILARLY,
C          AND FINALLY ITS HIGHEST SUPERDIAGONAL IN THE FIRST N+1-MB
C          POSITIONS OF THE LAST COLUMN.
C          CONTENTS OF STORAGES NOT PART OF THE MATRIX ARE ARBITRARY,
C
C        E21 SPECIFIES THE ORDERING OF THE EIGENVALUES AND CONTAINS
C            0.0 IF THE EIGENVALUES ARE IN ASCENDING ORDER, OR
C            2.0 IF THE EIGENVALUES ARE IN DESCENDING ORDER.
C          IF THE SUBROUTINE IS BEING USED TO SOLVE SYSTEMS OF LINEAR
C          EQUATIONS, E21 SHOULD BE SET TO 1.0 IF THE COEFFICIENT
C          MATRIX IS SYMMETRIC AND TO -1.0 IF NOT,
C
C        M IS THE NUMBER OF SPECIFIED EIGENVALUES OR THE NUMBER OF
C          SYSTEMS OF LINEAR EQUATIONS,
C
C        W CONTAINS THE M EIGENVALUES IN ASCENDING OR DESCENDING ORDER.
C          IF THE SUBROUTINE IS BEING USED TO SOLVE SYSTEMS OF LINEAR
C          EQUATIONS (A-W(R)*I)*X(R)=B(R), WHERE I IS THE IDENTITY
C          MATRIX, W(R) SHOULD BE SET ACCORDINGLY, FOR R=1,2,...,M,
C
C        Z CONTAINS THE CONSTANT MATRIX COLUMNS (B(R),R=1,2,...,M), IF
C          THE SUBROUTINE IS USED TO SOLVE SYSTEMS OF LINEAR EQUATIONS,
C
C        NV MUST BE SET TO THE DIMENSION OF THE ARRAY PARAMETER RV
C          AS DECLARED IN THE CALLING PROGRAM DIMENSION STATEMENT.
C
C     ON OUTPUT-
C
C        A AND W ARE UNALTERED,
C
C        Z CONTAINS THE ASSOCIATED SET OF ORTHOGONAL EIGENVECTORS.
C          ANY VECTOR WHICH FAILS TO CONVERGE IS SET TO ZERO.  IF THE
C          SUBROUTINE IS USED TO SOLVE SYSTEMS OF LINEAR EQUATIONS,
C          Z CONTAINS THE SOLUTION MATRIX COLUMNS (X(R),R=1,2,...,M),
C
C        IERR IS SET TO
C          ZERO       FOR NORMAL RETURN,
C          -R         IF THE EIGENVECTOR CORRESPONDING TO THE R-TH
C                     EIGENVALUE FAILS TO CONVERGE, OR IF THE R-TH
C                     SYSTEM OF LINEAR EQUATIONS IS NEARLY SINGULAR.
C
C        RV AND RV6 ARE TEMPORARY STORAGE ARRAYS.  NOTE THAT RV IS
C          OF DIMENSION AT LEAST N*(2*MB-1).  IF THE SUBROUTINE
C          IS BEING USED TO SOLVE SYSTEMS OF LINEAR EQUATIONS, THE
C          DETERMINANT (UP TO SIGN) OF A-W(M)*I IS AVAILABLE, UPON
C          RETURN, AS THE PRODUCT OF THE FIRST N ELEMENTS OF RV.
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO B. S. GARBOW,
C     APPLIED MATHEMATICS DIVISION, ARGONNE NATIONAL LABORATORY
C
C     ------------------------------------------------------------------
C
C     ********** MACHEP IS A MACHINE DEPENDENT PARAMETER SPECIFYING
C                THE RELATIVE PRECISION OF FLOATING POINT ARITHMETIC.
C
C                **********
      MACHEP = 2.**(-47)
C
      IERR = 0
      IF (M .EQ. 0) GO TO 1001
      MB = MBW
      IF (E21 .LT. 0.0) MB = (MBW + 1) / 2
      M1 = MB - 1
      M21 = M1 + MB
      ORDER = 1.0 - ABS(E21)
C     ********** FIND VECTORS BY INVERSE ITERATION **********
      DO 920 R = 1, M
         ITS = 1
         X1 = W(R)
      IF (R .NE. 1) GO TO 100
C     ********** COMPUTE NORM OF MATRIX **********
         NORM = 0.0
C
         DO 60 J = 1, MB
            JJ = MB + 1 - J
            KJ = JJ + M1
            IJ = 1
C
            DO 40 I = JJ, N
               NORM = NORM + ABS(A(I,J))
      IF (E21 .GE. 0.0) GO TO 40
               NORM = NORM + ABS(A(IJ,KJ))
               IJ = IJ + 1
   40       CONTINUE
C
   60    CONTINUE
C
      IF (E21 .LT. 0.0) NORM = 0.5 * NORM
C     ********** EPS2 IS THE CRITERION FOR GROUPING,
C                EPS3 REPLACES ZERO PIVOTS AND EQUAL
C                ROOTS ARE MODIFIED BY EPS3,
C                EPS4 IS TAKEN VERY SMALL TO AVOID OVERFLOW **********
      IF (NORM .EQ. 0.0) NORM = 1.0
         EPS2 = 1.0E-3 * NORM * ABS(ORDER)
         EPS3 = MACHEP * NORM
         UK = SQRT(FLOAT(N))
         EPS4 = UK * EPS3
   80    GROUP = 0
         GO TO 120
C     ********** LOOK FOR CLOSE OR COINCIDENT ROOTS **********
  100 IF (ABS(X1-X0) .GE. EPS2) GO TO 80
         GROUP = GROUP + 1
      IF (ORDER * (X1 - X0) .LE. 0.0) X1 = X0 + ORDER * EPS3
C     ********** EXPAND MATRIX, SUBTRACT EIGENVALUE,
C                AND INITIALIZE VECTOR **********
  120    DO 200 I = 1, N
            IJ = I + MIN0(0,I-M1) * N
            KJ = IJ + MB * N
            IJ1 = KJ + M1 * N
      IF (M1 .EQ. 0) GO TO 180
C
            DO 150 J = 1, M1
      IF (IJ .GT. M1) GO TO 125
      IF (IJ .GT. 0) GO TO 130
               RV(IJ1) = 0.0
               IJ1 = IJ1 + N
               GO TO 130
  125          RV(IJ) = A(I,J)
  130          IJ = IJ + N
               II = I + J
      IF (II .GT. N) GO TO 150
               JJ = MB - J
      IF (E21 .GE. 0.0) GO TO 140
               II = I
               JJ = MB + J
  140          RV(KJ) = A(II,JJ)
               KJ = KJ + N
  150       CONTINUE
C
  180       RV(IJ) = A(I,MB) - X1
            RV6(I) = EPS4
      IF (ORDER .EQ. 0.0) RV6(I) = Z(I,R)
  200    CONTINUE
C
      IF (M1 .EQ. 0) GO TO 600
C     ********** ELIMINATION WITH INTERCHANGES **********
         DO 580 I = 1, N
            II = I + 1
            MAXK = MIN0(I+M1-1,N)
            MAXJ = MIN0(N-I,M21-2) * N
C
            DO 360 K = I, MAXK
               KJ1 = K
               J = KJ1 + N
               JJ = J + MAXJ
C
               DO 340 KJ = J, JJ, N
                  RV(KJ1) = RV(KJ)
                  KJ1 = KJ
  340          CONTINUE
C
               RV(KJ1) = 0.0
  360       CONTINUE
C
      IF (I .EQ. N) GO TO 580
            U = 0.0
            MAXK = MIN0(I+M1,N)
            MAXJ = MIN0(N-II,M21-2) * N
C
            DO 450 J = I, MAXK
      IF (ABS(RV(J)) .LT. ABS(U)) GO TO 450
               U = RV(J)
               K = J
  450       CONTINUE
C
            J = I + N
            JJ = J + MAXJ
      IF (K .EQ. I) GO TO 520
            KJ = K
C
            DO 500 IJ = I, JJ, N
               V = RV(IJ)
               RV(IJ) = RV(KJ)
               RV(KJ) = V
               KJ = KJ + N
  500       CONTINUE
C
      IF (ORDER .NE. 0.0) GO TO 520
            V = RV6(I)
            RV6(I) = RV6(K)
            RV6(K) = V
  520 IF (U .EQ. 0.0) GO TO 580
C
            DO 560 K = II, MAXK
               V = RV(K) / U
               KJ = K
C
               DO 540 IJ = J, JJ, N
                  KJ = KJ + N
                  RV(KJ) = RV(KJ) - V * RV(IJ)
  540          CONTINUE
C
      IF (ORDER .EQ. 0.0) RV6(K) = RV6(K) - V * RV6(I)
  560       CONTINUE
C
  580    CONTINUE
C     ********** BACK SUBSTITUTION
C                FOR I=N STEP -1 UNTIL 1 DO -- **********
  600    DO 630 II = 1, N
            I = N + 1 - II
            MAXJ = MIN0(II,M21)
      IF (MAXJ .EQ. 1) GO TO 620
            IJ1 = I
            J = IJ1 + N
            JJ = J + (MAXJ - 2) * N
C
            DO 610 IJ = J, JJ, N
               IJ1 = IJ1 + 1
               RV6(I) = RV6(I) - RV(IJ) * RV6(IJ1)
  610       CONTINUE
C
  620       V = RV(I)
      IF (ABS(V) .GE. EPS3) GO TO 625
C     ********** SET ERROR -- NEARLY SINGULAR LINEAR SYSTEM **********
      IF (ORDER .EQ. 0.0) IERR = -R
            V = SIGN(EPS3,V)
  625       RV6(I) = RV6(I) / V
  630    CONTINUE
C
         XU = 1.0
      IF (ORDER .EQ. 0.0) GO TO 870
C     ********** ORTHOGONALIZE WITH RESPECT TO PREVIOUS
C                MEMBERS OF GROUP **********
      IF (GROUP .EQ. 0) GO TO 700
C
         DO 680 JJ = 1, GROUP
            J = R - GROUP - 1 + JJ
            XU = 0.0
C
            DO 640 I = 1, N
  640       XU = XU + RV6(I) * Z(I,J)
C
            DO 660 I = 1, N
  660       RV6(I) = RV6(I) - XU * Z(I,J)
C
  680    CONTINUE
C
  700    NORM = 0.0
C
         DO 720 I = 1, N
  720    NORM = NORM + ABS(RV6(I))
C
      IF (NORM .GE. 1.0E-1) GO TO 840
C     ********** IN-LINE PROCEDURE FOR CHOOSING
C                A NEW STARTING VECTOR **********
      IF (ITS .GE. N) GO TO 830
         ITS = ITS + 1
         XU = EPS4 / (UK + 1.0)
         RV6(1) = EPS4
C
         DO 760 I = 2, N
  760    RV6(I) = XU
C
         RV6(ITS) = RV6(ITS) - EPS4 * UK
         GO TO 600
C     ********** SET ERROR -- NON-CONVERGED EIGENVECTOR **********
  830    IERR = -R
         XU = 0.0
         GO TO 870
C     ********** NORMALIZE SO THAT SUM OF SQUARES IS
C                1 AND EXPAND TO FULL ORDER **********
  840    U = 0.0
C
         DO 860 I = 1, N
  860    U = U + RV6(I)**2
C
         XU = 1.0 / SQRT(U)
C
  870    DO 900 I = 1, N
  900    Z(I,R) = RV6(I) * XU
C
         X0 = X1
  920 CONTINUE
C
 1001 RETURN
C     ********** LAST CARD OF BANDV **********
      END
