C
C     ------------------------------------------------------------------
C
      SUBROUTINE BAKVEC(NM,N,T,E,M,Z,IERR)
C
      INTEGER I,J,M,N,NM,IERR
      REAL T(NM,3),E(N),Z(NM,M)
C
C     THIS SUBROUTINE FORMS THE EIGENVECTORS OF A NONSYMMETRIC
C     TRIDIAGONAL MATRIX BY BACK TRANSFORMING THOSE OF THE
C     CORRESPONDING SYMMETRIC MATRIX DETERMINED BY  FIGI.
C
C     ON INPUT-
C
C        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
C          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
C          DIMENSION STATEMENT,
C
C        N IS THE ORDER OF THE MATRIX,
C
C        T CONTAINS THE NONSYMMETRIC MATRIX.  ITS SUBDIAGONAL IS
C          STORED IN THE LAST N-1 POSITIONS OF THE FIRST COLUMN,
C          ITS DIAGONAL IN THE N POSITIONS OF THE SECOND COLUMN,
C          AND ITS SUPERDIAGONAL IN THE FIRST N-1 POSITIONS OF
C          THE THIRD COLUMN.  T(1,1) AND T(N,3) ARE ARBITRARY,
C
C        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE SYMMETRIC
C          MATRIX IN ITS LAST N-1 POSITIONS.  E(1) IS ARBITRARY,
C
C        M IS THE NUMBER OF EIGENVECTORS TO BE BACK TRANSFORMED,
C
C        Z CONTAINS THE EIGENVECTORS TO BE BACK TRANSFORMED
C          IN ITS FIRST M COLUMNS.
C
C     ON OUTPUT-
C
C        T IS UNALTERED,
C
C        E IS DESTROYED,
C
C        Z CONTAINS THE TRANSFORMED EIGENVECTORS
C          IN ITS FIRST M COLUMNS,
C
C        IERR IS SET TO
C          ZERO       FOR NORMAL RETURN,
C          2*N+I      IF E(I) IS ZERO WITH T(I,1) OR T(I-1,3) NON-ZERO.
C                     IN THIS CASE, THE SYMMETRIC MATRIX IS NOT SIMILAR
C                     TO THE ORIGINAL MATRIX, AND THE EIGENVECTORS
C                     CANNOT BE FOUND BY THIS PROGRAM.
C
C     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO B. S. GARBOW,
C     APPLIED MATHEMATICS DIVISION, ARGONNE NATIONAL LABORATORY
C
C     ------------------------------------------------------------------
C
      IERR = 0
      IF (M .EQ. 0) GO TO 1001
      E(1) = 1.0
      IF (N .EQ. 1) GO TO 1001
C
      DO 100 I = 2, N
      IF (E(I) .NE. 0.0) GO TO 80
      IF (T(I,1) .NE. 0.0 .OR. T(I-1,3) .NE. 0.0) GO TO 1000
         E(I) = 1.0
         GO TO 100
   80    E(I) = E(I-1) * E(I) / T(I-1,3)
  100 CONTINUE
C
      DO 120 J = 1, M
C
         DO 120 I = 2, N
         Z(I,J) = Z(I,J) * E(I)
  120 CONTINUE
C
      GO TO 1001
C     ********** SET ERROR -- EIGENVECTORS CANNOT BE
C                FOUND BY THIS PROGRAM **********
 1000 IERR = 2 * N + I
 1001 RETURN
C     ********** LAST CARD OF BAKVEC **********
      END
