/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#if !defined(WAIT_BLOCK_H)
#define WAIT_BLOCK_H 1

#if !defined(MAX_WAIT_BLOCK)
#define MAX_WAIT_BLOCK ((8*1024)-1)
#endif /* !defined(MAX_WAIT_BLOCK) */


#define DECLARE_ALL_WAIT_NODE()  \
	int Iaf; \
	void *buf; \
        logical use_compress;  \
            /* if no compression is used, the entire index list is stored */  \
            int nsize; int* list;  \
  \
           /* if compression is used, need to store compressed list */  \
           int nsets;  \
           int *start_list; int *size_list;  int *gindex; \
  \
        /* info about pages */  \
  \
        int npages;  \
        int *pageno_array;  \
        void **pageptr_array; /* array of (void *) */  \
        int *gid_array; int *userbuf_array;




struct wait_node {
	DECLARE_ALL_WAIT_NODE()
};


#define ASSIGN_ALL_WAIT_NODE( wait_id ) { \
	struct wait_node *XX; \
	XX = ( Gwait_node_array[ wait_id ]); \
   \
        Iaf = XX->Iaf;  \
        buf = XX->buf;  \
        use_compress = XX->use_compress;  \
  \
        nsets = XX->nsets;  \
        start_list = XX->start_list;  \
        size_list = XX->size_list;  \
	gindex = XX->gindex;	\
  \
        list = XX->list;  \
        nsize = XX->nsize;  \
  \
        npages = XX->npages;  \
        pageno_array = XX->pageno_array;  \
        pageptr_array = XX->pageptr_array;  \
        gid_array = XX->gid_array;  \
        userbuf_array = XX->userbuf_array;  \
	}

#define DEALLOCATE_ALL_WAIT_NODE( wait_id) { \
	struct wait_node *XX; XX = Gwait_node_array[ wait_id ]; \
	( XX)->Iaf = 0; \
	\
	/* buf is user allocated buffer, cannot deallocate */ \
	( XX)->buf = NULL; \
	if (( XX)->use_compress) { \
		if (XX->start_list != NULL) { MEMFREE( ( XX)->start_list );};\
		if (XX->size_list != NULL) { MEMFREE( ( XX)->size_list );};\
		if (XX->gindex != NULL) { MEMFREE( ( XX)->gindex ); }; \
		( XX)->nsets = 0; \
		assert( ((XX)->list) == NULL ); \
		} \
	else { \
		if (XX->list != NULL) { MEMFREE( ( XX)->list ); }; \
		( XX)->nsize = 0; \
		\
		assert(((Gwait_node_array[wait_id])->start_list)==NULL);\
		assert(((Gwait_node_array[wait_id])->size_list)==NULL);\
		assert(((Gwait_node_array[wait_id])->gindex)==NULL);\
		}; \
 \
	if (XX->pageno_array != NULL) { MEMFREE( ( XX)->pageno_array ); };\
	if (XX->pageptr_array != NULL) { MEMFREE( ( XX)->pageptr_array ); }; \
	if (XX->gid_array != NULL) { MEMFREE( ( XX)->gid_array ); }; \
	if (XX->userbuf_array != NULL) { MEMFREE( ( XX)->userbuf_array ); }; \
	( XX)->npages = 0; \
 \
	MEMFREE(  XX ); \
	Gwait_node_array[ wait_id ] = NULL; \
        }




/* note 0-th entry is not used */
struct wait_node *Gwait_node_array[MAX_WAIT_BLOCK + 1];

extern int      allocwait(void);



#endif
