/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include "stdinc.h"

void
vec_daxpby(int nsize, dfloat alpha, dfloat beta,
	   dfloat * xvec, dfloat * yvec)
{
	int             i;

	if (beta == 1) {
	   if (alpha == 1) {
		for (i = 0; i < nsize; i++) {
			yvec[i] += xvec[i];
		    };
		}
	   else {
		for (i = 0; i < nsize; i++) {
			yvec[i] += alpha * xvec[i];
		    };
		};
	} else {
		for (i = 0; i < nsize; i++) {
			yvec[i] = alpha * xvec[i] + beta * yvec[i];
		};
	};

}
