/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/



#if !defined(STDINC_H)

#define STDINC_H




#include <stdio.h>
#include <assert.h>
#include <malloc.h>
#include <math.h>



#include "ipx.h"


#define dfloat double
#define logical int
#define ALL -1


#if !defined(FALSE)
#define FALSE 0
#endif

#if !defined(TRUE)
#define TRUE (!FALSE)
#endif

#if !defined(NULL)
#define NULL 0
#endif


#define MEMALLOC( pointer, type, nbytes ) \
		{ i_disable(); \
		  assert( (nbytes) > 0); \
			pointer = type malloc( (nbytes) ); \
			assert( pointer != NULL ); \
		 i_enable(); \
		}

#define MEMFREE( pointer ) \
	{ assert( pointer != NULL ); \
		i_disable();  \
		free( pointer ); \
		i_enable(); \
		pointer = NULL; \
		}



#define CCOPY( csrc, cdest, isize ) {   \
        if (isize <= 64) {  \
                int i;  \
                for( i=0; i < isize; i++ )  { cdest[i] = csrc[i]; };  \
                }  \
        else {  \
                int nbytes; nbytes = isize*sizeof(char);  \
                BCOPY( (char *) csrc, (char *) cdest, nbytes );  \
             };  \
        }


#define ICOPY( isrc, idest, isize ) {   \
	if (isize <= 64) {  \
		int i;  \
		for( i=0; i < isize; i++ )  { idest[i] = isrc[i]; };  \
		}  \
	else {  \
		int nbytes; nbytes = isize*sizeof(int);  \
		BCOPY( (char *) isrc, (char *) idest, nbytes );  \
	     };  \
	}

#define RCOPY( rsrc, rdest, isize ) {   \
        if (isize <= 64) {  \
                int i;  \
                for( i=0; i < isize; i++ )  { rdest[i] = rsrc[i]; };  \
                }  \
        else {  \
                int nbytes; nbytes = isize*sizeof(float);  \
                BCOPY( (char *) rsrc, (char *) rdest, nbytes );  \
             };  \
        }

#define DCOPY( dsrc, ddest, isize ) {   \
        if (isize <= 64) {  \
                int i;  \
                for( i=0; i < isize; i++ )  { ddest[i] = dsrc[i]; };  \
                }  \
        else {  \
                int nbytes; nbytes = isize*sizeof(dfloat);  \
                BCOPY( (char *) dsrc, (char *) ddest, nbytes );  \
             };  \
        }

#define ASSERT(cond,message,x) { \
	if (! (cond)) { \
		printf(message,x); \
		assert(cond); \
	} \
}


/* #define malloc(n) i_malloc(n)  */

/* #define realloc(p,n) i_realloc(p,n)  */
/* #define free(p) i_free(p)  */


#if I860 || RX
/* bcopy is either not available or is very slow (in libX11.a) */
/* reverse arguments for faster memcpy */
#define BCOPY(src, dest, nbytes)  memcpy( dest, src, nbytes );

#else
#define BCOPY(src,dest,nbytes) \
	{ bcopy((char *)src, (char *) dest, (int) nbytes); }
extern void     bcopy(char *src, char *dest, int nbytes);

#endif


#if !defined(max)
#define max(ix,iy) ( (ix) > (iy) ? (ix) : (iy) )
#endif

#if !defined(min)
#define min(ix,iy) ( (ix) < (iy) ? (ix) : (iy) )
#endif


#include "message.h"

#if defined(USE_POLLING)
#define masktrap(ix) (ix)
#endif

#if !defined(MOD)
#define MOD(ix,iy) ((ix) % (iy))
#endif

#define NO_SHIFT -1

#if !defined(DIV_OR_SHIFT)
#if defined(USE_SHIFTS)
#define DIV_OR_SHIFT( dividend, divisor, shift ) \
	((shift) >= 0) ?	((dividend) >> (shift)) : \
				((dividend) / (divisor))
#else
#define DIV_OR_SHIFT( dividend, divisor, shift ) ((dividend) / (divisor))
#endif
#endif

#if !defined(MUL_OR_SHIFT)
#if defined(USE_SHIFTS)
#define MUL_OR_SHIFT( multiplicand, multiplier, shift ) \
	((shift) >= 0) ?	((multiplicand) << (shift)) : \
				((multiplicand) * (multiplier))
#else
#define MUL_OR_SHIFT( multiplicand, multiplier, shift ) \
	((multiplicand) * (multiplier))
#endif
#endif

#if !defined(MOD_OR_SHIFT)
#if defined(USE_SHIFTS)
#define MOD_OR_SHIFT( value, modulus, shift ) \
	((shift) >= 0) ? \
	((value) - (((value) >> (shift)) << (shift))) : \
	((value) % (modulus))
#else
#define MOD_OR_SHIFT( value, modulus, shift ) ((value) % (modulus))
#endif
#endif

#endif				/* stdinc.h */
