/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include <stdio.h>
#include <assert.h>
#include "globals.h"

void
set_cache_flag(int Iaf, logical flag)
{
	int             is_valid;
	struct Iarray_node *anp;

	/* modified by Ed, Aug 22 for Iaf == 0 to mean disable all object */

	if (Iaf != 0) {

		is_valid = (1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY);
		ASSERT(is_valid, "set_cache_flag(): Iaf of %d out of range\n", Iaf);
		anp = Global_array[Iaf];
		is_valid = (anp != NULL);
		ASSERT(is_valid, "set_cache_flag(): Iaf of %d indexes null entry\n", Iaf);

		anp->cache_is_on = flag;
	} else {
		/* Iaf == 0, special meaning */

		logical         inuse;

		for (Iaf = 1; Iaf <= MAX_GLOBAL_ARRAY; Iaf++) {
			anp = Global_array[Iaf];
			inuse = (anp != NULL);
			if (inuse) {
				anp->cache_is_on = flag;
			};
		};
	};
}




void
do_disable(int Iaf)
{
	extern void     ch_disable(int Iaf);

	if ( 	(1 <= Iaf) && 
		(Iaf <= MAX_GLOBAL_ARRAY)  &&
		(Global_array[Iaf] != NULL) ) {
		
		if (Global_array[Iaf]->cache_is_on == FALSE) {
			/* flag is set already, nothing to do */ 
			return;
			};
		};


	set_cache_flag(Iaf, FALSE);
	ch_disable(Iaf);
}

void
do_enable(int Iaf)
{
	set_cache_flag(Iaf, TRUE);
}
