/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include "stdinc.h"
#include "globals.h"
#include "message.h"

#include <assert.h>




extern void
local_axpby(int Iaf, int ialpha, int ibeta, dfloat dalpha, dfloat dbeta,
	    int ncount, void *xlist, int *list,
	    logical is_regular_mode,
	    logical use_compress, int nsets,
	    logical returnz);




/*
 * declare dfloat's first for structure alignment for IPP  invokation
 */
void
remot_axpby(dfloat dalpha, dfloat dbeta,
	    int src_node, int Iaf, int ialpha, int ibeta,
	    int ncount, int x_msgtag,
	    logical use_compress, int nsets,
	    logical returnz)
{


#define MAXCOUNT 32*1024

	/*
	 * avoid the use of malloc(), not sure if it is safe in interrupt
	 * mode
	 */

	static dfloat   dbuf[MAXCOUNT * 2];
	char           *cbuf = (char *) (&(dbuf[0]));
	int            *list;
	void           *xlist;
	int             totalbytes, nidxbytes, x_nbytes;

	logical         spaceok, is_integer, is_dfloat, is_char, is_real,
	                is_valid;
	logical         is_regular_mode;

	struct Iarray_node *anp;

	DISABLE_INTERRUPT();

	is_valid = ((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY));
	ASSERT(is_valid, "remote_axpby(): Iaf of %d out of range\n", Iaf);

	anp = Global_array[Iaf];
	ASSERT(anp != NULL, "remote_axpby(): Iaf of %d indexes null element\n", Iaf);

	is_integer = (anp->type == INTEGER);
	is_dfloat = (anp->type == REAL8);
	is_char = (anp->type == CHAR);
	is_real = (anp->type == REAL);

	is_valid = (is_integer || is_dfloat || is_char || is_real);
	ASSERT(is_valid, "remote_axpby(): global array type not valid\n", 0);

	spaceok = ((1 <= ncount) && (ncount <= MAXCOUNT));
	ASSERT(spaceok, "remote_axpby(): ncount of %d out of range\n", ncount);

	if (use_compress) {
		nidxbytes = 2 * nsets * sizeof(int);
	} else {
		nidxbytes = sizeof(int) * ncount;
	}

	if (is_integer) {
		x_nbytes = sizeof(int) * ncount;

		xlist = (int *) (&(cbuf[0]));
		list = (int *) (&(cbuf[x_nbytes]));
	} else if (is_dfloat) {
		x_nbytes = sizeof(dfloat) * ncount;

		xlist = (dfloat *) (&(cbuf[0]));
		list = (int *) (&(cbuf[x_nbytes]));
	} else if (is_char) {
		x_nbytes = sizeof(char) * ncount;

		/* reverse storage to guarantee alignment */
		/* NOTE: sending routine must be aware of this */

		list = (int *) (&(cbuf[0]));
		xlist = (char *) (&(cbuf[nidxbytes]));
	} else if (is_real) {
		x_nbytes = sizeof(float) * ncount;

		xlist = (float *) (&(cbuf[0]));
		list = (int *) (&(cbuf[x_nbytes]));
	} else {
		ASSERT(FALSE, "remote_axpby(): global array type not valid\n", 0);
	}

	totalbytes = x_nbytes + nidxbytes;

	MSGRECV(x_msgtag, src_node, (&(cbuf[0])), totalbytes);

	local_axpby(Iaf, ialpha, ibeta, dalpha, dbeta,
		    ncount, (void *) xlist, list, is_regular_mode = FALSE,
		    use_compress, nsets,
		    returnz);


	if (returnz) {
	 	/* send the results back to originating node,
		   for simplicity, use the same message tag */

		SEND0( (void *) xlist, (long) x_nbytes, 
			(long) x_msgtag, (long) src_node);
		};


	RESTORE_INTERRUPT();
}
