#if !defined(MESSAGE_H)
#define MESSAGE_H 1



#if I860 || RX

#if !defined(FORCE_TYPE)
#include <cube.h>
#endif

#endif

#if PGON || PARAGON
#include <nx.h>
#endif



#if !defined(GSYNC)
/*
#define GSYNC()  { finish(0); gsync(); finish(0); gsync(); }
*/
#define GSYNC() { do_gsync(); };
#endif



#if INTEL || NX || I860 || PGON || PARAGON

#if !defined(GISUM)
#define GISUM( ix, nitem ) { \
    extern int nproc; \
    long *iwork;  \
    MEMALLOC( iwork, (long *), (sizeof(long)*max( nproc, nitem )));  \
    assert( iwork != NULL );  \
    gisum( (long *) (ix), (long) (nitem), (long *) (iwork) );  \
    MEMFREE( iwork );  \
    }
#endif

#if !defined(GIMAX)
#define GIMAX( ix ) { \
        long lx, lwork[2*1024];  \
        lx = (long) (ix);  \
        gihigh( (&lx), (long) 1, (&(lwork[0]))  );  \
        ix = lx;  \
        }
#endif



#else
/* non NX system, use PICL */

/* IPXPP generates call to csend */
#if !defined(csend)
#define csend( type, buf, count, node, ptype ) { \
    extern void send0( char *, int, int, int ); \
    send0( (char *) (buf), (int) (count), (int) (type), (int) (node) ); }
#endif

#if !defined(masktrap)
#define masktrap(mask) (mask)
#endif



#define IROOT 0
#define INTEGER_TYPE 3
#define INTEGER_BYTES 4

#define GSUM0_MSGTYPE 88888
#define GMAX0_MSGTYPE 88889
#define BCAST0_MSGTYPE 88890


#if !defined(GISUM)
#define GISUM( ix, nitem ) { \
	extern void gsum0( char *, int, int, int, int ); \
 \
	gsync(); \
	gsum0( (char *) (ix), (int) (nitem), \
		(int) (INTEGER_TYPE),  \
		(int) (GSUM0_MSGTYPE), (int) (IROOT) ); \
	bcast0( (char *) (ix),  \
		(int) (nitem*INTEGER_BYTES),  \
		(int) BCAST0_MSGTYPE, (int) IROOT ); \
	}
#endif				/* if GISUM */


#if !defined(GIMAX)
#define GIMAX( ix) { \
        extern void gsum0( char *, int, int, int, int ); \
 \
	gsync(); \
        gmax0( (char *) (ix), (int) (1), \
                (int) (INTEGER_TYPE),  \
                (int) (GMAX0_MSGTYPE), (int) (IROOT) ); \
        bcast0( (char *) (ix),  \
                (int) (1*INTEGER_BYTES),  \
                (int) BCAST0_MSGTYPE, (int) IROOT ); \
        }
#endif				/* if GIMAX */



#endif				/* if INTEL || NX || ... */


#define INTERRUPT_CHECK() { mark(); } 



#if NX || I860 || PARGON || PGON || INTEL

static long     orgmask;
static long     dummask;
static long     disable_mask = 1;

#define DISABLE_MASK 1
#define DISABLE_INTERRUPT() {orgmask = (long) masktrap((long) disable_mask);}
#define RESTORE_INTERRUPT() {dummask = (long) masktrap((long) orgmask);}

#if PGON || PARAGON
static long     info[16];
#define MSGRECV( msgtag, srcnode, buf, nbytes ) \
{\
 crecvx( (long) (msgtag),  \
	(char *) (buf),  \
	(long) (nbytes),  \
	(long) (srcnode),  \
	(long) myptype(),  \
	(long *) (&(info[0])) ); \
 assert( info[0] == (msgtag)); \
 assert( info[1] == (nbytes)); \
 assert( info[2] == (srcnode) );\
}

#else
#define MSGRECV( msgtag, srcnode, buf, nbytes ) \
{\
   crecv( (long) (msgtag), \
	 (char *) (buf), \
	 (long) (nbytes)); }
#endif

#else
/* not NX system, use PICL */
#define DISABLE_INTERRUPT()
#define RESTORE_INTERRUPT()

#define MSGRECV(msgtag,srcnode,buf,nbytes) { \
	extern void recv0( char*,int,int ); \
	extern void recv0info( int *, int *, int * ); \
	int bytes, type, source;  \
 \
	recv0( (char *) (buf), (int) (nbytes), (int) (msgtag) ); \
	recvinfo0(  &bytes, &type, &source ); \
	assert( bytes <= (nbytes) ); \
	assert( msgtag == (type) ); \
	assert( source == (srcnode) ); \
	}

#endif



	/* stuff relate to probing */


#if defined(PICL_VERSION)

	/*
	 * ***** extern void     send0(); extern void     recv0(); ********
	 */

	extern void     who0(int *, int *, int *);
	extern int      probe0(int);

#define WHO0 who0
#define SEND0 send0
#define PROBE0 probe0
#define RECV0 recv0

#else /* defined(PICL_VERSION) */

	/* use NX routines */


#if PGON || PARAGON

#include <nx.h>

#if (0)
	extern long     iprobe( long typesel);
	extern void     crecv(long typesel, char *buf, long bytes);
	extern long     numnodes(void);
	extern long     mynode(void);
	extern void 	csend( long type, char *buf, 
				long bytes, long inode, long itype);
#endif /* if (0) */

#endif



#define PROBE0( typesel ) (iprobe( (long) typesel ))

#define RECV0(buf,bytes,typesel) { \
	crecv( (long) (typesel), (char *) (buf), (long) (bytes) ); }


#define WHO0(nproc,myid,host) { \
	*(nproc)= numnodes();  \
	*(myid) = mynode();  \
	*(host) = 32768;  \
	}




#define SEND0( buf, bytes, type, inode ) { \
	csend( (long) (type), (char *) (buf), (long) (bytes),  \
		(long) (inode), (long) 0 ); }

#endif






#endif /* defined(MESSAGE_H) */
