/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include "stdinc.h"

void
isort(int *pix, int n, int *piperm)
#define iperm(j) piperm[(j)-1]
#define ix(j) pix[(j)-1]

/*
 * --- shell sort to sort a sequence of integers --- NOTE array ix(:) is NOT
 * modified --- return the permutation vector
 */
{
	int             itemp, ixert, j, k, m, maxmn;
	logical         done, inorder;

	for (j = 1; j <= n; j++) {
		iperm(j) = j;
	};

	m = n;
	done = (m == 0);
	while (!done) {
		m = m / 2;
		done = (m == 0);
		if (done) {
			break;
		};

		maxmn = n - m;
		for (j = 1; j <= maxmn; j++) {
			for (k = j; k >= 1; k = k - m) {
				ixert = ix(iperm(k + m));
				if (ixert >= ix(iperm(k))) {
					break;
				};

				itemp = iperm(k + m);
				iperm(k + m) = iperm(k);
				iperm(k) = itemp;
			};
		};
	};			/* end while */

	/* ---  double check */
	for (j = 1; j <= (n - 1); j++) {
		inorder = (ix(iperm(j)) <= ix(iperm(j + 1)));
		ASSERT(inorder, "isort(): sort failed\n", 0);
	};

	/* convert back to C index */
	for (j = 1; j <= n; j++) {
		iperm(j) = iperm(j) - 1;
	};

	return;
}
