#if !defined(_IPXHEADER_)
#define _IPXHEADER_

#include <stdio.h>
#define IPP void
#define IPPS void
#define MT_at 1
#define MT_now 2
#define MT_on 2
typedef unsigned long IDTYPE;
extern long thisnode;
extern FILE *logfile;
IDTYPE ipx_newid(long mtype);
void ipx_start(void);
void ipx_master_start(void);
void ipx_slave_start(void);
void ipx_slave_stop(void);
IDTYPE ipx_mark(void);
void ipx_finish(IDTYPE id);
void ipx_finish_to(IDTYPE id);
int ipx_isdone(IDTYPE id);
void ipx_wait(void);
IDTYPE ipx_get_array(char*sa, long len, char* da,long snode);
IDTYPE ipx_put_array(char*sa,long len, char*da,long dnode);


typedef unsigned char PCTR_T;
IDTYPE ipx_put_arrayx(char*sa,long len, char*da,long dnode,PCTR_T pctr);
long ipx_rd_pctr(PCTR_T pctr);
void ipx_clr_pctr(PCTR_T pctr);
int ipx_continue(int state);


/**** NOTE: The following section is specific to Paragon **/

#define QLOAD(A,B) buf.ID=ipx_newid(B);\
csend(B,(char*)&buf,sizeof(buf),(A),0);

#define i_disable() masktrap(1)
#define i_enable() masktrap(0)

/** The following defines are to maintain compatibility with 
user code written before the |ipx_| was prefixes to the IPX
library functions.  They should be modified or removed if
a user wishes to use the names for other purposes.  RM 6/16/94  **/

#define newid ipx_newid
#define master_start ipx_master_start
#define slave_start ipx_slave_start
#define slave_stop ipx_slave_stop
#define mark ipx_mark
#define finish ipx_finish
#define finish_to ipx_finish_to
#define isdone ipx_isdone
#define wait ipx_wait
#define get_array ipx_get_array
#define put_array ipx_put_array
#define put_arrayx ipx_put_arrayx
#define rd_pctr ipx_rd_pctr
#define clr_pctr ipx_clr_pctr

/** The following section is to facilitate code which can be used
with either the standard or no-interrupt version of IPX, assuming 
the latter makes use of a -Dnoint on the compiler command line.
Note that for the no-interrupt mode, Intel gsync()'s are re-defined
to the substitute IPX version, and for the regular version, explicit
ipx_gsync() calls are eliminated. **/

#if defined(noint)
#define gsync ipx_gsync
#define interrupt_check ipx_interrupt_check
void ipx_interrupt_check(void);
void ipx_gsync(void);
#else
#define ipx_gsync()
#define interrupt_check()
#define ipx_interrupt_check()
#endif

#endif  /* defined(_IPXHEADER_) */
