/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#if !defined(HTABLE_H)

#define HTABLE_H 1

#include <malloc.h>
#include <assert.h>
#include <stdio.h>

#include "doublelist.h"

typedef void (*vfp)();
typedef int (*ifp)();

#if !defined(HTABLE_SIZE)
#define HTABLE_SIZE (4*1024)
#endif


struct Htable_t {
	ifp   isequal;
	ifp   hash_htable;

	DoubleList global_list;
	DoubleList table[HTABLE_SIZE];
	};

typedef struct Htable_t *Htable;

struct HtableGCell_t {
	DLinkCellptr local_iptr;
	int hashed_result;
	};
typedef struct HtableGCell_t  HtableGCell;
typedef struct HtableGCell_t *HtableGCellptr;


struct HtableCell_t {
	void *key;
	DLinkCellptr global_iptr;
	void *pdata;
	};

typedef struct HtableCell_t HtableCell;
typedef struct HtableCell_t *HtableCellptr;


#if defined(USE_INLINE)

#define data_htable( myhtable, myiptr ) \
	(  (void *) ((myiptr)->pdata) )
#else

/* return the value of pdata */
void * data_htable( Htable myhtable, HtableCellptr myiptr );

#endif


Htable create_htable(  ifp isequal, ifp hash_htable );

/* return 0 if not found, otherwise the value of HtableCellptr */
DLinkCellptr find_htable( Htable myhtable, void *key );






/* insertion assume there are no duplicate entries */
void insert_htable( Htable myhtable, void *key, void *pdata );

/* returns pdata, user should explicitly free storage */

void *deletelast_htable( Htable myhtable );

HtableCellptr delete_htable( Htable myhtable, void *key );

/* return number of deletes */
int purge_htable( Htable myhtable, void *inkey, ifp ismatch );

#endif /* defined(HTABLE_H) */
