/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include "stdinc.h"

#include <assert.h>

#include "globals.h"

int
gni2proc(int Iaf, int gni)
{

	logical         isvalid;
	int             page_size, block_size, gsize, gblock_no, page_no;
	int             proc;

	struct Iarray_node *anp;

	extern int      nproc;

	isvalid = (1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY);
	ASSERT(isvalid, "gni2proc(): Iaf of %d out of range\n", Iaf);

	anp = Global_array[Iaf];
	ASSERT(anp != NULL, "gni2proc(): Iaf of %d indexes null entry\n", Iaf);

	gsize = anp->gsize;
	isvalid = (1 <= gni) && (gni <= gsize);
	ASSERT(isvalid, "gni2proc(): gni of %d out of range\n", gni);


	page_size = anp->page_size;
	ASSERT(page_size > 0, "gni2proc(): page_size of %d out of range\n", page_size);

	block_size = anp->block_size;
	ASSERT(block_size > 0, "gni2proc(): block_size of %d out of range\n", block_size);

	page_no = (gni - 1) / page_size;
	gblock_no = page_no / block_size;

	proc = gblock_no % nproc;

	return (proc);
}
