/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#if !defined(GLOBALS_H)
#define GLOBALS_H



#include "stdinc.h"

#define MAX_GLOBAL_ARRAY 256

#define DEFAULT_CACHE_FLAG FALSE


/*
 * Global_array is a global array of pointers to the following structure.
 * Each distributed object will correspond to an integer index into the
 * Global_array.  The following structure will then constitute the object:
 */

#define DECLARE_ALL_IARRAY_NODE()  \
  char          *name;  /* name of array */ \
  int           gsize;  /* global size of array */ \
  enum {REAL8, INTEGER, CHAR, REAL} type; \
  logical       cache_is_on; \
  int           page_size; /* for cacheing */ \
  int           block_size; /* pages per block */ \
  int		page_shift; /* if page_size=2^k, page_shift=k, else -1 */ \
  int		block_shift; /* if block_size=2^k, block_shift=k, else -1 */ \
  int           total_pages; \
  int           total_blocks; \
  int           nblocks; \
  void          **local_data_start; \
  dfloat        *dblock_ptr; \
  int           *iblock_ptr; \
  char		*cblock_ptr; \
  float         *rblock_ptr;

#define ASSIGN_ALL_IARRAY_NODE(Iaf) { \
	struct Iarray_node *XX; \
	XX = (Global_array[ Iaf ] ); \
  \
	name = XX->name; \
	gsize = XX->gsize; \
	type = XX->type; \
	cache_is_on = XX->cache_is_on; \
	page_size = XX->page_size; \
	block_size = XX->block_size; \
	page_shift = XX->page_shift; \
	block_shift = XX->block_shift; \
	total_pages = XX->total_pages; \
	total_blocks = XX->total_blocks; \
	nblocks = XX->nblocks; \
	local_data_start = XX->local_data_start; \
	dblock_ptr = XX->dblock_ptr; \
	iblock_ptr = XX->iblock_ptr; \
	cblock_ptr = XX->cblock_ptr; \
	rblock_ptr = XX->rblock_ptr; \
	}

struct Iarray_node {
	DECLARE_ALL_IARRAY_NODE()
};

struct Iarray_node *Global_array[MAX_GLOBAL_ARRAY + 1];

int             myid;
int             nproc;
int		proc_shift;

#if !defined(ISINTEGER)
#define ISINTEGER(Iaf) ( \
	((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY)) &&  \
	(Global_array[ Iaf ] != NULL) &&  \
	(Global_array[ Iaf ]->type == INTEGER)  \
	)
#endif

#if !defined(ISREAL8)
#define ISREAL8(Iaf) ( \
	((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY)) &&  \
	(Global_array[ Iaf ] != NULL) &&  \
	(Global_array[ Iaf ]->type == REAL8)  \
	)
#endif

#if !defined(ISCHAR)
#define ISCHAR(Iaf) ( \
	((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY)) &&  \
	(Global_array[ Iaf ] != NULL) &&  \
	(Global_array[ Iaf ]->type == CHAR)  \
	)
#endif

#if !defined(ISREAL)
#define ISREAL(Iaf) ( \
	((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY)) &&  \
	(Global_array[ Iaf ] != NULL) &&  \
	(Global_array[ Iaf ]->type == REAL)  \
	)
#endif

#endif
