/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include <stdio.h>
#include <assert.h>

#include "ipx.h"
extern IDTYPE   get_array(char *sa, long len, char *da, long snode);
#define GET_ARRAY(sa,len,da,snode) \
	get_array( (char *) (sa), (long) (len), (char *) (da), (long) (snode) )


#include "stdinc.h"
#include "globals.h"

#if !defined(GET_SUCCESS)
#define GET_SUCCESS 0
#endif

extern void    *ch_get_page(int Iaf, int page_no);
extern void     ch_store_page(int Iaf, int page_no, void *page_ptr);


#define COMPUTE_LOCAL(anp,Iaf,page_no,lpage_no,page_size,\
		proc,is_local,is_integer,is_dfloat,is_char,is_real,nbytes)\
{  \
  logical is_valid;   \
  int  block_size,    total_pages,nblocks,total_blocks;  \
  int gblock_no, lblock_no,  block_offset;  \
  \
  is_valid = ((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY));  \
  ASSERT(is_valid, "COMPUTE_LOCAL: Iaf of %d out of range\n", Iaf);  \
  \
  anp = Global_array[Iaf];  \
  ASSERT(anp != NULL, "COMPUTE_LOCAL: Iaf of %d indexes null entry\n", Iaf);  \
  \
  page_size = anp->page_size;  \
  ASSERT(page_size > 0, "COMPUTE_LOCAL: page_size of %d out of range\n", page_size);  \
  \
  block_size = anp->block_size;  \
  ASSERT( block_size > 0,"COMPUTE_LOCAL: block_size of %d out of range\n", block_size);  \
  \
  total_pages = anp->total_pages;  \
  is_valid = ((0 <= page_no) && (page_no < total_pages));  \
  ASSERT (is_valid, "COMPUTE_LOCAL: page_no of %d out of range\n", page_no);  \
  \
  total_blocks = anp->total_blocks;  \
  ASSERT( total_blocks > 0, "COMPUTE_LOCAL: total_blocks of %d out of range\n", total_blocks);  \
  \
  nblocks = anp->nblocks;  \
  ASSERT( nblocks >= 0, "COMPUTE_LOCAL: nblocks of %d out of range\n", nblocks);  \
  \
  is_integer = (anp->type == INTEGER);  \
  is_dfloat = (anp->type == REAL8);  \
  is_char = (anp->type == CHAR);  \
  is_real = (anp->type == REAL);  \
  \
  is_valid = (is_integer || is_dfloat || is_char || is_real);  \
  ASSERT( is_valid ,"COMPUTE_LOCAL: global array type not valid\n", 0);  \
  \
  /* do index calculations */  \
  \
  gblock_no = page_no / block_size;  \
  \
  /* compute local block, page numbers */  \
  \
  lblock_no = gblock_no / nproc;  \
  is_valid = (0 <= lblock_no);  \
  ASSERT( is_valid ,"COMPUTE_LOCAL: lblock_no of %d out of range\n", lblock_no);  \
  \
  /* check to see if I own it */  \
  \
  /* -- Ed: modified original code "proc = gblock_no % nproc;" */ \
  \
  proc = (gblock_no - (lblock_no*nproc)); \
  is_valid = ((0 <= proc) && (proc < nproc)); \
  ASSERT( is_valid ,"COMPUTE_LOCAL: proc of %d out of range\n", proc); \
  is_local = (proc == myid);  \
  \
  \
  /* -- Ed:  modified original code "block_offset = page_no % block_size;" */ \
  \
  block_offset = page_no - (gblock_no*block_size); \
  lpage_no = (lblock_no * block_size) + block_offset;  \
  \
  \
  \
  \
  if (is_integer) {  \
	nbytes = sizeof(int)*page_size;  \
	}  \
  else if (is_dfloat) {  \
	nbytes = sizeof(dfloat)*page_size;  \
	}   \
  else if (is_char) {  \
	nbytes = sizeof(char)*page_size;  \
	}  \
  else if (is_real) {  \
	nbytes = sizeof(float)*page_size;  \
	}   \
  else { /* impossible */   \
	ASSERT(FALSE, "COMPUTE_LOCAL: global array type not valid\n", 0);  \
	}  \
  \
}


/*
 * GET_PAGE
 */

IDTYPE
iget_page(int Iaf, int page_no, void **ppage_ptr)
{
	int             proc;
	logical         is_local;
	logical         is_in_cache;
	logical         is_integer, is_dfloat, is_char, is_real;

	extern int      myid;
	extern int      nproc;

	struct Iarray_node *anp;

	IDTYPE          ipxid;

	int            *iremote_ptr;
	dfloat         *dremote_ptr;
	char           *cremote_ptr;
	float          *rremote_ptr;

	int            *iptr;
	dfloat         *dptr;
	char           *cptr;
	float          *rptr;

	int            *iblock_ptr;
	dfloat         *dblock_ptr;
	char           *cblock_ptr;
	float          *rblock_ptr;

	int             nbytes;
	char           *src;
	char           *dest;

	char           *page_ptr;
	int             lpage_no, page_size;

	logical         userbuf;


	/*
	 * userbuf is true mean we can safely drain the entire page into user
	 * buffer, this avoids extra memalloc
	 */

	userbuf = (*ppage_ptr != NULL);

	/* verify that Iaf is valid */
	COMPUTE_LOCAL(anp, Iaf, page_no, lpage_no, page_size,
		      proc, is_local, is_integer, is_dfloat, is_char,
		      is_real, nbytes);

	if (is_local) {
		if (is_integer) {
			iptr = (int *) (anp->iblock_ptr);
			src = (char *) (&(iptr[lpage_no * page_size]));
			if (userbuf) {
				/* copy into user buffer */
				dest = (char *) *ppage_ptr;
				BCOPY(src, dest, nbytes);
			} else {
				*ppage_ptr = (void *) src;
			};
		} else if (is_dfloat) {
			dptr = (dfloat *) (anp->dblock_ptr);
			src = (char *) (&(dptr[lpage_no * page_size]));
			if (userbuf) {
				/* copy into user buffer */
				dest = (char *) *ppage_ptr;
				BCOPY(src, dest, nbytes);
			} else {
				*ppage_ptr = (void *) src;
			};

		} else if (is_char) {
			cptr = (char *) (anp->cblock_ptr);
			src = (char *) (&(cptr[lpage_no * page_size]));

			if (userbuf) {
				/* copy into user buffer */
				dest = (char *) *ppage_ptr;
				BCOPY(src, dest, nbytes);
			} else {
				*ppage_ptr = (void *) src;
			};

		} else if (is_real) {
			rptr = (float *) (anp->rblock_ptr);
			src = (char *) (&(rptr[lpage_no * page_size]));

			if (userbuf) {
				/* copy into user buffer */
				dest = (char *) *ppage_ptr;
				BCOPY(src, dest, nbytes);
			} else {
				*ppage_ptr = (void *) src;
			};

		} else {	/* impossible */
			ASSERT(FALSE,"iget_page(): global array type not valid\n", 0);
		}

		return (GET_SUCCESS);
	}
	/* nope.  check to see if page is in cache. */

	if (anp->cache_is_on) {
		page_ptr = ch_get_page(Iaf, page_no);
		is_in_cache = ((page_ptr) != NULL);

		if (is_in_cache) {
			if (userbuf) {
				/* copy from cache and drain into user buffer */

				src = (char *) page_ptr;
				dest = (char *) *ppage_ptr;

				BCOPY(src, dest, nbytes);
			} else {
				*ppage_ptr = page_ptr;
			};

			return (GET_SUCCESS);
		}
	}
	/* nope.  force my neighbor to send it to me. */

	/* **** Ed changed code to void pointer arithmetic */

	if (is_integer) {
		iblock_ptr = (int *) (anp->local_data_start[proc]);
		iremote_ptr = (int *) (&(iblock_ptr[lpage_no * page_size]));
		/* iremote_ptr = (int *) (iblock_ptr + lpage_no * page_size); */


		if (userbuf) {

			/* GET_ARRAY drain directly into user buffer */

			page_ptr = *ppage_ptr;
		} else {

			MEMALLOC(page_ptr, (char *), nbytes);
			*ppage_ptr = (void *) page_ptr;

		};

		ipxid = (GET_ARRAY(iremote_ptr, nbytes, page_ptr, proc));
	} else if (is_dfloat) {

		dblock_ptr = (dfloat *) (anp->local_data_start[proc]);
		/*
		 * dremote_ptr = (dfloat *) (dblock_ptr + lpage_no *
		 * page_size);
		 */
		dremote_ptr = (dfloat *) (&(dblock_ptr[lpage_no * page_size]));


		if (userbuf) {

			/* GET_ARRAY drain directly into user buffer */

			page_ptr = *ppage_ptr;
		} else {

			MEMALLOC(page_ptr, (char *), nbytes);
			*ppage_ptr = (void *) page_ptr;

		};


		ipxid = (GET_ARRAY(dremote_ptr, nbytes, page_ptr, proc));


	} else if (is_char) {

		cblock_ptr = (char *) (anp->local_data_start[proc]);
		/*
		 * cremote_ptr = (char *) (cblock_ptr + lpage_no *
		 * page_size);
		 */
		cremote_ptr = (char *) (&(cblock_ptr[lpage_no * page_size]));


		if (userbuf) {

			/* GET_ARRAY drain directly into user buffer */

			page_ptr = *ppage_ptr;
		} else {

			MEMALLOC(page_ptr, (char *), nbytes);
			*ppage_ptr = (void *) page_ptr;

		};




		ipxid = (GET_ARRAY(cremote_ptr, nbytes, page_ptr, proc));

	} else if (is_real) {
		rblock_ptr = (float *) (anp->local_data_start[proc]);
		/*
		 * rremote_ptr = (float *) (rblock_ptr + lpage_no *
		 * page_size);
		 */
		rremote_ptr = (float *) (&(rblock_ptr[lpage_no * page_size]));


		if (userbuf) {

			/* GET_ARRAY drain directly into user buffer */

			page_ptr = *ppage_ptr;
		} else {

			MEMALLOC(page_ptr, (char *), nbytes);
			*ppage_ptr = (void *) page_ptr;

		};




		ipxid = (GET_ARRAY(rremote_ptr, nbytes, page_ptr, proc));
	} else {		/* impossible */
		ASSERT(FALSE,"iget_page(): global array type not valid\n", 0);
	}

	/* Ed May 27: use mark() instead of "get_array" to get IPX tag */
	ASSERT(mark() == ipxid,"iget_page(): ipxid mismatch with return value from mark()\n", 0);
	return (mark());
}

logical
isdone_page(IDTYPE gid)
{
	if (gid == GET_SUCCESS) {
		return (TRUE);
	}
	return (isdone(gid));
}

void
wait_page(IDTYPE gid)
{


	if (gid == GET_SUCCESS) {
		return;
	}
	while (!isdone_page(gid)) {	/* simply loop */
	}
}

void
return_page(int Iaf, int page_no, void *page_ptr, logical userbuf)
{
	struct Iarray_node *anp;
	logical         is_local, is_integer, is_dfloat, is_char, is_real;
	int             nbytes;
	int             proc;
	int             lpage_no, page_size;

	void           *page_ptr2;
	void           *new_page_ptr;
	logical         is_in_cache;

	char           *src;
	char           *dest;

	ASSERT(page_ptr != NULL,"return_page(): page_ptr is null\n", 0);
	COMPUTE_LOCAL(anp, Iaf, page_no, lpage_no, page_size,
		      proc, is_local, is_integer, is_dfloat, is_char,
		      is_real, nbytes);

	/* determine whether this page should be cached */
	if (is_local) {
		return;
	}
	if (!(anp->cache_is_on)) {
		if (!userbuf) {
			MEMFREE((page_ptr));	/* need to free memory */
		};
		return;
	}
	page_ptr2 = ch_get_page(Iaf, page_no);
	is_in_cache = (page_ptr2 != NULL);
	if (is_in_cache) {
		/* --------------------- */
		/* page already in cache */
		/* --------------------- */
		if ((page_ptr2) != (page_ptr)) {
			/* same page was requested more than once */
			/* the page is already inserted in the cache */
			/* thus need to free memory */

			if (!userbuf) {
				MEMFREE((page_ptr));	/* need to free memory */
			};
		}
		return;
	}
	/* if cacheing, cache it */

	if (userbuf) {
		/*
		 * the data was drained into user buffer, need to make a copy
		 * and place in cache
		 */

		MEMALLOC(new_page_ptr, (char *), nbytes);
		src = (char *) page_ptr;
		dest = (char *) new_page_ptr;
		BCOPY(src, dest, nbytes);

		ch_store_page(Iaf, page_no, new_page_ptr);

	} else {
		ch_store_page(Iaf, page_no, page_ptr);
	};

	return;
}

/* backward compatible */

#if (0)
void
get_page(int Iaf, int page_no, void *page_ptr)
{

	struct Iarray_node *anp;
	logical         is_local, is_integer, is_dfloat, is_char, is_real;
	int             nbytes;
	void           *page_ptr2;

	char           *src;
	char           *dest;
	int             lpage_no, page_size;
	int             proc;

	COMPUTE_LOCAL(anp, Iaf, page_no, lpage_no, page_size,
		      proc, is_local, is_integer, is_dfloat, is_char,
		      is_real, nbytes);

	wait_page(iget_page(Iaf, page_no, &page_ptr2));

	ASSERT(page_ptr2 != NULL,"get_page(): page_ptr2 is null\n", 0);

	src = (char *) page_ptr2;
	dest = (char *) page_ptr;
	BCOPY(src, dest, nbytes);

	return_page(Iaf, page_no, page_ptr2);
	page_ptr2 = NULL;
}
#endif

void
get_ppage(int Iaf, int page_no, void **ppage_ptr)
{
	void           *page_ptr2;


	wait_page(iget_page(Iaf, page_no, &page_ptr2));
	ASSERT(page_ptr2 != NULL,"get_ppage(): page_ptr2 is null\n", 0);

	*ppage_ptr = page_ptr2;
}
