/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include "stdinc.h"
#include "globals.h"


#include "donio.h"
#include "dolib.h"
#include "externs.h"


#if AIX || IBM || RS6K || RIOS
#else
#define UNDERSCORE 1
#endif




#if UNDERSCORE

#define DOBDSCATTER dobdscatter_
#define DOBISCATTER dobiscatter_
#define DOBRSCATTER dobrscatter_
#define DOBCSCATTER dobcscatter_

#define DOBDGATHER dobdgather_
#define DOBRGATHER dobrgather_
#define DOBIGATHER dobigather_
#define DOBCGATHER dobcgather_

#define DOWAIT dowait_
#define DOGSYNC dogsync_

#define IPXSTART ipxstart_

#define DODECLARE dodeclare_
#define DODESTROY dodestroy_

#define DOIGATHER doigather_
#define DODGATHER dodgather_
#define DORGATHER dorgather_

#define DOISCATTER doiscatter_
#define DODSCATTER dodscatter_
#define DORSCATTER dorscatter_

#define DOIAXPBY doiaxpby_
#define DODAXPBY dodaxpby_
#define DORAXPBY doraxpby_

#define DOBIAXPBY dobiaxpby_
#define DOBDAXPBY dobdaxpby_
#define DOBRAXPBY dobraxpby_



#define DOIAXPBYZ doiaxpbyz_
#define DODAXPBYZ dodaxpbyz_
#define DORAXPBYZ doraxpbyz_

#define DOBIAXPBYZ dobiaxpbyz_
#define DOBDAXPBYZ dobdaxpbyz_
#define DOBRAXPBYZ dobraxpbyz_




#define DOENABLE doenable_
#define DODISABLE dodisable_

#define DOINIT doinit_

#define DONIO donio_

#define DOSETCHSIZE dosetchsize_


#define DOOPEN doopen_
#define DOCLOSE doclose_
#define DOLSEEK dolseek_
#define DOREAD doread_

#define DOLSIZE dolsize_
#define DOWRITE dowrite_
#define DOFLUSH doflush_

#define DOCHECK docheck_

#else

#define DOBDSCATTER dobdscatter
#define DOBRSCATTER dobrscatter
#define DOBISCATTER dobiscatter
#define DOBCSCATTER dobcscatter


#define DOBDGATHER dobdgather
#define DOBRGATHER dobrgather
#define DOBIGATHER dobigather
#define DOBCGATHER dobcgather

#define DOWAIT dowait

#define IPXSTART ipxstart

#define DODECLARE dodeclare
#define DODESTROY dodestroy

#define DOIGATHER doigather
#define DODGATHER dodgather
#define DORGATHER dorgather

#define DOISCATTER doiscatter
#define DODSCATTER dodscatter
#define DORSCATTER dorscatter

#define DOIAXPBY doiaxpby
#define DODAXPBY dodaxpby
#define DORAXPBY doraxpby


#define DOBIAXPBY dobiaxpby
#define DOBDAXPBY dobdaxpby
#define DOBRAXPBY dobraxpby


#define DOIAXPBYZ doiaxpbyz
#define DODAXPBYZ dodaxpbyz
#define DORAXPBYZ doraxpbyz

#define DOBIAXPBYZ dobiaxpbyz
#define DOBDAXPBYZ dobdaxpbyz
#define DOBRAXPBYZ dobraxpbyz



#define DOENABLE doenable
#define DODISABLE dodisable

#define DOINIT doinit
#define DONIO donio

#define DOSETCHSIZE dosetchsize


#define DOOPEN doopen
#define DOCLOSE doclose
#define DOLSEEK dolseek
#define DOREAD doread

#define DOLSIZE dolsize
#define DOWRITE dowrite
#define DOFLUSH doflush


#define DOCHECK docheck
#endif

void
DOCHECK(void)
{
	extern void     do_check(void);

	do_check();
}

void
DOINIT(int *param_myid, int *param_nproc)
{
	do_init(*param_myid, *param_nproc);
}

void
DONIO(int *param_myid, int *param_nproc)
{
        do_nio(*param_myid, *param_nproc);
}



void
DODECLARE(int *Iaf, char *name, int *gsize,
	  char *ctype, int *page_size, int *block_size)
{
	do_declare(Iaf, name, *gsize, ctype, *page_size, *block_size);
}

void
DODESTROY(int *Iaf)
{
	do_destroy(*Iaf);
}


void
DOSETCHSIZE(int *npages)
{
	do_setchsize(*npages);
}


void
DOIGATHER(int *Iaf, int *nsize, int *list, int *buf)
{
	do_gather_C(*Iaf, *nsize, list, buf);
}

void
DODGATHER(int *Iaf, int *nsize, int *list, dfloat * buf)
{
	do_gather_C(*Iaf, *nsize, list, buf);
}

void
DORGATHER(int *Iaf, int *nsize, int *list, float *buf)
{
	do_gather_C(*Iaf, *nsize, list, buf);
}

void
DOCGATHER(int *Iaf, int *nsize, int *list, char *buf)
{
	do_gather_C(*Iaf, *nsize, list, buf);
}


int
DOBDGATHER(int *Iaf, int *nsize, int *index_start, dfloat * buf)
{
	return (do_bgather_C(*Iaf, *nsize, *index_start, buf));
}

int
DOBRGATHER(int *Iaf, int *nsize, int *index_start, float *buf)
{
	return (do_bgather_C(*Iaf, *nsize, *index_start, buf));
}

int
DOBIGATHER(int *Iaf, int *nsize, int *index_start, int *buf)
{
	return (do_bgather_C(*Iaf, *nsize, *index_start, buf));
}

int
DOBCGATHER(int *Iaf, int *nsize, int *index_start, char *buf)
{
	return (do_bgather_C(*Iaf, *nsize, *index_start, buf));
}



void
DOISCATTER(int *Iaf, int *nsize, int *list, int *buf)
{
	do_scatter_C(*Iaf, *nsize, list, buf);
}


void
DODSCATTER(int *Iaf, int *nsize, int *list, dfloat * buf)
{
	do_scatter_C(*Iaf, *nsize, list, buf);
}

void
DORSCATTER(int *Iaf, int *nsize, int *list, float *buf)
{
	do_scatter_C(*Iaf, *nsize, list, buf);
}

void
DOCSCATTER(int *Iaf, int *nsize, int *list, char *buf)
{
	do_scatter_C(*Iaf, *nsize, list, buf);
}


void
DOBDSCATTER(int *Iaf, int *nsize, int *index_start, dfloat * buf)
{
	do_bscatter_C(*Iaf, *nsize, *index_start, buf);
}

void
DOBRSCATTER(int *Iaf, int *nsize, int *index_start, float *buf)
{
	do_bscatter_C(*Iaf, *nsize, *index_start, buf);
}

void
DOBISCATTER(int *Iaf, int *nsize, int *index_start, int *buf)
{
	do_bscatter_C(*Iaf, *nsize, *index_start, buf);
}


void
DOBCSCATTER(int *Iaf, int *nsize, int *index_start, char *buf)
{
	do_bscatter_C(*Iaf, *nsize, *index_start, buf);
}




void
DOIAXPBY(int *Iaf, int *nsize, int *list, int *xvalues,
	 int *alpha, int *beta)
{
	do_iaxpby_C(*Iaf, *nsize, list, (void *) xvalues,
		    (int) *alpha, (int) *beta);
}

void
DODAXPBY(int *Iaf, int *nsize, int *list, dfloat * xvalues,
	 dfloat * alpha, dfloat * beta)
{
	do_daxpby_C(*Iaf, *nsize, list, (void *) xvalues,
		    (dfloat) * alpha, (dfloat) * beta);
}

void
DORAXPBY(int *Iaf, int *nsize, int *list, float *xvalues,
	 float *alpha, float *beta)
{
	do_raxpby_C(*Iaf, *nsize, list, (void *) xvalues,
		    (float) *alpha, (float) *beta);
}


void 
DOBIAXPBY(int *Iaf, int *nsize, int *idxstart, int *xvalues,
	  int *alpha, int *beta)
{

	do_biaxpby_C(*Iaf, *nsize, *idxstart, (void *) xvalues,
		     (int) *alpha, (int) *beta);
}



void 
DOBDAXPBY(int *Iaf, int *nsize, int *idxstart, dfloat * xvalues,
	  dfloat * alpha, dfloat * beta)
{

	do_bdaxpby_C(*Iaf, *nsize, *idxstart, (void *) xvalues,
		     (dfloat) * alpha, (dfloat) * beta);
}


void 
DOBRAXPBY(int *Iaf, int *nsize, int *idxstart, float *xvalues,
	  float *alpha, float *beta)
{

	do_braxpby_C(*Iaf, *nsize, *idxstart, (void *) xvalues,
		     (float) *alpha, (float) *beta);
}




void
DOIAXPBYZ(int *Iaf, int *nsize, int *list, int *xvalues,
	 int *alpha, int *beta)
{
	do_iaxpbyz_C(*Iaf, *nsize, list, (void *) xvalues,
		    (int) *alpha, (int) *beta);
}

void
DODAXPBYZ(int *Iaf, int *nsize, int *list, dfloat * xvalues,
	 dfloat * alpha, dfloat * beta)
{
	do_daxpbyz_C(*Iaf, *nsize, list, (void *) xvalues,
		    (dfloat) * alpha, (dfloat) * beta);
}

void
DORAXPBYZ(int *Iaf, int *nsize, int *list, float *xvalues,
	 float *alpha, float *beta)
{
	do_raxpbyz_C(*Iaf, *nsize, list, (void *) xvalues,
		    (float) *alpha, (float) *beta);
}


void 
DOBIAXPBYZ(int *Iaf, int *nsize, int *idxstart, int *xvalues,
	  int *alpha, int *beta)
{

	do_biaxpbyz_C(*Iaf, *nsize, *idxstart, (void *) xvalues,
		     (int) *alpha, (int) *beta);
}



void 
DOBDAXPBYZ(int *Iaf, int *nsize, int *idxstart, dfloat * xvalues,
	  dfloat * alpha, dfloat * beta)
{

	do_bdaxpbyz_C(*Iaf, *nsize, *idxstart, (void *) xvalues,
		     (dfloat) * alpha, (dfloat) * beta);
}


void 
DOBRAXPBYZ(int *Iaf, int *nsize, int *idxstart, float *xvalues,
	  float *alpha, float *beta)
{

	do_braxpbyz_C(*Iaf, *nsize, *idxstart, (void *) xvalues,
		     (float) *alpha, (float) *beta);
}










void
DOENABLE(int *Iaf)
{
	do_enable(*Iaf);
}

void
DODISABLE(int *Iaf)
{
	do_disable(*Iaf);
}


int
DOOPEN(char *path, int *flags, int *mode)
{
	return (do_open(path, *flags, *mode));
}

int
DOLSEEK(int *do_fd, int *offset, int *whence)
{
	return (do_lseek(*do_fd, *offset, *whence));
}


void
DOREAD(int *do_fd, int *buf, int *nbytes)
{
	do_read(*do_fd, (void *) buf, *nbytes);
}

void
DOLSIZE(int *do_fd, int *nbytes)
{
	do_lsize(*do_fd, *nbytes);
}

void
DOWRITE(int *do_fd, int *buf, int *nbytes)
{
	do_write(*do_fd, (void *) buf, *nbytes);
}

void
DOFLUSH(int *do_fd)
{
	do_flush(*do_fd);
}

void
DOCLOSE(int *do_fd)
{
	do_close(*do_fd);
}

void
IPXSTART()
{
	ipx_start();
}

void
DOWAIT(int *reqid)
{
	extern void     do_wait(int);

	do_wait(*reqid);
}

void
DOGSYNC()
{
	extern void     do_gsync(void);

	do_gsync();
}
