/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#if !defined(EXTERNS_H)
#define EXTERNS_H 1

#include "stdinc.h"

/* external declarations for the implementation part of DOLIB */


#if defined(_NO_PROTO)


extern void do_gather_C();
extern void do_scatter_C();

extern void do_bscatter_C();





extern int      do_agather();

extern void do_axpby();
extern void do_axpbyz();

extern void do_baxpby();
extern void do_baxpbyz();

extern void do_bdaxpby_C();
extern void do_biaxpby_C();
extern void do_braxpby_C();

extern void do_daxpby_C();
extern void do_iaxpby_C();
extern void do_raxpby_C();

extern void do_bdaxpbyz_C();
extern void do_biaxpbyz_C();
extern void do_braxpbyz_C();

extern void do_daxpbyz_C();
extern void do_iaxpbyz_C();
extern void do_raxpbyz_C();



extern void do_bset_axpby();




extern int do_setgather();
extern int      do_bgather_C();




#else


extern void do_gather_C(int Iaf, int nsize, int *list, void *buf);
extern void do_scatter_C(int Iaf, int nsize, int *list, void *buf);

extern void do_bscatter_C(int Iaf, int nsize, int index_start, void *buf);





extern int      do_agather(int Iaf, int nsize, int *list, void *buf);

extern void 
do_axpby(int Iaf, int nsize, int *list, void *xvalues,
	 int ialpha, int ibeta, dfloat dalpha, dfloat dbeta);

extern void 
do_axpbyz(int Iaf, int nsize, int *list, void *xvalues,
	 int ialpha, int ibeta, dfloat dalpha, dfloat dbeta);


extern void 
do_baxpby(int Iaf, int nsize, int index_start, void *buf,
	  int ialpha, int ibeta,
	  dfloat dalpha, dfloat dbeta);


extern void
do_baxpbyz(int Iaf, int nsize, int index_start, void *buf,
          int ialpha, int ibeta,
          dfloat dalpha, dfloat dbeta);


extern void 
do_bdaxpby_C(int Iaf, int nsize, int index_start, dfloat * xvec,
	     dfloat dalpha, dfloat dbeta);
extern void 
do_biaxpby_C(int Iaf, int nsize, int idxstart, int *xvec,
	     int ialpha, int ibeta);
extern void 
do_braxpby_C(int Iaf, int nsize, int index_start, float *xvec,
	     float dalpha, float dbeta);


extern void 
do_daxpby_C(int Iaf, int nsize, int *list, dfloat * xvec,
	    dfloat dalpha, dfloat dbeta);
extern void 
do_iaxpby_C(int Iaf, int nsize, int *list, int *xvec,
	    int ialpha, int ibeta);
extern void 
do_raxpby_C(int Iaf, int nsize, int *list, float *xvec,
	    float dalpha, float dbeta);







extern void
do_bdaxpbyz_C(int Iaf, int nsize, int index_start, dfloat * xvec,
             dfloat dalpha, dfloat dbeta);
extern void
do_biaxpbyz_C(int Iaf, int nsize, int idxstart, int *xvec,
             int ialpha, int ibeta);
extern void
do_braxpbyz_C(int Iaf, int nsize, int index_start, float *xvec,
             float dalpha, float dbeta);


extern void
do_daxpbyz_C(int Iaf, int nsize, int *list, dfloat * xvec,
            dfloat dalpha, dfloat dbeta);
extern void
do_iaxpbyz_C(int Iaf, int nsize, int *list, int *xvec,
            int ialpha, int ibeta);
extern void
do_raxpbyz_C(int Iaf, int nsize, int *list, float *xvec,
            float dalpha, float dbeta);







extern void 
do_bset_axpby(int Iaf, int nsize, void *xvalues, int *list,
	      int nsets, int index_start, int *start_list, int *size_list,
	      int ialpha, int ibeta, dfloat dalpha, dfloat dbeta);



extern int      do_bgather_C(int Iaf, int nsize, int index_start, void *buf);
extern int 
do_setgather(int Iaf, int nsize, int *list,
	     int nsets, int *gindex, int *start_list, int *size_list,
	     logical is_sorted, logical use_compress, void *buf);




#endif /* defined(_NO_PROTO) */

#endif
