/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/


#include "stdinc.h"


#include <stdio.h>
#include <assert.h>

#if !defined(IDEBUG)
/* IDEBUG == 0, mean no runtime, checking */
#define IDEBUG 0
#endif

#if !defined(MOD)
#define MOD(ix,ibase)  (  (ix) % (ibase) )
#endif

#if !defined(LOGICAL)
#define LOGICAL int
#endif

#if !defined(max)
#define max(ix,iy) ( ( (ix) > (iy) ) ? (ix) : (iy)  )
#endif


/* NOTE index_list[] is in FORTRAN indexing that starts from 1 */

int
encode_list(nitems, index_list, segment_size,
	    maxsets, start_list, size_list)
	int             nitems;
	int            *index_list;
	int             segment_size;
	int             maxsets;
	int            *start_list;
	int            *size_list;
{

	int             i, j, nsets, jvalue, istart, ifree, ip, gni, nsize,
	                isegment, jsegment, segment_lo, seglimit, imod;

	int		segment_shift;


	LOGICAL         is_valid, is_same, is_sameseg, all_done, spaceok;
#if defined(ORIGINAL)
	LOGICAL         is_contig;
#endif

	extern int	compute_shift();

	/* =============== */

	ASSERT(segment_size >= 1, "encode_list(): segment_size of %d out of range\n", segment_size);
	ASSERT(maxsets >= 1, "encode_list(): maxsets of %d out of range\n", maxsets);
	ASSERT(start_list != NULL, "encode_list(): start_list is null\n", 0);
	ASSERT(size_list != NULL, "encode_list(): size_list is null\n", 0);


	if (nitems <= 0) {
		return (-1);
	};

	istart = 0;
	ifree = 0;
	nsets = 0;

	segment_lo = -1;
	seglimit = -1;

	segment_shift = compute_shift(segment_size);

	for (;;) {

		nsize = 0;

		/* compute segment boundary */

		gni = index_list[istart];
		is_sameseg = ((segment_lo <= gni) && (gni <= seglimit));
		if (!is_sameseg) {
			/* recompute segment bounds */

			imod = MOD_OR_SHIFT(gni, segment_size, segment_shift);
			if (imod == 0) {
				imod = segment_size;
			};

			seglimit = gni + (segment_size - imod);

#if defined(DEBUG)
			is_valid = ((1 <= seglimit) &&
				    (gni <= seglimit) &&
				    (MOD_OR_SHIFT(seglimit, segment_size, segment_shift) == 0));
			ASSERT(is_valid, "encode_list(): seglimit of %d invalid\n", seglimit);
#endif

			segment_lo = max(1, seglimit - segment_size + 1);
		};		/* end if (!is_sameseg) */

		for (;;) {


#if defined(ORIGINAL)
			/*
			 * ip is index into "index_list[:]", hence start from
			 * 0
			 */
			ip = istart + nsize;

			is_valid = (ip < nitems);
			if (!is_valid) {
				break;
			};

			/* gni is with FORTRAN index, hence start from 1 */
			gni = index_list[ip];

			is_sameseg = ((segment_lo <= gni) &&
				      (gni <= seglimit));
			if (!is_sameseg) {
				break;
			};

			is_contig = (index_list[istart + nsize] ==
				     (index_list[istart] + nsize));
			if (!is_contig) {
				break;
			};

			/*
			 * we now have the condition (is_valid && is_contig
			 * && is_sameseg)
			 */

			nsize++
#else
			if ((istart + nsize < nitems)	/* is_valid */
			    && (index_list[istart + nsize] == 
				index_list[istart] + nsize) /* is_contig */
			    &&
			    ((segment_lo <= (index_list[(istart + nsize)])) &&
			     ((index_list[(istart + nsize)]) <= seglimit))) {
			  nsize++;
			} else {
			  break;
			};

#endif				/* defined(ORIGINAL) */

		};

		spaceok = (ifree < maxsets);
		if (!spaceok) {
		  return (-1);
		};

		nsets = nsets + 1;

		/* NOTE: start_list stores the local index into index_list */

		start_list[ifree] = istart;
		is_valid = ((0 <= istart) && (istart < nitems));
		ASSERT(is_valid,
		       "encode_list(): istart of %d out of range\n", istart);

		size_list[ifree] = nsize;
		is_valid = ((1 <= nsize) && (nsize <= (nitems - istart)));
		ASSERT(is_valid,
		       "encode_list(): nsize of %d out of range\n", nsize);
		ifree = ifree + 1;
		istart = istart + nsize;

		all_done = (istart >= nitems);
		if (all_done) {
		  break;
		};
	};

	/* debug-begin */
	if (IDEBUG >= 3) {
		printf("encode_list[:]\n");
		for (i = 0; i < nsets; i = i + 1) {
			istart = start_list[i];
			nsize = size_list[i];
			printf("i %d, istart %d, index_list[istart], %d nsize %d \n",
			       i, istart, index_list[istart], nsize);
		};
		printf("\n");
	};
	/* debug-end */

	if (IDEBUG >= 1) {

		/* --------------------------------- */
		/* double check contiguous sequence */
		/* --------------------------------- */

		ip = 0;
		for (i = 0; i < nsets; i = i + 1) {

			/*
			 * NOTE: start_list stores the local index into
			 * index_list[*]
			 */

			istart = start_list[i];
			jvalue = index_list[istart];
			nsize = size_list[i];

			for (j = 0; j < nsize; j = j + 1) {
			  is_valid = ((0 <= ip) && (ip < nitems));
			  ASSERT(is_valid,
				 "encode_list(): ip of %d out of range\n", ip);

			  is_same = (index_list[ip] == jvalue);
			  if (!is_same) {
			    printf("ip %d, index_list[ip] %d\n",
				   ip, index_list[ip]);
			    printf("i %d istart %d, nsize %d, jvalue %d\n",
				   i, istart, nsize, jvalue);
			  };
			  ASSERT(is_same,
				 "encode_list(): jvalue of %d invalid\n",
				 jvalue);

				ip = ip + 1;
				jvalue = jvalue + 1;
			};	/* end for(j) */

		};		/* end for(i) */

	};			/* end if (IDEBUG) */

	if (IDEBUG >= 2) {

		/* ------------------------ */
		/* check if in same segment */
		/* ------------------------ */

		for (i = 0; i < nsets; i = i + 1) {

			istart = start_list[i];
			jvalue = index_list[istart];
			nsize = size_list[i];

			isegment = DIV_OR_SHIFT((jvalue-1),segment_size,
						segment_shift) + 1;
/*			isegment = ((jvalue - 1) / segment_size) + 1; */

                        for (j = 0; j < nsize; j = j + 1) {

			  /* Ed Dec 22,94 update jvalue */
			  jvalue = index_list[istart+(j)];

			  jsegment = DIV_OR_SHIFT((jvalue-1),segment_size,
						  segment_shift) + 1;
			  is_sameseg = (isegment == jsegment);
			  ASSERT(is_sameseg,
				 "encode_list(): mismatch between isegment and jsegment\n", 0);

			};	/* end for(j) */

		};		/* end for(i) */

	};			/* end if (IDEBUG) */


	return (nsets);		/* NOTE: nsets >= 1 */
}
