/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#if !defined(DOUBLELIST_H) 

#define DOUBLELIST_H 1

#include <stdio.h>
#include <malloc.h>
#include <assert.h>


/* external module interface */

typedef struct DLinkCell_t{
        struct DLinkCell_t *flink;
        struct DLinkCell_t *blink;
        void *data;
        } DLinkCell;

typedef struct DLinkCell_t *DLinkCellptr;


struct DoubleList_t {
        DLinkCellptr head;
        DLinkCellptr tail;
        int       ncount;
        }  ;

typedef struct DoubleList_t *DoubleList;


		

DoubleList create_doublelist();
void destroy_doublelist( DoubleList mylist );

void *delete_doublelist( DoubleList mylist, DLinkCellptr iptr );


void inserthead_doublelist( DoubleList mylist, void *data );

void *deletelast_doublelist( DoubleList mylist );

/* returns the data page, user decide whether to deallocate right away */
void movetohead_doublelist( DoubleList mylist, DLinkCellptr  iptr );
void *delete_doublelist( DoubleList mylist, DLinkCellptr iptr );


#if defined(USE_INLINE)

#define next_doublelist( mylist, iptr ) \
	((iptr)->flink)

#define prev_doublelist( mylist, iptr ) \
	((iptr)->blink)

#define data_doublelist(  iptr ) \
	((iptr)->data)

#define  head_doublelist( mylist ) \
	((mylist)->head)

#define  tail_doublelist( mylist ) \
	( (mylist)->tail )

#define size_doubelist( mylist ) \
	( (mylist)->ncount )


#else

/* returns the next and prev entries */
DLinkCellptr next_doublelist( DoubleList mylist, DLinkCellptr iptr );
DLinkCellptr prev_doublelist( DoubleList mylist, DLinkCellptr iptr );

void *data_doublelist(  DLinkCellptr iptr );
DLinkCellptr head_doublelist( DoubleList mylist );
DLinkCellptr tail_doublelist( DoubleList mylist );

int size_doublelist( DoubleList mylist );

#endif






#endif /* defined(DOUBLELIST_H) */
