#if !defined(DOLIB_H)
#define DOLIB_H 1

	/* external interface to DOLIB functions */

#if !defined(dfloat)
#define dfloat double
#endif

#if defined(_NO_PROTO)



extern void do_daxpby();
extern void do_raxpby();
extern void do_iaxpby();



extern void do_bdaxpby();
extern void do_braxpby();
extern void do_biaxpby();



extern int do_bgather();
extern void do_bscatter();

extern void do_gather();
extern void do_scatter();



/* other routines */

extern void do_init();


extern void do_declare();
extern void do_destroy();

/* related to asynchronous mode */

extern void do_wait();
extern int do_isavail();
extern void do_gsync();
extern void do_check();

/* cache related */

extern void do_disable();
extern void do_enable();
extern int do_setchsize();


#else


extern void do_daxpby( int Iaf, int nsize, int *list,  
		dfloat *xvec,  dfloat alpha, dfloat beta );

extern void do_raxpby( int Iaf, int nsize, int *list,  
		float *xvec,  float alpha, float beta );

extern void do_iaxpby( int Iaf, int nsize, int *list,  
		int *xvec,  int alpha, int beta );



extern void do_bdaxpby( int Iaf, int nsize, int idxstart,
		dfloat *xvec, dfloat alpha, dfloat beta );

extern void do_braxpby( int Iaf, int nsize, int idxstart,
		float *xvec, float alpha, float beta );

extern void do_biaxpby( int Iaf, int nsize, int idxstart,
		int *xvec, int alpha, int beta );



extern int do_bgather( int Iaf, int nsize, int idxstart, void *buf );
extern void do_bscatter( int Iaf, int nsize, int idxstart, void *buf );

extern void do_gather( int Iaf, int nsize, int *list,   void *buf );
extern void do_scatter( int Iaf, int nsize, int *list,   void *buf );



/* other routines */

extern void do_init( int myid, int nproc );


extern void do_declare( int *Iaf, char *name, int gsize,
		char *ctype, int pagesize, int blocksize );
extern void do_destroy( int Iaf );

/* related to asynchronous mode */

extern void do_wait( int Iaf );
extern int do_isavail( int reqid );
extern void do_gsync( void );
extern void do_check( void );

/* cache related */

extern void do_disable( int Iaf );
extern void do_enable( int Iaf );
extern int do_setchsize( int npages );


#endif /* if _NO_PROTO */


#endif
