/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include "stdinc.h"

#include "globals.h"
#include "externs.h"


#define MAX_SCATTER (1024*32)

void
do_scatter_C(int Iaf, int nsize, int *list, void *xarray)
{

	INTERRUPT_CHECK();

	if (nsize <= MAX_SCATTER) {
		do_axpby(Iaf, nsize, list, (void *) xarray, 
			 (int) 1, (int) 0,
			 (dfloat) 1, (dfloat) 0);
	} else {
		do_axpby(Iaf, MAX_SCATTER, list, (void *) xarray,  
			 (int) 1, (int) 0,
			 (dfloat) 1, (dfloat) 0);

		/* remaining part */

		if (ISINTEGER(Iaf)) {
			int            *newxarray = (int *) xarray;
			do_axpby(Iaf, nsize - MAX_SCATTER,
				 list + MAX_SCATTER,
				 (void *) (newxarray + MAX_SCATTER),
				 (int) 1, (int) 0,
				 (dfloat) 1, (dfloat) 0);
		} else if (ISREAL8(Iaf)) {
			dfloat         *newxarray = (dfloat *) xarray;
			do_axpby(Iaf, nsize - MAX_SCATTER,
				 list + MAX_SCATTER,
				 (void *) (newxarray + MAX_SCATTER),
				 (int) 1, (int) 0,
				 (dfloat) 1, (dfloat) 0);
		} else if (ISCHAR(Iaf)) {
			char           *newxarray = (char *) xarray;
			do_axpby(Iaf, nsize - MAX_SCATTER,
				 list + MAX_SCATTER,
				 (void *) (newxarray + MAX_SCATTER),
				 (int) 1, (int) 0,
				 (dfloat) 1, (dfloat) 0);
		} else if (ISREAL(Iaf)) {
			float          *newxarray = (float *) xarray;
			do_axpby(Iaf, nsize - MAX_SCATTER,
				 list + MAX_SCATTER,
				 (void *) (newxarray + MAX_SCATTER),
				 (int) 1, (int) 0,
				 (dfloat) 1, (dfloat) 0);
		} else {	/* impossible */
			ASSERT(FALSE, "do_scatter_C(): global array type not valid\n", 0);
		}
	}			/* end if nsize */
}
