/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include <stdio.h>
#include <assert.h>
#include "globals.h"

void
do_print(int Iaf)
{

	extern void     do_disable(int Iaf);

	int             i, ip, lpage_no, lblock_no;
	logical         is_valid, is_integer, is_dfloat, is_char, is_real;
	struct Iarray_node *anp;

	extern int      myid;

	INTERRUPT_CHECK();

	/* verify that the given entry is valid */

	is_valid = ((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY));
	ASSERT(is_valid, "do_print(): Iaf of %d out of range\n", Iaf);

	/* verify that the entry exists */

	anp = Global_array[Iaf];
	is_valid = (anp != NULL);
	ASSERT(is_valid, "do_print(): Iaf of %d indexes null entry\n", Iaf);

	/* disable the cache for this entry, if it exists */

	if (anp->cache_is_on) {
		do_disable(Iaf);
	}
	is_integer = (anp->type == INTEGER);
	is_dfloat = (anp->type == REAL8);
	is_char = (anp->type == CHAR);
	is_real = (anp->type == REAL);

	is_valid = (is_integer || is_dfloat || is_char || is_real);
	ASSERT(is_valid, "do_print(): global array type not valid\n", 0);

	printf("myid %d Iaf %d, name %s\n", myid, Iaf, anp->name);
	printf("myid %d gsize %d, is_integer %d, is_dfloat %d, is_char %d, is_real %d, cache_is_on %d \n",
	       myid, anp->gsize, is_integer, is_dfloat, is_char, is_real, anp->cache_is_on);

	printf("myid %d page_size %d, block_size %d, total_blocks %d nblocks %d \n",
	       myid, anp->page_size, anp->block_size, anp->total_blocks,
	       anp->nblocks);

	ip = 0;
	for (lblock_no = 0; lblock_no < anp->nblocks; lblock_no++) {
		printf("myid %d lblock_no = %d\n", myid, lblock_no);
		for (lpage_no = 0; lpage_no < anp->block_size; lpage_no++) {
			printf("myid %d, lpage_no = %d \n", myid, lpage_no);
			for (i = 0; i < anp->page_size; i++) {
				if (is_integer) {
					printf(" myid %d i  %d ip %d ivalue %d \n",
					  myid, i, ip, anp->iblock_ptr[ip]);
				} else if (is_dfloat) {
					printf("myid %d i %d ip %d dvalue %f \n",
					  myid, i, ip, anp->dblock_ptr[ip]);
				} else if (is_char) {
					printf("myid %d i %d ip %d cvalue %c \n",
					  myid, i, ip, anp->cblock_ptr[ip]);
				} else if (is_real) {
					printf("myid %d i %d ip %d rvalue %f \n",
					  myid, i, ip, anp->rblock_ptr[ip]);
				} else {
					ASSERT(FALSE, "do_print(): global array type not valid\n", 0);
				}
				ip += 1;
			}	/* end for i */
		}		/* end for lpage_no */
	}			/* end for lblock */
}
