/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include <stdio.h>
#include <assert.h>

#include "ipx.h"

#include "globals.h"
#include "wait_block.h"




#if !defined(GET_SUCCESS)
#define GET_SUCCESS 0
#endif

logical
do_isavail(int wait_id)
{
	extern logical  isdone_page(IDTYPE gid);
	extern void     do_cpgather(int wait_id);



	logical         alldone, is_done, is_valid;
	struct wait_node *XX;

	int             i, npages, ndone;


	INTERRUPT_CHECK();


	is_valid = (1 <= wait_id) && (wait_id <= MAX_WAIT_BLOCK);
	ASSERT(is_valid, "do_isavail(): wait_id of %d out of range\n", wait_id);

	XX = Gwait_node_array[wait_id];
	is_valid = (XX != NULL);
	ASSERT(is_valid, "do_isavail(): wait_id of %d indexes null entry\n", wait_id);


	npages = XX->npages;

	/* check to see if all pages are available */

	ndone = 0;
	for (i = 0; i < npages; i++) {


		is_done = (XX->gid_array[i] == GET_SUCCESS) ||
			(isdone_page(XX->gid_array[i]));
		if (is_done) {
			XX->gid_array[i] = GET_SUCCESS;
			ndone += 1;
		};

	};

	alldone = (ndone == npages);
	if (alldone) {
		/* all pages are now available */
		do_cpgather(wait_id);
	};


	return (alldone);
}
