/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include "stdinc.h"
#include "globals.h"
#include "externs.h"


void
do_iaxpby_C(int Iaf, int nsize, int *list, int *xvec,
	    int ialpha, int ibeta)
{

	INTERRUPT_CHECK();

	ASSERT( ISINTEGER( Iaf ), "do_iaxpby_C(): global array %d not of type integer\n", Iaf);

	do_axpby(Iaf, nsize, list, (void *) xvec,
		 (int) ialpha, (int) ibeta,
		 (dfloat) ialpha, (dfloat) ibeta);

}

void
do_iaxpbyz_C(int Iaf, int nsize, int *list, int *xvec,
            int ialpha, int ibeta)
{

        INTERRUPT_CHECK();

        ASSERT( ISINTEGER( Iaf ), "do_iaxpbyz_C(): global array %d not of type integer\n", Iaf);

        do_axpbyz(Iaf, nsize, list, (void *) xvec,
                 (int) ialpha, (int) ibeta,
                 (dfloat) ialpha, (dfloat) ibeta);

}

