/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include "stdinc.h"
#include "message.h"

#include "ipx.h"

#if !defined(INTERRUPT_CHECK)
#define INTERRUPT_CHECK() mark()
#endif

/*
 * DO_GSYNC -- synchronize
 */

#if !defined(MT_sync)
#define MT_sync 4
#endif


#if !defined(PARENT)
#define PARENT( ix ) ( (ix)/(NCHILDREN) )
#endif







#if !defined(NCHILDREN)
#define NCHILDREN 2
#endif

void
do_gsync()
{
	int             i, ncount;
	int             iparent, ichild;
	logical         parentok, spaceok, isvalid, ischild;

	static int      nchild;
	static int      child_list[NCHILDREN + 1];
	static logical  isfirst = TRUE;
	static int      nproc, myid, host;


	/* everyone do a finish(0) for extra safety */
	finish(0);

	if (isfirst) {
		isfirst = FALSE;

		/* find out who are my children */
		WHO0(&nproc, &myid, &host);

		nchild = 0;
		for (ichild = 0; ichild < nproc; ichild++) {

			ischild = (PARENT(ichild) == myid) && (ichild != myid);
			if (ischild) {
				spaceok = (0 <= nchild) && (nchild < NCHILDREN);
				ASSERT(spaceok, "do_gsync(): nchild of %d out of range\n", nchild);

				child_list[nchild] = ichild;
				nchild += 1;

			};
		};		/* end for (ichild) */

	};			/* end if (isfirst) */



	/* wait for message from children */

	ncount = 0;
	for (;;) {
		INTERRUPT_CHECK();

		if (ncount == nchild) {
			break;
		};

		if (PROBE0(MT_sync)) {
			RECV0((char *) (&ichild),
			      (int) (sizeof(ichild)), (int) (MT_sync));
			isvalid = (0 <= ichild) && (ichild < nproc);
			ASSERT(isvalid && (PARENT(ichild) == myid) &&
			       (ichild != myid), "do_gsync(): received synchronization message invalid\n", 0);
			ncount += 1;
		};
	};			/* end loop */


	iparent = PARENT(myid);
	isvalid = ((0 <= iparent) && (iparent < nproc));
	parentok = isvalid && (iparent != myid);

	if (parentok) {

		/* forward token to parent */

		SEND0((char *) (&myid),
		    (int) (sizeof(myid)), (int) (MT_sync), (int) (iparent));

		/* then wait for reply from parent */

		for (;;) {
			INTERRUPT_CHECK();

			if (PROBE0(MT_sync)) {
				RECV0((char *) (&iparent),
				      sizeof(iparent), MT_sync);
				isvalid = (0 <= iparent) && (iparent < nproc);
				ASSERT(isvalid && (iparent == PARENT(myid)) &&
				       (iparent != myid), "do_gsync(): received synchronization message invalid\n", 0);

				break;
			};
		};		/* end loop */
	};			/* end if */


	/* send out reply to children */

	for (i = 0; i < nchild; i++) {
		ichild = child_list[i];
		isvalid = (0 <= ichild) && (ichild < nproc);
		ASSERT(isvalid && (PARENT(ichild) == myid) &&
		       (ichild != myid), "do_gsync(): synchronization message to be sent is not valid\n", 0);
		SEND0((char *) (&myid), (int) (sizeof(myid)),
		      (int) (MT_sync), (int) (ichild));
	};

}
