/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include <stdio.h>
#include <assert.h>
#include "globals.h"

#if INTEL || NX || I860 || PGON || PARAGON || RX

#if !defined(GSYNC)
#define GSYNC gsync
#endif

#endif

/*
 * DO_DESTROY -- destroy the distributed object Iaf.  Remove all trace from
 * the cache, and from the Global array.
 */

void
do_destroy(int Iaf)
{
	extern void     do_disable(int Iaf);

	logical         is_valid;
	struct Iarray_node *anp;

	extern int      myid;

	/* verify that the given entry is valid */

	INTERRUPT_CHECK();


	is_valid = ((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY));
	ASSERT(is_valid, "do_destroy(): Iaf of %d out of bounds\n", Iaf);

	/* verify that the entry exists */

	anp = Global_array[Iaf];
	is_valid = (anp != NULL);
	ASSERT(is_valid, "do_destroy(): Iaf of %d indexes NULL entry\n", Iaf);

	/* disable the cache for this entry, if it exists */

	if (anp->cache_is_on) {
		do_disable(Iaf);
	}
	GSYNC();
	finish(0);		/* wait for all to complete */

	GSYNC();		/* need a gsync so every processor agrees to
				 * free memory */

	/* now free up all the memory */

	/* free( anp->name );  */
	/* free( anp->local_data_start[myid] );  */
	/* free( anp->local_data_start );  */
	/* free( Global_array[Iaf] );  */

	MEMFREE(anp->name);
	MEMFREE(anp->local_data_start[myid]);
	MEMFREE(anp->local_data_start);
	MEMFREE(Global_array[Iaf]);

	Global_array[Iaf] = NULL;
}
