/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include <stdio.h>
#include <assert.h>

#include "ipx.h"

#include "globals.h"
#include "wait_block.h"

#define SET_PAGE( cur_page_no, page_ptr, ivalue ) \
  \
                      page_lo = cur_page_no*page_size + 1;  \
                      page_hi = page_lo + page_size - 1;  \
		      page_ptr = (void *) pageptr_array[  ivalue ];  \
  \
		      if (is_dfloat) { dptr = (dfloat *) page_ptr; }   \
		      else if (is_integer) { iptr = (int *) page_ptr; }  \
		      else if (is_char) { cptr = (char *) page_ptr; }  \
                      else if (is_real) { rptr = (float *) page_ptr; } \
		      else { ASSERT(FALSE, "SET_PAGE: global array type not valid\n", 0); };  \


#define BINARY_FIND_PAGE( cur_page_no, page_ptr ) {  \
			logical toobig,isfound;   \
			int ilo,ihi,imid, ivalue;  \
  \
  \
                        /* search in pageno_array[*] */  \
  \
                        isfound = FALSE; ivalue  = -1; \
			ilo = 0; ihi = npages-1;  \
                        while (ihi >= ilo ) {  \
                                imid = (ihi + ilo)/2;  \
                                isfound = (pageno_array[imid] == cur_page_no); \
                                if (isfound) { ivalue = imid; break ; };  \
  \
                                toobig = (pageno_array[imid] > cur_page_no);  \
                                if (toobig) { ihi = imid - 1; }  \
                                else { ilo  = imid + 1; };  \
                                };  \
  \
                        ASSERT(isfound && (pageno_array[ivalue] == cur_page_no), "BINARY_FIND_PAGE: page not found\n", 0);  \
			SET_PAGE( cur_page_no, page_ptr, ivalue ); \
			}
#define LINEAR_FIND_PAGE( cur_page_no, page_ptr ) { \
		logical is_valid, isfound;   \
		int ivalue, i;  \
  \
		/* use linear search */ \
		isfound = FALSE; ivalue = -1;  \
		for( i=0; i < npages; i++ ) {  \
		    isfound = (pageno_array[i] == cur_page_no);  \
		    if (isfound) { ivalue = i; break; };  \
		    };  \
  \
		is_valid = (0 <= ivalue) && (ivalue < npages);  \
		ASSERT(isfound  && is_valid &&   \
			(pageno_array[ivalue] == cur_page_no), "LINEAR_FIND_PAGE: page not found\n", 0);  \
		SET_PAGE( cur_page_no, page_ptr, ivalue );  \
		}

#define DEFAULT_BINARY_SEARCH_PAGES (7)

#define FIND_PAGE( cur_page_no, page_ptr) { \
	if (npages > DEFAULT_BINARY_SEARCH_PAGES) { \
		BINARY_FIND_PAGE( cur_page_no, page_ptr ); \
		} \
	else { \
		LINEAR_FIND_PAGE( cur_page_no, page_ptr ); \
		} \
	}

#if !defined(GET_SUCCESS)
#define GET_SUCCESS 0
#endif

void
do_cpgather(int wait_id)
{
#include "get_page.h"

	logical         is_valid, is_integer, is_dfloat, is_char, is_real;
	logical         is_processed;
	int            *ibuf;
	dfloat         *dbuf;
	char           *cbuf;
	float          *rbuf;

	void           *page_ptr;
	dfloat         *dptr;
	int            *iptr;
	char           *cptr;
	float          *rptr;

	int             nbytes;
	char           *csrc;
	char           *cdest;

	extern logical  isdone_page(IDTYPE gid);

	int             i, ihi, gni, gni_end, buf_ptr, istart, offset, isize,
	                cur_page_no, page_lo, page_hi;

	logical         is_samepage;

	DECLARE_ALL_WAIT_NODE()
		DECLARE_ALL_IARRAY_NODE()
	/* check parameter */

		INTERRUPT_CHECK();

	is_valid = ((1 <= wait_id) && (wait_id <= MAX_WAIT_BLOCK));
	ASSERT(is_valid, "do_cpgather(): wait_id of %d out of range\n", wait_id);

	is_valid = (Gwait_node_array[wait_id] != NULL);
	ASSERT(is_valid, "do_cpgather(): wait_id of %d indexes NULL entry\n", wait_id);

	ASSIGN_ALL_WAIT_NODE(wait_id);
	ASSIGN_ALL_IARRAY_NODE(Iaf);

	is_valid = ((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY));
	ASSERT(is_valid, "do_cpgather(): Iaf of %d out of range\n", Iaf);

	is_integer = (type == INTEGER);
	is_dfloat = (type == REAL8);
	is_char = (type == CHAR);
	is_real = (type == REAL);

	is_valid = (is_integer || is_dfloat || is_char || is_real);
	ASSERT(is_valid, "do_cpgather(): global array type not valid\n", 0);

	ASSERT(local_data_start != NULL, "do_cpgather(): local_data_start is NULL\n", 0);

	ibuf = NULL;
	dbuf = NULL;
	cbuf = NULL;
	rbuf = NULL;

	if (is_char) {
		cbuf = (char *) buf;
	} else if (is_integer) {
		ibuf = (int *) buf;
	} else if (is_dfloat) {
		dbuf = (dfloat *) buf;
	} else if (is_real) {
		rbuf = (float *) buf;
	} else {
		ASSERT(FALSE, "do_cpgather(): global array type not valid\n", 0);
	}

	/* all pages are now available */
	/* (1) perform all copies */
	/* (2) return pages to cache */
	/* (3) deallocate all storage used in wait_node */

	page_lo = -1;
	page_hi = -1;
	buf_ptr = 0;

	if (use_compress) {
		ihi = nsets;
	} else {
		ihi = nsize;
		isize = 1;
	}

	for (i = 0; i < ihi; i++) {

		/* double check parameters */
		if (use_compress) {

			istart = start_list[i];
			isize = size_list[i];

			gni = gindex[i];

			gni_end = gni + isize - 1;
			is_valid = ((1 <= gni_end) && (gni_end <= gsize));
			ASSERT(is_valid, "do_cpgather(): gni_end of %d out of range\n", gni_end);
		} else {
			gni = list[i];
		}

		is_valid = ((1 <= gni) && (gni <= gsize));
		ASSERT(is_valid, "do_cpgather(): gni of %d out of range\n", gni);

		is_samepage = ((page_lo <= gni) && (gni <= page_hi));
		if (!is_samepage) {
			cur_page_no = (gni - 1) / page_size;
			FIND_PAGE(cur_page_no, page_ptr);
		}
		is_processed = (page_ptr == NULL);
		if (!is_processed) {
			offset = (gni - page_lo);
#if defined(DEBUG)
			ASSERT(offset == MOD(gni - 1, page_size), "do_cpgather(): mismatch between offset and gni mod pagesize\n", 0);
			ASSERT((0 <= offset) && (offset < page_size), "do_cpgather(): offset of %d out of range\n", offset);
#endif

			/* page_ptr  is now set to correct value */

			if (is_dfloat) {
				csrc = (char *) (&(dptr[offset]));
				cdest = (char *) (&(dbuf[buf_ptr]));

				nbytes = isize * sizeof(dfloat);
			} else if (is_char) {
				csrc = (char *) (&(cptr[offset]));
				cdest = (char *) (&(cbuf[buf_ptr]));

				nbytes = isize * sizeof(char);
			} else if (is_integer) {
				csrc = (char *) (&(iptr[offset]));
				cdest = (char *) (&(ibuf[buf_ptr]));

				nbytes = isize * sizeof(int);
			} else if (is_real) {
				csrc = (char *) (&(rptr[offset]));
				cdest = (char *) (&(rbuf[buf_ptr]));

				nbytes = isize * sizeof(float);
			} else {
				ASSERT(FALSE, "do_cpgather(): global array type not valid\n", 0);
			}

			if (csrc != cdest) {
				/* avoid unnecessary copies */

				BCOPY(csrc, cdest, nbytes);
			};
		}		/* if (!is_processed) */
		buf_ptr += isize;
	}			/* end for */

	/* call return_page for each page */

	for (i = 0; i < npages; i++) {
		is_processed = (pageptr_array[i] == NULL);
		if (!is_processed) {
			return_page(Iaf, pageno_array[i],
				    pageptr_array[i], userbuf_array[i]);
			pageptr_array[i] = NULL;
		}
	}

	/* deallocate all storage */

	DEALLOCATE_ALL_WAIT_NODE(wait_id);
}
