/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include "stdinc.h"
#include "cache.h"


#if !defined(DEFAULT_CACHE_SIZE)
#define DEFAULT_CACHE_SIZE 128
#endif
	
		
#define CHECK_FIRST()   \
	{   \
	   if (isfirst) {  \
		isfirst = FALSE;  \
		mycache = create_cache( DEFAULT_CACHE_SIZE );  \
		};  \
	};


static int isfirst = TRUE;
static Cache mycache;


/*
 * CH_SET_SIZE -- sets max number of cache pages allowed
 */
int
ch_set_size(int newsize)
{

	CHECK_FIRST();

	/*
	 * should a value of 0 just disable the cache, rather than cause an
	 * error? -- chuck
	 */
	ASSERT(newsize >= 0, "ch_set_size(): newsize of %d not valid\n",
	       newsize);


	return ( setsize_cache(mycache, newsize)  );
}

int do_setchsize( int npages )
{
	return( ch_set_size( npages ) );
}

/*
 * GET_CACHE_PAGE -- return pointer to page, return NULL if page is not in
 * cache.
 */

void           *
ch_get_page(int Iaf, int page_no)
{

	logical is_valid;


	CHECK_FIRST();




	/* check to see if Iaf is valid */

	is_valid = (1 <= Iaf);
	ASSERT(is_valid, "ch_get_page(): Iaf of %d invalid\n", Iaf);

	is_valid = (0 <= page_no);
	ASSERT(is_valid, "ch_get_page(): page_no of %d invalid\n", page_no);

	/* check to see whether page is in cache */


	return( find_cache( mycache, Iaf, page_no ) );
}

/*
 * CH_STORE_PAGE -- store given page in cache at front, deleting from end if
 * necessary.
 */

void
ch_store_page(int Iaf, int page_no, void *page_ptr)
{
	logical         is_empty;
	logical         is_valid;
	logical         is_head;
	logical         isfound;


	CHECK_FIRST();


	/* check that Iaf is valid */

	is_valid = (1 <= Iaf);
	ASSERT(is_valid, "ch_store_page(): Iaf of %d out of range\n", Iaf);

	is_valid = (0 <= page_no);
	ASSERT(is_valid, "ch_store_page(): page_no of %d out of range\n",
	       page_no);

	ASSERT(page_ptr != NULL, "ch_store_page(): page_ptr is NULL\n", 0);

	/*
	 * check to make certain that this page is not already in the cache?
	 * -- chuck
	 */


	isfound = (NULL != find_cache( mycache, Iaf, page_no ));
	if (!isfound) {
		insert_cache( mycache, Iaf, page_no, page_ptr );
		};

	
}

/*
 * CH_DISABLE -- remove cache pages corresponding to object Iaf, and suppress
 * future cacheing for this object.
 */

void
ch_disable(int Iaf)
{
	logical         delete_this, delete_all;
	logical         is_empty;
	int             oldsize;


	CHECK_FIRST();

	delete_all = (Iaf <= 0);

	if (delete_all) {
		oldsize = ch_set_size(0);
		oldsize = ch_set_size( oldsize );
		return;
		};


	purge_cache( mycache, Iaf );

	return;
}


