/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include <assert.h>
#include <stdio.h>

#include "stdinc.h"
#include "globals.h"
#include "externs.h"

#define MAX_BSCATTER_SIZE (1024*32)
#define DEFAULT_MAXSETS (2*1024)

void
do_bscatter_C(int Iaf, int nsize, int index_start, void *buf)
{

  int            ialpha, ibeta;
  dfloat         dalpha, dbeta;
  int		*ibuf;
  dfloat	*dbuf;
  char		*cbuf;
  float		*rbuf;
  int		isize, cursize, curstart;

  INTERRUPT_CHECK();

  ialpha = (int) 1;
  ibeta = (int) 0;
  dalpha = (dfloat) 1;
  dbeta = (dfloat) 0;

  curstart = index_start;
  cursize = nsize;

  if (ISINTEGER(Iaf)) {
    ibuf = (int *) buf;
    while (cursize > 0) {
      isize = min(MAX_BSCATTER_SIZE, cursize);
      do_baxpby(Iaf, isize, curstart, (void *)ibuf,
		ialpha, ibeta, dalpha, dbeta);
      curstart += isize;
      cursize -= isize;
      ibuf += isize;
    }
  } else if (ISREAL8(Iaf)) {
    dbuf = (dfloat *)buf;
    while (cursize > 0) {
      isize = min(MAX_BSCATTER_SIZE, cursize);
      do_baxpby(Iaf, isize, curstart, (void *)dbuf,
		ialpha, ibeta, dalpha, dbeta);
      curstart += isize;
      cursize -= isize;
      dbuf += isize;
    }
  } else if (ISCHAR(Iaf)) {
    cbuf = (char *)buf;
    while (cursize > 0) {
      isize = min(MAX_BSCATTER_SIZE, cursize);
      do_baxpby(Iaf, isize, curstart, (void *)cbuf,
		ialpha, ibeta, dalpha, dbeta);
      curstart += isize;
      cursize -= isize;
      cbuf += isize;
    }
  } else if (ISREAL(Iaf)) {
    rbuf = (float *)buf;
    while (cursize > 0) {
      isize = min(MAX_BSCATTER_SIZE, cursize);
      do_baxpby(Iaf, isize, curstart, (void *)rbuf,
		ialpha, ibeta, dalpha, dbeta);
      curstart += isize;
      cursize -= isize;
      rbuf += isize;
    }
  } else ASSERT(FALSE, "do_bscatter_C(): global array type not valid\n", 0);
}
