/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#include <assert.h>
#include <stdio.h>

#include "stdinc.h"
#include "globals.h"

#define MAX_BLOCK_SIZE (1024*1024)
#define DEFAULT_MAXSETS (2*1024)



void
do_baxpbyz_C(int Iaf, int nsize, int index_start, void *buf,
	  int ialpha, int ibeta,
	  dfloat dalpha, dfloat dbeta,
	  logical returnz)
{

	logical         is_valid, use_compress, room_to_grow;
	logical         is_integer, is_dfloat, is_char, is_real;
	int             nbytes, nsets, maxsets, segment_size, page_size,
	                total_pages, gsize, index_end;
	int            *start_list;
	int            *size_list;

	struct Iarray_node *anp;
	int            *ibuf;
	dfloat         *dbuf;
	char           *cbuf;
	float          *rbuf;



	extern int      bencode_list(int nitems, int index_start, int segment_size,
	                      int maxsets, int *start_list, int *size_list);


	void
	                do_bset_axpby(int Iaf, int nsize, void *xvalues, int *list,
				                      int nsets, int index_start, int *start_list, int *size_list,
	                int ialpha, int ibeta, dfloat dalpha, dfloat dbeta,
			logical returnz);



	int            *list;
	void           *xvalues;

	INTERRUPT_CHECK();

	/* verify that Iaf is valid */

	is_valid = ((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY));
	ASSERT(is_valid, "do_baxpbyz_C(): Iaf of %d out of range\n", Iaf);

	/* verify that LIST is within bounds for Iaf */

	anp = Global_array[Iaf];
	ASSERT(anp != NULL, "do_baxpbyz_C(): Iaf of %d indexes NULL entry\n", Iaf);

	gsize = anp->gsize;
	page_size = anp->page_size;
	total_pages = anp->total_pages;


	is_integer = (anp->type == INTEGER);
	is_dfloat = (anp->type == REAL8);
	is_char = (anp->type == CHAR);
	is_real = (anp->type == REAL);

	is_valid = (is_integer || is_dfloat || is_char || is_real);
	ASSERT(is_valid, "do_baxpbyz_C(): global array type not valid\n", 0);

	ibuf = NULL;
	cbuf = NULL;
	dbuf = NULL;
	rbuf = NULL;

	if (is_char) {
		cbuf = (char *) buf;
		nbytes = page_size * sizeof(char);
	} else if (is_dfloat) {
		dbuf = (dfloat *) buf;
		nbytes = page_size * sizeof(dfloat);
	} else if (is_integer) {
		ibuf = (int *) buf;
		nbytes = page_size * sizeof(int);
	} else if (is_real) {
		rbuf = (float *) buf;
		nbytes = page_size * sizeof(float);
	} else {
		ASSERT(FALSE, "do_baxpbyz_C(): global array type not valid\n", 0);
	}

	if (nsize <= 0) {
		return;
	};

	if (nsize > MAX_BLOCK_SIZE) {
		do_baxpbyz_C(Iaf, MAX_BLOCK_SIZE, index_start, (void *) buf,
			  ialpha, ibeta, dalpha, dbeta, returnz);
		if (is_char) {
			do_baxpbyz_C(Iaf, nsize - MAX_BLOCK_SIZE,
				  index_start + MAX_BLOCK_SIZE - 1,
				  (void *) &(cbuf[MAX_BLOCK_SIZE]),
				  ialpha, ibeta, dalpha, dbeta, returnz);
		} else if (is_dfloat) {
			do_baxpbyz_C(Iaf, nsize - MAX_BLOCK_SIZE,
				  index_start + MAX_BLOCK_SIZE - 1,
				  (void *) &(dbuf[MAX_BLOCK_SIZE]),
				  ialpha, ibeta, dalpha, dbeta, returnz);
		} else if (is_integer) {
			do_baxpbyz_C(Iaf, nsize - MAX_BLOCK_SIZE,
				  index_start + MAX_BLOCK_SIZE - 1,
				  (void *) &(ibuf[MAX_BLOCK_SIZE]),
				  ialpha, ibeta, dalpha, dbeta, returnz);
		} else if (is_real) {
			do_baxpbyz_C(Iaf, nsize - MAX_BLOCK_SIZE,
				  index_start + MAX_BLOCK_SIZE - 1,
				  (void *) &(rbuf[MAX_BLOCK_SIZE]),
				  ialpha, ibeta, dalpha, dbeta, returnz);
		} else {
			ASSERT(FALSE, "do_baxpbyz_C(): global array type not valid\n", 0 );
		}

		return;
	}
	/* check parameters */
	is_valid = ((1 <= index_start) && (index_start <= gsize));
	ASSERT(is_valid, "do_baxpbyz_C(): index_start of %d out of range\n", index_start);

	index_end = index_start + nsize - 1;
	is_valid = ((1 <= index_end) && (index_end <= gsize));
	ASSERT(is_valid, "do_baxpbyz_C(): index_end of %d out of range\n", index_end);

	/* force  use of compression */
	maxsets = min(nsize, DEFAULT_MAXSETS);
	for (;;) {

		MEMALLOC(start_list, (int *), maxsets * sizeof(int));
		ASSERT(start_list != NULL, "do_baxpbyz_C(): Unable to allocate memory for start_list\n", 0);

		MEMALLOC(size_list, (int *), maxsets * sizeof(int));
		ASSERT(size_list != NULL, "do_baxpbyz_C(): Unable to allocate memory for size_list\n", 0);

		/*
		 * since we are getting one-page at a time, segment_size MUST
		 * be page_size, NOT page_size*block_size
		 */

		segment_size = page_size;
		nsets = bencode_list(nsize, index_start, segment_size,
				     maxsets, start_list, size_list);

		is_valid = ((1 <= nsets) && (nsets <= maxsets));
		if (is_valid) {
			break;
		}
		room_to_grow = (maxsets < nsize);
		if (!room_to_grow) {
			break;
		}
		/* increase maxsets size */
		MEMFREE(start_list);
		MEMFREE(size_list);

		maxsets = min(nsize + 1, maxsets * 2);
	}

	use_compress = ((1 <= nsets) && (nsets <= maxsets));
	ASSERT(use_compress, "do_baxpbyz_C(): Error -- use_compress not set\n", 0);

	/* most of the work done in do_bset_axpby() */

	do_bset_axpby(Iaf, nsize, xvalues = buf, list = (int *) NULL,
		      nsets, index_start, start_list, size_list,
		      (int) ialpha, (int) ibeta,
		      (dfloat) dalpha, (dfloat) dbeta, (logical) returnz);


	MEMFREE(start_list);
	MEMFREE(size_list);
}

void
do_baxpbyz(int Iaf, int nsize, int index_start, void *buf,
          int ialpha, int ibeta,
          dfloat dalpha, dfloat dbeta)
{
logical returnz;

do_baxpbyz_C(Iaf, nsize, index_start, buf,
          ialpha, ibeta,
          dalpha, dbeta, returnz = TRUE);
}


void
do_baxpby(int Iaf, int nsize, int index_start, void *buf,
          int ialpha, int ibeta,
          dfloat dalpha, dfloat dbeta)
{
logical returnz;

do_baxpbyz_C(Iaf, nsize, index_start, buf,
          ialpha, ibeta,
          dalpha, dbeta, returnz = FALSE);
}

