/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/


#include <stdio.h>
#include <assert.h>
#include "globals.h"



/*
 * DO_AGATHER -- get pages corresponding to indices in LIST of object Iaf;
 * put corresponding entries in BUF
 */



#if !defined(DEFAULT_MAX_SETS)
#define DEFAULT_MAX_SETS (8*1024)
#endif

#if !defined(DEFAULT_COMPRESS_SIZE)
#define DEFAULT_COMPRESS_SIZE 64
#endif

extern int 
encode_list(int nitems, int *index_list, int segment_size,
	    int maxsets, int *start_list, int *size_list);

#include "externs.h"

int
do_agather(int Iaf, int nsize, int *list, void *buf)
{




	int             start_list[DEFAULT_MAX_SETS + 1];
	int             size_list[DEFAULT_MAX_SETS + 1];
	int             gindex[DEFAULT_MAX_SETS + 1];

	int             nsets, maxsets, i, gni, istart;
	logical         is_valid, use_compress, is_org_sorted;

	int             wait_id;
	int             segment_size, page_size;

	struct Iarray_node *anp;


	INTERRUPT_CHECK();

	is_valid = ((1 <= Iaf) && (Iaf <= MAX_GLOBAL_ARRAY));
	ASSERT(is_valid, "do_agather(): Iaf of %d out of range\n", Iaf);
	anp = Global_array[Iaf];
	ASSERT(anp != NULL, "do_agather(): Iaf of %d indexes a NULL entry\n", Iaf);
	page_size = anp->page_size;



	/* attempt compression */

	maxsets = DEFAULT_MAX_SETS;
	/*
	 * since we are getting one-page at a time, segment_size MUST be
	 * page_size, NOT page_size*block_size
	 */

	if (nsize > DEFAULT_COMPRESS_SIZE) {
		segment_size = page_size;
		nsets = encode_list(nsize, list, segment_size,
				    maxsets, start_list, size_list);
		use_compress = (nsets >= 1);
	} else {
		/* too few entries in request */
		/* avoid overhead of 'encode_list' */
		use_compress = FALSE;
	};


	if (use_compress) {
		ASSERT((1 <= nsets) && (nsets <= maxsets), "do_agather(): nsets of %d out of range\n", nsets);
		for (i = 0; i < nsets; i++) {
			istart = start_list[i];
			is_valid = ((0 <= istart) && (istart < nsize));
			ASSERT(is_valid, "do_agather(): istart of %d out of range\n", istart);

			gni = list[istart];
			ASSERT(gni >= 1, "do_agather(): gni of %d not valid\n",
			       gni);

			gindex[i] = gni;
		};
	};


	/* most of the work done in do_setgather */

	wait_id = do_setgather(Iaf, nsize, &(list[0]),
		     nsets, &(gindex[0]), &(start_list[0]), &(size_list[0]),
			       is_org_sorted = FALSE, use_compress, buf);

	return (wait_id);
}
