#include <stdio.h>
#include <assert.h>
#include <fcntl.h>

#if PGON || PARAGON
#include <nx.h>
#else
#include <cube.h>
#endif

#include <unistd.h>

#define dfloat double


#define WRITE cwrite

main() 
{
	int myid, nproc;
	double tstart, tend;
#if defined(USE_STATIC)

#define N_INTEGERS 1024
#define N_DFLOATS 1

	static int ibuf[N_INTEGERS];
	static dfloat dbuf[N_DFLOATS];
#else

#if PGON || PARAGON

#define N_INTEGERS 512*1024
#define N_DFLOATS  256*1024

#else

#define N_INTEGERS (16*1024+11)
#define N_DFLOATS  (8*1024+13)

#endif

	int *ibuf;
	dfloat *dbuf;
#endif
	
	int ierr;
	int do_fd;
	int i;

#if PGON || PARAGON
	char *file_name = "/pfs/chuck2.bin";
#else
	char *file_name = "/cfs/chuck2.bin";
#endif

	int flag = O_WRONLY | O_CREAT;
	int mode = 0777 ;
	int fd;

	int nibytes;
	int ndbytes;
	int totalbytes;

#if !defined(USE_STATIC)
	ibuf = (int *) malloc( sizeof(int)* N_INTEGERS );
	assert( ibuf != NULL );

	dbuf = (dfloat *) malloc( sizeof(dfloat)* N_DFLOATS );
	assert( dbuf != NULL );
#endif

	myid = mynode(); nproc = numnodes();

	do_init( myid, nproc );

	do_setchsize( 32 );

	for(i=0; i < N_INTEGERS; i++ ) { ibuf[i] = i+1; };
	for(i=0; i < N_DFLOATS; i++ ) { dbuf[i] = (dfloat) i+1; };


		/* create a new file of integer and doubles */

	if (myid == 0) {
		unlink( file_name ); /* just make sure */
		};
    do_gsync();

	flag = (O_WRONLY | O_CREAT);
	fd =  (int ) do_open( file_name, flag, mode );
	assert( fd >= 0);
		do_gsync();

		nibytes = sizeof(int)*N_INTEGERS;
		ndbytes =  sizeof(dfloat)*N_DFLOATS;
		totalbytes = nibytes + ndbytes;


		/* try 2 Meg per processor */
		do_lsize( fd, totalbytes  );



	    if (myid == 0) {
			ierr = do_lseek( fd, 0, SEEK_SET );
			ierr = do_write( fd, (char *) ibuf, (unsigned int) nibytes );
			assert( ierr == nibytes );
			};


		if (myid == 1) {
			ierr = do_lseek( fd, nibytes, SEEK_SET );
			ierr = do_write( fd, (char *) dbuf, (unsigned int) ndbytes );
			assert( ierr = ndbytes );
			};

    do_gsync();
    tstart = dclock();
    do_close( fd );
    tend = dclock();
    if (myid == 0) {
	 printf(" do_close takes %lf \n", tend - tstart );
	 };

	for( i=0; i < N_INTEGERS; i++ ) { ibuf[i] = -999; };
	for( i=0; i < N_DFLOATS; i++ ) { dbuf[i] = (dfloat) -1234; };



	do_gsync();
	tstart = dclock();
	do_fd = do_open( file_name, O_RDONLY, mode );
	tend = dclock();
	do_gsync();
	if (myid == 0) {
		printf(" do_open takes %lf \n", tend - tstart );
		};

	do_gsync();
	tstart = dclock();

	ierr = do_lseek( do_fd, N_INTEGERS*sizeof(int), SEEK_SET);
	ierr = do_read( do_fd, dbuf, N_DFLOATS*sizeof(dfloat) );

	ierr = do_lseek(do_fd, 0, SEEK_SET );
	ierr = do_read( do_fd, ibuf, N_INTEGERS*sizeof(int) );


	do_close(do_fd);

	do_gsync();
	tend = dclock();
	if (myid == 0) {
		printf ("Processor %d network i/o time: %lf\n", myid, tend-tstart);
		};
	
	for( i=0; i < N_INTEGERS; i+=1 ) {
	  if (ibuf[i] != (i+1)  )
	    printf ("ERROR %d: ibuf[%d] = %d\n", myid, i, ibuf[i]);
	};

	for( i=0; i < N_DFLOATS; i+=1 ) {
	  if (dbuf[i] != ((dfloat) i+1) )
	    printf ("ERROR %d: dbuf[%d] = %d\n", myid, i, dbuf[i]);
	};


	exit(1); /* stop for debugging */




}
