/***********************************************************************
* DOLIB/DONIO Version 0.0 (8/24/94)                                    *       *
*  Software to emulate shared memory on distributed memory environments*
* written by:                                                          *
*  Ed D'Azevedo and Charles Romine of Oak Ridge National Laboratory    *
*                                                                      *
* Questions and comments should be directed to                         *
*      efdazedo@msr.epm.ornl.gov or romine@msr.epm.ornl.gov            *
*                                                                      *
*  Please notify and acknowledge the authors in any research or        *
*  publications utilizing DOLIB/DONIO or any part of the code.         *
*                                                                      *
* NOTICE: Neither the institution nor the author make any              *
*  representations about the suitability of this software for any      *
*  purpose. This software is provided "as is", without express or      *
*  implied warranty.                                                   *
************************************************************************/

#if !defined(CACHE_H) 
#define CACHE_H 1

#include "htable.h"

#include "doublelist.h"

struct Cache_t {
        int nsize;
        int maxsize;
        Htable htable;
        };
typedef struct Cache_t *Cache;



Cache create_cache( int maxsize );

int setsize_cache( Cache mycache, int newsize );

void *delete_cache( Cache mycache, int Iaf, int pageno );

void purge_cache( Cache mycache, int Iaf );


void insert_cache( Cache mycahe, int Iaf, int pageno, void *pdata );


void *find_cache( Cache mycache, int Iaf, int pageno );


#endif /* defined(CACHE_H) */

